/*
 * Decompiled with CFR 0.152.
 */
package tot.search;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import tot.bean.DataField;
import tot.global.Sysconfig;
import tot.search.SearchService;

public class SearchQuery {
    private static Log log = LogFactory.getLog(SearchQuery.class);
    public static final int SEARCH_ANY_DATE = 0;
    public static final int SEARCH_NEWER = 1;
    public static final int SEARCH_OLDER = 2;
    public static final int SEARCH_ONLY_TITLE = 1;
    public static final int SEARCH_ONLY_BODY = 2;
    public static final int SEARCH_SORT_DEFAULT = 0;
    public static final int SEARCH_SORT_TIME_DESC = 1;
    public static final int SEARCH_SORT_TIME_ASC = 2;
    private String userName = null;
    private int catalogid = -1;
    private int b2b = -1;
    private String table = null;
    private int province = -1;
    private int city = -1;
    private String searchString = null;
    private Timestamp fromDate = null;
    private Timestamp toDate = null;
    private String searchIndexDir = Sysconfig.getIndexDir();
    private int hitCount = 0;
    private Collection searchResult = null;
    private int scopeInArticle = 3;
    private int sort = 0;
    private int search_and_or;

    public void setUserName(String membername) {
        this.userName = membername;
    }

    public void setCatalogId(int catalogid) {
        this.catalogid = catalogid;
    }

    public void setB2b(int b2b) {
        this.b2b = b2b;
    }

    public void setProvince(int v) {
        this.province = v;
    }

    public void setCity(int v) {
        this.city = v;
    }

    public void setTable(String t) {
        this.table = t;
    }

    public void setSearchAndOr(int sao) {
        this.search_and_or = sao;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public void setScopeInArticle(int scopeInArticle) {
        this.scopeInArticle = scopeInArticle;
    }

    public void setFromDate(Timestamp fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Timestamp toDate) {
        this.toDate = toDate;
    }

    public void setSortType(int stype) {
        this.sort = stype;
    }

    public void searchDocuments(int offset, int rowsToReturn) throws IOException {
        if (this.searchString == null || this.searchString.equals("")) {
            return;
        }
        BooleanQuery query = new BooleanQuery();
        try {
            Query memberQuery;
            Query tableQuery;
            Query cityQuery;
            Query provinceQuery;
            Query b2bQuery;
            Query catalogQuery;
            Query topicBodyQuery = this.getTopicBodyQuery();
            if (topicBodyQuery != null) {
                query.add(topicBodyQuery, BooleanClause.Occur.MUST);
                log.debug((Object)("topicBodyQuery = " + topicBodyQuery));
            }
            if ((catalogQuery = this.getCatalogQuery()) != null) {
                log.debug((Object)("categoryForumQuery = " + catalogQuery));
                query.add(catalogQuery, BooleanClause.Occur.MUST);
            }
            if ((b2bQuery = this.getB2bQuery()) != null) {
                log.debug((Object)("b2bQuery = " + b2bQuery));
                query.add(b2bQuery, BooleanClause.Occur.MUST);
            }
            if ((provinceQuery = this.getProvinceQuery()) != null) {
                log.debug((Object)("provinceQuery = " + provinceQuery));
                query.add(provinceQuery, BooleanClause.Occur.MUST);
            }
            if ((cityQuery = this.getCityQuery()) != null) {
                log.debug((Object)("cityQuery = " + cityQuery));
                query.add(cityQuery, BooleanClause.Occur.MUST);
            }
            if ((tableQuery = this.getTableQuery()) != null) {
                log.debug((Object)("tableQuery = " + tableQuery));
                query.add(tableQuery, BooleanClause.Occur.MUST);
            }
            if ((memberQuery = this.getMemberQuery()) != null) {
                log.debug((Object)("memberQuery = " + memberQuery));
                query.add(memberQuery, BooleanClause.Occur.MUST);
            }
        }
        catch (Exception pe) {
            log.error((Object)"Cannot parse the search query", (Throwable)pe);
        }
        log.debug((Object)("booleanQuery = " + query));
        NumericRangeFilter dateFilter = null;
        if (this.fromDate != null && this.toDate != null) {
            dateFilter = NumericRangeFilter.newLongRange((String)"ModiTime", (Long)this.fromDate.getTime(), (Long)this.toDate.getTime(), (boolean)true, (boolean)true);
            log.debug((Object)("dateFilter = " + this.fromDate + "~" + this.toDate));
        }
        Directory directory = null;
        IndexSearcher searcher = null;
        DirectoryReader reader = null;
        int cachetops = 100000;
        try {
            directory = SearchService.getSearchIndexDir();
            reader = DirectoryReader.open((Directory)directory);
            searcher = new IndexSearcher((IndexReader)reader);
            TopFieldDocs docs = null;
            docs = searcher.search((Query)query, (Filter)dateFilter, cachetops, this.getQuerySort());
            this.hitCount = docs.totalHits;
            this.searchResult = new ArrayList(this.hitCount);
            ScoreDoc[] scoreDocs = docs.scoreDocs;
            String fields = "keyid,title,demons,linkurl,author";
            for (int i = offset; i < offset + rowsToReturn && i < this.hitCount; ++i) {
                Document doc = searcher.doc(scoreDocs[i].doc);
                String id = doc.get("id");
                DataField df = new DataField();
                df.setField("id", id, 0);
                df.setField("title", doc.get("Title"), 0);
                df.setField("moditime", doc.get("ModiTime"), 0);
                df.setField("demons", doc.get("Demons"), 0);
                df.setField("classid", doc.get("CategoryId"), 0);
                df.setField("linkurl", doc.get("LinkUrl"), 0);
                this.searchResult.add(df);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            reader.close();
        }
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public Collection getArticleResult() {
        if (this.searchResult == null) {
            this.searchResult = new ArrayList();
        }
        return this.searchResult;
    }

    private Query getTopicBodyQuery() throws ParseException {
        if (this.searchString == null || this.searchString.equals("")) {
            return null;
        }
        StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_40);
        BooleanQuery topicBodyQuery = new BooleanQuery();
        String fieldname = "Title";
        if (this.scopeInArticle == 1) {
            fieldname = "Title";
        } else if (this.scopeInArticle == 2) {
            fieldname = "Content";
        }
        if (this.scopeInArticle > 0) {
            return this.GetParse(fieldname, this.searchString, (Analyzer)analyzer);
        }
        topicBodyQuery.add(this.GetParse("Title", this.searchString, (Analyzer)analyzer), BooleanClause.Occur.SHOULD);
        topicBodyQuery.add(this.GetParse("Content", this.searchString, (Analyzer)analyzer), BooleanClause.Occur.SHOULD);
        return topicBodyQuery;
    }

    private Query GetParse(String fieldname, String s, Analyzer analyzer) throws ParseException {
        QueryParser parse = new QueryParser(Version.LUCENE_40, fieldname, analyzer);
        if (this.search_and_or == 1) {
            parse.setDefaultOperator(QueryParser.AND_OPERATOR);
        } else {
            parse.setDefaultOperator(QueryParser.OR_OPERATOR);
        }
        return parse.parse(s);
    }

    private Query getMemberQuery() {
        TermQuery memberQuery = null;
        if (this.userName != null) {
            Term memberTerm = new Term("UserName", this.userName);
            memberQuery = new TermQuery(memberTerm);
        }
        return memberQuery;
    }

    private Query getCatalogQuery() {
        TermQuery catalogQuery = null;
        if (this.catalogid > 0) {
            Term catalogTerm = new Term("CategoryId", String.valueOf(this.catalogid));
            catalogQuery = new TermQuery(catalogTerm);
        }
        return catalogQuery;
    }

    private Query getB2bQuery() {
        TermQuery b2bQuery = null;
        if (this.b2b > 0) {
            Term b2bTerm = new Term("b2b", String.valueOf(this.b2b));
            b2bQuery = new TermQuery(b2bTerm);
        }
        return b2bQuery;
    }

    private Query getProvinceQuery() {
        TermQuery provinceQuery = null;
        if (this.province > 0) {
            Term provinceTerm = new Term("Province", String.valueOf(this.province));
            provinceQuery = new TermQuery(provinceTerm);
        }
        return provinceQuery;
    }

    private Query getCityQuery() {
        TermQuery cityQuery = null;
        if (this.city > 0) {
            Term cityTerm = new Term("City", String.valueOf(this.city));
            cityQuery = new TermQuery(cityTerm);
        }
        return cityQuery;
    }

    private Query getTableQuery() {
        TermQuery tableQuery = null;
        if (this.table != null) {
            Term tableTerm = new Term("Table", String.valueOf(this.table));
            tableQuery = new TermQuery(tableTerm);
        }
        return tableQuery;
    }

    public void setSort(int sort) {
        if (sort != 0 && sort != 2 && sort != 1) {
            throw new IllegalArgumentException("Does not support sort = " + sort);
        }
        this.sort = sort;
    }

    public int getSort() {
        return this.sort;
    }

    private Sort getQuerySort() {
        Sort sortObj = null;
        switch (this.sort) {
            case 2: {
                sortObj = new Sort(new SortField("ModiTime", SortField.Type.LONG, false));
                break;
            }
            case 1: {
                sortObj = new Sort(new SortField("ModiTime", SortField.Type.LONG, true));
                break;
            }
            default: {
                sortObj = new Sort();
            }
        }
        return sortObj;
    }
}

