/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageUtil {
    private static Log log = LogFactory.getLog(ImageUtil.class);
    public static int TOP_LEFT = 0;
    public static int TOP_CENTER = 1;
    public static int TOP_RIGHT = 2;
    public static int CENTER = 3;
    public static int BOTTOM_LEFT = 4;
    public static int BOTTOM_CENTER = 5;
    public static int BOTTOM_RIHGHT = 6;

    public static void waterMarkImage(String source, String fromimage, int pos) {
        try {
            File _file = new File(source);
            String filename = _file.getName();
            String format = "jpeg";
            if (filename != null && filename.lastIndexOf(".") > 0) {
                format = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
            }
            BufferedImage src = ImageIO.read(_file);
            int wideth = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(wideth, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, wideth, height, null);
            File watermark = new File(fromimage);
            BufferedImage src_mark = ImageIO.read(watermark);
            int wideth_mark = ((Image)src_mark).getWidth(null);
            int height_mark = ((Image)src_mark).getHeight(null);
            int pos_x = wideth - wideth_mark;
            int pos_y = height - height_mark;
            switch (pos) {
                case 0: {
                    pos_x = 0;
                    pos_y = 0;
                    break;
                }
                case 1: {
                    pos_x /= 2;
                    pos_y = 0;
                    break;
                }
                case 2: {
                    pos_y = 0;
                    break;
                }
                case 3: {
                    pos_x /= 2;
                    pos_y /= 2;
                    break;
                }
                case 4: {
                    pos_x = 0;
                    break;
                }
                case 5: {
                    pos_x /= 2;
                    break;
                }
            }
            pos_x = pos_x < 0 ? 0 : pos_x;
            pos_y = pos_y < 0 ? 0 : pos_y;
            g.drawImage(src_mark, pos_x, pos_y, wideth_mark, height_mark, null);
            g.dispose();
            FileOutputStream out = new FileOutputStream(source);
            ImageIO.write((RenderedImage)image, format, out);
            out.close();
        }
        catch (Exception e) {
            log.error((Object)("make waterMarkImage error:" + source), (Throwable)e);
        }
    }

    public static void waterMarkText(String source, String text, String font, int style, Color color, int size, int pos) {
        int x = 0;
        int y = 0;
        try {
            File _file = new File(source);
            String filename = _file.getName();
            String format = "jpeg";
            BufferedImage src = ImageIO.read(_file);
            int wideth = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(wideth, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, wideth, height, null);
            int ch_w = text.length() * size / 2;
            switch (pos) {
                case 0: {
                    x = 5;
                    y = size;
                    break;
                }
                case 1: {
                    x = (wideth - ch_w) / 2;
                    y = size;
                    break;
                }
                case 2: {
                    x = wideth - ch_w < 0 ? 0 : wideth - ch_w;
                    y = size;
                    break;
                }
                case 3: {
                    x = (wideth - ch_w) / 2;
                    y = (height - size) / 2;
                    break;
                }
                case 4: {
                    x = 5;
                    y = height - 5;
                    break;
                }
                case 5: {
                    x = (wideth - ch_w) / 2;
                    y = height - 5;
                    break;
                }
                case 6: {
                    x = wideth - ch_w < 0 ? 0 : wideth - ch_w;
                    y = height - 5;
                }
            }
            x = x < 0 ? 0 : x;
            y = y < 0 ? 0 : y;
            g.setColor(color);
            g.setFont(new Font(font, style, size));
            ((Graphics)g).drawString(text, x, y);
            g.dispose();
            FileOutputStream out = new FileOutputStream(source);
            ImageIO.write((RenderedImage)image, format, out);
            out.close();
        }
        catch (Exception e) {
            log.error((Object)("make waterMarkText error:" + source), (Throwable)e);
        }
    }
}

