/*
 * Decompiled with CFR 0.152.
 */
import com.websina.persistence.ConnectionPool;
import com.websina.persistence.DBException;
import com.websina.persistence.SQLProc;
import com.websina.persistence.SQLStringParser;
import com.websina.util.StringUtil;
import com.websina.util.log.Log;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Patch20
extends Patch {
    private String OTHERS;

    public Patch20(Properties properties, Log log) {
        super(properties, log);
        this.OTHERS = properties.getProperty("column.project.project_area2");
    }

    public boolean doPatch() throws DBException {
        this.createTable();
        Map map = this.getProjectMap();
        for (String string : map.keySet()) {
            List[] listArray = (List[])map.get(string);
            this.populateTable(string, listArray);
        }
        for (String string : map.keySet()) {
            this.alterIssueTable(string);
        }
        this.dropProjectTableColumns();
        for (String string : map.keySet()) {
            this.dropIssueTableColumns(string);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable() throws DBException {
        String string = this.schema.getProperty("table.fieldset");
        if (string != null) {
            return;
        }
        ConnectionPool connectionPool = ConnectionPool.getPool((String)"bugzero");
        Connection connection = null;
        Statement statement = null;
        String string2 = new StringBuffer().append("CREATE TABLE fieldset (\n").append("  project_id VARCHAR(50) NOT NULL,\n").append("  field_name INT NOT NULL,\n").append("  item VARCHAR(255) NOT NULL,\n").append("  item_order INT NOT NULL,\n").append("  CONSTRAINT fieldset_pk PRIMARY KEY (project_id, field_name, item)").append(')').toString();
        string2 = SQLStringParser.make((String)string2).getRawString();
        try {
            connection = connectionPool.checkout();
            statement = connection.createStatement();
            statement.executeUpdate(string2);
            connection.commit();
            System.out.println("\nCreate new table fieldset successfully .....\n");
        }
        catch (SQLException sQLException) {
            try {
                this.cleanUp(sQLException, connection);
                Log.error((String)("Failed Patch 20\n" + string2), (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                Patch20.close(statement);
                Patch20.checkin((Connection)connection);
                throw throwable;
            }
            Patch20.close((Statement)statement);
            Patch20.checkin((Connection)connection);
        }
        Patch20.close((Statement)statement);
        Patch20.checkin((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateTable(String string, List[] listArray) throws DBException {
        ConnectionPool connectionPool = ConnectionPool.getPool((String)"bugzero");
        Connection connection = null;
        Statement statement = null;
        String string2 = null;
        String string3 = new StringBuffer().append("INSERT INTO fieldset (item,item_order,field_name,project_id)").append("VALUES (?,?,?,?)").toString();
        try {
            connection = connectionPool.checkout();
            statement = connection.createStatement();
            SQLProc sQLProc = SQLStringParser.make((String)string3);
            sQLProc.setString(4, string);
            for (int i = 0; i < 5; ++i) {
                if (listArray[i] == null) continue;
                sQLProc.setInt(3, i);
                Iterator iterator = listArray[i].iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    sQLProc.setString(1, (String)iterator.next());
                    sQLProc.setInt(2, n++);
                    string2 = sQLProc.getSqlString();
                    statement.executeUpdate(string2);
                    Log.debug((String)string2);
                }
            }
            connection.commit();
            System.out.println("\nNew table fieldset was populated successfully .....\n");
        }
        catch (SQLException sQLException) {
            try {
                this.cleanUp(sQLException, connection);
                String string4 = "Populate table fieldset failed ...........";
                Patch20.rollback((Exception)sQLException, (Connection)connection, string2, (String)string4);
            }
            catch (Throwable throwable) {
                Patch20.close(statement);
                Patch20.checkin((Connection)connection);
                throw throwable;
            }
            Patch20.close((Statement)statement);
            Patch20.checkin((Connection)connection);
        }
        Patch20.close((Statement)statement);
        Patch20.checkin((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getProjectMap() throws DBException {
        ConnectionPool connectionPool = ConnectionPool.getPool((String)"bugzero");
        Connection connection = null;
        Statement statement = null;
        String string = new StringBuffer().append("select project_id,").append("project_version, project_version2,").append("environment, environment2,").append(this.OTHERS).append(" from project").toString();
        HashMap<String, List[]> hashMap = new HashMap<String, List[]>();
        try {
            connection = connectionPool.checkout();
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                List[] listArray = new List[5];
                String string2 = resultSet.getString(1).trim();
                listArray[0] = StringUtil.makeList((String)resultSet.getString(2));
                listArray[1] = StringUtil.makeList((String)resultSet.getString(3));
                listArray[2] = StringUtil.makeList((String)resultSet.getString(4));
                listArray[3] = StringUtil.makeList((String)resultSet.getString(5));
                listArray[4] = StringUtil.makeList((String)resultSet.getString(6));
                hashMap.put(string2, listArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            try {
                Log.error((String)("Failed Patch 20\n" + string), (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                Patch20.close(statement);
                Patch20.checkin((Connection)connection);
                throw throwable;
            }
            Patch20.close((Statement)statement);
            Patch20.checkin((Connection)connection);
        }
        Patch20.close((Statement)statement);
        Patch20.checkin((Connection)connection);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterIssueTable(String string) throws DBException {
        ConnectionPool connectionPool = ConnectionPool.getPool((String)"bugzero");
        Connection connection = null;
        Statement statement = null;
        try {
            connection = connectionPool.checkout();
            statement = connection.createStatement();
            String string2 = string + "_issue";
            statement.executeUpdate(SQLStringParser.make((String)("ALTER TABLE " + string2 + " ADD field_0 VARCHAR(255)")).getRawString());
            statement.executeUpdate(SQLStringParser.make((String)("ALTER TABLE " + string2 + " ADD field_1 VARCHAR(255)")).getRawString());
            statement.executeUpdate(SQLStringParser.make((String)("ALTER TABLE " + string2 + " ADD field_2 VARCHAR(255)")).getRawString());
            statement.executeUpdate(SQLStringParser.make((String)("ALTER TABLE " + string2 + " ADD field_3 VARCHAR(255)")).getRawString());
            statement.executeUpdate(SQLStringParser.make((String)("ALTER TABLE " + string2 + " ADD field_4 VARCHAR(255)")).getRawString());
            statement.executeUpdate(SQLStringParser.make((String)("ALTER TABLE " + string2 + " ADD field_5 VARCHAR(255)")).getRawString());
            statement.executeUpdate("UPDATE " + string2 + " SET " + "field_0 = project_version, " + "field_1 = project_version2, " + "field_2 = environment, " + "field_3 = environment2, " + "field_4 = " + this.OTHERS);
            connection.commit();
            System.out.println("\nAdd new columns to issue tables successfully .....\n");
        }
        catch (SQLException sQLException) {
            try {
                this.cleanUp(sQLException, connection);
                String string3 = "Add columns to the issue table failed ...........";
                Patch20.rollback((Exception)sQLException, (Connection)connection, (String)string3);
            }
            catch (Throwable throwable) {
                Patch20.close(statement);
                Patch20.checkin((Connection)connection);
                throw throwable;
            }
            Patch20.close((Statement)statement);
            Patch20.checkin((Connection)connection);
        }
        Patch20.close((Statement)statement);
        Patch20.checkin((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropProjectTableColumns() throws DBException {
        ConnectionPool connectionPool = ConnectionPool.getPool((String)"bugzero");
        Connection connection = null;
        Statement statement = null;
        try {
            connection = connectionPool.checkout();
            statement = connection.createStatement();
            statement.executeUpdate("ALTER TABLE project DROP COLUMN project_version");
            statement.executeUpdate("ALTER TABLE project DROP COLUMN project_version2");
            statement.executeUpdate("ALTER TABLE project DROP COLUMN environment");
            statement.executeUpdate("ALTER TABLE project DROP COLUMN environment2");
            statement.executeUpdate("ALTER TABLE project DROP COLUMN " + this.OTHERS);
            connection.commit();
            System.out.println("\nObsolete columns were successfully dropped from table project .....\n");
        }
        catch (SQLException sQLException) {
            try {
                this.cleanUp(sQLException, connection);
                String string = "Drop project table columns failed ...... If you are using DB2 or PostgreSql,\nno need to worry, you cannot drop columns.";
                Log.warn((String)string);
            }
            catch (Throwable throwable) {
                Patch20.close(statement);
                Patch20.checkin((Connection)connection);
                throw throwable;
            }
            Patch20.close((Statement)statement);
            Patch20.checkin((Connection)connection);
        }
        Patch20.close((Statement)statement);
        Patch20.checkin((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropIssueTableColumns(String string) throws DBException {
        ConnectionPool connectionPool = ConnectionPool.getPool((String)"bugzero");
        Connection connection = null;
        Statement statement = null;
        try {
            connection = connectionPool.checkout();
            statement = connection.createStatement();
            String string2 = string + "_issue";
            statement.executeUpdate("ALTER TABLE " + string2 + " DROP COLUMN project_version");
            statement.executeUpdate("ALTER TABLE " + string2 + " DROP COLUMN project_version2");
            statement.executeUpdate("ALTER TABLE " + string2 + " DROP COLUMN environment");
            statement.executeUpdate("ALTER TABLE " + string2 + " DROP COLUMN environment2");
            statement.executeUpdate("ALTER TABLE " + string2 + " DROP COLUMN " + this.OTHERS);
            connection.commit();
            System.out.println("\nObsolete columns were successfully dropped from issue tables .....\n");
        }
        catch (SQLException sQLException) {
            try {
                this.cleanUp(sQLException, connection);
                String string3 = "Drop issue table columns failed ....... If you are using DB2 or PostgreSql,\nno need to worry, you cannot drop columns.";
                Log.warn((String)string3);
            }
            catch (Throwable throwable) {
                Patch20.close(statement);
                Patch20.checkin((Connection)connection);
                throw throwable;
            }
            Patch20.close((Statement)statement);
            Patch20.checkin((Connection)connection);
        }
        Patch20.close((Statement)statement);
        Patch20.checkin((Connection)connection);
    }
}

