/*
 * Decompiled with CFR 0.152.
 */
import com.websina.persistence.ConnectionPool;
import com.websina.persistence.DBException;
import com.websina.persistence.SQLProc;
import com.websina.persistence.SQLStringParser;
import com.websina.util.PropertyLoader;
import com.websina.util.log.Log;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class Patch27
extends Patch {
    public Patch27(Properties properties, Log log) {
        super(properties, log);
    }

    public boolean doPatch() throws DBException {
        Set set = null;
        boolean bl = false;
        try {
            set = this.loadFromFile();
            bl = this.createGroupTable();
            if (bl) {
                bl = this.addGroup(set);
            }
        }
        catch (RuntimeException runtimeException) {
            System.out.println("\n\n         ERROR!!!!!!!!!!!!!!!!");
            System.out.println("Please copy the existing group.properties file over to complete the upgrade!\n");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createGroupTable() throws DBException {
        boolean bl = false;
        ConnectionPool connectionPool = ConnectionPool.getPool((String)"bugzero");
        Connection connection = null;
        Statement statement = null;
        String string = "CREATE TABLE groupcode (name VARCHAR(50) NOT NULL)";
        try {
            connection = connectionPool.checkout();
            statement = connection.createStatement();
            string = SQLStringParser.make((String)string).getRawString();
            statement.executeUpdate(string);
            connection.commit();
            System.out.println("\nTable groupcode created .....\n");
            bl = true;
        }
        catch (SQLException sQLException) {
            try {
                this.cleanUp(sQLException, connection);
                Log.error((String)("Failed Patch 27\n" + string), (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                Patch27.close(statement);
                Patch27.checkin((Connection)connection);
                throw throwable;
            }
            Patch27.close((Statement)statement);
            Patch27.checkin((Connection)connection);
        }
        Patch27.close((Statement)statement);
        Patch27.checkin((Connection)connection);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addGroup(Set set) throws DBException {
        boolean bl = false;
        ConnectionPool connectionPool = ConnectionPool.getPool((String)"bugzero");
        Connection connection = null;
        Statement statement = null;
        String string = null;
        try {
            connection = connectionPool.checkout();
            statement = connection.createStatement();
            for (String string2 : set) {
                SQLProc sQLProc = SQLStringParser.make((String)"insert into groupcode (name) VALUES (?)");
                sQLProc.setString(1, string2);
                string = sQLProc.getSqlString();
                statement.executeUpdate(string);
            }
            connection.commit();
            statement.close();
            System.out.println("Added groups from the file to the groupcode table .....\n");
            bl = true;
        }
        catch (SQLException sQLException) {
            try {
                this.cleanUp(sQLException, connection);
                String string3 = "Failed to add groups to the groupcode table, make sure they already exist .....";
                Log.warn((String)string3);
            }
            catch (Throwable throwable) {
                Patch27.close(statement);
                Patch27.checkin((Connection)connection);
                throw throwable;
            }
            Patch27.close((Statement)statement);
            Patch27.checkin((Connection)connection);
        }
        Patch27.close((Statement)statement);
        Patch27.checkin((Connection)connection);
        return bl;
    }

    private Set loadFromFile() {
        Properties properties = PropertyLoader.getProperties((String)"conf/group");
        Iterator<Object> iterator = properties.keySet().iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf("group.");
            if (n == -1) continue;
            hashSet.add(string.substring(6));
        }
        return hashSet;
    }
}

