/*
 * Decompiled with CFR 0.152.
 */
import com.websina.VersionUID;
import com.websina.persistence.ConnectionPool;
import com.websina.persistence.DBException;
import com.websina.persistence.DatabaseEntity;
import com.websina.util.log.Log;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;

public class Upgrade
extends DatabaseEntity {
    private static final Log log = Log.getLog();

    public Properties getSchema() throws DBException, SQLException {
        ConnectionPool connectionPool = ConnectionPool.getPool((String)"bugzero");
        Connection connection = null;
        System.out.println("Testing database connection ......... ");
        connection = connectionPool.checkout();
        connection.setAutoCommit(true);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = databaseMetaData.getDatabaseProductName();
        String string2 = databaseMetaData.getDatabaseProductVersion();
        String string3 = databaseMetaData.getURL();
        String string4 = databaseMetaData.getUserName();
        System.out.println("Succeeded connecting to: ");
        System.out.println("///////////////////////////////////////////////////////");
        System.out.println("Database System: " + string);
        System.out.println(string2);
        System.out.println("URL:             " + string3);
        System.out.println("Username:        " + string4);
        System.out.println("///////////////////////////////////////////////////////");
        Properties properties = new Properties();
        properties.setProperty("database", connectionPool.getDatabaseName() + ": " + string.toLowerCase());
        String string5 = null;
        if (connectionPool.getDatabaseName().equals("oracle")) {
            string5 = string4;
        }
        this.checkTable(databaseMetaData, string5, properties, "person");
        if (!properties.containsKey("table.person")) {
            return properties;
        }
        this.checkTable(databaseMetaData, string5, properties, "field%");
        this.checkTable(databaseMetaData, string5, properties, "groupcode");
        this.checkTable(databaseMetaData, string5, properties, "%_entry");
        this.checkTable(databaseMetaData, string5, properties, "fieldorder");
        this.checkTable(databaseMetaData, string5, properties, "reminder");
        this.checkTable(databaseMetaData, string5, properties, "assignment");
        this.checkColumn(databaseMetaData, string5, properties, "project");
        this.checkColumn(databaseMetaData, string5, properties, "accesscode");
        this.checkColumn(databaseMetaData, string5, properties, "person");
        if (properties.containsKey("table.groupcode")) {
            this.checkColumn(databaseMetaData, string5, properties, "groupcode");
        }
        this.checkColumn(databaseMetaData, string5, properties, "fieldname");
        if (properties.containsKey("table.assignment")) {
            this.checkColumn(databaseMetaData, string5, properties, "assignment");
        }
        this.checkColumn(databaseMetaData, string5, properties, "reminder");
        this.checkColumn(databaseMetaData, string5, properties, "fieldset");
        this.checkTable(databaseMetaData, string5, properties, "fieldorder");
        this.checkTable(databaseMetaData, string5, properties, "mailbox");
        this.checkTable(databaseMetaData, string5, properties, "holiday");
        this.checkTable(databaseMetaData, string5, properties, "crosslink");
        this.checkTable(databaseMetaData, string5, properties, "emailtemplate");
        if (connection != null) {
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            connectionPool.checkin(connection);
        }
        connectionPool.clearPool();
        System.out.println("Current database schema checking completed.");
        return properties;
    }

    private void checkTable(DatabaseMetaData databaseMetaData, String string, Properties properties, String string2) throws SQLException {
        String string3;
        String string4 = "table.";
        boolean bl = true;
        ResultSet resultSet = databaseMetaData.getTables(null, string, string2, null);
        while (resultSet.next()) {
            string3 = resultSet.getString("TABLE_NAME");
            string3 = string3.toLowerCase();
            properties.setProperty(string4 + string3, string3);
            bl = false;
        }
        if (bl) {
            resultSet = databaseMetaData.getTables(null, string, string2.toUpperCase(), null);
            while (resultSet.next()) {
                string3 = resultSet.getString("TABLE_NAME");
                string3 = string3.toLowerCase();
                properties.setProperty(string4 + string3, string3);
            }
        }
        resultSet.close();
    }

    private void checkColumn(DatabaseMetaData databaseMetaData, String string, Properties properties, String string2) throws SQLException {
        String string3;
        String string4 = "column." + string2 + ".";
        boolean bl = true;
        ResultSet resultSet = databaseMetaData.getColumns(null, string, string2, null);
        while (resultSet.next()) {
            string3 = resultSet.getString("COLUMN_NAME");
            string3 = string3.toLowerCase();
            if (string2.equals("project") && string3.equals("others")) {
                properties.setProperty(string4 + "project_area2", string3);
            } else {
                properties.setProperty(string4 + string3, string3);
            }
            bl = false;
        }
        if (bl) {
            resultSet = databaseMetaData.getColumns(null, string, string2.toUpperCase(), null);
            while (resultSet.next()) {
                string3 = resultSet.getString("COLUMN_NAME");
                string3 = string3.toLowerCase();
                if (string2.equals("project") && string3.equals("others")) {
                    properties.setProperty(string4 + "project_area2", string3);
                    continue;
                }
                properties.setProperty(string4 + string3, string3);
            }
        }
        resultSet.close();
    }

    public void patchOne(Properties properties, Log log, String string) throws DBException, SQLException {
        Patch patch = null;
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(Properties.class, Log.class);
            patch = (Patch)((Object)constructor.newInstance(properties, log));
        }
        catch (Throwable throwable) {
            System.out.println("");
            System.out.println("No such a patch is available: " + string);
            System.out.println("");
        }
        if (patch != null) {
            patch.doPatch();
        }
    }

    public static void main(String[] stringArray) throws DBException, SQLException {
        System.out.println(new Date());
        long l = System.currentTimeMillis();
        log.setOut((OutputStream)System.out, "Log is now switched to System.out in Upgrade.main");
        Upgrade upgrade = new Upgrade();
        Properties properties = upgrade.getSchema();
        if (stringArray != null && stringArray.length == 1) {
            upgrade.patchOne(properties, log, stringArray[0]);
            System.out.println("Total time elapsed (s): " + (System.currentTimeMillis() - l) / 1000L);
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (!properties.containsKey("table.person")) {
            System.out.println("\n\nIt seems there is nothing to upgrade, no tables exist");
            return;
        }
        String string = VersionUID.version;
        System.out.println("Start patching database schema to " + string);
        boolean bl3 = bl = !properties.containsKey("table.fieldset");
        if (bl) {
            new Patch20(properties, log).doPatch();
            bl2 = true;
        }
        boolean bl4 = bl = !properties.containsKey("table.fieldname") || !properties.containsKey("column.project.project_name") || !properties.containsKey("column.project.project_status");
        if (bl) {
            new Patch22(properties, log).doPatch();
            bl2 = true;
        }
        String string2 = properties.getProperty("database");
        if (!properties.containsKey("column.project.email")) {
            bl2 = new Patch22b(properties, log).doPatch();
            bl2 = new Patch23(properties, log).doPatch();
            bl2 = new Patch24(properties, log).doPatch();
        }
        if (!properties.containsKey("column.person.signature")) {
            bl2 = new Patch25(properties, log).doPatch();
        }
        if (properties.containsKey("column.project.issue_type") && properties.containsKey("column.project.severity") && properties.containsKey("column.project.priority") && properties.containsKey("column.project.state")) {
            bl2 = new Patch26(properties, log).doPatch();
        }
        if (!properties.containsKey("table.groupcode")) {
            bl2 = new Patch26b(properties, log).doPatch();
            bl2 = new Patch27(properties, log).doPatch();
        }
        if (!properties.containsKey("column.project.email_subject") && !properties.containsKey("column.project.email_body")) {
            bl2 = new Patch27b(properties, log).doPatch();
        }
        if (!properties.containsKey("column.groupcode.group_type")) {
            bl2 = new Patch28(properties, log).doPatch();
        }
        if (!properties.containsKey("column.fieldname.denied_groups")) {
            bl2 = new Patch28b(properties, log).doPatch();
        }
        if (properties.containsKey("table.assignment") && !properties.containsKey("column.assignment.assignable") && !properties.containsKey("column.assignment.field")) {
            bl2 = new Patch30(properties, log).doPatch();
            bl2 = new Patch30b(properties, log).doPatch();
            bl2 = new Patch30c(properties, log).doPatch();
        }
        if (!properties.containsKey("column.person.browse_mode")) {
            bl2 = new Patch32(properties, log).doPatch();
            bl2 = new Patch33b(properties, log).doPatch();
        }
        if (!properties.containsKey("column.project.project_desc")) {
            bl2 = new Patch33(properties, log).doPatch();
            bl2 = new Patch34(properties, log).doPatch();
        }
        if (!properties.containsKey("column.fieldname.mandatory")) {
            bl2 = new Patch35(properties, log).doPatch();
        }
        if (!properties.containsKey("table.fieldorder") && !properties.containsKey("column.project.field_order")) {
            bl2 = new Patch35b(properties, log).doPatch();
        }
        if (!properties.containsKey("table.reminder")) {
            bl2 = new Patch36(properties, log).doPatch();
        }
        if (!properties.containsKey("column.fieldname.ro_groups")) {
            bl2 = new Patch38(properties, log).doPatch();
        }
        if (!properties.containsKey("column.project.project_ssn")) {
            bl2 = new Patch38b(properties, log).doPatch();
        }
        if (!properties.containsKey("column.fieldname.max_length")) {
            bl2 = new Patch39b(properties, log).doPatch();
            bl2 = new Patch39(properties, log).doPatch();
        }
        if (!properties.containsKey("column.reminder.remind_age") && !properties.containsKey("column.reminder.sdt")) {
            bl2 = new Patch39c(properties, log).doPatch();
            bl2 = new Patch40(properties, log).doPatch();
        }
        if (properties.containsKey("table.reminder") && !properties.containsKey("column.reminder.remind_age") && !properties.containsKey("column.reminder.sdt")) {
            bl2 = new Patch39d(properties, log).doPatch();
        }
        if (!properties.containsKey("column.project.field_order")) {
            bl2 = new Patch40c(properties, log).doPatch();
            bl2 = new Patch40b(properties, log).doPatch();
        }
        if (!properties.containsKey("column.fieldname.field_type")) {
            bl2 = new Patch40d(properties, log).doPatch();
        }
        if (!properties.containsKey("column.project.project_url")) {
            bl2 = new Patch41(properties, log).doPatch();
        }
        if (!properties.containsKey("table.mailbox")) {
            bl2 = new Patch41b(properties, log).doPatch();
            bl2 = new Patch42(properties, log).doPatch();
        }
        if (!properties.containsKey("column.project.theme_logo")) {
            bl2 = new Patch43(properties, log).doPatch();
        }
        if (!properties.containsKey("column.project.closed_state")) {
            bl2 = new Patch43b(properties, log).doPatch();
        }
        if (!properties.containsKey("column.project.project_type")) {
            bl2 = new Patch45(properties, log).doPatch();
        }
        if (!properties.containsKey("column.fieldset.parent_field") && !properties.containsKey("column.fieldset.parent_item")) {
            bl2 = new Patch50(properties, log).doPatch();
        }
        if (!properties.containsKey("column.project.project_group") && !properties.containsKey("column.accesscode.access_role")) {
            bl2 = new Patch51(properties, log).doPatch();
        }
        if (!properties.containsKey("table.holiday")) {
            bl2 = new Patch55(properties, log).doPatch();
            bl2 = new Patch55b(properties, log).doPatch();
        }
        if (!properties.containsKey("column.project.report_fields")) {
            bl2 = new Patch55c(properties, log).doPatch();
            bl2 = new Patch55d(properties, log).doPatch();
            bl2 = new Patch55e(properties, log).doPatch();
            bl2 = new Patch56(properties, log).doPatch();
        }
        if (properties.containsKey("new-table.accesscode") || !properties.containsKey("column.accesscode.role_type")) {
            bl2 = new Patch56b(properties, log).doPatch();
        }
        if (!properties.containsKey("column.person.ts")) {
            bl2 = new Patch57(properties, log).doPatch();
        }
        if (!properties.containsKey("table.crosslink")) {
            bl2 = new Patch58(properties, log).doPatch();
        }
        if (!properties.containsKey("column.person.failed_logins")) {
            bl2 = new Patch60(properties, log).doPatch();
        }
        if (!properties.containsKey("column.fieldname.params") || properties.containsKey("table.assignment") && properties.containsKey("column.assignment.assignable")) {
            bl2 = new Patch61(properties, log).doPatch();
        }
        if (!properties.containsKey("column.fieldset.p2_field") && !properties.containsKey("column.fieldset.p2_item")) {
            bl2 = new Patch62(properties, log).doPatch();
        }
        if (!(properties.containsKey("column.fieldset.fdisabled") && properties.containsKey("column.fieldset.fmandatory") && properties.containsKey("column.project.flag0"))) {
            bl2 = new Patch62b(properties, log).doPatch();
            if (string2.indexOf("oracle") != -1) {
                bl2 = new Patch62c(properties, log).doPatch();
            }
        }
        if (!properties.containsKey("table.emailtemplate")) {
            bl2 = new Patch65(properties, log).doPatch();
        }
        if (bl2) {
            System.out.println("\n\nYour database schema is patched to " + string + ". Any errors occurred above must be resolved.\n");
        } else {
            System.out.println("\nYour database schema seems up to date for " + string + ", but make sure no error has occurred above.\n");
        }
        System.out.println("Total time elapsed (s): " + (System.currentTimeMillis() - l) / 1000L);
    }
}

