@REM This script has to be run inside the bin directory.
@REM It is used to test database settings (in db.properties) and do other database related tasks.

@echo off

SETLOCAL
title Bugzero Database Administration

pushd ..

if not exist data (
if not exist classes (
echo Can not find the data or classes directory
echo Make sure this program is started in the bin directory it is located.
goto okey
))

@REM Lines below enable this CMD to be run within dev environment
SET CLASSPATH=.;data;classes
if exist lib/classes		SET CLASSPATH=%CLASSPATH%;lib/classes

@REM add other jar or zip files inside lib
set _LIBJARS=
for %%i in (lib\*.*) do call bin\cpappend.bat %%i

SET CLASSPATH=%CLASSPATH%%_LIBJARS%
echo Using CLASSPATH:   %CLASSPATH%

@REM If java is not in your path, specify the absolute path to java here
@REM check the java version
java -version

java -cp "%CLASSPATH%" com.websina.persistence.TableManager %1 %2 %3

IF %ERRORLEVEL% LEQ 1 goto okey
echo ////////////////////////////////////////////////////////////////////
echo Error occurred!
echo If you do not have Java installed or java is not in your system path,
echo please install J2SE (JDK1.3 or later) from java.sun.com and add the bin
echo folder where the java command is located in the PATH.
echo See README for more details.

:okey
popd
pause

ENDLOCAL
