#!/bin/sh
# This script has to be run inside the bin directory.
# It is used to test database settings (in db.properties) and do other database related tasks.

CLASSPATH=.:data:classes

cd ../

if [ ! -d data ]; then
if [ ! -d classes ]; then 
echo "Can not find the data or classes directory"
echo "Make sure this program is run in the bin directory it is located."
exit 1
fi
fi

# Lines below enable this script to be run within dev environment
if [ -d lib/classes ]; then
   CLASSPATH=${CLASSPATH}:lib/classes
fi

# Add all the jar or zip files inside lib
for i in lib/*.* ; do
  CLASSPATH=${CLASSPATH}:$i
done

echo "Using CLASSPATH:   $CLASSPATH"

# If java is not in your path, specify the absolute path to java here
# check the java version
java -version

java -cp "$CLASSPATH" com.websina.persistence.TableManager "$@"

if [ $? != 0 ]; then
echo ////////////////////////////////////////////////////////////////////
echo "Error occurred!"
echo "If you do not have Java installed or java is not in your system path,"
echo "please install J2SE (JDK1.3 or later) from java.sun.com and add the bin"
echo "folder where the java command is located in the PATH."
echo "See README for more details."
fi

cd bin

