# create the mailbox table
# mailbox_properties may include
# mail.store.protocol=pop3; mail.pop3.auth=true; mail.pop3.port=115; mail.debug=true, etc
#
# mailbox_status = 'N' or 'D' for de-active
CREATE TABLE mailbox (
  mailbox_host VARCHAR(200) NOT NULL,
  mailbox_username VARCHAR(50) NOT NULL,
  project_id VARCHAR(50) NOT NULL,
  assignable VARCHAR(200),
  refresh_minutes INT,
  mailbox_password VARCHAR(50),
  mailbox_properties VARCHAR(255),
  mailbox_status CHAR(1),
  CONSTRAINT mailbox_pk PRIMARY KEY (mailbox_host, mailbox_username),
  CONSTRAINT mailbox_project FOREIGN KEY (project_id)
    REFERENCES project
    ON DELETE CASCADE
)