# test original author or current responsible user group
SELECT
  count(*)
FROM person, accesscode, $PROJECT_entry issue, $PROJECT_trail trail
WHERE
  issue.entry_id=?
AND trail.entry_id=issue.entry_id
AND trail.ts = (select MAX(t2.ts)
  from $PROJECT_trail t2
  WHERE t2.entry_id=trail.entry_id)
AND (issue.author=person.username OR trail.responsible=person.username)
AND accesscode.project_id=?
AND ((person.group_code IN ($GROUPS) AND accesscode.person_id=person.person_id AND accesscode.access_role is NULL) 
  OR (accesscode.person_id=person.person_id AND accesscode.role_type is NULL AND accesscode.access_role IN ($GROUPS))
  OR (person.group_code=accesscode.access_role AND (accesscode.person_id is NULL OR accesscode.person_id=0) AND accesscode.access_role IN ($GROUPS)))

