/*
 * Copyright (c) 2002-2010 WEBsina, Inc. All Rights Reserved.
 */
package com.websina.servlet;

import com.websina.bean.Project;
import com.websina.bean.Issue;
import com.websina.bean.Person;

/**
 * This class is to be customized by end users for addional permission and workflow rules.
 * Some methods are moved from _issueform.jspf.
 *
 * You must not add or remove methods, nor modify method signature.
 * You can only modify rules and logics in the methods. 
 *
 * Run make.bat or ./make.sh to compile the class into /WEB-INF/classes, and restart.
 *
 */
public class AdditionalPermission {

  /**
   * Applied only when the page is loaded based on the field values that were already saved.
   * @param field the field internal id, like field_1, not the label.
   */
  protected static boolean isFieldEnabled(String field, Project conf, Person person, Issue issue) {
    return true;
  }

  protected static boolean isFieldReadOnly(String field, Project conf, Person person, Issue issue) {
    //if (issue != null && field.equals("synopsis")) return true;
    return false;
  }

  protected static boolean isFieldMandatory(String field, Project conf, Person person, Issue issue) {
    //if (issue != null && issue.get("state").equals("fixed") && field.equals("field_3")) return true;
    return false;
  }

  protected static String[] nextAllowed(String currentState, Project conf, String[] nextAllowed) {
    return nextAllowed;
  }

  protected static boolean saveAllowed(Project conf, Person person, Issue issue) {
    // if (issue != null && "submit".equals(person.getAccessCode())) return false;
    return true;
  }
}