/*
 * Copyright (c) 2002-2010 WEBsina, Inc. All Rights Reserved.
 */
import java.util.*;

import com.websina.service.TriggerAction;
import com.websina.bean.Reminder;
import com.websina.bean.Issue;
import com.websina.util.log.Log;

/**
 * This class is to be customized by end users for the actions to be taken in Reminder.
 *
 * Run make.bat or ./make.sh to compile the class into /WEB-INF/classes, and restart.
 */
public class SampleTriggerAction implements TriggerAction {

  /**
   *
   * You can get the project by issue.getProject().
   *
   * Use issue.getId() to get the id and you can update database directly:
   * update projectId_entry set field_name='value' where entry_id in (....); 
   *
   * or using API method:
   * issue.update(fieldName, value), or
   * issue.getLastTrail().set(fieldName, value);
   * and then issue.save(true);
   *
   * With the direct database update option, you can do one SQL for all issues,
   * while using the application API method, it is done one by one.
   *
   * @param rmd the reminder on which this issueList was obtained
   * @param issueList the list of issues to be acted upon.
   * @return the list of issues that has been acted upon.
   */
  public Issue[] doWork(Reminder rmd, Issue[] issueList) throws Exception {
    return issueList;
  }

}