@echo off
@REM 1. copy configuration/template files and JDBC drivers.
@REM 2. update the database schema.

if not exist upgrade.jar (
echo Error: this program must be run in the directory misc\upgrade
pause
goto end
)

SET HOME_PRE=%1
if ""%HOME_PRE%"" == """" (
echo Usage: upgrade path-to-the-installed-running-bugzero-home
echo example:  upgrade "c:\tomcat\webapps\bugzero"
pause
goto end
)
SET CONF_PRE=%HOME_PRE%\WEB-INF\classes\conf
if not exist %CONF_PRE% (
echo Bugzero home is not entered correctly, no conf dir was found.
pause
goto end
)
SET LIB_PRE=%HOME_PRE%\WEB-INF\lib
if not exist %LIB_PRE% (
echo Bugzero home is not entered correctly, no lib dir was found.
pause
goto end
)
SET TEMPLATE_PRE=%HOME_PRE%\WEB-INF\classes\template
if not exist %TEMPLATE_PRE% (
echo Bugzero home is not entered correctly, no template dir was found.
pause
goto end
)

SET CONF_DIR=..\..\classes\conf\
SET LIB_DIR=..\..\lib\
SET TEMPLATE_DIR=..\..\classes\template\

rename %CONF_DIR%\system.properties system.properties.new 
rename %CONF_DIR%\db.properties db.properties.new
rename %CONF_DIR%\mail.properties mail.properties.new

copy %CONF_PRE%\system.properties %CONF_DIR%
copy %CONF_PRE%\db.properties %CONF_DIR%
copy %CONF_PRE%\mail.properties %CONF_DIR%
copy %TEMPLATE_PRE%\email_subject %TEMPLATE_DIR%
copy %TEMPLATE_PRE%\email_body %TEMPLATE_DIR%
if exist %TEMPLATE_PRE%\reminder_subject (
  copy %TEMPLATE_PRE%\reminder_subject %TEMPLATE_DIR%
)
if exist %TEMPLATE_PRE%\reminder_body (
  copy %TEMPLATE_PRE%\reminder_body %TEMPLATE_DIR%
)
if exist %CONF_PRE%\schedule.properties (
  if exist %CONF_DIR%\schedule.properties (
    rename %CONF_DIR%\schedule.properties schedule.properties.new
  )
  copy %CONF_PRE%\schedule.properties %CONF_DIR%
)
if exist %CONF_PRE%\ldap.properties (
  if exist %CONF_DIR%\ldap.properties (
    rename %CONF_DIR%\ldap.properties ldap.properties.new
  )
  copy %CONF_PRE%\ldap.properties %CONF_DIR%
)
if exist %CONF_PRE%\cluster.properties (
  if exist %CONF_DIR%\cluster.properties (
    rename %CONF_DIR%\cluster.properties cluster.properties.new
  )
  copy %CONF_PRE%\cluster.properties %CONF_DIR%
)

IF %ERRORLEVEL% LEQ 0 (
  for  %%i in (%LIB_PRE%\*.jar %LIB_PRE%\*.zip) do call copyjar.bat %%~nxi %LIB_PRE% %LIB_DIR% 
)

IF %ERRORLEVEL% LEQ 0 goto okey
echo ////////////////////////////////////////////////////////////////////
echo Failed to copy required files, you may need do it manually
echo ................................. and then run checkdb.bat
pause
goto end

:okey
@REM remove the mail.jar and activation.jar if the original ones are not present.
if not exist %LIB_PRE%\mail.jar (
  del /F %LIB_DIR%\mail.jar
)
if not exist %LIB_PRE%\activation.jar (
  del /F %LIB_DIR%\activation.jar
)

echo Now updating the database schema ....
call checkdb.bat

:end
