#!/bin/sh
# 1. copy configuration/template files and JDBC drivers.
# 2. update the database schema.

CP="/bin/cp -fp"
MV="/bin/mv -i"

case "`uname`" in
   Linux*) MV="/bin/mv -u";;
esac

if [ ! -f upgrade.jar ]; then 
echo "Error: this program must be run in the directory misc/upgrade"
exit 1
fi

HOME_PRE=$@
if [ "$HOME_PRE" = "" ]; then
   echo "Usage: upgrade path-to-the-installed-running-bugzero-home"
   echo "   Ex: upgrade /usr/tomcat/webapps/bugzero"
exit 1
fi

CONF_PRE=$HOME_PRE/WEB-INF/classes/conf
if [ ! -d "$CONF_PRE" ]; then
   echo "Bugzero home is not entered correctly, no conf dir was found."
exit 1
fi

LIB_PRE=$HOME_PRE/WEB-INF/lib
if [ ! -d "$LIB_PRE" ]; then
   echo "Bugzero home is not entered correctly, no lib dir was found."
exit 1
fi

TEMPLATE_PRE=$HOME_PRE/WEB-INF/classes/template
if [ ! -d "$TEMPLATE_PRE" ]; then
   echo "Bugzero home is not entered correctly, no template dir was found."
exit 1
fi

CONF_DIR=../../classes/conf/.
LIB_DIR=../../lib/.
TEMPLATE_DIR=../../classes/template/.

$MV $CONF_DIR/system.properties $CONF_DIR/system.properties.new
$MV $CONF_DIR/db.properties $CONF_DIR/db.properties.new
$MV $CONF_DIR/mail.properties $CONF_DIR/mail.properties.new

$CP "$CONF_PRE"/system.properties $CONF_DIR
$CP "$CONF_PRE"/db.properties $CONF_DIR
$CP "$CONF_PRE"/mail.properties $CONF_DIR
$CP "$TEMPLATE_PRE"/email_subject $TEMPLATE_DIR
$CP "$TEMPLATE_PRE"/email_body $TEMPLATE_DIR

if [ -f "$TEMPLATE_PRE"/reminder_subject ]; then
  $CP "$TEMPLATE_PRE"/reminder_subject $TEMPLATE_DIR
fi
if [ -f "$TEMPLATE_PRE"/reminder_body ]; then
  $CP "$TEMPLATE_PRE"/reminder_body $TEMPLATE_DIR
fi
if [ -f "$CONF_PRE"/schedule.properties ]; then
  if [ -f "$CONF_DIR"/schedule.properties ]; then
    $MV $CONF_DIR/schedule.properties $CONF_DIR/schedule.properties.new
  fi
  $CP "$CONF_PRE"/schedule.properties $CONF_DIR
fi
if [ -f "$CONF_PRE"/ldap.properties ]; then
  if [ -f "$CONF_DIR"/ldap.properties ]; then
    $MV $CONF_DIR/ldap.properties $CONF_DIR/ldap.properties.new
  fi
  $CP "$CONF_PRE"/ldap.properties $CONF_DIR
fi
if [ -f "$CONF_PRE"/cluster.properties ]; then
  if [ -f "$CONF_DIR"/cluster.properties ]; then
    $MV $CONF_DIR/cluster.properties $CONF_DIR/cluster.properties.new
  fi
  $CP "$CONF_PRE"/cluster.properties $CONF_DIR
fi

errorlevel=$?
if [ $errorlevel = 0 ]; then
for i in "$LIB_PRE"/*.jar "$LIB_PRE"/*.zip; do
if [ -f "$i" ]; then
if [ "$i" != "$LIB_PRE/bugzero.jar" ]; then
if [ "$i" != "$LIB_PRE/mail.jar" ]; then
if [ "$i" != "$LIB_PRE/activation.jar" ]; then
if [ "$i" != "$LIB_PRE/mysql.jar" ]; then
if [ "$i" != "$LIB_PRE/mysql-connector-java-3.0.8-stable-bin.jar" ]; then
if [ "$i" != "$LIB_PRE/mysql-connector-java-3.0.15-ga-bin.jar" ]; then
   $CP "$i" $LIB_DIR
fi
fi
fi
fi
fi
fi
fi
done
errorlevel=$?
fi

if [ $errorlevel != 0 ]; then
  echo "////////////////////////////////////////////////////////////////////"
  echo "Failed to copy required files, you may need do it manually"
  echo "..................................... and then run checkdb"
else 
# remove the mail.jar and activation.jar if the original ones are not present.
  if [ ! -f "$LIB_PRE/mail.jar" ]; then
    rm -f "$LIB_DIR/mail.jar"
  fi
  if [ ! -f "$LIB_PRE/activation.jar" ]; then
    rm -f "$LIB_DIR/activation.jar"
  fi

  echo "Now updating the database schema ...."
  sh checkdb.sh
fi

