@REM This is the set up script used to configure Bugzero system.

@echo off

SETLOCAL
title Bugzero System Setup

SET CLASSPATH=.;data;classes

if not exist data (
if not exist classes (  
echo Can not find the data or classes directory
echo Make sure this setup program is run in the same directory it is located.
pause
goto okey
))

@REM Lines below enable this CMD to be run within dev environment
if exist lib/classes		SET CLASSPATH=%CLASSPATH%;lib/classes

@REM add other jar or zip files inside lib
set _LIBJARS=
for %%i in (lib\*.*) do call bin\cpappend.bat %%i

SET CLASSPATH=%CLASSPATH%%_LIBJARS%
echo Using CLASSPATH:   %CLASSPATH%

@REM If java is not in your path, specify the absolute path to java here
@REM check the java version
java -version

java -cp "%CLASSPATH%" com.websina.install.InstallManager

IF %ERRORLEVEL% LEQ 1 goto okey
echo ////////////////////////////////////////////////////////////////////
echo Error occurred!
echo If you do not have Java installed or java is not in your system path,
echo please install J2SE (JDK1.3 or later) from java.sun.com and add the bin
echo folder where the java command is located in the PATH.
echo See README for more details.
pause

:okey

ENDLOCAL
