#!/bin/sh
# This is the set up script used to configure Bugzero system.

CLASSPATH=.:data:classes

if [ ! -d data ]; then
if [ ! -d classes ]; then 
echo "Can not find the data or classes directory"
echo "Make sure this setup program is run in the same directory it is located" 
exit 1
fi
fi

# Lines below enable this script to be run within dev environment
if [ -d lib/classes ]; then
   CLASSPATH=${CLASSPATH}:lib/classes
fi

# Add all the jar or zip files inside lib
for i in lib/*.* ; do
  CLASSPATH=${CLASSPATH}:$i
done

echo "Using CLASSPATH:   $CLASSPATH"

# If java is not in your path, specify the absolute path to java here
# check the java version
java -version

java -cp "$CLASSPATH" com.websina.install.InstallManager

if [ $? != 0 ]; then
echo ////////////////////////////////////////////////////////////////////
echo "Error occurred!"
echo "If you do not have Java installed or java is not in your system path,"
echo "please install J2SE (JDK1.3 or later) from java.sun.com and add the bin"
echo "folder where the java command is located in the PATH."
echo "See README for more details."
fi
