<%@ page
    import="com.websina.bean.*,com.websina.util.*"
%>
<html>
<head>
<title>Field Dependency</title>
<script type="text/javascript" src="../script/utils.js"></script>
<script type="text/javascript" src="script/item_mover.js"></script>
</head>
<body topmargin=0>
<%@ include file="_header.jspf" %>
<%      
  String msg = com.websina.servlet.SessionUtil.getMessage(session, request);
  String mainTitle = label.get("admin_field_dependency");
  Project conf = null;
  String childFieldName = request.getParameter("childField");
  String parentFieldName = request.getParameter("parentField");
  String parent2FieldName = request.getParameter("parent2Field");
  com.websina.util.Field childField = null, parentField = null, parent2Field = null;
  if (projectId != null && projectId.trim().length()>0) {
    conf = Project.getInstance(projectId);
    if (!conf.isPersisted()) {
      msg = MessageCode.get("servlet.project.not_persisted", lang);
      conf = null;
      projectId = null;
    } else if (childFieldName == null || conf.isValidField(childFieldName) == false || (parentFieldName == null && parent2FieldName == null)) {
      msg = "Error: field is not properly selected, child='" + childFieldName + "', parent='" + parentFieldName + "', parent2='" + parent2FieldName + "'.";
      conf = null;
    } else {
      childField = conf.getField(childFieldName);
      parentField = conf.getMenuField(parentFieldName);
      parent2Field = conf.getMenuField(parent2FieldName);
      if (parentField == null && parent2Field == null) {
        msg = "Error: parent field '" + parentFieldName + "' or '" + parent2FieldName + "' are not menu field or have no options.";
        conf = null;
      } else {
        if (parentField == null) { 
          parentFieldName = parent2FieldName; 
          parentField = parent2Field;
          parent2Field = null;
        }
        mainTitle += (": " + admin.getProjectDisplay(projectId));
      }
    }
  } else {
    projectId = null;
  }
%>
<%--/// the title part ///--%>
<table cellpadding=0 cellspacing=0 width="100%" border=0>
  <tr><td>&nbsp;</td></tr>
  <tr class="f1"><td align=center height=30><font size=+1><b><%=mainTitle%></b></font>
  </td></tr>
</table>
<center>
<p>
<%=com.websina.servlet.ServletUtil.formatMessage(msg)%>

<% if (conf != null) { 
String[] parentOptions = parentField.getValue(); 
String[] parent2Options = (parent2Field != null)? parent2Field.getValue() : null; 
%>
<form name="fieldForm" method="post" action="<%=contextPath%>/servlet/project" onsubmit="return false;">
<input type="hidden" name="token" value='<%=com.websina.servlet.SessionUtil.getToken(session)%>'>
<input type="hidden" name="action" value="fields">
<input type="hidden" name="projectId" value="<%=projectId%>">
<input type="hidden" name="childField" value="<%=childFieldName%>">
<input type="hidden" name="parentField" value="<%=parentFieldName%>">
<% if (parent2Field != null) { %>
<input type="hidden" name="parent2Field" value="<%=parent2FieldName%>">
<% } %>

<table cellpadding=1 cellspacing=1 border=0 class="box">

<!--/// one parent ///-->
<% if (parent2Field == null) { %>
<tr class="header"><td colspan=2 align=center>
<font color="#ffffff"><b>
<%=childFieldName%> (<%=childField.getLabel()%>) on <%=parentFieldName%> (<%=parentField.getLabel()%>)
</b></font>
</td></tr>
<% for (int i=0; i<parentOptions.length; i++) { %>
<tr><td class="e8" colspan=2 align=center><%=parentOptions[i]%></td></tr>
<tr class="f1">
<td align=center>
<table cellpadding=1 cellspacing=1 border=0">
  <tr><td width=10>&nbsp;</td><td>
  <table cellpadding=0 cellspacing=0 border=0>
  <tr><td rowspan=2>&nbsp;
      <select multiple size="6" name="parent<%=i%>">
      <%=com.websina.util.ListMaker.makeOptionList(conf.getField(childFieldName, parentFieldName, parentOptions[i]).getValue()) %>
      </select>&nbsp;</td>
      <td><input type="button" class="button" value=" Up " onClick="Up(this.form.parent<%=i%>)"></td></tr>
  <tr><td><input type="button" class="button" value=" Dn " onClick="Down(this.form.parent<%=i%>)"></td></tr>
  </table><td width=36>&nbsp;</td><td>
  </td></tr>
</table>
</td>
<td align=center>
<table><tr><td width=36>&nbsp;</td><td>
       <td><input type="button" class="button" value="&lt;&lt; <%=HtmlParser.escapeQuotation(label.get("add_button"))%>" onClick="add(this.form.parent<%=i%>Add,this.form.parent<%=i%>)">
          &nbsp;<input type="text" name="parent<%=i%>Add" size=24 maxlength=50>
          <br>
          <input type="button" class="button" value="<%=HtmlParser.escapeQuotation(label.get("remove_button"))%>" onclick="remove(this.form.parent<%=i%>)">
  </td><td width=10>&nbsp;</td><td></tr>
</table>
</td></tr>
<% } %>
<%--/// the save/reset buttons ///--%>
<tr><td colspan=2>
<table width=100% border=0><tr><td align=center>
<input type="button" class="button" value="<%=label.get("save_button")%>"
onClick="<% for (int i=0; i<parentOptions.length; i++) { %>
selectAll(this.form.parent<%=i%>);<% } %> 
this.disabled=true; submit()">
<input type="button" class="button" value="<%=label.get("reset_button")%>"
onClick="location.href='fields.jsp?projectId=<%=projectId%>&childField=<%=childFieldName%>&parentField=<%=parentFieldName%>'">
</td><td width=30>
<a href="project.jsp?projectId=<%=projectId%>"><img src="../img/back.jpg" border=0 title="<%=label.get("back_button")%>"></a>
</td></tr></table>
</td></tr>

<!--/// two parents///-->
<% } else if (parentField != null && parent2Field != null) { %>
<tr class="header"><td colspan=<%=(parent2Options.length + 1)%> align=center>
<font color="#ffffff"><b>
<%=childFieldName%> (<%=childField.getLabel()%>) on <%=parentFieldName%> (<%=parentField.getLabel()%>) and <%=parent2FieldName%> (<%=parent2Field.getLabel()%>)
</b></font>
</td></tr>
<tr><td class="f1">
<table cellpadding=0 cellspacing=0 border=0 width=100%>
<tr><td>&nbsp;</td><td style="font-size:13px;text-align:right;background:ffffff;"><i>&nbsp;<%=parent2Field.getLabel()%></i></td></tr>
<tr><td style="font-size:13px;background:ffffff;"><i><%=parentField.getLabel()%>&nbsp;&nbsp;</i></td><td>&nbsp;</td></tr></table></td>
<% for (int j=0; j<parent2Options.length; j++) { %>
<td class="e8" align=center><%=parent2Options[j]%></td>
<% } %>
</tr>
<% for (int i=0; i<parentOptions.length; i++) { %>
<tr><td class="e8"><%=parentOptions[i]%></td>
<% for (int j=0; j<parent2Options.length; j++) { 
   com.websina.util.Field f = conf.getField(childFieldName, parentFieldName, parentOptions[i], parent2FieldName, parent2Options[j], true);
%>
<td class="e8" align=center>  
<input type="text" name="parent<%=i%>_<%=j%>" value="<%=HtmlParser.escapeQuotation(StringUtil.makeString(f.getValue(), ";"))%>">
</td>
<% } %>
</tr>
<% } %>
<%--/// the save/reset buttons ///--%>
<tr><td colspan=<%=(parent2Options.length + 1)%>>
<table width=100% border=0><tr><td align=center>
<input type="button" class="button" value="<%=label.get("save_button")%>"
onClick="this.disabled=true; submit()">
<input type="button" class="button" value="<%=label.get("reset_button")%>"
onClick="location.href='fields.jsp?projectId=<%=projectId%>&childField=<%=childFieldName%>&parentField=<%=parentFieldName%>&parent2Field=<%=parent2FieldName%>'">
</td><td width=30>
<a href="project.jsp?projectId=<%=projectId%>"><img src="../img/back.jpg" border=0 title="<%=label.get("back_button")%>"></a>
</td></tr></table>
</td></tr>
<% } %>
</table>
</form>
<% } %>
<%-- end of editing field dependency --%>
</center>
<%com.websina.servlet.JspUtil.include(application, request, response, out, "/jsp/customizable/footer.html");%>
</body>
</html>