<%@ page
    import="com.websina.bean.*,com.websina.util.*"
%>
<html>
<head>
<title>Project Configuration</title>
<script type="text/javascript" src="../script/utils.js"></script>
<script type="text/javascript" src="script/item_mover.js"></script>
</head>
<body topmargin=0>
<%@ include file="_header.jspf" %>
<%      
  int CUSTOM_FIELDS = Project.getTotalCustomFields();
  int CUSTOM_AUDIT_FIELDS = Project.getTotalCustomAuditFields();
  String msg = com.websina.servlet.SessionUtil.getMessage(session, request);
  String mainTitle = label.get("admin_project");
  String subTitle = ""; 
  Project conf = null;
  if (projectId != null && projectId.trim().length()>0) {
    conf = Project.getInstance(projectId);
    mainTitle += ": ";
    subTitle = admin.getProjectDisplay(projectId);
  }
  String requiredMark = "<font color=red>*</font>";
  String checkboxLabel = HtmlParser.escapeQuotation(label.get("admin_project_checkbox_required"));
  String defaultFieldLabel = HtmlParser.escapeQuotation(label.get("admin_project_field_default"));
  String datatypeFieldLabel = HtmlParser.escapeQuotation(label.get("admin_project_datatype"));
  String tmp; 
%>

<center>
<%-- the title part --%>
<form style="margin-top:10px;">
<table cellpadding=0 cellspacing=0 width="100%" border=0>
<% if (!isAdmin) { %>
  <tr><td align=right><font color="#000000"><b><%=label.get("project_label")%></b></font>&nbsp;
     <select name="project" 
        style="font-size:14px;"
        onChange="location.href='project.jsp?projectId='+form.project.options[form.project.selectedIndex].value;">
        <%=ListMaker.makeOptionList(admin.getProjects(), currentProject) %>
        </select>
      <input type="button" class="button" value=" <%=label.get("edit_button")%> " 
      onClick="location.href='project.jsp?projectId='+form.project.options[form.project.selectedIndex].value;">
  </td></tr>
<% } %>
  <tr class="f1"><td align=center height=30><font size=+1><b><%=mainTitle%></b></font>
  &nbsp;<font color="#cccc00"><b><%=subTitle%></b></font>
  </td></tr>
</table>
</form>
<p>
<%=com.websina.servlet.ServletUtil.formatMessage(msg)%>

<% if (conf == null) {
   if (msg == null) { // for instruction only %>
<table>
<% if (isAdmin) { %>
<tr><td>
<%=label.get("admin_project_intro")%>
</td></tr>
<% } %>
<tr><td height=320 valign=top>
<%=label.get("admin_common_intro")%>
<% if (isAdmin) { %>
<%=label.get("admin_project_remove")%>
<% } %>
</td></tr>
</table>
<% }} else if (conf.getInitError() != null) { %>
<%=com.websina.servlet.ServletUtil.formatMessage(conf.getInitError().getMessage(), "red")%>

<% } else { //if a project is loaded for editing %>
<p>
<table bgcolor="#ffffff" cellpadding=0 cellspacing=0 border=0 width=95%>
<tr><td>
<%=label.get("admin_project_text")%>
</td></tr>
<tr><td align=center valign=bottom height=50>
<form name="projectCopy" method="post" action="<%=contextPath%>/servlet/project">
<input type="hidden" name="token" value='<%=com.websina.servlet.SessionUtil.getToken(session)%>'>
<input type="hidden" name="action" value="clone">
<input type="hidden" name="projectId" value="<%=projectId%>">
<% if (!conf.isPersisted()) { %>
<%=label.get("admin_project_clone")%>
<input type="text" name="clone_project" size=16 maxlength=20>
<input type="submit" value="Go">
<% } else if (!conf.isActive()) { %>
<%=label.get("admin_project_status")%>
<input type="button" class="button" value="<%=label.get("activate_button")%>"
onClick="this.form.action.value='activate'; submit()">
<% } else if (conf.isPersisted()) { %>
<%=label.get("admin_project_status")%>
<input type="button" class="button" value="<%=label.get("deactivate_button")%>"
onClick="this.form.action.value='deactivate'; submit()">
&nbsp;&nbsp;
<input type="button" class="button" value="<%=label.get("reload_button")%>"
onClick="this.form.action.value='reload'; submit()">
&nbsp;&nbsp;&nbsp;<a href="fieldedit.jsp?projectId=<%=projectId%>"><%=label.get("admin_field_edit")%></a>
<% } %>
</form>
</td></tr>
</table> 

<form name="projectForm" method="post" action="<%=contextPath%>/servlet/project" onsubmit="return false;">
<input type="hidden" name="token" value='<%=com.websina.servlet.SessionUtil.getToken(session)%>'>
<input type="hidden" name="action">
<input type="hidden" name="projectId" value="<%=projectId%>">

<table cellpadding=2 cellspacing=1 border=0 class="box">
<tr class="e8"><td>
<b><%=label.get("admin_project_name")%><%=requiredMark%> &nbsp;</b>
</td><td>
<input type="text" name="projectName" value="<%=conf.getName()%>" size=30 maxlength=255>
&nbsp;&nbsp;&nbsp;&nbsp;
<input type="checkbox" name="isPublic" value="public" <%=conf.isPublic()? "checked":""%>>
<%=label.get("admin_project_public")%>
</td></tr>

<%-- the project description --%>
<tr class="f1"><td valign=top><%=label.get("admin_project_description")%></td>
<td><textarea name=projectDesc rows=8 cols=77 style="overflow: auto;">
<%=HtmlParser.escapeTag(conf.getDesc())%></textarea>
</td></tr>

<%-- the project reference Url --%>
<tr class="e8"><td><%=label.get("admin_project_referenceURL")%></td>
<td><input type="text" name="projectUrl" value="<%=HtmlParser.escapeQuotation(conf.getUrl())%>" size=100 maxlength=255>
</td></tr>

<%-- the project starting serial number --%>
<tr class="f1"><td><%=label.get("admin_project_ssn")%></td>
<td><input type="text" name="ssn" value="<%=(1 + conf.getSSN())%>" size=6 maxlength=9>
&nbsp;<%=label.get("admin_project_ssn_note")%>
</td></tr>

<%-- no email notification --%>
<tr class="f1"><td><%=label.get("no_email")%></td>
<td>&nbsp;<input type="checkbox" name="no_email_notification" value="Y" <%=conf.isNoEmailByDefault()? "checked":""%>>
</td></tr>

<%-- project group --%>
<tr class="f1"><td><%=label.get("admin_project_group")%></td>
<td><input type="text" name="projectGroup" value="<%=HtmlParser.escapeQuotation(conf.getGroup())%>" size=30 maxlength=255>
</td></tr>

<%-- project type --%>
<tr class="f1"><td><%=label.get("admin_routing_checkbox_label")%></td>
<td>&nbsp;<input type="checkbox" name="projectType" value="2" <%=conf.isReferenceType()? "checked":""%>
<% if (conf.isPersisted() == false) {%>onclick="this.form.action.value='settype';submit()"<%}%>>
&nbsp;&nbsp;<%=label.get("admin_routing_checkbox_desc")%>
</td></tr>

</table>
<p>

<table cellpadding=2 cellspacing=1 border=0>

<tr class="header"><td colspan=3 align=center>
<font color="#ffffff"><b><%=label.get("admin_project_accesscode")%></b></font>
</td></tr>
<tr class="f1"><td colspan=3>
<font size="-1"><b><%=label.get("admin_project_user_based_access")%></b></font>
<% if (conf.isPersisted()) { %> <a href="role.jsp?projectId=<%=projectId%>"><%=label.get("admin_role_link")%></a><%}%>
</td></tr>
<tr><td class="e8" colspan=3 align=center>
<table cellpadding=2 cellspacing=0 border=0 width="100%">
<tr>
<td rowspan=6 align=center valign=center>
<%=label.get("admin_project_available_users")%><br>
<select multiple size="12" name="user_src">
   <%=ListMaker.makeOptionList(admin.getAvailableUsers(conf), null) %>
</select></td>
<td align=center width=80>
<input type="button" class="button" value="  >>  " onclick="move(this.form.user_src,this.form.user_view)"><br>
<input type="button" class="button" value="  <<  " onclick="move(this.form.user_view,this.form.user_src)">
</td>
<td align=center>
<select multiple size="3" name="user_view">
   <%=ListMaker.makeOptionList(admin.getUsers(conf, "view"), null) %>
</select></td>
<td valigh=center><b>view:</b> <em>limited to<br>view only</em></td></tr>
<tr>
<td align=center width=80>
<input type="button" class="button" value="  >>  " onclick="move(this.form.user_src,this.form.user_edit)"><br>
<input type="button" class="button" value="  <<  " onclick="move(this.form.user_edit,this.form.user_src)">
</td>
<td align=center>
<select multiple size="5" name="user_edit">
   <%=ListMaker.makeOptionList(admin.getUsers(conf, "edit"), null) %>
</select></td>
<td valigh=center><b>edit:</b> <em>full access,<br>view, submit, and edit</em></td>
</tr>

<tr>
<td align=center width=80>
<input type="button" class="button" value="  >>  " onclick="move(this.form.user_src,this.form.user_editasgn)"><br>
<input type="button" class="button" value="  <<  " onclick="move(this.form.user_editasgn,this.form.user_src)">
</td>
<td align=center>
<select multiple size="3" name="user_editasgn">
   <%=ListMaker.makeOptionList(admin.getUsers(conf, "editasgn"), null) %>
</select></td>
<td valigh=center><b>editasgn:</b> <em>full access, but can<br>only edit currently assigned</em></td>
</tr>
<tr>
<td align=center width=80>
<input type="button" class="button" value="  >>  " onclick="move(this.form.user_src,this.form.user_editown)"><br>
<input type="button" class="button" value="  <<  " onclick="move(this.form.user_editown,this.form.user_src)">
</td>
<td align=center>
<select multiple size="3" name="user_editown">
   <%=ListMaker.makeOptionList(admin.getUsers(conf, "edit own"), null) %>
</select></td>
<td valigh=center><b>edit own:</b> <em>full access, but can<br>only edit originally authored</em></td>
</tr>
<tr>
<td align=center width=80>
<input type="button" class="button" value="  >>  " onclick="move(this.form.user_src,this.form.user_editboth)"><br>
<input type="button" class="button" value="  <<  " onclick="move(this.form.user_editboth,this.form.user_src)">
</td>
<td align=center>
<select multiple size="3" name="user_editboth">
   <%=ListMaker.makeOptionList(admin.getUsers(conf, "editboth"), null) %>
</select></td>
<td valigh=center><b>editboth:</b> <em>full access, but can<br>only edit originally authored<br>or currently assigned</em></td>
</tr>
<tr>
<td align=center width=80>
<input type="button" class="button" value="  >>  " onclick="move(this.form.user_src,this.form.user_submit)"><br>
<input type="button" class="button" value="  <<  " onclick="move(this.form.user_submit,this.form.user_src)">
</td>
<td align=center>
<select multiple size="3" name="user_submit">
   <%=ListMaker.makeOptionList(admin.getUsers(conf, "submit"), null) %>
</select></td>
<td valigh=center><b>submit:</b> <em>limited to<br>submit new only</em></td>
</tr>
</table>
</td></tr>

<tr class="f1"><td colspan=3>
<font size="-1"><b><%=label.get("admin_project_group_based_access")%></b></font>
</td></tr>
<tr><td class="e8" colspan=3 align=center>
<table cellpadding=2 cellspacing=0 border=0 width="100%">
<tr>
<td rowspan=6 align=center valign=center>
<%=label.get("admin_project_available_groups")%><br>

<select multiple size="12" name="group_src">
   <%=ListMaker.makeOptionList(admin.getAvailableGroups(conf), null) %>
</select></td>
<td align=center width=80>
<input type="button" class="button" value="  >>  " onclick="move(this.form.group_src,this.form.group_view)"><br>
<input type="button" class="button" value="  <<  " onclick="move(this.form.group_view,this.form.group_src)">
</td>
<td align=center>
<select multiple size="3" name="group_view">
   <%=ListMaker.makeOptionList(admin.getGroups(conf, "view"), null) %>
</select></td>
<td valigh=center><b>view:</b> <em>limited to<br>view only</em></td></tr>
<tr>
<td align=center width=80>
<input type="button" class="button" value="  >>  " onclick="move(this.form.group_src,this.form.group_edit)"><br>
<input type="button" class="button" value="  <<  " onclick="move(this.form.group_edit,this.form.group_src)">
</td>
<td align=center>
<select multiple size="5" name="group_edit">
   <%=ListMaker.makeOptionList(admin.getGroups(conf, "edit"), null) %>
</select></td>
<td valigh=center><b>edit:</b> <em>full access,<br>view, submit, and edit</em></td>
</tr>
<tr>
<td align=center width=80>
<input type="button" class="button" value="  >>  " onclick="move(this.form.group_src,this.form.group_editasgn)"><br>
<input type="button" class="button" value="  <<  " onclick="move(this.form.group_editasgn,this.form.group_src)">
</td>
<td align=center>
<select multiple size="3" name="group_editasgn">
   <%=ListMaker.makeOptionList(admin.getGroups(conf, "editasgn"), null) %>
</select></td>
<td valigh=center><b>editasgn:</b> <em>full access, but can<br>only edit currently assigned</em></td>
</tr>
<tr>
<td align=center width=80>
<input type="button" class="button" value="  >>  " onclick="move(this.form.group_src,this.form.group_editown)"><br>
<input type="button" class="button" value="  <<  " onclick="move(this.form.group_editown,this.form.group_src)">
</td>
<td align=center>
<select multiple size="3" name="group_editown">
   <%=ListMaker.makeOptionList(admin.getGroups(conf, "edit own"), null) %>
</select></td>
<td valigh=center><b>edit own:</b> <em>full access, but can<br>only edit originally authored</em></td>
</tr>
<td align=center width=80>
<input type="button" class="button" value="  >>  " onclick="move(this.form.group_src,this.form.group_editboth)"><br>
<input type="button" class="button" value="  <<  " onclick="move(this.form.group_editboth,this.form.group_src)">
</td>
<td align=center>
<select multiple size="3" name="group_editboth">
   <%=ListMaker.makeOptionList(admin.getGroups(conf, "editboth"), null) %>
</select></td>
<td valigh=center><b>editboth:</b> <em>full access, but can<br>only edit originally authored<br>or currently assigned</em></td>
</tr>
<tr>
<td align=center width=80>
<input type="button" class="button" value="  >>  " onclick="move(this.form.group_src,this.form.group_submit)"><br>
<input type="button" class="button" value="  <<  " onclick="move(this.form.group_submit,this.form.group_src)">
</td>
<td align=center>
<select multiple size="3" name="group_submit">
   <%=ListMaker.makeOptionList(admin.getGroups(conf, "submit"), null) %>
</select></td>
<td valigh=center><b>submit:</b> <em>limited to<br>submit new only</em></td>
</tr>
</table>
</td></tr>

<%-- project fields --%>
<tr class="header"><td colspan=3 align=center>
<font color="#ffffff"><b><%=label.get("admin_project_fields")%></b></font>
</td></tr>

<tr class="f1"><td align=center height=40>
synopsis:<%=requiredMark%>&nbsp;&nbsp;<input type="text" name="synopsis_label" value="<%=HtmlParser.escapeQuotation(label.get("synopsis", projectId))%>" size=20 maxlength=50>
</td><td colspan=2>
<%=label.get("admin_project_field_synopsis")%>
</td></tr>

<% for (int i=0; i<CUSTOM_FIELDS; i++) { 
   String fieldName = "field_" + i;
   String color = ((i/2)*2 == i)? "f1" : "e8";
   if (com.websina.bean.FieldID.isTextAreaCustomField(i) == false) {
%>
<%=ItemMover.make(label, conf.getField(fieldName), conf.isFieldMandatory(fieldName), null, HtmlParser.escapeQuotation(label.get(fieldName, projectId)), true, color, conf.getFieldMaxLength(fieldName), admin.getProjects(), conf.getAvailableFieldParents(fieldName), conf.getFieldParent(fieldName), conf.getFieldParent2(fieldName), projectId)%>
<% } else { // the text area part 
%>
<tr><td class="<%=color%>" align=center height=88>
  <%=fieldName%>:&nbsp;
  <input type="text" name="<%=fieldName%>_label" size=20 maxlength=200 value="<%=HtmlParser.escapeQuotation(label.get(fieldName, projectId))%>"> 
<p>
    <font size="-1">TextArea Rows:</font>&nbsp;
    <input type="text" name="<%=fieldName%>_maxlength" value="<%=(conf.getFieldMaxLength(fieldName)==0)?"":Integer.toString(conf.getFieldMaxLength(fieldName))%>" size=2 maxlength=2>
    <font size="-1">(default to 8)</font>
</td><td class="<%=color%>" colspan=2>
<%=label.get("admin_project_field_textarea")%>
<input type="checkbox" name="<%=fieldName%>Type" value="2" <%=conf.isFieldEnabled(fieldName)?"checked":""%>> 
&nbsp;&nbsp;<%=label.get("admin_project_field_textarea2")%>
<input type="checkbox" name="<%=fieldName%>_required" value="Y" <%=(conf.isFieldEnabled(fieldName) && conf.isFieldMandatory(fieldName))?"checked":""%>>
</td></tr>
<% }}%>

<%-- The Bcc field --%>
<% if (conf.isReferenceType() == false && com.websina.bean.AppContext.getEnableBccMail()) { %>
<tr class="e8"><td align=center height=88>
Bcc:&nbsp;&nbsp;<input type="text" name="bcc_mail_label" value="<%=HtmlParser.escapeQuotation(label.get("bcc_mail", projectId))%>" size=20 maxlength=50><br>
<font size="-1">Default (optional)</font>:&nbsp;
  <input type="text" name="bcc_mail_default" value="<%=HtmlParser.escapeQuotation(conf.getField("bcc_mail").getRawDefault())%>" size=24 maxlength=230> 
</td><td colspan=2>
<%=label.get("admin_project_field_bcc")%>
<input type="checkbox" name="bcc_mailType" value="1" <%=conf.isFieldEnabled("bcc_mail")?"checked":""%>> 
</td></tr>
<% } %>

<%-- Tracked fields --%>
<tr class="header"><td colspan=3 align=center>
<font color="#ffffff"><b><%=label.get("admin_project_tracked")%></b></font><br>
</td></tr>

<tr class="e8"><td align=center height=88>
description:<%=requiredMark%>&nbsp;&nbsp;<input type="text" name="detail_label" value="<%=HtmlParser.escapeQuotation(label.get("detail", projectId))%>" size=20 maxlength=50>
<p>
    <font size="-1">TextArea Rows:</font>&nbsp;
    <input type="text" name="detail_maxlength" value="<%=(conf.getFieldMaxLength("detail")==0)?"":Integer.toString(conf.getFieldMaxLength("detail"))%>" size=2 maxlength=2>
    <font size="-1">(default to 10)</font>
<br>
<font size="-1">Default (optional)</font>:&nbsp;
  <input type="text" name="detail_default" value="<%=HtmlParser.escapeQuotation(conf.getField("detail").getRawDefault())%>" size=24 maxlength=230> 
</td><td colspan=2>
<%=label.get("admin_project_field_description")%>
<p>Additional labeling of the field (or use a space to remove):<br>
<textarea name="detail_notes_label" rows=2 cols=48><%=HtmlParser.escapeQuotation(label.get("detail_notes", projectId))%></textarea>
</td></tr>

<tr class="f1"><td align=right height=36>
response:<%=requiredMark%>&nbsp;&nbsp;<input type="text" name="response_label" value="<%=HtmlParser.escapeQuotation(label.get("response", projectId))%>" size=20 maxlength=50>
&nbsp;<%=checkboxLabel%> <input type="checkbox" name="response_required" value="Y" <%=conf.isFieldMandatory("response")?"checked":""%>>
<br>Additional labeling of the field:&nbsp;
</td><td colspan=2>
<%=label.get("admin_project_field_response")%>
<br>
<textarea name="response_notes_label" rows=2 cols=48><%=HtmlParser.escapeQuotation(label.get("response_notes", projectId))%></textarea>
</td></tr>

<tr class="e8"><td align=center  height=88>
cc_mail:<%=requiredMark%>&nbsp;&nbsp;<input type="text" name="cc_mail_label" value="<%=HtmlParser.escapeQuotation(label.get("cc_mail", projectId))%>" size=20 maxlength=50>
<p>
    <font size="-1">Dropdown size:</font>&nbsp;
    <input type="text" name="cc_mail_maxlength" value="<%=(conf.getFieldMaxLength("cc_mail")==0)?"":Integer.toString(conf.getFieldMaxLength("cc_mail"))%>" size=2 maxlength=2>
    <font size="-1">(default to 5)</font>
</td><td colspan=2>
<%=label.get("admin_project_field_cc")%>
</td></tr>

<%-- custom audit fields --%>
<% for (int i=1; i<=CUSTOM_AUDIT_FIELDS; i++) { 
   String fieldName = "audit_" + i;
   String color = ((i/2)*2 == i)? "f1" : "e8";
   if (com.websina.bean.FieldID.isTextAreaAuditField(i) == false) {
     String options=ItemMover.make(label, conf.getField(fieldName), conf.isFieldMandatory(fieldName), null, HtmlParser.escapeQuotation(label.get(fieldName, projectId)), true, color, conf.getFieldMaxLength(fieldName), admin.getProjects(), conf.getAvailableFieldParents(fieldName), conf.getFieldParent(fieldName), conf.getFieldParent2(fieldName), projectId);
     options = com.websina.util.StringUtil.replace(options, "<option value=\"7\">Project</option>", "");
%>
<%=options%>
<% } else { // the text area part
%>
<tr><td class="<%=color%>" align=center height=36>
  <%=fieldName%>:&nbsp;
  <input type="text" name="<%=fieldName%>_label" size=20 maxlength=200 value="<%=HtmlParser.escapeQuotation(label.get(fieldName, projectId))%>"> 
</td><td class="<%=color%>" colspan=2>
<%=label.get("admin_project_field_textarea")%>
<input type="checkbox" name="<%=fieldName%>Type" value="2" <%=conf.isFieldEnabled(fieldName)?"checked":""%>> 
&nbsp;&nbsp;<%=label.get("admin_project_field_textarea2")%>
<input type="checkbox" name="<%=fieldName%>_required" value="Y" <%=(conf.isFieldEnabled(fieldName) && conf.isFieldMandatory(fieldName))?"checked":""%>>
</td></tr>
<% }}%>


<%-- the category part --%>
<%=ItemMover.make(label, conf.getField("category"), conf.isFieldMandatory("category"), null, HtmlParser.escapeQuotation(label.get("category", projectId)), false, "f1")%>

<%-- the severity part --%>
<%=ItemMover.make(label, conf.getField("severity"), conf.isFieldMandatory("severity"), null, HtmlParser.escapeQuotation(label.get("severity", projectId)), false, "e8")%>

<%-- the priority part --%>
<%=ItemMover.make(label, conf.getField("priority"), conf.isFieldMandatory("priority"), null, HtmlParser.escapeQuotation(label.get("priority", projectId)), false, "f1")%>

<%-- the state part --%>
<tr class="e8">
<td align=center>
<table cellpadding=1 cellspacing=1 border=0">
  <tr><td>state:<%=requiredMark%>&nbsp;
  <input type="text" name="state_label" size=20 maxlength=255
  value="<%=HtmlParser.escapeQuotation(label.get("state", projectId))%>"> 
  &nbsp;</td></tr>
  <tr><td>
  <table cellpadding=0 cellspacing=0 border=0>
  <tr><td rowspan=2>&nbsp;
      <select multiple size="6" name="state">
      <%=ListMaker.makeOptionList(conf.getField("state").getValue()) %>
      </select>&nbsp;</td>
      <td><input type="button" class="button" value=" Up " onClick="Up(this.form.state)"></td></tr>
  <tr><td><input type="button" class="button" value=" Dn " onClick="Down(this.form.state)"></td></tr>
  </table>
  </td></tr>
  <tr><td height=40 valign=top><%=HtmlParser.escapeQuotation(label.get("admin_project_closed_state"))%>:&nbsp;
  <input type="text" name="closed_state" value="<%=HtmlParser.escapeQuotation(conf.getClosedState())%>" size=24 maxlength=200>
  </td></tr>
</table>
</td>
<td colspan=2 align=center>
<table>
  <tr><td><input type="button" class="button" value="&lt;&lt; <%=HtmlParser.escapeQuotation(label.get("add_button"))%>" onClick="add(this.form.stateAdd,this.form.state)">
          &nbsp;<input type="text" name="stateAdd" size=20 maxlength=50>
          <br>
          <input type="button" class="button" value="<%=HtmlParser.escapeQuotation(label.get("remove_button"))%>" onclick="remove(this.form.state)">
  </td></tr>
</table>
<table width="100%"><tr><td><%=label.get("admin_project_field_state")%>
</td></tr></table>
</td></tr>
<%-- end of state section --%>

<%-- Other field labeling --%>
<tr class="header"><td colspan=3 align=center>
<font color="#ffffff"><b><%=label.get("admin_project_labels")%></b></font>
</td></tr>
<tr class="e8"><td colspan=3 align=center>
ID: &nbsp;&nbsp;<input type="text" name="entryId_label" value="<%=HtmlParser.escapeQuotation(label.get("entryId", projectId))%>" size=20 maxlength=50>
</td></tr>
<tr class="f1"><td colspan=3 align=center>
Responsible: &nbsp;&nbsp;<input type="text" name="responsible_label" value="<%=HtmlParser.escapeQuotation(label.get("responsible", projectId))%>" size=20 maxlength=50>
&nbsp;<%=checkboxLabel%> <input type="checkbox" name="responsible_required" value="Y" <%=conf.isFieldMandatory("responsible")?"checked":""%>>
&nbsp; &nbsp; &nbsp;<%=label.get("admin_project_enable_no_email")%>&nbsp;<input type="checkbox" name="responsible_noEmailFlag" value="Y" <%=conf.getField("responsible").getEnableNoEmailToResponsible()?"checked":""%>>
</td></tr>
<tr class="e8"><td colspan=3 align=center>
Original Author: &nbsp;&nbsp;<input type="text" name="author_label" value="<%=HtmlParser.escapeQuotation(label.get("author", projectId))%>" size=20 maxlength=50>
</td></tr>
<tr class="e8"><td colspan=3 align=center>
Last Modified By (editor): &nbsp;&nbsp;<input type="text" name="editor_label" value="<%=HtmlParser.escapeQuotation(label.get("editor", projectId))%>" size=20 maxlength=50>
</td></tr>
<tr class="f1"><td colspan=3 align=center>
Attachment: &nbsp;&nbsp;<input type="text" name="attachment_label" value="<%=HtmlParser.escapeQuotation(label.get("attachment", projectId))%>" size=20 maxlength=50>
</td></tr>
<tr class="f1"><td colspan=3 align=center>
Original Author Group: &nbsp;&nbsp;<input type="text" name="original_author_group_label" value="<%=HtmlParser.escapeQuotation(label.get("original_author_group", projectId))%>" size=20 maxlength=50>
</td></tr>

<%-- finally the save/cancel buttons --%>
<tr><td bgcolor="#ffffff" colspan=3 height=50 valign=bottom>
<%=requiredMark%><%=label.get("admin_project_note")%></td></tr>
<tr><td class="f1" colspan=3 align=center height=30>
<input type="button" class="button" value="<%=label.get("save_button")%>" onClick="this.form.action.value='save'; 
if(isEmpty(this.form.closed_state,'<%=label.getEscaped("admin_project_closed_state")%> is empty'))return false;
if(!isAdded(this.form.state,this.form.closed_state.value,'<%=label.getEscaped("admin_project_closed_state")%> is not added in state (<%=label.getEscaped("state", projectId)%>)')) return false;
if(this.form.state.length<2){alert('At least two state (<%=label.getEscaped("state", projectId)%>) are required'); return false;}
if(!selectAllRequired(this.form.state,'state (<%=label.getEscaped("state", projectId)%>) is a required field')) return false;

selectAll(this.form.category);selectAll(this.form.severity);selectAll(this.form.priority);

<% for (int i=0; i<CUSTOM_FIELDS; i++) {if (com.websina.bean.FieldID.isTextAreaCustomField(i) == false) { %>
selectAll(this.form.field_<%=i%>);
<% }} %>
<% for (int i=1; i<=CUSTOM_AUDIT_FIELDS; i++) {if (com.websina.bean.FieldID.isTextAreaAuditField(i) == false) {%>
selectAll(this.form.audit_<%=i%>);
<% }} %>
selectAll(this.form.user_view);selectAll(this.form.user_edit);
selectAll(this.form.group_view);selectAll(this.form.group_edit);
selectAll(this.form.user_editasgn);selectAll(this.form.user_submit);selectAll(this.form.user_editown);selectAll(this.form.user_editboth);
selectAll(this.form.group_editasgn);selectAll(this.form.group_submit);selectAll(this.form.group_editown);selectAll(this.form.group_editboth);
this.disabled=true; submit();">
<input type="button" class="button" value="<%=label.get("cancel_button")%>" onClick="if(<%=conf.isPersisted()%>) 
{location.href='project.jsp?currentProject=<%=projectId%>';} else 
{this.form.action.value='cancel'; submit();}">

</td></tr>
</table>
</form>
<%-- end of editing project --%>
<% } %>
</center>
<%com.websina.servlet.JspUtil.include(application, request, response, out, "/jsp/customizable/footer.html");%>
</body>
</html>