<%@ page
    import="com.websina.bean.*,com.websina.util.*"
%>
<html>
<head><title>Reminder and Escalation</title>
<script type="text/javascript" src="../script/utils.js"></script>
<script type="text/javascript" src="../script/ajax.js"></script>
<script type="text/javascript" src="../script/trigger.js"></script>
</head>
<body topmargin=0>
<%@ include file="_header.jspf" %>
<%      
  String title = label.get("admin_reminder");
  Reminder[] triggers = Reminder.loadAll();
  String name = request.getParameter("name");
  String action = request.getParameter("action");
  if (action == null) {
    action = "";
  } else if (action.equals("create") && name != null) {
    for (int i=0; i<triggers.length; i++) {
      Reminder rmd = triggers[i];
      if (name.equalsIgnoreCase(rmd.getName()) && rmd.getProject().equals(projectId)) {
         action = "edit";
         name = rmd.getName();
         break;
      }
    }
  }
%>
<center>
<%-- the title part --%>
<table cellpadding=0 cellspacing=0 border=0>
  <tr><td>&nbsp;</td></tr>
  <tr><td align=center height=30><font size=+1><b><%=title%></b></font></td></tr>
</table>

<table bgcolor="#ffffff" cellpadding=0 cellspacing=0 border=0 width=95%>
<tr><td>
<%=label.get("admin_reminder_text")%>
<tr><td>
&nbsp;
</td></tr>
</table> 

<%=com.websina.servlet.ServletUtil.formatMessage(com.websina.servlet.SessionUtil.getMessage(session, request))%>
<p>
<form name="rmdForm" method="post" action="<%=contextPath%>/servlet/reminder" onSubmit="return false;">
<input type="hidden" name="token" value='<%=com.websina.servlet.SessionUtil.getToken(session)%>'>
<input type="hidden" name="action" value="<%=action%>">
<input type="hidden" name="name" value="<%=name%>">
<input type="hidden" name="projectId" value="<%=projectId%>">

<%-- the trigger list part --%>
<% if (triggers.length > 0) { %>
<table cellpadding=2 cellspacing=1 border=0 class="box">
<tr class="header"><td colspan=2>
<%=label.get("admin_reminder_current")%> 
</td></tr>
<% for (int i=0; i<triggers.length; i++) { 
    Reminder rmd = triggers[i]; %>
<tr><td class="e8"><%=admin.getProjectDisplay(rmd.getProject())%>: <%=com.websina.util.HtmlParser.sanitizeOut(rmd.getName())%> &nbsp;&nbsp;</td>
<td align=center class="f1">
<nobr>
<input class="button" type="button" value="<%=label.get("edit_button")%>" 
onClick="location.href='reminder.jsp?action=edit&projectId=<%=rmd.getProject()%>&name='+<%=escape%>('<%=rmd.getName()%>');">
<input class="button" type="button" value="<%=label.get("delete_button")%>" 
onClick="if (confirm('<%=label.getEscaped("delete_confirmation")%>  <%=rmd.getName()%>/<%=rmd.getProject()%>')){
delete_reminder(rmdForm, '<%=rmd.getName()%>', '<%=rmd.getProject()%>');}">
</nobr>
</td></tr>
<% } %>
</table>
<p>
<% } %>

<% if (name == null || projectId == null) { %>
<table bgcolor="#ffffff" cellpadding=2 cellspacing=2 border=0>
<tr><td colspan=2><%=label.get("admin_reminder_add")%></td><td>
<tr><td><input type=text size=30 maxlength=255 name=new_name>
&nbsp;<select name="list">
       <%=ListMaker.makeOptionList(admin.getProjects(), null) %>
      </select></td>
<td><input class="button" type="button" value="<%=label.get("add_button")%>" 
onClick="if(isEmpty(rmdForm.new_name,'You need enter a name for the reminder'))return false;
location.href='reminder.jsp?action=create&projectId='+rmdForm.list.options[rmdForm.list.selectedIndex].value+'&name='+<%=escape%>(rmdForm.new_name.value);" <%=(admin.getProjects().isEmpty())?"disabled":""%>>
</td></tr></table>
<p style='height:220px'></p>
<% } else { 
  String[] optionList;
  Project conf = Project.getInstance(projectId);
  com.websina.util.Field field;
  Reminder trigger = new Reminder(projectId, name);
  trigger.load();
  int[] sdtArray = trigger.getSdtArray();
  int[] cdtArray = trigger.getCdtArray();
  int[] repeatArray = trigger.getRepeatIntervalArray();
  String actions = com.websina.util.StringUtil.makeString(trigger.getActions(), ";");
  String subject = null;
  String body = null;
  com.websina.mail.EmailTemplate rt = trigger.getEmailTemplate();
  if (rt != null && (rt.isDefault() && "edit".equals(action)) == false) {
    subject = rt.getSubject();
    body = rt.getBody();
  }
  com.websina.util.Field dateFields = admin.getDateFields(conf);
  com.websina.util.Field menuFields = admin.getCustomMenuFields(conf);
%>
<b><%=com.websina.util.HtmlParser.sanitizeOut(name)%> (<%=projectId%>)</b>
<p>
<table cellpadding=2 cellspacing=1 border=0 class="box">
<tr><td colspan=2><font size="-1" color="#555555"><b><%=label.get("admin_reminder_define")%></b></font>
</td></tr>
    <tr><td class="e8" height=36>
      <select name=sdt_name>
       <%=ListMaker.makeOptionList(new String[]{"last_modified", "arrived_date"}, new String[]{label.get("last_modified"), label.get("arrived_date")}, trigger.getSdtName()) %>
      </select><font color=red>*</font>
    </td><td class="f1">&nbsp;<%=label.get("admin_reminder_time_passed", projectId)%>&nbsp;
      <input type="text" name="sdt_d" value="<%=sdtArray[0]%>" size=2> days,&nbsp;&nbsp;
      <input type="text" name="sdt_hr" value="<%=sdtArray[1]%>" size=2> hours,&nbsp;&nbsp;
      <input type="text" name="sdt_m" value="<%=sdtArray[2]%>" size=2> minutes.&nbsp;&nbsp;
      <% if (com.websina.bean.Holiday.isEnabled()) { %> &nbsp;<%=label.get("query_skip")%> 
      <select name=sdt_holiday>
       <%=ListMaker.makeOptionList(new String[]{"0", "1", "2", "3"}, new String[]{"", label.get("query_weekends"), label.get("query_holidays"), label.get("query_weekends_holidays")}, String.valueOf(trigger.getSdtHolidayFlag())) %>
      </select> <% } %>
    </td></tr>
    <tr><td class="e8" height=36>
    <%=label.get("admin_reminder_repeat_interval")%>
    </td><td class="f1">
      <input type="text" name="repeat_d" value="<%=repeatArray[0]%>" size=2> days,&nbsp;&nbsp;
      <input type="text" name="repeat_hr" value="<%=repeatArray[1]%>" size=2> hours,&nbsp;&nbsp;
      <input type="text" name="repeat_m" value="<%=repeatArray[2]%>" size=2> minutes.&nbsp;&nbsp;
      <% if (com.websina.bean.Holiday.isEnabled()) { %> &nbsp;<%=label.get("query_skip")%> 
      <select name=repeat_holiday>
       <%=ListMaker.makeOptionList(new String[]{"0", "1", "2", "3"}, new String[]{"", label.get("query_weekends"), label.get("query_holidays"), label.get("query_weekends_holidays")}, String.valueOf(trigger.getRepeatHolidayFlag())) %>
      </select> <% } %>
    </td></tr>
  <% if (dateFields != null) { %>
    <tr><td class="e8" height=36>
      <select name=cdt_name>
       <%=ListMaker.makeOptionList(dateFields, trigger.getCdtName()) %>
      </select> 
    </td><td class="f1"><select name="cdt_time_flag"><%=com.websina.servlet.JspUtil.getReminderCdtOp(label, trigger.getCdtTimeFlag())%></select>
      <input type="text" name="cdt_d" value="<%=cdtArray[0]%>" size=2> days,&nbsp;&nbsp;
      <input type="text" name="cdt_hr" value="<%=cdtArray[1]%>" size=2> hours,&nbsp;&nbsp;
      <input type="text" name="cdt_m" value="<%=cdtArray[2]%>" size=2> minutes.&nbsp;&nbsp;
      <% if (com.websina.bean.Holiday.isEnabled()) { %> &nbsp;<%=label.get("query_skip")%> 
      <select name=cdt_holiday>
       <%=ListMaker.makeOptionList(new String[]{"0", "1", "2", "3"}, new String[]{"", label.get("query_weekends"), label.get("query_holidays"), label.get("query_weekends_holidays")}, String.valueOf(trigger.getCdtHolidayFlag())) %>
      </select> <% } %>
    </td></tr>
  <% } %>
  <% if (menuFields != null) {
       String cdmName = trigger.getCdmName(); String params = "projectId=" + projectId;
       if ("edit".equals(action) && name != null) params += "&name="+name; 
       if (cdmName == null) {cdmName = menuFields.getValue()[0];} else {params += ("&cs=" + cdmName);}%>
    <tr><td class="e8">
      <select name=cdm_name onChange="innerRefresh('<%=contextPath%>/servlet/reminder?<%=params%>&cdmName='+cdm_name.options[cdm_name.selectedIndex].value, 'cdmoptions');">
       <%=ListMaker.makeOptionList(menuFields, trigger.getCdmName()) %>
      </select> 
    <td class="f1"><div id="cdmoptions"><select name=cdm_value size=3 multiple>
        <%=ListMaker.makeOptionList(conf.getField(cdmName).getValue(), trigger.getCdmValue()) %>
        </select></div></td></tr>
  <% } %>
  <% if( conf.isFieldEnabled("author")) { %>
    <tr><td class="e8"><%=label.get("author", projectId)%></td>
    <td class="f1"><select name=author size=3 multiple> 
       <%=ListMaker.makeOptionList(conf.getAccess().getAuthors(true), trigger.getAuthor()) %>
        </select> </td></tr>
  <% } %>
  <% if (conf.isFieldEnabled("responsible")) { %>
    <tr><td class="e8"><%=label.get("responsible", projectId)%></td>
    <td class="f1"><select name=responsible size=3 multiple>
        <%=ListMaker.makeOptionList(conf.getAccess().getResponsibles(), trigger.getResponsible()) %>
        </select></td></tr>
  <% } %>
    <tr><td class="e8"><%=label.get("state", projectId)%></td>
    <td class="f1"><select name=state size=3 multiple>
        <%=ListMaker.makeOptionList(conf.getField("state").getValue(), trigger.getState()) %>
        </select></td></tr>
  <% if( conf.isFieldEnabled("category") && (field=conf.getField("category")) != null && (optionList=field.getValue()) != null) { %>
    <tr><td class="e8"><%=label.get("category", projectId)%></td>
    <td class="f1"><select name=category size=3 multiple> 
       <%=ListMaker.makeOptionList(optionList, trigger.getCategory()) %>
        </select> </td></tr>
  <% } %>
  <% if( conf.isFieldEnabled("severity") && (field=conf.getField("severity")) != null && (optionList=field.getValue()) != null) { %>
    <tr><td class="e8"><%=label.get("severity", projectId)%></td>
    <td class="f1"><select name=severity size=3 multiple>
        <%=ListMaker.makeOptionList(optionList, trigger.getSeverity()) %>
        </select></td></tr>
  <% } %>
  <% if( conf.isFieldEnabled("priority") && (field=conf.getField("priority")) != null && (optionList=field.getValue()) != null) { %>
    <tr><td class="e8"><%=label.get("priority", projectId)%></td>
    <td class="f1"><select name=priority size=3 multiple>
        <%=ListMaker.makeOptionList(optionList, trigger.getPriority()) %>
        </select></td></tr>
  <% } %>

    <tr><td colspan=2><font size="-1" color="#555555"><b><%=label.get("admin_reminder_action")%></b></font></td>
    <tr><td class="e8"><%=label.get("admin_reminder_email")%><font color=red>&#185;</font></td>
    <td class="f1">
      <input type="text" name="rmd_action" value="<%=HtmlParser.escapeQuotation(actions)%>" maxlength=255 style="width: 560px;"> 
    <tr><td class="e8"><%=label.get("admin_email_template_subject")%></td>
    <td class="f1"><input type="text" name="template_subject" 
        value="<%=HtmlParser.escapeQuotation(subject)%>" maxlength=255 style="width: 560px;"></td></tr>
    <tr><td class="e8"><%=label.get("admin_email_template_body")%></td>
    <td class="f1"><textarea name="template_body" rows=6 cols=60 style="width: 560px; overflow: auto;"><%=HtmlParser.escapeTag(body)%></textarea>
    </td></tr>

<tr><td colspan=2 align=center>
<input class="button" type="button" value="<%=label.get("save_button")%>"
onClick="
if(isEmpty(rmdForm.rmd_action, 'Field <%=label.get("admin_reminder_email")%> is required.'))return false;
if(!validEmailList2(rmdForm.rmd_action))return false;
this.disabled=true; submit();">
<input class="button" type="button" value="<%=label.get("cancel_button")%>"
onClick="location.href='reminder.jsp';">
</td></tr></table>
<p>
<table width=95%><tr><td>
<font color=red>&#185;</font>
<%=label.get("admin_reminder_note1")%>
</td></tr></table>
<% } %>
</form>
</center>
<%com.websina.servlet.JspUtil.include(application, request, response, out, "/jsp/customizable/footer.html");%>
</body>
</html>