<%@ page
    import="com.websina.bean.*,com.websina.util.*"
%>
<html>
<head>
<title>User Account Management</title>
<script type="text/javascript" src="../script/utils.js"></script>
<script type="text/javascript" src="../script/ajax.js"></script>
<script type="text/javascript" src="script/item_mover.js"></script>
</head>
<body topmargin=0>
<%@ include file="_header.jspf" %>
<%      
  String msg = com.websina.servlet.SessionUtil.getMessage(session, request);
  String mainTitle = label.get("admin_user"); 
  String username = request.getParameter("username");
  Person user = null;
  if (username != null) {
    user = ((SystemAdmin)admin).getPerson(username);
  }
  String passwordMark = "";
  String requiredMark = "<font color=red>*</font>";
%>
<center>

<%-- the title part --%>
<table bgcolor="#ffffff" cellpadding=0 cellspacing=0 width="100%" border=0>
  <tr class="f1"><td align=center height=30><font size=+1><b><%=mainTitle%></b></font>
</table>
<p>
<%=com.websina.servlet.ServletUtil.formatMessage(msg)%>

<% if (user == null) {
   if (msg == null) { // for instruction only %>
<table>
<tr><td>
<%=label.get("admin_user_intro")%>
</td></tr>
<tr><td align=right>
<form method="post" action="<%=contextPath%>/servlet/user">
<input type="hidden" name="action" value="reload">
<input type="submit" value="<%=label.get("reload_button")%>">
</form>
</td></tr>
</table>

<% if (com.websina.servlet.JspUtil.isUserStatusEnabled()) { %>
<div id="active_users"></div>
<form><input type="button" class="button" value="<%=label.get("admin_user_online_button")%>" onClick="innerRefresh('<%=contextPath%>/servlet/user?action=getActiveUsers', 'active_users');"></form>
<% } %>
<p style='height:160px'></p>
<% }} else { //if a user is loaded for editing
  String[] optionList = Group.getInstance().codes();
  if (user.getId() == 0) {
    if (false == com.websina.servlet.JspUtil.isLdapEnabled()) passwordMark = requiredMark;
  }
%>
<p>
<form name="userForm" method="post" action="<%=contextPath%>/servlet/user" onsubmit="return false;">
<input type="hidden" name="token" value='<%=com.websina.servlet.SessionUtil.getToken(session)%>'>
<input type="hidden" name="username" value="<%=HtmlParser.escapeQuotation(username)%>">
<table bgcolor="#ffffff" cellpadding=0 cellspacing=0 border=0 width=95%>
<tr><td colspan=2>
<%=label.get("admin_user_text")%>
</td></tr>
<tr><td width=60%></td><td>
<%-- user status --%>                            
<% if (user.getId() != 0) { 
     if (user.isActive()) { %>
&nbsp;&nbsp;&nbsp;&nbsp;
<input type="button" class="button" value="<%=label.get("deactivate_button")%>"
onClick="this.form.action.value='deactivate'; submit()">
<% } else { %>
&nbsp;&nbsp;&nbsp;&nbsp;
<input type="button" class="button" value="<%=label.get("activate_button")%>"
onClick="this.form.action.value='activate'; submit()">
<% } %>
<% if (com.websina.bean.AppContext.getEnableAccountLockout()) { %>
&nbsp;<input type="button" class="button" value="<%=label.get("unlock_button")%>"
onClick="this.form.action.value='unlock'; submit()">
<% }} %>
</td></tr>
</table> 
<p>
<table cellpadding=3 cellspacing=1 border=0 class="box">
<%-- the name part --%>
<tr><td class="f1">
<b><%=label.get("username")%></b></td>
<td class="f1">&nbsp;<tt><%=HtmlParser.escapeTag(username)%></tt>
</td></tr>
<tr>
<td><b><%=label.get("password")%><%=passwordMark%></b></td>
<td><input type=password name="password" size=24 maxlength=32></td>
</tr>
<tr>
<td><b><%=label.get("email")%></b><%=requiredMark%></td>
<td><input type=text name="email" value="<%=user.isAlias()?"":HtmlParser.escapeQuotation(user.getEmail())%>" size=60 maxlength=100></td>
</tr>
<tr>
<td>&nbsp;</td><td><input type=checkbox name="alias" value="Y" <%=user.isAlias()?"checked":""%>>
<%=label.get("admin_user_alias")%>
</td></tr>
<tr>
<td><b><%=label.get("fullname")%></b><%=requiredMark%></td>
<td><input type=text name="fullname" value="<%=HtmlParser.escapeQuotation(user.getFullname())%>" size=60 maxlength=100></td>
</tr>
<tr>
<td><b><%=label.get("group")%></b></td>
<td><select name="group_code">
   <%=ListMaker.makeOptionList(optionList, user.getGroup()) %>
</select></td>
</tr>

<%-- finally the save/cancel buttons --%>
<tr><td colspan=2 align=center valign=bottom height=40>
<input type="hidden" name="action">
<input type="button" class="button" value="<%=label.get("save_button")%>" onClick="action.value='save';
if(<%=(user.getId() == 0 && com.websina.servlet.JspUtil.isLdapEnabled() == false)%>) {
  if(isEmpty(this.form.password,'Password is required')) return false;
}
if(!this.form.alias.checked && isEmpty(this.form.email,'Email is required')) return false;
if(!this.form.alias.checked && !validEmail(this.form.email.value)) return false;
if(isEmpty(this.form.fullname,'Full name is required')) {alert('ppp'); return false};
this.disabled=true; submit();">
<input type="button" class="button" value="<%=label.get("cancel_button")%>" onClick="if(<%=(user.getPassword() != null)%>) 
{location.href='user.jsp';} else 
{action.value='cancel'; submit();}">

</td></tr>
</table>
</form>
<%-- end of editing user account --%>
<% } %>
</center>
<p style='height:30px'></p>
<%com.websina.servlet.JspUtil.include(application, request, response, out, "/jsp/customizable/footer.html");%>
</body>
</html>