<%@ page
    import="com.websina.bean.*,com.websina.util.*"
%>
<html>
<head>
<title>Project Workflow</title>
<script type="text/javascript" src="../script/utils.js"></script>
<script type="text/javascript" src="script/item_mover.js"></script>
</head>
<body topmargin=0>
<%@ include file="_header.jspf" %>
<%      
  String msg = com.websina.servlet.SessionUtil.getMessage(session, request);
  String mainTitle = label.get("admin_workflow");
  String subTitle = ""; 
  Project conf = null;
  if (projectId != null && projectId.trim().length()>0) {
    conf = Project.getInstance(projectId);
    mainTitle += ": ";
    subTitle = admin.getProjectDisplay(projectId);
    if (!conf.isPersisted()) {
      msg = MessageCode.get("servlet.project.not_persisted", lang);
      conf = null;
      projectId = null;
    }
  } else {
    projectId = null;
  }
%>
<%-- the title part --%>
<form style="margin-top:10px;">
<table cellpadding=0 cellspacing=0 width="100%" border=0>
  <tr><td align=right><font color="#000000"><b><%=label.get("project_label")%></b></font>&nbsp;
     <select name="project" 
        style="font-size:14px;"
        onChange="location.href='workflow.jsp?projectId='+form.project.options[form.project.selectedIndex].value;">
        <%=ListMaker.makeOptionList(admin.getProjects(), currentProject) %>
        </select>
      <input type="button" class="button" value=" <%=label.get("edit_button")%> " 
      onClick="location.href='workflow.jsp?projectId='+form.project.options[form.project.selectedIndex].value;" <%=(admin.getProjects().isEmpty())?"disabled":""%>>

  </td></tr>
  <tr class="f1"><td align=center height=30><font size=+1><b><%=mainTitle%></b></font>
  &nbsp;<font color="#cccc00"><b><%=subTitle%></b></font>
  </td></tr>
</table>
</form>
<center>
<p>
<%=com.websina.servlet.ServletUtil.formatMessage(msg)%>

<% if (conf == null) {
   if (msg == null) { // for instruction only %>
<table>
<tr><td height=380 valign=top>
<%=label.get("admin_common_intro")%>
</td></tr>
</table>
<% }} else if (conf.isReferenceType()) { %>
<table><tr><td height=100><%=label.get("admin_routing_not_applicable")%></td></tr></table>
<% } else { //if a project/workflow is loaded 
  Workflow workflow = conf.getWorkflow();    
  String[] allStates = conf.getField("state").getValue();

  String[] responsibles = null, responsibles0 = null;
  String[] fullnames = null, fullnames0 = null;
  com.websina.util.Field field = conf.getAccess().getResponsibles();
  String[] temp = field.getValue();
  String[] text = field.getText();
  if (temp == null) {
    out.print("<center><font color=red><b>");
    out.print("This project has no users with 'edit' or 'edit assigned' access, no workflow is applicable.");
    out.print("</b></font></center>");
    return;
  }
  com.websina.util.Field[] userFields = conf.getUserFields();

  responsibles = new String[temp.length + 6 + userFields.length];
  fullnames = new String[responsibles.length];
  responsibles0 = new String[temp.length + 5];
  fullnames0 = new String[responsibles0.length];
  responsibles[0] = "--";
  fullnames[0] = responsibles[0];
  responsibles0[0] = "--";
  fullnames0[0] = responsibles0[0];
  responsibles[1] = "original_author";
  fullnames[1] = "(Original author)";
  responsibles0[1] = "original_author";
  fullnames0[1] = "(Original author)";
  responsibles[2] = "original_responsible";
  fullnames[2] = "(Original responsible)";
  responsibles[3] = "previous_responsible";
  fullnames[3] = "(Previous responsible)";
  responsibles[4] = "assignable";
  fullnames[4] = "(Assignable)";
  responsibles0[2] = "assignable";
  fullnames0[2] = "(Assignable)";
  responsibles0[3] = "nobody";
  fullnames0[3] = "(Nobody)";

  for (int i=0; i<userFields.length; i++) {
    responsibles[i + 5] = userFields[i].getName();
    fullnames[i + 5] = "(" + userFields[i].getLabel() + ")";
  }

  responsibles[5 + userFields.length] = "------";
  fullnames[5 + userFields.length] = "";
  responsibles0[4] = "------";
  fullnames0[4] = "";

  for (int i=0; i<temp.length; i++) {
    responsibles[i + 6 + userFields.length] = temp[i];
    fullnames[i + 6 + userFields.length] = text[i];
    responsibles0[i + 5] = temp[i];
    fullnames0[i + 5] = text[i];
  }
  String[] allGroups = Group.getInstance().codes(conf);

  String[] optionList;
  String[] srcList;
%>

<table bgcolor="#ffffff" cellpadding=0 cellspacing=0 border=0 width=95%>
<tr><td>
<%=label.get("admin_workflow_text")%>
</td></tr>
</table> 

<form name="workflowForm" method="post" action="<%=contextPath%>/servlet/workflow" onsubmit="return false;">
<input type="hidden" name="token" value='<%=com.websina.servlet.SessionUtil.getToken(session)%>'>
<input type="hidden" name="projectId" value="<%=projectId%>">
<table cellpadding=1 cellspacing=1 border=0 class="box">
<%-- the name part --%>
<tr class="header"><td colspan=4 align=center>
<font color="#ffffff"><b><%=label.get("admin_workflow_NextStateAllowed")%></b></font>
</td></tr>
<%-- start next allowed state block --%>
<%
  for (int index=0; index<allStates.length; index++) {
    String aState = allStates[index];
    String jsState = "next_"+HtmlParser.jsName(aState);			      
    if (workflow == null) {
      optionList = allStates;
      srcList = null;
    } else {
      optionList = (String[])workflow.get(aState, 1);
      srcList = ArrayUtil.remove(allStates, optionList);
    }
%>
<tr><td class="f1" colspan=4 align=center>
<b><%=label.get("state")%>:</b>&nbsp; <%=aState%>
</td></tr>
<tr><td class="e8" align=center>
&nbsp;<%=label.get("admin_available")%> <%=label.get("admin_states")%>&nbsp;<br>
<select multiple size="5" name="state_src<%=index%>">
   <%=ListMaker.makeOptionList(srcList) %>
</select></td>
<td  class="e8" align=center width=100>
<input type="button" class="button" value="  >>  " onclick="move(form.state_src<%=index%>,form.<%=jsState%>)"><br>
<input type="button" class="button" value="  <<  " onclick="move(form.<%=jsState%>,form.state_src<%=index%>)">
</td>
<td class="e8" align=center>
&nbsp;<%=label.get("admin_workflow_NextStateAllowed")%>&nbsp;<br>
<select multiple size="5" name="<%=jsState%>">
   <%=ListMaker.makeOptionList(optionList) %>
</select></td>
<td class="e8">
<input type="button" class="button" value=" Up " onClick="Up(form.<%=jsState%>)">
<p><input type="button" class="button" value=" Dn " onClick="Down(form.<%=jsState%>)">
</td></tr>
<% } %>
<%-- end next allowed state block --%>

<tr><td colspan=4 align=center>
&nbsp;
</td></tr>
<tr class="header"><td colspan=4 align=center>
<font color="#ffffff"><b><%=label.get("admin_workflow_AutoAssignment")%></b></font>
</td></tr>
<%-- start assignee block --%>

<tr><td class="f1" colspan=4 align=center>
  <table cellpadding=2 cellspacing=2 border=0 width="100%">
  <tr><td class="f1" align=right><font color="#000000"><b><%=label.get("state")%></b></font></td>
      <td class="f1" align=center><font color="#000000"><b><%=label.get("admin_workflow_AutoAssignee")%></b></font></td></tr>
<%
if (responsibles != null) {
  for (int index=0; index<allStates.length; index++) {
    String aState = allStates[index];		      
    String jsAssignee = "assignee_"+HtmlParser.jsName(aState);	
    String assignee = (String)workflow.get(aState, 2);
%>
<tr><td class="e8" align=right>
<%=aState%>
</td></td>
<td class="e8" align=center>
<select name="<%=jsAssignee%>">
  <% if (index == 0) { %>
    <%=ListMaker.makeOptionList(responsibles0, fullnames0, assignee) %>
  <% } else { %>
    <%=ListMaker.makeOptionList(responsibles, fullnames, assignee) %>
  <% } %>
</select></td>
</tr>
<% } }%>
</table>
</td></tr>
<%-- end automatic assignee block --%>

<tr><td colspan=4 align=center>
&nbsp;
</td></tr>
<tr class="header"><td colspan=4 align=center>
<font color="#ffffff"><b><%=label.get("admin_workflow_StateBasedOnGroup")%></b></font>
</td></tr>

<%-- start group block --%>
<%
  for (int index=0; index<allGroups.length; index++) {
    String aGroup = allGroups[index];
    String jsGroup = "group_"+HtmlParser.jsName(aGroup);			      
    if (workflow == null) {
      optionList = allStates;
      srcList = null;
    } else {
      optionList = (String[])workflow.get(aGroup, 3);
      srcList = ArrayUtil.remove(allStates, optionList);
    }
%>
<tr><td class="f1" colspan=4 align=center>
<b><%=label.get("group")%>:</b>&nbsp; <%=aGroup%> 
</td></tr>
<tr><td class="e8" align=center>
&nbsp;<%=label.get("admin_available")%> <%=label.get("admin_states")%>&nbsp;<br>
<select multiple size="5" name="group_src<%=index%>">
   <%=ListMaker.makeOptionList(srcList) %>
</select></td>
<td  class="e8" align=center width=100>
<input type="button" class="button" value="  >>  " onclick="move(form.group_src<%=index%>,form.<%=jsGroup%>)"><br>
<input type="button" class="button" value="  <<  " onclick="move(form.<%=jsGroup%>,form.group_src<%=index%>)">
</td>
<td class="e8" align=center>
&nbsp;<%=label.get("admin_settable")%> <%=label.get("admin_states")%>&nbsp;<br>
<select multiple size="5" name="<%=jsGroup%>">
   <%=ListMaker.makeOptionList(optionList) %>
</select></td>
<td class="e8">
<input type="button" class="button" value=" Up " onClick="Up(form.<%=jsGroup%>)">
<p><input type="button" class="button" value=" Dn " onClick="Down(form.<%=jsGroup%>)">
</td></tr>
<% } %>
<%-- end group block --%>

<tr><td colspan=4 align=center>
&nbsp;
</td></tr>
<tr class="header"><td colspan=4 align=center>
<font color="#ffffff"><b><%=label.get("admin_workflow_GroupBasedOnState")%></b></font>
</td></tr>
<%-- start group for state block --%>
<%
  for (int index=0; index<allStates.length; index++) {
    String aState = allStates[index];
    String jsState = "deniedGroup_"+HtmlParser.jsName(aState);			      
    if (workflow == null) {
      optionList = allGroups;
      srcList = null;
    } else {
      optionList = (String[])workflow.get(aState, 4);
      srcList = ArrayUtil.remove(allGroups, optionList);
    }
%>
<tr><td class="f1" colspan=4 align=center>
<b><%=label.get("state")%>:</b>&nbsp; <%=aState%>
</td></tr>
<tr><td class="e8" align=center>
&nbsp;<%=label.get("admin_available")%> <%=label.get("admin_groups")%>&nbsp;<br>
<select multiple size="5" name="state_src_<%=index%>">
   <%=ListMaker.makeOptionList(srcList) %>
</select></td>
<td  class="e8" align=center width=100>
<input type="button" class="button" value="  >>  " onclick="move(form.state_src_<%=index%>,form.<%=jsState%>)"><br>
<input type="button" class="button" value="  <<  " onclick="move(form.<%=jsState%>,form.state_src_<%=index%>)">
</td>
<td class="e8" align=center colspan=2>
&nbsp;<%=label.get("admin_denied")%> <%=label.get("admin_groups")%>&nbsp;<br>
<select multiple size="5" name="<%=jsState%>">
   <%=ListMaker.makeOptionList(optionList) %>
</select>
</td></tr>
<% } %>
<%-- end group for state block --%>

<tr><td class="f1" colspan=4>&nbsp;</td></tr>

<tr><td class="f1" colspan=4>
<%=label.get("admin_workflow_close_responsible")%>
&nbsp;<input type="checkbox" name="close_responsible" value="Y" <%=workflow.isCloseAllowedOnlyByResponsible()?"checked":""%>
</td></tr>
<tr><td class="f1" colspan=4>
<%=label.get("admin_workflow_close_originalauthor")%>
&nbsp;<input type="checkbox" name="close_originalauthor" value="Y" <%=workflow.isCloseAllowedOnlyByOriginalAuthor()?"checked":""%>
</td></tr>

<%-- finally the save/reset buttons --%>
<tr><td class="f1" colspan=4 align=center height=30>
<input type="button" class="button" value="<%=label.get("save_button")%>" onClick=" 
<%
  for (int index=0; index<allStates.length; index++) {
    String aState = allStates[index];
    String jsState = HtmlParser.jsName(aState);			      
%>
  selectAll(form.next_<%=jsState%>);
  selectAll(form.deniedGroup_<%=jsState%>);
<%}
  for (int index=0; index<allGroups.length; index++) {
    String aGroup = allGroups[index];
    String jsGroup = HtmlParser.jsName(aGroup);	
%>
  selectAll(form.group_<%=jsGroup%>);
<%} %>
this.disabled=true; submit();">
<input type="button" class="button" value="<%=label.get("reset_button")%>"
onClick="location.href='workflow.jsp?projectId=<%=projectId%>'">

</td></tr>
</table>
</form>
<% } %>
<%-- end of editing project/workflow --%>
</center>
<%com.websina.servlet.JspUtil.include(application, request, response, out, "/jsp/customizable/footer.html");%>
</body>
</html>