<%@ page language="java"
    session="true"
    import="com.websina.util.*,com.websina.bean.*"
    errorPage="error.jsp" 
%>
<%
  com.websina.servlet.JspUtil.setCharsetAndCacheControl(request, response);
  response.addHeader("Cache-Control", "no-cache");
  String contextPath = request.getContextPath();
  String formId = request.getParameter("formId");
  IssueForm issueForm = null;
  String lang = com.websina.servlet.SessionUtil.getLanguage(session);
  Person person = com.websina.servlet.SessionUtil.getPerson(session);
  if(formId != null) { 
    issueForm = com.websina.servlet.SessionUtil.getIssueForm(session, formId);
  }
  if (person == null || issueForm == null) {
    out.print("<html><head><title>File Attachment</title></head>");
    out.print("<body><center>");
    out.print(com.websina.servlet.ServletUtil.formatMessage(MessageCode.get("servlet.issue.state_invalid", lang), "red"));
    out.print("</center></body></html>"); 
    return;
  }
  Label label = com.websina.util.Label.getInstance(lang);
%>
<html>
<head>
<title>File Attachment</title>
<meta http-equiv=Content-Type content="text/html">
<script type="text/javascript" src="script/attachment.js"></script>
<LINK type="text/css" rel="StyleSheet" href="css/<%=person.getTheme().getCss()%>">
</head>

<body bgcolor="#ffffff">
<%=com.websina.servlet.JspUtil.getBFCacheFlush(request, session, "login.jsp")%>
<center>
&nbsp;<br>
<table cellspacing=0 cellpadding=2 border=0>	
<tr><td width="720">
<b><%=label.get("attachment_title")%></b>
</td></tr><tr><td>
<table cellspacing=0 cellpadding=2 border=0 class="box" width="100%">	
<tr class="header"><td colspan=3>
<%=label.get("attachment_desc")%>
</td></tr>
<tr><td colspan=3>&nbsp;</td></tr>
<tr><td><%=label.get("attachment_step1")%>
</td><td colspan=2>
<%=label.get("attachment_step2")%>
</td></tr>
<tr><td colspan=3>&nbsp;</td></tr>
<tr><td colspan=2>
&nbsp;<%=label.get("file_name")%></td>
<td><%=label.get("attached_file")%></td></tr>
<tr><td>
<form method="POST" ENCTYPE="multipart/form-data"
      action="<%=contextPath%>/servlet/upload?id=<%=formId%>"
      onsubmit="if (attachment.value.length==0) return false;">
<input type=file size=32 name=attachment></td>
<td align=center>
<input type=submit class="button" value="<%=label.get("attach_button")%>"></td>
</form>
<td rowspan=3>
<form method="POST" name="attachForm"
      action="<%=contextPath%>/servlet/upload?id=<%=formId%>" onsubmit="return false;">
  <input type="hidden" name="action">
 <select name=attached_files size=5 multiple>
  <% 
     Attachment attachment = issueForm.getAttachment();
     if (attachment != null) {
  %>
   <%=ListMaker.makeOptionList(attachment.getAllFilenames()) %>
  <% } %>
 </select></td>
</tr>
<tr><td>&nbsp;</td>
<td align=center><input type=button class="button" value="<%=label.get("remove_button")%>" 
onClick="do_remove(attachForm)">
</td></tr>
<tr><td colspan=2 height=32>&nbsp;</td></tr>
<tr><td colspan=3 align=center height=30>
<input type=button class="button" value="  <%=label.get("ok_button")%>  " onClick="do_ok(attachForm)">
<input type=button class="button" value="<%=label.get("cancel_button")%>" onClick="do_cancel(attachForm)">
</td></tr>
</form>
<% String msg = com.websina.servlet.SessionUtil.getMessage(session, request);
   if (msg != null) {
%>
<tr><td colspan=3 align=center>
<%=com.websina.servlet.ServletUtil.formatMessage(msg)%>&nbsp;
</td></tr>
<% } %>
</table>
<% String applet = com.websina.servlet.JspUtil.getApplet(application); if (applet != null) { %>
</td></tr><tr><td height=30>&nbsp;</td></tr><tr><td>
<table cellspacing=2 cellpadding=2 border=0 class="box" width="100%">	
<tr><td style="white-space:nowrap;">
<%=label.get("attachment_screencapture")%><div id='jvmid' style="display:inline;">
<a href="#" style="color:#efefef;text-decoration:none;" onClick="showJVM();">&nbsp;Java in use ... &nbsp;</a></div>
<%=com.websina.servlet.JspUtil.getJavascriptJvm()%>
</td></tr><tr><td align=right>
<applet code="com.websina.applet.ScreenCaptureApplet.class" archive="<%=applet%>" width=700 height=30>
  <param name="token" value="<%=com.websina.servlet.SessionUtil.getToken(session)%>">
  <param name="formId" value="<%=formId%>"><br>
</applet>
</td></tr>
</table>
<% } %>
</td></tr></table>
</center>
<%com.websina.servlet.JspUtil.include(application, request, response, out, "/jsp/customizable/footer.html");%>
</body>
</html>
 