<%@ page
    import="com.websina.bean.*,com.websina.util.*,com.websina.servlet.JspUtil"
%>
<html>
<head>
<title>Reports and Statistics</title>
</head>
<body topmargin=0>
<%@ include file="_header.jspf" %>
<%      
  if (!person.isAllowed("report")) {
    response.sendRedirect("home.jsp");
    return;
  }
  com.websina.bean.Filter filter = null;

  String baseUrl = contextPath + "/servlet/report/bugzeroReport.png";
  Project conf = person.getProject();
  String projectId = conf.getId();

  String[] optionList;
  com.websina.bean.Query query = null;

  String queryName = "";
  String xName = (conf.isReferenceType() || conf.isFieldHiddenForReport("state"))? null: "state";
  String yName = null;

  boolean isPublic = false;
  boolean isSummaryReport = true;
  boolean isDistributionReport = false;
  boolean isTrendReport = false;
  String timePeriod = null;
  String timeUnit = null;

  String queryId = request.getParameter("query_id");
  if (queryId != null) {
    query = new com.websina.bean.Query(person, queryId);
    query.loadFilter();
    if (!query.isReport()) {
      queryId = null;
      query = null;
    } else {
      filter = query.getFilter();
      queryName = query.getQueryName();
      isPublic = query.isPublic();
      isSummaryReport = query.isSummaryReport();
      isDistributionReport = query.isDistributionReport();
      isTrendReport = query.isTrendReport();
      xName = query.getReportXName();
      yName = query.getReportYName();
      timePeriod = query.getReportTimePeriod();
      timeUnit = query.getReportTimeUnit();
    }
  }

  if (yName == null && conf.isFieldHiddenForReport("responsible") == false && 
                       conf.isFieldEnabled("responsible", person.getRoles())) {
    yName = "responsible";
  }

  String selectProjects = conf.getEnableSelectProjectsForReport()? "selectAll(reportForm.show_projects);" : "";
%>

<center>
<%=com.websina.servlet.ServletUtil.formatMessage(com.websina.servlet.SessionUtil.getMessage(session, request))%>

<table cellspacing=0 cellpadding=0 border=0>
<tr><td height=36>
<b><%=label.get("report", projectId)%></b>
</td></tr>

<tr><td>
<form name="stored_report" method="post" action="<%=baseUrl%>" <%=acceptCharset%>>
<input type="hidden" name="token" value='<%=com.websina.servlet.SessionUtil.getToken(session)%>'>
<input type="hidden" name="action">
<input type="hidden" name="projectId" value="<%=projectId%>">
<%=hiddenRequestor%>
<table cellspacing=0 cellpadding=2 border=0 width="100%" class="box">
<tr class="header"><td colspan=3>
<%=label.get("choose_report")%>
</td></tr>
<tr>
<td height=32><select name="query_id">
<% if (person.getStoredQuery() != null) { %>
       <%=ListMaker.makeOptionList(person.getStoredReport(), queryId)%>
<% } %>
    </select>
</td>
<td align=center>
<input class="button" type="button" value="<%=label.get("submit_button")%>" 
     onClick="if(stored_report.query_id.selectedIndex>-1) {do_report(stored_report, 'submit_stored_query'); return false;}">
&nbsp;<input class="button" type="button" value="<%=label.get("remove_button")%>" 
     onClick="if(stored_report.query_id.selectedIndex>-1) {
              if (confirm('<%=label.getEscaped("delete_confirmation")%>')) {
              do_report(stored_report, 'remove_stored_query'); return false;}}">
     </td><td align=center>
    <input class="button" type="button" value="<%=label.get("edit_button")%>" 
     onClick="if(stored_report.query_id.selectedIndex>-1) {
     location.href='report.jsp?<%=headerQueryString%>&query_id='+stored_report.query_id.options[stored_report.query_id.selectedIndex].value; return false;}">
</td></tr>
</table>
</form>
</td></tr>

<tr><td>&nbsp;</td></tr>
<tr><td height=30>
<%=label.get("define_report")%>
</td></tr>

<tr><td>
<form name="reportForm" method="post" action="<%=baseUrl%>" <%=acceptCharset%> onSubmit="return false;">
<input type="hidden" name="token" value='<%=com.websina.servlet.SessionUtil.getToken(session)%>'>
<input type="hidden" name="action">
<input type="hidden" name="projectId" value="<%=projectId%>">
<% if (queryId != null) { %>
<input type="hidden" name="query_id" value="<%=queryId%>">
<% } %>
<%=hiddenRequestor%>
<table cellspacing=0 cellpadding=2 border=0 width="100%" class="box">
<tr><td colspan=2 height=36 align=center>
     <input class="button" type="button" value="<%=label.get("show_report_button")%>" 
      onClick="<%=selectProjects%><%=JspUtil.getQuerySubmitValidation(conf, person, "reportForm")%> do_report(reportForm)">
&nbsp;<input class="button" type=reset value="<%=label.get("clear_button")%>">
    </td></tr>

<%--/// report type ///--%>
<tr><td class="e8" height=46 valign=center><%=label.get("report_type")%></td>
    <td class="f1">
<table cellspacing=0 cellpadding=0 border=0 width="100%">
<tr><td><select name="report_type"
     onChange="set_report(reportForm);">
  <option value="1" <%=(isSummaryReport)?"selected":""%>><%=label.get("summary_report")%></option>
  <option value="2" <%=(isDistributionReport)?"selected":""%>><%=label.get("current_counts")%></option>
  <option value="3" <%=(isTrendReport)?"selected":""%>><%=label.get("trend_metrics")%></option>
  </select></td>
<td>&nbsp;&nbsp; of &nbsp;&nbsp;<select name="x_name">
    <%=ListMaker.makeOptionList(label, projectId, conf.reportFields(person.getRoles()), xName) %>
    </select></td>

<td id="summary_only" style="display:<%=(isSummaryReport)?"inline":"none"%>;">
&nbsp;&nbsp;versus <select name="y_name" style="margin-top:2;">
       <%=ListMaker.makeOptionList(label, projectId, conf.reportFields(person.getRoles()), yName) %>
    </select>
</td>
<td id="trend_only" style="display:<%=(isTrendReport)?"inline":"none"%>;">
&nbsp;&nbsp;for the last
<input type="text" name="time_period" size=2 value="<%=com.websina.util.HtmlParser.escapeQuotation(timePeriod)%>">
<select name="time_unit" style="margin-top:2;">
        <%=ListMaker.makeOptionList(label, JspUtil.getReportTimeUnit(), timeUnit)%></select>
</td></tr>
</table>
</td></tr>

<%-- show projects --%> 
<% if (conf.getEnableSelectProjectsForReport()) { %>
<tr>
    <td class="e8"><nobr><%=label.get("show_projects")%></nobr></td>
  <td class="f1">
  <table cellspacing=0 cellpadding=0>
  <tr>
  <td><select name=show_projects_src size=5 multiple>
    <%=ListMaker.makeOptionList(person.getProjectList(), null) %>
    </select>
  </td>
  <td align=center width=100>
  <input type="button" class="button" value="<%=label.get("select_button")%> >>" onclick="move(show_projects_src,show_projects)"><br>
  <input type="button" class="button" value="<%=label.get("remove_button")%>" onclick="move(show_projects,show_projects_src)">
  </td>
  <td><select name=show_projects size=5 multiple>
    <%=ListMaker.makeOptionList((query != null)?query.getShowProjects():null, null) %>
    </select>
  </td></tr></table>
</td></tr>
<% } %>

<%--/// query constraints ///--%>
<%@ include file="_queryform.jspf" %>
<tr><td colspan=2 height=32 align=center>
     <input class="button" type="button" value="<%=label.get("show_report_button")%>" 
      onClick="<%=selectProjects%><%=JspUtil.getQuerySubmitValidation(conf, person, "reportForm")%> do_report(reportForm)">
&nbsp;<input class="button" type=reset value="<%=label.get("clear_button")%>">
</td></tr>
</table>
<p style='height:20px'></p>
<%=label.get("save_report")%>&nbsp;&nbsp;
<input type="text" name=query_name size=24 maxlength=120 value="<%=com.websina.util.HtmlParser.escapeQuotation(queryName)%>">
<input class="button" type="button" value="<%=label.get("go_button")%>"
      onClick="trim(reportForm.query_name); if (reportForm.query_name.value.length>0) {<%=selectProjects%>do_report(reportForm, 'save_stored_query')}">
&nbsp;&nbsp;<%=label.get("save_as_public")%>
<input type=checkbox name=public_query value="1" <%=(isPublic)?"checked":""%>>

</form>
</td></tr>
</table>
</center>
<%com.websina.servlet.JspUtil.include(application, request, response, out, "/jsp/customizable/footer.html");%>
</body></html>
