<!-- Begin
function assert(condition, msg) {
  if (condition == false) {
    alert (msg)
    return false;
  } else {
    return true;
  }
}

function isEmpty(input, msg) {
  trim(input);
  if(input.value.length==0) {
    alert (msg)
    return true;
  } else {
    return false;
  }
}

function isChecked(theForm) {
  for (var i=0; i<theForm.elements.length; i++) {
    if (theForm.elements[i].type=="checkbox" 
        && theForm.elements[i].checked) {
      return true;
    }
  }
  return false;
}

function isSelected(select, forbidden, msg) {
  if (select.value==forbidden) {
    alert(msg);
    return false;
  } else {
    return true;
  }
}

function isEqual(input1, input2, msg) {
  trim(input1);
  trim(input2);
  if (input1.value != input2.value) {
    alert(msg);
    return false;
  } else {
    return true;
  }
}

function validEmailList(input) {
  trim(input);
  var str = input.value;
  if (str.length == 0) {
    return true;
  }
  var T = str.split(/[; ,]/);
  for (var i=0; i<T.length; i++) {
    if (!validEmail(T[i])) return false;
  }
  return true;
}

function validEmail(str) {
  str = _trim(str);
  if(str.length == 0) {
    return true;
  } else {
    var regExp = /^[^@]+@[^@]+.[a-z]{2,}$/i;
    if (str.search(regExp) == -1) {
      alert ("Email address '"+ str+"' is not valid!")
      return false;
    }
    return true;
  }
}

function validEmailList2(input) {
  trim(input);
  var str = input.value;
  if (str.length == 0) {
    return true;
  }
  var T = str.split(/[; ,]/);
  for (var i=0; i<T.length; i++) {
    if (!(validEmail2(T[i]) || validEmail(T[i]))) return false;
  }
  return true;
}

function validEmail2(str) {
  str = _trim(str);
  if(str.length == 0) {
    return true;
  } else if (str == '$responsible' || str == '$author' || str.substring(str.length-6) == '.class') { 
    return true;
  } else {
    return false;
  }
}

function validUrlList(input) {
  trim(input);
  var str = input.value;
  if (str.length == 0) {
    return true;
  }
  var T = str.split(/[;,]/);
  for (var i=0; i<T.length; i++) {
    if (!validUrl(T[i])) return false;
  }
  return true;
}

function validUrl(str) {
  str = _trim(str);
  if (str.length == 0
    || str.search(/^\d+$/) == 0
    || str.search(/^http:\/\/[^@]+$/) == 0
    || str.search(/^https:\/\/[^@]+$/) == 0
    || str.search(/^file:\/\/[^@]+$/) == 0
    || str.search(/^ftp:\/\/[^@]+$/) == 0
    || str.search(/^www\.[^@]+$/) == 0 
    || str.search(/^[^\O]+:\s+http:\/\/[^@]+$/) == 0
    || str.search(/^[^\O]+:\s+https:\/\/[^@]+$/) == 0
    || str.search(/^[^\O]+:\s+file:\/\/[^@]+$/) == 0
    || str.search(/^[^\O]+:\s+ftp:\/\/[^@]+$/) == 0
    || str.search(/^[^\O]+:\s+www\.[^@]+$/) == 0) {
    return true;
  }
  alert ("URL or link ID '"+ str+"' is not valid!")
  return false;
}

function validDatetimeList(str) {
  str = _trim(str);
  if (str.length == 0) return true;
  var T = str.split(",");
  if (T.length > 2) {
    alert ("Datetime list '"+ str+"' is not valid!")
    return false;
  }
  var result = validDatetime(T[0]);
  if (result && T.length > 1) {
    result = validDatetime(T[1]);
  }
  return result;
}

function validDatetime(str) {
  str = _trim(str);
  if (str.length == 0) return true;
  var T = str.split(" ");
  var result = validDate(T[0]);
  if (result && T.length > 1 ) {
   result =  validTime(T[T.length-1]);
  }
  if (!result) {
    var df_format;
    if (df_position == 'MDY') {
      df_format = "m" + df_separator + "d" + df_separator + "yyyy";
    } else if (df_position == 'DMY') {
      df_format = "d" + df_separator + "m" + df_separator + "yyyy";
    } else if (df_position == 'YMD') {
      df_format = "yyyy" + df_separator + "m" + df_separator + "d";
    }
    alert ("Datetime '" + str + "' is not valid, use " + df_format + " h24:m:s")
  }
  return result;
}

function validDate(str) {
  str = _trim(str);
  if (str.length == 0) return true;
  var T;
  if (df_position == 'MDY' && str.search(new RegExp('^\\d{1,2}' + df_separator + '\\d{1,2}' + df_separator + '\\d{4}$')) == 0) {
    T = str.split(df_separator);
    if (T.length==3 && _validDate(T[2], T[0]-1, T[1])) {
      return true;
    }
  } else if (df_position == 'DMY' && str.search(new RegExp('^\\d{1,2}' + df_separator + '\\d{1,2}' + df_separator + '\\d{4}$')) == 0) {
    T = str.split(df_separator);
    if (T.length==3 && _validDate(T[2], T[1]-1, T[0])) {
      return true;
    }
  } else if (df_position == 'YMD' && str.search(new RegExp('^\\d{4}' + df_separator + '\\d{1,2}' + df_separator + '\\d{1,2}$')) == 0) {
    T = str.split(df_separator);
    if (T.length==3 && _validDate(T[0], T[1]-1, T[2])) {
      return true;
    }
  }
  return false;
}

function validTime(str) {
  str = _trim(str);
  if (str.length == 0) return true;
  var T = str.split(/:/);
  if (T.length > 3) return false;
  if (T.length <= 1) {
    if (T[0]<0 || T[0]>23) return false;
  }
  if (T.length <= 2) {
    if (T[1]<0 || T[1]>59) return false;
  }
  if (T.length == 3) {
    if (T[2]<0 || T[2]>59) return false;
  }
  return true;
}

function _validDate(y, m, d) {
  with (new Date(y, m, d)) {
    return (getMonth() == m && getDate() == d);
  }
}

function validNumberQuery(str) {
  str = _trim(str);
  if(str.length == 0) {
    return true;
  } else {
    var regExp = /^[><!=]*\d*\.*\d*[\s><!=,]*\d*\.*\d*$/;
    if (str.search(regExp) == -1) {
      alert ("'"+ str+"' is not a valid number search condition, use '><='.")
      return false;
    }
    return true;
  }
}

function validNumber(str) {
  str = _trim(str);
  if(str.length == 0) {
    return true;
  } else {
    var regExp = new RegExp('(^-?\\d+\\' + decimal_separator + '\\d*$)|(^-?\\d+$)|(^-?\\' + decimal_separator + '\\d+$)');
    if (str.search(regExp) == -1) {
      alert ("'"+ str+"' is not a valid number!")
      return false;
    }
    return true;
  }
}

function validInteger(str) {
  str = _trim(str);
  if(str.length == 0) {
    return false;
  } else {
    var regExp = /(^\d+$)/;
    if (str.search(regExp) == -1) {
      return false;
    }
    return true;
  }
}

function validNumberList(str) {
  str = _trim(str);
  if(str.length == 0) {
    return false;
  } else {
    var regExp = /(^(\d+\s*,?\s*)+$)/;
    if (str.search(regExp) == -1) {
      return false;
    }
    return true;
  }
}

function do_clear(box, input) {
  for (var i=0; i<box.length; i++) {
    if (box.options[i].selected) {
      box.options[i].selected = false;
    }
  }
  if(input.value != "") {
    input.value = "";
  }
}

function do_checkbox(frm, chkbox){
  for (var i=0; i<frm.elements.length; i++) {
    var e=frm.elements[i];
    if ((e != chkbox) && (e.type=='checkbox')) {
      e.checked=chkbox.checked;
    }
  }
}

function comboSelect(box, input, len) {
  trim(input);
  var str = input.value;
  var matched = false;
  for (var i=0; i < box.length; i++) {
    if (box.options[i].value == str) {
      box.options[i].selected = true;
      matched = true;
    } else {
      box.options[i].selected = false;
    }
  }
  if (matched == false) {
    if (box.length == len) {
      var no = new Option();
      box.options[len] = no;
    }
    box.options[len].value = str;
    box.options[len].text = str;
    if (str == '') {
      box.options[len].selected = false;
    } else {
      box.options[len].selected = true;
    }
  }
}

function getSelectedOptions(box) {
  var result = '';
  for (var i=0; i < box.length; i++) {
    if (box.options[i].selected) {
      if (result != '') {
        result += ';';
      }
      result += box.options[i].value;
    }
  }
  return result;
}

function trim(input) {
  var str = input.value;
  input.value = _trim(str);
}

function _trim(str) {
  while(''+str.charAt(0)==' ' || ''+str.charAt(0)=='\n' || ''+str.charAt(0)=='\r') {
    str=str.substring(1,str.length);
  }
  while(''+str.charAt(str.length-1)==' ') {
    str=str.substring(0,str.length-1);
  }
  return str;
}

function Up(box) {
  var index = box.selectedIndex; 
  if ( index > 0 ) {
    if (navigator.appName == 'Netscape') {
      var temp = box.options[index];
      box.remove(index);
      box.add(temp, box.options[index-1]);
    } else {
      var temp_value = box.options[index].value;
      var temp_text = box.options[index].text;
      box.options[index].value = box.options[index-1].value;
      box.options[index].text = box.options[index-1].text;
      box.options[index].selected = false;
      box.options[index-1].value = temp_value;
      box.options[index-1].text = temp_text;
      box.options[index-1].selected = true;
    }
  }
}

function Down(box) {
  var index = box.selectedIndex; 
  if ( index < box.options.length -1 ) {
    if (navigator.appName == 'Netscape') {
      var temp = box.options[index];
      box.remove(index);
      box.add(temp, box.options[index+1]);
    } else {
      var temp_value = box.options[index].value;
      var temp_text = box.options[index].text;
      box.options[index].value = box.options[index+1].value;
      box.options[index].text = box.options[index+1].text;
      box.options[index].selected = false;
      box.options[index+1].value = temp_value;
      box.options[index+1].text = temp_text;
      box.options[index+1].selected = true;
    }
  }
}
// End -->
