<%@ page language="java"
    session="true"
    import="com.websina.bean.*,com.websina.util.*"
    errorPage="error.jsp"
%>
<%      
  com.websina.servlet.JspUtil.setCharsetAndCacheControl(request, response);
  String lang = com.websina.servlet.SessionUtil.getLanguage(session);
  Label label = Label.getInstance(lang);        
  com.websina.bean.Report report = com.websina.servlet.SessionUtil.getReport(session);
  if (report == null || report.isEmpty()) {
    out.println("<html><head><title>Summary Report</title></head>");
    out.print("<body><center>&nbsp;<br>&nbsp;<br>");
    out.println(com.websina.servlet.ServletUtil.formatMessage(MessageCode.get("servlet.report.no_summary_report", lang)));
    out.println("</center></body></html>"); 
    return;
  }
  String xName = report.getXName();
  String yName = report.getYName();

  Project conf = report.getProject();
  String projectId = conf.getId();
  DateTime dateTime = com.websina.servlet.SessionUtil.getDateTime(session);

  com.websina.util.Field xField = report.getXField();
  com.websina.util.Field yField = report.getYField();

  String[] x = xField.getValue();
  String[] xDisplay = xField.getText();
  String[] y = yField.getValue();
  String[] yDisplay = yField.getText();
  int[] total = new int[x.length + 1];
  for (int i=0; i<=x.length; i++) {
     total[i] = 0; 
  }
%>
<html>
<head>
<title>Summary Report</title>
<LINK type="text/css" rel="StyleSheet" href="css/<%=conf.getTheme().getCss()%>">
</head>
<body topmargin=0>
<center>
&nbsp;<br>
<font size="+1">Summary Report:</font>
<font size="+1"><b><%=report.getProjectNames()%></b></font>
<br>

<%=label.get(yName, projectId)%> versus <%=label.get(xName, projectId)%>
<br><%=dateTime.localTime()%>

<table cellspacing=1 cellpadding=2 border=0>
<tr><td colspan=<%=(x.length+2)%> align=right>
<a href="<%=request.getContextPath()%>/servlet/export/summary.csv?projectId=<%=projectId%>&type=3" title="Export to CSV">Export <img src="img/excel.gif" border=0></a>
</td></tr>
<tr class="header">
<td>&nbsp;</td>
  <% for (int i=0; i<x.length; i++) {
  %>
<td align=center> <%= xDisplay[i] %></td>
  <% } %>
<td align=center>Total&nbsp;</td>
</tr>

  <% for (int i=0; i<y.length; i++) {
       int xTotal = 0; 
  %>
<tr><td class="e8" align=right><%= yDisplay[i] %>&nbsp;</td>
     <% for (int j=0; j<x.length; j++) {
          int count = report.getCount(x[j], y[i]);
          xTotal += count;
          total[j] += count; 
          total[x.length] += count;
     %>
<td class="f1" align=center> <%=Integer.toString(count)%></td>
     <% } %> <td class="f1" align=center><%=xTotal%></td></tr>
  <% } %>

<tr><td class="e8" align=right>Total&nbsp;</td>
     <% for (int j=0; j<=x.length; j++) {
     %>
<td class="f1" align=center><%=total[j] %></td>
     <% } %> </tr>
</table>
</center>
</body>
</html>
