/**
 * Cookie plugin
 *
 * Copyright (c) 2006 Klaus Hartl (stilbuero.de)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 */

/**
 * Create a cookie with the given name and value and other optional parameters.
 *
 * @example $.cookie('the_cookie', 'the_value');
 * @desc Set the value of a cookie.
 * @example $.cookie('the_cookie', 'the_value', { expires: 7, path: '/', domain: 'jquery.com', secure: true });
 * @desc Create a cookie with all available options.
 * @example $.cookie('the_cookie', 'the_value');
 * @desc Create a session cookie.
 * @example $.cookie('the_cookie', null);
 * @desc Delete a cookie by passing null as value. Keep in mind that you have to use the same path and domain
 *       used when the cookie was set.
 *
 * @param String name The name of the cookie.
 * @param String value The value of the cookie.
 * @param Object options An object literal containing key/value pairs to provide optional cookie attributes.
 * @option Number|Date expires Either an integer specifying the expiration date from now on in days or a Date object.
 *                             If a negative value is specified (e.g. a date in the past), the cookie will be deleted.
 *                             If set to null or omitted, the cookie will be a session cookie and will not be retained
 *                             when the the browser exits.
 * @option String path The value of the path atribute of the cookie (default: path of page that created the cookie).
 * @option String domain The value of the domain attribute of the cookie (default: domain of page that created the cookie).
 * @option Boolean secure If true, the secure attribute of the cookie will be set and the cookie transmission will
 *                        require a secure protocol (like HTTPS).
 * @type undefined
 *
 * @name $.cookie
 * @cat Plugins/Cookie
 * @author Klaus Hartl/klaus.hartl@stilbuero.de
 */

/**
 * Get the value of a cookie with the given name.
 *
 * @example $.cookie('the_cookie');
 * @desc Get the value of a cookie.
 *
 * @param String name The name of the cookie.
 * @return The value of the cookie.
 * @type String
 *
 * @name $.cookie
 * @cat Plugins/Cookie
 * @author Klaus Hartl/klaus.hartl@stilbuero.de
 */
jQuery.cookie = function(name, value, options) {
    if (typeof value != 'undefined') { // name and value given, set cookie
        options = options || {};
        if (value === null) {
            value = '';
            options.expires = -1;
        }
        var expires = '';
        if (options.expires && (typeof options.expires == 'number' || options.expires.toUTCString)) {
            var date;
            if (typeof options.expires == 'number') {
                date = new Date();
                date.setTime(date.getTime() + (options.expires * 24 * 60 * 60 * 1000));
            } else {
                date = options.expires;
            }
            expires = '; expires=' + date.toUTCString(); // use expires attribute, max-age is not supported by IE
        }
        // CAUTION: Needed to parenthesize options.path and options.domain
        // in the following expressions, otherwise they evaluate to undefined
        // in the packed version for some reason...
        var path = options.path ? '; path=' + (options.path) : '';
        var domain = options.domain ? '; domain=' + (options.domain) : '';
        var secure = options.secure ? '; secure' : '';
        document.cookie = [name, '=', encodeURIComponent(value), expires, path, domain, secure].join('');
    } else { // only name given, get cookie
        var cookieValue = null;
        if (document.cookie && document.cookie != '') {
            var cookies = document.cookie.split(';');
            for (var i = 0; i < cookies.length; i++) {
                var cookie = jQuery.trim(cookies[i]);
                // Does this cookie string begin with the name we want?
                if (cookie.substring(0, name.length + 1) == (name + '=')) {
                    cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                    break;
                }
            }
        }
        return cookieValue;
    }
};
// ┌─────────────────────────────────────────────────────────────────────┐ \\
// │ Raphaël 2.0.1 - JavaScript Vector Library                           │ \\
// ├─────────────────────────────────────────────────────────────────────┤ \\
// │ Copyright (c) 2008-2011 Dmitry Baranovskiy (http://raphaeljs.com)   │ \\
// │ Copyright (c) 2008-2011 Sencha Labs (http://sencha.com)             │ \\
// │ Licensed under the MIT (http://raphaeljs.com/license.html) license. │ \\
// └─────────────────────────────────────────────────────────────────────┘ \\
(function(a){var b="0.4.0",c="hasOwnProperty",d=/[\.\/]/,e="*",f=function(){},g=function(a,b){return a-b},h,i,j={n:{}},k=function(a,b){var c=j,d=i,e=Array.prototype.slice.call(arguments,2),f=k.listeners(a),l=0,m=!1,n,o=[],p={},q=[],r=[];h=a,i=0;for(var s=0,t=f.length;s<t;s++)"zIndex"in f[s]&&(o.push(f[s].zIndex),f[s].zIndex<0&&(p[f[s].zIndex]=f[s]));o.sort(g);while(o[l]<0){n=p[o[l++]],q.push(n.apply(b,e));if(i){i=d;return q}}for(s=0;s<t;s++){n=f[s];if("zIndex"in n)if(n.zIndex==o[l]){q.push(n.apply(b,e));if(i){i=d;return q}do{l++,n=p[o[l]],n&&q.push(n.apply(b,e));if(i){i=d;return q}}while(n)}else p[n.zIndex]=n;else{q.push(n.apply(b,e));if(i){i=d;return q}}}i=d;return q.length?q:null};k.listeners=function(a){var b=a.split(d),c=j,f,g,h,i,k,l,m,n,o=[c],p=[];for(i=0,k=b.length;i<k;i++){n=[];for(l=0,m=o.length;l<m;l++){c=o[l].n,g=[c[b[i]],c[e]],h=2;while(h--)f=g[h],f&&(n.push(f),p=p.concat(f.f||[]))}o=n}return p},k.on=function(a,b){var c=a.split(d),e=j;for(var g=0,h=c.length;g<h;g++)e=e.n,!e[c[g]]&&(e[c[g]]={n:{}}),e=e[c[g]];e.f=e.f||[];for(g=0,h=e.f.length;g<h;g++)if(e.f[g]==b)return f;e.f.push(b);return function(a){+a==+a&&(b.zIndex=+a)}},k.stop=function(){i=1},k.nt=function(a){if(a)return(new RegExp("(?:\\.|\\/|^)"+a+"(?:\\.|\\/|$)")).test(h);return h},k.unbind=function(a,b){var f=a.split(d),g,h,i,k,l,m,n,o=[j];for(k=0,l=f.length;k<l;k++)for(m=0;m<o.length;m+=i.length-2){i=[m,1],g=o[m].n;if(f[k]!=e)g[f[k]]&&i.push(g[f[k]]);else for(h in g)g[c](h)&&i.push(g[h]);o.splice.apply(o,i)}for(k=0,l=o.length;k<l;k++){g=o[k];while(g.n){if(b){if(g.f){for(m=0,n=g.f.length;m<n;m++)if(g.f[m]==b){g.f.splice(m,1);break}!g.f.length&&delete g.f}for(h in g.n)if(g.n[c](h)&&g.n[h].f){var p=g.n[h].f;for(m=0,n=p.length;m<n;m++)if(p[m]==b){p.splice(m,1);break}!p.length&&delete g.n[h].f}}else{delete g.f;for(h in g.n)g.n[c](h)&&g.n[h].f&&delete g.n[h].f}g=g.n}}},k.once=function(a,b){var c=function(){b.apply(this,arguments),k.unbind(a,c)};return k.on(a,c)},k.version=b,k.toString=function(){return"You are running Eve "+b},typeof module!="undefined"&&module.exports?module.exports=k:a.eve=k})(this),function(){function cr(b,d,e,f,h,i){e=Q(e);var j,k,l,m=[],o,p,q,t=b.ms,u={},v={},w={};if(f)for(y=0,z=cl.length;y<z;y++){var x=cl[y];if(x.el.id==d.id&&x.anim==b){x.percent!=e?(cl.splice(y,1),l=1):k=x,d.attr(x.totalOrigin);break}}else f=+v;for(var y=0,z=b.percents.length;y<z;y++){if(b.percents[y]==e||b.percents[y]>f*b.top){e=b.percents[y],p=b.percents[y-1]||0,t=t/b.top*(e-p),o=b.percents[y+1],j=b.anim[e];break}f&&d.attr(b.anim[b.percents[y]])}if(!!j){if(!k){for(var A in j)if(j[g](A))if(U[g](A)||d.paper.customAttributes[g](A)){u[A]=d.attr(A),u[A]==null&&(u[A]=T[A]),v[A]=j[A];switch(U[A]){case C:w[A]=(v[A]-u[A])/t;break;case"colour":u[A]=a.getRGB(u[A]);var B=a.getRGB(v[A]);w[A]={r:(B.r-u[A].r)/t,g:(B.g-u[A].g)/t,b:(B.b-u[A].b)/t};break;case"path":var D=bG(u[A],v[A]),E=D[1];u[A]=D[0],w[A]=[];for(y=0,z=u[A].length;y<z;y++){w[A][y]=[0];for(var F=1,G=u[A][y].length;F<G;F++)w[A][y][F]=(E[y][F]-u[A][y][F])/t}break;case"transform":var H=d._,I=bP(H[A],v[A]);if(I){u[A]=I.from,v[A]=I.to,w[A]=[],w[A].real=!0;for(y=0,z=u[A].length;y<z;y++){w[A][y]=[u[A][y][0]];for(F=1,G=u[A][y].length;F<G;F++)w[A][y][F]=(v[A][y][F]-u[A][y][F])/t}}else{var J=d.matrix||new bQ,K={_:{transform:H.transform},getBBox:function(){return d.getBBox(1)}};u[A]=[J.a,J.b,J.c,J.d,J.e,J.f],bN(K,v[A]),v[A]=K._.transform,w[A]=[(K.matrix.a-J.a)/t,(K.matrix.b-J.b)/t,(K.matrix.c-J.c)/t,(K.matrix.d-J.d)/t,(K.matrix.e-J.e)/t,(K.matrix.e-J.f)/t]}break;case"csv":var L=r(j[A])[s](c),M=r(u[A])[s](c);if(A=="clip-rect"){u[A]=M,w[A]=[],y=M.length;while(y--)w[A][y]=(L[y]-u[A][y])/t}v[A]=L;break;default:L=[][n](j[A]),M=[][n](u[A]),w[A]=[],y=d.paper.customAttributes[A].length;while(y--)w[A][y]=((L[y]||0)-(M[y]||0))/t}}var O=j.easing,P=a.easing_formulas[O];if(!P){P=r(O).match(N);if(P&&P.length==5){var R=P;P=function(a){return cp(a,+R[1],+R[2],+R[3],+R[4],t)}}else P=be}q=j.start||b.start||+(new Date),x={anim:b,percent:e,timestamp:q,start:q+(b.del||0),status:0,initstatus:f||0,stop:!1,ms:t,easing:P,from:u,diff:w,to:v,el:d,callback:j.callback,prev:p,next:o,repeat:i||b.times,origin:d.attr(),totalOrigin:h},cl.push(x);if(f&&!k&&!l){x.stop=!0,x.start=new Date-t*f;if(cl.length==1)return cn()}l&&(x.start=new Date-x.ms*f),cl.length==1&&cm(cn)}else k.initstatus=f,k.start=new Date-k.ms*f;eve("anim.start."+d.id,d,b)}}function cq(a,b){var c=[],d={};this.ms=b,this.times=1;if(a){for(var e in a)a[g](e)&&(d[Q(e)]=a[e],c.push(Q(e)));c.sort(bc)}this.anim=d,this.top=c[c.length-1],this.percents=c}function cp(a,b,c,d,e,f){function o(a,b){var c,d,e,f,j,k;for(e=a,k=0;k<8;k++){f=m(e)-a;if(z(f)<b)return e;j=(3*i*e+2*h)*e+g;if(z(j)<1e-6)break;e=e-f/j}c=0,d=1,e=a;if(e<c)return c;if(e>d)return d;while(c<d){f=m(e);if(z(f-a)<b)return e;a>f?c=e:d=e,e=(d-c)/2+c}return e}function n(a,b){var c=o(a,b);return((l*c+k)*c+j)*c}function m(a){return((i*a+h)*a+g)*a}var g=3*b,h=3*(d-b)-g,i=1-g-h,j=3*c,k=3*(e-c)-j,l=1-j-k;return n(a,1/(200*f))}function cd(){return this.x+q+this.y+q+this.width+" × "+this.height}function cc(){return this.x+q+this.y}function bQ(a,b,c,d,e,f){a!=null?(this.a=+a,this.b=+b,this.c=+c,this.d=+d,this.e=+e,this.f=+f):(this.a=1,this.b=0,this.c=0,this.d=1,this.e=0,this.f=0)}function bw(a){var b=[];for(var c=0,d=a.length;d-2>c;c+=2){var e=[{x:+a[c],y:+a[c+1]},{x:+a[c],y:+a[c+1]},{x:+a[c+2],y:+a[c+3]},{x:+a[c+4],y:+a[c+5]}];d-4==c?(e[0]={x:+a[c-2],y:+a[c-1]},e[3]=e[2]):c&&(e[0]={x:+a[c-2],y:+a[c-1]}),b.push(["C",(-e[0].x+6*e[1].x+e[2].x)/6,(-e[0].y+6*e[1].y+e[2].y)/6,(e[1].x+6*e[2].x-e[3].x)/6,(e[1].y+6*e[2].y-e[3].y)/6,e[2].x,e[2].y])}return b}function bv(){return this.hex}function bt(a,b,c){function d(){var e=Array.prototype.slice.call(arguments,0),f=e.join("␀"),h=d.cache=d.cache||{},i=d.count=d.count||[];if(h[g](f)){bs(i,f);return c?c(h[f]):h[f]}i.length>=1e3&&delete h[i.shift()],i.push(f),h[f]=a[m](b,e);return c?c(h[f]):h[f]}return d}function bs(a,b){for(var c=0,d=a.length;c<d;c++)if(a[c]===b)return a.push(a.splice(c,1)[0])}function a(c){if(a.is(c,"function"))return b?c():eve.on("DOMload",c);if(a.is(c,E))return a._engine.create[m](a,c.splice(0,3+a.is(c[0],C))).add(c);var d=Array.prototype.slice.call(arguments,0);if(a.is(d[d.length-1],"function")){var e=d.pop();return b?e.call(a._engine.create[m](a,d)):eve.on("DOMload",function(){e.call(a._engine.create[m](a,d))})}return a._engine.create[m](a,arguments)}a.version="2.0.1",a.eve=eve;var b,c=/[, ]+/,d={circle:1,rect:1,path:1,ellipse:1,text:1,image:1},e=/\{(\d+)\}/g,f="prototype",g="hasOwnProperty",h={doc:document,win:window},i={was:Object.prototype[g].call(h.win,"Raphael"),is:h.win.Raphael},j=function(){this.ca=this.customAttributes={}},k,l="appendChild",m="apply",n="concat",o="createTouch"in h.doc,p="",q=" ",r=String,s="split",t="click dblclick mousedown mousemove mouseout mouseover mouseup touchstart touchmove touchend touchcancel"[s](q),u={mousedown:"touchstart",mousemove:"touchmove",mouseup:"touchend"},v=r.prototype.toLowerCase,w=Math,x=w.max,y=w.min,z=w.abs,A=w.pow,B=w.PI,C="number",D="string",E="array",F="toString",G="fill",H=Object.prototype.toString,I={},J="push",K=a._ISURL=/^url\(['"]?([^\)]+?)['"]?\)$/i,L=/^\s*((#[a-f\d]{6})|(#[a-f\d]{3})|rgba?\(\s*([\d\.]+%?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+%?)?)\s*\)|hsba?\(\s*([\d\.]+(?:deg|\xb0|%)?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+(?:%?\s*,\s*[\d\.]+)?)%?\s*\)|hsla?\(\s*([\d\.]+(?:deg|\xb0|%)?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+(?:%?\s*,\s*[\d\.]+)?)%?\s*\))\s*$/i,M={NaN:1,Infinity:1,"-Infinity":1},N=/^(?:cubic-)?bezier\(([^,]+),([^,]+),([^,]+),([^\)]+)\)/,O=w.round,P="setAttribute",Q=parseFloat,R=parseInt,S=r.prototype.toUpperCase,T=a._availableAttrs={"arrow-end":"none","arrow-start":"none",blur:0,"clip-rect":"0 0 1e9 1e9",cursor:"default",cx:0,cy:0,fill:"#fff","fill-opacity":1,font:'10px "Arial"',"font-family":'"Arial"',"font-size":"10","font-style":"normal","font-weight":400,gradient:0,height:0,href:"http://raphaeljs.com/","letter-spacing":0,opacity:1,path:"M0,0",r:0,rx:0,ry:0,src:"",stroke:"#000","stroke-dasharray":"","stroke-linecap":"butt","stroke-linejoin":"butt","stroke-miterlimit":0,"stroke-opacity":1,"stroke-width":1,target:"_blank","text-anchor":"middle",title:"Raphael",transform:"",width:0,x:0,y:0},U=a._availableAnimAttrs={blur:C,"clip-rect":"csv",cx:C,cy:C,fill:"colour","fill-opacity":C,"font-size":C,height:C,opacity:C,path:"path",r:C,rx:C,ry:C,stroke:"colour","stroke-opacity":C,"stroke-width":C,transform:"transform",width:C,x:C,y:C},V=/\s*,\s*/,W={hs:1,rg:1},X=/,?([achlmqrstvxz]),?/gi,Y=/([achlmrqstvz])[\s,]*((-?\d*\.?\d*(?:e[\-+]?\d+)?\s*,?\s*)+)/ig,Z=/([rstm])[\s,]*((-?\d*\.?\d*(?:e[\-+]?\d+)?\s*,?\s*)+)/ig,$=/(-?\d*\.?\d*(?:e[\-+]?\d+)?)\s*,?\s*/ig,_=a._radial_gradient=/^r(?:\(([^,]+?)\s*,\s*([^\)]+?)\))?/,ba={},bb=function(a,b){return a.key-b.key},bc=function(a,b){return Q(a)-Q(b)},bd=function(){},be=function(a){return a},bf=a._rectPath=function(a,b,c,d,e){if(e)return[["M",a+e,b],["l",c-e*2,0],["a",e,e,0,0,1,e,e],["l",0,d-e*2],["a",e,e,0,0,1,-e,e],["l",e*2-c,0],["a",e,e,0,0,1,-e,-e],["l",0,e*2-d],["a",e,e,0,0,1,e,-e],["z"]];return[["M",a,b],["l",c,0],["l",0,d],["l",-c,0],["z"]]},bg=function(a,b,c,d){d==null&&(d=c);return[["M",a,b],["m",0,-d],["a",c,d,0,1,1,0,2*d],["a",c,d,0,1,1,0,-2*d],["z"]]},bh=a._getPath={path:function(a){return a.attr("path")},circle:function(a){var b=a.attrs;return bg(b.cx,b.cy,b.r)},ellipse:function(a){var b=a.attrs;return bg(b.cx,b.cy,b.rx,b.ry)},rect:function(a){var b=a.attrs;return bf(b.x,b.y,b.width,b.height,b.r)},image:function(a){var b=a.attrs;return bf(b.x,b.y,b.width,b.height)},text:function(a){var b=a._getBBox();return bf(b.x,b.y,b.width,b.height)}},bi=a.mapPath=function(a,b){if(!b)return a;var c,d,e,f,g,h,i;a=bG(a);for(e=0,g=a.length;e<g;e++){i=a[e];for(f=1,h=i.length;f<h;f+=2)c=b.x(i[f],i[f+1]),d=b.y(i[f],i[f+1]),i[f]=c,i[f+1]=d}return a};a._g=h,a.type=h.win.SVGAngle||h.doc.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1")?"SVG":"VML";if(a.type=="VML"){var bj=h.doc.createElement("div"),bk;bj.innerHTML='<v:shape adj="1"/>',bk=bj.firstChild,bk.style.behavior="url(#default#VML)";if(!bk||typeof bk.adj!="object")return a.type=p;bj=null}a.svg=!(a.vml=a.type=="VML"),a._Paper=j,a.fn=k=j.prototype=a.prototype,a._id=0,a._oid=0,a.is=function(a,b){b=v.call(b);if(b=="finite")return!M[g](+a);if(b=="array")return a instanceof Array;return b=="null"&&a===null||b==typeof a&&a!==null||b=="object"&&a===Object(a)||b=="array"&&Array.isArray&&Array.isArray(a)||H.call(a).slice(8,-1).toLowerCase()==b},a.angle=function(b,c,d,e,f,g){if(f==null){var h=b-d,i=c-e;if(!h&&!i)return 0;return(180+w.atan2(-i,-h)*180/B+360)%360}return a.angle(b,c,f,g)-a.angle(d,e,f,g)},a.rad=function(a){return a%360*B/180},a.deg=function(a){return a*180/B%360},a.snapTo=function(b,c,d){d=a.is(d,"finite")?d:10;if(a.is(b,E)){var e=b.length;while(e--)if(z(b[e]-c)<=d)return b[e]}else{b=+b;var f=c%b;if(f<d)return c-f;if(f>b-d)return c-f+b}return c};var bl=a.createUUID=function(a,b){return function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(a,b).toUpperCase()}}(/[xy]/g,function(a){var b=w.random()*16|0,c=a=="x"?b:b&3|8;return c.toString(16)});a.setWindow=function(b){eve("setWindow",a,h.win,b),h.win=b,h.doc=h.win.document,a._engine.initWin&&a._engine.initWin(h.win)};var bm=function(b){if(a.vml){var c=/^\s+|\s+$/g,d;try{var e=new ActiveXObject("htmlfile");e.write("<body>"),e.close(),d=e.body}catch(f){d=createPopup().document.body}var g=d.createTextRange();bm=bt(function(a){try{d.style.color=r(a).replace(c,p);var b=g.queryCommandValue("ForeColor");b=(b&255)<<16|b&65280|(b&16711680)>>>16;return"#"+("000000"+b.toString(16)).slice(-6)}catch(e){return"none"}})}else{var i=h.doc.createElement("i");i.title="Raphaël Colour Picker",i.style.display="none",h.doc.body.appendChild(i),bm=bt(function(a){i.style.color=a;return h.doc.defaultView.getComputedStyle(i,p).getPropertyValue("color")})}return bm(b)},bn=function(){return"hsb("+[this.h,this.s,this.b]+")"},bo=function(){return"hsl("+[this.h,this.s,this.l]+")"},bp=function(){return this.hex},bq=function(b,c,d){c==null&&a.is(b,"object")&&"r"in b&&"g"in b&&"b"in b&&(d=b.b,c=b.g,b=b.r);if(c==null&&a.is(b,D)){var e=a.getRGB(b);b=e.r,c=e.g,d=e.b}if(b>1||c>1||d>1)b/=255,c/=255,d/=255;return[b,c,d]},br=function(b,c,d,e){b*=255,c*=255,d*=255;var f={r:b,g:c,b:d,hex:a.rgb(b,c,d),toString:bp};a.is(e,"finite")&&(f.opacity=e);return f};a.color=function(b){var c;a.is(b,"object")&&"h"in b&&"s"in b&&"b"in b?(c=a.hsb2rgb(b),b.r=c.r,b.g=c.g,b.b=c.b,b.hex=c.hex):a.is(b,"object")&&"h"in b&&"s"in b&&"l"in b?(c=a.hsl2rgb(b),b.r=c.r,b.g=c.g,b.b=c.b,b.hex=c.hex):(a.is(b,"string")&&(b=a.getRGB(b)),a.is(b,"object")&&"r"in b&&"g"in b&&"b"in b?(c=a.rgb2hsl(b),b.h=c.h,b.s=c.s,b.l=c.l,c=a.rgb2hsb(b),b.v=c.b):(b={hex:"none"},b.r=b.g=b.b=b.h=b.s=b.v=b.l=-1)),b.toString=bp;return b},a.hsb2rgb=function(a,b,c,d){this.is(a,"object")&&"h"in a&&"s"in a&&"b"in a&&(c=a.b,b=a.s,a=a.h,d=a.o),a*=360;var e,f,g,h,i;a=a%360/60,i=c*b,h=i*(1-z(a%2-1)),e=f=g=c-i,a=~~a,e+=[i,h,0,0,h,i][a],f+=[h,i,i,h,0,0][a],g+=[0,0,h,i,i,h][a];return br(e,f,g,d)},a.hsl2rgb=function(a,b,c,d){this.is(a,"object")&&"h"in a&&"s"in a&&"l"in a&&(c=a.l,b=a.s,a=a.h);if(a>1||b>1||c>1)a/=360,b/=100,c/=100;a*=360;var e,f,g,h,i;a=a%360/60,i=2*b*(c<.5?c:1-c),h=i*(1-z(a%2-1)),e=f=g=c-i/2,a=~~a,e+=[i,h,0,0,h,i][a],f+=[h,i,i,h,0,0][a],g+=[0,0,h,i,i,h][a];return br(e,f,g,d)},a.rgb2hsb=function(a,b,c){c=bq(a,b,c),a=c[0],b=c[1],c=c[2];var d,e,f,g;f=x(a,b,c),g=f-y(a,b,c),d=g==0?null:f==a?(b-c)/g:f==b?(c-a)/g+2:(a-b)/g+4,d=(d+360)%6*60/360,e=g==0?0:g/f;return{h:d,s:e,b:f,toString:bn}},a.rgb2hsl=function(a,b,c){c=bq(a,b,c),a=c[0],b=c[1],c=c[2];var d,e,f,g,h,i;g=x(a,b,c),h=y(a,b,c),i=g-h,d=i==0?null:g==a?(b-c)/i:g==b?(c-a)/i+2:(a-b)/i+4,d=(d+360)%6*60/360,f=(g+h)/2,e=i==0?0:f<.5?i/(2*f):i/(2-2*f);return{h:d,s:e,l:f,toString:bo}},a._path2string=function(){return this.join(",").replace(X,"$1")};var bu=a._preload=function(a,b){var c=h.doc.createElement("img");c.style.cssText="position:absolute;left:-9999em;top:-9999em",c.onload=function(){b.call(this),this.onload=null,h.doc.body.removeChild(this)},c.onerror=function(){h.doc.body.removeChild(this)},h.doc.body.appendChild(c),c.src=a};a.getRGB=bt(function(b){if(!b||!!((b=r(b)).indexOf("-")+1))return{r:-1,g:-1,b:-1,hex:"none",error:1,toString:bv};if(b=="none")return{r:-1,g:-1,b:-1,hex:"none",toString:bv};!W[g](b.toLowerCase().substring(0,2))&&b.charAt()!="#"&&(b=bm(b));var c,d,e,f,h,i,j,k=b.match(L);if(k){k[2]&&(f=R(k[2].substring(5),16),e=R(k[2].substring(3,5),16),d=R(k[2].substring(1,3),16)),k[3]&&(f=R((i=k[3].charAt(3))+i,16),e=R((i=k[3].charAt(2))+i,16),d=R((i=k[3].charAt(1))+i,16)),k[4]&&(j=k[4][s](V),d=Q(j[0]),j[0].slice(-1)=="%"&&(d*=2.55),e=Q(j[1]),j[1].slice(-1)=="%"&&(e*=2.55),f=Q(j[2]),j[2].slice(-1)=="%"&&(f*=2.55),k[1].toLowerCase().slice(0,4)=="rgba"&&(h=Q(j[3])),j[3]&&j[3].slice(-1)=="%"&&(h/=100));if(k[5]){j=k[5][s](V),d=Q(j[0]),j[0].slice(-1)=="%"&&(d*=2.55),e=Q(j[1]),j[1].slice(-1)=="%"&&(e*=2.55),f=Q(j[2]),j[2].slice(-1)=="%"&&(f*=2.55),(j[0].slice(-3)=="deg"||j[0].slice(-1)=="°")&&(d/=360),k[1].toLowerCase().slice(0,4)=="hsba"&&(h=Q(j[3])),j[3]&&j[3].slice(-1)=="%"&&(h/=100);return a.hsb2rgb(d,e,f,h)}if(k[6]){j=k[6][s](V),d=Q(j[0]),j[0].slice(-1)=="%"&&(d*=2.55),e=Q(j[1]),j[1].slice(-1)=="%"&&(e*=2.55),f=Q(j[2]),j[2].slice(-1)=="%"&&(f*=2.55),(j[0].slice(-3)=="deg"||j[0].slice(-1)=="°")&&(d/=360),k[1].toLowerCase().slice(0,4)=="hsla"&&(h=Q(j[3])),j[3]&&j[3].slice(-1)=="%"&&(h/=100);return a.hsl2rgb(d,e,f,h)}k={r:d,g:e,b:f,toString:bv},k.hex="#"+(16777216|f|e<<8|d<<16).toString(16).slice(1),a.is(h,"finite")&&(k.opacity=h);return k}return{r:-1,g:-1,b:-1,hex:"none",error:1,toString:bv}},a),a.hsb=bt(function(b,c,d){return a.hsb2rgb(b,c,d).hex}),a.hsl=bt(function(b,c,d){return a.hsl2rgb(b,c,d).hex}),a.rgb=bt(function(a,b,c){return"#"+(16777216|c|b<<8|a<<16).toString(16).slice(1)}),a.getColor=function(a){var b=this.getColor.start=this.getColor.start||{h:0,s:1,b:a||.75},c=this.hsb2rgb(b.h,b.s,b.b);b.h+=.075,b.h>1&&(b.h=0,b.s-=.2,b.s<=0&&(this.getColor.start={h:0,s:1,b:b.b}));return c.hex},a.getColor.reset=function(){delete this.start},a.parsePathString=bt(function(b){if(!b)return null;var c={a:7,c:6,h:1,l:2,m:2,r:4,q:4,s:4,t:2,v:1,z:0},d=[];a.is(b,E)&&a.is(b[0],E)&&(d=by(b)),d.length||r(b).replace(Y,function(a,b,e){var f=[],g=b.toLowerCase();e.replace($,function(a,b){b&&f.push(+b)}),g=="m"&&f.length>2&&(d.push([b][n](f.splice(0,2))),g="l",b=b=="m"?"l":"L");if(g=="r")d.push([b][n](f));else while(f.length>=c[g]){d.push([b][n](f.splice(0,c[g])));if(!c[g])break}}),d.toString=a._path2string;return d}),a.parseTransformString=bt(function(b){if(!b)return null;var c={r:3,s:4,t:2,m:6},d=[];a.is(b,E)&&a.is(b[0],E)&&(d=by(b)),d.length||r(b).replace(Z,function(a,b,c){var e=[],f=v.call(b);c.replace($,function(a,b){b&&e.push(+b)}),d.push([b][n](e))}),d.toString=a._path2string;return d}),a.findDotsAtSegment=function(a,b,c,d,e,f,g,h,i){var j=1-i,k=A(j,3),l=A(j,2),m=i*i,n=m*i,o=k*a+l*3*i*c+j*3*i*i*e+n*g,p=k*b+l*3*i*d+j*3*i*i*f+n*h,q=a+2*i*(c-a)+m*(e-2*c+a),r=b+2*i*(d-b)+m*(f-2*d+b),s=c+2*i*(e-c)+m*(g-2*e+c),t=d+2*i*(f-d)+m*(h-2*f+d),u=j*a+i*c,v=j*b+i*d,x=j*e+i*g,y=j*f+i*h,z=90-w.atan2(q-s,r-t)*180/B;(q>s||r<t)&&(z+=180);return{x:o,y:p,m:{x:q,y:r},n:{x:s,y:t},start:{x:u,y:v},end:{x:x,y:y},alpha:z}},a._removedFactory=function(a){return function(){throw new Error("Raphaël: you are calling to method “"+a+"” of removed object")}};var bx=bt(function(a){if(!a)return{x:0,y:0,width:0,height:0};a=bG(a);var b=0,c=0,d=[],e=[],f;for(var g=0,h=a.length;g<h;g++){f=a[g];if(f[0]=="M")b=f[1],c=f[2],d.push(b),e.push(c);else{var i=bF(b,c,f[1],f[2],f[3],f[4],f[5],f[6]);d=d[n](i.min.x,i.max.x),e=e[n](i.min.y,i.max.y),b=f[5],c=f[6]}}var j=y[m](0,d),k=y[m](0,e);return{x:j,y:k,width:x[m](0,d)-j,height:x[m](0,e)-k}},null,function(a){return{x:a.x,y:a.y,width:a.width,height:a.height}}),by=function(b){var c=[];if(!a.is(b,E)||!a.is(b&&b[0],E))b=a.parsePathString(b);for(var d=0,e=b.length;d<e;d++){c[d]=[];for(var f=0,g=b[d].length;f<g;f++)c[d][f]=b[d][f]}c.toString=a._path2string;return c},bz=a._pathToRelative=bt(function(b){if(!a.is(b,E)||!a.is(b&&b[0],E))b=a.parsePathString(b);var c=[],d=0,e=0,f=0,g=0,h=0;b[0][0]=="M"&&(d=b[0][1],e=b[0][2],f=d,g=e,h++,c.push(["M",d,e]));for(var i=h,j=b.length;i<j;i++){var k=c[i]=[],l=b[i];if(l[0]!=v.call(l[0])){k[0]=v.call(l[0]);switch(k[0]){case"a":k[1]=l[1],k[2]=l[2],k[3]=l[3],k[4]=l[4],k[5]=l[5],k[6]=+(l[6]-d).toFixed(3),k[7]=+(l[7]-e).toFixed(3);break;case"v":k[1]=+(l[1]-e).toFixed(3);break;case"m":f=l[1],g=l[2];default:for(var m=1,n=l.length;m<n;m++)k[m]=+(l[m]-(m%2?d:e)).toFixed(3)}}else{k=c[i]=[],l[0]=="m"&&(f=l[1]+d,g=l[2]+e);for(var o=0,p=l.length;o<p;o++)c[i][o]=l[o]}var q=c[i].length;switch(c[i][0]){case"z":d=f,e=g;break;case"h":d+=+c[i][q-1];break;case"v":e+=+c[i][q-1];break;default:d+=+c[i][q-2],e+=+c[i][q-1]}}c.toString=a._path2string;return c},0,by),bA=a._pathToAbsolute=bt(function(b){if(!a.is(b,E)||!a.is(b&&b[0],E))b=a.parsePathString(b);if(!b||!b.length)return[["M",0,0]];var c=[],d=0,e=0,f=0,g=0,h=0;b[0][0]=="M"&&(d=+b[0][1],e=+b[0][2],f=d,g=e,h++,c[0]=["M",d,e]);for(var i,j,k=h,l=b.length;k<l;k++){c.push(i=[]),j=b[k];if(j[0]!=S.call(j[0])){i[0]=S.call(j[0]);switch(i[0]){case"A":i[1]=j[1],i[2]=j[2],i[3]=j[3],i[4]=j[4],i[5]=j[5],i[6]=+(j[6]+d),i[7]=+(j[7]+e);break;case"V":i[1]=+j[1]+e;break;case"H":i[1]=+j[1]+d;break;case"R":var m=[d,e][n](j.slice(1));for(var o=2,p=m.length;o<p;o++)m[o]=+m[o]+d,m[++o]=+m[o]+e;c.pop(),c=c[n](bw(m));break;case"M":f=+j[1]+d,g=+j[2]+e;default:for(o=1,p=j.length;o<p;o++)i[o]=+j[o]+(o%2?d:e)}}else if(j[0]=="R")m=[d,e][n](j.slice(1)),c.pop(),c=c[n](bw(m)),i=["R"][n](j.slice(-2));else for(var q=0,r=j.length;q<r;q++)i[q]=j[q];switch(i[0]){case"Z":d=f,e=g;break;case"H":d=i[1];break;case"V":e=i[1];break;case"M":f=i[i.length-2],g=i[i.length-1];default:d=i[i.length-2],e=i[i.length-1]}}c.toString=a._path2string;return c},null,by),bB=function(a,b,c,d){return[a,b,c,d,c,d]},bC=function(a,b,c,d,e,f){var g=1/3,h=2/3;return[g*a+h*c,g*b+h*d,g*e+h*c,g*f+h*d,e,f]},bD=function(a,b,c,d,e,f,g,h,i,j){var k=B*120/180,l=B/180*(+e||0),m=[],o,p=bt(function(a,b,c){var d=a*w.cos(c)-b*w.sin(c),e=a*w.sin(c)+b*w.cos(c);return{x:d,y:e}});if(!j){o=p(a,b,-l),a=o.x,b=o.y,o=p(h,i,-l),h=o.x,i=o.y;var q=w.cos(B/180*e),r=w.sin(B/180*e),t=(a-h)/2,u=(b-i)/2,v=t*t/(c*c)+u*u/(d*d);v>1&&(v=w.sqrt(v),c=v*c,d=v*d);var x=c*c,y=d*d,A=(f==g?-1:1)*w.sqrt(z((x*y-x*u*u-y*t*t)/(x*u*u+y*t*t))),C=A*c*u/d+(a+h)/2,D=A*-d*t/c+(b+i)/2,E=w.asin(((b-D)/d).toFixed(9)),F=w.asin(((i-D)/d).toFixed(9));E=a<C?B-E:E,F=h<C?B-F:F,E<0&&(E=B*2+E),F<0&&(F=B*2+F),g&&E>F&&(E=E-B*2),!g&&F>E&&(F=F-B*2)}else E=j[0],F=j[1],C=j[2],D=j[3];var G=F-E;if(z(G)>k){var H=F,I=h,J=i;F=E+k*(g&&F>E?1:-1),h=C+c*w.cos(F),i=D+d*w.sin(F),m=bD(h,i,c,d,e,0,g,I,J,[F,H,C,D])}G=F-E;var K=w.cos(E),L=w.sin(E),M=w.cos(F),N=w.sin(F),O=w.tan(G/4),P=4/3*c*O,Q=4/3*d*O,R=[a,b],S=[a+P*L,b-Q*K],T=[h+P*N,i-Q*M],U=[h,i];S[0]=2*R[0]-S[0],S[1]=2*R[1]-S[1];if(j)return[S,T,U][n](m);m=[S,T,U][n](m).join()[s](",");var V=[];for(var W=0,X=m.length;W<X;W++)V[W]=W%2?p(m[W-1],m[W],l).y:p(m[W],m[W+1],l).x;return V},bE=function(a,b,c,d,e,f,g,h,i){var j=1-i;return{x:A(j,3)*a+A(j,2)*3*i*c+j*3*i*i*e+A(i,3)*g,y:A(j,3)*b+A(j,2)*3*i*d+j*3*i*i*f+A(i,3)*h}},bF=bt(function(a,b,c,d,e,f,g,h){var i=e-2*c+a-(g-2*e+c),j=2*(c-a)-2*(e-c),k=a-c,l=(-j+w.sqrt(j*j-4*i*k))/2/i,n=(-j-w.sqrt(j*j-4*i*k))/2/i,o=[b,h],p=[a,g],q;z(l)>"1e12"&&(l=.5),z(n)>"1e12"&&(n=.5),l>0&&l<1&&(q=bE(a,b,c,d,e,f,g,h,l),p.push(q.x),o.push(q.y)),n>0&&n<1&&(q=bE(a,b,c,d,e,f,g,h,n),p.push(q.x),o.push(q.y)),i=f-2*d+b-(h-2*f+d),j=2*(d-b)-2*(f-d),k=b-d,l=(-j+w.sqrt(j*j-4*i*k))/2/i,n=(-j-w.sqrt(j*j-4*i*k))/2/i,z(l)>"1e12"&&(l=.5),z(n)>"1e12"&&(n=.5),l>0&&l<1&&(q=bE(a,b,c,d,e,f,g,h,l),p.push(q.x),o.push(q.y)),n>0&&n<1&&(q=bE(a,b,c,d,e,f,g,h,n),p.push(q.x),o.push(q.y));return{min:{x:y[m](0,p),y:y[m](0,o)},max:{x:x[m](0,p),y:x[m](0,o)}}}),bG=a._path2curve=bt(function(a,b){var c=bA(a),d=b&&bA(b),e={x:0,y:0,bx:0,by:0,X:0,Y:0,qx:null,qy:null},f={x:0,y:0,bx:0,by:0,X:0,Y:0,qx:null,qy:null},g=function(a,b){var c,d;if(!a)return["C",b.x,b.y,b.x,b.y,b.x,b.y];!(a[0]in{T:1,Q:1})&&(b.qx=b.qy=null);switch(a[0]){case"M":b.X=a[1],b.Y=a[2];break;case"A":a=["C"][n](bD[m](0,[b.x,b.y][n](a.slice(1))));break;case"S":c=b.x+(b.x-(b.bx||b.x)),d=b.y+(b.y-(b.by||b.y)),a=["C",c,d][n](a.slice(1));break;case"T":b.qx=b.x+(b.x-(b.qx||b.x)),b.qy=b.y+(b.y-(b.qy||b.y)),a=["C"][n](bC(b.x,b.y,b.qx,b.qy,a[1],a[2]));break;case"Q":b.qx=a[1],b.qy=a[2],a=["C"][n](bC(b.x,b.y,a[1],a[2],a[3],a[4]));break;case"L":a=["C"][n](bB(b.x,b.y,a[1],a[2]));break;case"H":a=["C"][n](bB(b.x,b.y,a[1],b.y));break;case"V":a=["C"][n](bB(b.x,b.y,b.x,a[1]));break;case"Z":a=["C"][n](bB(b.x,b.y,b.X,b.Y))}return a},h=function(a,b){if(a[b].length>7){a[b].shift();var e=a[b];while(e.length)a.splice(b++,0,["C"][n](e.splice(0,6)));a.splice(b,1),k=x(c.length,d&&d.length||0)}},i=function(a,b,e,f,g){a&&b&&a[g][0]=="M"&&b[g][0]!="M"&&(b.splice(g,0,["M",f.x,f.y]),e.bx=0,e.by=0,e.x=a[g][1],e.y=a[g][2],k=x(c.length,d&&d.length||0))};for(var j=0,k=x(c.length,d&&d.length||0);j<k;j++){c[j]=g(c[j],e),h(c,j),d&&(d[j]=g(d[j],f)),d&&h(d,j),i(c,d,e,f,j),i(d,c,f,e,j);var l=c[j],o=d&&d[j],p=l.length,q=d&&o.length;e.x=l[p-2],e.y=l[p-1],e.bx=Q(l[p-4])||e.x,e.by=Q(l[p-3])||e.y,f.bx=d&&(Q(o[q-4])||f.x),f.by=d&&(Q(o[q-3])||f.y),f.x=d&&o[q-2],f.y=d&&o[q-1]}return d?[c,d]:c},null,by),bH=a._parseDots=bt(function(b){var c=[];for(var d=0,e=b.length;d<e;d++){var f={},g=b[d].match(/^([^:]*):?([\d\.]*)/);f.color=a.getRGB(g[1]);if(f.color.error)return null;f.color=f.color.hex,g[2]&&(f.offset=g[2]+"%"),c.push(f)}for(d=1,e=c.length-1;d<e;d++)if(!c[d].offset){var h=Q(c[d-1].offset||0),i=0;for(var j=d+1;j<e;j++)if(c[j].offset){i=c[j].offset;break}i||(i=100,j=e),i=Q(i);var k=(i-h)/(j-d+1);for(;d<j;d++)h+=k,c[d].offset=h+"%"}return c}),bI=a._tear=function(a,b){a==b.top&&(b.top=a.prev),a==b.bottom&&(b.bottom=a.next),a.next&&(a.next.prev=a.prev),a.prev&&(a.prev.next=a.next)},bJ=a._tofront=function(a,b){b.top!==a&&(bI(a,b),a.next=null,a.prev=b.top,b.top.next=a,b.top=a)},bK=a._toback=function(a,b){b.bottom!==a&&(bI(a,b),a.next=b.bottom,a.prev=null,b.bottom.prev=a,b.bottom=a)},bL=a._insertafter=function(a,b,c){bI(a,c),b==c.top&&(c.top=a),b.next&&(b.next.prev=a),a.next=b.next,a.prev=b,b.next=a},bM=a._insertbefore=function(a,b,c){bI(a,c),b==c.bottom&&(c.bottom=a),b.prev&&(b.prev.next=a),a.prev=b.prev,b.prev=a,a.next=b},bN=a._extractTransform=function(b,c){if(c==null)return b._.transform;c=r(c).replace(/\.{3}|\u2026/g,b._.transform||p);var d=a.parseTransformString(c),e=0,f=0,g=0,h=1,i=1,j=b._,k=new bQ;j.transform=d||[];if(d)for(var l=0,m=d.length;l<m;l++){var n=d[l],o=n.length,q=r(n[0]).toLowerCase(),s=n[0]!=q,t=s?k.invert():0,u,v,w,x,y;q=="t"&&o==3?s?(u=t.x(0,0),v=t.y(0,0),w=t.x(n[1],n[2]),x=t.y(n[1],n[2]),k.translate(w-u,x-v)):k.translate(n[1],n[2]):q=="r"?o==2?(y=y||b.getBBox(1),k.rotate(n[1],y.x+y.width/2,y.y+y.height/2),e+=n[1]):o==4&&(s?(w=t.x(n[2],n[3]),x=t.y(n[2],n[3]),k.rotate(n[1],w,x)):k.rotate(n[1],n[2],n[3]),e+=n[1]):q=="s"?o==2||o==3?(y=y||b.getBBox(1),k.scale(n[1],n[o-1],y.x+y.width/2,y.y+y.height/2),h*=n[1],i*=n[o-1]):o==5&&(s?(w=t.x(n[3],n[4]),x=t.y(n[3],n[4]),k.scale(n[1],n[2],w,x)):k.scale(n[1],n[2],n[3],n[4]),h*=n[1],i*=n[2]):q=="m"&&o==7&&k.add(n[1],n[2],n[3],n[4],n[5],n[6]),j.dirtyT=1,b.matrix=k}b.matrix=k,j.sx=h,j.sy=i,j.deg=e,j.dx=f=k.e,j.dy=g=k.f,h==1&&i==1&&!e&&j.bbox?(j.bbox.x+=+f,j.bbox.y+=+g):j.dirtyT=1},bO=function(a){var b=a[0];switch(b.toLowerCase()){case"t":return[b,0,0];case"m":return[b,1,0,0,1,0,0];case"r":return a.length==4?[b,0,a[2],a[3]]:[b,0];case"s":return a.length==5?[b,1,1,a[3],a[4]]:a.length==3?[b,1,1]:[b,1]}},bP=a._equaliseTransform=function(b,c){c=r(c).replace(/\.{3}|\u2026/g,b),b=a.parseTransformString(b)||[],c=a.parseTransformString(c)||[];var d=x(b.length,c.length),e=[],f=[],g=0,h,i,j,k;for(;g<d;g++){j=b[g]||bO(c[g]),k=c[g]||bO(j);if(j[0]!=k[0]||j[0].toLowerCase()=="r"&&(j[2]!=k[2]||j[3]!=k[3])||j[0].toLowerCase()=="s"&&(j[3]!=k[3]||j[4]!=k[4]))return;e[g]=[],f[g]=[];for(h=0,i=x(j.length,k.length);h<i;h++)h in j&&(e[g][h]=j[h]),h in k&&(f[g][h]=k[h])}return{from:e,to:f}};a._getContainer=function(b,c,d,e){var f;f=e==null&&!a.is(b,"object")?h.doc.getElementById(b):b;if(f!=null){if(f.tagName)return c==null?{container:f,width:f.style.pixelWidth||f.offsetWidth,height:f.style.pixelHeight||f.offsetHeight}:{container:f,width:c,height:d};return{container:1,x:b,y:c,width:d,height:e}}},a.pathToRelative=bz,a._engine={},a.path2curve=bG,a.matrix=function(a,b,c,d,e,f){return new bQ(a,b,c,d,e,f)},function(b){function d(a){var b=w.sqrt(c(a));a[0]&&(a[0]/=b),a[1]&&(a[1]/=b)}function c(a){return a[0]*a[0]+a[1]*a[1]}b.add=function(a,b,c,d,e,f){var g=[[],[],[]],h=[[this.a,this.c,this.e],[this.b,this.d,this.f],[0,0,1]],i=[[a,c,e],[b,d,f],[0,0,1]],j,k,l,m;a&&a instanceof bQ&&(i=[[a.a,a.c,a.e],[a.b,a.d,a.f],[0,0,1]]);for(j=0;j<3;j++)for(k=0;k<3;k++){m=0;for(l=0;l<3;l++)m+=h[j][l]*i[l][k];g[j][k]=m}this.a=g[0][0],this.b=g[1][0],this.c=g[0][1],this.d=g[1][1],this.e=g[0][2],this.f=g[1][2]},b.invert=function(){var a=this,b=a.a*a.d-a.b*a.c;return new bQ(a.d/b,-a.b/b,-a.c/b,a.a/b,(a.c*a.f-a.d*a.e)/b,(a.b*a.e-a.a*a.f)/b)},b.clone=function(){return new bQ(this.a,this.b,this.c,this.d,this.e,this.f)},b.translate=function(a,b){this.add(1,0,0,1,a,b)},b.scale=function(a,b,c,d){b==null&&(b=a),(c||d)&&this.add(1,0,0,1,c,d),this.add(a,0,0,b,0,0),(c||d)&&this.add(1,0,0,1,-c,-d)},b.rotate=function(b,c,d){b=a.rad(b),c=c||0,d=d||0;var e=+w.cos(b).toFixed(9),f=+w.sin(b).toFixed(9);this.add(e,f,-f,e,c,d),this.add(1,0,0,1,-c,-d)},b.x=function(a,b){return a*this.a+b*this.c+this.e},b.y=function(a,b){return a*this.b+b*this.d+this.f},b.get=function(a){return+this[r.fromCharCode(97+a)].toFixed(4)},b.toString=function(){return a.svg?"matrix("+[this.get(0),this.get(1),this.get(2),this.get(3),this.get(4),this.get(5)].join()+")":[this.get(0),this.get(2),this.get(1),this.get(3),0,0].join()},b.toFilter=function(){return"progid:DXImageTransform.Microsoft.Matrix(M11="+this.get(0)+", M12="+this.get(2)+", M21="+this.get(1)+", M22="+this.get(3)+", Dx="+this.get(4)+", Dy="+this.get(5)+", sizingmethod='auto expand')"},b.offset=function(){return[this.e.toFixed(4),this.f.toFixed(4)]},b.split=function(){var b={};b.dx=this.e,b.dy=this.f;var e=[[this.a,this.c],[this.b,this.d]];b.scalex=w.sqrt(c(e[0])),d(e[0]),b.shear=e[0][0]*e[1][0]+e[0][1]*e[1][1],e[1]=[e[1][0]-e[0][0]*b.shear,e[1][1]-e[0][1]*b.shear],b.scaley=w.sqrt(c(e[1])),d(e[1]),b.shear/=b.scaley;var f=-e[0][1],g=e[1][1];g<0?(b.rotate=a.deg(w.acos(g)),f<0&&(b.rotate=360-b.rotate)):b.rotate=a.deg(w.asin(f)),b.isSimple=!+b.shear.toFixed(9)&&(b.scalex.toFixed(9)==b.scaley.toFixed(9)||!b.rotate),b.isSuperSimple=!+b.shear.toFixed(9)&&b.scalex.toFixed(9)==b.scaley.toFixed(9)&&!b.rotate,b.noRotation=!+b.shear.toFixed(9)&&!b.rotate;return b},b.toTransformString=function(a){var b=a||this[s]();if(b.isSimple){b.scalex=+b.scalex.toFixed(4),b.scaley=+b.scaley.toFixed(4),b.rotate=+b.rotate.toFixed(4);return(b.dx&&b.dy?"t"+[b.dx,b.dy]:p)+(b.scalex!=1||b.scaley!=1?"s"+[b.scalex,b.scaley,0,0]:p)+(b.rotate?"r"+[b.rotate,0,0]:p)}return"m"+[this.get(0),this.get(1),this.get(2),this.get(3),this.get(4),this.get(5)]}}(bQ.prototype);var bR=navigator.userAgent.match(/Version\/(.*?)\s/)||navigator.userAgent.match(/Chrome\/(\d+)/);navigator.vendor=="Apple Computer, Inc."&&(bR&&bR[1]<4||navigator.platform.slice(0,2)=="iP")||navigator.vendor=="Google Inc."&&bR&&bR[1]<8?k.safari=function(){var a=this.rect(-99,-99,this.width+99,this.height+99).attr({stroke:"none"});setTimeout(function(){a.remove()})}:k.safari=bd;var bS=function(){this.returnValue=!1},bT=function(){return this.originalEvent.preventDefault()},bU=function(){this.cancelBubble=!0},bV=function(){return this.originalEvent.stopPropagation()},bW=function(){if(h.doc.addEventListener)return function(a,b,c,d){var e=o&&u[b]?u[b]:b,f=function(e){var f=h.doc.documentElement.scrollTop||h.doc.body.scrollTop,i=h.doc.documentElement.scrollLeft||h.doc.body.scrollLeft,j=e.clientX+i,k=e.clientY+f;if(o&&u[g](b))for(var l=0,m=e.targetTouches&&e.targetTouches.length;l<m;l++)if(e.targetTouches[l].target==a){var n=e;e=e.targetTouches[l],e.originalEvent=n,e.preventDefault=bT,e.stopPropagation=bV;break}return c.call(d,e,j,k)};a.addEventListener(e,f,!1);return function(){a.removeEventListener(e,f,!1);return!0}};if(h.doc.attachEvent)return function(a,b,c,d){var e=function(a){a=a||h.win.event;var b=h.doc.documentElement.scrollTop||h.doc.body.scrollTop,e=h.doc.documentElement.scrollLeft||h.doc.body.scrollLeft,f=a.clientX+e,g=a.clientY+b;a.preventDefault=a.preventDefault||bS,a.stopPropagation=a.stopPropagation||bU;return c.call(d,a,f,g)};a.attachEvent("on"+b,e);var f=function(){a.detachEvent("on"+b,e);return!0};return f}}(),bX=[],bY=function(a){var b=a.clientX,c=a.clientY,d=h.doc.documentElement.scrollTop||h.doc.body.scrollTop,e=h.doc.documentElement.scrollLeft||h.doc.body.scrollLeft,f,g=bX.length;while(g--){f=bX[g];if(o){var i=a.touches.length,j;while(i--){j=a.touches[i];if(j.identifier==f.el._drag.id){b=j.clientX,c=j.clientY,(a.originalEvent?a.originalEvent:a).preventDefault();break}}}else a.preventDefault();var k=f.el.node,l,m=k.nextSibling,n=k.parentNode,p=k.style.display;h.win.opera&&n.removeChild(k),k.style.display="none",l=f.el.paper.getElementByPoint(b,c),k.style.display=p,h.win.opera&&(m?n.insertBefore(k,m):n.appendChild(k)),l&&eve("drag.over."+f.el.id,f.el,l),b+=e,c+=d,eve("drag.move."+f.el.id,f.move_scope||f.el,b-f.el._drag.x,c-f.el._drag.y,b,c,a)}},bZ=function(b){a.unmousemove(bY).unmouseup(bZ);var c=bX.length,d;while(c--)d=bX[c],d.el._drag={},eve("drag.end."+d.el.id,d.end_scope||d.start_scope||d.move_scope||d.el,b);bX=[]},b$=a.el={};for(var b_=t.length;b_--;)(function(b){a[b]=b$[b]=function(c,d){a.is(c,"function")&&(this.events=this.events||[],this.events.push({name:b,f:c,unbind:bW(this.shape||this.node||h.doc,b,c,d||this)}));return this},a["un"+b]=b$["un"+b]=function(a){var c=this.events,d=c.length;while(d--)if(c[d].name==b&&c[d].f==a){c[d].unbind(),c.splice(d,1),!c.length&&delete this.events;return this}return this}})(t[b_]);b$.data=function(b,c){var d=ba[this.id]=ba[this.id]||{};if(arguments.length==1){if(a.is(b,"object")){for(var e in b)b[g](e)&&this.data(e,b[e]);return this}eve("data.get."+this.id,this,d[b],b);return d[b]}d[b]=c,eve("data.set."+this.id,this,c,b);return this},b$.removeData=function(a){a==null?ba[this.id]={}:ba[this.id]&&delete ba[this.id][a];return this},b$.hover=function(a,b,c,d){return this.mouseover(a,c).mouseout(b,d||c)},b$.unhover=function(a,b){return this.unmouseover(a).unmouseout(b)};var ca=[];b$.drag=function(b,c,d,e,f,g){function i(i){(i.originalEvent||i).preventDefault();var j=h.doc.documentElement.scrollTop||h.doc.body.scrollTop,k=h.doc.documentElement.scrollLeft||h.doc.body.scrollLeft;this._drag.x=i.clientX+k,this._drag.y=i.clientY+j,this._drag.id=i.identifier,!bX.length&&a.mousemove(bY).mouseup(bZ),bX.push({el:this,move_scope:e,start_scope:f,end_scope:g}),c&&eve.on("drag.start."+this.id,c),b&&eve.on("drag.move."+this.id,b),d&&eve.on("drag.end."+this.id,d),eve("drag.start."+this.id,f||e||this,i.clientX+k,i.clientY+j,i)}this._drag={},ca.push({el:this,start:i}),this.mousedown(i);return this},b$.onDragOver=function(a){a?eve.on("drag.over."+this.id,a):eve.unbind("drag.over."+this.id)},b$.undrag=function(){var b=ca.length;while(b--)ca[b].el==this&&(this.unmousedown(ca[b].start),ca.splice(b,1),eve.unbind("drag.*."+this.id));!ca.length&&a.unmousemove(bY).unmouseup(bZ)},k.circle=function(b,c,d){var e=a._engine.circle(this,b||0,c||0,d||0);this.__set__&&this.__set__.push(e);return e},k.rect=function(b,c,d,e,f){var g=a._engine.rect(this,b||0,c||0,d||0,e||0,f||0);this.__set__&&this.__set__.push(g);return g},k.ellipse=function(b,c,d,e){var f=a._engine.ellipse(this,b||0,c||0,d||0,e||0);this.__set__&&this.__set__.push(f);return f},k.path=function(b){b&&!a.is(b,D)&&!a.is(b[0],E)&&(b+=p);var c=a._engine.path(a.format[m](a,arguments),this);this.__set__&&this.__set__.push(c);return c},k.image=function(b,c,d,e,f){var g=a._engine.image(this,b||"about:blank",c||0,d||0,e||0,f||0);this.__set__&&this.__set__.push(g);return g},k.text=function(b,c,d){var e=a._engine.text(this,b||0,c||0,r(d));this.__set__&&this.__set__.push(e);return e},k.set=function(b){!a.is(b,"array")&&(b=Array.prototype.splice.call(arguments,0,arguments.length));var c=new cs(b);this.__set__&&this.__set__.push(c);return c},k.setStart=function(a){this.__set__=a||this.set()},k.setFinish=function(a){var b=this.__set__;delete this.__set__;return b},k.setSize=function(b,c){return a._engine.setSize.call(this,b,c)},k.setViewBox=function(b,c,d,e,f){return a._engine.setViewBox.call(this,b,c,d,e,f)},k.top=k.bottom=null,k.raphael=a;var cb=function(a){var b=a.getBoundingClientRect(),c=a.ownerDocument,d=c.body,e=c.documentElement,f=e.clientTop||d.clientTop||0,g=e.clientLeft||d.clientLeft||0,i=b.top+(h.win.pageYOffset||e.scrollTop||d.scrollTop)-f,j=b.left+(h.win.pageXOffset||e.scrollLeft||d.scrollLeft)-g;return{y:i,x:j}};k.getElementByPoint=function(a,b){var c=this,d=c.canvas,e=h.doc.elementFromPoint(a,b);if(h.win.opera&&e.tagName=="svg"){var f=cb(d),g=d.createSVGRect();g.x=a-f.x,g.y=b-f.y,g.width=g.height=1;var i=d.getIntersectionList(g,null);i.length&&(e=i[i.length-1])}if(!e)return null;while(e.parentNode&&e!=d.parentNode&&!e.raphael)e=e.parentNode;e==c.canvas.parentNode&&(e=d),e=e&&e.raphael?c.getById(e.raphaelid):null;return e},k.getById=function(a){var b=this.bottom;while(b){if(b.id==a)return b;b=b.next}return null},k.forEach=function(a,b){var c=this.bottom;while(c){if(a.call(b,c)===!1)return this;c=c.next}return this},b$.getBBox=function(a){if(this.removed)return{};var b=this._;if(a){if(b.dirty||!b.bboxwt)this.realPath=bh[this.type](this),b.bboxwt=bx(this.realPath),b.bboxwt.toString=cd,b.dirty=0;return b.bboxwt}if(b.dirty||b.dirtyT||!b.bbox){if(b.dirty||!this.realPath)b.bboxwt=0,this.realPath=bh[this.type](this);b.bbox=bx(bi(this.realPath,this.matrix)),b.bbox.toString=cd,b.dirty=b.dirtyT=0}return b.bbox},b$.clone=function(){if(this.removed)return null;var a=this.paper[this.type]().attr(this.attr());this.__set__&&this.__set__.push(a);return a},b$.glow=function(a){if(this.type=="text")return null;a=a||{};var b={width:(a.width||10)+(+this.attr("stroke-width")||1),fill:a.fill||!1,opacity:a.opacity||.5,offsetx:a.offsetx||0,offsety:a.offsety||0,color:a.color||"#000"},c=b.width/2,d=this.paper,e=d.set(),f=this.realPath||bh[this.type](this);f=this.matrix?bi(f,this.matrix):f;for(var g=1;g<c+1;g++)e.push(d.path(f).attr({stroke:b.color,fill:b.fill?b.color:"none","stroke-linejoin":"round","stroke-linecap":"round","stroke-width":+(b.width/c*g).toFixed(3),opacity:+(b.opacity/c).toFixed(3)}));return e.insertBefore(this).translate(b.offsetx,b.offsety)};var ce={},cf=function(b,c,d,e,f,g,h,i,j){var k=0,l=100,m=[b,c,d,e,f,g,h,i].join(),n=ce[m],o,p;!n&&(ce[m]=n={data:[]}),n.timer&&clearTimeout(n.timer),n.timer=setTimeout(function(){delete ce[m]},2e3);if(j!=null&&!n.precision){var q=cf(b,c,d,e,f,g,h,i);n.precision=~~q*10,n.data=[]}l=n.precision||l;for(var r=0;r<l+1;r++){n.data[r*l]?p=n.data[r*l]:(p=a.findDotsAtSegment(b,c,d,e,f,g,h,i,r/l),n.data[r*l]=p),r&&(k+=A(A(o.x-p.x,2)+A(o.y-p.y,2),.5));if(j!=null&&k>=j)return p;o=p}if(j==null)return k},cg=function(b,c){return function(d,e,f){d=bG(d);var g,h,i,j,k="",l={},m,n=0;for(var o=0,p=d.length;o<p;o++){i=d[o];if(i[0]=="M")g=+i[1],h=+i[2];else{j=cf(g,h,i[1],i[2],i[3],i[4],i[5],i[6]);if(n+j>e){if(c&&!l.start){m=cf(g,h,i[1],i[2],i[3],i[4],i[5],i[6],e-n),k+=["C"+m.start.x,m.start.y,m.m.x,m.m.y,m.x,m.y];if(f)return k;l.start=k,k=["M"+m.x,m.y+"C"+m.n.x,m.n.y,m.end.x,m.end.y,i[5],i[6]].join(),n+=j,g=+i[5],h=+i[6];continue}if(!b&&!c){m=cf(g,h,i[1],i[2],i[3],i[4],i[5],i[6],e-n);return{x:m.x,y:m.y,alpha:m.alpha}}}n+=j,g=+i[5],h=+i[6]}k+=i.shift()+i}l.end=k,m=b?n:c?l:a.findDotsAtSegment(g,h,i[0],i[1],i[2],i[3],i[4],i[5],1),m.alpha&&(m={x:m.x,y:m.y,alpha:m.alpha});return m}},ch=cg(1),ci=cg(),cj=cg(0,1);a.getTotalLength=ch,a.getPointAtLength=ci,a.getSubpath=function(a,b,c){if(this.getTotalLength(a)-c<1e-6)return cj(a,b).end;var d=cj(a,c,1);return b?cj(d,b).end:d},b$.getTotalLength=function(){if(this.type=="path"){if(this.node.getTotalLength)return this.node.getTotalLength();return ch(this.attrs.path)}},b$.getPointAtLength=function(a){if(this.type=="path")return ci(this.attrs.path,a)},b$.getSubpath=function(b,c){if(this.type=="path")return a.getSubpath(this.attrs.path,b,c)};var ck=a.easing_formulas={linear:function(a){return a},"<":function(a){return A(a,1.7)},">":function(a){return A(a,.48)},"<>":function(a){var b=.48-a/1.04,c=w.sqrt(.1734+b*b),d=c-b,e=A(z(d),1/3)*(d<0?-1:1),f=-c-b,g=A(z(f),1/3)*(f<0?-1:1),h=e+g+.5;return(1-h)*3*h*h+h*h*h},backIn:function(a){var b=1.70158;return a*a*((b+1)*a-b)},backOut:function(a){a=a-1;var b=1.70158;return a*a*((b+1)*a+b)+1},elastic:function(a){if(a==!!a)return a;return A(2,-10*a)*w.sin((a-.075)*2*B/.3)+1},bounce:function(a){var b=7.5625,c=2.75,d;a<1/c?d=b*a*a:a<2/c?(a-=1.5/c,d=b*a*a+.75):a<2.5/c?(a-=2.25/c,d=b*a*a+.9375):(a-=2.625/c,d=b*a*a+.984375);return d}};ck.easeIn=ck["ease-in"]=ck["<"],ck.easeOut=ck["ease-out"]=ck[">"],ck.easeInOut=ck["ease-in-out"]=ck["<>"],ck["back-in"]=ck.backIn,ck["back-out"]=ck.backOut;var cl=[],cm=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(a){setTimeout(a,16)},cn=function(){var b=+(new Date),c=0;for(;c<cl.length;c++){var d=cl[c];if(d.el.removed||d.paused)continue;var e=b-d.start,f=d.ms,h=d.easing,i=d.from,j=d.diff,k=d.to,l=d.t,m=d.el,o={},p,r={},s;d.initstatus?(e=(d.initstatus*d.anim.top-d.prev)/(d.percent-d.prev)*f,d.status=d.initstatus,delete d.initstatus,d.stop&&cl.splice(c--,1)):d.status=(d.prev+(d.percent-d.prev)*(e/f))/d.anim.top;if(e<0)continue;if(e<f){var t=h(e/f);for(var u in i)if(i[g](u)){switch(U[u]){case C:p=+i[u]+t*f*j[u];break;case"colour":p="rgb("+[co(O(i[u].r+t*f*j[u].r)),co(O(i[u].g+t*f*j[u].g)),co(O(i[u].b+t*f*j[u].b))].join(",")+")";break;case"path":p=[];for(var v=0,w=i[u].length;v<w;v++){p[v]=[i[u][v][0]];for(var x=1,y=i[u][v].length;x<y;x++)p[v][x]=+i[u][v][x]+t*f*j[u][v][x];p[v]=p[v].join(q)}p=p.join(q);break;case"transform":if(j[u].real){p=[];for(v=0,w=i[u].length;v<w;v++){p[v]=[i[u][v][0]];for(x=1,y=i[u][v].length;x<y;x++)p[v][x]=i[u][v][x]+t*f*j[u][v][x]}}else{var z=function(a){return+i[u][a]+t*f*j[u][a]};p=[["m",z(0),z(1),z(2),z(3),z(4),z(5)]]}break;case"csv":if(u=="clip-rect"){p=[],v=4;while(v--)p[v]=+i[u][v]+t*f*j[u][v]}break;default:var A=[][n](i[u]);p=[],v=m.paper.customAttributes[u].length;while(v--)p[v]=+A[v]+t*f*j[u][v]}o[u]=p}m.attr(o),function(a,b,c){setTimeout(function(){eve("anim.frame."+a,b,c)})}(m.id,m,d.anim)}else{(function(b,c,d){setTimeout(function(){eve("anim.frame."+c.id,c,d),eve("anim.finish."+c.id,c,d),a.is(b,"function")&&b.call(c)})})(d.callback,m,d.anim),m.attr(k),cl.splice(c--,1);if(d.repeat>1&&!d.next){for(s in k)k[g](s)&&(r[s]=d.totalOrigin[s]);d.el.attr(r),cr(d.anim,d.el,d.anim.percents[0],null,d.totalOrigin,d.repeat-1)}d.next&&!d.stop&&cr(d.anim,d.el,d.next,null,d.totalOrigin,d.repeat)}}a.svg&&m&&m.paper&&m.paper.safari(),cl.length&&cm(cn)},co=function(a){return a>255?255:a<0?0:a};b$.animateWith=function(b,c,d,e,f,g){var h=d?a.animation(d,e,f,g):c,i=b.status(c);return this.animate(h).status(h,i*c.ms/h.ms)},b$.onAnimation=function(a){a?eve.on("anim.frame."+this.id,a):eve.unbind("anim.frame."+this.id);return this},cq.prototype.delay=function(a){var b=new cq(this.anim,this.ms);b.times=this.times,b.del=+a||0;return b},cq.prototype.repeat=function(a){var b=new cq(this.anim,this.ms);b.del=this.del,b.times=w.floor(x(a,0))||1;return b},a.animation=function(b,c,d,e){if(b instanceof cq)return b;if(a.is(d,"function")||!d)e=e||d||null,d=null;b=Object(b),c=+c||0;var f={},h,i;for(i in b)b[g](i)&&Q(i)!=i&&Q(i)+"%"!=i&&(h=!0,f[i]=b[i]);if(!h)return new cq(b,c);d&&(f.easing=d),e&&(f.callback=e);return new cq({100:f},c)},b$.animate=function(b,c,d,e){var f=this;if(f.removed){e&&e.call(f);return f}var g=b instanceof cq?b:a.animation(b,c,d,e);cr(g,f,g.percents[0],null,f.attr());return f},b$.setTime=function(a,b){a&&b!=null&&this.status(a,y(b,a.ms)/a.ms);return this},b$.status=function(a,b){var c=[],d=0,e,f;if(b!=null){cr(a,this,-1,y(b,1));return this}e=cl.length;for(;d<e;d++){f=cl[d];if(f.el.id==this.id&&(!a||f.anim==a)){if(a)return f.status;c.push({anim:f.anim,status:f.status})}}if(a)return 0;return c},b$.pause=function(a){for(var b=0;b<cl.length;b++)cl[b].el.id==this.id&&(!a||cl[b].anim==a)&&eve("anim.pause."+this.id,this,cl[b].anim)!==!1&&(cl[b].paused=!0);return this},b$.resume=function(a){for(var b=0;b<cl.length;b++)if(cl[b].el.id==this.id&&(!a||cl[b].anim==a)){var c=cl[b];eve("anim.resume."+this.id,this,c.anim)!==!1&&(delete c.paused,this.status(c.anim,c.status))}return this},b$.stop=function(a){for(var b=0;b<cl.length;b++)cl[b].el.id==this.id&&(!a||cl[b].anim==a)&&eve("anim.stop."+this.id,this,cl[b].anim)!==!1&&cl.splice(b--,1);return this},b$.toString=function(){return"Raphaël’s object"};var cs=function(a){this.items=[],this.length=0,this.type="set";if(a)for(var b=0,c=a.length;b<c;b++)a[b]&&(a[b].constructor==b$.constructor||a[b].constructor==cs)&&(this[this.items.length]=this.items[this.items.length]=a[b],this.length++)},ct=cs.prototype;ct.push=function(){var a,b;for(var c=0,d=arguments.length;c<d;c++)a=arguments[c],a&&(a.constructor==b$.constructor||a.constructor==cs)&&(b=this.items.length,this[b]=this.items[b]=a,this.length++);return this},ct.pop=function(){this.length&&delete this[this.length--];return this.items.pop()},ct.forEach=function(a,b){for(var c=0,d=this.items.length;c<d;c++)if(a.call(b,this.items[c],c)===!1)return this;return this};for(var cu in b$)b$[g](cu)&&(ct[cu]=function(a){return function(){var b=arguments;return this.forEach(function(c){c[a][m](c,b)})}}(cu));ct.attr=function(b,c){if(b&&a.is(b,E)&&a.is(b[0],"object"))for(var d=0,e=b.length;d<e;d++)this.items[d].attr(b[d]);else for(var f=0,g=this.items.length;f<g;f++)this.items[f].attr(b,c);return this},ct.clear=function(){while(this.length)this.pop()},ct.splice=function(a,b,c){a=a<0?x(this.length+a,0):a,b=x(0,y(this.length-a,b));var d=[],e=[],f=[],g;for(g=2;g<arguments.length;g++)f.push(arguments[g]);for(g=0;g<b;g++)e.push(this[a+g]);for(;g<this.length-a;g++)d.push(this[a+g]);var h=f.length;for(g=0;g<h+d.length;g++)this.items[a+g]=this[a+g]=g<h?f[g]:d[g-h];g=this.items.length=this.length-=b-h;while(this[g])delete this[g++];return new cs(e)},ct.exclude=function(a){for(var b=0,c=this.length;b<c;b++)if(this[b]==a){this.splice(b,1);return!0}},ct.animate=function(b,c,d,e){(a.is(d,"function")||!d)&&(e=d||null);var f=this.items.length,g=f,h,i=this,j;if(!f)return this;e&&(j=function(){!--f&&e.call(i)}),d=a.is(d,D)?d:j;var k=a.animation(b,c,d,j);h=this.items[--g].animate(k);while(g--)this.items[g]&&!this.items[g].removed&&this.items[g].animateWith(h,k);return this},ct.insertAfter=function(a){var b=this.items.length;while(b--)this.items[b].insertAfter(a);return this},ct.getBBox=function(){var a=[],b=[],c=[],d=[];for(var e=this.items.length;e--;)if(!this.items[e].removed){var f=this.items[e].getBBox();a.push(f.x),b.push(f.y),c.push(f.x+f.width),d.push(f.y+f.height)}a=y[m](0,a),b=y[m](0,b);return{x:a,y:b,width:x[m](0,c)-a,height:x[m](0,d)-b}},ct.clone=function(a){a=new cs;for(var b=0,c=this.items.length;b<c;b++)a.push(this.items[b].clone());return a},ct.toString=function(){return"Raphaël‘s set"},a.registerFont=function(a){if(!a.face)return a;this.fonts=this.fonts||{};var b={w:a.w,face:{},glyphs:{}},c=a.face["font-family"];for(var d in a.face)a.face[g](d)&&(b.face[d]=a.face[d]);this.fonts[c]?this.fonts[c].push(b):this.fonts[c]=[b];if(!a.svg){b.face["units-per-em"]=R(a.face["units-per-em"],10);for(var e in a.glyphs)if(a.glyphs[g](e)){var f=a.glyphs[e];b.glyphs[e]={w:f.w,k:{},d:f.d&&"M"+f.d.replace(/[mlcxtrv]/g,function(a){return{l:"L",c:"C",x:"z",t:"m",r:"l",v:"c"}[a]||"M"})+"z"};if(f.k)for(var h in f.k)f[g](h)&&(b.glyphs[e].k[h]=f.k[h])}}return a},k.getFont=function(b,c,d,e){e=e||"normal",d=d||"normal",c=+c||{normal:400,bold:700,lighter:300,bolder:800}[c]||400;if(!!a.fonts){var f=a.fonts[b];if(!f){var h=new RegExp("(^|\\s)"+b.replace(/[^\w\d\s+!~.:_-]/g,p)+"(\\s|$)","i");for(var i in a.fonts)if(a.fonts[g](i)&&h.test(i)){f=a.fonts[i];break}}var j;if(f)for(var k=0,l=f.length;k<l;k++){j=f[k];if(j.face["font-weight"]==c&&(j.face["font-style"]==d||!j.face["font-style"])&&j.face["font-stretch"]==e)break}return j}},k.print=function(b,d,e,f,g,h,i){h=h||"middle",i=x(y(i||0,1),-1);var j=this.set(),k=r(e)[s](p),l=0,m=p,n;a.is(f,e)&&(f=this.getFont(f));if(f){n=(g||16)/f.face["units-per-em"];var o=f.face.bbox[s](c),q=+o[0],t=+o[1]+(h=="baseline"?o[3]-o[1]+ +f.face.descent:(o[3]-o[1])/2);for(var u=0,v=k.length;u<v;u++){var w=u&&f.glyphs[k[u-1]]||{},z=f.glyphs[k[u]];l+=u?(w.w||f.w)+(w.k&&w.k[k[u]]||0)+f.w*i:0,z&&z.d&&j.push(this.path(z.d).attr({fill:"#000",stroke:"none",transform:[["t",l*n,0]]}))}j.transform(["...s",n,n,q,t,"t",(b-q)/n,(d-t)/n])}return j},k.add=function(b){if(a.is(b,"array")){var c=this.set(),e=0,f=b.length,h;for(;e<f;e++)h=b[e]||{},d[g](h.type)&&c.push(this[h.type]().attr(h))}return c},a.format=function(b,c){var d=a.is(c,E)?[0][n](c):arguments;b&&a.is(b,D)&&d.length-1&&(b=b.replace(e,function(a,b){return d[++b]==null?p:d[b]}));return b||p},a.fullfill=function(){var a=/\{([^\}]+)\}/g,b=/(?:(?:^|\.)(.+?)(?=\[|\.|$|\()|\[('|")(.+?)\2\])(\(\))?/g,c=function(a,c,d){var e=d;c.replace(b,function(a,b,c,d,f){b=b||d,e&&(b in e&&(e=e[b]),typeof e=="function"&&f&&(e=e()))}),e=(e==null||e==d?a:e)+"";return e};return function(b,d){return String(b).replace(a,function(a,b){return c(a,b,d)})}}(),a.ninja=function(){i.was?h.win.Raphael=i.is:delete Raphael;return a},a.st=ct,function(b,c,d){function e(){/in/.test(b.readyState)?setTimeout(e,9):a.eve("DOMload")}b.readyState==null&&b.addEventListener&&(b.addEventListener(c,d=function(){b.removeEventListener(c,d,!1),b.readyState="complete"},!1),b.readyState="loading"),e()}(document,"DOMContentLoaded"),i.was?h.win.Raphael=a:Raphael=a,eve.on("DOMload",function(){b=!0})}(),window.Raphael.svg&&function(a){var b="hasOwnProperty",c=String,d=parseFloat,e=parseInt,f=Math,g=f.max,h=f.abs,i=f.pow,j=/[, ]+/,k=a.eve,l="",m=" ",n="http://www.w3.org/1999/xlink",o={block:"M5,0 0,2.5 5,5z",classic:"M5,0 0,2.5 5,5 3.5,3 3.5,2z",diamond:"M2.5,0 5,2.5 2.5,5 0,2.5z",open:"M6,1 1,3.5 6,6",oval:"M2.5,0A2.5,2.5,0,0,1,2.5,5 2.5,2.5,0,0,1,2.5,0z"},p={};a.toString=function(){return"Your browser supports SVG.\nYou are running Raphaël "+this.version};var q=function(d,e){if(e){typeof d=="string"&&(d=q(d));for(var f in e)e[b](f)&&(f.substring(0,6)=="xlink:"?d.setAttributeNS(n,f.substring(6),c(e[f])):d.setAttribute(f,c(e[f])))}else d=a._g.doc.createElementNS("http://www.w3.org/2000/svg",d),d.style&&(d.style.webkitTapHighlightColor="rgba(0,0,0,0)");return d},r=function(b,e){var j="linear",k=b.id+e,m=.5,n=.5,o=b.node,p=b.paper,r=o.style,s=a._g.doc.getElementById(k);if(!s){e=c(e).replace(a._radial_gradient,function(a,b,c){j="radial";if(b&&c){m=d(b),n=d(c);var e=(n>.5)*2-1;i(m-.5,2)+i(n-.5,2)>.25&&(n=f.sqrt(.25-i(m-.5,2))*e+.5)&&n!=.5&&(n=n.toFixed(5)-1e-5*e)}return l}),e=e.split(/\s*\-\s*/);if(j=="linear"){var t=e.shift();t=-d(t);if(isNaN(t))return null;var u=[0,0,f.cos(a.rad(t)),f.sin(a.rad(t))],v=1/(g(h(u[2]),h(u[3]))||1);u[2]*=v,u[3]*=v,u[2]<0&&(u[0]=-u[2],u[2]=0),u[3]<0&&(u[1]=-u[3],u[3]=0)}var w=a._parseDots(e);if(!w)return null;k=k.replace(/[\(\)\s,\xb0#]/g,"_"),b.gradient&&k!=b.gradient.id&&(p.defs.removeChild(b.gradient),delete b.gradient);if(!b.gradient){s=q(j+"Gradient",{id:k}),b.gradient=s,q(s,j=="radial"?{fx:m,fy:n}:{x1:u[0],y1:u[1],x2:u[2],y2:u[3],gradientTransform:b.matrix.invert()}),p.defs.appendChild(s);for(var x=0,y=w.length;x<y;x++)s.appendChild(q("stop",{offset:w[x].offset?w[x].offset:x?"100%":"0%","stop-color":w[x].color||"#fff"}))}}q(o,{fill:"url(#"+k+")",opacity:1,"fill-opacity":1}),r.fill=l,r.opacity=1,r.fillOpacity=1;return 1},s=function(a){var b=a.getBBox(1);q(a.pattern,{patternTransform:a.matrix.invert()+" translate("+b.x+","+b.y+")"})},t=function(d,e,f){if(d.type=="path"){var g=c(e).toLowerCase().split("-"),h=d.paper,i=f?"end":"start",j=d.node,k=d.attrs,l=k["stroke-width"],n=g.length,r="classic",s,t,u,v,w,x=3,y=3,z=5;while(n--)switch(g[n]){case"block":case"classic":case"oval":case"diamond":case"open":case"none":r=g[n];break;case"wide":y=5;break;case"narrow":y=2;break;case"long":x=5;break;case"short":x=2}r=="open"?(x+=2,y+=2,z+=2,u=1,v=f?4:1,w={fill:"none",stroke:k.stroke}):(v=u=x/2,w={fill:k.stroke,stroke:"none"}),d._.arrows?f?(d._.arrows.endPath&&p[d._.arrows.endPath]--,d._.arrows.endMarker&&p[d._.arrows.endMarker]--):(d._.arrows.startPath&&p[d._.arrows.startPath]--,d._.arrows.startMarker&&p[d._.arrows.startMarker]--):d._.arrows={};if(r!="none"){var A="raphael-marker-"+r,B="raphael-marker-"+i+r+x+y;a._g.doc.getElementById(A)?p[A]++:(h.defs.appendChild(q(q("path"),{"stroke-linecap":"round",d:o[r],id:A})),p[A]=1);var C=a._g.doc.getElementById(B),D;C?(p[B]++,D=C.getElementsByTagName("use")[0]):(C=q(q("marker"),{id:B,markerHeight:y,markerWidth:x,orient:"auto",refX:v,refY:y/2}),D=q(q("use"),{"xlink:href":"#"+A,transform:(f?" rotate(180 "+x/2+" "+y/2+") ":m)+"scale("+x/z+","+y/z+")","stroke-width":1/((x/z+y/z)/2)}),C.appendChild(D),h.defs.appendChild(C),p[B]=1),q(D,w);var E=u*(r!="diamond"&&r!="oval");f?(s=d._.arrows.startdx*l||0,t=a.getTotalLength(k.path)-E*l):(s=E*l,t=a.getTotalLength(k.path)-(d._.arrows.enddx*l||0)),w={},w["marker-"+i]="url(#"+B+")";if(t||s)w.d=Raphael.getSubpath(k.path,s,t);q(j,w),d._.arrows[i+"Path"]=A,d._.arrows[i+"Marker"]=B,d._.arrows[i+"dx"]=E,d._.arrows[i+"Type"]=r,d._.arrows[i+"String"]=e}else f?(s=d._.arrows.startdx*l||0,t=a.getTotalLength(k.path)-s):(s=0,t=a.getTotalLength(k.path)-(d._.arrows.enddx*l||0)),d._.arrows[i+"Path"]&&q(j,{d:Raphael.getSubpath(k.path,s,t)}),delete d._.arrows[i+"Path"],delete d._.arrows[i+"Marker"],delete d._.arrows[i+"dx"],delete d._.arrows[i+"Type"],delete d._.arrows[i+"String"];for(w in p)if(p[b](w)&&!p[w]){var F=a._g.doc.getElementById(w);F&&F.parentNode.removeChild(F)}}},u={"":[0],none:[0],"-":[3,1],".":[1,1],"-.":[3,1,1,1],"-..":[3,1,1,1,1,1],". ":[1,3],"- ":[4,3],"--":[8,3],"- .":[4,3,1,3],"--.":[8,3,1,3],"--..":[8,3,1,3,1,3]},v=function(a,b,d){b=u[c(b).toLowerCase()];if(b){var e=a.attrs["stroke-width"]||"1",f={round:e,square:e,butt:0}[a.attrs["stroke-linecap"]||d["stroke-linecap"]]||0,g=[],h=b.length;while(h--)g[h]=b[h]*e+(h%2?1:-1)*f;q(a.node,{"stroke-dasharray":g.join(",")})}},w=function(d,f){var i=d.node,k=d.attrs,m=i.style.visibility;i.style.visibility="hidden";for(var o in f)if(f[b](o)){if(!a._availableAttrs[b](o))continue;var p=f[o];k[o]=p;switch(o){case"blur":d.blur(p);break;case"href":case"title":case"target":var u=i.parentNode;if(u.tagName.toLowerCase()!="a"){var w=q("a");u.insertBefore(w,i),w.appendChild(i),u=w}o=="target"&&p=="blank"?u.setAttributeNS(n,"show","new"):u.setAttributeNS(n,o,p);break;case"cursor":i.style.cursor=p;break;case"transform":d.transform(p);break;case"arrow-start":t(d,p);break;case"arrow-end":t(d,p,1);break;case"clip-rect":var x=c(p).split(j);if(x.length==4){d.clip&&d.clip.parentNode.parentNode.removeChild(d.clip.parentNode);var z=q("clipPath"),A=q("rect");z.id=a.createUUID(),q(A,{x:x[0],y:x[1],width:x[2],height:x[3]}),z.appendChild(A),d.paper.defs.appendChild(z),q(i,{"clip-path":"url(#"+z.id+")"}),d.clip=A}if(!p){var B=i.getAttribute("clip-path");if(B){var C=a._g.doc.getElementById(B.replace(/(^url\(#|\)$)/g,l));C&&C.parentNode.removeChild(C),q(i,{"clip-path":l}),delete d.clip}}break;case"path":d.type=="path"&&(q(i,{d:p?k.path=a._pathToAbsolute(p):"M0,0"}),d._.dirty=1,d._.arrows&&("startString"in d._.arrows&&t(d,d._.arrows.startString),"endString"in d._.arrows&&t(d,d._.arrows.endString,1)));break;case"width":i.setAttribute(o,p),d._.dirty=1;if(k.fx)o="x",p=k.x;else break;case"x":k.fx&&(p=-k.x-(k.width||0));case"rx":if(o=="rx"&&d.type=="rect")break;case"cx":i.setAttribute(o,p),d.pattern&&s(d),d._.dirty=1;break;case"height":i.setAttribute(o,p),d._.dirty=1;if(k.fy)o="y",p=k.y;else break;case"y":k.fy&&(p=-k.y-(k.height||0));case"ry":if(o=="ry"&&d.type=="rect")break;case"cy":i.setAttribute(o,p),d.pattern&&s(d),d._.dirty=1;break;case"r":d.type=="rect"?q(i,{rx:p,ry:p}):i.setAttribute(o,p),d._.dirty=1;break;case"src":d.type=="image"&&i.setAttributeNS(n,"href",p);break;case"stroke-width":if(d._.sx!=1||d._.sy!=1)p/=g(h(d._.sx),h(d._.sy))||1;d.paper._vbSize&&(p*=d.paper._vbSize),i.setAttribute(o,p),k["stroke-dasharray"]&&v(d,k["stroke-dasharray"],f),d._.arrows&&("startString"in d._.arrows&&t(d,d._.arrows.startString),"endString"in d._.arrows&&t(d,d._.arrows.endString,1));break;case"stroke-dasharray":v(d,p,f);break;case"fill":var D=c(p).match(a._ISURL);if(D){z=q("pattern");var F=q("image");z.id=a.createUUID(),q(z,{x:0,y:0,patternUnits:"userSpaceOnUse",height:1,width:1}),q(F,{x:0,y:0,"xlink:href":D[1]}),z.appendChild(F),function(b){a._preload(D[1],function(){var a=this.offsetWidth,c=this.offsetHeight;q(b,{width:a,height:c}),q(F,{width:a,height:c}),d.paper.safari()})}(z),d.paper.defs.appendChild(z),i.style.fill="url(#"+z.id+")",q(i,{fill:"url(#"+z.id+")"}),d.pattern=z,d.pattern&&s(d);break}var G=a.getRGB(p);if(!G.error)delete f.gradient,delete k.gradient,!a.is(k.opacity,"undefined")&&a.is(f.opacity,"undefined")&&q(i,{opacity:k.opacity}),!a.is(k["fill-opacity"],"undefined")&&a.is(f["fill-opacity"],"undefined")&&q(i,{"fill-opacity":k["fill-opacity"]});else if((d.type=="circle"||d.type=="ellipse"||c(p).charAt()!="r")&&r(d,p)){if("opacity"in k||"fill-opacity"in k){var H=a._g.doc.getElementById(i.getAttribute("fill").replace(/^url\(#|\)$/g,l));if(H){var I=H.getElementsByTagName("stop");q(I[I.length-1],{"stop-opacity":("opacity"in k?k.opacity:1)*("fill-opacity"in k?k["fill-opacity"]:1)})}}k.gradient=p,k.fill="none";break}G[b]("opacity")&&q(i,{"fill-opacity":G.opacity>1?G.opacity/100:G.opacity});case"stroke":G=a.getRGB(p),i.setAttribute(o,G.hex),o=="stroke"&&G[b]("opacity")&&q(i,{"stroke-opacity":G.opacity>1?G.opacity/100:G.opacity}),o=="stroke"&&d._.arrows&&("startString"in d._.arrows&&t(d,d._.arrows.startString),"endString"in d._.arrows&&t(d,d._.arrows.endString,1));break;case"gradient":(d.type=="circle"||d.type=="ellipse"||c(p).charAt()!="r")&&r(d,p);break;case"opacity":k.gradient&&!k[b]("stroke-opacity")&&q(i,{"stroke-opacity":p>1?p/100:p});case"fill-opacity":if(k.gradient){H=a._g.doc.getElementById(i.getAttribute("fill").replace(/^url\(#|\)$/g,l)),H&&(I=H.getElementsByTagName("stop"),q(I[I.length-1],{"stop-opacity":p}));break};default:o=="font-size"&&(p=e(p,10)+"px");var J=o.replace(/(\-.)/g,function(a){return a.substring(1).toUpperCase()});i.style[J]=p,d._.dirty=1,i.setAttribute(o,p)}}y(d,f),i.style.visibility=m},x=1.2,y=function(d,f){if(d.type=="text"&&!!(f[b]("text")||f[b]("font")||f[b]("font-size")||f[b]("x")||f[b]("y"))){var g=d.attrs,h=d.node,i=h.firstChild?e(a._g.doc.defaultView.getComputedStyle(h.firstChild,l).getPropertyValue("font-size"),10):10;if(f[b]("text")){g.text=f.text;while(h.firstChild)h.removeChild(h.firstChild);var j=c(f.text).split("\n"),k=[],m;for(var n=0,o=j.length;n<o;n++)m=q("tspan"),n&&q(m,{dy:i*x,x:g.x}),m.appendChild(a._g.doc.createTextNode(j[n])),h.appendChild(m),k[n]=m}else{k=h.getElementsByTagName("tspan");for(n=0,o=k.length;n<o;n++)n?q(k[n],{dy:i*x,x:g.x}):q(k[0],{dy:0})}q(h,{x:g.x,y:g.y}),d._.dirty=1;var p=d._getBBox(),r=g.y-(p.y+p.height/2);r&&a.is(r,"finite")&&q(k[0],{dy:r})}},z=function(b,c){var d=0,e=0;this[0]=this.node=b,b.raphael=!0,this.id=a._oid++,b.raphaelid=this.id,this.matrix=a.matrix(),this.realPath=null,this.paper=c,this.attrs=this.attrs||{},this._={transform:[],sx:1,sy:1,deg:0,dx:0,dy:0,dirty:1},!c.bottom&&(c.bottom=this),this.prev=c.top,c.top&&(c.top.next=this),c.top=this,this.next=null},A=a.el;z.prototype=A,A.constructor=z,a._engine.path=function(a,b){var c=q("path");b.canvas&&b.canvas.appendChild(c);var d=new z(c,b);d.type="path",w(d,{fill:"none",stroke:"#000",path:a});return d},A.rotate=function(a,b,e){if(this.removed)return this;a=c(a).split(j),a.length-1&&(b=d(a[1]),e=d(a[2])),a=d(a[0]),e==null&&(b=e);if(b==null||e==null){var f=this.getBBox(1);b=f.x+f.width/2,e=f.y+f.height/2}this.transform(this._.transform.concat([["r",a,b,e]]));return this},A.scale=function(a,b,e,f){if(this.removed)return this;a=c(a).split(j),a.length-1&&(b=d(a[1]),e=d(a[2]),f=d(a[3])),a=d(a[0]),b==null&&(b=a),f==null&&(e=f);if(e==null||f==null)var g=this.getBBox(1);e=e==null?g.x+g.width/2:e,f=f==null?g.y+g.height/2:f,this.transform(this._.transform.concat([["s",a,b,e,f]]));return this},A.translate=function(a,b){if(this.removed)return this;a=c(a).split(j),a.length-1&&(b=d(a[1])),a=d(a[0])||0,b=+b||0,this.transform(this._.transform.concat([["t",a,b]]));return this},A.transform=function(c){var d=this._;if(c==null)return d.transform;a._extractTransform(this,c),this.clip&&q(this.clip,{transform:this.matrix.invert()}),this.pattern&&s(this),this.node&&q(this.node,{transform:this.matrix});if(d.sx!=1||d.sy!=1){var e=this.attrs[b]("stroke-width")?this.attrs["stroke-width"]:1;this.attr({"stroke-width":e})}return this},A.hide=function(){!this.removed&&this.paper.safari(this.node.style.display="none");return this},A.show=function(){!this.removed&&this.paper.safari(this.node.style.display="");return this},A.remove=function(){if(!this.removed){var b=this.paper;b.__set__&&b.__set__.exclude(this),k.unbind("*.*."+this.id),this.gradient&&b.defs.removeChild(this.gradient),a._tear(this,b),this.node.parentNode.removeChild(this.node);for(var c in this)this[c]=typeof this[c]=="function"?a._removedFactory(c):null;this.removed=!0}},A._getBBox=function(){if(this.node.style.display=="none"){this.show();var a=!0}var b={};try{b=this.node.getBBox()}catch(c){}finally{b=b||{}}a&&this.hide();return b},A.attr=function(c,d){if(this.removed)return this;if(c==null){var e={};for(var f in this.attrs)this.attrs[b](f)&&(e[f]=this.attrs[f]);e.gradient&&e.fill=="none"&&(e.fill=e.gradient)&&delete e.gradient,e.transform=this._.transform;return e}if(d==null&&a.is(c,"string")){if(c=="fill"&&this.attrs.fill=="none"&&this.attrs.gradient)return this.attrs.gradient;if(c=="transform")return this._.transform;var g=c.split(j),h={};for(var i=0,l=g.length;i<l;i++)c=g[i],c in this.attrs?h[c]=this.attrs[c]:a.is(this.paper.customAttributes[c],"function")?h[c]=this.paper.customAttributes[c].def:h[c]=a._availableAttrs[c];return l-1?h:h[g[0]]}if(d==null&&a.is(c,"array")){h={};for(i=0,l=c.length;i<l;i++)h[c[i]]=this.attr(c[i]);return h}if(d!=null){var m={};m[c]=d}else c!=null&&a.is(c,"object")&&(m=c);for(var n in m)k("attr."+n+"."+this.id,this,m[n]);for(n in this.paper.customAttributes)if(this.paper.customAttributes[b](n)&&m[b](n)&&a.is(this.paper.customAttributes[n],"function")){var o=this.paper.customAttributes[n].apply(this,[].concat(m[n]));this.attrs[n]=m[n];for(var p in o)o[b](p)&&(m[p]=o[p])}w(this,m);return this},A.toFront=function(){if(this.removed)return this;this.node.parentNode.tagName.toLowerCase()=="a"?this.node.parentNode.parentNode.appendChild(this.node.parentNode):this.node.parentNode.appendChild(this.node);var b=this.paper;b.top!=this&&a._tofront(this,b);return this},A.toBack=function(){if(this.removed)return this;var b=this.node.parentNode;b.tagName.toLowerCase()=="a"?b.parentNode.insertBefore(this.node.parentNode,this.node.parentNode.parentNode.firstChild):b.firstChild!=this.node&&b.insertBefore(this.node,this.node.parentNode.firstChild),a._toback(this,this.paper);var c=this.paper;return this},A.insertAfter=function(b){if(this.removed)return this;var c=b.node||b[b.length-1].node;c.nextSibling?c.parentNode.insertBefore(this.node,c.nextSibling):c.parentNode.appendChild(this.node),a._insertafter(this,b,this.paper);return this},A.insertBefore=function(b){if(this.removed)return this;var c=b.node||b[0].node;c.parentNode.insertBefore(this.node,c),a._insertbefore(this,b,this.paper);return this},A.blur=function(b){var c=this;if(+b!==0){var d=q("filter"),e=q("feGaussianBlur");c.attrs.blur=b,d.id=a.createUUID(),q(e,{stdDeviation:+b||1.5}),d.appendChild(e),c.paper.defs.appendChild(d),c._blur=d,q(c.node,{filter:"url(#"+d.id+")"})}else c._blur&&(c._blur.parentNode.removeChild(c._blur),delete c._blur,delete c.attrs.blur),c.node.removeAttribute("filter")},a._engine.circle=function(a,b,c,d){var e=q("circle");a.canvas&&a.canvas.appendChild(e);var f=new z(e,a);f.attrs={cx:b,cy:c,r:d,fill:"none",stroke:"#000"},f.type="circle",q(e,f.attrs);return f},a._engine.rect=function(a,b,c,d,e,f){var g=q("rect");a.canvas&&a.canvas.appendChild(g);var h=new z(g,a);h.attrs={x:b,y:c,width:d,height:e,r:f||0,rx:f||0,ry:f||0,fill:"none",stroke:"#000"},h.type="rect",q(g,h.attrs);return h},a._engine.ellipse=function(a,b,c,d,e){var f=q("ellipse");a.canvas&&a.canvas.appendChild(f);var g=new z(f,a);g.attrs={cx:b,cy:c,rx:d,ry:e,fill:"none",stroke:"#000"},g.type="ellipse",q(f,g.attrs);return g},a._engine.image=function(a,b,c,d,e,f){var g=q("image");q(g,{x:c,y:d,width:e,height:f,preserveAspectRatio:"none"}),g.setAttributeNS(n,"href",b),a.canvas&&a.canvas.appendChild(g);var h=new z(g,a);h.attrs={x:c,y:d,width:e,height:f,src:b},h.type="image";return h},a._engine.text=function(b,c,d,e){var f=q("text");b.canvas&&b.canvas.appendChild(f);var g=new z(f,b);g.attrs={x:c,y:d,"text-anchor":"middle",text:e,font:a._availableAttrs.font,stroke:"none",fill:"#000"},g.type="text",w(g,g.attrs);return g},a._engine.setSize=function(a,b){this.width=a||this.width,this.height=b||this.height,this.canvas.setAttribute("width",this.width),this.canvas.setAttribute("height",this.height),this._viewBox&&this.setViewBox.apply(this,this._viewBox);return this},a._engine.create=function(){var b=a._getContainer.apply(0,arguments),c=b&&b.container,d=b.x,e=b.y,f=b.width,g=b.height;if(!c)throw new Error("SVG container not found.");var h=q("svg"),i="overflow:hidden;",j;d=d||0,e=e||0,f=f||512,g=g||342,q(h,{height:g,version:1.1,width:f,xmlns:"http://www.w3.org/2000/svg"}),c==1?(h.style.cssText=i+"position:absolute;left:"+d+"px;top:"+e+"px",a._g.doc.body.appendChild(h),j=1):(h.style.cssText=i+"position:relative",c.firstChild?c.insertBefore(h,c.firstChild):c.appendChild(h)),c=new a._Paper,c.width=f,c.height=g,c.canvas=h,c.clear(),c._left=c._top=0,j&&(c.renderfix=function(){}),c.renderfix();return c},a._engine.setViewBox=function(a,b,c,d,e){k("setViewBox",this,this._viewBox,[a,b,c,d,e]);var f=g(c/this.width,d/this.height),h=this.top,i=e?"meet":"xMinYMin",j,l;a==null?(this._vbSize&&(f=1),delete this._vbSize,j="0 0 "+this.width+m+this.height):(this._vbSize=f,j=a+m+b+m+c+m+d),q(this.canvas,{viewBox:j,preserveAspectRatio:i});while(f&&h)l="stroke-width"in h.attrs?h.attrs["stroke-width"]:1,h.attr({"stroke-width":l}),h._.dirty=1,h._.dirtyT=1,h=h.prev;this._viewBox=[a,b,c,d,!!e];return this},a.prototype.renderfix=function(){var a=this.canvas,b=a.style,c=a.getScreenCTM()||a.createSVGMatrix(),d=-c.e%1,e=-c.f%1;if(d||e)d&&(this._left=(this._left+d)%1,b.left=this._left+"px"),e&&(this._top=(this._top+e)%1,b.top=this._top+"px")},a.prototype.clear=function(){a.eve("clear",this);var b=this.canvas;while(b.firstChild)b.removeChild(b.firstChild);this.bottom=this.top=null,(this.desc=q("desc")).appendChild(a._g.doc.createTextNode("Created with Raphaël "+a.version)),b.appendChild(this.desc),b.appendChild(this.defs=q("defs"))},a.prototype.remove=function(){k("remove",this),this.canvas.parentNode&&this.canvas.parentNode.removeChild(this.canvas);for(var b in this)this[b]=typeof this[b]=="function"?a._removedFactory(b):null};var B=a.st;for(var C in A)A[b](C)&&!B[b](C)&&(B[C]=function(a){return function(){var b=arguments;return this.forEach(function(c){c[a].apply(c,b)})}}(C))}(window.Raphael),window.Raphael.vml&&function(a){var b="hasOwnProperty",c=String,d=parseFloat,e=Math,f=e.round,g=e.max,h=e.min,i=e.abs,j="fill",k=/[, ]+/,l=a.eve,m=" progid:DXImageTransform.Microsoft",n=" ",o="",p={M:"m",L:"l",C:"c",Z:"x",m:"t",l:"r",c:"v",z:"x"},q=/([clmz]),?([^clmz]*)/gi,r=/ progid:\S+Blur\([^\)]+\)/g,s=/-?[^,\s-]+/g,t="position:absolute;left:0;top:0;width:1px;height:1px",u=21600,v={path:1,rect:1,image:1},w={circle:1,ellipse:1},x=function(b){var d=/[ahqstv]/ig,e=a._pathToAbsolute;c(b).match(d)&&(e=a._path2curve),d=/[clmz]/g;if(e==a._pathToAbsolute&&!c(b).match(d)){var g=c(b).replace(q,function(a,b,c){var d=[],e=b.toLowerCase()=="m",g=p[b];c.replace(s,function(a){e&&d.length==2&&(g+=d+p[b=="m"?"l":"L"],d=[]),d.push(f(a*u))});return g+d});return g}var h=e(b),i,j;g=[];for(var k=0,l=h.length;k<l;k++){i=h[k],j=h[k][0].toLowerCase(),j=="z"&&(j="x");for(var m=1,r=i.length;m<r;m++)j+=f(i[m]*u)+(m!=r-1?",":o);g.push(j)}return g.join(n)},y=function(b,c,d){var e=a.matrix();e.rotate(-b,.5,.5);return{dx:e.x(c,d),dy:e.y(c,d)}},z=function(a,b,c,d,e,f){var g=a._,h=a.matrix,k=g.fillpos,l=a.node,m=l.style,o=1,p="",q,r=u/b,s=u/c;m.visibility="hidden";if(!!b&&!!c){l.coordsize=i(r)+n+i(s),m.rotation=f*(b*c<0?-1:1);if(f){var t=y(f,d,e);d=t.dx,e=t.dy}b<0&&(p+="x"),c<0&&(p+=" y")&&(o=-1),m.flip=p,l.coordorigin=d*-r+n+e*-s;if(k||g.fillsize){var v=l.getElementsByTagName(j);v=v&&v[0],l.removeChild(v),k&&(t=y(f,h.x(k[0],k[1]),h.y(k[0],k[1])),v.position=t.dx*o+n+t.dy*o),g.fillsize&&(v.size=g.fillsize[0]*i(b)+n+g.fillsize[1]*i(c)),l.appendChild(v)}m.visibility="visible"}};a.toString=function(){return"Your browser doesn’t support SVG. Falling down to VML.\nYou are running Raphaël "+this.version};var A=function(a,b,d){var e=c(b).toLowerCase().split("-"),f=d?"end":"start",g=e.length,h="classic",i="medium",j="medium";while(g--)switch(e[g]){case"block":case"classic":case"oval":case"diamond":case"open":case"none":h=e[g];break;case"wide":case"narrow":j=e[g];break;case"long":case"short":i=e[g]}var k=a.node.getElementsByTagName("stroke")[0];k[f+"arrow"]=h,k[f+"arrowlength"]=i,k[f+"arrowwidth"]=j},B=function(e,i){e.attrs=e.attrs||{};var l=e.node,m=e.attrs,p=l.style,q,r=v[e.type]&&(i.x!=m.x||i.y!=m.y||i.width!=m.width||i.height!=m.height||i.cx!=m.cx||i.cy!=m.cy||i.rx!=m.rx||i.ry!=m.ry||i.r!=m.r),s=w[e.type]&&(m.cx!=i.cx||m.cy!=i.cy||m.r!=i.r||m.rx!=i.rx||m.ry!=i.ry),t=e;for(var y in i)i[b](y)&&(m[y]=i[y]);r&&(m.path=a._getPath[e.type](e),e._.dirty=1),i.href&&(l.href=i.href),i.title&&(l.title=i.title),i.target&&(l.target=i.target),i.cursor&&(p.cursor=i.cursor),"blur"in i&&e.blur(i.blur);if(i.path&&e.type=="path"||r)l.path=x(~c(m.path).toLowerCase().indexOf("r")?a._pathToAbsolute(m.path):m.path),e.type=="image"&&(e._.fillpos=[m.x,m.y],e._.fillsize=[m.width,m.height],z(e,1,1,0,0,0));"transform"in i&&e.transform(i.transform);if(s){var B=+m.cx,D=+m.cy,E=+m.rx||+m.r||0,G=+m.ry||+m.r||0;l.path=a.format("ar{0},{1},{2},{3},{4},{1},{4},{1}x",f((B-E)*u),f((D-G)*u),f((B+E)*u),f((D+G)*u),f(B*u))}if("clip-rect"in i){var H=c(i["clip-rect"]).split(k);if(H.length==4){H[2]=+H[2]+ +H[0],H[3]=+H[3]+ +H[1];var I=l.clipRect||a._g.doc.createElement("div"),J=I.style;J.clip=a.format("rect({1}px {2}px {3}px {0}px)",H),l.clipRect||(J.position="absolute",J.top=0,J.left=0,J.width=e.paper.width+"px",J.height=e.paper.height+"px",l.parentNode.insertBefore(I,l),I.appendChild(l),l.clipRect=I)}i["clip-rect"]||l.clipRect&&(l.clipRect.style.clip="auto")}if(e.textpath){var K=e.textpath.style;i.font&&(K.font=i.font),i["font-family"]&&(K.fontFamily='"'+i["font-family"].split(",")[0].replace(/^['"]+|['"]+$/g,o)+'"'),i["font-size"]&&(K.fontSize=i["font-size"]),i["font-weight"]&&(K.fontWeight=i["font-weight"]),i["font-style"]&&(K.fontStyle=i["font-style"])}"arrow-start"in i&&A(t,i["arrow-start"]),"arrow-end"in i&&A(t,i["arrow-end"],1);if(i.opacity!=null||i["stroke-width"]!=null||i.fill!=null||i.src!=null||i.stroke!=null||i["stroke-width"]!=null||i["stroke-opacity"]!=null||i["fill-opacity"]!=null||i["stroke-dasharray"]!=null||i["stroke-miterlimit"]!=null||i["stroke-linejoin"]!=null||i["stroke-linecap"]!=null){var L=l.getElementsByTagName(j),M=!1;L=L&&L[0],!L&&(M=L=F(j)),e.type=="image"&&i.src&&(L.src=i.src),i.fill&&(L.on=!0);if(L.on==null||i.fill=="none"||i.fill===null)L.on=!1;if(L.on&&i.fill){var N=c(i.fill).match(a._ISURL);if(N){L.parentNode==l&&l.removeChild(L),L.rotate=!0,L.src=N[1],L.type="tile";var O=e.getBBox(1);L.position=O.x+n+O.y,e._.fillpos=[O.x,O.y],a._preload(N[1],function(){e._.fillsize=[this.offsetWidth,this.offsetHeight]})}else L.color=a.getRGB(i.fill).hex,L.src=o,L.type="solid",a.getRGB(i.fill).error&&(t.type in{circle:1,ellipse:1}||c(i.fill).charAt()!="r")&&C(t,i.fill,L)&&(m.fill="none",m.gradient=i.fill,L.rotate=!1)}if("fill-opacity"in i||"opacity"in i){var P=((+m["fill-opacity"]+1||2)-1)*((+m.opacity+1||2)-1)*((+a.getRGB(i.fill).o+1||2)-1);P=h(g(P,0),1),L.opacity=P,L.src&&(L.color="none")}l.appendChild(L);var Q=l.getElementsByTagName("stroke")&&l.getElementsByTagName("stroke")[0],T=!1;!Q&&(T=Q=F("stroke"));if(i.stroke&&i.stroke!="none"||i["stroke-width"]||i["stroke-opacity"]!=null||i["stroke-dasharray"]||i["stroke-miterlimit"]||i["stroke-linejoin"]||i["stroke-linecap"])Q.on=!0;(i.stroke=="none"||i.stroke===null||Q.on==null||i.stroke==0||i["stroke-width"]==0)&&(Q.on=!1);var U=a.getRGB(i.stroke);Q.on&&i.stroke&&(Q.color=U.hex),P=((+m["stroke-opacity"]+1||2)-1)*((+m.opacity+1||2)-1)*((+U.o+1||2)-1);var V=(d(i["stroke-width"])||1)*.75;P=h(g(P,0),1),i["stroke-width"]==null&&(V=m["stroke-width"]),i["stroke-width"]&&(Q.weight=V),V&&V<1&&(P*=V)&&(Q.weight=1),Q.opacity=P,i["stroke-linejoin"]&&(Q.joinstyle=i["stroke-linejoin"]||"miter"),Q.miterlimit=i["stroke-miterlimit"]||8,i["stroke-linecap"]&&(Q.endcap=i["stroke-linecap"]=="butt"?"flat":i["stroke-linecap"]=="square"?"square":"round");if(i["stroke-dasharray"]){var W={"-":"shortdash",".":"shortdot","-.":"shortdashdot","-..":"shortdashdotdot",". ":"dot","- ":"dash","--":"longdash","- .":"dashdot","--.":"longdashdot","--..":"longdashdotdot"};Q.dashstyle=W[b](i["stroke-dasharray"])?W[i["stroke-dasharray"]]:o}T&&l.appendChild(Q)}if(t.type=="text"){t.paper.canvas.style.display=o;var X=t.paper.span,Y=100,Z=m.font&&m.font.match(/\d+(?:\.\d*)?(?=px)/);p=X.style,m.font&&(p.font=m.font),m["font-family"]&&(p.fontFamily=m["font-family"]),m["font-weight"]&&(p.fontWeight=m["font-weight"]),m["font-style"]&&(p.fontStyle=m["font-style"]),Z=d(m["font-size"]||Z&&Z[0])||10,p.fontSize=Z*Y+"px",t.textpath.string&&(X.innerHTML=c(t.textpath.string).replace(/</g,"&#60;").replace(/&/g,"&#38;").replace(/\n/g,"<br>"));var $=X.getBoundingClientRect();t.W=m.w=($.right-$.left)/Y,t.H=m.h=($.bottom-$.top)/Y,t.X=m.x,t.Y=m.y+t.H/2,("x"in i||"y"in i)&&(t.path.v=a.format("m{0},{1}l{2},{1}",f(m.x*u),f(m.y*u),f(m.x*u)+1));var _=["x","y","text","font","font-family","font-weight","font-style","font-size"];for(var ba=0,bb=_.length;ba<bb;ba++)if(_[ba]in i){t._.dirty=1;break}switch(m["text-anchor"]){case"start":t.textpath.style["v-text-align"]="left",t.bbx=t.W/2;break;case"end":t.textpath.style["v-text-align"]="right",t.bbx=-t.W/2;break;default:t.textpath.style["v-text-align"]="center",t.bbx=0}t.textpath.style["v-text-kern"]=!0}},C=function(b,f,g){b.attrs=b.attrs||{};var h=b.attrs,i=Math.pow,j,k,l="linear",m=".5 .5";b.attrs.gradient=f,f=c(f).replace(a._radial_gradient,function(a,b,c){l="radial",b&&c&&(b=d(b),c=d(c),i(b-.5,2)+i(c-.5,2)>.25&&(c=e.sqrt(.25-i(b-.5,2))*((c>.5)*2-1)+.5),m=b+n+c);return o}),f=f.split(/\s*\-\s*/);if(l=="linear"){var p=f.shift();p=-d(p);if(isNaN(p))return null}var q=a._parseDots(f);if(!q)return null;b=b.shape||b.node;if(q.length){b.removeChild(g),g.on=!0,g.method="none",g.color=q[0].color,g.color2=q[q.length-1].color;var r=[];for(var s=0,t=q.length;s<t;s++)q[s].offset&&r.push(q[s].offset+n+q[s].color);g.colors=r.length?r.join():"0% "+g.color,l=="radial"?(g.type="gradientTitle",g.focus="100%",g.focussize="0 0",g.focusposition=m,g.angle=0):(g.type="gradient",g.angle=(270-p)%360),b.appendChild(g)}return 1},D=function(b,c){this[0]=this.node=b,b.raphael=!0,this.id=a._oid++,b.raphaelid=this.id,this.X=0,this.Y=0,this.attrs={},this.paper=c,this.matrix=a.matrix(),this._={transform:[],sx:1,sy:1,dx:0,dy:0,deg:0,dirty:1,dirtyT:1},!c.bottom&&(c.bottom=this),this.prev=c.top,c.top&&(c.top.next=this),c.top=this,this.next=null},E=a.el;D.prototype=E,E.constructor=D,E.transform=function(b){if(b==null)return this._.transform;var d=this.paper._viewBoxShift,e=d?"s"+[d.scale,d.scale]+"-1-1t"+[d.dx,d.dy]:o,f;d&&(f=b=c(b).replace(/\.{3}|\u2026/g,this._.transform||o)),a._extractTransform(this,e+b);var g=this.matrix.clone(),h=this.skew,i=this.node,j,k=~c(this.attrs.fill).indexOf("-"),l=!c(this.attrs.fill).indexOf("url(");g.translate(-0.5,-0.5);if(l||k||this.type=="image"){h.matrix="1 0 0 1",h.offset="0 0",j=g.split();if(k&&j.noRotation||!j.isSimple){i.style.filter=g.toFilter();var m=this.getBBox(),p=this.getBBox(1),q=m.x-p.x,r=m.y-p.y;i.coordorigin=q*-u+n+r*-u,z(this,1,1,q,r,0)}else i.style.filter=o,z(this,j.scalex,j.scaley,j.dx,j.dy,j.rotate)}else i.style.filter=o,h.matrix=c(g),h.offset=g.offset();f&&(this._.transform=f);return this},E.rotate=function(a,b,e){if(this.removed)return this;if(a!=null){a=c(a).split(k),a.length-1&&(b=d(a[1]),e=d(a[2])),a=d(a[0]),e==null&&(b=e);if(b==null||e==null){var f=this.getBBox(1);b=f.x+f.width/2,e=f.y+f.height/2}this._.dirtyT=1,this.transform(this._.transform.concat([["r",a,b,e]]));return this}},E.translate=function(a,b){if(this.removed)return this;a=c(a).split(k),a.length-1&&(b=d(a[1])),a=d(a[0])||0,b=+b||0,this._.bbox&&(this._.bbox.x+=a,this._.bbox.y+=b),this.transform(this._.transform.concat([["t",a,b]]));return this},E.scale=function(a,b,e,f){if(this.removed)return this;a=c(a).split(k),a.length-1&&(b=d(a[1]),e=d(a[2]),f=d(a[3]),isNaN(e)&&(e=null),isNaN(f)&&(f=null)),a=d(a[0]),b==null&&(b=a),f==null&&(e=f);if(e==null||f==null)var g=this.getBBox(1);e=e==null?g.x+g.width/2:e,f=f==null?g.y+g.height/2:f,this.transform(this._.transform.concat([["s",a,b,e,f]])),this._.dirtyT=1;return this},E.hide=function(){!this.removed&&(this.node.style.display="none");return this},E.show=function(){!this.removed&&(this.node.style.display=o);return this},E._getBBox=function(){if(this.removed)return{};return{x:this.X+(this.bbx||0)-this.W/2,y:this.Y-this.H,width:this.W,height:this.H}},E.remove=function(){if(!this.removed){this.paper.__set__&&this.paper.__set__.exclude(this),a.eve.unbind("*.*."+this.id),a._tear(this,this.paper),this.node.parentNode.removeChild(this.node),this.shape&&this.shape.parentNode.removeChild(this.shape);for(var b in this)this[b]=typeof this[b]=="function"?a._removedFactory(b):null;this.removed=!0}},E.attr=function(c,d){if(this.removed)return this;if(c==null){var e={};for(var f in this.attrs)this.attrs[b](f)&&(e[f]=this.attrs[f]);e.gradient&&e.fill=="none"&&(e.fill=e.gradient)&&delete e.gradient,e.transform=this._.transform;return e}if(d==null&&a.is(c,"string")){if(c==j&&this.attrs.fill=="none"&&this.attrs.gradient)return this.attrs.gradient;var g=c.split(k),h={};for(var i=0,m=g.length;i<m;i++)c=g[i],c in this.attrs?h[c]=this.attrs[c]:a.is(this.paper.customAttributes[c],"function")?h[c]=this.paper.customAttributes[c].def:h[c]=a._availableAttrs[c];return m-1?h:h[g[0]]}if(this.attrs&&d==null&&a.is(c,"array")){h={};for(i=0,m=c.length;i<m;i++)h[c[i]]=this.attr(c[i]);return h}var n;d!=null&&(n={},n[c]=d),d==null&&a.is(c,"object")&&(n=c);for(var o in n)l("attr."+o+"."+this.id,this,n[o]);if(n){for(o in this.paper.customAttributes)if(this.paper.customAttributes[b](o)&&n[b](o)&&a.is(this.paper.customAttributes[o],"function")){var p=this.paper.customAttributes[o].apply(this,[].concat(n[o]));this.attrs[o]=n[o];for(var q in p)p[b](q)&&(n[q]=p[q])}n.text&&this.type=="text"&&(this.textpath.string=n.text),B(this,n)}return this},E.toFront=function(){!this.removed&&this.node.parentNode.appendChild(this.node),this.paper&&this.paper.top!=this&&a._tofront(this,this.paper);return this},E.toBack=function(){if(this.removed)return this;this.node.parentNode.firstChild!=this.node&&(this.node.parentNode.insertBefore(this.node,this.node.parentNode.firstChild),a._toback(this,this.paper));return this},E.insertAfter=function(b){if(this.removed)return this;b.constructor==a.st.constructor&&(b=b[b.length-1]),b.node.nextSibling?b.node.parentNode.insertBefore(this.node,b.node.nextSibling):b.node.parentNode.appendChild(this.node),a._insertafter(this,b,this.paper);return this},E.insertBefore=function(b){if(this.removed)return this;b.constructor==a.st.constructor&&(b=b[0]),b.node.parentNode.insertBefore(this.node,b.node),a._insertbefore(this,b,this.paper);return this},E.blur=function(b){var c=this.node.runtimeStyle,d=c.filter;d=d.replace(r,o),+b!==0?(this.attrs.blur=b,c.filter=d+n+m+".Blur(pixelradius="+(+b||1.5)+")",c.margin=a.format("-{0}px 0 0 -{0}px",f(+b||1.5))):(c.filter=d,c.margin=0,delete this.attrs.blur)},a._engine.path=function(a,b){var c=F("shape");c.style.cssText=t,c.coordsize=u+n+u,c.coordorigin=b.coordorigin;var d=new D(c,b),e={fill:"none",stroke:"#000"};a&&(e.path=a),d.type="path",d.path=[],d.Path=o,B(d,e),b.canvas.appendChild(c);var f=F("skew");f.on=!0,c.appendChild(f),d.skew=f,d.transform(o);return d},a._engine.rect=function(b,c,d,e,f,g){var h=a._rectPath(c,d,e,f,g),i=b.path(h),j=i.attrs;i.X=j.x=c,i.Y=j.y=d,i.W=j.width=e,i.H=j.height=f,j.r=g,j.path=h,i.type="rect";return i},a._engine.ellipse=function(a,b,c,d,e){var f=a.path(),g=f.attrs;f.X=b-d,f.Y=c-e,f.W=d*2,f.H=e*2,f.type="ellipse",B(f,{cx:b,cy:c,rx:d,ry:e});return f},a._engine.circle=function(a,b,c,d){var e=a.path(),f=e.attrs;e.X=b-d,e.Y=c-d,e.W=e.H=d*2,e.type="circle",B(e,{cx:b,cy:c,r:d});return e},a._engine.image=function(b,c,d,e,f,g){var h=a._rectPath(d,e,f,g),i=b.path(h).attr({stroke:"none"}),k=i.attrs,l=i.node,m=l.getElementsByTagName(j)[0];k.src=c,i.X=k.x=d,i.Y=k.y=e,i.W=k.width=f,i.H=k.height=g,k.path=h,i.type="image",m.parentNode==l&&l.removeChild(m),m.rotate=!0,m.src=c,m.type="tile",i._.fillpos=[d,e],i._.fillsize=[f,g],l.appendChild(m),z(i,1,1,0,0,0);return i},a._engine.text=function(b,d,e,g){var h=F("shape"),i=F("path"),j=F("textpath");d=d||0,e=e||0,g=g||"",i.v=a.format("m{0},{1}l{2},{1}",f(d*u),f(e*u),f(d*u)+1),i.textpathok=!0,j.string=c(g),j.on=!0,h.style.cssText=t,h.coordsize=u+n+u,h.coordorigin="0 0";var k=new D(h,b),l={fill:"#000",stroke:"none",font:a._availableAttrs.font,text:g};k.shape=h,k.path=i,k.textpath=j,k.type="text",k.attrs.text=c(g),k.attrs.x=d,k.attrs.y=e,k.attrs.w=1,k.attrs.h=1,B(k,l),h.appendChild(j),h.appendChild(i),b.canvas.appendChild(h);var m=F("skew");m.on=!0,h.appendChild(m),k.skew=m,k.transform(o);return k},a._engine.setSize=function(b,c){var d=this.canvas.style;this.width=b,this.height=c,b==+b&&(b+="px"),c==+c&&(c+="px"),d.width=b,d.height=c,d.clip="rect(0 "+b+" "+c+" 0)",this._viewBox&&a._engine.setViewBox.apply(this,this._viewBox);return this},a._engine.setViewBox=function(b,c,d,e,f){a.eve("setViewBox",this,this._viewBox,[b,c,d,e,f]);var h=this.width,i=this.height,j=1/g(d/h,e/i),k,l;f&&(k=i/e,l=h/d,d*k<h&&(b-=(h-d*k)/2/k),e*l<i&&(c-=(i-e*l)/2/l)),this._viewBox=[b,c,d,e,!!f],this._viewBoxShift={dx:-b,dy:-c,scale:j},this.forEach(function(a){a.transform("...")});return this};var F;a._engine.initWin=function(a){var b=a.document;b.createStyleSheet().addRule(".rvml","behavior:url(#default#VML)");try{!b.namespaces.rvml&&b.namespaces.add("rvml","urn:schemas-microsoft-com:vml"),F=function(a){return b.createElement("<rvml:"+a+' class="rvml">')}}catch(c){F=function(a){return b.createElement("<"+a+' xmlns="urn:schemas-microsoft.com:vml" class="rvml">')}}},a._engine.initWin(a._g.win),a._engine.create=function(){var b=a._getContainer.apply(0,arguments),c=b.container,d=b.height,e,f=b.width,g=b.x,h=b.y;if(!c)throw new Error("VML container not found.");var i=new a._Paper,j=i.canvas=a._g.doc.createElement("div"),k=j.style;g=g||0,h=h||0,f=f||512,d=d||342,i.width=f,i.height=d,f==+f&&(f+="px"),d==+d&&(d+="px"),i.coordsize=u*1e3+n+u*1e3,i.coordorigin="0 0",i.span=a._g.doc.createElement("span"),i.span.style.cssText="position:absolute;left:-9999em;top:-9999em;padding:0;margin:0;line-height:1;",j.appendChild(i.span),k.cssText=a.format("top:0;left:0;width:{0};height:{1};display:inline-block;position:relative;clip:rect(0 {0} {1} 0);overflow:hidden",f,d),c==1?(a._g.doc.body.appendChild(j),k.left=g+"px",k.top=h+"px",k.position="absolute"):c.firstChild?c.insertBefore(j,c.firstChild):c.appendChild(j),i.renderfix=function(){};return i},a.prototype.clear=function(){a.eve("clear",this),this.canvas.innerHTML=o,this.span=a._g.doc.createElement("span"),this.span.style.cssText="position:absolute;left:-9999em;top:-9999em;padding:0;margin:0;line-height:1;display:inline;",this.canvas.appendChild(this.span),this.bottom=this.top=null},a.prototype.remove=function(){a.eve("remove",this),this.canvas.parentNode.removeChild(this.canvas);for(var b in this)this[b]=typeof this[b]=="function"?a._removedFactory(b):null;return!0};var G=a.st;for(var H in E)E[b](H)&&!G[b](H)&&(G[H]=function(a){return function(){var b=arguments;return this.forEach(function(c){c[a].apply(c,b)})}}(H))}(window.Raphael);
/*globals jQuery,$*/
/*jslint white: false */
/*
 *
 * Wijmo Library 1.1.2
 * http://wijmo.com/
 *
 * Copyright(c) ComponentOne, LLC.  All rights reserved.
 * 
 * Dual licensed under the Wijmo Commercial or GNU GPL Version 3 licenses.
 * licensing@wijmo.com
 * http://wijmo.com/license
 *
 *
 * * Wijmo Pager widget.
 *
 * Depends:
 *  jquery-1.4.2.js
 *  jquery.ui.core.js
 *  jquery.ui.widget.js
 *
 */
(function ($) {
	"use strict";
	$.widget("wijmo.wijpager", {
		options: {
			/// <summary>
			/// The class of the first-page button.
			/// Default: ui-icon-seek-first.
			/// Type: String
			/// Code example: $("#element").wijpager( { firstButtonClass: "ui-icon-seek-first" } );
			/// </summary>
			firstPageClass: "ui-icon-seek-first",

			/// <summary>
			/// The text to display for the first-page button.
			/// Default: "First".
			/// Type: String
			/// Code example: $("#element").wijpager( { firstPageText: "First" } );
			/// </summary>
			firstPageText: "First",

			/// <summary>
			/// The class of the last-page button.
			/// Default: ui-icon-seek-end.
			/// Type: String
			/// Code example: $("#element").wijpager( { lastPageClass: "ui-icon-seek-end" } );
			/// </summary>
			lastPageClass: "ui-icon-seek-end",

			/// <summary>
			/// The text to display for the last-page button.
			/// Default: "Last".
			/// Type: String
			/// Code example: $("#element").wijpager( { lastPageText: "Last" } );
			/// </summary>
			lastPageText: "Last",

			/// <summary>
			/// Determines the pager mode. Possible values are: "nextPrevious", "nextPreviousFirstLast", "numeric", "numericFirstLast".
			/// 
			/// "nextPrevious" - a set of pagination controls consisting of Previous and Next buttons.
			/// "nextPreviousFirstLast" - a set of pagination controls consisting of Previous, Next, First, and Last buttons.
			/// "numeric" - a set of pagination controls consisting of numbered link buttons to access pages directly.
			/// "numericFirstLast" - a set of pagination controls consisting of numbered and First and Last link buttons.
			///
			/// Default: "numeric".
			/// Type: String
			/// Code example: $("#element").wijpager( { mode: "numeric" } );
			/// </summary>
			mode: "numeric",

			/// <summary>
			/// The class of the next-page button.
			/// Default: ui-icon-seek-next.
			/// Type: String
			/// Code example: $("#element").wijpager( { nextPageClass: "ui-icon-seek-next" } );
			/// </summary>
			nextPageClass: "ui-icon-seek-next",

			/// <summary>
			/// The text to display for the next-page button.
			/// Default: "Next".
			/// Type: String
			/// Code example: $("#element").wijpager( { nextPageText: "Next" } );
			/// </summary>
			nextPageText: "Next",

			/// <summary>
			/// The number of page buttons to display in the pager.
			/// Default: 10.
			/// Type: Number.
			/// Code example: $("#element").wijpager( { pageButtonCount: 10 } );
			/// </summary>
			pageButtonCount: 10,

			/// <summary>
			/// The class of the previous-page button.
			/// Default: ui-icon-seek-prev.
			/// Type: String
			/// Code example: $("#element").wijpager( { previousPageClass: "ui-icon-seek-prev" } );
			/// </summary>
			previousPageClass: "ui-icon-seek-prev",

			/// <summary>
			/// The text to display for the previous-page button.
			/// Default: "Previous".
			/// Type: String
			/// Code example: $("#element").wijpager( { previousPageText: "Previous" } );
			/// </summary>
			previousPageText: "Previous",

			/// <summary>
			/// Total number of pages.
			/// Default: 1.
			/// Type: Number.
			/// Code example: $("#element").wijpager( { pageCount: 1 } );
			/// </summary>
			pageCount: 1,

			/// <summary>
			/// The zero-based index of the current page.
			/// Default: 0.
			/// Type: Number.
			/// Code example: $("#element").wijpager( { pageIndex: 0 } );
			/// </summary>
			pageIndex: 0,

			/// <summary>
			/// pageIndexChanging event handler. A function called when page index is changing. Cancellable.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the pageIndexChanging event:
			/// $("#element").wijpager({ pageIndexChanging: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijpagerpageindexchanging", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data whith this event.
			/// args.newPageIndex - new page index.
			/// </param>
			pageIndexChanging: null,

			/// <summary>
			/// pageIndexChanged event handler. A function called when the page index is changed.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the pageIndexChanged event:
			/// $("#element").wijpager({ pageIndexChanged: function (e) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijpagerpageindexchanged", function (e) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			pageIndexChanged: null
		},

		_create: function () {
			this.element.addClass("ui-widget wijmo-wijpager ui-helper-clearfix");

			if (this.options.disabled) {
				this.disable();
			}

			this._refresh();
		},

		_init: function () {
		},

		destroy: function () {
			/// <summary>
			/// Destroys the wijpager widget and reset the DOM element.
			/// Code example: $("#element").wijpager("destroy");
			/// </summary>
			this.element.removeClass("ui-widget wijmo-wijpager ui-helper-clearfix");
			this.$ul.remove();
			$.Widget.prototype.destroy.apply(this, arguments);
		},

		_setOption: function (key, value) {
			$.Widget.prototype._setOption.apply(this, arguments);
			this._refresh();
		},

		_refresh: function () {
			this._validate();

			if (this.$ul) {
				this.$ul.remove();
			}

			this.element.append(this.$ul = $("<ul class=\"ui-list ui-corner-all ui-widget-content ui-helper-clearfix\" role=\"tablist\"></ul>"));

			switch ((this.options.mode || "").toLowerCase()) {
				case "nextprevious":
					this._createNextPrev(false);
					break;

				case "nextpreviousfirstlast":
					this._createNextPrev(true);
					break;

				case "numeric":
					this._createNumeric(false);
					break;

				case "numericfirstlast":
					this._createNumeric(true);
					break;
			}
		},

		_validate: function () {
			var o = this.options;

			if (isNaN(o.pageCount) || o.pageCount < 1) {
				o.pageCount = 1;
			}

			if (isNaN(o.pageIndex) || o.pageIndex < 0) {
				o.pageIndex = 0;
			} else {
				 if (o.pageIndex >= o.pageCount) {
					o.pageIndex = o.pageCount - 1;
				}
			}

			if (isNaN(o.pageButtonCount) || o.pageButtonCount < 1) {
				o.pageButtonCount = 1;
			}
		},

		_createNextPrev: function (addFirstLast) {
			var o = this.options;

			// first button
			if (addFirstLast && o.pageIndex) {
				this.$ul.append(this._createPagerItem(false, o.firstPageText, 1, o.firstPageClass));
			}

			// previous button
			if (o.pageIndex) {
				this.$ul.append(this._createPagerItem(false, o.previousPageText, o.pageIndex, o.previousPageClass));
			}

			// next button
			if (o.pageIndex + 1 < o.pageCount) {
				this.$ul.append(this._createPagerItem(false, o.nextPageText, o.pageIndex + 2, o.nextPageClass));
			}

			// last button
			if (addFirstLast && (o.pageIndex + 1 < o.pageCount)) {
				this.$ul.append(this._createPagerItem(false, o.lastPageText, o.pageCount, o.lastPageClass));
			}
		},

		_createNumeric: function (addFirstLast) {
			var o = this.options,
				currentPage = o.pageIndex + 1,
				startPageNumber = 1,
				endPageNumber = Math.min(o.pageCount, o.pageButtonCount),
				i;

			if (currentPage > endPageNumber) {
				startPageNumber = (Math.floor(o.pageIndex/ o.pageButtonCount)) * o.pageButtonCount + 1;

				endPageNumber = startPageNumber + o.pageButtonCount - 1;
				endPageNumber = Math.min(endPageNumber, o.pageCount);

				if (endPageNumber - startPageNumber + 1 < o.pageButtonCount) {
					startPageNumber = Math.max(1, endPageNumber - o.pageButtonCount + 1);
				}
			}

			// first + "..." buttons
			if (startPageNumber !== 1) {
				// first button
				if (addFirstLast) {
					this.$ul.append(this._createPagerItem(false, o.firstPageText, 1, o.firstPageClass));
				}

				// "..." button
				this.$ul.append(this._createPagerItem(false, "...", startPageNumber - 1, ""));
			}

			// page numbers buttons
			for (i = startPageNumber; i <= endPageNumber; i++) {
				this.$ul.append(this._createPagerItem(i === currentPage, i.toString(), i, ""));
			}

			// "..." + last buttons
			if (o.pageCount > endPageNumber) {
				this.$ul.append(this._createPagerItem(false, "...", endPageNumber + 1, ""));

				// last button
				if (addFirstLast) {
					this.$ul.append(this._createPagerItem(false, o.lastPageText, o.pageCount, o.lastPageClass));
				}
			}
		},

		_createPagerItem: function (active, title, pageIndex, btnClass) {
			var btnContent,
				 self = this,
				 $li = $("<li />")
					.addClass("ui-page ui-corner-all")
					.attr({ "role": "tab", "aria-label": title, "title": title });

			if (active) {
				$li
					.addClass("ui-state-active")
					.attr("aria-selected", "true");
			} else {
				$li
					.addClass("ui-state-default")
					.hover(
						function () {
							if (!self.options.disabled) {
								$(this).removeClass("ui-state-default").addClass("ui-state-hover");
							}
						},
						function () {
							if (!self.options.disabled) {
								$(this).removeClass("ui-state-hover").addClass("ui-state-default");
							}
					})
					.bind("click." + this.widgetName, { newPageIndex: pageIndex - 1 }, $.proxy(this._onClick, this)); // pageIndex is 1-based.
			}

			if (active) {
				btnContent = $("<span />");
			} else {
				btnContent = btnClass
					? $("<span />").addClass("ui-icon " + btnClass)
					: $("<a/>").attr("href", "#");
			}

			btnContent
				.text(title);

			$li.append(btnContent);

			return $li;
		},

		_onClick: function (arg) {
			if (this.options.disabled) {
				return false;
			}

			var eventArg = { newPageIndex: arg.data.newPageIndex, handled: false };

			if (this._trigger("pageIndexChanging", null, eventArg) !== false) {
				if (this.options.pageIndex !== eventArg.newPageIndex) {
					this.options.pageIndex = eventArg.newPageIndex;
					if (!eventArg.handled) {
						this._refresh();
					}
					this._trigger("pageIndexChanged", null, { newPageIndex: eventArg.newPageIndex });
				}
			}

			return false;
		}
	});
})(jQuery);

/*
 *
 * Wijmo Library 1.1.2
 * http://wijmo.com/
 *
 * Copyright(c) ComponentOne, LLC.  All rights reserved.
 * 
 * Dual licensed under the Wijmo Commercial or GNU GPL Version 3 licenses.
 * licensing@wijmo.com
 * http://wijmo.com/license
 *
 *
 ** Wijmo Text Selection plugin.
*
*/


(function ($) {
	"use strict";

	$.fn.extend({
		wijtextselection: function () {
			/// <summary>jQuery plugins to get/set text selection for input element</summary>
			var start, end, t = this[0];
			var val = this.val();
			if (arguments.length === 0) {
				var range, stored_range, s, e;
				if ($.browser.msie) {
					var selection = document.selection;
					if (t.tagName.toLowerCase() != "textarea") {
						range = selection.createRange().duplicate();
						range.moveEnd("character", val.length);
						s = (range.text == "" ? val.length : val.lastIndexOf(range.text));
						range = selection.createRange().duplicate();
						range.moveStart("character", -val.length);
						e = range.text.length;
					} else {
						range = selection.createRange();
						stored_range = range.duplicate();
						stored_range.moveToElementText(t);
						stored_range.setEndPoint('EndToEnd', range);
						s = stored_range.text.length - range.text.length,
				e = s + range.text.length
					}
			} else {
					// invisible input throw an exception in FF
					//if ($(t).isPrototypeOf(':visible')) {
						s = t.selectionStart;
						e = t.selectionEnd;
					//}
					//else {
					//	s = e = 0;
					//}
				}

				var te = val.substring(s, e);
				return { start: s, end: e, text: te, replace: function (st) {
					return val.substring(0, s) + st + val.substring(e, val.length)
				}
				};
			} else if (arguments.length === 1) {
				if (typeof arguments[0] === "object" && typeof arguments[0].start === "number" && typeof arguments[0].end === "number") {
					start = arguments[0].start;
					end = arguments[0].end;
				} else if (typeof arguments[0] === "string") {
					if ((start = val.indexOf(arguments[0])) > -1) {
						end = start + arguments[0].length;
					}
				} else if (Object.prototype.toString.call(arguments[0]) === "[object RegExp]") {
					var re = arguments[0].exec(val);
					if (re != null) {
						start = re.index;
						end = start + re[0].length;
					}
				}
			} else if (arguments.length === 2) {
				if (typeof arguments[0] === "number" && typeof arguments[1] === "number") {
					start = arguments[0];
					end = arguments[1];
				}
			}

			if (typeof start === "undefined") {
				start = 0;
				end = val.length;
			}

			if ($.browser.msie) {
				var selRange = t.createTextRange();
				selRange.collapse(true);
				selRange.moveStart('character', start);
				selRange.moveEnd('character', end - start);
				selRange.select();
			} else {
				t.selectionStart = start;
				t.selectionEnd = end;
			}
		}
	});

})(jQuery);

/*globals window jQuery */
/*
 *
 * Wijmo Library 1.1.2
 * http://wijmo.com/
 *
 * Copyright(c) ComponentOne, LLC.  All rights reserved.
 * 
 * Dual licensed under the Wijmo Commercial or GNU GPL Version 3 licenses.
 * licensing@wijmo.com
 * http://wijmo.com/license
 *
 *
 ** Wijmo Datasource widget.
*
* Depends:
*	jquery.js
*	jquery.ui.js
*
*/
(function ($) {
	"use strict";
	/// <summary>
	/// wijdatasource reads local raw data or remote raw data through proxy by using
	/// a DataReader and provide tabular object data for widgets. 
	/// </summary>
	var wijdatasource, wijarrayreader, wijhttpproxy;
	wijdatasource = function (options) {
		var self = this;
		/// <summary>
		/// The data to process using the wijdatasource class.
		/// Default: {}.
		/// Type: Object. 
		/// </summary>
		self.data = {};
		/// <summary>
		/// The reader to use with wijdatasource. The wijdatasource class will call the
		/// read method of reader to read from rawdata with an array of fields provided.
		/// The field contains a name, mapping and defaultValue properties which define
		/// the rule of the mapping.
		/// If no reader is configured with wijdatasource it will directly return the
		/// raw data.
		/// Default: null.
		/// Type: Object. 
		/// </summary>
		self.reader = null;
		/// <summary>
		/// The proxy to use with wijdatasource. The wijdatasource class will call
		/// the proxy object's request method.  
		/// In the proxy object, you can send a request to a remote server to
		/// obtain data with the ajaxs options object provided.
		/// Then you can use the wijdatasource reader to process the raw data in the call.
		/// Default: null.
		/// Type: Object. 
		/// </summary>
		self.proxy = null;
		/// <summary>
		/// The processed items from the raw data.  This can be obtained after
		/// datasource is loaded.
		/// Default: [].
		/// Type: Array. 
		/// </summary>
		self.items = [];
		/// <summary>
		/// Function called before loading process starts
		/// Default: null.
		/// Type: Function. 
		/// Code example:
		/// var datasource = new wijdatasource({loading: function(e, data) { }})
		/// </summary>
		/// <param name="datasource" type="wijdatasource">
		/// wijdatasource object that raises this event.
		/// </param>
		/// <param name="data" type="Object">
		/// data passed in by load method.
		/// </param>
		self.loading = null;
		/// <summary>
		/// Function called after loading.
		/// Default: null.
		/// Type: Function. 
		/// Code example:
		/// var datasource = new wijdatasource({loaded: function(e, data) { }})
		/// </summary>
		/// <param name="datasource" type="wijdatasource">
		/// wijdatasource object that raises this event.
		/// </param>
		/// <param name="data" type="Object">
		/// data passed in by load method.
		/// </param>
		self.loaded = null;		
		self._constructor(options);
	};
	window.wijdatasource = wijdatasource;

	$.extend(wijdatasource.prototype, {
		_constructor: function (options) {
			$.extend(this, options);
		},

		load: function (data, forceLocalReload) {
			/// <summary>
			/// Triggers data loading process of wijdatasource.
			/// </summary>
			/// <param name="data" type="Object">
			/// The data to pass to the loading and loaded event handler.
			/// </param>
			/// <param name="forceLocalReload" type="Boolean">
			/// Normally local data is only load for one time,
			/// if needs to reload the data, try to set forceLocalReload to true.
			/// </param>

			var self = this,
			p = self.proxy;
			//var d = self.data;
			// fire loading event.
			if ($.isFunction(self.loading)) {
				self.loading(self, data);
			}
			// if datasource has an proxy object, it will use the request method of
			// proxy to retrive the raw data.
			if (p) {
				// pass callback function to request method so that proxy could
				// call the function when request is finished.
				p.request(self, self.loaded, data);
			}
			else {
				// local data is loaded only once, if force loading is needed
				// forceLocalReload should be true.
				if (self.items.length === 0 || forceLocalReload) {
					// no proxy, read raw data
					this.read();
				}
				// callback function is called
				if ($.isFunction(self.loaded)) {
					self.loaded(self, data);
				}
			}
		},

		read: function () {
			/// <summary>
			/// Triggers data reading process of wijdatasource
			/// by using a DataReader if presented.
			/// </summary>

			var self = this,
			d = self.data;
			// reads using a reader object
			if (d && self.reader) {
				self.reader.read(self);
			}
			else {
				// returns raw data if no reader is configured with datasource.
				self.items = self.data;
				//removed by Jeffrey for removing unnecessary return
				//return self.data;
				//end by Jeffrey
			}
		}
	});

	/// <summary>
	/// wijdatasource ArrayReader reads from a array and processes items.
	/// </summary>
	wijarrayreader = function (fields) {
		// this.fields to store the fields info

		// Add for parse objectValue options for jUICE. D.H
		if ($.isFunction(window["wijmoASPNetParseOptions"])) {
			wijmoASPNetParseOptions(fields);
		}

		if ($.isArray(fields)) {
			this.fields = fields;
		}
	};
	window.wijarrayreader = wijarrayreader;

	$.extend(wijarrayreader.prototype, {
		read: function (datasource) {
			/// <summary>
			/// Starts reading data.
			/// </summary>
			/// <param name="datasource" type="wijdatasource">
			/// The wijdatasource using this DataReader.
			/// </param>

			// convert the raw data of wijdatasource
			if ($.isArray(datasource.data)) {
				datasource.items = this._map(datasource.data);
			}
			else {
				datasource.items = [];
			}
		},

		_map: function (data) {
			var self = this, arr = [];
			if (self.fields === undefined || self.fields.length === 0) {
				$.extend(true, arr, data);
				return arr;
			}
			else {
				$.each(data, function (index, value) {
					var i = {};
					$.each(self.fields, function (index, field) {
						// mapping property is a function,
						// the return value will be used as value.

						//handle the juice
						if (field.mapping && typeof field.mapping && window[field.mapping]) {
							field.mapping = window[field.mapping];
						}

						if ($.isFunction(field.mapping)) {
							i[field.name] = field.mapping(value);
							return true;
						}
						// use string field mapping or number index mapping.
						var mapping = field.mapping !== undefined ?
											field.mapping : field.name,
						v = value[mapping];
						if (v === undefined) {
							if (field.defaultValue !== undefined) {
								v = field.defaultValue;
							}
							else {
								v = value;
							}
						}
						i[field.name] = v;
					});
					arr.push(i);
				});
			}
			return arr;
		}
	});

	/// <summary>
	/// wijdatasource HttpProxy fetches data by using Ajax request.
	/// </summary>
	wijhttpproxy = function (options) {
		this.options = options;

		// Add for parse objectValue options for jUICE. D.H
		if ($.isFunction(window["wijmoASPNetParseOptions"])) {
			wijmoASPNetParseOptions(options);
		}
	};
	window.wijhttpproxy = wijhttpproxy;

	$.extend(wijhttpproxy.prototype, {
		request: function (datasource, callBack, userData) {
			/// <summary>
			/// Starts requesting data.
			/// </summary>
			/// <param name="datasource" type="wijdatasource">
			/// The wijdatasource using this DataReader.
			/// </param>
			/// <param name="callback" type="Function">
			/// The function to call after requesting data successfully.
			/// </param>

			var self = this,
			o = $.extend({}, this.options),
			oldSuccess = o.success;

			o.success = function (data) {
				if ($.isFunction(oldSuccess)) {
					oldSuccess(data);
				}
				self._complete(data, datasource, callBack, o, userData);
			};
			$.ajax(o);
		},

		_complete: function (data, datasource, callback, options, userData) {
			// set raw data
			datasource.data = options.key !== undefined ? data[options.key] : data;
			// read raw data using a data reader in datasource
			datasource.read();
			// fire loaded callback
			if ($.isFunction(callback)) {
				callback(datasource, userData);
			}
		}
	});
} (jQuery));

/*globals jQuery,window,document*/
/*
 *
 * Wijmo Library 1.1.2
 * http://wijmo.com/
 *
 * Copyright(c) ComponentOne, LLC.  All rights reserved.
 * 
 * Dual licensed under the Wijmo Commercial or GNU GPL Version 3 licenses.
 * licensing@wijmo.com
 * http://wijmo.com/license
 *
 *
 * * Wijmo Combobox widget.
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 *	jquery.ui.position.js
 *	jquery.wijmo.wijlist.js
 *
 */
(function ($) {
	"use strict";
	var inputCSS = "wijmo-wijcombobox-input",
		stateHover = "ui-state-hover",
		stateActive = "ui-state-active",
		stateFocus = "ui-state-focus",
		conerLeft = "ui-corner-left",
		conerRight = "ui-corner-right",
		triggerHTML = "<div class='wijmo-wijcombobox-trigger ui-state-default " +
							"ui-corner-right'>" +
							"<span class='ui-icon ui-icon-triangle-1-s'></span>" +
						"</div>",
		labelHTML = "<label class='wijmo-wijcombobox-label ui-widget-content'></label>";

	$.widget("wijmo.wijcombobox", {
		options: {
			/// <summary>
			/// A value that specifies the underlying data source provider of wijcombobox.
			/// Default: null.
			/// Type: wijdatasource/Array
			/// Code example: 
			/// var testArray = [ 
		    /// {label: 'c++',value: 'c++'},  
		    /// {label: 'java',value: 'java'},  
		    /// {label: 'php',value: 'php'}]; 
			/// $("#tags").wijcombobox("option", "data", testArray);
			/// </summary>
			/// <remarks>
			/// This option could either be a wijdatasource object 
			/// or an Object Array containing an item such as 
			/// {label: "label text", value: "value"}.
			/// </remarks>
			data: null,
			/// <summary>
			/// A value that specifies the text in the wijcombobox label.
			/// Default: null.
			/// Type: String.
			/// Code example: $("#tags").wijcombobox("option", "labelText", "Text")
			/// </summary>
			labelText: null,
			/// <summary>
			/// A value that determines the minimum length of text 
			/// that can be entered in the wijcombobox text box to issue an AJAX request.
			/// Default: 4.
			/// Type: Number.
			/// Code example: $("#tags").wijcombobox("option", "minLength", 5)
			/// </summary>
			minLength: 4,
			/// <summary>
			/// A value that determines the duration (in milliseconds) of the time 
			/// to delay before autocomplete begins after typing stops.
			/// Default: 300.
			/// Type: Number.
			/// Code example: $("#tags").wijcombobox("option", "delay", 500)
			/// </summary>
			delay: 300,
			/// <summary>
			/// A value that specifies the animation options for a drop-down list
			/// when it is visible.
			/// Default: null.
			/// Type: Object.
			/// Code example: 
			/// var animationOptions = {
            /// animated: "Drop",
            /// duration: 1000
            /// };
			/// $("#tags").wijcombobox("option", "showingAnimation", animationOptions)
			/// </summary>
			showingAnimation: null,
			/// <summary>
			/// A value specifies the animation options for the drop-down list
			/// when it is hidden.
			/// Default: null.
			/// Type: Object.
			/// Code example: 
			/// var animationOptions = {
            /// animated: "Drop",
            /// duration: 1000
            /// };
			///$("#tags").wijcombobox("option", "hidingAnimation", animationOptions)
			/// </summary>
			hidingAnimation: null,
			/// <summary>
			/// A value that determines whether to show the trigger of wijcombobox.
			/// Default: true.
			/// Type: Boolean.
			/// Code example: $("#tags").wijcombobox("option", "showTrigger", false)
			/// </summary>
			showTrigger: true,
			/// <summary>
			/// A value that specifies the position of the drop-down list trigger.
			/// Default: "right".
			/// Type: String.
			/// Code example: $("#tags").wijcombobox("option", "triggerPosition", "left")
			/// </summary>
			triggerPosition: "right",
			/// <summary>
			/// A value that specifies the height of the drop-down list.
			/// Default: 300.
			/// Type: Number.
			/// Code example: $("#tags").wijcombobox("option", "dropdownHeight", 300)
			/// </summary>
			/// <remarks>
			/// If the total height of all items is less than the value of this option,
			/// it will use the total height of items as the height of the drop-down list.
			/// </remarks>
			dropdownHeight: 300,
			/// <summary>
			/// A value that specifies the width of the drop-down list.
			/// Default: "auto".
			/// Type: Number/String("auto").
			/// Code example: $("#tags").wijcombobox("option", "dropdownWidth", 500)
			/// </summary>
			/// <remarks>
			/// When this option is set to "auto", the width of the drop-down
			/// list is equal to the width of wijcombobox.
			/// </remarks>
			dropdownWidth: "auto",
			/// <summary>
			/// A value that determines whether to select the item 
			/// when the item gains focus or is activated.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#tags").wijcombobox("option", "selectOnItemFocus", true)
			/// </summary>
			selectOnItemFocus: false,
			/// <summary>
			/// A value determines whether to shorten the drop-down list items 
			/// by matching the text in the textbox after typing.
			/// Default: true.
			/// Type: Boolean.
			/// Code example: $("#tags").wijcombobox("option", "autoFilter", false)
			/// </summary>
			autoFilter: true,
			/// <summary>
			/// A value that determines whether to start the auto-complete 
			/// function after typing in the text if a match exists.
			/// Default: true.
			/// Type: Boolean.
			/// Code example: $("#tags").wijcombobox("option", "autoComplete", false)
			/// </summary>
			autoComplete: true,
			/// <summary>
			/// A value that determines whether to highlight the keywords in an item. 
			/// If "abc" is typed in the textbox, 
			/// all "abc" matches are highlighted in the drop-down list.
			/// Default: true.
			/// Type: Boolean.
			/// Code example: $("#tags").wijcombobox("option", "highlightMatching", false)
			/// </summary>
			highlightMatching: true,
			/// <summary>
			/// A value that specifies the position options of the drop-down list.
			/// The default value of the "of" options is the input of wijcombobox.
			/// Default: {}.
			/// Type: Object.
			/// Code example: 
			/// var positionOptions = {my:"right", at:"top"};
			/// $("#tags").wijcombobox("option", "dropDownListPosition", positionOptions)
			/// </summary>
			dropDownListPosition: {},
			/// <summary>
			/// An array that specifies the column collections of wijcombobox.
			/// Example: columns: [{name: "header1", width: 150},
			///                    {name: "header2", width: 150},
			///                    {name: "header3", width: 150}]
			/// Default: [].
			/// Type: Array.
			/// Code example: $("#tags").wijcombobox("option", "columns", [
			/// {name: 'header1', width: 150}, 
			/// {name: 'header2', width: 150}, 
			/// {name: 'header3', width: 150}
			/// ]);
			/// </summary>
			columns: [],
			/// <summary>
			/// A value that specifies the selection mode of wijcombobox.
			/// Default: "Single".
			/// Type: String.
			/// Code example: $("#tags").wijcombobox("option", 
			/// "selectionMode", "multiple")
			/// </summary>
			/// <remarks>
			/// Possible options are: "single" and "multiple".
			/// </remars>
			selectionMode: "single",
			/// <summary>
			/// A value that specifies the separator for 
			/// the multiple selected items text in the textbox.
			/// Default: ",".
			/// Type: String.
			/// Code example: $("#tags").wijcombobox("option", 
			/// "multipleSelectionSeparator", ";")
			/// </summary>
			multipleSelectionSeparator: ",",
			/// <summary>
			/// A value that determines whether to check the input text against 
			/// the text of the selected item when the focus blurs. 
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#tags").wijcombobox("option", "forceSelectionText", true)
			/// </summary>
			/// <remarks>
			/// If the text does not match any item, input text will restore 
			/// to text the selected item or empty if no item is selected.  
			/// </remarks>
			forceSelectionText: false,
			/// <summary>
			/// A function called when any item in list is selected.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a function as an option.
			///  $("#tags").wijcombobox({select: function(e, data) { } });
			/// Bind to the event by type: wijcomboboxselect
			/// $("#tags").bind("wijcomboboxselect", function(e, data) {} );
			/// </summary>
			/// <param name="e" type="EventObj">
			/// EventObj that relates to this event.
			/// </param>
			/// <param name="item" type="Object">
			/// item to be rendered.
			/// item.element: LI element with this item.
			/// item.list: wijlist instance.
			/// item.label: label of item.
			/// item.value: value of item.
			/// item.text: could be set in handler to override rendered label of item.
			/// </param>
			select: null,
			/// <summary>
			/// A value that determines whether input is editable.
			/// Default: true.
			/// Type: Boolean.
			/// Code example: $("#tags").wijcombobox("option", "isEditable", false)
			/// </summary>
			isEditable: true,
			/// <summary>
			/// A value that specifies the index of the item to select 
			/// when using single mode.
			/// If the selectionMode is "multiple", then this option could be set 
			/// to an array of Number which contains the indices of the items to select.
			/// Default: -1.
			/// Type: Number/Array.
			/// Code example: $("#tags").wijcombobox("option", "selectedIndex", 0);
			/// The following example gets the selected item:
			/// var selectedIndex = $("#tags").wijcombobox("option","selectedIndex"); 
			/// var selectedItem = $("#tags").wijcombobox("option","data")[selectedIndex];
			/// </summary>
			/// <remarks>
			/// If no item is selected, it will return -1.
			/// </remarks>
			selectedIndex: -1,
			/// <summary>
			/// A value that specifies the value of the item to select 
			/// when using single mode.
			/// Default: null.
			/// Type: Number/String/Object.
			/// Code example: $("#tags").wijcombobox("option", "selectedValue", "c++")
			/// </summary>
			/// <remarks>
			/// If no item is selected, it will return null.
			/// </remarks>
			selectedValue: null,
			/// <summary>
			/// A function called when drop-donw list is opened.
			/// Default: null.
			/// Type: Function.
			/// Supply a function as an option.
			/// Code example: $("#tags").wijcombobox("open", function(e, data) {});
			/// Bind to the event by type: wijcomboboxopen
			/// $("#tags").bind("wijcomboboxopen", function(e, data) {} );
			/// </summary>
			/// <param name="e" type="EventObj">
			/// The jquery event object.
			/// </param>
			open: null,
			/// <summary>
			/// A function called when drop-donw list is closed.
			/// Default: null.
			/// Type: Function.
			/// Supply a function as an option.
			/// Code example: $("#tags").wijcombobox("close", function(e, data) {});
			/// Bind to the event by type: wijcomboboxclose
			/// $("#tags").bind("wijcomboboxclose", function(e, data) {} );
			/// </summary>
			/// <param name="e" type="EventObj">
			/// The jquery event object.
			/// </param>
			close: null,
			/// <summary>
			/// A value added to the width of the target select element 
			/// to account for the scroll bar width of superpanel.
			/// Default: 6.
			/// Type: Number.
			/// <remarks>
			/// Unit for this value is pixel.
			/// Because the width of the scroll bar may be different between browsers 
			/// if wijcombobox is initialized with the width of the HTML select element, 
			/// the text may be hidden by the scroll bar of wijcombobox. 
			/// </remarks>
			/// Code example: $("#tags").wijcombobox("option", "selectElementWidthFix", 5)
			/// </summary>
			selectElementWidthFix: 6,
			/// <summary>
			/// A function called before searching the list.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a function as an option.
			///  $("#tags").wijcombobox({search: function(e, data) { } });
			/// Bind to the event by type: wijcomboboxsearch
			/// $("#tags").bind("wijcomboboxsearch", function(e, data) {} );
			/// </summary>
			/// <param name="e" type="EventObj">
			/// The jquery event object.
			/// </param>
			/// <param name="data" type="Object">
			/// data.datasrc: The datasource of wijcombobox.
			/// data.term: The text to search.
			/// </param>
			search: null,
			/// <summary>
			/// A function called when select item is changed.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a function as an option.
			///  $("#tags").wijcombobox({changed: function(e, data) { } });
			/// Bind to the event by type: wijcomboboxchanged
			/// $("#tags").bind("wijcomboboxchanged", function(e, data) {} );
			/// </summary>
			/// <param name="e" type="EventObj">
			/// The jquery event object.
			/// </param>
			/// <param name="data" type="Object">
			/// data.oldItem: The old item.
			/// data.newItem: The new item.
			/// data.oldIndex: The old index of selected item.
			/// data.newIndex: The new index of selected item.
			/// </param>
			changed: null,
			/// <summary>
			/// The object contains the options of wijlist.
			/// Default: null.
			/// Type: Object.
			/// Code example: 
			/// var listoptions = {addHoverItemClass: false};
			/// $("#tags").wijcombobox("option", "listOptions", listoptions)
			/// </summary>
			listOptions: null
		},

		_create: function () {
			var t = this;
			// inits selected items
			t.selectedItem = null;
			t.selectedItems = [];

			// inits wijcombobox
			t._createDOMElements();
			t._bindInputEvents();
			t._initDropDownList();
			t.repaint();
			t._checkSelectIndex();
		},

		_checkSelectIndex: function () {
			var self = this, index,
			o = self.options;
			
			if (o.selectedIndex === -1 && o.selectedValue) {
				$.each(o.data, function (i, item) {
					if (o.data[i].value === o.selectedValue) {
						self.options.selectedIndex = i;
						return false;
					}
				});
			}
			index = o.selectedIndex;
			if (!self._usingRemoteData() && (index >= 0 || $.isArray(index))) {
				self.search(null, "checkindex");
			}
		},

		repaint: function () {
			/// <summary>
			/// Repaints wijcombobox. Returns true if it succeeds; 
			/// otherwise, returns false.
			/// Code example: $("#tags").wijcombobox("repaint");
			/// </summary>
			/// <returns type="Boolean">
			/// Returns true if it succeeds; otherwise, returns false.
			/// </returns>

			var self = this;
			if (self.element.is(":visible") || self._comboDiv ||
			(self._select !== undefined && self._input.is(":visible"))) {
				self._showTrigger();
				if (self.options.disabled) {
					self.disable();
				}
				return true;
			}
			return false;
		},

		_bindInputEvents: function () {
			var self = this, input, o, code, keyCode;

			input = self._input;
			o = self.options;
			// self.element is an html input element.
			input.bind("keydown.wijcombobox", function (event) {
				if (o.disabled === true) {
					return;
				}
				code = event.keyCode;
				keyCode = $.ui.keyCode;
				switch (code) {
				case keyCode.UP:
					self._move("previous", event);
					// prevent moving cursor to beginning of 
					//text field in some browsers
					event.preventDefault();
					break;
				case keyCode.DOWN:
					self._move("next", event);
					// prevent moving cursor to end of text field in some browsers
					event.preventDefault();
					break;
				case keyCode.ENTER:
					// when menu is open or has focus
					if (self.menu.active) {
						event.preventDefault();
						self.menu.select(event);
					}
					break;
				//passthrough - ENTER and TAB both select the current element
				case keyCode.TAB:
					input.trigger("wijcomboblur");
					if (!self.menu.active ||
				(o.selectionMode === "multiple" && keyCode.TAB === code)) {
						return;
					}
					self.menu.select(event);
					// remove selection from input.
					var end = input.val().length;
					self._selectText(end, end, input);

					break;
				case keyCode.ESCAPE:
					self.close(event);
					break;
				case keyCode.LEFT:
				case keyCode.RIGHT:
				case keyCode.SHIFT:
				case keyCode.CONTROL:
				case keyCode.HOME:
				case keyCode.END:
				case keyCode.DELETE:
				case keyCode.PAGE_UP:
				case keyCode.PAGE_DOWN:
					// ignore metakeys (shift, ctrl, alt)
					break;
				case 18: //alt key
					input.trigger("wijcomboblur");
					break;
				default:
					// keypress is triggered before the input value is changed
					window.clearTimeout(self.searching);
					if (o.isEditable === false) {
						if (self._cacheKey === undefined) {
							self._cacheKey = "";
						}
						self._cacheKey += String.fromCharCode(code);
					}
					self.searching = window.setTimeout(function () {
						var term;
						if (o.isEditable === false) {
							term = self._cacheKey;
							self._cacheKey = undefined;
						}
						else {
							term = input.val();
						}
						self.search(term, event);
					}, o.delay);
					break;
				}
			}).bind("wijcomboblur.wijcombobox", function (event) {
				window.clearTimeout(self.searching);
				self._addInputFocus(false, stateFocus);
				// TODO try to implement this without a timeout, 
				// see clearTimeout in search()
				self.closing = window.setTimeout(function () {
					self.close(event, true);
				}, 150);

			}).bind("focus.wijcombobox", function () {
				self._addInputFocus(true, stateFocus);
			}).bind("blur.wijcombobox", function () {
				if (!self.menu.element.is(":visible")) {
					input.trigger("wijcomboblur");
				}
				//self.options.currentText = input.val(); 
				self._change();
			});
		},

		_addInputFocus: function (add, css) {
			var self = this, wrap, key, arrow;

			wrap = self._input.parent();
			key = add ? "addClass" : "removeClass";
			arrow = self._triggerArrow;
			wrap[key](css);
			if (arrow !== undefined) {
				arrow[key](css);
			}
		},

		_renderColumnsHeader: function (header) {
			var ul = $("<ul class='wijmo-wijcombobox-rowheader'></ul>");
			$.each(this.options.columns, function (index, column) {
				var li = $("<li class='wijmo-wijcombobox-cell ui-widget-header'></li>");
				li.html(column.name);
				if (column.width !== undefined) {
					li.width(column.width);
				}
				li.appendTo(ul);
			});
			header.append(ul);
		},

		_hasSameValueText: function (item1, item2) {
			return item1.label === item2.label && item1.value === item2.value;
		},

		_initDropDownList: function () {
			var self = this, doc, menuElement, o, header, listOptions;

			doc = self.element[0].ownerDocument;
			if (!self._comboDiv) {
				menuElement = $("<div class='wijmo-wijcombobox-list'></div>");
			} else {
				menuElement = self._oriList;
			}
			o = self.options;
			if (o.columns.length > 0) {
				menuElement.addClass("wijmo-wijcombobox-multicolumn");
				header = $("<div class='wijmo-wijsuperpanel-header " +
				"ui-state-default'></div>");
				self._renderColumnsHeader(header);
				menuElement.append(header);
			}

			listOptions = {
				keepHightlightOnMouseLeave: true,
				selectionMode: o.selectionMode,
				addHoverItemClass: o.columns.length === 0,
				focus: function (e, item) {
					var i = item;
					if (o.selectOnItemFocus) {
						self.menu.select(null, {
							notCloseAfterSelected: true
						});
					}
					if (o.columns.length > 0) {
						i.element.prev().addClass("wijmo-wijcombobox-active-prev");
						i.element.find(".wijmo-wijcombobox-row>.wijmo-wijcombobox-cell")
						.addClass("ui-state-hover");
					}
				},
				selected: function (event, ui) {
					window.clearTimeout(self.closing);
					var mode = o.selectionMode, item, newIndex, oldIndex, oldItem;

					item = ui.item;
					if (self._trigger("select", event, item)) {
						if (mode === "single") { // single mode selection
							// local data select
							if (!self._usingRemoteData()) {
								//update for fixing bug 17528 by wh at 2011/10/9
								//if(ui.selectedIndex !== undefined){
								//	newIndex = ui.selectedIndex;
								//}else
								//{
								//	newIndex = $.inArray(item, self.items);	
								//}		
								newIndex = $.inArray(item, self.items);	
								if (newIndex === undefined) {
									newIndex = ui.selectedIndex;
								}
								//end for fixing bug 17528
								if (newIndex !== o.selectedIndex) {
									self._input.val(item.label);
									oldItem = self.selectedItem;
									if (oldItem !== null) {
										oldItem.selected = false;
									}
									self.selectedItem = item;
									oldIndex = o.selectedIndex;
									o.selectedIndex = newIndex;
									//update for get selected value by wh at 2012/2/29
									o.selectedValue = self.selectedItem.value;
									//end for get selected value
									// fire select change event 
									if (self._select !== undefined) {
										self._select[0].selectedIndex = o.selectedIndex;
										self._select.trigger("change");
									}
									self._trigger("changed", null, {
										oldItem: oldItem,
										selectedItem: self.selectedItem,
										newIndex: o.selectedIndex,
										oldIndex: oldIndex
									});
								}
							}
							else {
								// If items have the same text and value, 
								// they are considered to be same in remote mode.
								if (self.selectedItem === null ||
								!self._hasSameValueText(item, self.selectedItem)) {
									self._input.val(item.label);
									self.selectedItem = item;
									self._trigger("changed", null, {
										selectedItem: item
									});
								}
							}
							
						}
						else { // multiple selection mode
							if (!self._usingRemoteData()) {
								self.selectedItems = ui.selectedItems;
								self._selectedItemsToInputVal(self.selectedItems);
								self._trigger("changed", null, {
									selectedItem: item,
									selectedItems: self.selectedItems
								});
								///TODO: show helper list
							}
						}
					}
					if ((ui.data === undefined || !ui.data.notCloseAfterSelected) &&
					mode === "single") {
						self.close(event);
						self._input.focus();
					}
				},
				blur: function (e, item) {
					var d = item.element;
					if (o.columns.length > 0) {
						d.find(".wijmo-wijcombobox-row>.wijmo-wijcombobox-cell")
						.removeClass("ui-state-hover");
						d.prev().removeClass("wijmo-wijcombobox-active-prev");
					}
				},
				itemRendering: function (event, data) {
					var item = data, css;
					css = "";
					if (item.isSeparator) {
						css += " wijmo-wijcombobox-separator";
					}
					if (item.selected) {
						css += " wijmo-wijcombobox-selecteditem";
					}
					if (css.length > 0) {
						item.element.addClass(css);
					}
					//update for js error when fixing select don't fire
					//by wuhao at 2011/10/24
					//Add condition: item.label
					if (self._keypress && o.isEditable &&
					o.columns.length === 0 && o.highlightMatching &&
					$.trim(self._input.val()).length > 0 && item.label) {
						item.text = item.label.replace(
						new RegExp("(?![^&;]+;)(?!<[^<>]*)(" +
						self._escapeRegex(self._input.val()) +
						")(?![^<>]*>)(?![^&;]+;)", "gi"),
						"<span class='ui-priority-primary'>$1</span>");
					}
					else {
						item.text = undefined;
					}
				},
				itemRendered: function (event, data) {
					var item = data, li, u;
					if (item.cells === undefined) {
						return;
					}
					li = item.element;
					li.empty();
					u = $("<ul class='wijmo-wijcombobox-row'></ul>");
					$.each(item.cells, function (index, cell) {
						var l = $("<li class='wijmo-wijcombobox-cell " +
						"ui-state-default'></li>");
						l.append(cell);
						l.attr("title", cell);
						u.append(l);
					});
					li.append(u);
				},
				superPanelOptions: {
					resized: function (e) {
						var m = self.menu, ele = m.element;
						o.dropdownWidth = ele.outerWidth();
						o.dropdownHeight = ele.outerHeight();
						self._positionList();
						self.menu.refreshSuperPanel();
					}
				}
			};
			listOptions = $.extend(true, listOptions, o.listOptions);
			self.menu = menuElement.appendTo("body", doc)
						.wijlist(listOptions)
						.zIndex(self._input.zIndex() + 1)
						.css({
					top: 0,
					left: 0
				}).hide().data("wijlist");
			self._menuUL = self.menu.ul;
		},

		_getSelectedItemsText: function (items) {
			var s = "", self, sep;

			self = this;
			sep = self.options.multipleSelectionSeparator;
			self.selectedItems = items;

			$.each(items, function (index, item) {
				s += item.label + sep;
			});
			if (s.length > 0) {
				s = s.substr(0, s.lastIndexOf(sep));
			}
			
			return s;
		},
		
		_selectedItemsToInputVal: function (items) {
			var self = this;
			
			self._input.val(self._getSelectedItemsText(items));
		},

		_createDOMElements: function () {
			var self = this, comboElement, ele, input, wrapperElement;

			wrapperElement = $("<div class='wijmo-wijcombobox-wrapper " +
			"ui-state-default ui-corner-all'>" +
			"</div>");

			// check if element is  a select element
			ele = self.element;

			// create from a select element
			if (ele.is("select")) {
				comboElement =
					$("<div role='combobox' class='wijmo-wijcombobox " +
						"ui-widget ui-helper-clearfix'>" +
					"</div>");
				comboElement.append(wrapperElement);
				self._comboElement = comboElement;
				self._select = ele;
				// add class to set font size to get the correct width of select.
				ele.addClass("ui-widget");
				input = self._input = $("<input role='textbox' " +
				"aria-autocomplete='list' aria-haspopup='true' />")
				.insertAfter(ele);
				self.options.data = self._convertSelectOptions();
			} else if (ele.is("div") && $(ele.children()[0]).is("input[type='text']") && 
					$(ele.children()[1]).is("div")) {
				//div tag
				self._comboElement = self._comboDiv = comboElement = ele;
				self._oriList = $(ele.children()[1]);
				input = self._input = $(ele.children()[0]);

				wrapperElement.prependTo(comboElement).append(input);
				ele.addClass("wijmo-wijcombobox ui-widget ui-helper-clearfix");
				ele.attr("role", "combobox");
			}
			else {
				comboElement =
					$("<div role='combobox' class='wijmo-wijcombobox " +
						"ui-widget ui-helper-clearfix'>" +
					"</div>");
				comboElement.append(wrapperElement);
				self._comboElement = comboElement;
				input = self._input = ele;
			}
			if (!self._comboDiv) {
				comboElement.insertBefore(input);
				//update for fixing bug 17328 at 2011/10/18 by wuhao
				input.width(input.width());
				//end for fixing bug 17328
				comboElement.children(".wijmo-wijcombobox-wrapper").append(input);
			}
			input.attr({
				autocomplete: "off",
				role: "textbox",
				"aria-wijcombobox": "list",
				"aria-haspopup": "true"
			}).addClass(inputCSS);
			self._oldWidth = ele.css("width");
			if (self.options.isEditable === false) {
				input.attr("readonly", "readonly");
			}
			comboElement.bind("mouseenter", function () {
				self._addInputFocus(true, stateHover);
			}).bind("mouseleave", function () {
				self._addInputFocus(false, stateHover);
			});
			
		},

		_convertSelectOptions: function () {
			var items = [], self, selectOptions;

			self = this;
			selectOptions = self._select.get(0).options;
			$.each(selectOptions, function (idx, opt) {
				items.push({ label: opt.text, value: opt.value });
			});
			self.options.selectedIndex = self._select[0].selectedIndex;
			return items;
		},

		getComboElement: function () {
			return this._comboElement;
		},

		_showTrigger: function () {
			var self = this, o, input, inputWrapper, comboElement,
			selectClone, selectWidth = 0,
			trigger, label, sp, padding, labelPadding, triggerPadding;

			o = self.options;
			input = self._input;
			inputWrapper = input.parent();
			comboElement = self._comboElement;
			trigger = self._triggerArrow;
			label = self._label;

			// set size
			if (self._select !== undefined) {
				//update for fixing bug 15920 by wuhao
				if (!$.browser.msie) {
					selectWidth = self._select.width();
				} else {
					selectClone = self._select.clone();
					self._select.after(selectClone);
					selectWidth = selectClone.width();
					selectClone.remove();
				}
				input.width(selectWidth +
				(o.data.length > 20 ? o.selectElementWidthFix : 0));
				//				input.width(self._select.width() +
				//				(o.data.length > 20 ? o.selectElementWidthFix : 0));
				//end for bug 15920.
				self._select.hide();
			}

			//update for fixing bug 15920 by wuhao
			input.css("margin-left", "");
			input.css("margin-right", "");
			//end for bug 15920.

			comboElement.width(inputWrapper[0].offsetWidth);
			//comboElement.height(inputWrapper[0].offsetHeight);

			// show label
			if (o.labelText !== null) {
				label = self._label = $(labelHTML);
				inputWrapper.append(label.html(o.labelText));
			}
			else {
				if (label !== undefined) {
					label.remove();
					self._label = undefined;
				}
			}

			if (o.showTrigger) {
				input.removeClass("ui-corner-all");
				if (trigger === undefined) {
					trigger = self._triggerArrow = $(triggerHTML);
					comboElement.append(trigger);
					trigger.bind("mouseover.triggerevent", self, function (e) {
						if (o.disabled === true) {
							return;
						}
						var ct = $(e.currentTarget);
						ct.addClass(stateHover);
					}).bind("mousedown.triggerevent", self, function (e) {
						if (o.disabled === true) {
							return;
						}
						var ct = $(e.currentTarget);
						ct.addClass(stateActive);
					}).bind("mouseup.triggerevent", self, function (e) {
						var ct = $(e.currentTarget);
						ct.removeClass(stateActive);
					}).bind("click.triggerevent", self, function () {
						if (o.disabled === true) {
							return;
						}
						self._triggerClick();
					});
				}
				if (o.triggerPosition === "right") {
					trigger.css({ left: "", right: "0px" });
					trigger.removeClass(conerLeft);
					trigger.addClass(conerRight);
				}
				else {
					trigger.css({ "right": "", "left": "0px" });
					trigger.removeClass(conerRight);
					trigger.addClass(conerLeft);
				}
				trigger.setOutHeight(comboElement.innerHeight());
				sp = trigger.find("span");
				sp.css("margin-left", (trigger.innerWidth() - sp[0].offsetWidth) / 2);
				sp.css("margin-top", (trigger.innerHeight() - sp[0].offsetHeight) / 2);
			}
			else {
				if (trigger !== undefined) {
					trigger.unbind(".triggerevent");
					trigger.remove();
					self._triggerArrow = undefined;
				}
				input.removeClass("ui-corner-left");
				input.removeClass("ui-corner-right");
				input.addClass("ui-corner-all");
			}

			// padding
			padding = labelPadding = triggerPadding = 0;
			if (label !== undefined) {
				labelPadding += label[0].offsetWidth;
			}
			if (trigger !== undefined) {
				triggerPadding = trigger[0].offsetWidth;
			}
			padding = labelPadding + triggerPadding;
			input.setOutWidth(inputWrapper.innerWidth() - padding);
			padding = padding === 0 ? "" : padding;
			if (o.triggerPosition === "right") {
				input.css("margin-left", "");
				input.css("margin-right", padding);
				if (label !== undefined) {
					label.css("left", "");
					label.css("right", triggerPadding);
				}
			}
			else {
				input.css("margin-right", "");
				input.css("margin-left", padding);

				if (label !== undefined) {
					label.css("right", "");
					label.css("left", triggerPadding);
				}
			}
		},

		_triggerClick: function (e) {
			var self = this, term = "";
			window.clearTimeout(self.closing);
			if (self.menu.element.is(":visible")) {
				self.close();
			}
			else {
				// TODO: click open should not render again.
				if (self._usingRemoteData()) {
					term = self._input.val();
				}
				self.search(term, e);
			}
		},

		destroy: function () {
			/// <summary>
			/// Removes the wijcombobox functionality completely. 
			/// This returns the element back to its pre-init state. 
			/// Code example: $("#tags").wijcombobox("destroy");
			/// </summary>

			var self = this,
			ele = self.element;
			if (self.options.isEditable === false) {
				ele.removeAttr("readonly");
			}
			if (self._select !== undefined) {
				self._select.removeClass("ui-widget");
				self._select.show();
				self._input.remove();
			}
			else if (self._comboDiv) {
				self._comboDiv
					.removeClass("wijmo-wijcombobox ui-widget ui-helper-clearfix");
				self._comboDiv.removeAttr("role");
				self._input.insertBefore(self._comboDiv);
				self._comboDiv.children(".wijmo-wijcombobox-wrapper").remove();
			}
			else {
				ele.css("width", self._oldWidth);
				ele.removeClass(inputCSS);
				ele.removeAttr("autocomplete").removeAttr("role")
				.removeAttr("aria-wijcombobox").removeAttr("aria-haspopup");
				ele.insertBefore(self._comboElement);
				ele.css("padding", "");
			}
			self._comboElement.remove();
			self.menu.destroy();
			self.menu.element.remove();
			$.Widget.prototype.destroy.call(self);
		},

		_setOption: function (key, value) {
			var self = this, ele, input, items;
			ele = self._comboElement;
			input = self.element;
			$.Widget.prototype._setOption.apply(self, arguments);
			if (key === "disabled") {
				if (value) {
					ele.addClass("wijmo-wijcombobox-disabled ui-state-disabled");
					input.attr("disabled", "disabled");
					if (self._comboDiv) {
						self._input
						.addClass("wijmo-wijcombobox-disabled ui-state-disabled")
						.attr("disabled", "disabled");
					}
					self.close();
				}
				else {
					ele.removeClass("wijmo-wijcombobox-disabled ui-state-disabled");
					input.removeAttr("disabled");
					if (self._comboDiv) {
						self._input
						.removeClass("wijmo-wijcombobox-disabled ui-state-disabled")
						.removeAttr("disabled");
					}
				}
			}
			else if (key === "isEditable") {
				if (value) {
					input.attr("readonly", "readonly");
				}
				else {
					input.removeAttr("readonly");
				}
			}
			//Add comments by RyanWu@20110119.
			//For fixing the issue that first open the dropdown list and choose one item,
			//then set the new data to the combo and click the dropdown list, 
			//an exception will be thrown.
			else if (key === "data") {
				self.selectedItem = null;
				self.options.selectedIndex = -1;
				//update for get selectedvalue option by wh at 2012/2/29
				self.options.selectedValue = null;
				//end for get selectedValue option				
				self._input.val("");
			}
			//end by RyanWu@20110119.
			else if (key === "selectedIndex") {
				if (value > -1) {
					if (self.selectedItem !== null) {
						self.selectedItem.selected = false;
					}
					items = self.items;
					if (!items) {
						items = self.options.data;
					}
					if (items && items[value] !== null) {
						self.selectedItem = items[value];
						self.selectedItem.selected = true;
						self._input.val(self.selectedItem.label);
					}
				}
			}
			else if (key === "selectedValue") {
				if (value) {
					if (self.selectedItem !== null) {
						self.selectedItem.selected = false;
					}
					items = self.items;
					if (!items) {
						items = self.options.data;
					}
					$.each(items, function (index, item) {
						if (items[index].value === value) {
							self.selectedItem = items[index];
							self.selectedItem.selected = true;
							self._input.val(self.selectedItem.label);
							return false;
						}
					});
				}
			}
		},

		search: function (value, eventObj) {
			/// <summary>
			/// Searches the wijcombobox drop-down list for the given value.
			/// Code example: $("#tags").wijcombobox("search", "C++");
			/// </summary>
			/// <param name="value" type="String">
			/// Text to search in the drop-down list
			/// </param>
			/// <param name="eventObj" type="Object">
			/// The jquery event object.
			/// </param>

			var self = this, o, datasource, d;

			o = self.options;
			datasource = o.data;
			window.clearTimeout(self.closing);
			d = {
				value: value,
				e: eventObj,
				self: self
			};

			// load data when data is not loaded yet 
			// or datasource is using a proxy to obtain data.
			if (datasource !== null || self._comboDiv) {
				// check index will skip search event
				if (eventObj !== "checkindex") {
					if (self._trigger("search", eventObj,
					{ datasrc: datasource, term: d }) === false) {
						return;
					}
				}

				if ($.isArray(datasource) || self._comboDiv) {
					self._hideShowArrow(false);
					self._onListLoaded(datasource, d);
				}
				else {
					if (self._usingRemoteData() &&
					eventObj !== undefined && value.length < o.minLength) {
						return;
					}
					self._hideShowArrow(false);
					datasource.loaded = self._onListLoaded;
					datasource.load(d);
				}
			}
		},

		_usingRemoteData: function () {
			var o = this.options.data, r = false;
			if (!$.isArray(o) && o !== null && o.proxy !== null) {
				r = true;
			}
			return r;
		},

		_hideShowArrow: function (show) {
			// hide arrow to show
			var self = this, input, arrow;

			input = self.element;
			arrow = self._triggerArrow;
			if (arrow !== undefined) {
				arrow[show ? "show" : "hide"]();
			}
			input[show ? "removeClass" : "addClass"]("wijmo-wijcombobox-loading");
		},

		_onListLoaded: function (datasource, data) {
			var self = data.self, ele, o, searchTerm, items, idx, itemsToRender;

			ele = self._input;
			o = self.options;
			searchTerm = data.value;
			if (datasource === null) {
				items = null;
			} else {
				items = $.isArray(datasource) ? datasource : datasource.items;
			}
			
			self.items = items;
			if (data.e === "checkindex") {
				idx = o.selectedIndex;

				if (o.selectionMode === "multiple" && $.isArray(idx)) {
					$.each(idx, function (i, n) {
						var itm = items[n];
						itm.selected = true;
						self.selectedItems.push(itm);
					});
					self._selectedItemsToInputVal(self.selectedItems);
				}
				else {
					items[idx].selected = true;
					self.selectedItem = items[idx];
					ele.val(self.selectedItem.label);
				}
				self._hideShowArrow(true);
				return;
			}
			// only fileter result when using local data.
			if (!self._usingRemoteData() && items) {
				self._filter(items, searchTerm);
				itemsToRender = $.grep(items, function (item1) {
					return !o.autoFilter || item1.match;
				});
			}
			else {
				self._topHit = null;
				itemsToRender = items;
			}
			if ((itemsToRender && itemsToRender.length > 0) || self._comboDiv) {
				// open dropdown list
				self._openlist(itemsToRender, data);
				// trigger dropdown open event.
				self._trigger("open");
				self._addInputFocus(true, stateFocus);
			}
			else {
				self.close(null, true);
			}
			self._hideShowArrow(true);
		},

		close: function (event, skipAnimation) {
			/// <summary>
			/// Closes drop-down list.
			/// Code example: $("#tags").wijcombobox("close", null, false);
			/// </summary>
			/// <param name="event" type="EventObj">
			/// The jquery event object.
			/// </param>
			/// <param name="skipAnimation" type="Boolean">
			/// A value indicating whehter to skip animation.
			/// </param>
			var self = this, menu, hidingAnimation, hidingStyle;
			menu = self.menu;

			self._dropDownHeight = menu.element.outerHeight();
			self._dropDownWidth = menu.element.outerWidth();

			window.clearTimeout(self.closing);
			// test parent element is need, hidingAnimation
			// because some effect will wrap the target element.
			if (menu.element.is(":visible") && !menu.element.is(":animated") &&
				!menu.element.parent().is(":animated")) {
				self._trigger("close", event);
				menu.deactivate();
				hidingAnimation = self.options.hidingAnimation;
				//add for size animation by wuhao 2011/7/16
				if (hidingAnimation && (hidingAnimation.effect === "size" ||
						hidingAnimation.animated === "size")) {
					hidingAnimation.options = $.extend({
						to: {
							width: 0,
							height: 0
						}
					}, hidingAnimation.options);
				}
				hidingStyle = menu.element.attr("style");
				//end for size animation
				if (skipAnimation !== true && hidingAnimation) {
					menu.element.hide(
				    //update for modifying animation name by wh at 2011/9/26
					//hidingAnimation.effect,
					hidingAnimation.effect || hidingAnimation.animated,
					hidingAnimation.options,
					hidingAnimation.speed || hidingAnimation.duration,
					//end for modifying name
					function () {
						//add for size animation by wuhao 2011/7/16
						menu.element.removeAttr("style")
										.attr("style", hidingStyle)
										.hide();
						//end for size animation 
						if (hidingAnimation.callback) {
							hidingAnimation.callback.apply(this, arguments);
						}
					});
				}
				else {
					menu.element.hide();
				}
				self._addInputFocus(false, stateFocus);
				$(document).unbind("click", self.closeOnClick);
			}
		},

		_change: function () {
			// TODO: finish _change event.
			var self = this, o, f, m, ele, t, itm;

			o = self.options;
			f = o.forceSelectionText;
			m = o.selectionMode;
			ele = self._input;
			t = ele.val();
			itm = self.selectedItem;

			if (f) {
				if (m === "single") {
					if (itm !== null) {
						if (itm.label !== t) {
							ele.val(itm.label);
						}
					}
					else {
						ele.val("");
					}
				}
			}
			//Todo: when input something to combobox, 
			//the text will restore in multiple mode
			//Maybe it need to be adjusted.
			if (m === "multiple") {
				self._selectedItemsToInputVal(self.selectedItems);
			}
		},

		_openlist: function (items, data) {
			var self = data.self, eventObj = data.e, keypress, textWidth, menuElement,
			o, oldPadding, verticalBorder = 2, headerHeight = 0, dropDownHeight, 
			origCloseOnClick, h, showingAnimation, showingStyle, showingSize;
			
			keypress = self._keypress = !!eventObj;
			o = self.options;
			menuElement = self.menu.element;

			//update for fixing issue 18124 at 2011/11/3 by wh
			//menuElement.zIndex(self.element.zIndex() + 1);
			menuElement.zIndex(self.element.zIndex() + 100);
			//end for 18124
			
			if (self._comboDiv) {
				//update for case 20689 at 2012/4/11
				if (!self.listHasCreated) {
					self.menu.setTemplateItems(items);	
					self.menu.renderList();
					self.listHasCreated = true;
				}
			} else {
				self.menu.setItems(items);
				self.menu.renderList();
			}
			
			// show dropdown
			self.menu.element.show();
			if (o.dropdownWidth === "auto") {
				textWidth = self._comboElement.outerWidth();
			}
			else {
				textWidth = o.dropdownWidth;
			}
			oldPadding = menuElement.css("padding");
			menuElement.css("padding", "0px");
			menuElement.setOutWidth(textWidth);
			menuElement.css("padding", oldPadding);

			dropDownHeight = o.dropdownHeight;
			if (self._select !== undefined) {
				dropDownHeight = 20 * self._menuUL
				.children(".wijmo-wijlist-item:first").outerHeight();
			}
			//For fixing bug 15778
			//h = Math.min(self._menuUL.outerHeight() + verticalBorder, dropDownHeight); 
			if (menuElement.children(".wijmo-wijsuperpanel-header")) {
				headerHeight = menuElement
					.children(".wijmo-wijsuperpanel-header").outerHeight();
			}
			//end for fixing bug 15778
			h = Math.min(self._menuUL.outerHeight() + verticalBorder + headerHeight, 
				dropDownHeight);
			menuElement.setOutHeight(h);
			self.menu.refreshSuperPanel();
			self._positionList();
			if (!keypress && self.selectedItem !== undefined) {
				self.menu.activate(null, self.selectedItem, true);
			}
			if (keypress && eventObj.keyCode !== $.ui.keyCode.BACKSPACE) {
				if (o.isEditable) {
					self._runAutoComplete();
				}
				else {
					self.menu.activate(null, self._topHit, true);
				}
			}
			else {
				showingAnimation = self.options.showingAnimation;
				if (o.showingAnimation !== null &&
				!(eventObj !== undefined &&
				eventObj.keyCode === $.ui.keyCode.BACKSPACE)) {
					self.menu.element.hide();
					//Add comments by RyanWu@20101105.
					//For fixing the issue that list items are transparent 
					//when choosing bounce effect. 

					//self.menu.element.show(
					//showingAnimation.effect, 
					//showingAnimation.options, 
					//showingAnimation.speed, 
					//showingAnimation.callback);
					//add for size animation by wuhao 2011/7/16
					showingSize = {
						from: { width: 0, height: 0 },
						to: { width: self._dropDownWidth || menuElement.outerWidth(),
							height: self._dropDownHeight || menuElement.outerHeight()
						}
					};
					if (showingAnimation && (showingAnimation.effect === "size" || 
							showingAnimation.animated === "size")) {
						showingAnimation.options = 
							$.extend(showingSize, showingAnimation.options);
					}
					showingStyle = menuElement.attr("style");
					//end for size animation
					menuElement.show(
					//update for modify animation name by wh at 2011/9/26		
					//showingAnimation.effect,
					showingAnimation.effect || showingAnimation.animated,
					//end for modifu animation name
					showingAnimation.options,
					showingAnimation.speed || showingAnimation.duration,
					function () {
						//add for size animation by wuhao 2011/7/16
						menuElement.removeAttr("style")
										.attr("style", showingStyle)
										.show();
						//end for size animation
						if (showingAnimation.callback) {
							showingAnimation.callback.apply(this, arguments);
						}

						if ($.browser.msie) {
							menuElement.css("filter", "");
						}
					});
					//end by RyanWu@20101105.
				}
			}
			if (!self.hasOwnProperty("closeOnClick")) {
				origCloseOnClick = self.closeOnClick;
				self.closeOnClick = function (e) {
					return origCloseOnClick(e);
				};
			}
			$(document).bind("click", self, self.closeOnClick);
		},

		closeOnClick: function (e) {
			var self = e.data, t = e.target;

			if (!$.contains(self._comboElement[0], t) &&
			!$.contains(self.menu.element[0], t)) {
				self.close();
				$(".wijmo-wijcombobox-wrapper", self._comboElement[0])
				.removeClass("ui-state-hover")
				.removeClass("ui-state-focus");
				$(".wijmo-wijcombobox-trigger", self._comboElement[0])
				.removeClass("ui-state-hover")
				.removeClass("ui-state-focus");
			}
		},

		_positionList: function () {
			var self = this, positionOptions, defaultPosition;
			positionOptions = self.options.dropDownListPosition;
			defaultPosition = {
				my: "left top",
				at: "left bottom",
				of: self._comboElement,
				collision: "none"
			};
			defaultPosition = $.extend(defaultPosition, positionOptions);
			self.menu.element.position(defaultPosition);
		},

		_runAutoComplete: function () {
			var self = this, ele, topHit, oldText, fullText, start, end;
			ele = self._input;
			topHit = self._topHit;
			if (!self.options.autoComplete || topHit === null) {
				return;
			}
			self.menu.activate(null, topHit, true);
			oldText = ele.val();
			fullText = topHit.label;
			ele.val(fullText);
			start = oldText.length;
			end = fullText.length;
			self._selectText(start, end, ele);
		},

		_selectText: function (start, end, input) {
			var v = input.val(), inputElement = input.get(0), range;
			if (v.length > 0) {
				if (inputElement.setSelectionRange !== undefined) {
					inputElement.setSelectionRange(start, end);
				}
				else if (inputElement.createTextRange !== undefined) {
					range = inputElement.createTextRange();
					range.moveStart("character", start);
					range.moveEnd("character", end - v.length);
					range.select();
				}
			}
		},

		_move: function (direction, event) {
			if (!this.menu.element.is(":visible")) {
				this.search("", event);
				return;
			}
			if (this.menu.first() && /^previous/.test(direction) ||
			this.menu.last() && /^next/.test(direction)) {
				//update for fixing bug 15964 by wuhao
				//this.menu.deactivate();
				//end for bug 15964.
				return;
			}
			this.menu[direction](event);
		},

		_escapeRegex: function (value) {
			if (value === undefined) {
				return value;
			}
			return value.replace(/([\^\$\(\)\[\]\{\}\*\.\+\?\|\\])/gi, "\\$1");
		},

		_filter: function (array, searchTerm) {
			var term1 = this._escapeRegex(searchTerm), matcher, topHit = null;
			/// TODO : start with or contains and case sensitive.
			if (!array) {
				return null;
			}
			matcher = new RegExp(term1, "i");
			$.each(array, function (index, item) {
				if (term1 === undefined || term1.length === 0) {
					item.match = true;
					return;
				}
				var matchResult = matcher.exec(item.label);
				if (matchResult === null) {
					item.match = false;
				}
				else {
					if (topHit === null && matchResult.index === 0) {
						topHit = item;
					}
					item.match = matchResult.index >= 0;
				}
			});
			this._topHit = topHit;
			return array;
		}
	});
} (jQuery));

/*
 *
 * Wijmo Library 1.1.2
 * http://wijmo.com/
 *
 * Copyright(c) ComponentOne, LLC.  All rights reserved.
 * 
 * Dual licensed under the Wijmo Commercial or GNU GPL Version 3 licenses.
 * licensing@wijmo.com
 * http://wijmo.com/license
 *
 *
 * * Wijmo Inputcore widget.
 *
 */
(function ($) {
    "use strict";
    window.wijinputcore = {
        options: {
            ///	<summary>
            ///		Determines the culture ID name.
            ///	</summary>
            culture: '',
            ///	<summary>
            ///		The CSS class applied to the widget when an invalid value is entered.
            ///	</summary>
            invalidClass: 'ui-state-error',
            ///	<summary>
            ///		Determines the text that will be displayed for blank status.
            ///	</summary>
            nullText: '',
            ///	<summary>
            ///		Show Null Text if the value is empty and the control loses its focus.
            ///	</summary>
            showNullText: false,
            ///	<summary>
            ///		If true, then the browser response is disabled when the ENTER key is pressed.
            ///	</summary>
            hideEnter: false,
            ///	<summary>
            ///		Determines whether the user can type a value.
            ///	</summary>
            disableUserInput: false,
            ///	<summary>
            ///		Determines the alignment of buttons.
            ///		Possible values are: 'left', 'right'
            ///	</summary>
            buttonAlign: 'right',
            ///	<summary>
            ///		Determines whether trigger button is displayed.
            ///	</summary>
            showTrigger: false,
            ///	<summary>
            ///		Determines whether spinner button is displayed.
            ///	</summary>
            showSpinner: false,
            ///	<summary>
            ///		Array of data items for the drop-down list.
            ///	</summary>
            comboItems: undefined,
            ///	<summary>
            ///		Determines the width of the drop-down list.
            ///	</summary>
            comboWidth: undefined,
            ///	<summary>
            ///		Determines the height of the drop-down list.
            ///	</summary>
            comboHeight: undefined,
            /// <summary>
            /// The initializing event handler. A function called before the widget is initialized.
            /// Default: null.
            /// Type: Function.
            /// Code example: $("#element").wijinputmask({ initializing: function () { } });
            /// </summary>
            initializing: null,
            /// <summary>
            /// The initialized event handler. A function called after the widget is initialized.
            /// Default: null.
            /// Type: Function.
            /// Code example: $("#element").wijinputmask({ initialized: function (e) { } });
            /// </summary>
            ///
            /// <param name="e" type="Object">jQuery.Event object.</param>
            initialized: null,
            /// <summary>
            /// The triggerMouseDown event handler. A function called when the mouse is pressed down on the trigger button.
            /// Default: null.
            /// Type: Function.
            /// Code example: $("#element").wijinputmask({ triggerMouseDown: function (e) { } });
            /// </summary>
            ///
            /// <param name="e" type="Object">jQuery.Event object.</param>
            triggerMouseDown: null,
            /// <summary>
            /// The triggerMouseUp event handler. A function called when the mouse is released on the trigger button.
            /// Default: null.
            /// Type: Function.
            /// Code example: $("#element").wijinputmask({ triggerMouseUp: function (e) { } });
            /// </summary>
            ////// <param name="e" type="Object">jQuery.Event object.</param>
            triggerMouseUp: null,
            /// <summary>
            /// The textChanged event handler. A function called when the text of the input is changed.
            /// Default: null.
            /// Type: Function.
            /// Code example: $("#element").wijinputmask({ textChanged: function (e, arg) { } });
            /// </summary>
            ///
            /// <param name="e" type="Object">jQuery.Event object.</param>
            /// <param name="args" type="Object">
            /// The data with this event.
            /// args.text: The new text.
            ///</param>
            textChanged: null,
            /// <summary>
            /// The invalidInput event handler. A function called when invalid charactor is typed.
            /// Default: null.
            /// Type: Function.
            /// Code example: $("#element").wijinputmask({ invalidInput: function (e, data) { } });
            /// </summary>
            ///
            /// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="data" type="Object">
			/// The data that contains the related information.
			/// data.char: The newly input character.
			/// data.widget: The widget object itself.
			/// </param>
            invalidInput: null
        },

        _create: function () {
            if (this.element[0].tagName.toLowerCase() !== 'input') {
                throw "Target element is not a INPUT";
            }
			
			this.element.data("widgetName", this.widgetName);

            $.effects.save(this.element, ['width', 'height']);
            var width = this.element.width();
            this.element.wrap("<div class='wijmo-wijinput ui-widget ui-helper-clearfix ui-state-default ui-corner-all'><span class='wijmo-wijinput-wrapper'></span></div>");
            this.element.addClass('wijmo-wijinput-input ui-corner-all').attr({ 'role': 'textbox', 'aria-multiline': false });
            this.wrapper = this.element.parent();
            this.outerDiv = this.wrapper.parent();
            this.outerDiv.width(width);

            if (this.options.showTrigger) {
                this.triggerBtn = $("<div class='wijmo-wijinput-trigger ui-state-default'><span class='ui-icon ui-icon-triangle-1-s'></span></div>")
					.addClass(this.options.buttonAlign === 'left' ? 'ui-corner-left' : 'ui-corner-right')
					.attr('role', 'button')
					.appendTo(this.outerDiv);
                this.element.attr({ 'role': 'combobox', 'aria-expanded': false });
            }

            if (this.options.showSpinner) {
                this.spinner = $("<div class='wijmo-wijinput-spinner wijmo-wijinput-button'></div>");
                this.spinUp = $("<div class='ui-state-default wijmo-wijinput-spinup'><span class='ui-icon ui-icon-triangle-1-n'></span></div>").attr('role', 'button');
                this.spinDown = $("<div class='ui-state-default wijmo-wijinput-spindown'><span class='ui-icon ui-icon-triangle-1-s'></span></div>").attr('role', 'button');
                if (!this.options.showTrigger) {
                    this.spinUp.addClass(this.options.buttonAlign === 'left' ? 'ui-corner-tl' : 'ui-corner-tr');
                    this.spinDown.addClass(this.options.buttonAlign === 'left' ? 'ui-corner-bl' : 'ui-corner-br');
                }
                this.spinner.append(this.spinUp)
					.append(this.spinDown)
					.appendTo(this.outerDiv);
                this.element.attr('role', 'spinner');
            }

            if (this.options.showTrigger && this.options.showSpinner) {
                this.outerDiv.addClass(this.options.buttonAlign === 'left' ? 'ui-input-spinner-trigger-left' : 'ui-input-spinner-trigger-right');
            } else {
                if (this.options.showTrigger) {
                    this.outerDiv.addClass(this.options.buttonAlign === 'left' ? 'ui-input-trigger-left' : 'ui-input-trigger-right');
                }

                if (this.options.showSpinner) {
                    this.outerDiv.addClass(this.options.buttonAlign === 'left' ? 'ui-input-spinner-left' : 'ui-input-spinner-right');
                }
            }

            this.element.setOutWidth(this.outerDiv.width());
            this._initialize();
        },

        _createTextProvider: function () {
            return undefined;
        },

        _beginUpdate: function () {
        },

        _endUpdate: function () {
        },

        _onTriggerClicked: function () {
        },

        _initialize: function () {
            this.element.data('initializing', true);
            this._trigger('initializing');

            this.element.data('preText', this.element.val());
            this.element.data('elementValue', this.element.val());
            this.element.data('errorstate', false);
            this.element.data('breakSpinner', true);
            this.element.data('prevCursorPos', -1);
            this.element.data('simulating', false);

            this._createTextProvider();
            this._beginUpdate();

            var isLeftButton = function (e) { return (!e.which ? e.button : e.which) === 1; };
            var o = this.options, self = this;
            if (this.triggerBtn && !o.disabled) {
                this.triggerBtn.bind({
                    'mouseover': function () { self._addState('hover', $(this)); },
                    'mouseout': function () { self._removeState('hover', $(this)); },
                    'mousedown': function (e) {
                        if (!isLeftButton(e)) { return; }
                        self._addState('active', $(this));
                        self._trigger('triggerMouseDown');
                    },
                    'click': function (e) {
                        self._stopEvent(e);
                        self._stopSpin();
                        self._removeState('active', $(this));
                        self._trigger('triggerMouseUp');
                        self._onTriggerClicked();
                        self._trySetFocus();
                    }
                });
            }

            var spinButtonDown = function (e) {
                if (!isLeftButton(e)) { return; }
                self._trySetFocus();
                self.element.data('breakSpinner', false);
                self._addState('active', $(this));
                self._doSpin($(e.currentTarget).hasClass('wijmo-wijinput-spinup'), true);
            };

            var spinButtonUp = function (e) {
                if (!isLeftButton(e)) { return; }
                self._stopSpin();
                self._removeState('active', $(this));
            };

            if (this.spinUp && !o.disabled) {
                this.spinUp.bind({
                    'mouseover': function () { self._addState('hover', $(this)); },
                    'mouseout': function () { self._removeState('hover', $(this)); self._removeState('active', $(this)); self._stopSpin(); },
                    'mousedown': spinButtonDown,
                    'mouseup': spinButtonUp
                });
            }

            if (this.spinDown && !o.disabled) {
                this.spinDown.bind({
                    'mouseover': function () { self._addState('hover', $(this)); },
                    'mouseout': function () { self._removeState('hover', $(this)); self._removeState('active', $(this)); self._stopSpin(); },
                    'mousedown': spinButtonDown,
                    'mouseup': spinButtonUp
                });
            }

            this.element.bind({
                'focus.wijinput': $.proxy(this._onFocus, this),
                'blur.wijinput': $.proxy(this._onBlur, this),
                'mouseup.wijinput': $.proxy(this._onMouseUp, this),
                'keypress.wijinput': $.proxy(this._onKeyPress, this),
                'keydown.wijinput': $.proxy(this._onKeyDown, this),
                'keyup.wijinput': $.proxy(this._onKeyUp, this),
                'change.wijinput': $.proxy(this._onChange, this),
                'paste.wijinput': $.proxy(this._onPaste, this),
                'drop.wijinput': $.proxy(this._onDrop, this)
            });

            this.element.bind('propertychange.wijinput input.wijinput', $.proxy(this._onInput, this));
            this.element.data('initializing', false);

            this._resetData();
            this._endUpdate();
            this._updateText();

            if (this.options.disabled) {
                this.disable();
            }

			this.element.data('initialized', true);
            this._trigger('initialized');
        },

        _init: function () {
        },

        _setOption: function (key, value) {
            $.Widget.prototype._setOption.apply(this, arguments);

            switch (key) {
                case 'buttonAlign':
                case 'showTrigger':
                case 'showSpinner':
                    this._destroy();
                    this._create();
                    break;

                case 'showNullText':
                    this._updateText();
                    break;

                case 'disabled':
                    this.element.attr('disabled', value);
                    this.element[value ? 'addClass' : 'removeClass'](this.namespace + "-state-disabled");
                    if (this.triggerBtn !== undefined) {
                        this.triggerBtn[value ? 'addClass' : 'removeClass'](this.namespace + "-state-disabled");
                    }

                    if (this.spinup !== undefined) {
                        this.spinup[value ? 'addClass' : 'removeClass'](this.namespace + "-state-disabled");
                    }

                    if (this.spindown !== undefined) {
                        this.spindown[value ? 'addClass' : 'removeClass'](this.namespace + "-state-disabled");
                    }
                    break;
            }
        },

        destroy: function () {
            $.Widget.prototype.destroy.apply(this, arguments);
            this._destroy();
        },

        _destroy: function () {
            this.wrapper = undefined;
            this.outerDiv = undefined;
            this.element.unbind('.wijinput');

            this.element.removeData('errorstate')
				.removeData('breakSpinner')
				.removeData('prevCursorPos')
				.removeData('simulating')
				.removeData('isPassword')
				.removeClass('wijmo-wijinput-input')
				.removeAttr('role')
				.removeAttr('aria-valuemin')
				.removeAttr('aria-valuemax')
				.removeAttr('aria-valuenow')
				.removeAttr('aria-expanded');

            this.element.parent().replaceWith(this.element);
            this.element.parent().replaceWith(this.element);
            $.effects.restore(this.element, ['width', 'height']);
        },

        widget: function () {
            /// <summary>Gets element this widget is associated.</summary>
            return this.outerDiv;
        },

        _getCulture: function (name) {
            return Globalize.findClosestCulture(name || this.options.culture);
        },

        _addState: function (state, el) {
            if (el.is(':not(.ui-state-disabled)')) {
                el.addClass('ui-state-' + state);
            }
        },

        _removeState: function (state, el) {
            el.removeClass('ui-state-' + state);
        },

        _isInitialized: function () {
            return !this.element.data('initializing');
        },

        _setData: function (val) {
            this.setText(val);
        },

        _resetData: function () {
        },

        _validateData: function () {
        },

        getText: function () {
            /// <summary>Gets the text displayed in the input box.</summary>
            if (!this._isInitialized()) { return this.element.val(); }
            return this._textProvider.toString(true, false, false);
        },

        setText: function (value) {
            /// <summary>Sets the text displayed in the input box.</summary>
            if (!this._isInitialized()) {
                this.element.val(value);
            } else {
                this._textProvider.set(value);
                this._updateText();
            }
        },
		
		getPostValue: function(){
			/// <summary>Gets the text value when the container form is posted back to server.</summary>
			if (!this._isInitialized()) { return this.element.val(); }
            return this._textProvider.toString(true, false, true);
		},

        selectText: function (start, end) {
            /// <summary>Selects a range of text.</summary>
            /// <param name="start" type="Number">Start of the range.</param>
            /// <param name="end" type="Number">End of the range.</param>
            if (this.element.is(':disabled')) { return; }
            this.element.wijtextselection(start, end);
        },

        focus: function () {
            /// <summary>Set the focus to this input.</summary>
            if (this.element.is(':disabled')) { return; }
            this.element.get(0).focus();
        },

        isFocused: function () {
            /// <summary>Determines whether the input has input focus.</summary>
            return this.outerDiv.hasClass("ui-state-focus");
        },

        _raiseTextChanged: function () {
            var txt = this.element.val(), preText = this.element.data('preText');
            if (!!this.element.data('initialized') && preText !== txt ) {
                this._trigger('textChanged', null, { text: txt });
				this.element.data('changed', true);
            }
			
			this.element.data('preText', txt);
        },

        _raiseDataChanged: function () {
        },

        _allowEdit: function () {
            return !(this.element.attr('readOnly') && this.element.is(':disabled'));
        },

        _updateText: function (keepSelection) {
            if (!this._isInitialized()) { return; }

            // default is false
            keepSelection = !!keepSelection;
            var range = this.element.wijtextselection();
            this.element.val(this._textProvider.toString());
            this.options.text = this._textProvider.toString(true, false, false);
            if (this.element.is(':disabled')) { return; }

            if (keepSelection) {
                this.selectText(range.start, range.end);
            }
            this.element.data('prevCursorPos', range.start);

            this._raiseTextChanged();
            this._raiseDataChanged();
        },

        _trySetFocus: function () {
            if (!this.isFocused()) {
                try {
                    if (!this.options.disableUserInput) {
                        this.element.focus();
                    }
                }
                catch (e) {
                }
            }
        },

        _deleteSelText: function (backSpace) {
            if (!this._allowEdit()) { return; }
            var selRange = this.element.wijtextselection();

            backSpace = !!backSpace;
            if (backSpace) {
                if (selRange.end === selRange.start) {
                    if (selRange.end >= 1) {
                        selRange.end = (selRange.end - 1);
                        selRange.start = (selRange.start - 1);
                    } else {
                        return;
                    }
                } else {
                    selRange.end = (selRange.end - 1);
                }
            } else {
                selRange.end = (selRange.end - 1);
            }
            if (selRange.end < selRange.start) {
                selRange.end = (selRange.start);
            }
            var rh = new wijInputResult();
            this._textProvider.removeAt(selRange.start, selRange.end, rh);
            this._updateText();
            this.selectText(rh.testPosition, rh.testPosition);
        },

        _fireIvalidInputEvent: function (chr) {
            if (this._trigger('invalidInput', null, { widget: this, char: chr } ) === true) { return; };
            if (!this.element.data('errorstate')) {
                var cls = this.options.invalidClass || 'ui-state-error';
                this.element.data('errorstate', true);
                var self = this;
                window.setTimeout(function () {
                    self.outerDiv.removeClass(cls);
                    self.element.data('errorstate', false);
                }, 100);
                this.outerDiv.addClass(cls);
            }
        },

        _onInput: function (e) {
            if (!this._isSimulating() || !this.element.data('ime')) { return; }
            this._simulate();
        },

        _keyDownPreview: function (e) {
            return false; // true means handled.
        },

        _beforeSimulate: function (ime) {
            if (!this.element.data('lastSelection')) {
                this.element.data('lastSelection', this.element.wijtextselection());
                this.element.data('lastValue', this.element.val());
            }

            this.element.data('ime', ime);
            this.element.data('simulating', true);
        },

        _isSimulating: function () {
            return this.element.data('simulating');
        },

        _simulate: function (text) {
            var self = this,
				str = null;
				
			if (typeof text === "string"){
				str = text;
			} else {
                var range = this.element.wijtextselection();
                var start = this.element.data('lastSelection').start;
                var end = range.end;

                if (end >= start) {
                    str = this.element.val().substring(start, end);
                }
            }

            if (str) {
                window.setTimeout(function () {
                    if (!self.element.data('lastValue')) { return; }
                    self.element.val(self.element.data('lastValue'));
                    var lastSel = self.element.data('lastSelection');
                    self.element.wijtextselection(lastSel);
                    self.element.data('batchKeyPress', true);
                    self.element.data('simulating', false);
					var e = jQuery.Event('keypress')
					e.ctrlKey = e.altKey = false;
                    for (var i = 0; i < str.length; i++) {
                        e.which = e.charCode = e.keyCode = str.charCodeAt(i);
                        self._onKeyPress(e);
                    }
                    self.element.data('batchKeyPress', false);
                    self._endSimulate();
                }, 1);
            }
        },

        _endSimulate: function () {
            this.element.removeData('ime');
            this.element.removeData('lastSelection');
            this.element.removeData('lastValue');
        },

        _onKeyDown: function (e) {
            this.element.data('prevCursorPos', -1);

            if (!this._isInitialized()) { return; }

            var k = this._getKeyCode(e);
            if (k === 229) { // Double Bytes
                this._beforeSimulate(true);
                return;
            }
            this._endSimulate();

            if (this.options.disableUserInput) {
                this._stopEvent(e);
                return;
            }

            if (this._keyDownPreview(e)) {
                this._stopEvent(e);
                return;
            }

            switch (k) {
                case $.ui.keyCode.UP:
                    this._doSpin(true, false);
                    this._stopEvent(e);
                    return;
                case $.ui.keyCode.DOWN:
                    this._doSpin(false, false);
                    this._stopEvent(e);
                    return;
            }

            if (e.ctrlKey) {
                switch (k) {
                    case $.ui.keyCode.INSERT:
                    case 67: // 'c'
                        return;
                    default:
                        break;
                }
            }
            if ((e.ctrlKey || e.altKey)) { return; }

            switch (k) {
                case 112: // F1-F6
                case 113:
                case 114:
                case 115:
                case 116:
                case 117:
                case $.ui.keyCode.TAB:
                case $.ui.keyCode.CAPSLOCK:
                case $.ui.keyCode.END:
                case $.ui.keyCode.HOME:
                case $.ui.keyCode.CTRL:
                case $.ui.keyCode.SHIFT:
                    return;
                case $.ui.keyCode.BACKSPACE:
                    this._deleteSelText(true);
                    this._stopEvent(e);
                    return;
                case $.ui.keyCode.DELETE:
                    this._deleteSelText(false);
                    this._stopEvent(e);
                    return;
                case $.ui.keyCode.ENTER:
                    if (!this.options.hideEnter) { return; }
                    break;
                case $.ui.keyCode.ESCAPE:
                    this._stopEvent(e);
                    window.setTimeout($.proxy(this._resetData, this), 1);
                    return;
                case $.ui.keyCode.PAGE_UP:
                case $.ui.keyCode.PAGE_DOWN:
                case $.ui.keyCode.ALT:
                    this._stopEvent(e);
                    return;
            }
        },

        _onKeyUp: function (e) {
            if (this._isSimulating()) { return; }
            var k = this._getKeyCode(e);

            if (!this._isInitialized()) { return; }
            if (k === $.ui.keyCode.ENTER) { return; }
            if (k === $.ui.keyCode.ESCAPE) { return; }

            if (this.options.disableUserInput) {
                this._raiseTextChanged();
                this._raiseDataChanged();
                return;
            }

            this._stopEvent(e);
        },

        _getKeyCode: function (e) {
            var userAgent = window.navigator.userAgent;
            if ((userAgent.indexOf('iPod') !== -1 || userAgent.indexOf('iPhone') !== -1) && e.which === 127) {
                return 8;
            }
            return e.keyCode || e.which;
        },

        _keyPressPreview: function (e) {
            return false;
        },

        _onKeyPress: function (e) {
            if (this._isSimulating()) { return; }
            this.element.data('prevCursorPos', -1);

            if (this.options.disableUserInput) { return; }
            if (!this._allowEdit()) { return; }

            if (e.ctrlKey && e.keyCode == 119) {  //Ctrl + F8
                this._onPaste(e);
                return;
            }

            if (e.which === 0) { return; }

            var key = e.keyCode || e.which;
            if (key === $.ui.keyCode.BACKSPACE) {
                this._stopEvent(e);
                return;
            }

            if (e.ctrlKey || e.altKey) {
                if (key !== $.ui.keyCode.SPACE) {
                    return;
                }
            }
			
            if (this._keyPressPreview(e)) {
                return;
            }

            if (key === $.ui.keyCode.ENTER && !this.options.hideEnter) { return true; }

            var selRange = this.element.wijtextselection();
            var ch = String.fromCharCode(key);
            if (selRange.start < selRange.end) {
                this._textProvider.removeAt(selRange.start, selRange.end - 1, new wijInputResult());
            }
            var rh = new wijInputResult();
            var opResult = this._textProvider.insertAt(ch, selRange.start, rh);
            if (opResult) {
                this._updateText();
                this.selectText(rh.testPosition + 1, rh.testPosition + 1);
            }
            else {
                this._fireIvalidInputEvent(ch);
            }
            if (!this.element.data('batchKeyPress')) {
                this._stopEvent(e);
            }
        },

        _isNullText: function (val) {
			val = val || this.element.val();
            return this.options.showNullText && val === this.options.nullText;
        },

        _doFocus: function () {
            var selRange = this.element.wijtextselection();
            var sta = selRange.start;
            this._updateText();
            var s = this.element.val();
            if (s.length === sta) { sta = 0; }
            if (!$.browser.safari) {
                this.selectText(sta, sta);
            }
        },

        _afterFocused: function () {
            if (this._isNullText()) {
                this._doFocus();
            }
        },

        _onFocus: function (e) {
            if (this.options.disableUserInput) { return; }
            this._addState('focus', this.outerDiv);

            if (!this.element.data('breakSpinner')) {
                return;
            }

            if (!this._isInitialized()) { return; }
            if (!this._allowEdit()) { return; }

            if (!this.element.data('focusNotCalledFirstTime')) { this.element.data('focusNotCalledFirstTime', new Date().getTime()); }
            this._afterFocused();
        },

        _onBlur: function (e) {
            if (this.options.disableUserInput) { return; }
            if (this._isComboListVisible()) { return; }

            var focused = this.isFocused();
            this._removeState('focus', this.outerDiv);

            if (!this.element.data('breakSpinner')) {
                this.element.get(0).focus();
                var curPos = this.element.data('prevCursorPos');
                if (curPos !== undefined && curPos !== -1) {
                    this.selectText(curPos, curPos);
                }
                return;
            }
            if (!this._isInitialized()) { return; }
            if (!focused) { return; }

            this.element.data('value', this.element.val());
            var self = this;
            window.setTimeout(function () {
                self._onChange();
                self._updateText();
                self._validateData();

				if (!self._popupVisible() && !!self.element.data('changed')){
					self._trigger('change');
				}
				
				self.element.data('changed', false);
            }, 100);
			
			
        },
		
		_popupVisible: function(){
			return this._isComboListVisible();
		},

        _onMouseUp: function (e) {
            if (!this._isInitialized()) { return; }
            if (this.element.is(':disabled')) { return; }

            var selRange = this.element.wijtextselection();
            this.element.data('prevCursorPos', selRange.start);
        },

        _onChange: function (e) {
            if (!this.element) { return; }
            var val = this.element.val();
            var txt = this.getText();
            if (txt !== val) {
                this.setText(val);
            }
        },

        _onPaste: function (e) {
            this._beforeSimulate();
            var self = this;
            window.setTimeout(function () {
                self._simulate();
            }, 1);
        },

        _onDrop: function (e) {
            this._beforeSimulate();
			if (e.originalEvent && e.originalEvent.dataTransfer){
				var text = e.originalEvent.dataTransfer.getData('Text');
				if (text){
					this._simulate(text);
				}
			}
        },

        _stopEvent: function (e) {
            e.stopPropagation();
            e.preventDefault();
        },

        _calcSpinInterval: function () {
            this._repeatingCount++;
            if (this._repeatingCount > 10) {
                return 50;
            }
            else if (this._repeatingCount > 4) {
                return 100;
            }
            else if (this._repeatingCount > 2) {
                return 200;
            }
            return 400;
        },

        _doSpin: function () {
        },

        _stopSpin: function _stopSpin() {
            this.element.data('breakSpinner', true);
            this._repeatingCount = 0;
        },

        _hasComboItems: function () {
            return (!!this.options.comboItems && this.options.comboItems.length);
        },

        _isComboListVisible: function () {
            if (!this._comboDiv) { return false; }
            return this._comboDiv.wijpopup('isVisible');
        },

        _popupComboList: function () {
            if (!this._hasComboItems()) { return; }
            if (!this._allowEdit()) { return; }

            if (this._isComboListVisible()) {
                this._comboDiv.wijpopup('hide');
                return;
            }

            var self = this;
            if (this._comboDiv === undefined) {
                this._comboDiv = $("<div></div>")
				.appendTo(document.body)
				.width(this.element.width())
				.height(this.options.comboHeight || 180)
				.css('position', 'absolute');

                var content = this._normalize(this.options.comboItems);
                this._comboDiv.wijlist({
                    autoSize: true,
                    maxItemsCount: 5,
                    selected: function (event, ui) {
                        self._setData(ui.item.value);
                        self._comboDiv.wijpopup('hide');
                        self._trySetFocus();
                    }
                });

                this._comboDiv.wijlist('setItems', content);
                this._comboDiv.wijlist('renderList');
                this._comboDiv.wijlist("refreshSuperPanel");
            }

            this._comboDiv.wijpopup({
                autoHide: true
            });

            this.outerDiv.attr('aria-expanded', true);
            this._comboDiv.wijpopup('show', {
                of: this.outerDiv,
                offset: '0 4',
                hidden: function () { self.outerDiv.attr('aria-expanded', false); }
            });
        },

        _normalize: function (items) {
            // assume all items have the right format when the first item is complete
            if (items.length && items[0].label && items[0].value) {
                return items;
            }
            return $.map(items, function (item) {
                if (typeof item === "string") {
                    return {
                        label: item,
                        value: item
                    };
                }
                return $.extend({
                    label: item.label || item.value,
                    value: item.value || item.label
                }, item);
            });
        }
    };

    window.wijInputResult = function () {
        this.alphanumericCharacterExpected = -2;
        this.asciiCharacterExpected = -1;
        this.digitExpected = -3;
        this.invalidInput = -51;
        this.letterExpected = -4;
        this.nonEditPosition = -54;
        this.positionOutOfRange = -55;
        this.promptCharNotAllowed = -52;
        this.signedDigitExpected = -5;
        this.unavailableEditPosition = -53;
        this.testPosition = -1;
    };

    window.wijInputResult.prototype = {
        characterEscaped: 1,
        noEffect: 2,
        sideEffect: 3,
        success: 4,
        unknown: 0,
        hint: 0,

        clone: function () {
            var rh = new wijInputResult();
            rh.hint = this.hint;
            rh.testPosition = this.testPosition;
            return rh;
        }
    };

})(jQuery);

/*
 *
 * Wijmo Library 1.1.2
 * http://wijmo.com/
 *
 * Copyright(c) ComponentOne, LLC.  All rights reserved.
 * 
 * Dual licensed under the Wijmo Commercial or GNU GPL Version 3 licenses.
 * licensing@wijmo.com
 * http://wijmo.com/license
 *
 *
 * * Wijmo Inputdate widget.
 *
 * Depends:
 *	jquery-1.4.2.js
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 *	jquery.ui.position.js
 *	jquery.effects.core.js	
 *	jquery.effects.blind.js
 *	globalize.js
 *	jquery.plugin.wijtextselection.js
 *	jquery.mousewheel.js
 *	jquery.wijmo.wijpopup.js
 *	jquery.wijmo.wijcalendar.js
 *	jquery.wijmo.wijinputcore.js
 *
 */

(function ($) {
    "use strict";
    var wijdigits = {
        useDefault: -2,
        asIs: -1,
        zero: 0,
        one: 1,
        two: 2,
        three: 3,
        four: 4,
        five: 5,
        six: 6,
        seven: 7,
        eight: 8
    };

    $.widget("wijmo.wijinputdate", $.extend(true, {}, wijinputcore, {
        options: {
            ///	<summary>
            ///		Determines the default date value for a date input.
            ///	</summary>
            date: null,
            ///	<summary>
            ///		Determines the minimal date that can be entered.
            ///	</summary>
            minDate: null,
            ///	<summary>
            ///		Determines the maximum date that can be entered.
            ///	</summary>
            maxDate: null,
            ///	<summary>
            ///		The format pattern to display the date value
            ///		wijinputdate supports two types of formats: Standard Format and Custom Format.
            ///
            ///		A standard date and time format string uses a single format specifier to 
            ///		define the text representation of a date and time value. 
            ///
            ///		Possible values for Standard Format are:
            ///		"d": ShortDatePattern
            ///		"D": LongDatePattern
            ///     "f": Full date and time (long date and short time)
            ///     "F": FullDateTimePattern
            ///	    "g": General (short date and short time)
            ///     "G": General (short date and long time)
            ///     "m": MonthDayPattern
            ///     "M": monthDayPattern
            ///     "r": RFC1123Pattern
            ///     "R": RFC1123Pattern
            ///     "s": SortableDateTimePattern
            ///     "t": shortTimePattern
            ///     "T": LongTimePattern
            ///     "u": UniversalSortableDateTimePattern
            ///     "U": Full date and time (long date and long time) using universal time
            ///     "y": YearMonthPattern
            ///     "Y": yearMonthPattern
            ///
            ///		Any date and time format string that contains more than one character, including white space, 
            ///		is interpreted as a custom date and time format string. For example: 
            ///		"mmm-dd-yyyy", "mmmm d, yyyy", "mm/dd/yyyy", "d-mmm-yyyy", "ddd, mmmm dd, yyyy" etc.
            ///
            ///		Below are the custom date and time format specifiers:
            ///
            ///		"d": The day of the month, from 1 through 31. 
            ///		"dd": The day of the month, from 01 through 31.
            ///		"ddd": The abbreviated name of the day of the week.
            ///		"dddd": The full name of the day of the week.
            ///		"m": The minute, from 0 through 59.
            ///		"mm": The minute, from 00 through 59.
            ///		"M": The month, from 1 through 12.
            ///		"MM": The month, from 01 through 12.
            ///		"MMM": The abbreviated name of the month.
            ///		"MMMM": The full name of the month.
            ///		"y": The year, from 0 to 99.
            ///		"yy": The year, from 00 to 99
            ///		"yyy": The year, with a minimum of three digits.
            ///		"yyyy": The year as a four-digit number
            ///		"h": The hour, using a 12-hour clock from 1 to 12.
            ///		"hh": The hour, using a 12-hour clock from 01 to 12.
            ///		"H": The hour, using a 24-hour clock from 0 to 23.
            ///		"HH": The hour, using a 24-hour clock from 00 to 23.
            ///		"s": The second, from 0 through 59.
            ///		"ss": The second, from 00 through 59.
            ///		"t": The first character of the AM/PM designator.
            ///		"tt": The AM/PM designator.
            ///	</summary>
            dateFormat: 'd',
            ///	<summary>
            ///		Determines the value of the starting year to be used for the smart input year calculation.
            ///	</summary>
            startYear: 1950,
            ///	<summary>
            ///		Allows smart input behavior.
            ///	</summary>
            smartInputMode: true,
            ///	<summary>
            ///		Determines the active field index.
            ///	</summary>
            activeField: 0,
            ///	<summary>
            ///		Determines the time span, in milliseconds, between two input intentions.
            ///	</summary>
            keyDelay: 800,
            ///	<summary>
            ///		Determines whether to automatically moves to the next field.
            ///	</summary>
            autoNextField: true,
            ///	<summary>
            ///		Determines the calendar element for a date input.
            ///		Set to 'default' to use default calendar.
            ///	</summary>
            calendar: 'default',
            ///	<summary>
            ///		Detemines the popup position of a calendar. See jQuery.ui.position for position options.
            ///	</summary>
            popupPosition: {
                offset: '0 4'
            },
            /// <summary>
            /// The dateChanged event handler. A function called when the date of the input is changed.
            /// Default: null.
            /// Type: Function.
            /// Code example: $("#element").wijinputdate({ dateChanged: function (e, arg) { } });
            /// </summary>
            ///
            /// <param name="e" type="Object">jQuery.Event object.</param>
            /// <param name="args" type="Object">
            /// The data with this event.
            /// args.date: The new date.
            ///</param>
            dateChanged: null
        },

        _createTextProvider: function () {
            this._textProvider = new wijDateTextProvider(this, this.options.dateFormat);
        },

        _strToDate: function (str) {
            return this._textProvider.parseDate(str);
        },

        _beginUpdate: function () {
            var o = this.options,
				strDate,
				date = null;

            if (o.minDate) {
                if (typeof o.minDate === 'string') {
                    o.minDate = this._strToDate(o.minDate);
                }
            }

            if (o.maxDate) {
                if (typeof o.maxDate === 'string') {
                    o.maxDate = this._strToDate(o.maxDate);
                }
            }

            if (!o.date) {
                if (!!this.element.data('elementValue')) {
                    strDate = this.element.data('elementValue');
                }
            } else {
                if (typeof o.date === 'string') {
                    strDate = o.date;
                } else {
                    date = o.date;
                }
            }

            if (strDate) {
                date = this._strToDate(strDate);
            }

            this._safeSetDate(date);

            this.element.data({
                defaultDate: date === null ? date : new Date(o.date.getTime()),
                preDate: date === null ? date : new Date(o.date.getTime())
            });
            this._resetTimeStamp();
            if (o.showTrigger && !this._hasComboItems()) {
                this._initCalendar();
            }
            this.element.addClass('wijmo-wijinput-date')
				.attr({
				    'aria-valuemin': new Date(1900, 1, 1),
				    'aria-valuemax': new Date(2099, 1, 1),
				    'aria-valuenow': o.date
				});
        },

        _endUpdate: function () {
            var self = this;
            this.element.click(function () {
                self._highLightCursor();
            });

            this.element.mousewheel(function (e, delta) {
                self._doSpin(delta > 0, false);
            });
        },

        _onTriggerClicked: function () {
            if (this._hasComboItems()) {
                this._popupComboList();
            } else {
                this._popupOrHideCalendar();
            }
        },

        _isValidDate: function (date, chkBounds) {
            var o = this.options;
            if (date === undefined) { return false; }
            if (isNaN(date)) { return false; }
            if (date.getFullYear() < 1 || date.getFullYear() > 9999) { return false; }

            if (chkBounds) {
                if (o.minDate) {
                    if (date < o.minDate) { return false; }
                }

                if (o.maxDate) {
                    if (date > o.maxDate) { return false; }
                }
            }

            return true;
        },
		
		_checkRange: function(date){
			var o = this.options;
			if (!!date){
				if (o.minDate && date < o.minDate) {
					date = new Date(Math.max(o.minDate, date));
				}

				if (o.maxDate && date > o.maxDate) {
					date = new Date(Math.min(o.maxDate, date));
				}
			}
			
			return date;
		},

        _safeSetDate: function (date) {
            var o = this.options, cache = date;

			date = this._checkRange(date);
			if (isNaN(date)) {
				date = cache;
			}

            o.date = date;
            return true;
        },
		
		_safeGetDate: function(){
			var o = this.options, date = o.date;
			if (!date){
				date = new Date();
			}
			
			date = this._checkRange(date);
			return date;
		},

        _setOption: function (key, value) {
            $.Widget.prototype._setOption.apply(this, arguments);
            wijinputcore._setOption.apply(this, arguments);

            switch (key) {
                case 'date':
                    if (!!value) {
                        if (typeof value === "string") {
                            value = this._strToDate(value);
                        } else if (typeof value === "object") {
                            value = new Date(value.getTime());
                        } else {
                            value = new Date(value);
                        }

                        if (isNaN(value)) {
                            value = new Date();
                        }
                    }
                    this._safeSetDate(value);
                    this._updateText();
                    this._highLightField();

                    break;

                case 'dateFormat':
                case 'culture':
                    this._textProvider._setFormat(this.options.dateFormat);
                    this._updateText();
                    break;

                case 'activeField':
                    value = Math.min(value, this._textProvider.getFieldCount() - 1);
                    value = Math.max(value, 0);
                    this.options.activeField = value;
                    this._highLightField();
                    this._resetTimeStamp();
                    break;
            }
        },

        _setData: function (val) {
            this.option('date', val);
        },

        _resetData: function () {
            var o = this.options;

            var d = this.element.data('defaultDate');
            if (d === undefined || d === null) {
                d = this.element.data('elementValue');
                if (d !== undefined && d !== null && d !== "") {
					this.setText(val);
                } else {
                    this._setData(null);
                }
            } else {
                this._setData(d);
            }
        },

        _resetTimeStamp: function () {
            this.element.data('cursorPos', 0);
            this.element.data('timeStamp', new Date('1900/1/1'));
        },

        getPostValue: function () {
            /// <summary>Gets the text value when the container form is posted back to server.</summary>
            if (!this._isInitialized()) { return this.element.val(); }
            if (this.options.showNullText && this.isDateNull()) { return ""; }

            var val = this._textProvider.toString();
            if (val === this.options.nullText) { return ""; }

            return val;
        },

        _highLightField: function (index) {
            if (index === undefined) { index = this.options.activeField; }
            if (this.isFocused()) {
                var range = this._textProvider.getFieldRange(index);
                if (range) {
                    this.element.wijtextselection(range);
                }
            }
        },

        _highLightCursor: function (pos) {
            if (this._isNullText()) {
                return;
            }

            if (pos === undefined) {
                pos = Math.max(0, this.element.wijtextselection().start);
            }

            var index = this._textProvider.getCursorField(pos);
            if (index < 0) { return; }
            this._setOption('activeField', index);
        },

        _toNextField: function () {
            this._setOption('activeField', this.options.activeField + 1);
        },

        _toPrevField: function () {
            this._setOption('activeField', this.options.activeField - 1);
        },

        _toFirstField: function () {
            this._setOption('activeField', 0);
        },

        _toLastField: function () {
            this._setOption('activeField', this._textProvider.getFieldCount());
        },

        _clearField: function (index) {
            if (index === undefined) { index = this.options.activeField; }
            var range = this._textProvider.getFieldRange(index);
            if (range) {
                var rh = new wijInputResult();
                this._textProvider.removeAt(range.start, range.end, rh);
                this._updateText();
                var self = this;
                window.setTimeout(function () {
                    self._highLightField();
                }, 1);
            }
        },

        _doSpin: function (up, repeating) {
            up = !!up;
            repeating = !!repeating;

            if (!this._allowEdit()) { return; }
            if (repeating && this.element.data('breakSpinner')) { return; }

            if (this._textProvider[up ? 'incEnumPart' : 'decEnumPart']()) {
                this._updateText();
                this._highLightField();
            }

            if (repeating && !this.element.data('breakSpinner')) {
                window.setTimeout($.proxy(function () { this._doSpin(up, true); }, this), this._calcSpinInterval());
            }
        },
		
		_onChange: function (e) {
		},

        _afterFocused: function () {
            if (this._isNullText()) {
                this._doFocus();
            }

            var self = this,
				hc = function () {
				    self._highLightCursor();
				    self._resetTimeStamp();
				};

            window.setTimeout(hc, 10);
        },

        _keyDownPreview: function (e) {
            var key = e.keyCode || e.which;
            switch (key) {
                case $.ui.keyCode.LEFT:
                    this._toPrevField();
                    return true;
                    break;

                case $.ui.keyCode.RIGHT:
                    this._toNextField();
                    return true;
                    break;

                case $.ui.keyCode.TAB:
                case $.ui.keyCode.SPACE:
                case 188: // ,
                case 190: // .
                case 110: // . on pad
                case 191: // /
                    if (e.shiftKey) {
                        if (this.options.activeField > 0) {
                            this._toPrevField();
                            return true;
                        }
                    } else {
                        if (this.options.activeField < this._textProvider.getFieldCount() - 1) {
                            this._toNextField();
                            return true;
                        }
                    }
                    break;

                case $.ui.keyCode.HOME:
                    if (e.ctrlKey) {
                        this._setOption('date', new Date());
                    } else {
                        this._toFirstField();
                    }
                    return true;
                    break;

                case $.ui.keyCode.END:
                    if (e.ctrlKey) {
                        this._setOption('date', new Date('1970/1/1'));
                    } else {
                        this._toLastField();
                    }
                    return true;
                    break;

                case $.ui.keyCode.DELETE:
                    if (this._allowEdit()) {
                        var selRange = this.element.wijtextselection();
                        if (selRange.end - selRange.start === this.element.val().length) {
                            this._setOption('date', new Date('1970/1/1'));
                        } else {
                            this._clearField();
                        }
                        return true;
                    }
                    break;
            }

            return false;
        },

        _autoMoveToNextField: function (pos, ch) {
            if (!this.options.autoNextField) { return; }

            if (this._textProvider.needToMove(this.options.activeField, pos, ch)) {
                this._toNextField();
            }
        },

        _keyPressPreview: function (e) {
            var key = e.keyCode || e.which;
			if (key === $.ui.keyCode.ENTER) {
				if (this.isDateNull()){
					this.options.date = new Date();
				}
				return false;
			}
		
            var range = this._textProvider.getFieldRange(this.options.activeField);
            if (range) {
                if (key === $.ui.keyCode.TAB) {
                    return true;
                }

                if (key === $.ui.keyCode.SPACE) {
                    this._stopEvent(e);
                    return true;
                }

                var ch = String.fromCharCode(key);
                var fieldSep = this._textProvider.isFieldSep(ch, this.options.activeField);
                if (fieldSep) {
                    this._toNextField();
                    this._stopEvent(e);
                    return true;
                }

                var cursor = this.element.data('cursorPos');
                var now = new Date(), lastTime = this.element.data('timeStamp');
                this.element.data('timeStamp', now);
                var newAction = (now.getTime() - lastTime.getTime()) > this.options.keyDelay;
                if (newAction) {
                    cursor = 0;
                }

                var pos = range.start + cursor;
                this.element.data('cursorPos', ++cursor);

                var ret = this._textProvider.addToField(ch, this.options.activeField, pos, !newAction);
                if (ret) {
                    this._updateText();
                    this._autoMoveToNextField(cursor, ch);
                    this._highLightField();
                } else {
                    this._fireIvalidInputEvent();
                }

                this._stopEvent(e);
                return true;
            }

            return false;
        },

        _raiseDataChanged: function () {
            var d = this.options.date;
            var prevDt = this.element.data('preDate');
            this.element.data('preDate', !d ? null : new Date(d.getTime()));
			
            if ((!prevDt && d) || (prevDt && !d) || (prevDt && d && (prevDt.getTime() !== d.getTime()))) {
                this._syncCalendar();
                this.element.attr('aria-valuenow', d);
                this._trigger('dateChanged', null, { date: d });
            }
        },

        isDateNull: function () {
            /// <summary>Determines whether the date is a null value.</summary>
			return this.options.date === null || this.options.date === undefined;
        },

        _isMinDate: function (date) {
            return date.getFullYear() === 1 && date.getMonth() === 0 && date.getDate() === 1;
        },

        _initCalendar: function () {
            var c = this.options.calendar;
            if (c === undefined || c === null) { return; }
            if (typeof (c) === 'boolean' || c === 'default') {
                c = $("<div/>");
                c.appendTo(document.body);
            }

            var calendar = $(c);
            if (calendar.length != 1) { return; }

            this.element.data('calendar', calendar);
            calendar.wijcalendar({ popupMode: true, culture: this.options.culture });
            this._syncCalendar();

            var self = this;
            calendar.bind('wijcalendarselecteddateschanged', function () {
                var selDate = $(this).wijcalendar("getSelectedDate");
                $(this).wijcalendar("close");
                if (!!selDate) { self.option('date', selDate); }
                self._trySetFocus();
            });
        },

        _syncCalendar: function () {
            var calendar = this.element.data('calendar');
            if (!calendar) { return; }

            var o = this.options,
				d = this._safeGetDate();
            if (this._isMinDate(d)) { d = new Date(); }

            calendar.wijcalendar('option', 'displayDate', d);

            if (o.minDate) {
                calendar.wijcalendar('option', 'minDate', o.minDate);
            }

            if (o.maxDate) {
                calendar.wijcalendar('option', 'maxDate', o.maxDate);
            }

            calendar.wijcalendar('unSelectAll');
            calendar.wijcalendar('selectDate', d);
            calendar.wijcalendar('refresh');
        },

        _popupOrHideCalendar: function () {
            if (!this._allowEdit()) { return; }

            var calendar = this.element.data('calendar');
            if (!calendar) { return; }

            if (calendar.wijcalendar('isPopupShowing')) {
                calendar.wijcalendar('hide');
				this._trySetFocus();
                return;
            }

            this._syncCalendar();
            calendar.wijcalendar('popup', $.extend({}, this.options.popupPosition, { of: this.outerDiv }));
        },

        _isCalendarVisible: function () {
            if (!this._allowEdit()) { return false; }

            var calendar = this.element.data('calendar');
            if (!calendar) { return false; }

            return calendar.wijcalendar('isPopupShowing');
        },

        _popupVisible: function () {
            if (this._hasComboItems()) {
                return this._isComboListVisible();
            } else {
                return this._isCalendarVisible();
            }

            return false;
        }
    }));


    //============================

    var wijDateTextProvider = function (w, f) {
        this.inputWidget = w;
        this.descriptors = new Array(0);
        this.desPostions = new Array(0);
        this.fields = new Array(0);
        this._setFormat(f);
    };

    wijDateTextProvider.prototype = {
        descriptors: undefined,
        desPostions: undefined,
        maskPartsCount: 0,
        pattern: 'M/d/yyyy',

        initialize: function () { },

        getFieldCount: function () {
            return this.fields.length;
        },

        getFieldRange: function (index) {
            var desc = this.fields[index];
            return { start: desc.startIndex, end: desc.startIndex + desc.getText().length };
        },

        getCursorField: function (pos) {
            pos = Math.min(pos, this.desPostions.length - 1);
            pos = Math.max(pos, 0);
            var desc = this.desPostions[pos].desc;
            if (desc.type === -1) {
                var i = $.inArray(desc, this.descriptors);
                if (i > 0 && this.descriptors[i - 1].type != -1) {
                    desc = this.descriptors[i - 1];
                } else {
                    return -1; // liternal
                }
            }
            return $.inArray(desc, this.fields);
        },

        needToMove: function (index, pos, ch) {
            if (!this.inputWidget._isValidDate(this.inputWidget._safeGetDate(), true)) { return false; }

            var desc = this.fields[index];
            if (pos === desc.maxLen) { return true; }

            var val = ch * 1;
            if (isNaN(val)) { return false; }

            switch (desc.type) {
                case 20:
                case 25:
                case 45:
                case 46:
                    return val > 1;
                    break;

                case 47:
                case 48:
                    return val > 2;
                    break;

                case 30:
                case 31:
                    return val > 3;
                    break;

                case 50:
                case 51:
                case 60:
                case 61:
                    return val > 6;
                    break;
            }

            return false;
        },

        _getCulture: function () {
            return this.inputWidget._getCulture();
        },

        _isDigitString: function (s) {
            s = $.trim(s);
            if (s.length === 0) { return true; }

            var c = s.charAt(0);
            if (c === '+' || c === '-') {
                s = s.substr(1);
                s = $.trim(s);
            }
            if (s.length === 0) { return true; }
            try {
                var f = parseFloat(s);
                var t = f.toString();
                return t === s;
            }
            catch (e) {
                return false;
            }
        },

        _setFormat: function (f) {
            this.descriptors = [];
            var curPattern = '';
            var prevCh = '';
            var isBegin = false;
            var liternalNext = false;
            this.pattern = this._parseFormatToPattern(f);
            for (var i = 0; i < this.pattern.length; i++) {
                var ch = this.pattern.charAt(i);
                if (liternalNext) {
                    this.descriptors.push(this.createDescriptor(-1, ch));
                    curPattern = '';
                    liternalNext = false;
                    continue;
                }
                if (ch === '\\') {
                    liternalNext = true;
                    if (curPattern.length > 0) {
                        if (!this.handlePattern(curPattern)) {
                            this.descriptors.push(this.createDescriptor(-1, prevCh));
                        }
                        curPattern = '';
                    }
                    continue;
                }
                if (ch === '\'') {
                    if (isBegin) {
                        isBegin = false;
                        curPattern = '';
                    } else {
                        isBegin = true;
                        if (curPattern.length > 0) {
                            if (!this.handlePattern(curPattern)) {
                                this.descriptors.push(this.createDescriptor(-1, prevCh));
                            }
                            curPattern = '';
                        }

                    }
                    continue;
                }
                if (isBegin) {
                    this.descriptors.push(this.createDescriptor(-1, ch));
                    curPattern = '';
                    continue;
                }
                if (!i) {
                    prevCh = ch;
                }
                if (prevCh !== ch && curPattern.length > 0) {
                    if (!this.handlePattern(curPattern)) {
                        this.descriptors.push(this.createDescriptor(-1, prevCh));
                    }
                    curPattern = '';
                }
                curPattern += ch;
                prevCh = ch;
            }
            if (curPattern.length > 0) {
                if (!this.handlePattern(curPattern)) {
                    this.descriptors.push(this.createDescriptor(-1, prevCh));
                }
            }

            this.fields = $.grep(this.descriptors, function (d) {
                return d.type !== -1;
            });
        },

        _parseFormatToPattern: function (f) {
            var cf = this.inputWidget._getCulture().calendars.standard;
            var pattern = cf.patterns.d;
            if (f.length <= 1) {
                switch (f) {
                    case "":
                    case "d": // ShortDatePattern
                        pattern = cf.patterns.d;
                        break;
                    case "D": // LongDatePattern
                        pattern = cf.patterns.D;
                        break;
                    case "f": // Full date and time (long date and short time)
                        pattern = cf.patterns.D + " " + cf.patterns.t;
                        break;
                    case "F": // Full date and time (long date and long time)
                        pattern = cf.patterns.D + " " + cf.patterns.T;
                        break;
                    case "g": // General (short date and short time)
                        pattern = cf.patterns.d + " " + cf.patterns.t;
                        break;
                    case "G": // General (short date and long time)
                        pattern = cf.patterns.d + " " + cf.patterns.T;
                        break;
                    case "m": // MonthDayPattern
                        pattern = cf.patterns.M;
                        break;
                    case "M": // monthDayPattern
                        pattern = cf.patterns.M;
                        break;
                    case "s": // SortableDateTimePattern
                        pattern = cf.patterns.S;
                        break;
                    case "t": // shortTimePattern
                        pattern = cf.patterns.t;
                        break;
                    case "T": // LongTimePattern
                        pattern = cf.patterns.T;
                        break;
                    case "u": // UniversalSortableDateTimePattern
                        pattern = cf.patterns.S;
                        break;
                    case "U": // Full date and time (long date and long time) using universal time
                        pattern = cf.patterns.D + " " + cf.patterns.T;
                        break;
                    case "y": // YearMonthPattern
                        pattern = cf.patterns.Y;
                        break;
                    case "Y": // yearMonthPattern
                        pattern = cf.patterns.Y;
                        break;
                }
            } else {
                pattern = f;
            }

            return pattern;
        },

        getDate: function () {
            return (!!this.inputWidget) ? new Date(this.inputWidget._safeGetDate().getTime()) : undefined;
        },

        setDate: function (value) {
            if (this.inputWidget) {
                this.inputWidget._setData(value);
            }
        },

        _internalSetDate: function (date) {
            if (this.inputWidget) {
                var self = this,
					o = this.inputWidget.options,
					inputElement = this.inputWidget.element,
					typing = !!inputElement.data('typing');

                if (typing) {
                    o.date = date;

                    var chkBounds = function () {
                        var now = new Date(), lastTime = inputElement.data('timeStamp');
                        if ((now.getTime() - lastTime.getTime()) > o.keyDelay) {
                            self.inputWidget._safeSetDate(o.date);
                            self.inputWidget._updateText();
                            self.inputWidget._highLightField();
                        } else {
                            window.setTimeout(chkBounds, o.keyDelay);
                        }
                    }

                    window.setTimeout(chkBounds, o.keyDelay);
                } else {
                    this.inputWidget._safeSetDate(date);
                }
            }
        },

        daysInMonth: function (m, y) {
            m = m - 1;
            var d = new Date(y, ++m, 1, -1).getDate();
            return d;
        },

        setYear: function (val, resultObj, chkBounds) {
            try {
                if (resultObj && resultObj.isfullreset) {
                    resultObj.offset = 1;
                    val = '1970';
                }
                if (typeof val === 'string') {
                    if (!this._isDigitString(val)) {
                        return false;
                    }
                }
                val = val * 1;

                var o = this.inputWidget.options,
					minYear = 1,
					maxYear = 9999;

                if (chkBounds) {
                    if (o.minDate) {
                        minYear = Math.max(minYear, o.minDate.getFullYear());
                    }

                    if (o.maxDate) {
                        maxYear = Math.min(maxYear, o.maxDate.getFullYear());
                    }
                }

                if (resultObj && resultObj.isreset) {
                    val = minYear;
                }

                if (val < minYear) {
                    val = minYear;
                }

                if (val > maxYear) {
                    val = maxYear;
                }

                var currentDate = this.getDate();
                var testDate = new Date(currentDate.getTime());
                testDate.setFullYear(val);
                if (this._isValidDate(testDate)) {
                    var mmm = this.daysInMonth(this.getMonth(), this.getYear());
                    if (mmm === currentDate.getDate()) {
                        testDate = new Date(currentDate.getTime());
                        testDate.setDate(1);
                        testDate.setFullYear(val);
                        mmm = this.daysInMonth((testDate.getMonth() + 1), testDate.getFullYear());
                        testDate.setDate(mmm);
                        if (this._isValidDate(testDate)) {
                            this._internalSetDate(testDate);
                            return true;
                        } else {
                            return false;
                        }
                    }
                    currentDate.setFullYear(val);
                    this._internalSetDate(currentDate);
                    return true;
                }
                else {
                    if (resultObj && resultObj.isreset) {
                        currentDate.setFullYear(1);
                        this._internalSetDate(currentDate);
                        return true;
                    }
                    return false;
                }
            }
            catch (e) {
                return false;
            }
        },

        getYear: function () {
            try {
                var year = this.getDate().getFullYear();
                year = '' + year + '';
                while (year.length < 4) {
                    year = '0' + year;
                }
                return '' + year + '';
            }
            catch (e) {
                alert('getYear() failed');
            }
            return '';
        },

        setMonth: function (val, allowChangeOtherParts, resultObj) {
            try {
                if (resultObj && resultObj.isfullreset) {
                    val = '1';
                }
                val = val * 1;
                var currentDate = this.getDate();
                if (typeof (allowChangeOtherParts) !== 'undefined' && !allowChangeOtherParts) {
                    if (val > 12 || val < 1) {
                        if (resultObj && resultObj.isreset) {
                            val = 1;
                        } else {
                            return false;
                        }
                    }
                }
                var mmm = this.daysInMonth(this.getMonth(), this.getYear()), testDate;
                if (mmm === this.getDate().getDate()) {
                    testDate = new Date(currentDate.getTime());
                    testDate.setDate(1);
                    testDate.setMonth(val - 1);
                    mmm = this.daysInMonth((testDate.getMonth() + 1), testDate.getFullYear());
                    testDate.setDate(mmm);
                    if (this._isValidDate(testDate)) {
                        this._internalSetDate(testDate);
                        return true;
                    } else {
                        return false;
                    }
                }
                else {
                    testDate = new Date(currentDate.getTime());
                    testDate.setMonth(val - 1);
                    if (this._isValidDate(testDate)) {
                        this._internalSetDate(testDate);
                        return true;
                    } else {
                        return false;
                    }
                }
            }
            catch (e) {
                return false;
            }
        },

        getMonth: function () {
            return (this.getDate().getMonth() + 1);
        },

        setDayOfMonth: function (val, allowChangeOtherParts, resultObj) {
            try {
                if (resultObj && resultObj.isfullreset) {
                    return this.setDayOfMonth(1, allowChangeOtherParts);
                }
                var currentDate = this.getDate();
                val = val * 1;
                if (typeof (allowChangeOtherParts) !== 'undefined' && !allowChangeOtherParts) {
                    var mmm = this.daysInMonth(this.getMonth(), this.getYear());
                    if (val > mmm || val < 1) {
                        if (resultObj && resultObj.isreset) {
                            return this.setDayOfMonth(1, allowChangeOtherParts, resultObj);
                        }
                        return false;
                    }
                }
                var testDate = new Date(currentDate.getTime());
                testDate.setDate(val);
                if (this._isValidDate(testDate)) {
                    this._internalSetDate(testDate);
                    return true;
                } else {
                    return false;
                }
            }
            catch (e) {
                return false;
            }
        },

        getDayOfMonth: function () {
            return this.getDate().getDate();
        },

        setHours: function (val, allowChangeOtherParts) {
            try {
                val = val * 1;
                if (typeof (allowChangeOtherParts) !== 'undefined' && !allowChangeOtherParts) {
                    if (val > 24) {
                        return false;
                    }
                }
                var testDate = new Date(this.getDate().getTime());
                testDate.setHours(val);
                if (this._isValidDate(testDate)) {
                    this._internalSetDate(testDate);
                    return true;
                } else {
                    return false;
                }
            }
            catch (e) {
                return false;
            }
        },

        getHours: function () {
            return this.getDate().getHours();
        },

        setMinutes: function (val, allowChangeOtherParts) {
            try {
                val = val * 1;
                if (typeof (allowChangeOtherParts) !== 'undefined' && !allowChangeOtherParts) {
                    if (val > 60) {
                        return false;
                    }
                }
                var testDate = new Date(this.getDate().getTime());
                testDate.setMinutes(val);
                if (this._isValidDate(testDate)) {
                    this._internalSetDate(testDate);
                    return true;
                } else {
                    return false;
                }
            }
            catch (e) {
                return false;
            }
        },

        getMinutes: function () {
            return this.getDate().getMinutes();
        },

        setSeconds: function (val, allowChangeOtherParts) {
            try {
                val = val * 1;
                if (typeof (allowChangeOtherParts) !== 'undefined' && !allowChangeOtherParts) {
                    if (val > 60) {
                        return false;
                    }
                }
                var testDate = new Date(this.getDate().getTime());
                testDate.setSeconds(val);
                if (this._isValidDate(testDate)) {
                    this._internalSetDate(testDate);
                    return true;
                } else {
                    return false;
                }
            }
            catch (e) {
                return false;
            }
        },

        getSeconds: function () {
            return this.getDate().getSeconds();
        },

        setDayOfWeek: function (val) {
            try {
                val = val * 1;
                var aDif = val - this.getDayOfWeek() * 1;
                return this.setDayOfMonth(this.getDayOfMonth() * 1 + aDif * 1, true);
            }
            catch (e) {
                return false;
            }
        },

        getDayOfWeek: function () {
            return (this.getDate().getDay() + 1);
        },

        handlePattern: function (p) {
            var reg = new RegExp('y{3,4}');
            var suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(10));
                return true;
            }
            reg = new RegExp('y{2,2}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(2));
                return true;
            }
            reg = new RegExp('y{1,1}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(1));
                return true;
            }
            reg = new RegExp('d{4,4}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(101));
                return true;
            }
            reg = new RegExp('d{3,3}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(100));
                return true;
            }
            reg = new RegExp('d{2,2}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(30));
                return true;
            }
            reg = new RegExp('d{1,1}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(31));
                return true;
            }
            reg = new RegExp('M{4,4}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(27));
                return true;
            }
            reg = new RegExp('M{3,3}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(26));
                return true;
            }
            reg = new RegExp('M{2,2}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(20));
                return true;
            }
            reg = new RegExp('M{1,1}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(25));
                return true;
            }
            reg = new RegExp('h{2,2}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(46));
                return true;
            }
            reg = new RegExp('h{1,1}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(45));
                return true;
            }
            reg = new RegExp('H{2,2}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(48));
                return true;
            }
            reg = new RegExp('H{1,1}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(47));
                return true;
            }
            reg = new RegExp('m{2,2}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(50));
                return true;
            }
            reg = new RegExp('m{1,1}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(51));
                return true;
            }
            reg = new RegExp('s{2,2}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(60));
                return true;
            }
            reg = new RegExp('s{1,1}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(61));
                return true;
            }
            reg = new RegExp('t{2,2}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(251));
                return true;
            }
            reg = new RegExp('t{1,1}');
            suc = reg.test(p);
            if (suc) {
                this.descriptors.push(this.createDescriptor(250));
                return true;
            }
            return false;
        },

        createDescriptor: function (t, liternal) {
            var desc = null;
            var id = this.maskPartsCount++;
            switch (t) {
                case -1:
                    desc = new _dateDescriptor(this, id);
                    desc.liternal = liternal;
                    break;
                case 20:
                    desc = new _dateDescriptor20(this, id);
                    break;
                case 25:
                    desc = new _dateDescriptor25(this, id);
                    break;
                case 26:
                    desc = new _dateDescriptor26(this, id);
                    break;
                case 27:
                    desc = new _dateDescriptor27(this, id);
                    break;
                case 30:
                    desc = new _dateDescriptor30(this, id);
                    break;
                case 31:
                    desc = new _dateDescriptor31(this, id);
                    break;
                case 100:
                    desc = new _dateDescriptor100(this, id);
                    break;
                case 101:
                    desc = new _dateDescriptor101(this, id);
                    break;
                case 10:
                    desc = new _dateDescriptor10(this, id);
                    break;
                case 1:
                    desc = new _dateDescriptor1(this, id);
                    break;
                case 2:
                    desc = new _dateDescriptor2(this, id);
                    break;
                case 45:
                    desc = new _dateDescriptor45(this, id);
                    break;
                case 46:
                    desc = new _dateDescriptor46(this, id);
                    break;
                case 47:
                    desc = new _dateDescriptor47(this, id);
                    break;
                case 48:
                    desc = new _dateDescriptor48(this, id);
                    break;
                case 250:
                    desc = new _dateDescriptor250(this, id);
                    break;
                case 251:
                    desc = new _dateDescriptor251(this, id);
                    break;
                case 50:
                    desc = new _dateDescriptor50(this, id);
                    break;
                case 51:
                    desc = new _dateDescriptor51(this, id);
                    break;
                case 60:
                    desc = new _dateDescriptor60(this, id);
                    break;
                case 61:
                    desc = new _dateDescriptor61(this, id);
                    break;
                default:
                    break;
            }
            return desc;
        },

        toString: function () {
            if (this.inputWidget.options.showNullText && !this.inputWidget.isFocused() && this.inputWidget.isDateNull()) {
                return this.inputWidget.options.nullText;
            }

            var s = '', l = 0;
            this.desPostions = new Array(0);
            for (var i = 0; i < this.descriptors.length; i++) {
                this.descriptors[i].startIndex = s.length;
                var txt = '' || this.descriptors[i].getText();
                s += txt;
                for (var j = 0; j < txt.length; j++) {
                    var dp = {};
                    dp.desc = this.descriptors[i];
                    dp.pos = j;
                    dp.text = txt;
                    dp.length = txt.length;
                    this.desPostions.push(dp);
                    l++;
                    if (this.desPostions.length !== l) {
                        throw 'Fatal Error !!!!!!!!!!!!!!!';
                    }
                }
            }
            return s;
        },

        parseDate: function (str) {
            var date;
            if (this.pattern === 'dddd' ||
				this.pattern === 'ddd' ||
				typeof str == 'object') {
                try {
                    date = new Date(str);
                    if (isNaN(date)) {
                        date = new Date();
                    }
                }
                catch (e) {
                    date = new Date();
                }
            } else {
                date = Globalize.parseDate(str, this.pattern, this._getCulture());
                if (!date) {
                    date = this._tryParseDate(str, this.pattern);
                }
                if (!date) {
                    date = new Date();
                }
            }
            return date;
        },

        set: function (input, rh) {
            this._internalSetDate(new Date(this.parseDate(input)));
            return true;
        },

        haveEnumParts: function () {
            return false;
        },

        removeLiterals: function (s) {
            s = '' + s + '';
            s = s.replace(new RegExp('\\s', 'g'), '');
            s = s.replace(new RegExp('[+]', 'g'), '');
            s = s.replace(new RegExp('[.]', 'g'), '');
            s = s.replace(new RegExp('[:]', 'g'), '');
            s = s.replace(new RegExp('[-]', 'g'), '');
            s = s.replace(new RegExp('[()=]', 'g'), '');
            return s;
        },

        getFirstDelimiterPos: function (aText, bText) {
            var i = 0;
            var j = 0;
            while (i < bText.length && j < aText.length) {
                var ch1 = bText.charAt(i);
                var ch2 = aText.charAt(j);
                if (ch1 === ch2) {
                    j++;
                }
                else {
                    return j - 1;
                }
                i++;
            }
            return aText.length - 1;
        },

        findAlikeArrayItemIndex: function (arr, txt) {
            var index = -1;
            var pos = 99999;
            for (var i = 0; i < arr.length; i++) {
                var k = arr[i].toLowerCase().indexOf(txt.toLowerCase());
                if (k !== -1 && k < pos) {
                    pos = k;
                    index = i;
                }
            }
            return index;
        },

        _isValidDate: function (dt) {
            return this.inputWidget._isValidDate(dt);
        },

        isFieldSep: function (input, activeField) {
            var nextField = activeField++;
            if (nextField < this.descriptors.length) {
                var desc = this.descriptors[nextField];
                if (desc.type != -1) { return false; }
                return (input === desc.text);
            }

            return false;
        },

        getPositionType: function (pos) {
            var desPos = this.desPostions[pos];
            return desPos.desc.type;
        },

        addToField: function (input, activeField, pos, append) {
            var desc = this.fields[activeField];
            if (desc.type == 10) {
                return this.insertAt(input, pos);
            }

            var txt = append ? desc.getText() + input : input;
            var resultObj = { val: input, pos: 0, offset: 0, isreset: false };
            this.inputWidget.element.data('typing', true);
            var ret = desc.setText(txt, ((input.length === 1) ? false : true), resultObj);
            this.inputWidget.element.data('typing', false);
            return ret;
        },

        insertAt: function (input, position, rh) {
            if (!rh) { rh = new wijInputResult(); }

            rh.testPosition = -1;
            var desPos;
            if (input.length === 1) {
                desPos = this.desPostions[position];
                if (desPos && desPos.desc.type === -1) {
                    if (desPos.text === input) {
                        rh.testPosition = position;
                        rh.hint = rh.characterEscaped;
                        return true;
                    }
                }
            }

            var oldTxt = input, pos = position;
            input = this.removeLiterals(input);
            var txt = input;
            var tryToExpandAtRight = false, tryToExpandAtLeft = false;
            if (pos > 0 && txt.length === 1) {
                pos--;
                position = pos;
                desPos = this.desPostions[pos];
                tryToExpandAtRight = true;
                if (desPos && (desPos.desc.type === -1 || desPos.desc.getText().length !== 1)) {
                    position++;
                    pos++;
                    tryToExpandAtRight = false;
                }
            }
            var result = false, curInsertTxt, resultObj;
            while (txt.length > 0 && pos < this.desPostions.length) {
                desPos = this.desPostions[pos];
                if (desPos.desc.type === -1) {
                    pos = pos + desPos.length;
                    continue;
                }
                if (desPos.desc.needAdjustInsertPos()) {
                    curInsertTxt = txt.substr(0, (desPos.length - desPos.pos));
                    curInsertTxt = desPos.text.slice(0, desPos.pos) + curInsertTxt + desPos.text.slice(desPos.pos + curInsertTxt.length, desPos.length);
                    if (tryToExpandAtRight) {
                        curInsertTxt = desPos.text + curInsertTxt;
                    }
                    if (tryToExpandAtLeft) {
                        curInsertTxt = curInsertTxt + desPos.text;
                    }
                    var prevTextLength = desPos.desc.getText().length;
                    var altInsertText = '';
                    try {
                        if (input.length === 1) {
                            if (!desPos.pos) {
                                altInsertText = input;
                            } else if (desPos.pos > 0) {
                                altInsertText = curInsertTxt.substring(0, desPos.pos + 1);
                            }
                        }
                    }
                    catch (e) {
                    }
                    if (prevTextLength === 1 && curInsertTxt.length > 1 && input.length === 1) {
                        if (desPos.desc.type === 31 || desPos.desc.type === 25) {
                            this._disableSmartInputMode = true;
                        }
                    }
                    resultObj = { val: input, pos: desPos.pos, offset: 0, isreset: false };
                    result = desPos.desc.setText(curInsertTxt, ((input.length === 1) ? false : true), resultObj);
                    this._disableSmartInputMode = false;
                    if (!result && typeof (altInsertText) !== 'undefined' && altInsertText.length > 0 && (desPos.desc.type === 26 || desPos.desc.type === 27 || desPos.desc.type === 100 || desPos.desc.type === 101 || desPos.desc.type === 250 || desPos.desc.type === 251)) {
                        result = desPos.desc.setText(altInsertText, ((input.length === 1) ? false : true), resultObj);
                    }
                    if (result) {
                        rh.hint = rh.success;
                        rh.testPosition = pos + resultObj.offset;
                        if (input.length === 1) {
                            var newTextLength = desPos.desc.getText().length;
                            var posAdjustValue = desPos.pos;
                            if (desPos.pos > (newTextLength - 1)) {
                                posAdjustValue = newTextLength;
                            }
                            var diff = newTextLength - prevTextLength;
                            if (diff > 0 && desPos.pos === prevTextLength - 1) {
                                posAdjustValue = newTextLength - 1;
                            }
                            var s = this.toString();
                            rh.testPosition = desPos.desc.startIndex + posAdjustValue + resultObj.offset;
                        }
                        txt = txt.slice(desPos.length - desPos.pos, txt.length);
                    }
                    else {
                        rh.hint = rh.invalidInput;
                        if (rh.testPosition !== -1) {
                            rh.testPosition = position;
                        }
                        if (desPos.desc.type !== -1 && input.length === 1) {
                            return false;
                        }
                    }
                    pos = pos + desPos.length;
                } else {
                    var delimOrEndPos = this.getFirstDelimiterPos(txt, oldTxt);
                    if (delimOrEndPos < 0) {
                        delimOrEndPos = 0;
                    }
                    curInsertTxt = txt.substring(0, delimOrEndPos + 1);
                    resultObj = { val: input, pos: desPos.pos, offset: 0, isreset: false };
                    result = desPos.desc.setText(curInsertTxt, ((input.length === 1) ? false : true), resultObj);
                    if (result) {
                        rh.hint = rh.success;
                        rh.testPosition = pos + resultObj.offset;
                        txt = txt.slice(delimOrEndPos + 1, txt.length);
                    } else {
                        rh.hint = rh.invalidInput;
                        if (rh.testPosition !== -1) {
                            rh.testPosition = position;
                        }
                    }
                    if (delimOrEndPos < 0) {
                        delimOrEndPos = 0;
                    }
                    var delta = delimOrEndPos + 1;
                    pos = pos + delta;
                }
            }
            return result;
        },

        removeAt: function (start, end, rh) {
            try {
                var desPos = this.desPostions[start];
                if (desPos.desc.needAdjustInsertPos()) {
                    var curInsertTxt = '0';
                    var pos = start;
                    desPos.text = desPos.desc.getText();
                    curInsertTxt = desPos.text.slice(0, desPos.pos) + curInsertTxt + desPos.text.slice(desPos.pos + curInsertTxt.length, desPos.length);
                    var resultObj = { val: curInsertTxt, pos: desPos.pos, offset: 0, isreset: true, isfullreset: false };
                    if ((end - start + 1) >= desPos.length) {
                        resultObj.isfullreset = true;
                        start = start + desPos.length;
                        pos = start;
                    }
                    var result = desPos.desc.setText(curInsertTxt, false, resultObj);
                    if (result) {
                        rh.hint = rh.success;
                        rh.testPosition = pos;
                    } else {
                        rh.hint = rh.invalidInput;
                        if (rh.testPosition === -1) {
                            rh.testPosition = start;
                        }
                    }
                }
                if (start < end) {
                    this.removeAt(start + 1, end, rh);
                }
                return true;
            }
            catch (e) {
                return false;
            }
        },

        incEnumPart: function () {
            var desc = this.fields[this.inputWidget.options.activeField];
            if (desc) {
                desc.inc();
            }
            return true;
        },

        decEnumPart: function (pos) {
            var desc = this.fields[this.inputWidget.options.activeField];
            if (desc) {
                desc.dec();
            }
            return true;
        },

        setValue: function (val) {
            this.setDate(new Date(val instanceof Date ? val.getTime() : val));
            return true;
        },

        getValue: function () {
            return this.getDate();
        },

        _disableSmartInputMode: false,

        _isSmartInputMode: function () {
            if (this._disableSmartInputMode) { return false; }
            if (this.inputWidget) { return this.inputWidget.options.smartInputMode; }
            return true;
        },

        _getInt: function (str, i, minlength, maxlength) {
            for (var x = maxlength; x >= minlength; x--) {
                var token = str.substring(i, i + x);
                if (token.length < minlength) {
                    return null;
                }
                if ($.wij.charValidator.isDigit(token)) {
                    return token;
                }
            }
            return null;
        },

        _tryParseDate: function (val, pattern) {
            var ci = this._getCulture().calendars;
            pattern = pattern || ci.standard.patterns.d;
            if (pattern) {
                if (pattern.indexOf('MMM') === -1 && pattern.indexOf('MMMM') === -1) {
                    pattern = pattern.replace('MM', 'M');
                }
                pattern = pattern.replace('dd', 'd');
                pattern = pattern.replace('tt', 'a');
            }

            var pattern2 = pattern.replace('yyyy', 'yy'),
				sep = ci.standard["/"],
				patterns = [pattern, pattern2, pattern.replace(new RegExp(sep, 'g'), '-'), pattern2.replace(new RegExp(sep, 'g'), '-'), pattern.replace(new RegExp(sep, 'g'), '.'), pattern2.replace(new RegExp(sep, 'g'), '.')],
				d = Globalize.parseDate(val, patterns, this._getCulture());

            if (d) {
                return d;
            }

            return 0;
        },

        paddingZero: function (val, aCount) {
            var s = '' + val + '';
            while (s.length < aCount) {
                s = '0' + s;
            }
            return s;
        },

        _formatDate: function (d, f, ci) {
            if (!(d.valueOf())) {
                return '&nbsp;';
            }

            var self = this;
            var sRes = f.replace(new RegExp('yyyy|MMMM|MMM|MM|M|mm|m|dddd|ddd|dd|d|hh|h|HH|H|ss|s|tt|t|a/p', 'gi'), function (match) {
                var h;
                switch (match) {
                    case 'yyyy':
                        return d.getFullYear();
                    case 'MMMM':
                        return ci.dateTimeFormat.monthNames[d.getMonth()];
                    case 'MMM':
                        return ci.dateTimeFormat.abbreviatedMonthNames[d.getMonth()];
                    case 'MM':
                        return self.paddingZero((d.getMonth() + 1), 2);
                    case 'M':
                        return self.paddingZero((d.getMonth() + 1), 1);
                    case 'mm':
                        return self.paddingZero(d.getMinutes(), 2);
                    case 'm':
                        return self.paddingZero(d.getMinutes(), 1);
                    case 'dddd':
                        return ci.dateTimeFormat.dayNames[d.getDay()];
                    case 'ddd':
                        return ci.dateTimeFormat.abbreviatedDayNames[d.getDay()];
                    case 'dd':
                        return self.paddingZero(d.getDate(), 2);
                    case 'd':
                        return self.paddingZero(d.getDate(), 1);
                    case 'hh':
                        h = d.getHours() % 12;
                        return self.paddingZero(((h) ? h : 12), 2);
                    case 'h':
                        h = d.getHours() % 12;
                        return self.paddingZero(((h) ? h : 12), 1);
                    case 'HH':
                        return self.paddingZero(d.getHours(), 2);
                    case 'H':
                        return self.paddingZero(d.getHours(), 1);
                    case 'ss':
                        return self.paddingZero(d.getSeconds(), 2);
                    case 's':
                        return self.paddingZero(d.getSeconds(), 1);
                    case 'tt':
                        return (d.getHours() < 12) ? cf.AM[0] : cf.PM[0];
                    case 't':
                        return (d.getHours() < 12) ? ((cf.AM[0].length > 0) ? cf.AM[0].charAt(0) : '') : ((cf.PM[0].length > 0) ? cf.PM[0].charAt(0) : '');
                    case 'a/p':
                        return (d.getHours() < 12) ? 'a' : 'p';
                }
                return 'N';
            });
            return sRes;
        }
    };


    ////////////////////////////////////////////////////////////////////////////////
    // _iDateDescriptor

    var _iDateDescriptor = function (tp, id, type, len) {
        this._txtProvider = tp;
        this.id = id;
        this.type = type;
        this.startIndex = 0;
        this.maxLen = len || 2;
    };

    _iDateDescriptor.prototype = {
        _txtProvider: null,
        id: 0,
        type: 0,
        name: null,
        startIndex: 0,
        maxLen: 2,

        getText: function () { return null; },
        setText: function (value, allowchangeotherpart, result) { return false; },
        inc: function () { },
        dec: function () { },
        needAdjustInsertPos: function () { return true; },
        reachMaxLen: function () {
            var t = this.getText();
            do {
                if (t.charAt(0) === '0') {
                    t = t.slice(1);
                } else {
                    break;
                }
            } while (t.length > 0);
            return t.length >= this.maxLen;
        }
    };

    var wijImplementInterface = function (target, interfaceType) {
        for (var name in interfaceType.prototype) {
            if (!target.prototype[name]) {
                target.prototype[name] = interfaceType.prototype[name];
            }
        }
    };


    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor

    var _dateDescriptor = function (owner, id) {
        wijImplementInterface(_dateDescriptor, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, -1, 100]);
    };

    _dateDescriptor.prototype = {
        liternal: '',

        getText: function () {
            return this.liternal;
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor20

    var _dateDescriptor20 = function (owner, id) {
        wijImplementInterface(_dateDescriptor20, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 20]);
        this.name = 'Two-digit month';
    };

    _dateDescriptor20.prototype = {
        getText: function () {
            var m = '' + this._txtProvider.getMonth() + '';
            return m.length === 1 ? ('0' + m) : m;
        },

        setText: function (value, allowchangeotherpart, result) {
            return this._txtProvider.setMonth(value, allowchangeotherpart, result);
        },

        inc: function () {
            this._txtProvider.setMonth(this._txtProvider.getMonth() * 1 + 1, true);
        },

        dec: function () {
            this._txtProvider.setMonth(this._txtProvider.getMonth() * 1 - 1, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor25

    var _dateDescriptor25 = function (owner, id) {
        wijImplementInterface(_dateDescriptor25, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 25]);
        this.name = 'month';
    };

    _dateDescriptor25.prototype = {

        getText: function () {
            var m = '' + this._txtProvider.getMonth() + '';
            return m;
        },

        setText: function (value, allowchangeotherpart, result) {
            return this._txtProvider.setMonth(value, allowchangeotherpart, result);
        },

        inc: function () {
            this._txtProvider.setMonth(this._txtProvider.getMonth() * 1 + 1, true);
        },

        dec: function () {
            this._txtProvider.setMonth(this._txtProvider.getMonth() * 1 - 1, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor26

    var _dateDescriptor26 = function (owner, id) {
        wijImplementInterface(_dateDescriptor26, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 26, 100]);
        this.name = 'AbbreviatedMonthNames';
    };

    _dateDescriptor26.prototype = {

        getText: function () {
            var m = this._txtProvider.getMonth(), culture = this._txtProvider._getCulture();
            return culture.calendars.standard.months.namesAbbr[m - 1];
        },

        setText: function (value, allowchangeotherpart, result) {
            var m = -1;
            m = this._txtProvider.findAlikeArrayItemIndex(cf.months.namesAbbr, value);
            if (m === -1) {
                return false;
            }
            return this._txtProvider.setMonth(m + 1, allowchangeotherpart, result);
        },

        inc: function () {
            this._txtProvider.setMonth(this._txtProvider.getMonth() * 1 + 1, true);
        },

        dec: function () {
            this._txtProvider.setMonth(this._txtProvider.getMonth() * 1 - 1, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor27

    var _dateDescriptor27 = function (owner, id) {
        wijImplementInterface(_dateDescriptor27, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 27, 100]);
        this.name = 'MonthNames';
    };

    _dateDescriptor27.prototype = {

        getText: function () {
            var m = this._txtProvider.getMonth(), culture = this._txtProvider._getCulture();
            return culture.calendars.standard.months.names[m - 1];
        },

        setText: function (value, allowchangeotherpart, result) {
            var m = -1;
            if (result && result.isfullreset) {
                m = 1;
            }
            else {
                var culture = this._txtProvider._getCulture();
                m = this._txtProvider.findAlikeArrayItemIndex(culture.calendars.standard.months.names, value);
                if (m === -1) {
                    return false;
                }
            }
            return this._txtProvider.setMonth(m + 1, allowchangeotherpart, result);
        },

        inc: function () {
            this._txtProvider.setMonth(this._txtProvider.getMonth() * 1 + 1, true);
        },

        dec: function () {
            this._txtProvider.setMonth(this._txtProvider.getMonth() * 1 - 1, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor30

    var _dateDescriptor30 = function (owner, id) {
        wijImplementInterface(_dateDescriptor30, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 30]);
        this.name = 'Two-digit day of month';
    };

    _dateDescriptor30.prototype = {

        getText: function () {
            var dom = this._txtProvider.getDayOfMonth();
            if (dom < 10) {
                dom = '0' + dom;
            }
            return '' + dom + '';
        },

        setText: function (value, allowchangeotherpart, result) {
            return this._txtProvider.setDayOfMonth(value, allowchangeotherpart, result);
        },

        inc: function () {
            this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth() * 1 + 1, true);
        },

        dec: function () {
            this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth() * 1 - 1, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor31

    var _dateDescriptor31 = function (owner, id) {
        wijImplementInterface(_dateDescriptor31, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 31]);
        this.name = 'Day of month';
    };

    _dateDescriptor31.prototype = {

        getText: function () {
            var dom = this._txtProvider.getDayOfMonth();
            return '' + dom + '';
        },

        setText: function (value, allowchangeotherpart, result) {
            return this._txtProvider.setDayOfMonth(value, allowchangeotherpart, result);
        },

        inc: function () {
            this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth() * 1 + 1, true);
        },

        dec: function () {
            this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth() * 1 - 1, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor100

    var _dateDescriptor100 = function (owner, id) {
        wijImplementInterface(_dateDescriptor100, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 100, 100]);
        this.name = 'AbbreviatedDayNames';
    };

    _dateDescriptor100.prototype = {

        getText: function () {
            var dw = this._txtProvider.getDayOfWeek(), culture = this._txtProvider._getCulture();
            return culture.calendars.standard.days.namesShort[dw - 1];
        },

        setText: function (value, allowchangeotherpart, result) {
            var dw = -1, culture = this._txtProvider._getCulture();
            dw = this._txtProvider.findAlikeArrayItemIndex(culture.calendars.standard.days.namesShort, value);
            if (dw === -1) {
                return false;
            }
            return this._txtProvider.setDayOfWeek(dw + 1);
        },

        inc: function () {
            this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth() * 1 + 1, true);
        },

        dec: function () {
            this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth() * 1 - 1, true);
        },

        needAdjustInsertPos: function () {
            return false;
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor101

    var _dateDescriptor101 = function (owner, id) {
        wijImplementInterface(_dateDescriptor101, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 101, 100]);
        this.name = 'DayNames';
    };

    _dateDescriptor101.prototype = {

        getText: function () {
            var dw = this._txtProvider.getDayOfWeek(), culture = this._txtProvider._getCulture();
            return culture.calendars.standard.days.names[dw - 1];
        },

        setText: function (value, allowchangeotherpart, result) {
            var dw = -1, culture = this._txtProvider._getCulture();
            dw = this._txtProvider.findAlikeArrayItemIndex(culture.calendars.standard.days.names, value);
            if (dw === -1) {
                return false;
            }
            return this._txtProvider.setDayOfWeek(dw + 1);
        },

        inc: function () {
            this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth() * 1 + 1, true);
        },

        dec: function () {
            this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth() * 1 - 1, true);
        },

        needAdjustInsertPos: function () {
            return false;
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor10

    var _dateDescriptor10 = function (owner, id) {
        wijImplementInterface(_dateDescriptor10, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 10, 4]);
        this.name = 'Four-digit year';
    };

    _dateDescriptor10.prototype = {
        getText: function () {
            return this._txtProvider.getYear();
        },

        setText: function (value, allowchangeotherpart, result) {
            if (this._txtProvider._isSmartInputMode() && result) {
                var startYear = 1900 + 100;
                if (this._txtProvider.inputWidget.options.startYear) {
                    startYear = this._txtProvider.inputWidget.options.startYear;
                }
                var endYear = startYear + 100 - 1;
                startYear = this._txtProvider.paddingZero(startYear, 4);
                endYear = this._txtProvider.paddingZero(endYear, 4);
                if (result.pos === 0 || result.pos === 1) {
                    var curDate = new Date(),
						thisYear = this._txtProvider.paddingZero(this._txtProvider.getYear(), 4);
                    if (thisYear.charAt(0) === '0' && thisYear.charAt(1) === '0' && result.pos <= 1) {
                        var inputNum = result.val * 1;
                        var century = '00';
                        if (inputNum >= 5) {
                            century = startYear.slice(0, 2);
                        }
                        else {
                            century = endYear.slice(0, 2);
                        }
                        var addYear = result.val + thisYear.slice(3, 4);
                        var s = century + addYear;
                        result.offset = 2 - result.pos;
                        this._txtProvider.setYear(s, result);
                        return true;
                    }
                }
            }
            return this._txtProvider.setYear(value, result);
        },

        inc: function () {
            this._txtProvider.setYear(this._txtProvider.getYear() * 1 + 1, null, true);
        },

        dec: function () {
            this._txtProvider.setYear(this._txtProvider.getYear() * 1 - 1, null, true);
        }
    };


    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor1

    var _dateDescriptor1 = function (owner, id) {
        wijImplementInterface(_dateDescriptor1, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 1]);
        this.name = 'One-digit year';
    };

    _dateDescriptor1.prototype = {

        getText: function () {
            var y = this._txtProvider.getYear();
            y = '' + y + '';
            if (y.length === 4) {
                y = y.charAt(2) + y.charAt(3);
            }
            if (y.charAt(0) === '0') {
                y = y.charAt(1);
            }
            return y;
        },

        setText: function (value, allowchangeotherpart, result) {
            value = value + '';
            while (value.length < 2) {
                value = '0' + value;
            }
            var y = this._txtProvider.getYear();
            y = '' + y + '';
            if (value === '00') {
                var m = this._txtProvider.getMonth();
                var dom = this._txtProvider.getDayOfMonth();
                var h = this._txtProvider.getHours();
                var min = this._txtProvider.getMinutes();
                var s = this._txtProvider.getSeconds();
                if (m === 1 && dom === 1 && !h && !min && !s) {
                    y = '0001';
                    value = '01';
                }
            }
            if (y.length >= 2) {
                y = y.charAt(0) + y.charAt(1) + value.charAt(0) + value.charAt(1);
            }
            return this._txtProvider.setYear(y, result);
        },

        inc: function () {
            this._txtProvider.setYear(this._txtProvider.getYear() * 1 + 1, null, true);
        },

        dec: function () {
            this._txtProvider.setYear(this._txtProvider.getYear() * 1 - 1, null, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor2

    var _dateDescriptor2 = function (owner, id) {
        wijImplementInterface(_dateDescriptor2, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 2]);
        this.name = 'Two-digit year';
    };

    _dateDescriptor2.prototype = {

        getText: function () {
            var y = this._txtProvider.getYear();
            y = '' + y + '';
            if (y.length === 4) {
                y = y.charAt(2) + y.charAt(3);
            }
            return y;
        },

        setText: function (value, allowchangeotherpart, result) {
            value = value + '';
            while (value.length < 2) {
                value = '0' + value;
            }
            var y = this._txtProvider.getYear();
            y = '' + y + '';
            if (value === '00') {
                var m = this._txtProvider.getMonth();
                var dom = this._txtProvider.getDayOfMonth();
                var h = this._txtProvider.getHours();
                var min = this._txtProvider.getMinutes();
                var s = this._txtProvider.getSeconds();
                if (m === 1 && dom === 1 && !h && !min && !s) {
                    y = '0001';
                    value = '01';
                }
            }
            if (y.length >= 2) {
                y = y.charAt(0) + y.charAt(1) + value.charAt(0) + value.charAt(1);
            }
            var aRes = this._txtProvider.setYear(y, result);
            return aRes;
        },

        inc: function () {
            this._txtProvider.setYear(this._txtProvider.getYear() * 1 + 1, null, true);
        },

        dec: function () {
            this._txtProvider.setYear(this._txtProvider.getYear() * 1 - 1, null, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor45

    var _dateDescriptor45 = function (owner, id) {
        wijImplementInterface(_dateDescriptor45, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 45]);
        this.name = 'h';
    };

    _dateDescriptor45.prototype = {

        getText: function () {
            var h = this._txtProvider.getHours();
            if (h > 12) {
                h = h - 12;
            }
            return '' + h + '';
        },

        setText: function (value, allowchangeotherpart, result) {
            var h = this._txtProvider.getHours();
            if (h > 12) {
                value = ((value * 1) + 12);
            }
            return this._txtProvider.setHours(value, allowchangeotherpart);
        },

        inc: function () {
            this._txtProvider.setHours(this._txtProvider.getHours() * 1 + 1, true);
        },

        dec: function () {
            this._txtProvider.setHours(this._txtProvider.getHours() * 1 - 1, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor46

    var _dateDescriptor46 = function (owner, id) {
        wijImplementInterface(_dateDescriptor46, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 46]);
        this.name = 'hh';
    };

    _dateDescriptor46.prototype = {

        getText: function () {
            var h = this._txtProvider.getHours();
            if (h > 12) {
                h = h - 12;
            }
            if (h < 10) {
                h = '0' + h;
            }
            return '' + h + '';
        },

        setText: function (value, allowchangeotherpart, result) {
            var h = this._txtProvider.getHours();
            if (h > 12) {
                value = ((value * 1) + 12);
            }
            return this._txtProvider.setHours(value, allowchangeotherpart);
        },

        inc: function () {
            this._txtProvider.setHours(this._txtProvider.getHours() * 1 + 1, true);
        },

        dec: function () {
            this._txtProvider.setHours(this._txtProvider.getHours() * 1 - 1, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor47

    var _dateDescriptor47 = function (owner, id) {
        wijImplementInterface(_dateDescriptor47, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 47]);
        this.name = 'H';
    };

    _dateDescriptor47.prototype = {

        getText: function () {
            var h = this._txtProvider.getHours();
            return '' + h + '';
        },

        setText: function (value, allowchangeotherpart, result) {
            return this._txtProvider.setHours(value, allowchangeotherpart);
        },

        inc: function () {
            this._txtProvider.setHours(this._txtProvider.getHours() * 1 + 1, true);
        },

        dec: function () {
            this._txtProvider.setHours(this._txtProvider.getHours() * 1 - 1, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor48

    var _dateDescriptor48 = function (owner, id) {
        wijImplementInterface(_dateDescriptor48, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 48]);
        this.name = 'HH';
    };

    _dateDescriptor48.prototype = {

        getText: function () {
            var h = this._txtProvider.getHours();
            if (h < 10) {
                h = '0' + h;
            }
            return '' + h + '';
        },

        setText: function (value, allowchangeotherpart, result) {
            return this._txtProvider.setHours(value, allowchangeotherpart);
        },

        inc: function () {
            this._txtProvider.setHours(this._txtProvider.getHours() * 1 + 1, true);
        },

        dec: function () {
            this._txtProvider.setHours(this._txtProvider.getHours() * 1 - 1, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor250

    var _dateDescriptor250 = function (owner, id) {
        wijImplementInterface(_dateDescriptor250, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 250]);
        this.name = 't';
    };

    _dateDescriptor250.prototype = {

        getText: function () {
            var h = this._txtProvider.getHours(), ds = '', culture = this._txtProvider._getCulture();
            if (h < 12) {
                ds = culture.calendars.standard.AM[0];
            }
            else {
                ds = culture.calendars.standard.PM[0];
            }
            if (ds.length <= 0) {
                ds = ' ';
            }
            return ds.charAt(0);
        },

        setText: function (value, allowchangeotherpart, result) {
            var h;
            if (value.toLowerCase().indexOf('a') >= 0) {
                h = (this._txtProvider.getHours() * 1) % 12;
                this._txtProvider.setHours(h, true);
            } else if (value.toLowerCase().indexOf('p') >= 0) {
                h = (this._txtProvider.getHours() * 1) % 12 + 12;
                this._txtProvider.setHours(h, true);
            }
        },

        inc: function () {
            var h = (this._txtProvider.getHours() * 1 + 12) % 24;
            this._txtProvider.setHours(h, true);
        },

        dec: function () {
            var h = (this._txtProvider.getHours() * 1 + 12) % 24;
            this._txtProvider.setHours(h, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor251

    var _dateDescriptor251 = function (owner, id) {
        wijImplementInterface(_dateDescriptor251, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 251]);
        this.name = 'tt';
    };

    _dateDescriptor251.prototype = {

        getText: function () {
            var h = this._txtProvider.getHours(), ds = '', culture = this._txtProvider._getCulture();
            if (h < 12) {
                ds = culture.calendars.standard.AM[0];
            }
            else {
                ds = culture.calendars.standard.PM[0];
            }
            if (ds.length <= 0) {
                ds = ' ';
            }
            return ds;
        },

        setText: function (value, allowchangeotherpart, result) {
            var h;
            if (value.toLowerCase().indexOf('a') >= 0) {
                h = (this._txtProvider.getHours() * 1) % 12;
                this._txtProvider.setHours(h, true);
            } else if (value.toLowerCase().indexOf('p') >= 0) {
                h = (this._txtProvider.getHours() * 1) % 12 + 12;
                this._txtProvider.setHours(h, true);
            }

            return true;
        },

        inc: function () {
            var h = (this._txtProvider.getHours() * 1 + 12) % 24;
            this._txtProvider.setHours(h, true);
        },

        dec: function () {
            var h = (this._txtProvider.getHours() * 1 + 12) % 24;
            this._txtProvider.setHours(h, true);
        }
    };


    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor50

    var _dateDescriptor50 = function (owner, id) {
        wijImplementInterface(_dateDescriptor50, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 50]);
        this.name = 'mm';
    };

    _dateDescriptor50.prototype = {

        getText: function () {
            var min = this._txtProvider.getMinutes();
            if (min < 10) {
                min = '0' + min;
            }
            return '' + min + '';
        },

        setText: function (value, allowchangeotherpart, result) {
            if (result && result.isfullreset) {
                value = '0';
            }

            return this._txtProvider.setMinutes(value, allowchangeotherpart);
        },

        inc: function () {
            this._txtProvider.setMinutes(this._txtProvider.getMinutes() * 1 + 1, true);
        },

        dec: function () {
            this._txtProvider.setMinutes(this._txtProvider.getMinutes() * 1 - 1, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor51

    var _dateDescriptor51 = function (owner, id) {
        wijImplementInterface(_dateDescriptor51, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 51]);
        this.name = 'm';
    };

    _dateDescriptor51.prototype = {

        getText: function () {
            var min = this._txtProvider.getMinutes();
            return '' + min + '';
        },

        setText: function (value, allowchangeotherpart, result) {
            if (result && result.isfullreset) {
                value = '0';
            }

            return this._txtProvider.setMinutes(value, allowchangeotherpart);
        },

        inc: function () {
            this._txtProvider.setMinutes(this._txtProvider.getMinutes() * 1 + 12, true);
        },

        dec: function () {
            this._txtProvider.setMinutes(this._txtProvider.getMinutes() * 1 - 12, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor60

    var _dateDescriptor60 = function (owner, id) {
        wijImplementInterface(_dateDescriptor60, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 60]);
        this.name = 'ss';
    };

    _dateDescriptor60.prototype = {

        getText: function () {
            var s = this._txtProvider.getSeconds();
            if (s < 10) {
                s = '0' + s;
            }
            return '' + s + '';
        },

        setText: function (value, allowchangeotherpart, result) {
            if (result && result.isfullreset) {
                value = '0';
            }
            return this._txtProvider.setSeconds(value, allowchangeotherpart);
        },

        inc: function () {
            this._txtProvider.setSeconds(this._txtProvider.getSeconds() * 1 + 12, true);
        },

        dec: function () {
            this._txtProvider.setSeconds(this._txtProvider.getSeconds() * 1 - 12, true);
        }
    };

    ////////////////////////////////////////////////////////////////////////////////
    // _dateDescriptor61

    var _dateDescriptor61 = function (owner, id) {
        wijImplementInterface(_dateDescriptor61, _iDateDescriptor);
        _iDateDescriptor.apply(this, [owner, id, 61]);
        this.name = 's';
    };

    _dateDescriptor61.prototype = {

        getText: function () {
            var s = this._txtProvider.getSeconds();
            return '' + s + '';
        },

        setText: function (value, allowchangeotherpart, result) {
            if (result && result.isfullreset) {
                value = '0';
            }
            return this._txtProvider.setSeconds(value, allowchangeotherpart);
        },

        inc: function () {
            this._txtProvider.setSeconds(this._txtProvider.getSeconds() * 1 + 12, true);
        },

        dec: function () {
            this._txtProvider.setSeconds(this._txtProvider.getSeconds() * 1 - 12, true);
        }
    };

})(jQuery);

/*
 *
 * Wijmo Library 1.1.2
 * http://wijmo.com/
 *
 * Copyright(c) ComponentOne, LLC.  All rights reserved.
 * 
 * Dual licensed under the Wijmo Commercial or GNU GPL Version 3 licenses.
 * licensing@wijmo.com
 * http://wijmo.com/license
 *
 *
 * * Wijmo Inputmask widget.
 *
 * Depends:
 *	jquery-1.4.2.js
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 *	jquery.ui.position.js
 *	jquery.effects.core.js	
 *	jquery.effects.blind.js
 *	globalize.js
 *	jquery.plugin.wijtextselection.js
 *	jquery.wijmo.wijpopup.js
 *	jquery.wijmo.wijinputcore.js
 *
 */
 (function ($) {
"use strict";
var wijchartype = {
	editOptional: 1,
	editRequired: 2,
	separator: 4,
	literal: 8
};

$.widget("wijmo.wijinputmask", $.extend(true, {}, wijinputcore, {
	options: {
		///	<summary>
		///		Determines the default text.
		///	</summary>
		text: null,
		///	<summary>
		///		Determines the input mask to use at run time. 
		///		Mask must be a string composed of one or more of the masking elements.
		///	</summary>
		mask: "",
		///	<summary>
		///		Determines the character used to represent the absence of user input.
		///	</summary>
		promptChar: '_',
		///	<summary>
		///		Indicates whether the prompt characters in the input mask are hidden when the input loses focus.
		///	</summary>
		hidePromptOnLeave: false,
		///	<summary>
		///		Determines how an input character that matches the prompt character should be handled.
		///	</summary>
		resetOnPrompt: true,
		///	<summary>
		///		Indicates whether promptChar can be entered as valid data by the user.
		///	</summary>
		allowPromptAsInput: false,
		///	<summary>
		///		Determines the character to be substituted for the actual input characters.
		///	</summary>
		passwordChar: '',
		///	<summary>
		///		Determines how a space input character should be handled.
		///	</summary>
		resetOnSpace: true,
		///	<summary>
		///		Indicates whether the user is allowed to re-enter literal values.
		///	</summary>
		skipLiterals: true
	},
	
	_createTextProvider: function(){
		this._textProvider = new wijMaskedTextProvider(this, this.options.mask, false);
	},
	
	_beginUpdate: function(){
		this.element.addClass('wijmo-wijinput-mask');
		this.element.data('isPassword', (this.options.passwordChar.length > 0) && (this.element.attr('type') !== 'password'));
		this.element.data('defaultText', this.options.text);
	},
	
	_onTriggerClicked: function(){
		this._popupComboList();
	},

	_setOption: function (key, value) {
		$.Widget.prototype._setOption.apply(this, arguments);
		wijinputcore._setOption.apply(this, arguments);

		switch (key) {
			case 'text':
				this.setText(value);
				break;

			case 'mask':
			case 'culture':
				if (typeof (value) === 'undefined' || value.length <= 0) { return; }
				var text = this.getText();
				this._textProvider.mask = value;
				this._textProvider.initialMask = value;
				this._textProvider.initialize();
				this._textProvider.set(text);
				this._updateText();
				break;
			case 'promptChar':
				if (!!this._textProvider) {
					this._textProvider.updatePromptChar();
					this._updateText();
				}
				break;
			case 'hidePromptOnLeave':
			case 'resetOnPrompt':
				this._updateText();
				break;
			case 'passwordChar':
				this.element.data('isPassword', ((value + '').length > 0));
				this._updateText();
				break;
		}
	},
	
	_resetData: function () {
		var o = this.options;
		var txt = this.element.data('defaultText');
		if (txt === undefined || txt === null){
			txt = this.element.data('elementValue');
		}
		
		if (txt === undefined || txt === null){
			txt = "";
		}
		
		this.setText(txt);
	},
	
	_isPassword: function () {
		return !!this.element.data('isPassword');
	},
	
	_getTextWithPrompts: function () {
		return !this._isInitialized() ? this.element.val() : this._textProvider.toString(true, true, false);
	},

	_getTextWithLiterals: function () {
		return !this._isInitialized() ? this.element.val() : this._textProvider.toString(true, false, true);
	},

	_getTextWithPromptAndLiterals: function () {
		return !this._isInitialized() ? this.element.val() : this._textProvider.toString(true, true, true);
	},
	
	_onChange: function (e) {
		if (!this.element) { return; }
		var val = this.element.val();
		var txt = this.getText();
		if (txt !== val) {
			txt = this._getTextWithPrompts();
			if (txt !== val) {
				txt = this._getTextWithPromptAndLiterals();
				if (txt !== val) {
					this.setText(val);
				}
			}
		}
	},
	
	_afterFocused: function () {
		if (this._isNullText() || !!this.options.hidePromptOnLeave) {
			this._doFocus();
		}
	}
}));



var wijMaskedTextProvider = function (w, m, asciiOnly) {
	this.inputWidget = w;
	this.mask = m;
	this.asciiOnly = asciiOnly;
	this.descriptors = [];
	this.noMask = false;
	this.initialize();
};

wijMaskedTextProvider.prototype = {
	inputWidget: undefined,
	noMask: false,
	mask: '',
	testString: '',
	assignedCharCount: 0,
	requiredCharCount: 0,
	asciiOnly: false,
	
	initialize: function () {
		this.noMask = (!this.mask || this.mask.length <= 0);
		if (this.noMask) { return; }

		this.testString = '';
		this.assignedCharCount = 0;
		this.requiredCharCount = 0;
		this.descriptors = new Array(0);
		var caseType = 'none', escape = false, index = 0, charType = wijchartype.literal, text = '';
		var culture = this.inputWidget._getCulture();
		for (var i = 0; i < this.mask.length; i++) {
			var needDesc = false;
			var ch = this.mask.charAt(i);
			if (escape) {
				escape = false;
				needDesc = true;
			}
			if (!needDesc) {
				var ch3 = ch;
				if (ch3 <= 'C') {
					switch (ch3) {
						case '#':
						case '9':
						case '?':
						case 'C':
							ch = this.getPromtChar();
							charType = wijchartype.editOptional;
							needDesc = true;
							break;
						case '$':
							text = culture.numberFormat.currency.symbol;
							charType = wijchartype.separator;
							needDesc = true;
							break;
						case '%':
						case '-':
						case ';':
						case '=':
						case '@':
						case 'B':
							charType = wijchartype.literal;
							needDesc = true;
							break;
						case '&':
						case '0':
						case 'A':
							ch = this.getPromtChar();
							charType = wijchartype.editRequired;
							needDesc = true;
							break;
						case ',':
							text = culture.numberFormat[','];
							charType = wijchartype.separator;
							needDesc = true;
							break;
						case '.':
							text = culture.numberFormat['.'];
							charType = wijchartype.separator;
							needDesc = true;
							break;
						case '/':
							text = culture.calendars.standard['/'];
							charType = wijchartype.separator;
							needDesc = true;
							break;
						case ':':
							text = culture.calendars.standard[':'];
							charType = wijchartype.separator;
							needDesc = true;
							break;
						case '<':
							caseType = 'lower';
							continue;
						case '>':
							caseType = 'upper';
							continue;
					}
					if (!needDesc) {
						charType = wijchartype.literal;
						needDesc = true;
					}
				}
				if (!needDesc) {
					if (ch3 <= '\\') {
						switch (ch3) {
							case 'L':
								ch = this.getPromtChar();
								charType = wijchartype.editRequired;
								needDesc = true;
								break;
							case '\\':
								escape = true;
								charType = wijchartype.literal;
								continue;
						}
						if (!needDesc) {
							charType = wijchartype.literal;
							needDesc = true;
						}
					}
					if (!needDesc) {
						if (ch3 === 'a') {
							ch = this.getPromtChar();
							charType = wijchartype.editOptional;
							needDesc = true;
						}
						if (!needDesc) {
							if (ch3 !== '|') {
								charType = wijchartype.literal;
								needDesc = true;
							}
							if (!needDesc) {
								caseType = 'none';
								continue;
							}
						}
					}
				}
			}
			if (needDesc) {
				var cd = new wijCharDescriptor(i, charType);
				if (this.isEditDesc(cd)) {
					cd.caseConversion = caseType;
				}
				if (charType !== wijchartype.separator) {
					text = ch;
				}
				for (var j = 0; j < text.length; j++) {
					var ch2 = text.charAt(j);
					this.testString = this.testString + ch2;
					this.descriptors[this.descriptors.length] = cd;
					index++;
				}
			}
		}
		this.testString.Capacity = this.testString.length;
	},

	getAllowPromptAsInput: function () {
		return !!this.inputWidget ? this.inputWidget.options.allowPromptAsInput : false;
	},

	getPasswordChar: function () {
		return !!this.inputWidget ? this.inputWidget.options.passwordChar : '*';
	},

	isPassword: function () {
		return !!this.inputWidget ? this.inputWidget._isPassword() : false;
	},

	getResetOnPrompt: function () {
		return !!this.inputWidget ? this.inputWidget.options.resetOnPrompt : true;
	},

	getResetOnSpace: function () {
		return !!this.inputWidget ? this.inputWidget.options.resetOnSpace : true;
	},

	getSkipLiterals: function () {
		return !!this.inputWidget ? this.inputWidget.options.skipLiterals : true;
	},
	
	getHidePromptOnLeave: function () {
		return !!this.inputWidget ? this.inputWidget.options.hidePromptOnLeave : false;
	},
	
	_trueOR: function (n1, n2) {
		return ((n1 >>> 1 | n2 >>> 1) * 2 + (n1 & 1 | n2 & 1));
	},

	setValue: function (val) {
		return false;
	},

	getValue: function () {
		return null;
	},
	
	getPromtChar: function () {
		return !!this.inputWidget ? this.inputWidget.options.promptChar : '_';
	},

	updatePromptChar: function () {
		if (this.noMask) { return; }

		for (var i = 0; i < this.descriptors.length; i++) {
			var cd = this.descriptors[i];
			if (cd.charType === wijchartype.editOptional || cd.charType === wijchartype.editRequired) {
				if (!cd.isAssigned) {
					this.testString = $.wij.charValidator.setChar(this.testString, this.getPromtChar(), i);
				}
			}
		}
	},

	resetChar: function (pos) {
		var cd = this.descriptors[pos];
		if (this.isEditPos(pos) && cd.isAssigned) {
			cd.isAssigned = false;
			this.testString = $.wij.charValidator.setChar(this.testString, this.getPromtChar(), pos);
			this.assignedCharCount--;
			if (cd.charType === wijchartype.editRequired) {
				this.requiredCharCount--;
			}
		}
	},

	getAdjustedPos: function (pos) {
		if (this.noMask) {
			if (pos >= this.testString.length) {
				pos = this.testString.length - 1;
			}
		}
		else {
			if (pos >= this.descriptors.length) {
				pos = pos - 1;
			}
		}
		
		return Math.max(0, pos);
	},

	incEnumPart: function (pos, rh, step) {
		return !this.noMask;
	},

	decEnumPart: function (pos, rh, step) {
		return !this.noMask;
	},

	findNonEditPositionInRange: function (start, end, direction) {
		return this.findPositionInRange(start, end, direction, this._trueOR(wijchartype.literal, wijchartype.separator));
	},

	findPositionInRange: function (start, end, direction, charType) {
		start = Math.max(0, start);
		end = Math.min(end, this.testString.length - 1);
		
		if (start <= end) {
			while (start <= end) {
				var pos = (direction) ? start++ : end--;
				var cd = this.descriptors[pos];
				if (((cd.charType & 4294967295) & (charType & 4294967295)) === cd.charType) {
					return pos;
				}
			}
		}
		return -1;
	},

	findAssignedEditPositionInRange: function (start, end, direction) {
		if (this.assignedCharCount === 0) { return -1; }
		return this.findEditPositionInRange(start, end, direction, wijchartype.editRequired);
	},

	findEditPositionInRange: function (start, end, direction, assignedStatus) {
		do {
			var pos = this.findPositionInRange(start, end, direction, this._trueOR(wijchartype.editRequired, wijchartype.editOptional));
			if (pos === -1) {
				break;
			}
			
			var cd = this.descriptors[pos];
			switch (assignedStatus) {
				case wijchartype.editOptional:
					if (!cd.isAssigned) {
						return pos;
					}
					break;
				case wijchartype.editRequired:
					if (cd.isAssigned) {
						return pos;
					}
					break;
				default:
					return pos;
			}
			if (direction){
				start++;
			}else{
				end--;
			}
		} while (start <= end);
		
		return -1;
	},

	findAssignedEditPositionFrom: function (pos, direction) {
		if (!this.assignedCharCount) { return -1; }
		
		var start, end;
		if (direction) {
			start = pos;
			end = this.testString.length - 1;
		}else{
			start = 0;
			end = pos;
		}
		return this.findAssignedEditPositionInRange(start, end, direction);
	},

	findEditPositionFrom: function (pos, direction) {
		var start, end;
		if (direction) {
			start = pos;
			end = this.testString.length - 1;
		}
		else {
			start = 0;
			end = pos;
		}
		return this.findEditPositionInRange(start, end, direction, 0);
	},
	
	setChar: function (input, pos, desc) {
		pos = pos < 0 ? 0 : pos;
		if (!desc) {
			desc = this.descriptors[pos];
		}
		if (this.testEscapeChar(input, pos, desc)) {
			this.resetChar(pos);
		}else{
			if ($.wij.charValidator.isLetter(input)) {
				if ($.wij.charValidator.isUpper(input)) {
					if (desc.caseConversion === 'lower') {
						input = input.toLowerCase();
					}
				}
				else if (desc.caseConversion === 'upper') {
					input = input.toUpperCase();
				}
			}
			this.testString = $.wij.charValidator.setChar(this.testString, input, pos);
			if (!desc.isAssigned) {
				desc.isAssigned = true;
				this.assignedCharCount++;
				if (desc.charType === wijchartype.editRequired) {
					this.requiredCharCount++;
				}
			}
		}
	},

	internalInsertAt: function (input, pos, rh, testOnly) {
		if (input.length === 0) {
			rh.testPosition = pos;
			rh.hint = rh.noEffect;
			return true;
		}
		if (!this._testString(input, pos, rh)) {
			return false;
		}
		var num1 = this.findEditPositionFrom(pos, true);
		var flag1 = this.findAssignedEditPositionInRange(num1, rh.testPosition, true) !== -1;
		var num2 = this.findAssignedEditPositionFrom(this.testString.length - 1, false);
		if (flag1 && (rh.testPosition === (this.testString.length - 1))) {
			rh.hint = rh.unavailableEditPosition;
			rh.testPosition = this.testString.length;
			return false;
		}
		var num3 = this.findEditPositionFrom(rh.testPosition + 1, true);
		if (flag1) {
			var hint1 = new wijInputResult();
			hint1.hint = hint1.unknown;
			var repeat = true;
			while (repeat) {
				repeat = false;
				if (num3 === -1) {
					rh.hint = rh.unavailableEditPosition;
					rh.testPosition = this.testString.length;
					return false;
				}
				var cd = this.descriptors[num1];
				if (cd.isAssigned && !this.testChar(this.testString.charAt(num1), num3, hint1)) {
					rh.hint = hint1.hint;
					rh.testPosition = num3;
					return false;
				}
				if (num1 !== num2) {
					num1 = this.findEditPositionFrom(num1 + 1, true);
					num3 = this.findEditPositionFrom(num3 + 1, true);
					repeat = true;
					continue;
				}
			}
			if (hint1.hint > rh.hint) {
				rh.hint = hint1.hint;
			}
		}
		if (!testOnly) {
			if (flag1) {
				while (num1 >= pos) {
					var descriptor2 = this.descriptors[num1];
					if (descriptor2.isAssigned) {
						this.setChar(this.testString.charAt(num1), num3);
					}
					else {
						this.resetChar(num3);
					}
					num3 = this.findEditPositionFrom(num3 - 1, false);
					num1 = this.findEditPositionFrom(num1 - 1, false);
				}
			}
			this.setString(input, pos);
		}
		return true;
	},

	insertAt: function (input, pos, rh) {
		if (rh === undefined) { rh = new wijInputResult(); }
		if (input === undefined) { throw 'InsertAt: input'; }

		if (this.noMask) {
			this.testString = this.testString.substring(0, pos) + input + this.testString.substring(pos, this.testString.length);
			rh.testPosition = pos + input.length - 1;
			return true;
		}
		if ((pos >= 0) && (pos < this.testString.length)) {
			return this.internalInsertAt(input, pos, rh, false);
		}
		rh.testPosition = pos;
		rh.hint = rh.positionOutOfRange;
		return false;
	},

	clear: function (rh) {
		if (this.noMask) {
			this.testString = '';
			rh.hint = rh.success;
			return;
		}
		if (!this.assignedCharCount) {
			rh.hint = rh.noEffect;
		}else{
			rh.hint = rh.success;
			for (var num1 = 0; num1 < this.testString.length; num1++) {
				this.resetChar(num1);
			}
		}
	},

	isLiteral: function (desc) {
		if (!desc) { return false;}
		if (desc.charType !== wijchartype.literal) {
			return (desc.charType === wijchartype.separator);
		}
		return true;
	},

	testEscapeChar: function (input, pos, desc) {
		pos = pos < 0 ? 0 : pos;
		if (!desc) {
			desc = this.descriptors[pos];
		}
		if (this.isLiteral(desc)) {
			if (this.getSkipLiterals()) {
				return (input === this.testString.charAt(pos));
			}
			return false;
		}
		if ((!this.getResetOnPrompt() || (input !== this.getPromtChar())) && (!this.getResetOnSpace() || (input !== ' '))) {
			return false;
		}
		return true;
	},

	testChar: function (input, pos, rh) {
		if (!$.wij.charValidator.isPrintableChar(input)) {
			rh.hint = rh.invalidInput;
			return false;
		}
		var cd = this.descriptors[pos];
		if (!cd) { return false; }

		if (this.isLiteral(cd)) {
			if (this.getSkipLiterals() && (input === this.testString.charAt(pos))) {
				rh.hint = rh.characterEscaped;
				return true;
			}
			rh.hint = rh.nonEditPosition;
			return false;
		}
		if (input === this.getPromtChar()) {
			if (this.getResetOnPrompt()) {
				if (this.isEditDesc(cd) && cd.isAssigned) {
					rh.hint = rh.sideEffect;
				}else{
					rh.hint = rh.characterEscaped;
				}
				return true;
			}
			if (!this.getAllowPromptAsInput()) {
				rh.hint = rh.promptCharNotAllowed;
				return false;
			}
		}
		if ((input === ' ') && this.getResetOnSpace()) {
			if (this.isEditDesc(cd) && cd.isAssigned) {
				rh.hint = rh.sideEffect;
			}else{
				rh.hint = rh.characterEscaped;
			}
			return true;
		}
		switch (this.mask.charAt(cd.maskPosition)) {
			case 'L':
				if (!$.wij.charValidator.isLetter(input)) {
					rh.hint = rh.letterExpected;
					return false;
				}
				if (!$.wij.charValidator.isAsciiLetter(input) && this.asciiOnly) {
					rh.hint = rh.asciiCharacterExpected;
					return false;
				}
				break;
			case 'a':
				if (!$.wij.charValidator.isAlphanumeric(input) && (input !== ' ')) {
					rh.hint = rh.alphanumericCharacterExpected;
					return false;
				}
				if (!$.wij.charValidator.isAciiAlphanumeric(input) && this.asciiOnly) {
					rh.hint = rh.asciiCharacterExpected;
					return false;
				}
				break;
			case '?':
				if (!$.wij.charValidator.isLetter(input) && (input !== ' ')) {
					rh.hint = rh.letterExpected;
					return false;
				}
				if ($.wij.charValidator.isAsciiLetter(input) || !this.asciiOnly) {
					break;
				}
				rh.hint = rh.asciiCharacterExpected;
				return false;
			case 'A':
				if (!$.wij.charValidator.isAlphanumeric(input)) {
					rh.hint = rh.alphanumericCharacterExpected;
					return false;
				}
				if ($.wij.charValidator.isAciiAlphanumeric(input) || !this.asciiOnly) {
					break;
				}
				rh.hint = rh.asciiCharacterExpected;
				return false;
			case 'C':
				if ((!$.wij.charValidator.isAscii(input) && this.asciiOnly) && (input !== ' ')) {
					rh.hint = rh.asciiCharacterExpected;
					return false;
				}
				break;
			case '9':
				if (!$.wij.charValidator.isDigit(input) && (input !== ' ')) {
					rh.hint = rh.digitExpected;
					return false;
				}
				break;
			case '#':
				if ((!$.wij.charValidator.isDigit(input) && (input !== '-')) && ((input !== '+') && (input !== ' '))) {
					rh.hint = rh.digitExpected;
					return false;
				}
				break;
			case '&':
				if (!$.wij.charValidator.isAscii(input) && this.asciiOnly) {
					rh.hint = rh.asciiCharacterExpected;
					return false;
				}
				break;
			case '0':
				if (!$.wij.charValidator.isDigit(input)) {
					rh.hint = rh.digitExpected;
					return false;
				}
				break;
		}
		if ((input === this.testString.charAt(pos)) && cd.isAssigned) {
			rh.hint = rh.noEffect;
		}else{
			rh.hint = rh.success;
		}
		return true;
	},

	_testString: function (input, pos, rh) {
		rh.hint = rh.unknown;
		rh.testPosition = pos;
		if (input.length) {
			var hint1 = new wijInputResult();
			hint1.testPosition = rh.testPosition;
			hint1.hint = rh.hint;
			for (var i = 0; i < input.length; i++) {
				var ch = input.charAt(i);
				if (rh.testPosition > this.testString.length) {
					rh.hint = rh.unavailableEditPosition;
					return false;
				}
				if (!this.testEscapeChar(ch, rh.testPosition)) {
					rh.testPosition = this.findEditPositionFrom(rh.testPosition, true);
					if (rh.testPosition === -1) {
						rh.testPosition = this.testString.length;
						rh.hint = rh.unavailableEditPosition;
						return false;
					}
				}
				if (!this.testChar(ch, rh.testPosition, hint1)) {
					rh.hint = hint1.hint;
					return false;
				}
				if (hint1.hint > rh.hint) {
					rh.hint = hint1.hint;
				}
				rh.testPosition += 1;
				
				if (rh.testPosition == this.testString.length){
					break;
				}
			}
			rh.testPosition -= 1;
		}
		return true;
	},

	set: function (input, rh) {
		if (rh === undefined) { rh = new wijInputResult(); }
		if (input === undefined) { throw 'SetFromPos: input parameter is null or undefined.'; }

		rh.hint = rh.unknown;
		rh.testPosition = 0;
		if (!input.length) {
			this.clear(rh);
			return true;
		}
		if (this.noMask) {
			this.testString = input;
			return true;
		}
		if (!this.testSetString(input, rh.testPosition, rh)) {
			return false;
		}
		var num1 = this.findAssignedEditPositionFrom(rh.testPosition + 1, true);
		if (num1 !== -1) {
			this.resetString(num1, this.testString.length - 1);
		}
		return true;
	},

	resetString: function (start, end) {
		if (this.noMask) {
			this.testString = '';
			return;
		}
		start = this.findAssignedEditPositionFrom(start, true);
		if (start !== -1) {
			end = this.findAssignedEditPositionFrom(end, false);
			while (start <= end) {
				start = this.findAssignedEditPositionFrom(start, true);
				this.resetChar(start);
				start++;
			}
		}
	},

	setString: function (input, pos) {
		for (var i = 0; i < input.length; i++) {
			var ch = input.charAt(i);
			if (!this.testEscapeChar(ch, pos)) {
				pos = this.findEditPositionFrom(pos, true);
			}
			
			if (pos < 0 || pos >= this.testString.length) { return; }
			this.setChar(ch, pos);
			pos++;
		}
	},

	testSetString: function (input, pos, rh) {
		if (input.length > this.testString.length) {
			input = input.substring(0, this.testString.length);
		}
		
		if (this._testString(input, pos, rh)) {
			this.setString(input, pos);
			return true;
		}
		return false;
	},
	
	toString: function (ignorePasswordChar, includePrompt, includeLiterals, start, len) {
		var val = this.inputWidget.options.text || "";
		val = $.trim(val);
		if (this.inputWidget.options.showNullText && !this.inputWidget.isFocused() && (val === "" || val === this.inputWidget.options.nullText)) {
			return this.inputWidget.options.nullText;
		}

		ignorePasswordChar = (ignorePasswordChar === undefined) ? !this.isPassword() : ignorePasswordChar;
		includePrompt = (includePrompt === undefined) ? (this.getHidePromptOnLeave() ? this.inputWidget.isFocused() : true) : includePrompt;
		includeLiterals = (includeLiterals === undefined) ? true : includeLiterals;

		if (this.noMask) {
			if (!ignorePasswordChar) {
				var s = '';
				for (var i = 0; i < this.testString.length; i++) {
					s += this.getPasswordChar();
				}
				return s;
			}
			return this.testString;
		}
		

		start = (start === undefined) ? 0 : start;
		len = (len === undefined) ? this.testString.length : len;

		if (len <= 0) { return ''; }
		if (start < 0) { start = 0; }
		if (start >= this.testString.length) { return ''; }
		var num1 = this.testString.length - start;
		if (len > num1) { len = num1; }
		if ((!this.isPassword() || ignorePasswordChar) && (includePrompt && includeLiterals)) {
			var result = this.testString.substring(start, len - start);
			return result;
		}
		var builder1 = '';
		var num2 = (start + len) - 1;
		for (var num5 = start; num5 <= num2; num5++) {
			var ch = this.testString.charAt(num5);
			var cd = this.descriptors[num5];
			switch (cd.charType) {
				case wijchartype.editOptional:
				case wijchartype.editRequired:
					if (!cd.isAssigned) {
						break;
					}
					if (!this.isPassword() || ignorePasswordChar) {
						builder1 = builder1 + ch;
						continue;
					}
					builder1 = builder1 + this.getPasswordChar();
					continue;
				case (wijchartype.editRequired | wijchartype.editOptional):
					builder1 = builder1 + ch;
					continue;
				case wijchartype.separator:
				case wijchartype.literal:
					if (!includeLiterals) {
						continue;
					}
					builder1 = builder1 + ch;
					continue;
				default:
					builder1 = builder1 + ch;
					continue;
			}
			if (includePrompt) {
				builder1 = builder1 + ch;
				continue;
			}
			builder1 = builder1 + ' ';
			continue;
		}

		return builder1;
	},

	isEditDesc: function (desc) {
		if (this.noMask) { return true; }
		
		if (desc.charType !== wijchartype.editRequired) {
			return (desc.charType === wijchartype.editOptional);
		}
		return true;
	},

	isEditPos: function (pos) {
		if (this.noMask) { return true; }
		if ((pos < 0) || (pos >= this.testString.length)) { return false; }

		var cd = this.descriptors[pos];
		return this.isEditDesc(cd);
	},

	internalRemoveAt: function (start, end, rh, testOnly) {
		if (this.noMask) {
			try {
				this.testString = this.testString.substring(0, start) + this.testString.substring(end + 1, this.testString.length);
				rh.testPosition = start;
			}
			catch (e) {
			}
			return true;
		}
		var hint1 = new wijInputResult();
		var ch;
		var ch2;
		var num1 = this.findAssignedEditPositionFrom(this.testString.length - 1, false);
		var i = this.findEditPositionInRange(start, end, true, 0);
		rh.hint = rh.noEffect;
		if ((i === -1) || (i > num1)) {
			rh.testPosition = start;
			return true;
		}
		rh.testPosition = start;
		var flag1 = end < num1;
		if (this.findAssignedEditPositionInRange(start, end, true) !== -1) {
			rh.hint = rh.success;
		}
		if (flag1) {
			var num3 = this.findEditPositionFrom(end + 1, true);
			var num4 = num3;
			start = i;
			var repeat = true;
			while (repeat) {
				repeat = false;
				ch = this.testString.charAt(num3);
				var cd = this.descriptors[num3];
				if (((ch !== this.getPromtChar()) || cd.isAssigned) && !this.testChar(ch, i, hint1)) {
					rh.hint = hint1.hint;
					rh.testPosition = i;
					return false;
				}
				if (num3 !== num1) {
					num3 = this.findEditPositionFrom(num3 + 1, true);
					i = this.findEditPositionFrom(i + 1, true);
					repeat = true;
					continue;
				}
			}
			if (rh.sideEffect > rh.hint) {
				rh.hint = rh.sideEffect;
			}
			if (testOnly) {
				return true;
			}
			num3 = num4;
			i = start;
			var repeat2 = true;
			while (repeat2) {
				repeat2 = false;
				ch2 = this.testString.charAt(num3);
				var descriptor2 = this.descriptors[num3];
				if ((ch2 === this.getPromtChar()) && !descriptor2.isAssigned) {
					this.resetChar(i);
				}
				else {
					this.setChar(ch2, i);
					this.resetChar(num3);
				}
				if (num3 !== num1) {
					num3 = this.findEditPositionFrom(num3 + 1, true);
					i = this.findEditPositionFrom(i + 1, true);
					repeat2 = true;
					continue;
				}
			}
			start = i + 1;
		}
		if (start <= end) {
			this.resetString(start, end);
		}
		return true;
	},

	removeAt: function (start, end, rh) {
		if (typeof (end) === 'undefined') {
			end = start;
		}

		if (!rh) { rh = new wijInputResult(); }
		if (end >= this.testString.length) {
			rh.testPosition = end;
			rh.hint = rh.positionOutOfRange;
			return false;
		}
		if ((start >= 0) && (start <= end)) {
			var result = this.internalRemoveAt(start, end, rh, false);
			return result;
		}
		rh.testPosition = start;
		rh.hint = rh.positionOutOfRange;
		return false;
	}
};


////////////////////////////////////////////////////////////////////////////////
// wijCharDescriptor

var wijCharDescriptor = function (maskPos, charType) {
	this.caseConversion = 'none';
	this.maskPosition = maskPos;
	this.charType = charType;
};

wijCharDescriptor.prototype = {
	isAssigned: false,
	maskPosition: 0
};
	

})(jQuery);

/*
 *
 * Wijmo Library 1.1.2
 * http://wijmo.com/
 *
 * Copyright(c) ComponentOne, LLC.  All rights reserved.
 * 
 * Dual licensed under the Wijmo Commercial or GNU GPL Version 3 licenses.
 * licensing@wijmo.com
 * http://wijmo.com/license
 *
 *
 * * Wijmo Inputnumber widget.
 *
 * Depends:
 *	jquery-1.4.2.js
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 *	jquery.ui.position.js
 *	jquery.effects.core.js	
 *	jquery.effects.blind.js
 *	globalize.js
 *	jquery.plugin.wijtextselection.js
 *	jquery.wijmo.wijpopup.js
 *	jquery.wijmo.wijinputcore.js
 *
 */
 (function ($) {
	 "use strict";

	 $.widget("wijmo.wijinputnumber", $.extend(true, {}, wijinputcore, {
		 options: {
			///	<summary>
			///		Determines the type of the number input.
			///		Possible values are: 'numeric', 'percent', 'currency'.
			///	</summary>
			type: 'numeric',
			///	<summary>
			///		Determines the default numeric value.
			///	</summary>
			value: null,
			///	<summary>
			///		Determines the minimal value that can be entered for numeric/percent/currency inputs.
			///	</summary>
			minValue: -1000000000,
			///	<summary>
			///		Determines the maximum value that can be entered for numeric/percent/currency inputs.
			///	</summary>
			maxValue: 1000000000,
			///	<summary>
			///		Indicates whether the thousands group separator will be 
			///		inserted between between each digital group 
			///		(number of digits in thousands group depends on the 
			///		selected Culture).
			///	</summary>
			showGroup: false,
			///	<summary>
			///		Indicates the number of decimal places to display.
			///		Possible values are integer from -2 to 8. They are:
			///		useDefault: -2,
			///		asIs: -1,
			///		zero: 0,
			///		one: 1,
			///		two: 2,
			///		three: 3,
			///		four: 4,
			///		five: 5,
			///		six: 6,
			///		seven: 7,
			///		eight: 8
			///	</summary>
			decimalPlaces: 2,
			///	<summary>
			///		Determines how much to increase/decrease the input field.
			///	</summary>
			increment: 1,
			/// <summary>
			/// The valueChanged event handler. A function called when the value of the input is changed.
			/// Default: null.
			/// Type: Function.
			/// Code example: $("#element").wijinputnumber({ valueChanged: function (e, arg) { } });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.value: The new value.
			///</param>
			valueChanged: null,
			/// <summary>
			/// The valueBoundsExceeded event handler. A function called when the value of the input exceeds the valid range.
			/// Default: null.
			/// Type: Function.
			/// Code example: $("#element").wijinputnumber({ valueBoundsExceeded: function (e) { } });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			valueBoundsExceeded: null
		 },

		 _createTextProvider: function () {
			 this._textProvider = new wijNumberTextProvider(this, this.options.type);
		 },

		 _beginUpdate: function () {
			 var o = this.options;
			 this.element.addClass('wijmo-wijinput-numeric');
			 
			 this.element.data({
				 defaultValue: o.value,
				 preValue: o.value
			 }).attr({
				 'aria-valuemin': o.minValue,
				 'aria-valuemax': o.maxValue,
				 'aria-valuenow': o.value || 0
			 });
		 },
		 
		 _onTriggerClicked: function () {
			 this._popupComboList();
		 },

		 _setOption: function (key, value) {
			 $.Widget.prototype._setOption.apply(this, arguments);
			 wijinputcore._setOption.apply(this, arguments);

			 switch (key) {
				 case 'minValue':
					 this.element.attr('aria-valuemin', value);
					 this._updateText();
					 break;

				 case 'maxValue':
					 this.element.attr('aria-valuemax', value);
					 this._updateText();
					 break;

				 case 'value':
					 this.setValue(value);
					 this._updateText();
					 break;

				 case 'showGroup':
				 case 'decimalPlaces':
				 case 'culture':
					 this._textProvider.updateStringFormat();
					 this._updateText();
					 break;
			 }
		 },

		 _setData: function (val) {
			 this.setValue(val);
		 },

		 _resetData: function () {
			var val = this.element.data('defaultValue');
			if (val === undefined || val === null){
				val = this.element.data('elementValue');
				if (val === undefined || val === null && val === ""){
					val = 0;
				}
			}
			
			this.setValue(val);
		 },

		 _validateData: function () {
			 if (this._textProvider.checkAndRepairBounds(true, false)) {
				 this._updateText();
			 }
		 },

		 _raiseDataChanged: function () {
			 var v = this.options.value;
			 var prevValue = this.element.data('preValue');
			 this.element.data('preValue', v);
			 if (prevValue !== v) {
				 this.element.attr('aria-valuenow', v);
				 this._trigger('valueChanged', null, {value: v});
			 }
		 },

        getValue: function () {
            /// <summary>Gets the value.</summary>
			 var val = this._textProvider.getValue();
			 if (val === undefined || val === null) { val = this.getText(); }
			 return val;
		 },

         setValue: function (val, exact) {
            /// <summary>Sets the value.</summary>
			 try {
				 exact = !!exact;
				 if (typeof val === 'boolean') {
					 val = val ? '1' : '0';
				 }else if (typeof val === 'string') {
					 val = this._textProvider.tryParseValue(val);
				 }
				 
				 if (this._textProvider.setValue(val)) {
					 this._updateText();
				 } else {
					 if (exact) {
						 var prevVal = '';
						 prevVal = this.getText();
						 this.setText(val);
						 val = val.trim();
						 var txt = this.getText().trim();
						 if (txt !== val) {
							this.setText(prevVal);
						 }
					 } else {
						 this.setText(val);
					 }
				 }

				 return true;
			 }
			 catch (e) {
				 return false;
			 }
		 },

        isValueNull: function () {
            /// <summary>Determines whether the value is in null state.</summary>
			 try {
				 return (this._textProvider).isValueNull();
			 }
			 catch (e) {
				 return true;
			 }
		 },
		 
 		getPostValue: function(){
			/// <summary>Gets the text value when the container form is posted back to server.</summary>
			if (!this._isInitialized()) { return this.element.val(); }
			if (this.options.showNullText && this.isValueNull()) { return "0"; }
			
			var val = this.options.value ? this.options.value : 0;
			if (this.options.type === "percent"){
				val = (val / 100).toFixed(10);
			}
			
			return val.toString();
		},

		 _updateText: function () {
			 if (!this._isInitialized()) { return; }

			 this.options.value = this._textProvider.getValue();
			 wijinputcore._updateText.apply(this, arguments);
			 if (!this._textProvider.checkAndRepairBounds(false, false)) {
				 this._trigger('valueBoundsExceeded');
			 }
		 },
		 
		 _doSpin: function (up, repeating) {
			up = !!up;
			repeating = !!repeating;

			if (!this._allowEdit()) { return; }
			if (repeating && this.element.data('breakSpinner')) { return; }
			var selRange = this.element.wijtextselection();
			var rh = new wijInputResult();
			if (this.element.data('focusNotCalledFirstTime') !== -9 && (new Date().getTime() - this.element.data('focusNotCalledFirstTime')) < 600) {
				this.element.data('focusNotCalledFirstTime', -9);
				this.element.data('prevCursorPos', 0);
			}
			if (this.element.data('prevCursorPos') === -1) {
				this.element.data('prevCursorPos', selRange.start);
			} else {
				selRange.start = (this.element.data('prevCursorPos'));
			}
			rh.testPosition = selRange.start;
			this._textProvider[up ? 'incEnumPart' : 'decEnumPart'](selRange.start, rh, this.options.increment);
			this._updateText();
			this.element.data('prevCursorPos', rh.testPosition);
			this.selectText(rh.testPosition, rh.testPosition);
			if (repeating && !this.element.data('breakSpinner')) {
				window.setTimeout($.proxy(function () { this._doSpin(up, true); }, this), this._calcSpinInterval());
			}
		}
	 }));


	 //==============================
	 var wijNumberTextProvider = function (owner, t) {
		 this.inputWidget = owner;
		 this._type = t;
		 this._stringFormat = new wijNumberFormat(this._type, this.inputWidget.options.decimalPlaces, this.inputWidget.options.showGroup, this._getCulture());
		 this._stringFormat._setValueFromJSFloat(this.getValue());
	 };

	 wijNumberTextProvider.prototype = {
		 _type: 'numeric',
		 _stringFormat: null,

		 _getCulture: function () {
			 return this.inputWidget._getCulture();
		 },

		 getDecimalSeparator: function () {
			 return this._getCulture().numberFormat['.'];
		 },
		 
		 tryParseValue: function(value){
			return this._stringFormat.tryParseValue(value);
		 },

		 toString: function () {
			 if (this.inputWidget.options.showNullText && !this.inputWidget.isFocused() && this.isValueNull()) {
				 return this.inputWidget.options.nullText;
			 }
			 return this._stringFormat.getFormattedValue();
		 },

		 isValueNull: function () {
			var o = this.inputWidget.options,
				nullValue = Math.max(0, o.minValue);

			return null === o.value || undefined === o.value || nullValue === o.value;
		 },

		 set: function (input, rh) {
			 this.clear();
			 this.insertAt(input, 0, rh);
			 return true;
		 },

		 clear: function () {
			 this._stringFormat.clear();
		 },

		 checkAndRepairBounds: function (chkAndRepair, chkIsLessOrEqMin) {
			 var result = true;
			 if (typeof (chkAndRepair) === 'undefined') { chkAndRepair = false; }

			 var minValue = this.inputWidget.options.minValue,
				maxValue = this.inputWidget.options.maxValue;

			 if (typeof (chkIsLessOrEqMin) !== 'undefined' && chkIsLessOrEqMin) {
				 return this._stringFormat.checkMinValue(minValue, false, true);
			 }

			 if (!this._stringFormat.checkMinValue(minValue, chkAndRepair, false)) { result = false; }
			 if (!this._stringFormat.checkMaxValue(maxValue, chkAndRepair)) { result = false; }
			 if (this.inputWidget.options.decimalPlaces >= 0) {
				 this._stringFormat.checkDigitsLimits(this.inputWidget.options.decimalPlaces);
			 }

			 return result;
		 },

		 countSubstring: function (txt, subStr) {
			 var c = 0;
			 var pos = txt.indexOf(subStr);
			 while (pos !== -1) {
				 c++;
				 pos = txt.indexOf(subStr, pos + 1);
			 }
			 return c;
		 },

		 getAdjustedPositionFromLeft: function (position) {
			 var currentText = this._stringFormat._currentText;
			 for (var i = 0; i < currentText.length; i++) {
				 var ch = currentText.charAt(i);
				 if (!$.wij.charValidator.isDigit(ch) && (ch !== ',' && ch !== '.') || ch === '0') {
					 if (this._stringFormat.isZero()) {
						 if (position < i) {
							 position++;
						 }
					 } else {
						 if (position <= i) {
							 position++;
						 }
					 }
				 } else {
					 break;
				 }
			 }
			 
			 return position;
		 },

		 getDecimalSeparatorPos: function () {
			 var currentText = this._stringFormat._currentText;
			 return currentText.indexOf(this.getDecimalSeparator());
		 },

		 insertAt: function (input, position, rh) {
			 var nf = this._getCulture().numberFormat;

			 if (input === nf['.']) { input = nf['.']; }
			 if (!rh) { rh = new wijInputResult(); }
			 if (input.length === 1) {
				 if (input === '+') {
					 this._stringFormat.setPositiveSign();
					 this.checkAndRepairBounds(true, false);
					 return true;
				 }
				 if (input === '-' || input === ')' || input === '(') {
					 this._stringFormat.invertSign();
					 this.checkAndRepairBounds(true, false);
					 rh.testPosition = position;
					if (this._stringFormat.isNegative())
						rh.testPosition = position;
					else
						rh.testPosition = position - 2;
					 return true;
				 }
				 if (!$.wij.charValidator.isDigit(input)) {
					 if (input === '.') {
						 var pos = this.getDecimalSeparatorPos();
						 if (pos >= 0) {
							 rh.testPosition = pos;
							 return true;
						 }
					 }
					 if (input !== ',' && input !== '.' && input !== ')' && input !== '+' && input !== '-' && input !== '(' && input !== this.getDecimalSeparator()) {
						 if (this._type === 'percent' && input === nf.percent.symbol) {
							 rh.testPosition = position;
							 return true;
						 } else if (this._type === 'currency' && input === nf.currency.symbol) {
							 rh.testPosition = position;
							 return true;
						 } else {
							 return false;
						 }
					 }
				 }
			 }

			 position = this.getAdjustedPositionFromLeft(position);
			 var slicePos = position;
			 var currentText = this._stringFormat._currentText;
			 if (slicePos > currentText.length) {
				 slicePos = currentText.length - 1;
			 }
			 if (input.length === 1) {
				 if (currentText.charAt(slicePos) === input) {
					 rh.testPosition = slicePos;
					 return true;
				 }
			 }
			 var beginText = currentText.substring(0, slicePos);
			 var endText = currentText.substring(slicePos, currentText.length);
			 if (this._stringFormat.isZero()) {
				 endText = endText.replace(new RegExp('[0]'), '');
			 }

			 rh.testPosition = beginText.length + input.length - 1;
			 this._stringFormat.deFormatValue(beginText + input + endText);
			 this.checkAndRepairBounds(true, false);
			 try {
				 if (input.length === 1) {
					 if (this.inputWidget.options.showGroup) {
						 var newBegText = this._stringFormat._currentText.substring(0, beginText.length);
						 if (this.countSubstring(newBegText, this._stringFormat._groupSeparator) !== this.countSubstring(beginText, this._stringFormat._groupSeparator)) {
							 rh.testPosition = rh.testPosition + 1;
						 }
					 }
					 else {
						 var leftPrevCh = beginText.charAt(beginText.length - 1);
						 var leftCh = this._stringFormat._currentText.charAt(rh.testPosition - 1);
						 if (leftCh !== leftPrevCh) {
							 rh.testPosition = rh.testPosition - 1;
						 }
					 }
				 }
			 }
			 catch (e) {
			 }
			 
			 return true;
		 },

		 removeAt: function (start, end, rh) {
			 var nf = this._getCulture().numberFormat;

			 if (!rh) { rh = new wijInputResult(); }
			 rh.testPosition = start;
			 try {
				 var curText = this._stringFormat._currentText;
				 if ((start === end) && curText.substring(start, end + 1) === this.getDecimalSeparator()) {
					 return false;
				 }
				 var curInsertText = curText.slice(0, start) + curText.slice(end + 1);
				 if (curInsertText === '') { curInsertText = '0'; }
				 this._stringFormat.deFormatValue(curInsertText);
				 if (start === end && this.inputWidget.options.showGroup) {
					 try {
						 var newBegText = this._stringFormat._currentText.substring(0, start);
						 if (this.countSubstring(newBegText, this._stringFormat._groupSeparator) !== this.countSubstring(curInsertText, this._stringFormat._groupSeparator)) {
							 rh.testPosition = rh.testPosition - 1;
							 if (curText.indexOf(nf.currency.symbol) === rh.testPosition || curText.indexOf(nf.percent.symbol) === rh.testPosition) {
								 rh.testPosition = rh.testPosition + 1;
							 }
						 }
					 }
					 catch (e1) {
					 }
				 }
				 this.checkAndRepairBounds(true, false);
				 return true;
			 }
			 catch (e2) {
			 }
			 this.checkAndRepairBounds(true, false);
			 return true;
		 },

		 incEnumPart: function (position, rh, val) {
			 if (!rh) { rh = new wijInputResult(); }
			 this._stringFormat.increment(val);
			 return this.checkAndRepairBounds(true, false);
		 },

		 decEnumPart: function (position, rh, val) {
			 if (!rh) { rh = new wijInputResult(); }
			 this._stringFormat.decrement(val);
			 return this.checkAndRepairBounds(true, false);
		 },

		 getValue: function () {
			 return this._stringFormat.getJSFloatValue();
		 },

		 setValue: function (val) {
			 try {
				 this._stringFormat._setValueFromJSFloat(val);
				 this.checkAndRepairBounds(true, false);
				 return true;
			 }
			 catch (e) {
				 return false;
			 }
		 },

		 updateStringFormat: function () {
			 var t = '0';
			 if (typeof (this._stringFormat) !== 'undefined') {
				 t = this._stringFormat._currentValueInString;
			 }
			 this._stringFormat = new wijNumberFormat(this._type, this.inputWidget.options.decimalPlaces, this.inputWidget.options.showGroup, this._getCulture());
			 this._stringFormat._currentValueInString = t;
		 }
	 };


	 //============================

	 var wijNumberFormat = function (t, dp, g, c) {
		 this.type = t;
		 this.digitsPlaces = dp;
		 this.showGroup = g;
		 this.culture = c;
	 };

	 wijNumberFormat.prototype = {
		 _currentValueInString: '0',
		 _currentText: '0',
		 _groupSeparator: ' ',
		 type: 'numeric',
		 digitsPlaces: 0,
		 showGroup: false,
		 culture: null,

 		 isNegtive: function (value) {
			 return value.indexOf('-') !== -1 || value.indexOf('(') !== -1;
		 },
		 
		 stripValue: function(value){
			 var nf = this.culture.numberFormat;
			 var isNegative = this.isNegtive(value);

			 value = value.replace('(', '');
			 value = value.replace(')', '');
			 value = value.replace('-', '');
			 value = value.replace(nf.percent.symbol, '');
			 value = value.replace(nf.currency.symbol, '');
			 var groupSep = nf[','];
			 var decimalSep = nf['.'];
			 switch (this.type) {
				 case 'percent':
					 groupSep = nf.percent[','];
					 decimalSep = nf.percent['.'];
					 break;
				 case 'currency':
					 groupSep = nf.currency[','];
					 decimalSep = nf.currency['.'];
					 break;
			 }
			 this._groupSeparator = groupSep;
			 var r = new RegExp('[' + groupSep + ']', 'g');
			 value = value.replace(r, '');
			 r = new RegExp('[' + decimalSep + ']', 'g');
			 value = value.replace(r, '.');
			 r = new RegExp('[ ]', 'g');
			 value = value.replace(r, '');
			 try {
				 var reg = new RegExp('([\\d\\.])+');
				 var arr = reg.exec(value);
				 if (arr) {
					 value = arr[0];
				 }
				 if (isNegative) {
					 value = '-' + value;
				 }
				 
				 return value;
			 }
			 catch (e) {
			 }
			 
			 return null;
		 },
		 
		 tryParseValue: function(value){
			 value = this.stripValue(value);
			 if (value === null) {return 0;}
			 
			 try{
				value = parseFloat(value);
				if (isNaN(value)) { value = 0 ;}
			 }catch(e){
				value = 0;
			 }
			 
			 return value;
		 },

		 deFormatValue: function (value) {
 			 value = this.stripValue(value);
			 if (value === null) {return;}
		 
			 this._currentValueInString = value;
			 this._currentText = this.formatValue(value);
		 },

		 formatValue: function (value) {
			 var nf = this.culture.numberFormat;
			 value = '' + value + '';
			 var dp = this.digitsPlaces, groupSep = ' ', decimalSep = '.', decimals = 2, isNegative = this.isNegtive(value);

			 var groupSizes = new Array(3);
			 groupSizes.push(3);
			 var pattern = 'n';
			 switch (this.type) {
				 case 'numeric':
					 pattern = isNegative ? nf.pattern[0] : 'n';
					 groupSep = nf[','];
					 decimalSep = nf['.'];
					 decimals = nf.decimals;
					 groupSizes = nf.groupSizes;
					 break;
				 case 'percent':
					 pattern = nf.percent.pattern[isNegative ? 0 : 1];
					 groupSep = nf.percent[','];
					 decimalSep = nf.percent['.'];
					 decimals = nf.percent.decimals;
					 groupSizes = nf.percent.groupSizes;
					 break;
				 case 'currency':
					 pattern = nf.currency.pattern[isNegative ? 0 : 1];
					 groupSep = nf.currency[','];
					 decimalSep = nf.currency['.'];
					 decimals = nf.currency.decimals;
					 groupSizes = nf.currency.groupSizes;
					 break;
			 }

			 if (dp !== -2) { decimals = dp; }
			 if (!this.showGroup) { groupSizes = [0]; }

			 value = value.replace(new RegExp('^[0]+'), '');
			 var digitsString = this.formatDigit(value, groupSep, decimalSep, decimals, groupSizes);
			 digitsString = digitsString.replace(new RegExp('^[0]+'), '');
			 if (digitsString.indexOf(decimalSep) === 0) { digitsString = '0' + digitsString; }
			 if (digitsString === '') { digitsString = '0'; }

			 this._currentValueInString = value;
			 this._currentText = this.applyFormatPattern(pattern, digitsString, nf.percent.symbol, nf.currency.symbol);
			 return this._currentText;
		 },

		 getFormattedValue: function () {
			 return this.formatValue(this._currentValueInString);
		 },

		 getJSFloatValue: function () {
			 try {
				 if (this._currentValueInString === '') {
					 return 0;
				 }
				 return parseFloat(this._currentValueInString);
			 }
			 catch (e) {
				 return Number.NaN;
			 }
		 },

		 clear: function () {
			 this._currentValueInString = '0';
			 this._currentText = '0';
		 },

		 _setValueFromJSFloat: function (v) {
			 try {
				 this._currentValueInString = '' + v + '';
				 this.formatValue(v);
				 return true;
			 }
			 catch (e) {
				 return false;
			 }
		 },

		 isZero: function (val) {
			 try {
				if (val === undefined){
					val = this._currentValueInString;
				}
			 
				 var test = val.replace('-', '');
				 test = test.replace('(', '');
				 test = test.replace(')', '');
				 if (!test.length) {
					 test = '0';
				 }
				 var dbl = parseFloat(test);
				 if (!isNaN(dbl) && !dbl) {
					 return true;
				 }
			 }
			 catch (e) {
			 }
			 return false;
		 },

		 setPositiveSign: function () {
			 this._currentValueInString = this._currentValueInString.replace('-', '');
			 this._currentValueInString = this._currentValueInString.replace('(', '');
			 this._currentValueInString = this._currentValueInString.replace(')', '');
		 },
		 
		 isNegative: function(){
			return this._currentValueInString.indexOf('-') !== -1 || this._currentValueInString.indexOf('(') !== -1;
		 },

		 invertSign: function () {
			 var isNegative = this.isNegative();
			 if (isNegative) {
				 this.setPositiveSign();
			 } else {
				 this._currentValueInString = (!this._currentValueInString.length) ? '0' : '-' + this._currentValueInString;
			 }
			 if (this.isZero()) {
				 this._currentValueInString = isNegative ? '0' : '-0';
			 }
			 this.formatValue(this._currentValueInString);
		 },

		 increment: function (val) {
			 if (val === undefined) { val = 1; }
			 try {
				 var arr = this._currentValueInString.split('.');
				 this._currentValueInString = (arr[0] * 1 + val) + '' + ((arr.length > 1) ? ('.' + arr[1]) : '');
			 }
			 catch (e) {
			 }
		 },

		 decrement: function (val) {
			 if (val === undefined) { val = 1; }
			 try {
				 var arr = this._currentValueInString.split('.');
				 this._currentValueInString = (arr[0] * 1 - val) + '' + ((arr.length > 1) ? ('.' + arr[1]) : '');
			 }
			 catch (e) {
			 }
		 },

		 checkDigitsLimits: function (aDigitsCount) {
			 try {
				 var arr = this._currentValueInString.split('.');
				 if (!arr.length || (arr.length === 1 && arr[0] === '')) {
					 return;
				 }
				 var s = '';
				 if (arr.length > 1) {
					 s = arr[1];
				 }
				 var d = '';
				 for (var i = 0; i < aDigitsCount; i++) {
					 var ch = '0';
					 if (s.length > i) {
						 ch = s.charAt(i);
					 }
					 d = d + ch;
				 }
				 if (d.length > 0) {
					 this._currentValueInString = arr[0] + '.' + d;
				 } else {
					 this._currentValueInString = arr[0];
				 }
			 }
			 catch (e) {
			 }
		 },

		 checkMinValue: function (val, chkAndRepair, chkIsLessOrEqMin) {
			 if (typeof (chkIsLessOrEqMin) === 'undefined') {
				 chkIsLessOrEqMin = false;
			 }
			 var result = true;
			 try {
				 var arr = this._currentValueInString.split('.');
				 var s1 = parseFloat((arr[0] === '' || arr[0] === '-') ? '0' : arr[0]);
				 var s2 = 0;
				 if (arr.length > 1 && parseFloat(arr[1]) > 0) {
					 s2 = parseFloat('1.' + arr[1]);
				 }
				 if (s1 < 0 || arr[0] === '-') {
					 s2 = s2 * -1;
				 }
				 val = '' + val + '';
				 arr = val.split('.');
				 var sv1 = parseFloat(arr[0]);
				 var sv2 = 0;
				 if (arr.length > 1 && parseFloat(arr[1]) > 0) {
					 sv2 = parseFloat('1.' + arr[1]);
				 }
				 if (s1 > sv1) {
					 return true;
				 }
				 if (s1 < sv1 || (chkIsLessOrEqMin && s1 === sv1 && s2 <= sv2)) {
					 result = false;
				 } else if (s1 === sv1 && s1 < 0 && s2 > sv2) {
					 result = false;
				 } else if (s1 === sv1 && s1 >= 0 && s2 < sv2) {
					 result = false;
				 }
				 if (!result && chkAndRepair) {
					 this._currentValueInString = '' + val + '';
				 }
			 }
			 catch (e) {
			 }
			 return result;
		 },

		 checkMaxValue: function (val, chkAndRepair) {
			 var result = true;
			 try {
				 var arr = this._currentValueInString.split('.');
				 var s1 = parseFloat((arr[0] === '' || arr[0] === '-') ? '0' : arr[0]);
				 var s2 = 0;
				 if (arr.length > 1 && parseFloat(arr[1]) > 0) {
					 s2 = parseFloat('1.' + arr[1]);
				 }
				 if (s1 < 0 || arr[0] === '-') {
					 s2 = s2 * -1;
				 }
				 val = '' + val + '';
				 arr = val.split('.');
				 var sv1 = parseFloat(arr[0]);
				 var sv2 = 0;
				 if (arr.length > 1 && parseFloat(arr[1]) > 0) {
					 sv2 = parseFloat('1.' + arr[1]);
				 }
				 if (s1 < sv1) {
					 return true;
				 }
				 if (s1 > sv1) {
					 result = false;
				 }
				 if (s1 === sv1 && s1 >= 0 && s2 > sv2) {
					 result = false;
				 }
				 if (s1 === sv1 && s1 < 0 && s2 < sv2) {
					 result = false;
				 }
				 if (!result && chkAndRepair) {
					 this._currentValueInString = '' + val + '';
				 }
			 }
			 catch (e) {
			 }
			 return result;
		 },

		 applyFormatPattern: function (pattern, digitString, percentSymbol, currencySymbol) {
			 var result = pattern;
			 var r = new RegExp('[n]', 'g');
			 result = result.replace(r, digitString);
			 r = new RegExp('[%]', 'g');
			 result = result.replace(r, percentSymbol);
			 r = new RegExp('[$]', 'g');
			 result = result.replace(r, currencySymbol);
			 return result;
		 },

		 formatDigit: function (value, groupSep, decimalSep, decimals, groupSizes) {
			 var absValue = '' + value + '';
			 absValue = absValue.replace('-', '');
			 absValue = absValue.replace('(', '');
			 absValue = absValue.replace(')', '');
			 var decimalPos = absValue.indexOf(decimalSep);
			 if (decimalPos === -1) { decimalPos = absValue.indexOf('.'); }
			 if (decimalPos === -1) { decimalPos = absValue.indexOf(','); }
			 if (decimalPos === -1) { decimalPos = absValue.length; }

			 var result = '', groupSizeIndex = 0, groupCount = 0, ch, i;
			 for (i = absValue.length - 1; i >= 0; i--) {
				 ch = absValue.charAt(i);
				 if (i < decimalPos) {
					 result = ch + result;
					 groupCount++;
					 if (groupCount === groupSizes[groupSizeIndex] * 1 && groupSizes[groupSizeIndex] * 1 && i) {
						 result = groupSep + result;
						 groupCount = 0;
						 if (groupSizes.length - 1 > groupSizeIndex) {
							 groupSizeIndex++;
						 }
					 }
				 }
			 }
			 if (decimals > 0) {
				 result = result + decimalSep;
				 for (i = 0; i < decimals; i++) {
					 ch = '0';
					 if (i + decimalPos + 1 < absValue.length) {
						 ch = absValue.charAt(i + decimalPos + 1);
					 }
					 result = result + ch;
				 }
			 }
			 if (decimals === -1) {
				 if (decimalPos < absValue.length - 1) {
					 result = result + decimalSep;
					 result = result + absValue.substr(decimalPos + 1);
				 }
			 }
			 return result;
		 }
	 };

 })(jQuery);

/*globals jQuery,$,document*/
/*jslint white: false*/

/*
 *
 * Wijmo Library 1.1.2
 * http://wijmo.com/
 *
 * Copyright(c) ComponentOne, LLC.  All rights reserved.
 * 
 * Dual licensed under the Wijmo Commercial or GNU GPL Version 3 licenses.
 * licensing@wijmo.com
 * http://wijmo.com/license
 *
 *
 * * Wijmo Grid Widget.
 *
 * Depends:
 * jquery-1.4.2.js
 * jquery.ui.core.js
 * jquery.ui.widget.js
 * globalize.js
 * jquery.wijmo.wijutil.js
 * jquery.wijmo.wijdatasource.js
 *
 * Optional dependencies for paging feature:
 * jquery.wijmo.wijpager.js
 *
 * Optional dependencies for scrolling feature:
 * jquery.wijmo.wijsuperpanel.js
 *
 * Optional dependencies for filtering feature:
 * jquery.ui.position.js
 * jquery.wijmo.wijinputdate.js
 * jquery.wijmo.wijinputmask.js
 * jquery.wijmo.wijinputnumber.js
 * jquery.wijmo.wijlist.js
 *
 * Optional dependencies for column moving feature:
 * jquery.ui.draggable.js
 * jquery.ui.droppable.js
 * jquery.ui.position.js
 *
 */

(function ($) {
	"use strict";
	$.widget("wijmo.wijgrid", {
		options: {
			/// <summary>
			/// A value indicating whether columns can be moved.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ allowColMoving: false });
			/// </summary>
			allowColMoving: false,

			/// <summary>
			/// A value indicating whether columns can be sized.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ allowColSizing: false });
			/// </summary>
			allowColSizing: false,

			/// <summary>
			/// A value indicating whether editing is enabled.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ allowEditing: false });
			/// </summary>
			allowEditing: false,

			/// <summary>
			/// A value indicating whether keyboard navigation is allowed.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ allowKeyboardNavigation: false });
			/// </summary>
			allowKeyboardNavigation: false,

			/// <summary>
			/// A value indicating whether the widget can be paged.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ allowPaging: false });
			/// </summary>
			allowPaging: false,

			/// <summary>
			/// A value indicating whether the widget can be sorted.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ allowSorting: false });
			/// </summary>
			allowSorting: false,

			/// <summary>
			/// Determines whether wijgrid should parse underlying data at each operation requiring data re-fetching, like calling the ensureControl(true) method, paging, sorting, and so on.
			/// If the option is disabled, wijgrid parses data only at the first fetch.
			/// The option is ignored if dynamic data load feature is used, in this case data are always parsed.
			///
			/// Default: true
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ alwaysParseData: true });
			/// </summary>
			///
			/// <remarks>
			/// Turning off the option enhance wijgrid performance but if underlying data are changed by a developer it is necessary
			/// that changes match column datatype.
			/// </remarks>
			alwaysParseData: true,

			/// <summary>
			/// Function used for styling the cells in wijgrid.
			/// Default: undefined,
			/// Type: Function.
			/// Code example: $("#element").wijgrid({ cellStyleFormatter: function(args) { } });
			/// </summary>
			/// <param name="args" type="Object">
			/// args.$cell: jQuery object that represents cell to format.
			/// args.column: Options of the column to which the cell belongs.
			/// args.state: state of a cell to format, the following $.wijmo.wijgrid.renderState values or their combination can be applied to the cell: rendering, current, selected.
			/// args.row: information about associated row.
			/// args.row.$rows: jQuery object that represents rows to format.
			/// args.row.data: associated data.
			/// args.row.dataRowIndex: data row index.
			/// args.row.dataItemIndex: data item index.
			/// args.row.virtualDataItemIndex: virtual data item index.
			/// args.row.type: type of the row, one of the $.wijmo.wijgrid.rowType values.
			/// </param>
			cellStyleFormatter: undefined,

			/// <summary>
			/// An array of column options.
			/// Default: [].
			/// Type: Array.
			/// Code example: $("#element").wijgrid({ columns: [ { headerText: "column0", allowSort: false }, { headerText: "column1", dataType: "number" } ] });
			/// </summary>
			columns: [],

			/// <summary>
			/// Determines behavior for column autogeneration.
			///
			/// Possible values are: "none", "append", "merge".
			///
			/// "none": column auto-generation is turned off.
			/// "append": a column will be generated for each data field and added to the end of the columns collection.
			/// "merge": each column having dataKey option not specified will be automatically bound to the first unreserved data field.
			/// For each data field not bound to any column a new column will be generated and added to the end of the columns collection.
			/// To prevent automatic binding of a column to a data field set its dataKey option to null.
			///
			/// Default: "merge".
			/// Type: String.
			/// Code example: $("#element").wijgrid({ columnsAutogenerationMode: "merge" });
			/// </summary>
			///
			/// <remarks>
			/// Note: columns autogeneration process affects the options of columns and the columns option itself.
			/// </remarks>
			columnsAutogenerationMode: "merge",

			/// <summary>
			/// Determines the culture ID.
			/// Default: "".
			/// Type: String.
			/// Code example: $("#element").wijgrid({ culture: "en" });
			/// </summary>
			culture: "",

			/// <summary>
			/// An array of custom user filters.
			///
			/// Custom user filter is an object which contains the following properties:
			///   name - operator name.
			///   arity - the number of filter operands. Can be either 1 or 2.
			///   applicableTo - an array of datatypes to which the filter can be applied. Possible values for elements of the array are "string", "number", "datetime", "currency" and "boolean".
			///   operator - comparison operator, the number of accepted parameters depends upon the arity. The first parameter is a data value, the second parameter is a filter value.
			///
			/// Default: [].
			/// Type: Array.
			/// Code example:
			///
			///   var oddFilterOp = {
			///     name: "customOperator-Odd",
			///     arity: 1,
			///     applicableTo: ["number"],
			///     operator: function(dataVal) { return (dataVal % 2 !== 0); }
			///  }
			///
			///  $("#element").wijgrid({ customFilterOperators: [oddFilterOp] });
			/// </summary>
			customFilterOperators: [],

			/// <summary>
			/// Determines the datasource.
			/// Possible datasources include:
			///
			///   1. A DOM table. This is the default datasource, used if the data option is null.
			///     Table must have no cells with rowSpan and colSpan attributes.
			///   2. A two-dimensional array, such as [[0, "a"], [1, "b"]].
			///   3. An array of objects, such as [{field0: 0, field1: "a"}, {field0: 1, field1: "b'}].
			///   4. A wijdatasource.
			///
			/// Type: Object.
			/// Default: null
			/// Code example:
			/// /* DOM table */
			/// $("#element").wijgrid();
			///
			/// /* two-dimensional array */
			/// $("#element").wijgrid({ data: [[0, "a"], [1, "b"]] });
			/// </summary>
			data: null,

			/// <summary>
			/// Determines whether to use number type column width as the real width of the column.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ ensureColumnsPxWidth: true });
			/// </summary>
			/// <remarks>
			/// If this option is set to true, wijgrid will not expand itself to expand the available space.
			/// Instead, it will use the width option of each column widget.
			/// </remarks>
			ensureColumnsPxWidth: false,

			/// <summary>
			/// Determines the order of items in the filter dropdown list.
			/// Possible values are: "none", "alphabetical", "alphabeticalCustomFirst" and "alphabeticalEmbeddedFirst"
			///
			/// "none" - operators follow the order of addition, built-in operators goes before custom ones.
			/// "alphabetical" - operators are sorted alphabetically.
			/// "alphabeticalCustomFirst" - operators are sorted alphabetically with custom operators going before built-in ones.
			/// "alphabeticalEmbeddedFirst" - operators are sorted alphabetically with built-in operators going before custom operators.
			///
			/// Note: "NoFilter" operator is always first.
			///
			/// Type: String.
			/// Default: "alphabeticalCustomFirst"
			/// Code example: $("#element").wijgrid({ filterOperatorsSortMode: "alphabeticalCustomFirst" });
			/// </summary>
			filterOperatorsSortMode: "alphabeticalCustomFirst",

			/// <summary>
			/// Determines the caption of the group area.
			/// Default: "Drag a column here to group by that column.".
			/// Type: String.
			/// Code example: $("#element").wijgrid({ groupAreaCaption: "Drag a column here to group by that column." });
			/// </summary>
			groupAreaCaption: "Drag a column here to group by that column.",

			/// <summary>
			/// Determines the indentation of the groups.
			/// Default: 10.
			/// Type: Number.
			/// Code example: $("#element").wijgrid({ groupIndent: 10 });
			/// </summary>
			groupIndent: 10,

			/// <summary>
			/// Determines whether position of the current cell is highlighted or not.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ highlightCurrentCell: false });
			/// </summary>
			highlightCurrentCell: false,

			///<summary>
			/// Determines the text to be displayed when the grid is loading.
			/// Default: "Loading...".
			/// Code example: $("#element").wijgrid({ loadingText: "Loading..."});
			///</summary>
			loadingText: "Loading...",

			/// <summary>
			/// Cell values equal to this property value are considered as null value.
			/// Case-sensitive for built-in parsers.
			/// Default: undefined.
			/// Type: String.
			/// Code example: $("#element").wijgrid({ nullString: "" });
			/// </summary>
			nullString: undefined,

			/// <summary>
			/// Determines the zero-based index of the current page.
			/// The default value is 0.
			/// Type: Number.
			/// Code example: $("#element").wijgrid({ pageIndex: 0 });
			/// </summary>
			pageIndex: 0,

			/// <summary>
			/// Number of rows to place on a single page.
			/// The default value is 10.
			/// Type: Number.
			/// Code example: $("#element").wijgrid({ pageSize: 10 });
			/// </summary>
			pageSize: 10,

			/// <summary>
			/// Pager settings.
			/// Note: See jquery.wijmo.wijpager.js for more information.
			/// Type: Object.
			/// Default: { mode: "numeric", pageButtonCount: 10, position: "bottom" }.
			/// Code example: $("#element").wijgrid({ pagerSettings: { position: "bottom" } });
			/// </summary>
			pagerSettings: {
				mode: "numeric",
				pageButtonCount: 10,
				position: "bottom"
			},

			/// A value indicating whether DOM cell attributes can be passed within a data values.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ readAttributesFromData: false });
			/// </summary>
			/// <remarks>
			/// This option allows binding collection of values to data and automatically converting them as attributes of corresponded DOM table cells during rendering.
			///
			/// Values should be passed as an array of two items, where first item is a value of the data field, the second item is a list of values:
			///
			/// $("#element").wijgrid({
			///   data: [
			///     [ [1, { "style": "color: red", "class": "myclass" } ], a ]
			///   ]
			/// });
			///
			/// or
			///
			/// $("#element").wijgrid({
			///   data: [
			///     { col0: [1, { "style": "color: red", "class": "myclass" }], col1: "a" }
			///   ]
			/// });
			///
			/// Note: during conversion wijgrid extracts the first item value and makes it data field value, the second item (list of values) is removed:
			///  [ { col0: 1, col1: "a" } ]
			/// 
			/// If DOM table is used as a datasource then attributes belonging to the cells in tBody section of the original table will be read and applied to the new cells.
			///
			/// rowSpan and colSpan attributes are not allowed.
			/// </remarks>
			readAttributesFromData: false,

			/// <summary>
			/// Function used for styling the rows in wijgrid.
			/// Default: undefined,
			/// Type: Function.
			/// Code example: $("#element").wijgrid({ rowStyleFormatter: function(args) { } });
			/// </summary>
			/// <param name="args" type="Object">
			/// args.state: state of a row to format, the following $.wijmo.wijgrid.renderState values or their combination can be applied to the row: rendering, current, hovered.
			/// args.$rows: jQuery object that represents rows to format.
			/// args.data: associated data.
			/// args.dataRowIndex: data row index.
			/// args.dataItemIndex: data item index.
			/// args.virtualDataItemIndex: virtual data item index.
			/// args.type: type of the row, one of the $.wijmo.wijgrid.rowType values.
			/// </param>
			rowStyleFormatter: undefined,

			/// <summary>
			/// Determines the scrolling mode.
			///
			/// Possible values are:
			/// "none": scrolling is not used, staticRowIndex and staticColumnIndex are ignored.
			/// "auto": scrollbars appear automatically depending upon content size.
			/// "horizontal": horizontal scrollbar is active.
			/// "vertical": vertical scrollbar is active.
			/// "both": both horizontal and vertical scrollbars are active.
			///
			/// Default: "none".
			/// Type: String.
			/// Code example: $("#element").wijgrid({ scrollMode: "none" });
			/// </summary>
			scrollMode: "none",

			/// <summary>
			/// Represents selection behavior.
			/// Possible values are: "none", "singleCell", "singleColumn", "singleRow", "singleRange", "multiColumn", "multiRow" and "multiRange".
			///
			/// "none": selection is turned off.
			/// "singleCell": only a single cell can be selected at the same time.
			/// "singleColumn": only a single column can be selected at the same time.
			/// "singleRow": only a single row can be selected at the same time.
			/// "singleRange": only a single range of cells can be selected at the same time.
			/// "multiColumn": it is possible to select more than one row at the same time using the mouse and the CTRL or SHIFT keys.
			/// "multiRow": it is possible to select more than one row at the same time using the mouse and the CTRL or SHIFT keys.
			/// "multiRange": it is possible to select more than one cells range at the same time using the mouse and the CTRL or SHIFT keys.
			///
			/// Default: "singleRow".
			/// Type: String.
			/// Code example: $("#element").wijgrid({ selectionMode: "singleRow" });
			/// </summary>
			selectionMode: "singleRow",

			/// <summary>
			/// A value indicating whether filter row is visible.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ showFilter: false });
			/// </summary>
			showFilter: false,

			/// <summary>
			/// A value indicating whether footer row is visible.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ showFooter: false });
			/// </summary>
			showFooter: false,

			/// <summary>
			/// A value indicating whether group area is visible.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ showGroupArea: false });
			/// </summary>
			showGroupArea: false,

			/// <summary>
			/// A value indicating whether the row header is visible.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ showRowHeader: false });
			/// </summary>
			showRowHeader: false,

			/*dma> Commented by YK for removing unsupported options.
			/// <summary>
			/// A value indicating whether the grid view should split content into several views with the ability to resize and scroll each view independently.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ splits: false });
			/// </summary>
			splits: false,

			/// <summary>
			/// Determines the distance in pixels for the vertical splitter. Applicable when the splits option is true.
			/// Default: 50.
			/// Type: Number.
			/// Code example: $("#element").wijgrid({ splitDistanceX: 50 });
			/// </summary>
			splitDistanceX: 50,

			/// <summary>
			/// Determines the distance in pixels for the horizontal splitter. Applicable when the splits option is true.
			/// Default: 50.
			/// Type: Number.
			/// Code example: $("#element").wijgrid({ splitDistanceY: 50 });
			/// </summary>
			splitDistanceY: 50,*/

			/// <summary>
			/// Indicates the index of columns that will always be shown on the left when the grid view scrolled horizontally. 
			/// Note, that all columns before the static column will be automatically marked as static, too.
			/// It can only take effect when scrollMode is not "none".
			/// It will be considered as -1 when grouping or row merging is enabled.
			/// -1 means no data column but row header is static.
			/// 0 means one data column and row header are static.
			///
			/// Default: -1.
			/// Type: Number.
			/// Code example: $("#element").wijgrid({ staticColumnIndex: -1 });
			/// </summary>
			staticColumnIndex: -1,

			/// <summary>
			/// Indicates the index of data rows that will always be shown on the
			/// top when the wijgrid is scrolled vertically.
			/// Note, that all rows before the static row
			/// will be automatically marked as static, too.
			/// It can only take effect when scrollMode is not "none".
			/// It will be considered as -1 when grouping or row merging is enabled.
			/// -1 means no data row but header row is static.
			/// 0 means one data row and header row are static.
			///
			/// Default: -1.
			/// Type: Number.
			/// Code example: $("#element").wijgrid({ staticRowIndex: -1 });
			/// </summary>
			staticRowIndex: -1,
			/*<dma*/

			/* --- events */

			/// <summary>
			/// The afterCellEdit event handler. A function called after editing is completed.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the afterCellEdit event:
			/// $("#element").wijgrid({ afterCellEdit: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridaftercelledit", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.cell: gets the edited cell's information.
			/// args.event: event that initiated the cell updating.
			/// args.handled: gets or sets value determining whether the developer finalizes editing of the cell manually.
			///   The default value is false which means that the widget will try to finalize editing of the cell automatically.
			///   If the developer provides a custom editing front end then this property must be set to true.
			/// </param>
			afterCellEdit: null,

			/// <summary>
			/// The afterCellUpdate event handler. A function called after a cell has been updated.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the afterCellUpdate event:
			/// $("#element").wijgrid({ afterCellUpdate: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridaftercellupdate", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.cell: gets the edited cell's information.
			/// </param>
			afterCellUpdate: null,

			/// <summary>
			/// The beforeCellEdit event handler. A function called before a cell enters edit mode. Cancellable.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the beforeCellEdit event:
			/// $("#element").wijgrid({ beforeCellEdit: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridbeforecelledit", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.cell: information about the cell to be edited.
			/// args.event: event initiated cell editing.
			/// args.handled: gets or sets a value determining whether developer initiates cell editor(s) manually.
			///   The default value is false which means that widget will trying to provide editing control automatically.
			///   If cells contain custom controls or if developer wants to provide a custom editing front end then he
			///   must set this property to true.
			///</param>
			beforeCellEdit: null,

			/// <summary>
			/// The beforeCellUpdate event handler. A function called before a cell is updated.
			/// Default: null.
			/// Type: Function.
			///
			/// Code example:
			/// Supply a callback function to handle the beforeCellUpdate event:
			/// $("#element").wijgrid({ beforeCellUpdate: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridbeforecellupdate", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.cell: gets information of the edited cell.
			/// args.value: returns the new cell value. If the property value is not changed the widget will try to
			///   extract the new cell value automatically. If the developer provides custom editing front end then
			///   the new cell value must be returned within this property.
			/// </param>
			beforeCellUpdate: null,

			/// <summary>
			/// The columnDragging event handler. A function called when column dragging is started, but before wijgrid handles the operation. Cancellable.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the columnDragging event:
			/// $("#element").wijgrid({ columnDragging: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridcolumndragging", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.drag: drag source, column being dragged.
			/// args.dragSource: the place where the dragged column widget is located, possible value: "groupArea", "columns".
			/// </param>
			columnDragging: null,

			/// <summary>
			/// The columnDragged event handler. A function called when column dragging has been started.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the columnDragged event:
			/// $("#element").wijgrid({ columnDragged: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridcolumndragged", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.drag: drag source, column being dragged.
			/// args.dragSource: the place where the dragged column widget is located, possible value: "groupArea", "columns".
			/// </param>
			columnDragged: null,

			/// <summary>
			/// The columnDropping event handler. A function called when column is dropped into the columns area, but before wijgrid handles the operation. Cancellable.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the columnDropping event:
			/// $("#element").wijgrid({ columnDropping: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridcolumndropping", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.drag: drag source, column being dragged.
			/// args.drop: drop target, column on which drag source is dropped.
			/// args.at: position to drop (one of the "left", "right" and "center" values) relative to drop target.
			/// </param>
			columnDropping: null,

			/// <summary>
			/// The columnDropped event handler. A function called when column has been dropped into the columns area.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the columnDropped event:
			/// $("#element").wijgrid({ columnDropped: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridcolumndropped", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.drag: drag source, column being dragged.
			/// args.drop: drop target, column on which drag source is dropped.
			/// args.at: position to drop (one of the "left", "right" and "center" values) relative to drop target.
			/// </param>
			columnDropped: null,

			/// <summary>
			/// The columnGrouping event handler. A function called when column is dropped into the group area, but before wijgrid handles the operation. Cancellable.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the columnGrouping event:
			/// $("#element").wijgrid({ columnGrouping: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridcolumngrouping", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.drag: drag source, column being dragged.
			/// args.drop: drop target, column on which drag source is dropped (be null if dropping a column into empty group area).
			/// args.dragSource: the place where the dragged column widget is located, possible value: "groupArea", "columns".
			/// args.dropSource: the place where the dropped column widget is located, possible value: "groupArea", "columns".
			/// args.at: position to drop (one of the "left", "right" and "center" values) relative to drop target ("left" if dropping a column into empty group area).
			/// </param>
			columnGrouping: null,

			/// <summary>
			/// The columnGrouped event handler. A function called when column has been dropped into the group area.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the columnGrouped event:
			/// $("#element").wijgrid({ columnGrouped: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridcolumngrouped", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.drag: drag source, column being dragged.
			/// args.drop: drop target, column on which drag source is dropped (null if dropping a column into empty group area).
			/// args.dragSource: the place where the dragged column is located, possible values: "groupArea", "columns".
			/// args.dropSource: the place where the dropped column is located, possible values: "groupArea", "columns".
			/// args.at: position to drop (one of the "left", "right" and "center" values) relative to drop target ("left" if dropping a column into empty group area).
			/// </param>
			columnGrouped: null,

			/// <summary>
			/// The columnResizing event handler. A function called when column is resized, but before wijgrid handles the operation. Cancellable.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the columnResizing event:
			/// $("#element").wijgrid({ columnResizing: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridcolumnresizing", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.column: column that is being resized.
			/// args.oldWidth: the old width of the column before resized.
			/// args.newWidth: the new width being set to the column.
			/// </param>
			columnResizing: null,

			/// <summary>
			/// The columnResized event handler. A function called when column has been resized.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the columnResized event:
			/// $("#element").wijgrid({ columnResized: function (e) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridcolumnresized", function (e) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.column: column that is being resized.
			/// </param>
			columnResized: null,

			/// <summary>
			/// The columnUngrouping event handler. A function called when column is removed from the group area, but before wijgrid handles the operation. Cancellable.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the columnUngrouping event:
			/// $("#element").wijgrid({ columnUngrouping: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridcolumnungrouping", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.column: column being removed.
			/// </param>
			columnUngrouping: null,

			/// <summary>
			/// The columnUngrouped event handler. A function called when column has been removed from the group area.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the columnUngrouped event:
			/// $("#element").wijgrid({ columnUngrouped: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridcolumnungrouped", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.column: column being removed.
			/// </param>
			columnUngrouped: null,

			/// <summary>
			/// The currentCellChanging event handler. A function called before the current cell is changed. Cancellable.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the currentCellChanging event:
			/// $("#element").wijgrid({ currentCellChanging: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridcurrentcellchanging", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.cellIndex: new cell index.
			/// args.rowIndex: new row index.
			/// args.oldCellIndex: old cell index.
			/// args.oldRowIndex: old row index.
			/// </param>
			currentCellChanging: null,

			/// <summary>
			/// The currentCellChanged event handler. A function called after the current cell is changed.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the currentCellChanged event:
			/// $("#element").wijgrid({ currentCellChanged: function (e) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridcurrentcellchanged", function (e) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			currentCellChanged: null,

			/// <summary>
			/// The filterOperatorsListShowing event handler. A function called before the filter drop-down list is shown.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the filterOperatorsListShowing event:
			/// $("#element").wijgrid({ filterOperatorsListShowing: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridfilteroperatorslistshowing", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.column: associated column.
			/// args.operators: An array of filter operators.
			/// </param>
			filterOperatorsListShowing: null,

			/// <summary>
			/// The filtering event handler. A function called before the filtering operation is started. Cancellable.
			/// Type: Function.
			/// Default: null.
			/// Code example:
			/// Supply a callback function to handle the filtering event:
			/// $("#element").wijgrid({ filtering: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridfiltering", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.column: column that is being filtered.
			/// args.operator: new filter operator name.
			/// args.value: new filter value.
			/// </param>
			filtering: null,

			/// <summary>
			/// The filtered event handler. A function called after the wijgrid is filtered.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the filtered event:
			/// $("#element").wijgrid({ filtered: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridfiltered", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.column: column that is being filtered.
			/// </param>
			filtered: null,

			/// <summary>
			/// The groupAggregate event handler. A function called when groups are being created and the "aggregate" option of the column object has been set to "custom".
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the groupAggregate event:
			/// $("#element").wijgrid({ groupAggregate: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridgroupaggregate", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.data: data object.
			/// args.column: column that is being grouped.
			/// args.groupByColumn: column initiated grouping.
			/// args.groupText: text that is being grouped.
			/// args.text: text that will be displayed in the group header or group footer.
			/// args.groupingStart: first index for the data being grouped.
			/// args.groupingEnd: last index for the data being grouped.
			/// args.isGroupHeader: indicates whether row that is being grouped is a group header or not.
			/// </param>
			groupAggregate: null,

			/// <summary>
			/// The groupText event handler. A function called when groups are being created and the groupInfo.headerText or groupInfo.footerText of the groupInfo option has been set to "custom".
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the groupText event:
			/// $("#element").wijgrid({ groupText: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridgrouptext", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.data: data object.
			/// args.column: column that is being grouped.
			/// args.groupByColumn: column initiated grouping.
			/// args.groupText: text that is being grouped.
			/// args.text: text that will be displayed in the group header or group footer.
			/// args.groupingStart: first index for the data being grouped.
			/// args.groupingEnd: last index for the data being grouped.
			/// args.isGroupHeader: indicates whether the row that is being grouped is a group header or not.
			/// args.aggregate: aggregate value.
			/// </param>
			groupText: null,

			/// <summary>
			/// The invalidCellValue event handler. A function called when a cell needs to start updating but the cell value is invalid.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the invalidCellValue event:
			/// $("#element").wijgrid({ invalidCellValue: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridinvalidcellvalue", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.cell: gets the information of edited cell.
			/// args.value: current value.
			/// </param>
			invalidCellValue: null,

			/// <summary>
			/// The pageIndexChanging event handler. A function called before page index is changed. Cancellable.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the pageIndexChanging event:
			/// $("#element").wijgrid({ pageIndexChanging: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridpageindexchanging", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.newPageIndex: new page index.
			/// </param>
			pageIndexChanging: null,

			/// <summary>
			/// The pageIndexChanged event handler. A function called after page index is changed.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the pageIndexChanged event:
			/// $("#element").wijgrid({ pageIndexChanged: function (e) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridpageindexchanged", function (e) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			pageIndexChanged: null,

			/// <summary>
			/// The selectionChanged event handler. A function called after the selection is changed.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the selectionChanged event:
			/// $("#element").wijgrid({ selectionChanged: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridselectionchanged", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.addedCells: cells added to the selection.
			/// args.removedCells: cells removed from the selection.
			/// </param>
			selectionChanged: null,

			/// <summary>
			/// The sorting event handler. A function called before the sorting operation is started. Cancellable.
			/// Type: Function.
			/// Default: null.
			/// Code example:
			/// Supply a callback function to handle the sorting event:
			/// $("#element").wijgrid({ sorting: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridsorting", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.column: column that is being sorted.
			/// args.sortDirection: new sort direction.
			/// </param>
			sorting: null,

			/// <summary>
			/// The sorted event handler. A function called after the widget is sorted.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the sorted event:
			/// $("#element").wijgrid({ sorted: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridsorted", function (e, args) { });
			/// </summary>
			///
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data with this event.
			/// args.column: column that is being sorted.
			/// </param>
			sorted: null,

			/* events --- */

			/* --- life-cycle events */
			/// <summary>
			/// The ajaxError event handler. A function called when wijgrid is bound to remote data and
			/// the ajax request fails.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the ajaxError event:
			/// $("#element").wijgrid({ ajaxError: function (e, args) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridajaxerror", function (e, args) { });
			/// </summary>
			/// <param name="e" type="Object">jQuery.Event object.</param>
			/// <param name="args" type="Object">
			/// The data corresponded with this event.
			/// args.XMLHttpRequest: the XMLHttpRequest object.
			/// args.textStatus: a string describing the error type.
			/// args.errorThrown: an exception object.
			///
			/// Refer to the jQuery.ajax.error event documentation for more details on this arguments.
			/// </param>
			ajaxError: null,

			/// <summary>
			/// The dataLoading event handler. A function called when wijgrid loads a portion of data from the underlying datasource.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the dataLoading event:
			/// $("#element").wijgrid({ dataLoading: function (e) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgriddataloading", function (e) { });
			/// </summary>
			/// <param name="e" type="Object">jQuery.Event object.</param>
			dataLoading: null,

			/// <summary>
			/// The dataLoaded event handler. A function called when data are loaded.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the dataLoaded event:
			/// $("#element").wijgrid({ dataLoaded: function (e) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgriddataloaded", function (e) { });
			/// </summary>
			/// <param name="e" type="Object">jQuery.Event object.</param>
			dataLoaded: null,

			/// <summary>
			/// The loading event handler. A function called at the beginning of the wijgrid's lifecycle.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the loading event:
			/// $("#element").wijgrid({ loading: function (e) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridloading", function (e) { });
			/// </summary>
			/// <param name="e" type="Object">jQuery.Event object.</param>
			loading: null,

			/// <summary>
			/// The loaded event handler. A function called at the end the wijgrid's lifecycle when wijgrid is
			/// filled with data and rendered.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the loaded event:
			/// $("#element").wijgrid({ loaded: function (e) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridloaded", function (e) { });
			/// </summary>
			/// <param name="e" type="Object">jQuery.Event object.</param>
			loaded: null,

			/// <summary>
			/// The rendering event handler. A function called when wijgrid is about to render.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the rendering event:
			/// $("#element").wijgrid({ rendering: function (e) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridrendering", function (e) { });
			/// </summary>
			/// <param name="e" type="Object">jQuery.Event object.</param>
			rendering: null,

			/// <summary>
			/// The rendered event handler. A function called when wijgrid is rendered.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a callback function to handle the rendered event:
			/// $("#element").wijgrid({ rendered: function (e) { } });
			/// Bind to the event by type:
			/// $("#element").bind("wijgridrendered", function (e) { });
			/// </summary>
			/// <param name="e" type="Object">jQuery.Event object.</param>
			rendered: null

			/* life-cycle events --- */
		},

		// private fields **
		//_staticColumnIndex: -1,
		_data$prefix: "wijgrid",
		_customSortOrder: 1000,
		_reverseKey: false,
		_pageSizeKey: 10,
		_mergeWidgetsWithOptions: true,
		// ** private fields

		_ajaxError: function (xhttpr, textStatus, error) {
			this._trigger("ajaxError", null, {
				XMLHttpRequest: xhttpr,
				textStatus: textStatus,
				errorThrown: error
			});

			this._deactivateSpinner();
		},

		_dataLoading: function (userData) {
			this._trigger("dataLoading");
		},

		_dataLoaded: function (userData) {
			this._trigger("dataLoaded");

			this.doRefresh(userData);

			this._loaded();
		},

		_loading: function () {
			this._activateSpinner();
			this._trigger("loading");
		},

		_loaded: function () {
			this._deactivateSpinner();
			this._trigger("loaded");
		},

		ensureControl: function (loadData, userData) {
			/// <summary>
			/// Moves column widgets options to wijgrid options and renders wijgrid
			/// Code example: $("#element").wijgrid("ensureControl", true);
			/// </summary>
			/// <param name="loadData" type="Boolean">Determines if wijgrid must load data from linked data source before rendering.</param>
			this._loading();

			if (!$.isPlainObject(userData)) {
				userData = {
					data: null,
					afterRefresh: null,
					beforeRefresh: null
				};
			}

			if (this._initialized) {
				if (this._mergeWidgetsWithOptions) {
					this._ownerise(false);
					this._widgetsToOptions();
				}
			} else {
				this._prepareColumnOptions(false); // prepare static columns only
			}

			this._ownerise(true);

			if (loadData === true) {
				this._dataStore.load(userData);
			} else {
				this.doRefresh(userData);
				this._loaded();
			}
		},

		doRefresh: function (userData) {
			/// <summary>
			/// Re-renders wijgrid.
			/// Code example: $("#element").wijgrid("doRefresh");
			/// </summary>
			if (!this._initialized) {
				try {
					this._prepareColumnOptions(true); // prepare static and dynamic columns
				}
				catch (e) {
					throw e;
				}
				finally {
					//ownerise the column for bug 16936, 17079
					this._ownerise(true);
					this._initialized = true;
				}
			} else {
				if (userData && $.isFunction(userData.beforeRefresh)) {
					userData.beforeRefresh.apply(this);
				}
			}

			this._rebuildLeaves(); // build leaves, visible leaves, set dataIndex etc

			var dataSlice = this._dataStore.getDataSlice(),
				table = dataSlice.data,
				leaves, ri, rowsLen, dataItem, newItem, i, len, leaf, tmp;

			$.each(this._field("leaves"), function () { // copy totals
				this._totalsValue = (dataSlice.totals)
						? dataSlice.totals[this.dataKey]
						: undefined;
			});

			this._setPageCount(dataSlice);

			leaves = this._field("leaves");
			this.dataTable = [];

			if (rowsLen = table.length) { // process data items
				for (ri = 0; ri < rowsLen; ri++) {
					dataItem = table[ri];
					newItem = [];

					for (i = 0, len = leaves.length; i < len; i++) {
						leaf = leaves[i];

						if ($.wijmo.wijgrid.validDataKey(leaf.dataKey)) {
							newItem.push({
								value: dataItem.values[leaf.dataKey],
								__attr: (dataItem.attributes) ? dataItem.attributes.cellsAttributes[leaf.dataKey] : {},
								__style: {}
							});

							newItem.originalRowIndex = dataItem.originalRowIndex;
						}
					}

					newItem.rowType = $.wijmo.wijgrid.rowType.data;
					if (ri % 2 !== 0) {
						newItem.rowType |= $.wijmo.wijgrid.rowType.dataAlt;
					}

					newItem.__style = {};
					newItem.__attr = (dataItem.attributes) ? dataItem.attributes.rowAttributes : {};

					this.dataTable.push(newItem);
				}
			} else {
				// process empty data row
				if (dataSlice.emptyData && (rowsLen = dataSlice.emptyData.length)) {
					for (ri = 0; ri < rowsLen; ri++) {
						dataItem = dataSlice.emptyData[ri];
						newItem = [];
						tmp = this._field("visibleLeaves").length;

						for (i = 0, len = dataItem.length; i < len; i++) {
							newItem.push({
								html: dataItem[i],
								__attr: {
									colSpan: ((tmp > 0 && ri === rowsLen - 1)
										? tmp - ri
										: 1)
								},
								__style: {}
							});
						}

						newItem.rowType = $.wijmo.wijgrid.rowType.emptyDataRow;
						newItem.__style = {};
						newItem.__attr = {};

						this.dataTable.push(newItem);
					}
				}
			}

			this._trigger("rendering");
			this._refresh();
			this._trigger("rendered");

			if (userData && $.isFunction(userData.afterRefresh)) {
				userData.afterRefresh.apply(this);
			}
		},

		getFilterOperatorsByDataType: function (dataType) {
			/// <summary>
			/// Returns a one-dimensional array of filter operators which are applicable to the specified data type.
			/// Code example: var operators = $("#element").wijgrid("getFilterOperatorsByDataType", "string");
			/// <param name="dataType" type="String">Data type. Possible values are: "string", "number", "datetime", "currency" and "boolean".</param>
			/// </summary>
			/// <returns type="Array">A one-dimensional array of filter operators.</returns>

			var applicableFilters = this.filterOperatorsCache.getByDataType(dataType || "string");

			this.filterOperatorsCache.sort(applicableFilters, this.options.filterOperatorsSortMode);

			return applicableFilters;
		},

		setSize: function (width, height) {
			/// <summary>
			/// Set the size of grid.
			/// Code example: $("#element").wijgrid("setSize", 200, 200);
			/// <param name="width" type="Object" optional="true">Determines the width of the grid.</param>
			/// <param name="height" type="Object" optional="true">Determines the height of the grid.</param>
			/// </summary>
			var view = this._view(),
				scrollValue = { type: "", hScrollValue: null, vScrollValue: null },
				outerDiv = this.outerDiv,
				frozener = this._field("frozener"),
				visibleLeaves = this._field("visibleLeaves");

			if (view && view.getScrollValue) {
				scrollValue = view.getScrollValue();
			}

			if (width || (width === 0)) {
				this._autoWidth = false;
				outerDiv.width(width);
			}
			if (height || (height === 0)) {
				this._autoHeight = false;
				outerDiv.height(height);
			}

			$.each(visibleLeaves, function (index, leaf) {
				var th = view.getHeaderCell(index),
					cols = view.getJoinedCols(index);
				$(th).css("width", "");
				$.each(cols, function (index, col) {
					$(col).css("width", "");
				});
			});

			this._updateSplits(scrollValue);

			if (frozener) {
				frozener.refresh();
			}
		},

		_prepareColumnOptions: function (dataLoaded) {
			$.wijmo.wijgrid.traverse(this.options.columns, function (column) {
				column.isBand = ($.isArray(column.columns) || (column.clientType === "c1band"));
			});

			// set .isLeaf
			new $.wijmo.wijgrid.bandProcessor()._getVisibleHeight(this.options.columns, true);

			// prepare leaves
			var leaves = [],
				boundedToDOM,
				headerRow = this._originalHeaderRowData(),
				footerRow = this._originalFooterRowData(),
				autogenerationMode = (this.options.columnsAutogenerationMode || "").toLowerCase();

			if (dataLoaded) {
				boundedToDOM = this._dataStore.dataMode() === $.wijmo.wijgrid.dataMode.dom;

				if (autogenerationMode !== "none") {
					(new $.wijmo.wijgrid.columnsGenerator(this)).generate(autogenerationMode, this._dataStore, this.options.columns);
				}
			}

			$.wijmo.wijgrid.setTraverseIndex(this.options.columns); // build indices (linearIdx, travIdx, parentIdx)

			// * merge options with defaults and build "pure" leaves list.
			$.wijmo.wijgrid.traverse(this.options.columns, function (column) {
				// merge options **
				column.isBand = ($.isArray(column.columns) || (column.clientType === "c1band"));

				$.wijmo.wijgrid.shallowMerge(column, $.wijmo.c1basefield.prototype.options); // merge with the c1basefield default options

				if (!column.isBand) {
					$.wijmo.wijgrid.shallowMerge(column, $.wijmo.c1field.prototype.options); // merge with the c1field default options

					if (!column.clientType) {
						column.clientType = "c1field";
					}
				} else {
					column.clientType = "c1band";
				}
				// ** merge options

				if (column.isLeaf && !column.isBand) {
					leaves.push(column);
				}
			});

			this._field("leaves", leaves); // contains static columns only when dataLoaded == false, used by the "dynamic data load" feature during request initialization.

			if (dataLoaded) {
				// assume headerText and footerText
				$.each(leaves, function (i, leaf) {
					var thIndex = (typeof (leaf.dataKey) === "number")
						? leaf.dataKey
						: i;

					if (autogenerationMode === "merge" || leaf.dynamic === true) { // assume headerText options of the static columns only when using "merge" mode.
						if (leaf.headerText === undefined) {
							if (boundedToDOM && headerRow && (thIndex < headerRow.length)) {
								leaf.headerText = $.trim(headerRow[thIndex]); // copy th
							} else {
								if ($.wijmo.wijgrid.validDataKey(leaf.dataKey)) {
									leaf.headerText = "" + leaf.dataKey; // copy dataKey
								}
							}
						}
					}

					if (boundedToDOM && footerRow && (thIndex < footerRow.length)) {
						leaf._footerTextDOM = $.trim(footerRow[thIndex]);
					}
				});

			}
		},

		_rebuildLeaves: function () {
			var tmpColumns = [],
				leaves = [],
				tmp;

			if (this.options.showRowHeader) { // append rowHeader
				tmp = $.wijmo.wijgrid.createDynamicField({ clientType: "c1basefield", dataIndex: -1, travIdx: -1, parentVis: true,
					allowMoving: false, allowSizing: false, allowSort: false, isRowHeader: true
				});
				tmp.owner = this;
				tmpColumns.push(tmp);
			}

			$.each(this.options.columns, function (index, item) {
				tmpColumns.push(item); // append columns
			});

			// generate span table and build leaves
			this._field("columnHeadersTable", new $.wijmo.wijgrid.bandProcessor().generateSpanTable(tmpColumns, leaves));
			this._field("leaves", leaves);

			this._onLeavesCreated();
		},

		_onLeavesCreated: function () {
			var leaves = this._field("leaves"),
				dataIndex = 0,
				visLeavesIdx = 0,
				self = this;

			// build visible leaves list, set dataParsers, dataIndices
			this._field("visibleLeaves", $.grep(leaves, function (leaf, index) {
				leaf.leavesIdx = index;

				if ($.wijmo.wijgrid.validDataKey(leaf.dataKey)) {
					leaf.dataIndex = dataIndex++;
				} else {
					leaf.dataIndex = -1;
				}

				// attach data parser **
				if (!leaf.isBand) {
					self._ensureDataParser(leaf);

					if ($.isFunction(leaf.dataParser)) {
						leaf.dataParser = new leaf.dataParser();
					}
				}
				// ** attach data parser

				if (leaf.parentVis) {
					leaf.visLeavesIdx = visLeavesIdx++;
					return true;
				}

				return false;
			}));
		},

		_create: function () {
			if (!this.element.is("table")) {
				throw "invalid markup";
			}

			// handle juice objectValue serialize
			if ($.isFunction(window["wijmoASPNetParseOptions"])) {
				wijmoASPNetParseOptions(this.options);
			}

			this.destroyed = false;

			var styleHeight = this.element[0].style.height,
				styleWidth = this.element[0].style.width;

			// initialize data
			this._dataStore = new $.wijmo.wijgrid.dataStore(this);

			this._originalHtml = this.element.html(); // store original html. Will be restored in the destroy() method.

			this.element.addClass("wijmo-wijgrid-root");
			this.element.wrap("<div class=\"ui-widget wijmo-wijgrid ui-widget-content ui-corner-all\"></div>");
			this.outerDiv = this.element.parent();

			// -
			//this.outerDiv.css({ "height": this.element.css("height"), "width": this.element.css("width") });
			if (styleHeight) {
				this.outerDiv.css("height", this.element[0].style.height);
			}

			if (styleHeight !== "" && styleHeight !== "auto") {
				this._autoHeight = false;
			}
			else {
				this._autoHeight = true;
			}

			if (styleWidth) {
				this.outerDiv.css("width", this.element[0].style.width);
			}

			if (styleWidth !== "" && styleWidth !== "auto") {
				this._autoWidth = false;
			}
			else {
				this._autoWidth = true;
			}

			this.element.css({ "height": "", "width": "" });
			// -

			this.filterOperatorsCache = new $.wijmo.wijgrid.filterOperatorsCache();

			// process build-in filtering operators
			this._registerFilterOperator($.wijmo.wijgrid.embeddedFilters);

			if (this.options.disabled) {
				this.disable();
			}

			// formatters
			this.cellFormatter = new $.wijmo.wijgrid.cellFormatterHelper();
			this.rowStyleFormatter = new $.wijmo.wijgrid.rowStyleFormatterHelper(this);
			this.cellStyleFormatter = new $.wijmo.wijgrid.cellStyleFormatterHelper(this);
		},

		_init: function () {
			this.$superPanelHeader = null;
			this.$topPagerDiv = null;
			this.$bottomPagerDiv = null;
			this.$groupArea = null;

			// processing custom filtering operators
			this.filterOperatorsCache.removeCustom();
			$.each(this.options.customFilterOperators, function (index, value) {
				if (value) {
					value.custom = true;
				}
			});
			this._registerFilterOperator(this.options.customFilterOperators);

			// culture
			this._field("closestCulture", Globalize.findClosestCulture(this.options.culture) || Globalize.findClosestCulture("default"));

			if (!this.options.data) { // dataSource is a domTable
				if (!this._field("thead")) { // read tHead section
					this._field("thead", $.wijmo.wijgrid.readTableSection(this.element, 1));
				}

				if (!this._field("tfoot")) { // read tFoot section
					this._field("tfoot", $.wijmo.wijgrid.readTableSection(this.element, 3));
				}
			}

			this._initialized = this._initialized || false; // to avoid reinitialization.

			this.ensureControl(true);
		},

		_setOption: function (key, value) {
			var presetFunc = this["_preset_" + key],
				oldValue = this.options[key],
				optionChanged, postsetFunc;

			if (presetFunc !== undefined) {
				value = presetFunc.apply(this, [value, oldValue]);
			}

			optionChanged = (value !== oldValue);

			//$.Widget.prototype._setOption.apply(this, arguments); note: there is no dynamic linkage between the arguments and the formal parameter values when strict mode is used
			$.Widget.prototype._setOption.apply(this, [key, value]); // update this.options

			if (optionChanged) {
				postsetFunc = this["_postset_" + key];
				if (postsetFunc !== undefined) {
					postsetFunc.apply(this, [value, oldValue]);
				}
			}
		},

		destroy: function () {
			///	<summary>
			///	Destroy wijgrid widget and reset the DOM element.
			/// Code example: $("#element").wijgrid("destroy");
			///	</summary>

			var tmp,
				self = this;

			try {
				this._view().dispose();

				this._detachEvents(true);

				if (tmp = this._field("resizer")) {
					tmp.dispose();
				}

				if (tmp = this._field("frozener")) {
					tmp.dispose();
				}

				$.wijmo.wijgrid.iterateChildrenWidgets(this.outerDiv, function (index, widget) {
					if (widget !== self) {
						widget.destroy();
					}
				});

				if (tmp = this._field("selectionui")) {
					tmp.dispose();
				}

				if (tmp = this._field("dragndrop")) {
					tmp.dispose();
				}

				// cleanup $data
				$.wijmo.wijgrid.remove$dataByPrefix(this.element, this._data$prefix);

				// restore original content
				this.element.removeClass("wijmo-wijgrid-root");
				this.element.html(this._originalHtml);
				this.element.insertBefore(this.outerDiv);
				this.outerDiv.remove();

				$.Widget.prototype.destroy.apply(this, arguments);
			}
			finally {
				this.destroyed = true;
			}
		},

		// * public
		columns: function () {
			/// <summary>
			/// Returns a one-dimensional array of widgets bound to visible column headers.
			/// Code example: var colWidgets = $("#element").wijgrid("columns");
			/// </summary>
			/// <returns type="Array" elementType="$.wijmo.c1basefield">A one-dimensional array of widgets bound to visible column headers.</returns>
			return this._field("columns") || [];
		},

		currentCell: function (cellInfo /* cellIndex */, rowIndex /* opt */) {
			/// <summary>
			/// Gets or sets the current cell for the grid.
			/// Note: Use (-1, -1) value to hide the current cell.
			/// Code example:
			/// -) Getter:
			///   var current = $("#element).wijgrid("currentCell");
			/// -) Setter:
			///   $("#element).wijgrid("currentCell", new $.wijmo.wijgrid.cellInfo(0, 0));
			///   or
			///   $("#element).wijgrid("currentCell", 0, 0);
			/// </summary>
			/// <param name="cellInfo" type="$.wijmo.wijgrid.cellInfo">Object that represents a single cell.</param>
			/// <param name="cellIndex" type="Number" integer="true" optional="true">Zero-based index of the required cell inside the corresponding row.</param>
			/// <param name="rowIndex" type="Number" integer="true" optional="true">Zero-based index of the row that contains required cell.</param>
			/// <returns type="$.wijmo.wijgrid.cellInfo">Object that represents current cell of the grid</returns>

			var currentCell;

			if (arguments.length === 0) { // getter
				currentCell = this._field("currentCell");
				if (!currentCell) {
					this._field("currentCell", currentCell = $.wijmo.wijgrid.cellInfo.prototype.outsideValue);
				}
				return currentCell;
			} else { // setter

				currentCell = (arguments.length === 1)
					? cellInfo._clone()
					: new $.wijmo.wijgrid.cellInfo(cellInfo, rowIndex);

				if (!currentCell.isEqual($.wijmo.wijgrid.cellInfo.prototype.outsideValue)) {
					if (!currentCell._isValid()) {
						throw "invalid arguments";
					}

					currentCell._clip(this._getDataCellsRange());

					if (currentCell.rowIndex() >= 0 && !(this.dataTable[currentCell.rowIndex()].rowType & $.wijmo.wijgrid.rowType.data)) {
						return;
					}
				}

				currentCell._setGridView(this);

				this._changeCurrentCell(currentCell);

				return this._field("currentCell");
			}
		},

		data: function () {
			/// <summary>
			/// Gets a array of the underlying data.
			/// Code example: var data = $("#element").wijgrid("data");
			/// </summary>
			/// <returns type="Array"></returns>
			return this._dataStore.dataSource().items;
		},

		selection: function () {
			/// <summary>
			/// Gets an object that manages selection in the grid.
			/// Code example:
			///   var selection = $("#element").wijgrid("selection");
			/// </summary>
			/// <returns type="$.wijmo.wijgrid.selection">Object that manages selection in the grid.</returns>
			var selection = this._field("selection");
			if (!selection) {
				this._field("selection", selection = new $.wijmo.wijgrid.selection(this));
			}
			return selection;
		},

		beginEdit: function () {
			/// <summary>
			/// Puts the current cell in editing mode.
			/// Note: works only if the allowEditing option is set to true.
			/// Code example: $("#element").wijgrid("beginEdit");
			/// </summary>
			/// <returns type="Boolean">True if the cell is successfully put in edit mode, otherwise false.</returns>
			return this._beginEditInternal(null);
		},

		endEdit: function () {
			/// <summary>
			/// Finishes editing the current cell.
			/// Code example: $("#element").wijgrid("endEdit");
			/// </summary>
			return this._endEditInternal(null);
		},

		pageCount: function () {
			/// <summary>
			/// Gets the number of pages.
			/// Code example:
			/// var pageCount = $("#element").wijgrid("pageCount");
			/// </summary>
			/// <returns type="Number" integer="true"></returns>
			return this.options.allowPaging
				? this._field("pageCount") || 1
				: 1;
		},

		// * public
		_dragndrop: function () {
			var dnd = this._field("dragndrop");

			if (!dnd) {
				this._field("dragndrop", dnd = new $.wijmo.wijgrid.dragAndDropHelper(this));
			}

			return dnd;
		},

		_headerRows: function () {
			var accessor = this._field("headerRowsAccessor"),
				bottomOffset;

			if (!accessor) {
				bottomOffset = this.options.showFilter ? 1 : 0;
				this._field("headerRowsAccessor", accessor = new $.wijmo.wijgrid.rowAccessor(this._view(), 1 /* thead */, 0, bottomOffset));
			}

			return accessor;
		},

		_filterRow: function () {
			if (this.options.showFilter) {
				var tHeadAccessor = new $.wijmo.wijgrid.rowAccessor(this._view(), 1 /* thead */, 0, 0);

				return tHeadAccessor.item(tHeadAccessor.length() - 1); // filter is the last row in the tHead section
			}

			return null;
		},

		_localizeFilterOperators: function (locArray) {
			var self = this;
			$.each(locArray, function (i, o) {
				if (o.name) {
					var fop = self.filterOperatorsCache.getByName(o.name);
					if (fop) {
						fop.displayName = o.displayName;
					}
				}
			});
		},

		_rows: function () {
			var accessor = this._field("rowsAccessor");

			if (!accessor) {
				this._field("rowsAccessor", accessor = new $.wijmo.wijgrid.rowAccessor(this._view(), 2 /* tbody */, 0, 0));
			}

			return accessor;
		},

		_selectionui: function () {
			var selectionui = this._field("selectionui");

			if (!selectionui) {
				this._field("selectionui", selectionui = new $.wijmo.wijgrid.selectionui(this));
			}

			return selectionui;
		},

		_setPageCount: function (dataSlice) {
			this._field("pageCount", Math.ceil(dataSlice.totalRows / this.options.pageSize) || 1);
		},

		_registerFilterOperator: function (value) {
			var self = this,
				sourceList = value && ($.isArray(value) || ($.isPlainObject(value) && !value.operator))
					? value // operators array or operators hash
					: arguments; // single or multiple operators passed as parameters.

			$.each(sourceList, function (key, fop) {
				self.filterOperatorsCache.add(fop);
			});
		},

		//

		// * propeties (pre-\ post-)
		_postset_allowColMoving: function (value, oldValue) {
			var self = this;

			$.each(this.columns(), function (idx, wijField) {
				if (value) {
					self._dragndrop().attach(wijField);
				} else {
					self._dragndrop().detach(wijField);
				}
			});

			$.each(this._field("groupedWidgets"), function (idx, wijField) {
				if (value) {
					self._dragndrop().attach(wijField);
				} else {
					self._dragndrop().detach(wijField);
				}
			});
		},

		_postset_allowSorting: function (value, oldValue) {
			this.ensureControl(false);
		},

		_postset_columns: function (value, oldValue) {
			throw "read-only";
		},

		_postset_allowPaging: function (value, oldValue) {
			this.ensureControl(true);
		},

		_postset_culture: function (value, oldValue) {
			//this._field("closestCulture", Globalize.findClosestCulture(this.options.culture));
			throw "read-only";
		},

		_postset_customFilterOperators: function (value, oldValue) {
			this.filterOperatorsCache.removeCustom();
			$.each(this.options.customFilterOperators, function (index, value) {
				value.custom = true;
			});
			this._registerFilterOperator(value);
		},

		_postset_data: function (value, oldValue) {
			throw "read-only";
		},

		_postset_disabled: function (value, oldValue) {
			// update children widgets
			var self = this,
				view = this._view();

			$.wijmo.wijgrid.iterateChildrenWidgets(this.outerDiv, function (index, widget) {
				if (widget !== self) {
					widget.option("disabled", value);
				}
			});


			if (view) {
				view.ensureDisabledState();
			}
		},

		_postset_groupIndent: function (value, oldValue) {
			this.ensureControl(false);
		},

		_postset_groupAreaCaption: function (value, oldValue) {
			var groupedColumns = this._field("groupedColumns");

			if (this.$groupArea && (!groupedColumns || !groupedColumns.length)) { // update html when the group area is empty only.
				this.$groupArea.html(value || "&nbsp;");
			}
		},

		_postset_highlightCurrentCell: function (value, oldValue) {
			var currentCell = this.currentCell();

			if (currentCell && currentCell._isValid()) {
				this._highlightCellPosition(currentCell, value);
			}
		},

		_preset_pageIndex: function (value, oldValue) {
			if (isNaN(value)) {
				throw "out of range";
			}

			var pageCount = this.pageCount();

			if (value > pageCount - 1) {
				value = pageCount - 1;
			}

			if (value < 0) {
				value = 0;
			}

			if (this.options.allowPaging && value !== oldValue) {
				if (!this._onPageIndexChanging({ newPageIndex: value })) {
					value = oldValue;
				}
			}

			return value;
		},

		_postset_pageIndex: function (value, oldValue) {
			if (this.options.allowPaging) {
				this.ensureControl(true, {
					afterRefresh: function () { this._onPageIndexChanged(); }
				});
			}
		},

		_preset_pageSize: function (value, oldValue) {
			if (isNaN(value)) {
				throw "out of range";
			}

			if (value <= 0) {
				value = 1;
			}

			return value;
		},

		_postset_pageSize: function (value, oldValue) {
			this.options.pageIndex = 0;

			if (this.options.allowPaging) {
				this.ensureControl(true);
			}
		},

		_postset_pagerSettings: function (value, oldValue) {
			this.ensureControl(false);
		},

		_postset_scrollMode: function (value, oldValue) {
			if (value === "none" || oldValue === "none") { // wijsuperpanel is enabled or disabled.
				this.ensureControl(false);
			} else { // wijsuperpanel is used, updating it.
				// refresh panel.
				this._view().refreshPanel();
			}
		},

		_postset_selectionMode: function (value, oldValue) {
			var selection = this.selection(),
				currentCell = this.currentCell();

			selection.beginUpdate();

			selection.clear();

			if (currentCell && currentCell._isValid()) {
				selection._selectRange(new $.wijmo.wijgrid.cellInfoRange(currentCell, currentCell), false, false, 0 /* none */, null);
			}

			selection.endUpdate();

			this._view().toggleDOMSelection(value === "none"); // disable or enable DOM selection
		},

		_postset_showFilter: function (value, oldValue) {
			this.ensureControl(false);
		},

		_postset_showGroupArea: function (value, oldValue) {
			this.ensureControl(false);
		},

		_postset_showRowHeader: function (value, oldValue) {
			this.ensureControl(false);
		},

		_postset_staticRowIndex: function () {
			if (this.options.scrollMode !== "none") { // staticRowIndex is ignored when scrolling is turned off.
				this.ensureControl(false);
			}
		},

		_postset_staticColumnIndex: function () {
			if (this.options.scrollMode !== "none") {
				this.ensureControl(false);
			}
		},

		// * propeties (pre-\ post-)

		// * private

		_activateSpinner: function () {
			var loadingText = this.outerDiv.append(
					"<div class=\"wijmo-wijgrid-overlay ui-widget-overlay\"></div>" +
					"<span class=\"wijmo-wijgrid-loadingtext ui-widget-content ui-corner-all\">" +
						"<span class=\"ui-icon ui-icon-clock\"></span>" +
						this.options.loadingText +
					"</span>")
					.find("> .wijmo-wijgrid-loadingtext");

			loadingText
				.position({
					my: "center",
					at: "center center",
					of: this.outerDiv,
					collision: "none"
				});
		},

		_deactivateSpinner: function () {
			this.outerDiv
				.find("> .wijmo-wijgrid-overlay, > .wijmo-wijgrid-loadingtext")
				.remove();
		},

		_columnWidgetsFactory: function ($node, columnOpt) {
			var columnWidget,
				clientType = columnOpt.clientType;

			if (!clientType && columnOpt.isBand) {
				clientType = "c1band";
			}

			//columnOpt.owner = this;
			columnOpt = $.extend({ owner: this }, columnOpt, { disabled: this.options.disabled });

			switch (clientType) {
				case "c1basefield":
					columnWidget = $node.c1basefield(columnOpt);
					break;

				case "c1band":
					columnWidget = $node.c1band(columnOpt);
					break;

				default:
					columnWidget = $node.c1field(columnOpt);
			}

			return columnWidget;
		},

		_field: function (name, value) {
			//return $.wijmo.wijgrid.dataPrefix(this.element, this._data$prefix, name, value);
			return $.wijmo.wijgrid.dataPrefix(this.element[0], this._data$prefix, name, value);
		},

		_removeField: function (name) {
			var internalDataName = this._data$prefix + name;

			this.element.removeData(internalDataName);
		},

		_changeRenderState: function ($obj, state, combine) {
			var $dp = $.wijmo.wijgrid.dataPrefix,
				prevState = $dp($obj, this._data$prefix, "renderState");

			if (combine) { // combine
				state = prevState | state;
				$dp($obj, this._data$prefix, "renderState", state);
			} else { // clear
				state = prevState & ~state;
				$dp($obj, this._data$prefix, "renderState", state);
			}

			return state;
		},

		_prepareFilterRequest: function (isLocal) {
			var leaves = this._field("leaves"),
				result;

			if (!leaves) {
				return [];
			}

			result = $.map(leaves, $.proxy(function (element, index) {
				if (!element.isBand && ($.wijmo.wijgrid.validDataKey(element.dataKey)/*element.dataIndex >= 0*/) && element.filterOperator) {
					var fvToVerify = $.extend(true, {}, { foo: element.filterValue }).foo, // to avoid string values reconstruction ("abc" -> ["a", "b", "c"])
						fopToVerify = $.extend(true, {}, { foo: element.filterOperator }).foo,
						verifiedFop = $.wijmo.wijgrid.filterHelper.verify(fopToVerify, fvToVerify, element.dataType, this.filterOperatorsCache);

					if (verifiedFop) {
						return (isLocal)
							? [{ column: element, filterOperator: verifiedFop.filterOperator, filterValue: verifiedFop.filterValue}]
							: [{ dataKey: element.dataKey, filterOperator: verifiedFop.filterOperator, filterValue: verifiedFop.filterValue}];
					}
				}

				return null;
			}, this));

			return result;
		},

		_preparePageRequest: function (isLocal) {
			if (this.options.allowPaging) {
				return {
					pageIndex: this.options.pageIndex,
					pageSize: this.options.pageSize
				};
			}
			return null;
		},

		_prepareSortRequest: function (isLocal) {
			var leaves = this._field("leaves"),
				result;

			if (!leaves || !this.options.allowSorting) {
				return [];
			}

			result = $.map(leaves, function (element, index) {
				var value = null;

				if (!element.isBand && element.allowSort && ($.wijmo.wijgrid.validDataKey(element.dataKey))) {
					if (element.groupInfo && (element.groupInfo.position !== "none") && (element.sortDirection === "none")) {
						element.sortDirection = "ascending"; // use "ascending" for grouped columns by default
					}

					value = (element.sortDirection === "ascending" || element.sortDirection === "descending")
						? [{ dataKey: element.dataKey,
							sortDirection: element.sortDirection,
							sortOrder: element.sortOrder || 0
						}]
						: null;
				}

				return value;
			});

			// sort by .sortOrder
			result.sort(function (a, b) {
				return a.sortOrder - b.sortOrder;
			});

			// remove .sortOrder
			$.each(result, function (idx, item) {
				//item.sortOrder = idx;
				delete item.sortOrder;
			});

			return result;
		},

		_prepareTotalsRequest: function (isLocal) {
			var leaves = this._field("leaves"),
				result;

			if (!leaves || !this.options.showFooter) {
				return [];
			}

			result = $.map(leaves, function (element, index) {
				if (!element.isBand && $.wijmo.wijgrid.validDataKey(element.dataKey) && element.aggregate && element.aggregate !== "none") {
					return (isLocal)
						? [{ column: element, aggregate: element.aggregate}]
						: [{ dataKey: element.dataKey, aggregate: element.aggregate}];
				}

				return null;
			});

			return result;
		},

		_widgetsToOptions: function () {
			var colOptionsList = $.wijmo.wijgrid.flatten(this.options.columns);

			$.each(this.columns(), function (index, colWidget) {
				delete colWidget.options.columns; // only options of the column itself will be merged at the next step.
				var congruentColOption = colOptionsList[colWidget.options.travIdx];
				$.extend(true, congruentColOption, colWidget.options);

				congruentColOption.filterValue = colWidget.options.filterValue;
				congruentColOption.filterOperator = colWidget.options.filterOperator;
			});
		},

		_recreateColumnWidgets: function () {
			$.each(this.columns(), function (index, item) {
				item.destroy();
			});

			var columns = [],
				headerRows = this._headerRows(),
				visibleColumns, i, len, column, headerRowObj, th, columnWidget;

			if (/* tHead.length*/headerRows && headerRows.length()) {
				visibleColumns = []; // visible bands and leaves

				$.wijmo.wijgrid.traverse(this.options.columns, function (column) {
					if (column.parentVis) {
						visibleColumns.push(column);
					}
				});

				for (i = 0, len = visibleColumns.length; i < len; i++) {
					column = visibleColumns[i];
					headerRowObj = headerRows.item(column.thY);
					th = new $.wijmo.wijgrid.rowAccessor().getCell(headerRowObj, column.thX);

					columnWidget = this._columnWidgetsFactory($(th), column);
					columns.push(columnWidget.data(columnWidget.data($.wijmo.c1basefield.prototype._data$prefix + "widgetName"))); // store actual widget instance
				}
			}

			this._field("columns", columns);
		},

		_ownerise: function (flag) {
			if (flag) {
				var self = this;

				$.wijmo.wijgrid.traverse(this.options.columns, function (column) {
					column.owner = self;

					var tmp, i, len;

					if ((tmp = column.groupInfo)) {
						tmp.owner = column;

						if (tmp.expandInfo) {
							for (i = 0, len = tmp.expandInfo.length; i < len; i++) {
								tmp.expandInfo[i].owner = tmp;
							}
						}
					}
				});
			} else {

				$.wijmo.wijgrid.traverse(this.options.columns, function (column) {
					delete column.owner;

					var tmp, i, len;

					if ((tmp = column.groupInfo)) {
						delete tmp.owner;

						if (tmp.expandInfo) {
							for (i = 0, len = tmp.expandInfo.length; i < len; i++) {
								delete tmp.expandInfo[i].owner;
							}
						}
					}
				});
			}
		},

		_updateSplits: function (scrollValue) {
			if (this._view().updateSplits !== null) {
				this._view().updateSplits(scrollValue);
			}
		},

		_refresh: function () {
			var view = this._view(), currentCell, resizer, frozener,
				scrollValue = { type: "", hScrollValue: null, vScrollValue: null },
				filterEditorsInfo = [];

			//$.wijmo.wijgrid.timerOn("refresh");

			if (view && view.getScrollValue) {
				scrollValue = view.getScrollValue();
			}

			this._detachEvents(false);

			this.element.detach();
			this.element.empty();
			this.outerDiv.empty();
			this.outerDiv.append(this.element);

			if (this._field("selectionui")) {
				this._field("selectionui").dispose();
				this._field("selectionui", null);
			}

			if (this._field("headerRowsAccessor")) {
				this._field("headerRowsAccessor", null);
			}

			if (this._field("rowsAccessor")) {
				this._field("rowsAccessor", null);
			}

			if (this._field("resizer")) {
				this._field("resizer").dispose();
			}

			if (this._field("frozener")) {
				this._field("frozener").dispose();
			}

			// apply grouping
			new $.wijmo.wijgrid.grouper().group(this, this.dataTable, this._field("leaves"));

			// apply merging
			new $.wijmo.wijgrid.merger().merge(this.dataTable, this._field("visibleLeaves"));

			// view
			//if (!this.options.splits && (this.options.staticRowIndex >= 0 || this.options.staticColumnIndex >= 0)) {
			// only support fixing row feature in this version.
			//if (this.options.scrollMode !== "none" && (this.options.staticColumnIndex >= 0 || this.options.staticRowIndex >= 0)) {
			if (this.options.scrollMode !== "none") {
				this._field("view", view = new $.wijmo.wijgrid.fixedView(this));
			} else {
				this._field("view", view = new $.wijmo.wijgrid.flatView(this));
			}

			this._render();

			// (re)create iternal widgets
			this._ownerise(false);
			this._recreateColumnWidgets();
			this._ownerise(true);

			// pager
			if (this.options.allowPaging) {
				// top pager
				if (this.$topPagerDiv) {
					this.$topPagerDiv.wijpager(this._pagerSettings2PagerWidgetSettings()).css("zIndex", 5);
				}

				// bottom pager
				if (this.$bottomPagerDiv) {
					this.$bottomPagerDiv.wijpager(this._pagerSettings2PagerWidgetSettings()).css("zIndex", 5);
				}
			}

			// (re)create iternal widgets

			// update css
			//this._updateCss();

			// attach events
			this._attachEvents();

			// currentCell
			view.focusableElement().attr("tabIndex", 0); // to handle keyboard\ focus events

			//because after setting some options affecting the current cell,
			//the current cell info is not correct.
			//if (this.currentCell()._isValid()) {
			//	this.currentCell(this.currentCell())._isEdit(false);
			if (this.currentCell()._isValid() && this.currentCell(this.currentCell())) {
				this.currentCell()._isEdit(false);
			} else {
				this.currentCell(this._getFirstDataRowCell(0));
			}

			// selection
			this._field("selection", null); // always recreate selection object
			currentCell = this.currentCell();
			if (currentCell._isValid()) {
				this.selection()._startNewTransaction(currentCell);
				this.selection()._selectRange(new $.wijmo.wijgrid.cellInfoRange(currentCell, currentCell), false, false, 0 /* none */, null);
			}

			// selection ui
			this._selectionui();

			// initialize resizer
			resizer = new $.wijmo.wijgrid.resizer(this);
			$.each(this.columns(), function (index, colWidget) {
				var o = colWidget.options;

				if (o.visible && o.parentVis && o.isLeaf) {
					resizer.addElement(colWidget);
				}
			});
			this._field("resizer", resizer);

			this._updateSplits(scrollValue); /*dma*/

			//frozener
			if (this.options.scrollMode !== "none") {
				frozener = new $.wijmo.wijgrid.frozener(this);
				frozener.addVElement(this._getStaticIndex(false));
				frozener.addHElement(this._getStaticIndex(true));
				frozener.attachDivEvent();
				this._field("frozener", frozener);
			}

			// update filter editors widths
			$.each(this.columns(), function (index, colWidget) {
				if (!colWidget.options.isBand && colWidget.options.showFilter === true) {
					var width = colWidget._getFilterEditorWidth();

					if (width !== undefined) {
						filterEditorsInfo.push({
							widget: colWidget,
							width: width
						});
					}
				}
			});

			$.each(filterEditorsInfo, function (index, item) {
				item.widget._setFilterEditorWidth(item.width);
			});

			//window.defaultStatus = $.wijmo.wijgrid.timerOff("refresh");
		},

		_needToCreatePagerItem: function () {
			return this.options.allowPaging;
		},

		_render: function () {
			var view = this._view(),
				o = this.options,
				content;

			view.render();

			// YK: for fixing pager is not align to top and bottom when header is fixed.
			content = this.outerDiv;
			if (o.scrollMode !== "none") {
				// fixed header content
				content = this.outerDiv.find("div.wijmo-wijgrid-scroller:first");
			}

			this.$superPanelHeader = null;

			// ** top pager (top div)
			if (this.$topPagerDiv) {
				if (this.$topPagerDiv.data("wijpager")) {
					this.$topPagerDiv.wijpager("destroy");
				}

				this.$topPagerDiv.remove();
			}

			this.$topPagerDiv = null;

			if (this._needToCreatePagerItem() && ((o.pagerSettings.position === "top") || (o.pagerSettings.position === "topAndBottom"))) {
				if (!this.$topPagerDiv) {
					content.prepend(this.$superPanelHeader = $("<div class=\"wijmo-wijsuperpanel-header\"></div>"));
					this.$superPanelHeader.prepend(this.$topPagerDiv = $("<div class=\"wijmo-wijgrid-header ui-widget-header ui-corner-top\"></div>"));
				}
			}
			// top pager **

			if (o.showGroupArea) {
				this._processGroupArea(content);
			} else {
				this.$groupArea = null;
			}

			// ** bottom pager (bottom div)
			if (this.$bottomPagerDiv) {
				if (this.$bottomPagerDiv.data("wijpager")) {
					this.$bottomPagerDiv.wijpager("destroy");
				}

				this.$bottomPagerDiv.remove();
			}

			this.$bottomPagerDiv = null;

			if (this._needToCreatePagerItem() && ((o.pagerSettings.position === "bottom") || (o.pagerSettings.position === "topAndBottom"))) {
				if (!this.$bottomPagerDiv) {
					content.append(this.$bottomPagerDiv = $("<div class=\"wijmo-wijgrid-footer wijmo-wijsuperpanel-footer ui-state-default ui-corner-bottom\"></div>"));
				}
			}
			// bottom pager **
		},

		_processGroupArea: function (content) {
			var self = this,
				groupCollection = this._field("groupedColumns"),
				groupWidgetCollection = [];

			this.$groupArea = $("<div class=\"ui-widget-content ui-helper-clearfix\"></div>");

			if (groupCollection.length > 0) {
				$.each(groupCollection, function (index, item) {
					var groupElement = $("<a href=\"#\"></a>").appendTo(self.$groupArea);

					groupElement.c1groupedfield($.extend({ owner: self }, {
						allowMoving: item.allowMoving,
						allowSort: item.allowSort,
						dataIndex: item.dataIndex,
						headerText: item.headerText,
						isBand: item.isBand,
						isLeaf: item.isLeaf,
						linearIdx: item.linearIdx,
						parentIdx: item.parentIdx,
						sortDirection: item.sortDirection,
						travIdx: item.travIdx,
						groupedIndex: item.groupedIndex
					}, { disabled: self.options.disabled }));

					groupWidgetCollection.push(groupElement.data("c1groupedfield"));
				});
			}
			else {
				this.$groupArea
					.addClass("wijmo-wijgrid-group-area")
					.html(this.options.groupAreaCaption || "&nbsp;");
			}

			this._field("groupedWidgets", groupWidgetCollection);

			if (!this.$superPanelHeader) {
				content.prepend(this.$superPanelHeader = $("<div class=\"wijmo-wijsuperpanel-header\"></div>"));
			}

			this.$superPanelHeader.prepend(this.$groupArea);

			this._dragndrop().attachGroupArea(this.$groupArea);
		},

		/*
		_updateCss: function() {
		var view = this._view();

		$.each(view.subTables(), function(index, item) {
		var domTable = item.element();
		$(domTable).addClass("wijmo-wijgrid-table");

		if (domTable.tBodies) {
		var tBody = domTable.tBodies[0];
		if (tBody) {
		$(tBody).addClass("ui-widget-content wijmo-wijgrid-data");
		}
		}
		});

		view.updateCss();
		},*/

		_attachEvents: function () {
			var view = this._view(),
				$fe = view.focusableElement();

			$fe.bind("keydown." + this.widgetName, $.proxy(this._onKeyDown, this));
			$fe.bind("keypress." + this.widgetName, $.proxy(this._onKeyPress, this));

			$.each(view.subTables(), $.proxy(function (index, element) {
				var domTable = element.element();
				if (domTable) {
					if (domTable.tHead) {
						$(domTable.tHead).bind("click." + this.widgetName, $.proxy(this._onClick, this));
					}

					if (domTable.tBodies.length) {
						$(domTable.tBodies[0])
							.bind("click." + this.widgetName, $.proxy(this._onClick, this))
							.bind("dblclick." + this.widgetName, $.proxy(this._onDblClick, this))
							.bind("mousemove." + this.widgetName, $.proxy(this._onMouseMove, this))
							.bind("mouseout." + this.widgetName, $.proxy(this._onMouseOut, this))

						// attach "onGroupExpandCollapseIconClick" event
							.find("> tr.wijmo-wijgrid-groupheaderrow > td .wijmo-wijgrid-grouptogglebtn")
								.bind("click." + this.widgetName, $.proxy(this._onGroupBtnClick, this));
					}
				}
			}, this));
		},

		_detachEvents: function (destroy) {
			var view = this._view(),
				self = this,
				$fe;

			if (view) {
				$fe = view.focusableElement();

				$fe.unbind("keydown." + this.widgetName);
				$fe.unbind("keypress." + this.widgetName);

				$.each(view.subTables(), function () {
					var domTable = this.element(); // item (this) is a htmlTableAccessor instance 

					if (domTable) {
						if (domTable.tHead) {
							$(domTable.tHead).unbind("." + self.widgetName);
						}

						if (domTable.tBodies.length) {
							$(domTable.tBodies[0]).unbind("." + self.widgetName);
						}
					}
				});

				if (destroy) {
					// detach "onGroupExpandCollapseIconClick" event
					$.each(view.getJoinedTables(true, 0), function (index, item) {
						if (item && typeof (item) !== "number") {
							$(item.element()) // item (this) is a htmlTableAccessor instance 
								.find("> tbody")
								.find("> tr.wijmo-wijgrid-groupheaderrow > td .wijmo-wijgrid-grouptogglebtn")
								.unbind("." + self.widgetName);
						}
					});
				}
			}
		},

		_handleSort: function (column, multiSort) {
			var columns = this.options.columns,
				travIdx = column.travIdx,
				newSortDirection, args;

			//if (this.options.allowSorting && ($.inArray(columnWidget, columns) >= 0)) {
			if (column && this.options.allowSorting) {
				newSortDirection = ((column.sortDirection === "none")
					? "ascending"
					: ((column.sortDirection === "ascending") ? "descending" : "ascending"));

				args = { column: column, sortDirection: newSortDirection };

				if (this._onColumnSorting(args)) {
					args.column.sortDirection = args.sortDirection;

					if (multiSort) {
						args.column.sortOrder = this._customSortOrder++;
					} else {
						this._customSortOrder = 1000; // reset to default

						// reset sortDirection for all column widgets except sorting one and grouped columns
						$.each(this.columns(), function (index, item) {
							item.options.sortOrder = 0;

							if (item.options.travIdx !== travIdx && !(item.options.groupInfo && item.options.groupInfo.position !== "none")) {
								item.options.sortDirection = "none";
							}
						});

						// ensure invisible columns.
						$.wijmo.wijgrid.traverse(columns, function (item) {
							item.sortOrder = 0;

							if (item.travIdx !== travIdx && !(item.groupInfo && item.groupInfo.position !== "none")) {
								item.sortDirection = "none";
							}
						});
					}

					this.ensureControl(true, {
						afterRefresh: function () { this._onColumnSorted({ column: args.column }); }
					});
				}
			}
		},

		_pagerSettings2PagerWidgetSettings: function () {
			return $.extend({}, this.options.pagerSettings,
				{
					disabled: this.options.disabled,
					pageCount: this.pageCount(),
					pageIndex: this.options.pageIndex,
					pageIndexChanging: $.proxy(this._onPagerWidgetPageIndexChanging, this),
					pageIndexChanged: $.proxy(this._onPagerWidgetPageIndexChanged, this)
				});
		},

		_handleDragnDrop: function (dragTravIdx, dropTravIdx, at, dragInGroup, dropInGroup) {
			var drag = $.wijmo.wijgrid.getColumnByTravIdx(this.options.columns, dragTravIdx),
				drop = $.wijmo.wijgrid.getColumnByTravIdx(this.options.columns, dropTravIdx),
				dragSource = dragInGroup ? "groupArea" : "columns",
				dropSource = dropInGroup ? "groupArea" : "columns";

			if (dropInGroup) { // drag is dropped into the group area
				if (this._onColumnGrouping({ drag: drag.found, drop: drop ? drop.found : null, dragSource: dragSource, dropSource: dropSource, at: at })) {
					this.ensureControl(true, {
						beforeRefresh: function () {
							if (!drop) { // drag is dropped into the empty group area.
								drag.found.groupedIndex = 0;
							} else {
								switch (at) {
									case "left":
										drag.found.groupedIndex = drop.found.groupedIndex - 0.5;
										break;

									case "right":
										drag.found.groupedIndex = drop.found.groupedIndex + 0.5;
										break;
								}
							}

							if (!dragInGroup) {
								$.extend(true, drag.found, {
									groupInfo: {
										position: "header"
									}
								});
							}
						},

						afterRefresh: function () {
							this._onColumnGrouped({ drag: drag.found, drop: drop ? drop.found : null, dragSource: dragSource, dropSource: dropSource, at: at });
						}
					});
				}
			} else {
				if (this._onColumnDropping({ drag: drag.found, drop: drop.found, at: at })) {
					this.ensureControl(false, {
						beforeRefresh: function () {
							/* modifying the wijgrid.options.columns option */
							drag.at.splice(drag.found.linearIdx, 1);

							//because when drag is before drop, the index of drop is affected.
							switch (at) {
								case "left":
									if (drag.at === drop.at && drag.found.linearIdx < drop.found.linearIdx) {
										drop.at.splice(drop.found.linearIdx - 1, 0, drag.found);
									} else {
										drop.at.splice(drop.found.linearIdx, 0, drag.found);
									}
									break;

								case "right":
									if (drag.at === drop.at && drag.found.linearIdx < drop.found.linearIdx) {
										drop.at.splice(drop.found.linearIdx, 0, drag.found);
									} else {
										drop.at.splice(drop.found.linearIdx + 1, 0, drag.found);
									}
									break;

								case "center": // drop is a band
									drop.found.columns.push(drag.found);
									break;
							}

							// rebuild indices (linearIdx, travIdx, parentIdx)
							$.wijmo.wijgrid.setTraverseIndex(this.options.columns);
						},

						afterRefresh: function () {
							this._onColumnDropped({ drag: drag.found, drop: drop.found, at: at });
						}
					});
				}
			}
		},

		_handleFilter: function (column, rawOperator, rawValue) {
			var operator = this.filterOperatorsCache.getByName(rawOperator),
				value, ok, args;

			if (operator) {
				if (operator.arity > 1) {
					// check value
					value = this._parse(column.options, rawValue);
					ok = (value !== null && (column.options.dataType === "string" || !isNaN(value)));
				} else {
					ok = true;
				}

				if (ok) {
					args = { column: column.options, operator: operator.name, value: value };

					if (this._onColumnFiltering(args)) {
						column.options.filterValue = args.value;
						column.options.filterOperator = args.operator;

						this.options.pageIndex = 0;

						this.ensureControl(true, {
							afterRefresh: function () { this._onColumnFiltered({ column: column.options }); }
						});
					}
				}
			}
		},

		_handleUngroup: function (columnTravIdx) {
			var column = $.wijmo.wijgrid.getColumnByTravIdx(this.options.columns, columnTravIdx);
			if (column && column.found) {
				column = column.found;

				if (this._onColumnUngrouping({ column: column })) {

					this.ensureControl(false, {
						beforeRefresh: function () {
							delete column.groupedIndex;

							$.extend(true, column, {
								groupInfo: {
									position: "none"
								}
							});
						},

						afterRefresh: function () {
							this._onColumnUngrouped({ column: column });
						}
					});
				}
			}
		},

		// * event handlers

		_onColumnDropping: function (args) {
			return this._trigger("columnDropping", null, args);
		},

		_onColumnDropped: function (args) {
			this._trigger("columnDropped", null, args);
		},

		_onColumnGrouping: function (args) {
			return this._trigger("columnGrouping", null, args);
		},

		_onColumnGrouped: function (args) {
			this._trigger("columnGrouped", null, args);
		},

		_onColumnUngrouping: function (args) {
			return this._trigger("columnUngrouping", null, args);
		},

		_onColumnUngrouped: function (args) {
			this._trigger("columnUngrouped", null, args);
		},

		_onColumnFiltering: function (args) {
			return this._trigger("filtering", null, args);
		},

		_onColumnFiltered: function (args) {
			this._trigger("filtered", null, args);
		},

		_onColumnSorting: function (args) {
			return this._trigger("sorting", null, args);
		},

		_onColumnSorted: function (args) {
			this._trigger("sorted", null, args);
		},

		_onCurrentCellChanged: function () {
			var o = this.options,
				currentCell;

			if (o.allowKeyboardNavigation) {
				currentCell = this._field("currentCell");

				if (o.scrollMode !== "none" && currentCell && !currentCell.isEqual(currentCell.outsideValue)) {
					this._view().scrollTo(currentCell);
				}
			}

			this._trigger("currentCellChanged");
		},

		_onPageIndexChanging: function (args) {
			return this._trigger("pageIndexChanging", null, args);
		},

		_onPageIndexChanged: function (args) {
			this._trigger("pageIndexChanged");
		},

		_onPagerWidgetPageIndexChanging: function (sender, args) {
			args.handled = true;
		},

		_onPagerWidgetPageIndexChanged: function (sender, args) {
			this._setOption("pageIndex", args.newPageIndex);
		},

		_onClick: function (args) {
			if (!this._canInteract() || !args.target) {
				return;
			}

			// info[0] - clicked cell
			// info[1] - wijmo-wijgrid-table
			var view = this._view(),
				info = this._getParentSubTable(args.target, ["td", "th"], view.subTables()),
				clickedCell, $row, clickedCellInfo,
				extendMode = 0, // none
				currentCell, selection;

			if (info) {
				clickedCell = info[0];

				$row = $(clickedCell).closest("tr");

				if (!($row.is(".wijmo-wijgrid-datarow") || $row.is(".wijmo-wijgrid-headerrow"))) {
					return;
				}

				if (!$row.length) {
					return;
				}

				clickedCellInfo = view.getAbsoluteCellInfo(clickedCell)._absToData(this._getDataToAbsOffset());

				if (clickedCellInfo.cellIndex() < 0 || clickedCellInfo.rowIndex() < 0) { // header cell, rowheader cell or filter cell

					if (clickedCellInfo.rowIndex() >= 0) { // rowheader cell
						// move current cell to the first cell of the clicked row
						clickedCellInfo = new $.wijmo.wijgrid.cellInfo(0, clickedCellInfo.rowIndex());
						extendMode = 2; // extend to row
					} else { // header cell
						// move current cell to the first data cell of the clicked column
						clickedCellInfo = this._getFirstDataRowCell(clickedCellInfo.cellIndex());
						extendMode = 1; // extend to column
					}
				}

				this._changeCurrentCell(clickedCellInfo);

				currentCell = this.currentCell();
				selection = this.selection();

				if (!args.shiftKey || (!selection._multipleRangesAllowed() && this.options.selectionMode.toLowerCase() !== "singlerange")) {
					selection._startNewTransaction(currentCell);
				}

				selection.beginUpdate();

				if (args.shiftKey && args.ctrlKey) {
					selection._clearRange(new $.wijmo.wijgrid.cellInfoRange(currentCell, currentCell), extendMode);
				} else {
					selection._selectRange(new $.wijmo.wijgrid.cellInfoRange(selection._anchorCell(), currentCell), args.ctrlKey, args.shiftKey, extendMode, null);
				}

				selection.endUpdate();
			}
		},

		_onDblClick: function (args) {
			this._beginEditInternal(args);
		},

		_onGroupBtnClick: function (args) {
			if (!this._canInteract()) {
				return;
			}

			var $row = $(args.target).closest("tr"),
				gh = new $.wijmo.wijgrid.groupHelper(),
				groupInfo = gh.getGroupInfo($row[0]),
				column, group;

			if (groupInfo) {
				column = gh.getColumnByGroupLevel(this._field("leaves"), groupInfo.level);
				if (column) {
					group = column.groupInfo.expandInfo[groupInfo.index];

					if (group.isExpanded) {
						group.collapse(args.shiftKey);
					} else {
						group.expand(args.shiftKey);
					}
					this._view().ensureHeight(); /*dma*/
				}
			}
		},

		_onKeyDown: function (args) {
			if (!this._canInteract()) {
				return true;
			}

			var tag = args.target.tagName.toLowerCase(),
				canChangePos = false,
				curPos, cell, currentCell, selection;

			if ((tag === "input" || tag === "option" || tag === "select" || tag === "textarea") &&
				 ($(args.target).closest("tr.wijmo-wijgrid-datarow").length === 0)) { // not a datarow ?
				return true;
			}

			if (this.options.allowEditing) {
				// ESC: cancel editing, F2: finish editing
				if ((args.which === $.ui.keyCode.ESCAPE || args.which === 113) && (this.currentCell()._isValid() && this.currentCell()._isEdit())) {
					this._endEditInternal(args);
					return false;
				} else {
					if (args.which === 113) { // F2: start editing
						this._beginEditInternal(args);
						return false;
					}
				}
			}

			if (!this.options.allowKeyboardNavigation) {
				return true;
			}

			//switch (args.keyCode) {
			switch (args.which) {
				case $.ui.keyCode.LEFT:
				case $.ui.keyCode.RIGHT:
				case $.ui.keyCode.DOWN:
				case $.ui.keyCode.UP:
				case $.ui.keyCode.PAGE_DOWN:
				case $.ui.keyCode.PAGE_UP:
				case $.ui.keyCode.HOME:
				case $.ui.keyCode.END:
				case $.ui.keyCode.TAB:

					curPos = this._getNextCurrencyPos(this._getDataCellsRange(), this.currentCell(), args.keyCode, args.shiftKey);
					canChangePos = this._canMoveToAnotherCell(args.target, args.which); // TODO: add tab navigation

					break;
			}

			if (canChangePos) {
				this._changeCurrentCell(new $.wijmo.wijgrid.cellInfo(curPos.cellIndex, curPos.rowIndex));

				currentCell = this.currentCell();
				cell = this._getDOMDataCell(currentCell);
				selection = this.selection();

				if (!args.shiftKey || (!selection._multipleRangesAllowed() && this.options.selectionMode.toLowerCase() !== "singlerange")) {
					selection._startNewTransaction(currentCell);
				}

				selection.beginUpdate();
				selection._selectRange(new $.wijmo.wijgrid.cellInfoRange(selection._anchorCell(), currentCell), false, args.shiftKey, 0 /* none */, null);
				selection.endUpdate();

				// TODO: tab navigation

				return false; // stop bubbling
			}

			return true;
		},

		_onKeyPress: function (args) {
			if (this._canInteract() && this.options.allowEditing) {
				var charCode = args.which,
					currentCell = this.currentCell(),
					tag, table, domSubTables;

				if (charCode && currentCell._isValid() && !currentCell._isEdit()) {
					tag = args.target.tagName.toLowerCase();

					if (tag !== "input" && tag !== "option" && tag !== "select" && tag !== "textarea") {
						table = $(args.target).closest(".wijmo-wijgrid-table");
						// if (table.length && (table[0] === this.$table[0])) {
						if (table.length) {

							domSubTables = $.map(this._view().subTables(), function (item, index) {
								return item.element();
							});

							if ($.inArray(table[0], domSubTables) >= 0) {
								if ($.wij.charValidator.isPrintableChar(String.fromCharCode(charCode))) {
									//new $.wijmo.wijgrid.cellEditorHelper().currentCellEditStart(this, args);
									this._beginEditInternal(args);
									return false;
								}
							}
						}
					}
				}
			}
		},

		_onMouseMove: function (args) {
			if (!this._canInteract()) {
				return;
			}

			var view = this._view(),
				info = this._getParentSubTable(args.target, ["td", "th"], view.subTables()),
				hoveredCell, $hoveredRow, hoveredCellInfo, rowIndex, rowObj, rowInfo,
				$rs = $.wijmo.wijgrid.renderState;

			if (info) {
				hoveredCell = info[0];
				$hoveredRow = $(hoveredCell).closest("tr");

				if (!$hoveredRow.length || $hoveredRow.is(".wijmo-wijgrid-foorow") || !($hoveredRow.is(".wijmo-wijgrid-datarow") || $hoveredRow.is(".wijmo-wijgrid-headerrow"))) {
					return;
				}

				hoveredCellInfo = view.getAbsoluteCellInfo(hoveredCell)._absToData(this._getDataToAbsOffset());

				rowIndex = this._field("hoveredRow"); // previous row index
				if (rowIndex !== undefined && hoveredCellInfo.rowIndex() !== rowIndex) {
					rowObj = this._rows().item(rowIndex);
					if (rowObj) {
						rowInfo = this._createRowInfo(rowObj);
						rowInfo.state = this._changeRenderState(rowInfo.$rows, $rs.hovered, false);
						this.rowStyleFormatter.format(rowInfo);
					}
				}

				rowIndex = hoveredCellInfo.rowIndex();
				this._field("hoveredRow", rowIndex);
				//if (rowIndex >= 1) { // yk to inclue the first row.
				if (rowIndex >= 0) {
					rowObj = this._rows().item(rowIndex);
					if (rowObj) {
						rowInfo = this._createRowInfo(rowObj);
						rowInfo.state = this._changeRenderState(rowInfo.$rows, $rs.hovered, true);
						this.rowStyleFormatter.format(rowInfo);
					}
				}
			}
		},

		_onMouseOut: function (args) {
			if ($(args.relatedTarget).closest(".wijmo-wijgrid-data").length === 0) { // remove hovering
				var hovRowIndex = this._field("hoveredRow"),
					rowObj, rowInfo;

				if (hovRowIndex >= 0) {
					rowObj = this._rows().item(hovRowIndex);
					if (rowObj) {
						rowInfo = this._createRowInfo(rowObj);
						rowInfo.state = this._changeRenderState(rowInfo.$rows, $.wijmo.wijgrid.renderState.hovered, false);
						this.rowStyleFormatter.format(rowInfo);
					}
				}
			}
		},
		// * event handlers

		// * resizing
		_fieldResized: function (fieldWidget, oldWidth, newWidth) {
			if (oldWidth < 0) {
				oldWidth = 0;
			}

			if (newWidth <= 0) {
				newWidth = 1;
			}

			if (this._trigger("columnResizing", null, { column: fieldWidget.options, oldWidth: oldWidth, newWidth: newWidth }) !== false) {
				//we should set the width option with the column resized
				//this.options.columns[fieldWidget.options.$uid].width = newWidth;
				fieldWidget.option("width", newWidth);

				this._trigger("columnResized", null, { column: fieldWidget.options });
			}
		},
		// * resizing

		// * currentCell
		_changeCurrentCell: function (cellInfo) {
			var currentCell = this.currentCell(),
				dataRange = this._getDataCellsRange(),
				args, cellEditCompleted,
				highlight = this.options.highlightCurrentCell;

			// if cellInfo has a valid value
			if ((dataRange._isValid() && dataRange._containsCellInfo(cellInfo)) || (cellInfo.isEqual(cellInfo.outsideValue))) {

				// other cell than current cell
				if (currentCell.cellIndex() !== cellInfo.cellIndex() || currentCell.rowIndex() !== cellInfo.rowIndex()) {
					args = {
						cellIndex: cellInfo.cellIndex(),
						rowIndex: cellInfo.rowIndex(),
						oldCellIndex: currentCell.cellIndex(),
						oldRowIndex: currentCell.rowIndex()
					};

					if (this._trigger("currentCellChanging", null, args)) {

						cellEditCompleted = false;
						if (!this.options.allowEditing || !currentCell._isEdit() || (cellEditCompleted = this._endEditInternal(null))) {
							if (highlight && dataRange._containsCellInfo(currentCell)) {
								this._highlightCellPosition(currentCell, false); // remove the current one
							}

							currentCell = cellInfo._clone();
							currentCell._setGridView(this);

							if (highlight) {
								this._highlightCellPosition(currentCell, true);
							}

							this._field("currentCell", currentCell); // set currentCell

							this._onCurrentCellChanged();
						}
					}
				} else { // the same cell
					if (highlight) {
						this._highlightCellPosition(currentCell, true); // ensure
					}
				}
			} else { // cellInfo is invalid
				// do nothing

				// this._highlightCellPosition(currentCell, false);
				// this._field("currentCell", currentCell.outsideValue); // set currentCell
			}
		},

		_highlightCellPosition: function (cellInfo, add) {
			if (cellInfo && cellInfo._isValid()) {

				var absCellInfo = cellInfo._clone()._dataToAbs(this._getDataToAbsOffset()),
					x = absCellInfo.cellIndex(),
					y = absCellInfo.rowIndex(),
					$rs = $.wijmo.wijgrid.renderState,
					view = this._view(),
					obj, rowInfo, state;

				// * column header cell *
				obj = view.getHeaderCell(x);
				if (obj) {
					rowInfo = this._createRowInfo(this._headerRows().item(cellInfo.column().thY));

					obj = $(obj);
					state = this._changeRenderState(obj, $rs.current, add);

					// highlight column header cell
					this.cellStyleFormatter.format(obj, x, cellInfo.column(), rowInfo, state);
				}

				// * row header cell *
				obj = view.getJoinedRows(y, 0);
				if (obj) {
					// change row state
					rowInfo = this._createRowInfo(obj);
					rowInfo.state = this._changeRenderState(rowInfo.$rows, $rs.current, add);

					// highlight row header cell
					this.rowStyleFormatter.format(rowInfo);
				}

				// * data cell *
				obj = view.getCell(x, y);
				if (obj) {
					obj = $(obj);
					state = this._changeRenderState(obj, $rs.current, add);

					// highlight data cell
					this.cellStyleFormatter.format(obj, x, cellInfo.column(), rowInfo, state);  // rowInfo is taken from the previous step
				}
			}
		},

		// * currentCell


		// * editing
		_beginEditInternal: function (e) {
			if (this._canInteract() && this.options.allowEditing) {
				var column = this.currentCell().column(),
					res;

				if (column && !column.readOnly) {
					res = new $.wijmo.wijgrid.cellEditorHelper().currentCellEditStart(this, e);
					if (res) {
						// this._view().ensureWidth(undefined, column.visLeavesIdx);
					}
					return res;
				}
			}

			return false;
		},

		_endEditInternal: function (e) {
			if (this._canInteract() && this.options.allowEditing) {
				//var column = this.currentCell().column(),
				var res = new $.wijmo.wijgrid.cellEditorHelper().currentCellEditEnd(this, e);

				if (res) {
					this._view().ensureHeight(this.currentCell().rowIndex());
				}
				return res;
			}

			return false;
		},
		// * editing

		// misc

		_createRow: function (tableSection, rowType, rowIndex) {
			return tableSection.insertRow(-1);
		},

		_createCell: function (rowType, rowIndex, dataCellIndex, column) {
			var rt = $.wijmo.wijgrid.rowType;

			switch (rowType) {
				case rt.header:
					return "<th><div class=\"wijmo-wijgrid-innercell\"></div></th>";

				case rt.filter:
					return "<td />";

				default: // body section - data, data | dataAlt, groupFooter, groupHeader, emptyDataRow
					// footer section - footer
					return "<td><div class=\"wijmo-wijgrid-innercell\"></div></td>";
			}
		},

		_cellCreated: function ($cell, cellIndex, column, rowInfo, state, attr, style) {
			$.wijmo.wijgrid.dataPrefix($cell, this._data$prefix, "renderState", state);

			this.cellStyleFormatter.format($cell, cellIndex, column, rowInfo, state, attr, style);

			this._changeRenderState($cell, $.wijmo.wijgrid.renderState.rendering, false);
		},

		_rowCreated: function (rowInfo, rowAttr, rowStyle) {
			$.wijmo.wijgrid.dataPrefix(true, rowInfo.$rows, this._data$prefix, {
				dataTableRowIndex: rowInfo._dataTableRowIndex,
				dataRowIndex: rowInfo.dataRowIndex,
				rowType: rowInfo.type,
				dataItemIndex: rowInfo.dataItemIndex,
				virtualDataItemIndex: rowInfo.virtualDataItemIndex,
				renderState: rowInfo.state
			});

			this.rowStyleFormatter.format(rowInfo, rowAttr, rowStyle);

			this._changeRenderState(rowInfo.$rows, $.wijmo.wijgrid.renderState.rendering, false);
		},

		_createRowInfo: function (rowObj, rowType /*opt*/, renderState /*opt*/, dataTableRowIndex /*opt*/, dataRowIndex /*opt*/, dataItemIndex/*opt*/, virtualDataItemIndex/*opt*/) {
			var dataTable = this.dataTable,
				sourceDataRow = null,
				$rows = (rowObj[1] ? $(rowObj) : $(rowObj[0])),
				tmp,
				$getData = $.wijmo.wijgrid.dataPrefix;

			if (isNaN(rowType)) {
				rowType = $getData($rows, this._data$prefix, "rowType");
			}

			if (isNaN(renderState)) {
				renderState = $getData($rows, this._data$prefix, "renderState");
			}

			if (isNaN(dataTableRowIndex)) {
				dataTableRowIndex = $getData($rows, this._data$prefix, "dataTableRowIndex");
			}

			if (isNaN(dataRowIndex)) {
				dataRowIndex = $getData($rows, this._data$prefix, "dataRowIndex");
			}

			if (isNaN(dataItemIndex)) {
				dataItemIndex = $getData($rows, this._data$prefix, "dataItemIndex");
			}

			if (isNaN(virtualDataItemIndex)) {
				virtualDataItemIndex = $getData($rows, this._data$prefix, "virtualDataItemIndex");
			}

			if (dataTableRowIndex >= 0) {
				tmp = dataTable[dataTableRowIndex].originalRowIndex;
				if (tmp >= 0) {
					sourceDataRow = this.data()[tmp];
				}
			}

			return {
				$rows: $rows,
				state: renderState,
				type: rowType,
				data: sourceDataRow,
				dataRowIndex: dataRowIndex,
				dataItemIndex: dataItemIndex,
				virtualDataItemIndex: virtualDataItemIndex,
				_dataTableRowIndex: dataTableRowIndex
			};
		},

		_ensureDataParser: function (column) {
			switch (column.dataType) {
				case undefined: // default parser
				case "string":
					if (!column.dataParser) {
						column.dataParser = $.wijmo.wijgrid.embeddedParsers.stringParser;
					}
					break;

				case "boolean":
					if (!column.dataParser) {
						column.dataParser = $.wijmo.wijgrid.embeddedParsers.boolParser;
					}
					break;

				case "number":
					if (!column.dataParser) {
						column.dataParser = $.wijmo.wijgrid.embeddedParsers.numberParser;
					}
					break;

				case "currency":
					if (!column.dataParser) {
						column.dataParser = $.wijmo.wijgrid.embeddedParsers.currencyParser;
					}
					break;

				case "datetime":
					if (!column.dataParser) {
						column.dataParser = $.wijmo.wijgrid.embeddedParsers.dateTimeParser;
					}
					break;

				default:
					throw $.wijmo.wijgrid.stringFormat("Unsupported dataType value: \"{0}\"", column.dataType);
			}
		},

		_parseDOM: function (column, value) {
			return column.dataParser.parseDOM(value, this._field("closestCulture"), column.dataFormatString, this.options.nullString, true);
		},

		_parse: function (column, value) {
			var parsedValue = column.dataParser.parse(value, this._field("closestCulture"), column.dataFormatString, this.options.nullString, true);

			switch (column.dataType) {
				case "datetime":
					if (parsedValue !== null && !(parsedValue instanceof Date)) {
						throw "invalid value.";
					}
					break;

				case "number":
				case "currency":
					if (parsedValue !== null && (typeof (parsedValue) !== "number" || isNaN(parsedValue))) {
						throw "invalid value.";
					}
					break;

				case "boolean":
					if (parsedValue !== null && (typeof (parsedValue) !== "boolean" || isNaN(parsedValue))) {
						throw "invalid value.";
					}

					break;
			}

			return parsedValue;
		},

		_toStr: function (column, value) {
			return column.dataParser.toStr(value, this._field("closestCulture"), column.dataFormatString, this.options.nullString, true);
		},

		_funcOptions: function () {
			return ["cellStyleFormatter", "rowStyleFormatter", "afterCellEdit", "afterCellUpdate", "beforeCellEdit", "beforeCellUpdate",
				"columnDragging", "columnDragged", "columnDropping", "columnDropped", "columnResizing", "columnResized",
				"columnGrouping", "columnGrouped", "columnUngrouping", "columnUngrouped", "currentCellChanging", "currentCellChanged",
				"filtering", "filtered",
				"filterOperatorsListShowing", "groupAggregate", "groupText", "invalidCellValue", "pageIndexChanging", "pageIndexChanged",
				"selectionChanged", "sorting", "sorted", "ajaxError", "dataLoading", "dataLoaded", "loading", "loaded", "rendering", "rendered"];
		},

		_canInteract: function () {
			return !this.options.disabled;
		},

		_canMoveToAnotherCell: function (domElement, keyCode) {
			var tag = domElement.tagName.toLowerCase(),
				len, selectionRange, kc, res;

			switch (tag) {
				case "input":
					if ($(domElement).hasClass("wijgridinput")) {

						if (domElement.type === "text") {
							len = domElement.value.length;
							selectionRange = new $.wijmo.wijgrid.domSelection(domElement).getSelection();

							kc = $.ui.keyCode;

							res = ((keyCode === kc.UP || keyCode === kc.DOWN || keyCode === kc.PAGE_DOWN || keyCode === kc.PAGE_UP) ||
								(selectionRange.length === 0 &&
									(
										(selectionRange.start === 0 && (keyCode === kc.LEFT || keyCode === kc.HOME)) ||
										(selectionRange.end >= len && (keyCode === kc.RIGHT || keyCode === kc.END))
									)
								));

							return res;
						}

						return true;
					}

					return false;

				case "textarea":
				case "select":
					return false;
			}

			return true;
		},

		_getDataToAbsOffset: function () {
			var x = 0,
				y = 0,
				headerRows = this._headerRows();

			if (this.options.showRowHeader) {
				x++;
			}

			if (headerRows) {
				y += headerRows.length();
			}

			if (this._filterRow()) {
				y++;
			}

			return {
				x: x,
				y: y
			};
		},

		_getDataCellsRange: function () {
			var minCol = 0,
				minRow = 0,
				maxCol = this._field("visibleLeaves").length - 1, // = this._field("dataCache").<maxWidth>
				maxRow = this.dataTable.length - 1;

			if (this.options.showRowHeader) {
				maxCol--;
			}

			if (maxCol < 0 || maxRow < 0) {
				minCol = minRow = maxCol = maxRow = -1;
			}

			return new $.wijmo.wijgrid.cellInfoRange(new $.wijmo.wijgrid.cellInfo(minCol, minRow),
				new $.wijmo.wijgrid.cellInfo(maxCol, maxRow));
		},

		_getDOMDataCell: function (cellInfo) {
			if (cellInfo) {
				cellInfo = cellInfo._clone()._dataToAbs(this._getDataToAbsOffset());
				if (cellInfo._isValid()) {
					return this._view().getCell(cellInfo.cellIndex(), cellInfo.rowIndex());
				}
			}

			return null;
		},

		_getFirstDataRowCell: function (absCellIndex) {
			var rowIndex, dataRow,
				$rt = $.wijmo.wijgrid.rowType;

			for (rowIndex = 0; dataRow = this.dataTable[rowIndex]; rowIndex++) {
				if (dataRow.rowType & $rt.data) {
					return new $.wijmo.wijgrid.cellInfo(absCellIndex, rowIndex);
				}
			}

			return $.wijmo.wijgrid.cellInfo.prototype.outsideValue;
		},

		_getNextCurrencyPos: function (dataRange, cellInfo, keyCode, shiftKeyPressed) {
			var cellIndex = cellInfo.cellIndex(),
				rowIndex = cellInfo.rowIndex(),
				tmp;

			switch (keyCode) {
				case $.ui.keyCode.PAGE_UP:
					if (this._reverseKey && rowIndex === dataRange.topLeft().rowIndex()) {
						rowIndex = dataRange.bottomRight().rowIndex();
					} else {
						rowIndex -= this._pageSizeKey;

						if (rowIndex < (tmp = dataRange.topLeft().rowIndex())) {
							rowIndex = tmp;
						}
					}
					break;

				case $.ui.keyCode.PAGE_DOWN:
					if (this._reverseKey && rowIndex === dataRange.bottomRight().rowIndex()) {
						rowIndex = dataRange.TopLeft().RowIndex();
					}
					else {
						rowIndex += this._pageSizeKey;

						if (rowIndex > (tmp = dataRange.bottomRight().rowIndex())) {
							rowIndex = tmp;
						}
					}

					break;

				case $.ui.keyCode.END:
					cellIndex = (this._reverseKey && cellIndex === dataRange.bottomRight().cellIndex())
						? dataRange.topLeft().cellIndex()
						: dataRange.bottomRight().cellIndex();

					break;

				case $.ui.keyCode.HOME:
					cellIndex = (this._reverseKey && cellIndex === dataRange.topLeft().cellIndex())
						? dataRange.bottomRight().cellIndex()
						: dataRange.topLeft().cellIndex();

					break;

				case $.ui.keyCode.LEFT:
					if (cellIndex > dataRange.topLeft().cellIndex()) {
						cellIndex--;
					} else
						if (this._reverseKey) {
							cellIndex = dataRange.bottomRight().cellIndex();
						}

					break;

				case $.ui.keyCode.UP:
					if (rowIndex > dataRange.topLeft().rowIndex()) {
						rowIndex--;
					}
					else
						if (this._reverseKey) {
							rowIndex = dataRange.bottomRight().rowIndex();
						}

					break;

				case $.ui.keyCode.RIGHT:
					if (cellIndex < dataRange.bottomRight().cellIndex()) {
						cellIndex++;
					}
					else
						if (this._reverseKey) {
							cellIndex = dataRange.topLeft().cellIndex();
						}

					break;

				case $.ui.keyCode.ENTER:
				case $.ui.keyCode.DOWN:
					if (rowIndex < dataRange.bottomRight().rowIndex()) {
						rowIndex++;
					}
					else
						if (this._reverseKey) {
							rowIndex = dataRange.topLeft().rowIndex();
						}

					break;

				case $.ui.keyCode.TAB:
					if (false /* TODO - tab navigation */) {
						if (shiftKeyPressed) {
							cellIndex--;

							if (cellIndex < dataRange.topLeft().cellIndex()) {

								cellIndex = dataRange.bottomRight().cellIndex();
								rowIndex--;

								if (rowIndex < dataRange.topLeft().rowIndex()) {
									rowIndex = dataRange.bottomRight().rowIndex();
								}
							}
						}
						else {
							cellIndex++;

							if (cellIndex > dataRange.bottomRight().cellIndex()) {
								cellIndex = dataRange.topLeft().cellIndex();
								rowIndex++;

								if (rowIndex > dataRange.bottomRight().rowIndex()) {
									rowIndex = dataRange.topLeft().rowIndex();
								}
							}
						}

					}

					break;
			}

			return { cellIndex: cellIndex, rowIndex: rowIndex };
		},

		_getParentSubTable: function (root, tagsToFind, subTables) {
			var domSubTables = $.map(subTables, function (item, index) { return item.element(); }),
				subTable = null,
				lastCoincidentEl = null,
				tag;

			for (; root !== null && subTable === null; root = root.parentNode) {
				tag = (root.tagName)
					? root.tagName.toLowerCase()
					: undefined;

				if ($.inArray(tag, tagsToFind) >= 0) {
					lastCoincidentEl = root;
				} else {
					//if ($(root).hasClass("wijmo-wijgrid-table")) {
					if ($.inArray(root, domSubTables) >= 0) {
						subTable = root;
					}
				}
			}

			return (lastCoincidentEl && subTable)
				? [lastCoincidentEl, subTable]
				: null;
		},

		_getStaticIndex: function (bRow) {
			var limitation = false,
				o = this.options,
				staticIndex, maxStaticIndex;
			$.each(this._field("leaves"), function (index, field) {
				if (field.rowMerge !== "none" || (field.groupInfo && field.groupInfo.position !== "none")) {
					limitation = true;
					return false;
				}
			});
			if (limitation) {
				return -1;
			}
			if (bRow) {
				staticIndex = o.staticRowIndex;
				maxStaticIndex = this.dataTable.length - 1;
			} else {
				staticIndex = o.staticColumnIndex;
				maxStaticIndex = this._field("visibleLeaves").length - (o.showRowHeader ? 1 : 0) - 1;
			}
			if (staticIndex < -1) {
				staticIndex = -1;
			} else if (staticIndex > maxStaticIndex) {
				staticIndex = maxStaticIndex;
			}
			return staticIndex;
		},

		// index of the fixed leaf inside the visibleLeaves collection.
		// return the length of Header when bHeader is true
		_getRealStaticColumnIndex: function (bHeader) {
			var leaves, len,
				headerLen = 0,
				staticColumnIndex = this._getStaticIndex(false),
				resultIndex;

			if (this.options.showRowHeader === true) {
				headerLen++;
			}

			if (bHeader) {
				return headerLen;
			}

			resultIndex = staticColumnIndex + headerLen;
			if (staticColumnIndex >= 0) {
				leaves = this._field("visibleLeaves");
				len = leaves.length;

				// If child column of some band is fixed then the top and right-most column of the root band contained current column will be fixed.
				for (; resultIndex < len; resultIndex++) {
					if (leaves[resultIndex].parentIdx === -1) {
						break; // index of the first leaf which is not contained inside a band.
					}
				}

				if (resultIndex >= len) {
					resultIndex = len - 1;
				}
			}

			return resultIndex;
		},

		// return the length of Header when bHeader is true
		_getRealStaticRowIndex: function (bHeader) {
			/*
			if (this.options.staticRowIndex >= 0) {
			var index = this._field("columnHeadersTable").length - 1; //the whole header is fixed in case of staticRowIndex >= 0.

			if (this.options.showFilter) {
			index++; // filter row is placed inside the header, so it is fixed too.
			}

			return index;
			} else {
			return this.options.staticRowIndex;
			}
			*/
			var index = this._field("columnHeadersTable").length; //the whole header is fixed in case of staticRowIndex >= 0.

			if (this.options.showFilter) {
				index++; // filter row is placed inside the header, so it is fixed too.
			}

			if (bHeader) {
				return index;
			}

			return this._getStaticIndex(true) + index;
		},

		_view: function () {
			return this._field("view");
		},

		_originalFooterRowData: function () {
			var footer = this._field("tfoot");

			return (footer && footer.length)
				? footer[0] // first row only
				: null;
		},

		_originalHeaderRowData: function () {
			var header = this._field("thead");

			return (header && header.length)
				? header[0] // first row only
				: null;
		}

		// * misc
	});
})(jQuery);
/*
 Provides the base widget for columns in the wijgrid.
*/

(function ($) {
	"use strict";
	$.widget("wijmo.c1basefield", {
		_data$prefix: "c1basefield",
		options: {
			/// <summary>
			/// A value indicating whether the column can be moved.
			/// Default: true.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ columns: [ { allowMoving: true } ] });
			/// </summary>
			allowMoving: true,

			/// <summary>
			/// A value indicating whether the column can be sized.
			/// Default: true.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ columns: [ { allowSizing: true } ] });
			/// </summary>
			allowSizing: true,

			/// <summary>
			/// Function used for changing content, style and attributes of the column cells.
			/// Default: undefined.
			/// Type: Function.
			/// Code example: $("#element").wijgrid({ columns: [ { cellFormatter: function(args) { } } ] });
			/// </summary>
			/// <remarks>
			/// Important: cellFormatter should not alter content of header and filter row cells container.
			/// </remarks>
			/// <param name="args" type="Object">
			/// args.$container: jQuery object that represents cell container to format.
			/// args.afterDefaultCallback: callback function which is invoked after applying default formatting.
			/// args.column: Options of the formatted column.
			/// args.formattedValue: Formatted value of the cell.
			/// args.row: information about associated row.
			/// args.row.$rows: jQuery object that represents rows to format.
			/// args.row.data: associated data.
			/// args.row.dataRowIndex: data row index.
			/// args.row.dataItemIndex: data item index.
			/// args.row.virtualDataItemIndex: virtual data item index.
			/// args.row.type: type of the row, one of the $.wijmo.wijgrid.rowType values.
			/// </param>
			/// <returns type="Boolean">True if container content has been changed and wijgrid should not apply the default formatting to the cell.</returns>
			cellFormatter: undefined,

			/// <summary>
			/// A value indicating the key of the data field associated with a column.
			/// If an array of hashes is used as a datasource for wijgrid, this should be string value,
			/// otherwise this should be an integer determining an index of the field in the datasource.
			/// Default: undefined
			/// Type: String or Number.
			/// Code example: $("#element").wijgrid({ columns: [ { dataKey: "ProductID" } ] });
			/// </summary>
			dataKey: undefined,

			/// <summary>
			/// Determines whether to use number type column width as the real width of the column.
			/// Default: undefined.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ columns: [ { ensurePxWidth: true } ] });
			/// </summary>
			/// <remarks>
			/// If this option is set to true, wijgrid will use the width option of the column widget.
			/// If this option is undefined, wijgrid will refer to the ensureColumnsPxWidth option.
			/// </remarks>
			ensurePxWidth: undefined,

			/// <summary>
			/// Gets or sets the footer text.
			/// The text may include a placeholder: "{0}" is replaced with the aggregate.
			/// Default: undefined.
			/// Type: String.
			/// Code example: $("#element").wijgrid({ columns: [ { footerText: "footer" } ] });
			/// </summary>
			/// <remarks>
			/// If the value is undefined the footer text will be determined automatically depending on the type of the datasource:
			///  DOM table - text in the footer cell.
			/// </remarks>
			footerText: undefined,

			/// <summary>
			/// Gets or sets the header text.
			/// Default: undefined.
			/// Type: String.
			/// Code example: $("#element").wijgrid({ columns: [ { headerText: "column0" } ] });
			/// </summary>
			/// <remarks>
			/// If the value is undefined the header text will be determined automatically depending on the type of the datasource:
			///  DOM table - text in the header cell.
			///  Array of hashes - dataKey (name of the field associated with column).
			///  Two-dimensional array - dataKey (index of the field associated with column).
			/// </remarks>
			headerText: undefined,

			/// <summary>
			/// A value indicating whether column is visible.
			/// Default: true.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ columns: [ { visible: true } ] });
			/// </summary>
			visible: true,

			/// <summary>
			/// Determines the width of the column.
			/// Default: undefined.
			/// Type: Number or String.
			/// Code example:
			/// $("#element").wijgrid({ columns: [ { width: 150 } ] });
			/// $("#element").wijgrid({ columns: [ { width: "10%" } ]});
			/// </summary>
			/// <remarks>
			/// The option could either be a number of string.
			/// Use number to specify width in pixel.
			/// Use string to specify width in percentage.
			/// By default, wijgrid emulates the table element behavior when using number as width.
			/// This means wijgrid may not have the exact width specified.
			/// If exact width is needed, please set ensureColumnsPxWidth option of wijgrid to true.
			/// </remarks>
			width: undefined
		},

		_create: function () {
			var wijgrid = this.options.owner;

			this.element.addClass("ui-widget wijmo-c1basefield ui-state-default");
			this._field("owner", wijgrid);
			delete this.options.owner;
			this._field("widgetName", this.widgetName);

			if (this.options.disabled) {
				this.disable();
			}

			if (wijgrid.options.allowColMoving) {
				wijgrid._dragndrop().attach(this);
			}
		},

		_init: function () {
			this.element.wrapInner("<div class='wijmo-wijgrid-innercell'></div>");
			this._refreshHeaderCell();
		},

		destroy: function () {
			var wijgrid = this._owner();

			if (wijgrid) {
				wijgrid._dragndrop().detach(this);
			}

			$.wijmo.wijgrid.remove$dataByPrefix(this.element, this._data$prefix);

			this.element
				.removeClass("ui-widget wijmo-c1basefield ui-state-default")
				.html(this.element.find(".wijmo-wijgrid-headertext").contents()); // restore initial cell content
		},

		_field: function (name, value) {
			//return $.wijmo.wijgrid.dataPrefix(this.element, this._data$prefix, name, value);
			return $.wijmo.wijgrid.dataPrefix(this.element[0], this._data$prefix, name, value);
		},

		_removeField: function (name) {
			var internalDataName = this._data$prefix + name;

			this.element.removeData(internalDataName);
		},

		//isInvokedOutside stands for whether setOption is invoked by related widget
		_setOption: function (key, value, isInvokedOutside) {
			var presetFunc = this["_preset_" + key],
				oldValue = this.options[key],
				optionChanged, postsetFunc;

			if (presetFunc !== undefined) {
				value = presetFunc.apply(this, [value, oldValue, isInvokedOutside]);
			}

			optionChanged = (value !== oldValue);

			//$.Widget.prototype._setOption.apply(this, arguments);  note: there is no dynamic linkage between the arguments and the formal parameter values when strict mode is used
			$.Widget.prototype._setOption.apply(this, [key, value]);

			if (optionChanged) {
				postsetFunc = this["_postset_" + key];
				if (postsetFunc !== undefined) {
					postsetFunc.apply(this, [value, oldValue, isInvokedOutside]);
				}
			}
		},

		_postset_allowMoving: function (value, oldValue, isInvokedOutside) {
			//no need to detach because there is allowMoving judgment in draganddrop
			/*
			if (value) {
			if (this._owner().options.allowColMoving) {
			this._owner()._dragndrop().attach(this);
			}
			} else {
			this._owner()._dragndrop().detach(this);
			}
			*/
			this._invokeGroupedColumn("allowMoving", value, isInvokedOutside);
		},

		_preset_clientType: function (value, oldValue) {
			throw "read-only";
		},

		_postset_headerText: function (value, oldValue, isInvokedOutside) {
			this._refreshHeaderCell();
			this._invokeGroupedColumn("headerText", value, isInvokedOutside);
		},

		_postset_visible: function (value, oldValue) {
			this._owner().ensureControl(false);
		},

		_postset_width: function (value, oldValue) {
			// change width of column.
			var view = this._owner()._view(),
			index = this.options.visLeavesIdx,
			oldRealValue = $(view.getHeaderCell(index)).outerWidth();
			view.ensureWidth(index, value, oldRealValue);
		},

		_invokeGroupedColumn: function (key, value, isInvokedOutside) {
			//invoke setOption method to set the property of related widget
			if (!isInvokedOutside && this.options.groupedIndex !== undefined) {
				var groupWidget = this._owner()._field("groupedWidgets")[this.options.groupedIndex];
				groupWidget._setOption(key, value, true);
			}
		},

		_owner: function () {
			return this._field("owner");
		},

		_canSize: function () {
			return this.options.allowSizing && this._owner().options.allowColSizing;
		},

		// drag-n-drop
		_canDrag: function () {
			return this.options.allowMoving === true;
		},

		_canDropTo: function (wijField) {
			// parent can't be dropped into a child
			if ($.wijmo.wijgrid.isChildOf(this._owner().options.columns, wijField, this)) {
				return false;
			}

			return true;
		},

		_refreshHeaderCell: function () {
			var $container = this.element.children(".wijmo-wijgrid-innercell")
				.empty()
				.html(this.options.headerText || "") // html(value) returns "" if value is undefined
				.wrapInner("<span class=\"wijmo-wijgrid-headertext\" />");
		}
	});
})(jQuery);

/*
 Provides the widget for columns in the wijgrid.
*/

(function ($) {
	"use strict";
	$.widget("wijmo.c1field", $.wijmo.c1basefield, {
		options: {
			/// <summary>
			/// Causes the grid to calculate aggregate values on the column and place them in the column footer cell or group header and footer rows.
			/// If the <see cref="showFooter"/> option is disabled or grid does not contain any groups, setting the "aggregate" option has no effect.
			/// 
			/// Possible values are: "none", "count", "sum", "average", "min", "max", "std", "stdPop", "var", "varPop" and "custom".
			///
			/// "none": no aggregate is calculated or displayed.
			/// "count": count of non-empty values.
			/// "sum": sum of numerical values.
			/// "average": average of the numerical values.
			/// "min": minimum value (numerical, string, or date).
			/// "max": maximum value (numerical, string, or date).
			/// "std": standard deviation (using formula for Sample, n-1).
			/// "stdPop": standard deviation (using formula for Population, n).
			/// "var": variance (using formula for Sample, n-1).
			/// "varPop": variance (using formula for Population, n).
			/// "custom": custom value (causing grid to throw groupAggregate event).
			///
			/// Default: "none".
			/// Type: String.
			/// Code example: $("#element").wijgrid({ columns: [{ aggregate: "none" }] });
			/// </summary>
			aggregate: "none",

			/// <summary>
			/// A value indicating whether column can be sorted.
			/// Default: true.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ columns: [{ allowSort: true }] });
			/// </summary>
			allowSort: true,

			/// <summary>
			/// Column data type. Used to determine the rules for sorting, grouping, aggregate calculation, and so on.
			/// Possible values are: "string", "number", "datetime", "currency" and "boolean".
			///
			/// "string": if using built-in parser any values are acceptable; "&nbsp;" considered as an empty string, nullString as null.
			/// "number": if using built-in parser only numeric values are acceptable, also "&nbsp;", "" and nullString which are considered as null. Any other value throws an exception.
			/// "datetime": if using built-in parser only date-time values are acceptable, also "&nbsp;", "" and nullString which are considered as null. Any other value throws an exception.
			/// "currency": if using built-in parser only numeric and currency values are acceptable, also "&nbsp;", "" and nullString which are considered as null. Any other value throws an exception.
			/// "boolean": if using built-in parser only "true" and "false" (case-insensitive) values are acceptable, also "&nbsp;", "" and nullString which are considered as null. Any other value throws an exception.
			/// 
			/// Default: "string".
			/// Type: String.
			/// Code example: $("#element").wijgrid({ columns: [{ dataType: "string" }] });
			/// </summary>
			dataType: "string",

			/// <summary>
			/// Data converter that is able to translate values from a string representation to column data type and back.
			/// 
			/// The dataParser is an object which must contains the following methods:
			///   parseDOM(value, culture, format, nullString): converts given DOM element into the typed value.
			///   parse(value, culture, format, nullString): converts the value into typed value.
			///   toStr(value, culture, format, nullString): converts the value into its string representation.
			///
			/// Default: undefined (widget built-in parser for supported datatypes will be used).
			/// Type: Object.
			///
			/// Code example:
			///   var myBoolParser = {
			///     parseDOM: function (value, culture, format, nullString) {
			///       return this.parse(value.innerHTML, culture, format, nullString);
			///     },
			///
			///     parse: function (value, culture, format, nullString) {
			///       if (typeof (value) === "boolean")  return value;
			///
			///       if (!value || (value === "&nbsp;") || (value === nullString)) {
			///         return null;
			///       }
			///
			///       switch (value.toLowerCase()) {
			///         case "on": return true;
			///         case "off": return false;
			///       }
			///
			///       return NaN;
			///     },
			///
			///     toStr: function (value, culture, format, nullString) {
			///       if (value === null)  return nullString;
			///       return (value) ? "on" : "off";
			///     }
			///   }
			///
			///   $("#element").wijgrid({ columns: [ { dataType: "boolean", dataParser: myBoolParser } ] });
			/// </summary>
			dataParser: undefined,

			/// <summary>
			/// A pattern used for formatting and parsing column values. See globalize.js for possible values.
			/// The default value is undefined ("n" pattern will be used for "number" dataType, "d" for "datetime", "c" for "currency").
			/// Default: undefined.
			/// Type: String.
			/// Code example: $("#element").wijgrid({ columns: [ { dataType: "number", dataFormatString: "n" } ] });
			/// </summary>
			dataFormatString: undefined,

			/// <summary>
			/// An operations set for filtering. Must be either one of the embedded operators or custom filter operator.
			/// Operator names are case insensitive. 
			///
			/// Embedded filter operators include:
			///   "NoFilter": no filter.
			///   "Contains": applicable to "string" data type.
			///   "NotContain": applicable to "string" data type.
			///   "BeginsWith": applicable to "string" data type.
			///   "EndsWith": applicable to "string" data type.
			///   "Equals": applicable to "string", "number", "datetime", "currency" and "boolean" data types.
			///   "NotEqual": applicable to "string", "number", "datetime", "currency" and "boolean" data types.
			///   "Greater": applicable to "string", "number", "datetime", "currency" and "boolean" data types.
			///   "Less": applicable to "string", "number", "datetime", "currency" and "boolean" data types.
			///   "GreaterOrEqual": applicable to "string", "number", "datetime", "currency" and "boolean" data types.
			///   "LessOrEqual": applicable to "string", "number", "datetime", "currency" and "boolean" data types.
			///   "IsEmpty": applicable to "string".
			///   "NotIsEmpty": applicable to "string".
			///   "IsNull": applicable to "string", "number", "datetime", "currency" and "boolean" data types.
			///   "NotIsNull": applicable to "string", "number", "datetime", "currency" and "boolean" data types.
			///
			/// Full option value is:
			///   [filterOperartor1, ..., filterOperatorN]
			/// 
			/// where each filter item is an object of the following kind:
			///   { name: <operatorName>, condition: "or"|"and" }
			///
			/// where:
			///   name: filter operator name.
			///   condition: logical condition to other operators, "or" is by default.
			///
			/// Example:
			///   filterOperator: [ { name: "Equals" }, { name: "NotEqual", condition: "and" } ]
			///
			/// It is possible to use shorthand notation, the following statements are equivalent:
			///   filterOperator: [ { name: "Equals" }, { name: "BeginsWith" } ]
			///   filterOperator: [ "Equals", "BeginsWith" ]
			///
			/// In the case of a single operator option name may contain only filter operator name, the following statements are equivalent:
			///   filterOperator: [ { name: "Equals" } ]
			///   filterOperator: [ "Equals" ]
			///   filterOperator: "Equals"
			///
			/// Note: wijgrid built-in filter editors do not support multiple filter operators.
			///
			/// Default: "nofilter".
			/// Type: Object.
			/// Code example: $("#element").wijgrid({ columns: [ { filterOperator: "nofilter" } ] });
			/// </summary>
			filterOperator: "nofilter",

			/// <summary>
			/// A value set for filtering.
			///
			/// Full option value is:
			///   [filterValue1, ..., filterValueN]
			///
			/// where each item is a filter value for the corresponding filter operator.
			///
			/// Example:
			///  filterValue: [0, "a", "b"]
			///
			/// Built-in filter operators support array of values as an argument.
			///
			/// Example:
			///   filterOperator: ["Equals", "BeginsWith"]
			///   filterValue: [[0, 1, 2], "a"]
			///
			///   As a result of filtering all the records having 0, 1, 2, or starting with "a" will be fetched.
			///
			/// Shorthand notation allows omitting square brackets, the following statements are equivalent:
			///    filterValue: ["a"]
			///    filterValue: [["a"]]
			///    filterValue: "a"
			///
			/// Note: wijgrid built-in filter editors do not support multiple filter values.
			///
			/// Default: undefined.
			/// Type: Depends on column data type.
			/// Code example: $("#element").wijgrid({ columns: [ { filterValue: "abc" } ] });
			/// </summary>
			filterValue: undefined,

			/// <summary>
			/// Using to customize the appearance and position of groups.
			/// Default: {
			///   groupSingleRow: true,
			///   collapsedImageClass: "ui-icon-triangle-1-e",
			///   expandedImageClass: "ui-icon-triangle-1-se",
			///   position: "none",
			///   outlineMode: "startExpanded",
			///   headerText: undefined,
			///   footerText: undefined
			/// }
			/// Type: Object.
			/// Code example: $("#element").wijgrid({ columns: [{ groupInfo: { position: "header" }}] });
			/// </summary>
			groupInfo: {
				expandInfo: [], // infrastructure

				/// <summary>
				/// A value indicating whether groupings containing a single row are grouped.
				/// The default value is true.
				/// Type: Boolean.
				/// </summary>
				groupSingleRow: true,

				/// <summary>
				/// Determines the css used to show collapsed nodes on the grid.
				/// The default value is "ui-icon-triangle-1-e".
				/// Type: String.
				/// </summary>
				collapsedImageClass: "ui-icon-triangle-1-e",

				/// <summary>
				/// Determines the css used to show expanded nodes on the grid.
				/// The default value is "ui-icon-triangle-1-se".
				/// Type: String.
				/// </summary>
				expandedImageClass: "ui-icon-triangle-1-se",

				/// <summary>
				/// Determines whether the grid should insert group header and/or group footer rows for this column.
				///
				/// Possible values are: "none", "header", "footer", "headerAndFooter".
				///  "none" -  disables grouping for the column.
				///  "header" - inserts header rows.
				///  "footer" - inserts footer rows.
				///  "headerAndFooter" - inserts header and footer rows.
				///
				/// The default value is "none".
				/// Type: String.
				/// </summary>
				position: "none",

				/// <summary>
				/// Determines whether the user will be able to collapse and expand the groups by clicking on the group headers,
				/// and also determines whether groups will be initially collapsed or expanded.
				///
				/// Possible values are: "none", "startCollapsed", "startExpanded".
				///  "none" -  disables collapsing and expanding.
				///  "startCollapsed" - groups are initially collapsed.
				///  "startExpanded" - groups are initially expanded.
				///
				/// The default value is "startExpanded".
				/// Type: String.
				/// </summary>
				outlineMode: "startExpanded",

				/// <summary>
				/// Determines the text that is displayed in the group header rows.
				///
				/// The text may include up to three placeholders:
				/// "{0}" is replaced with the value being grouped on.
				/// "{1}" is replaced with the group's column header.
				/// "{2}" is replaced with the aggregate
				///
				/// The text may be set to "custom". Doing so causes the grid groupText event to be raised when
				/// processing a grouped header.
				///
				/// The default value is undefined.
				/// Type: String.
				/// </summary>
				headerText: undefined,

				/// <summary>
				/// Determines the text that is displayed in the group footer rows.
				///
				/// The text may include up to three placeholders:
				/// "{0}" is replaced with the value being grouped on.
				/// "{1}" is replaced with the group's column header.
				/// "{2}" is replaced with the aggregate
				///
				/// The text may be set to "custom". Doing so causes the grid groupText event to be raised when
				/// processing a grouped footer.
				///
				/// The default value is undefined.
				/// Type: String.
				/// </summary>
				footerText: undefined
			},

			/// <summary>
			/// A value indicating whether the cells in the column can be edited.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ columns: [ { readOnly: false } ] });
			/// </summary>
			readOnly: false,

			/// <summary>
			/// Determines whether rows are merged.
			/// Possible values are: "none", "free" and "restricted".
			///
			/// "none": no row merging.
			/// "free": allows row with identical text to merge.
			/// "restricted": keeps rows with identical text from merging if rows in the previous column are merged.
			/// 
			/// Default: "none".
			/// Type: String.
			/// Code example: $("#element").wijgrid({ columns: [{ rowMerge: "none" }] });
			/// </summary>
			rowMerge: "none",

			/// <summary>
			/// A value indicating whether filter editor will be shown in the filter row.
			/// Default: true.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ columns: [ { showFilter: true } ] });
			/// </summary>
			showFilter: true,

			/// <summary>
			/// Determines the sort direction.
			/// Possible values are: "none", "ascending" and "descending".
			///
			/// "none": no sorting.
			/// "ascending": sort from smallest to largest.
			/// "descending": sort from largest to smallest.
			/// 
			/// Default: "none".
			/// Type: String.
			/// Code example: $("#element").wijgrid({ columns: [{ sortDirection: "none" }] });
			/// </summary>
			sortDirection: "none",

			/// <summary>
			/// A value indicating whether null value is allowed during editing.
			/// Default: false.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ columns: [ { valueRequired: false } ] });
			/// </summary>
			valueRequired: false
		},

		_create: function () {
			$.wijmo.c1basefield.prototype._create.apply(this, arguments);
			this.element.addClass("ui-widget wijmo-c1field");
		},

		destroy: function () {
			this.element.find("*").unbind("." + this.widgetName);

			if (this.$filterEditor) {
				this.$filterEditor
					.closest("td") // column filter cell
					.find("*")
					.unbind("." + this.widgetName);

				switch (this._getInputEditorType(this.options)) {
					case "date":
						if (this.$filterEditor.data("wijinputdate")) {
							this.$filterEditor.wijinputdate("destroy");
						}
						break;

					case "mask":
						if (this.$filterEditor.data("wijinputmask")) {
							this.$filterEditor.wijinputmask("destroy");
						}
						break;

					case "numberCurrency":
					case "numberNumber":
					case "numberPercent":
						if (this.$filterEditor.data("wijinputnumber")) {
							this.$filterEditor.wijinputnumber("destroy");
						}
						break;
				}

				this.$filterEditor = null;
			}

			this.element
				.removeClass("ui-widget wijmo-c1field")
				.find(".wijmo-wijgrid-headertext > span.ui-icon").remove(); // remove ascending/ descending icon

			this._removeDropDownFilterList();

			$.wijmo.c1basefield.prototype.destroy.apply(this, arguments);
		},

		_init: function () {
			$.wijmo.c1basefield.prototype._init.apply(this, arguments);

			this.$filterEditor = null;

			var wijgrid = this._owner();

			this.filterRow = wijgrid._filterRow();
			if (wijgrid.options.showFilter && this.options.showFilter && (this.options.dataIndex >= 0)) {
				this._prepareFilterCell();
			}
		},

		_postset_aggregate: function (value, oldValue) {
			this._owner().ensureControl(false);
		},

		_postset_allowSort: function (value, oldValue, isInvokedOutside) {
			//this.element.find("#contentCell").empty();
			//this._headerTextDOM(this.options.headerText);
			this._refreshHeaderCell();
			this._invokeGroupedColumn("allowSort", value, isInvokedOutside);
		},

		_postset_dataType: function (value, oldValue) {
			throw "read-only";
		},

		_postset_dataParser: function (value, oldValue) {
			this._owner().ensureControl(false);
		},

		_postset_dataFormatString: function (value, oldValue) {
			this._owner().ensureControl(false);
		},

		_postset_filterOperator: function (value, oldValue) {
			this._owner().ensureControl(true);
		},

		_postset_filterValue: function (value, oldValue) {
			this._owner().ensureControl(true);
		},

		_postset_groupInfo: function (value, oldValue) {
			this._owner().ensureControl(true);
		},

		_postset_rowMerge: function (value, oldValue) {
			this._owner().ensureControl(false);
		},

		_postset_showFilter: function (value, oldValue) {
			this._owner().ensureControl(false);
		},

		_postset_sortDirection: function (value, oldValue) {
			this.options.sortOrder = 0;
			this._owner().ensureControl(true);
		},

		_postset_width: function (value, oldValue) {
			this._setFilterEditorWidth(1);
			$.wijmo.c1basefield.prototype._postset_width.apply(this, arguments);
			this._setFilterEditorWidth(this._getFilterEditorWidth());
		},

		_canDropTo: function (wijField) {
			if ($.wijmo.c1basefield.prototype._canDropTo.apply(this, arguments)) {
				//the grouped column can't be dropped into group area
				if (this.options.groupedIndex !== undefined && (wijField instanceof $.wijmo.c1groupedfield)) {
					return false;
				}

				return true;
			}

			return false;
		},

		_canSort: function () {
			var grid = this._owner();

			return (grid && grid.options.allowSorting && this.options.allowSort && (this.options.dataIndex >= 0));
		},

		_refreshHeaderCell: function () {
			if (this._canSort()) {
				var $anchor,
					$container = this.element.children(".wijmo-wijgrid-innercell")
						.empty()
						.html(this.options.headerText || "") // html(value) returns "" if value is undefined
						.wrapInner("<a class=\"wijmo-wijgrid-headertext\" href=\"#\" role=\"button\" />");

				$anchor = $container.children("a").bind("click." + this.widgetName, this, this._onHrefClick);

				switch (this.options.sortDirection) { // sorting icon
					case "ascending":
						$anchor.append($("<span class=\"ui-icon ui-icon-triangle-1-n\">ascending</span>"));
						break;

					case "descending":
						$anchor.append($("<span class=\"ui-icon ui-icon-triangle-1-s\">descending</span>"));
						break;
				}
			} else {
				$.wijmo.c1basefield.prototype._refreshHeaderCell.apply(this, arguments);
			}
		},

		_prepareFilterCell: function () {
			var filterCellIndex = this.options.visLeavesIdx,
				gridView = null,
				filterCell = null,
				dataValue, editorOptions,
				self = this,
				editorType;

			if (filterCellIndex >= 0) {
				gridView = this._owner();

				if (this.filterRow) {
					filterCell = $(new $.wijmo.wijgrid.rowAccessor().getCell(this.filterRow, filterCellIndex));
				} else {
					throw "exception";
				}

				this.$filterEditor = filterCell.find("input");
				//the problem of inputing in the filter textbox
				filterCell.bind(($.support.selectstart ? "selectstart" : "mousedown"), function (event) {
					event.stopPropagation();
				});

				//var editorWidth = this._getFilterEditorWidth();
				//this.$filterEditor.setOutWidth(editorWidth);

				dataValue = gridView._parse(this.options, $.wijmo.wijgrid.filterHelper.getSingleValue(this.options.filterValue));

				// set default value
				if (dataValue === null) {
					switch (this.options.dataType) {
						case "boolean":
							dataValue = false;
							break;

						case "number":
						case "currency":
						case "datetime":
							dataValue = 0;
							break;

						default:
							dataValue = "";
					}
				}

				editorOptions = {
					culture: gridView.options.culture,
					disabled: gridView.options.disabled,
					decimalPlaces: (function (pattern) { // map decimal places specified within the dataFormatString option into the decimalPlaces option of the wijinputnumber.
						var test = /^(n|p|c){1}(\d*)$/.exec(pattern);

						if (test) {
							if (test[2]) {
								return parseInt(test[2], 10);
							}
						}

						return 2;
					})(this.options.dataFormatString)
				};

				// create editor
				switch (editorType = this._getInputEditorType(this.options)) {
					case "date":
						this.$filterEditor.wijinputdate($.extend(editorOptions, { date: dataValue }));
						break;

					case "mask":
						this.$filterEditor.wijinputmask({ text: dataValue + "" });
						break;

					case "numberCurrency":
						this.$filterEditor.wijinputnumber($.extend(editorOptions, { type: "currency", value: dataValue }));
						break;

					case "numberNumber":
						this.$filterEditor.wijinputnumber($.extend(editorOptions, { value: dataValue }));
						break;

					case "numberPercent":
						this.$filterEditor.wijinputnumber($.extend(editorOptions, { type: "percent", value: dataValue * 100 }));
						break;

					default:
						throw $.wijmo.wijgrid.stringFormat("Unsupported editor type: \"{0}\"", editorType);
				}

				// create button
				//var filterButton = filterCell.find(".filterBtn");
				filterCell.find(".wijmo-wijgrid-filter-trigger") // filter button
					.attr({ "role": "button", "aria-haspopup": "true" })
					.bind("mouseenter." + this.widgetName, function (e) {
						if (!self.options.disabled) {
							$(this).addClass("ui-state-hover");
						}
					}).bind("mouseleave." + this.widgetName, function (e) {
						if (!self.options.disabled) {
							$(this).removeClass("ui-state-hover ui-state-active");
						}
					}).bind("mouseup." + this.widgetName, this, function (e) {
						if (!self.options.disabled) {
							$(this).removeClass("ui-state-active");
						}
					}).bind("mousedown." + this.widgetName, { column: this }, this._onFilterBtnClick)
					.bind("click." + this.widgetName, function (e) { e.preventDefault(); }); // prevent # being added to url.
			}
		},

		_onFilterBtnClick: function (e) {
			var column = e.data.column,
				maxItemsCount = 8,
				wijgrid, filterOpLC, applicableFilters, args, items, key, operator, width, eventGuid;

			if (column.options.disabled) {
				return false;
			}

			if (column.$dropDownFilterList) { // close the dropdown list
				column._removeDropDownFilterList();
				return false;
			}

			wijgrid = column._owner();
			filterOpLC = $.wijmo.wijgrid.filterHelper.getSingleOperatorName(column.options.filterOperator).toLowerCase();
			applicableFilters = wijgrid.filterOperatorsCache.getByDataType(column.options.dataType);

			wijgrid.filterOperatorsCache.sort(applicableFilters, wijgrid.options.filterOperatorsSortMode);

			args = $.extend(true, {}, { operators: applicableFilters, column: column.options });
			wijgrid._trigger("filterOperatorsListShowing", null, args);

			items = [];
			if (args.operators) {
				for (key in args.operators) {
					if (args.operators.hasOwnProperty(key)) {
						operator = args.operators[key];

						items.push({
							label: operator.displayName || operator.name,
							value: operator.name,
							selected: operator.name.toLowerCase() === filterOpLC
						});
					}
				}
			}

			column.$dropDownFilterList = $("<div class=\"wijmo-wijgrid-filterlist\"></div").appendTo(document.body).wijlist(
			{
				autoSize: true,
				maxItemsCount: maxItemsCount,
				selected: function (data, arg) {
					var filterValue,
						editorType;

					switch (editorType = column._getInputEditorType(column.options)) {
						case "date":
							filterValue = column.$filterEditor.wijinputdate("option", "date");
							break;

						case "mask":
							filterValue = column.$filterEditor.wijinputmask("option", "text");
							break;

						case "numberCurrency":
						case "numberNumber":
						case "numberPercent":
							filterValue = column.$filterEditor.wijinputnumber("option", "value");

							if (editorType === "numberPercent") {
								filterValue /= 100;
							}

							break;
					}

					column._removeDropDownFilterList();

					wijgrid._handleFilter(column, arg.item.value, filterValue);
				}
			});

			column.$dropDownFilterList
				.wijlist("setItems", items)
				.wijlist("renderList");

			width = column.$dropDownFilterList.width() | 150;

			column.$dropDownFilterList
				.width(items.length > maxItemsCount ? width + 20 : width)
				.wijlist("refreshSuperPanel")
				.position({
					of: $(this),
					my: "left top",
					at: "left bottom"
				});

			column.$dropDownFilterList.$button = $(this);

			eventGuid = column.$dropDownFilterList.eventGuid = new Date().getTime();
			$(document).bind("mousedown." + column.widgetName + "." + eventGuid, { column: column }, column._onDocMouseDown);
		},

		_onDocMouseDown: function (e) {
			var $target = $(e.target),
				$filterList = $target.parents(".wijmo-wijgrid-filterlist:first"),
				$filterButton = $target.is(".wijmo-wijgrid-filter-trigger")
					? $target
					: $target.parents(".wijmo-wijgrid-filter-trigger:first");

			if (($filterButton.length && ($filterButton[0] === e.data.column.$dropDownFilterList.$button[0])) ||
			 ($filterList.length && ($filterList[0] === e.data.column.$dropDownFilterList[0]))) {
				// do nothing
			} else {
				e.data.column._removeDropDownFilterList();
			}
		},

		_onHrefClick: function (args) {
			if (args.data.options.disabled) {
				return false;
			}

			if (args.data.options.allowSort) {
				args.data._owner()._handleSort(args.data.options, args.ctrlKey);
			}

			return false;
		},

		_removeDropDownFilterList: function () {
			if (this.$dropDownFilterList) {
				var eventGuid = this.$dropDownFilterList.eventGuid;

				this.$dropDownFilterList.remove();

				this.$dropDownFilterList = null;

				$(document).unbind("mousedown." + this.widgetName + "." + eventGuid, this._onDocMouseDown);
			}
		},

		_getFilterEditorWidth: function () {
			if (this.$filterEditor) {
				var $fd = this.$filterEditor.closest(".wijmo-wijgrid-filter"),
					value = $fd.width() - $fd.find(".wijmo-wijgrid-filter-trigger").width();

				if (!value || value < 0) {
					value = 0;
				}

				return value;
			}

			return undefined;
		},

		_setFilterEditorWidth: function (width) {
			if (this.$filterEditor) {
				width -= this.$filterEditor.leftBorderWidth() + this.$filterEditor.rightBorderWidth();

				if (width < 0) {
					width = 0;
				}

				switch (this._getInputEditorType(this.options)) {
					case "date":
						this.$filterEditor.wijinputdate("widget").width(width);
						break;

					case "mask":
						this.$filterEditor.wijinputmask("widget").width(width);
						break;

					case "numberCurrency":
					case "numberNumber":
					case "numberPercent":
						this.$filterEditor.wijinputnumber("widget").width(width);
						break;
				}

				this.$filterEditor.setOutWidth(width);
			}
		},

		// "mask", "date", "numberNumber", "numberPercent", "numberCurrency"
		_getInputEditorType: function (column) {
			switch (column.dataType) {
				case "number":
					return (column.dataFormatString && column.dataFormatString.indexOf("p") === 0)
						? "numberPercent"
						: "numberNumber";

				case "currency":
					return "numberCurrency";

				case "datetime":
					return "date";

				default:
					return "mask";
			}
		}
	});
})(jQuery);


/*
 Provides the grouped widget for columns in the wijgrid.
*/

(function ($) {
	"use strict";
	$.widget("wijmo.c1groupedfield", {
		_data$prefix: "c1groupedfield",
		options: {
			/// <summary>
			/// A value indicating whether the column can be moved.
			/// Default: true.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ columns: [ { allowMoving: true } ] });
			/// </summary>
			allowMoving: true,

			/// <summary>
			/// A value indicating whether column can be sorted.
			/// Default: true.
			/// Type: Boolean.
			/// Code example: $("#element").wijgrid({ columns: [{ allowSort: true }] });
			/// </summary>
			allowSort: true,

			/// <summary>
			/// Gets or sets the header text.
			/// Default: undefined.
			/// Type: String.
			/// Code example: $("#element").wijgrid({ columns: [ { headerText: "column0" } ] });
			/// </summary>
			/// <remarks>
			/// If the value is undefined the header text will be determined automatically depending on the type of the datasource:
			///  DOM table - text in the header cell.
			///  Array of hashes - dataKey (name of the field associated with column).
			///  Two-dimensional array - dataKey (index of the field associated with column).
			/// </remarks>
			headerText: undefined,

			/// <summary>
			/// Determines the sort direction.
			/// Possible values are: "none", "ascending" and "descending".
			///
			/// "none": no sorting.
			/// "ascending": sort from smallest to largest.
			/// "descending": sort from largest to smallest.
			/// 
			/// Default: "none".
			/// Type: String.
			/// Code example: $("#element").wijgrid({ columns: [{ sortDirection: "none" }] });
			/// </summary>
			sortDirection: "none"
		},

		_create: function () {
			var wijgrid = this.options.owner;

			this.element.addClass("wijmo-wijgrid-group-button ui-state-default ui-corner-all");
			this._field("owner", wijgrid);
			delete this.options.owner;

			if (this.options.disabled) {
				this.disable();
			}

			if (wijgrid.options.allowColMoving) {
				wijgrid._dragndrop().attach(this);
			}
		},

		_init: function () {
			this._refreshHeaderCell();
		},

		destroy: function () {
			this.element.find("*").unbind("." + this.widgetName);

			var wijgrid = this._owner();

			if (wijgrid) {
				wijgrid._dragndrop().detach(this);
			}

			$.wijmo.wijgrid.remove$dataByPrefix(this.element, this._data$prefix);
		},

		_field: function (name, value) {
			return $.wijmo.wijgrid.dataPrefix(this.element[0], this._data$prefix, name, value);
		},

		_removeField: function (name) {
			var internalDataName = this._data$prefix + name;

			this.element.removeData(internalDataName);
		},

		_setOption: function (key, value, isInvokedOutside) {
			var presetFunc = this["_preset_" + key],
				oldValue = this.options[key],
				optionChanged, postsetFunc;

			if (presetFunc !== undefined) {
				value = presetFunc.apply(this, [value, oldValue, isInvokedOutside]);
			}

			optionChanged = (value !== oldValue);

			//$.Widget.prototype._setOption.apply(this, arguments);  note: there is no dynamic linkage between the arguments and the formal parameter values when strict mode is used
			$.Widget.prototype._setOption.apply(this, [key, value]);

			if (optionChanged) {
				postsetFunc = this["_postset_" + key];
				if (postsetFunc !== undefined) {
					postsetFunc.apply(this, [value, oldValue, isInvokedOutside]);
				}
			}
		},

		_postset_headerText: function (value, oldValue, isInvokedOutside) {
			this._refreshHeaderCell();
		},

		_postset_allowSort: function (value, oldValue, isInvokedOutside) {
			this._refreshHeaderCell();
		},

		_owner: function () {
			return this._field("owner");
		},

		_canSize: function () {
			return this.options.allowSizing && this._owner().options.allowColSizing;
		},

		// drag-n-drop
		_canDrag: function () {
			return this.options.allowMoving === true;
		},

		_canDropTo: function (wijField) {
			//band can't be dropped into group area
			if (!(wijField instanceof $.wijmo.c1groupedfield)) {
				return false;
			}

			// parent can't be dropped into a child
			if ($.wijmo.wijgrid.isChildOf(this._owner().options.columns, wijField, this)) {
				return false;
			}

			return true;
		},

		_canSort: function () {
			var grid = this._owner();

			return (grid && grid.options.allowSorting && this.options.allowSort && (this.options.dataIndex >= 0));
		},

		_refreshHeaderCell: function () {
			var $closeButton = $("<span class=\"wijmo-wijgrid-group-button-close ui-state-default ui-corner-all\"><span class=\"ui-icon ui-icon-close\"></span></span>")
				.bind("click." + this.widgetName, this, this._onCloseClick);
			this.element
				.html(this.options.headerText || "") // html(value) returns "" if value is undefined
				.prepend($closeButton)
				.bind("click." + this.widgetName, this, this._onHrefClick);
			if (this._canSort()) {
				switch (this.options.sortDirection) { // sorting icon
					case "ascending":
						this.element.append($("<span class=\"wijmo-wijgrid-group-button-sort ui-icon ui-icon-triangle-1-n\"></span>"));
						break;

					case "descending":
						this.element.append($("<span class=\"wijmo-wijgrid-group-button-sort ui-icon ui-icon-triangle-1-s\"></span>"));
						break;
				}
			}
		},

		_onCloseClick: function (args) {
			var options = args.data.options;

			if (!options.disabled) {
				args.data._owner()._handleUngroup(args.data.options.travIdx);
			}

			return false;
		},

		_onHrefClick: function (args) {
			var wijgrid = args.data._owner(),
				options = args.data.options,
				column;

			if (!options.disabled && options.allowSort) {
				//find the column according to the c1groupedfield widget
				column = $.wijmo.wijgrid.search(wijgrid.columns(), function (test) {
					return test.options.travIdx === options.travIdx;
				});

				column = (!column.found) // grouped column is invisible?
					? $.wijmo.wijgrid.getColumnByTravIdx(wijgrid.options.columns, options.travIdx).found
					: column.found.options;

				if (column) {
					wijgrid._handleSort(column, args.ctrlKey);
				}
			}

			return false;
		}
	});
})(jQuery);

(function ($) {
	"use strict";
	$.widget("wijmo.c1band", $.wijmo.c1basefield, {
		options: {
			/// <summary>
			/// Gets a array of objects representing the columns of the band.
			/// The default value is an empty array.
			/// Type: Array.
			/// </summary>
			columns: []
		},

		_create: function () {
			$.wijmo.c1basefield.prototype._create.apply(this, arguments);
			this.element.addClass("ui-widget wijmo-c1band");
		},

		_canDropTo: function(wijField) {
			if ($.wijmo.c1basefield.prototype._canDropTo.apply(this, arguments)) {
				//band can't be dropped into group area
				return !(wijField instanceof $.wijmo.c1groupedfield);
			}
 
			return false;
		}
	});
})(jQuery);

(function ($) {
	"use strict";
	// traversing, band processing
	$.extend($.wijmo.wijgrid, {
		bandProcessor: function () {
			var height, width, table, traverseList, shift, inc, savedXPos;

			this.generateSpanTable = function (root, leaves) {
				height = width = inc = shift = 0;
				table = [];
				traverseList = [];
				savedXPos = [];

				var spanTable = this._generateSpanTable(root, leaves, true);

				return spanTable;
			};

			this._generateSpanTable = function (root, leaves, parentVisibility) {
				var i, j;
					height = this._getVisibleHeight(root, parentVisibility);

				leaves = leaves || [];

				//var foo = function(self) {
				$.wijmo.wijgrid.traverse(root, function (column) {
					if (column.isLeaf) {
						leaves.push(column);
					}
					traverseList.push(column);
					//self.traverseList.push(column);
				});
				//} (this); // make closure

				width = leaves.length;

				for (i = 0; i < height; i++) {
					table[i] = [];
					for (j = 0; j < width; j++) {
						table[i][j] = { column: null, colSpan: 0, rowSpan: 0 };
					}
				}

				this._setTableValues(root, 0, 0);

				return table;
			};

			this._getVisibleHeight = function (root, parentVisibility) {
				var i, len, colVis, tmp, result = 0;

				if ($.isArray(root)) { // columns
					for (i = 0, len = root.length; i < len; i++) {
						tmp = this._getVisibleHeight(root[i], parentVisibility);
						result = Math.max(result, tmp);
					}
				} else { // column
					colVis = (root.visible === undefined) ? true : root.visible;
					root.parentVis = colVis && parentVisibility;

					if (root.isBand) { // band
						for (i = 0, len = root.columns.length; i < len; i++) {
							tmp = this._getVisibleHeight(root.columns[i], root.parentVis);
							result = Math.max(result, tmp);
						}

						if (!root.parentVis) {
							return result;
						}

						root.isLeaf = (result === 0);
						result++;
					} else { // general column
						root.isLeaf = true;
						if (root.parentVis) {
							result = 1;
						}
					}
				}

				return result;
			};

			this._getVisibleParent = function (column) {

				while (column) {
					column = traverseList[column.parentIdx];
					if (column && (column.parentVis || column.parentVis === undefined)) {
						return column;
					}
				}

				return null;
			};

			this._setTableValues = function (root, y, x) {
				var i, len, tx, posX, parentIsLeaf, visibleParent;

				if ($.isArray(root)) { //
					for (i = 0, len = root.length; i < len; i++) {
						this._setTableValues(root[i], y, x);
					}
				} else { // column
					if (root.travIdx === undefined) {
						throw "undefined travIdx";
					}

					tx = x + shift;

					if (root.parentVis) {
						posX = tx + inc;
						table[y][posX].column = root;
						savedXPos[root.travIdx] = posX;
					}

					if (root.isBand) { // band
						for (i = 0, len = root.columns.length; i < len; i++) {
							this._setTableValues(root.columns[i], y + 1, x);
						}
					}

					if (root.parentVis) {
						if (shift - tx === 0) { //root is column or band without visible nodes
							table[y][savedXPos[root.travIdx]].rowSpan = height - y;
							shift++;
						} else { // band with visible nodes
							table[y][savedXPos[root.travIdx]].colSpan = shift - tx;
						}
					} else {
						if (!root.isBand && height > 0) {
							visibleParent = this._getVisibleParent(root);

							parentIsLeaf = (visibleParent)
							? visibleParent.isLeaf
							: false;

							if (parentIsLeaf) {
								inc++;
							}

							if (y >= height) {
								y = height - 1;
							}

							posX = x + shift + inc;

							table[y][posX].column = root;

							if (!parentIsLeaf) {
								if (visibleParent && (savedXPos[visibleParent.travIdx] === posX)) {
									this._shiftTableElements(posX, y);
								}

								inc++;
							}
						}
					}
				}
			};

			this._shiftTableElements = function (x, untilY) {
				var i;

				for (i = 0; i < untilY; i++) {
					table[i][x + 1] = table[i][x];
					table[i][x] = { column: null, colSpan: 0, rowSpan: 0 };

					if (table[i][x + 1].column) {
						savedXPos[table[i][x + 1].column.travIdx]++;
					}
				}
			};
		},

		// returns both visible and invisible leaves.
		getAllLeaves: function (columns) {
			var leaves = [];

			this._getAllLeaves(columns, leaves);

			return leaves;
		},

		_getAllLeaves: function (columns, leaves) {
			var i, len, column, subColumns;

			if (columns) {
				for (i = 0, len = columns.length; i < len; i++) {
					column = columns[i];

					if (column.options) { // widget
						column = column.options;
					}

					subColumns = column.columns;
					if (subColumns && subColumns.length) {
						this._getAllLeaves(subColumns, leaves);
					}
					else {
						leaves.push(column);
					}
				}
			}
		},

		// returns null or { found (object), at (array) } object.
		getColumnByTravIdx: function (columns, travIdx) {
			var i, len, column, result = null;

			if (columns && travIdx >= 0) {
				for (i = 0, len = columns.length; i < len && !result; i++) {
					column = columns[i];

					if (column.options) { // widget
						column = column.options;
					}

					if (column.travIdx === travIdx) {
						return { found: column, at: columns };
					}

					if (column.columns) {
						result = this.getColumnByTravIdx(column.columns, travIdx);
					}
				}
			}

			return result;
		},

		isChildOf: function (columns, child, parent) {
			if (child.options) {
				child = child.options;
			}

			if (parent.options) {
				parent = parent.options;
			}

			if (parent.isBand && child.parentIdx >= 0) {
				if (child.parentIdx === parent.travIdx) {
					return true;
				}

				if (child.parentIdx > parent.travIdx) {
					var traverse = this.flatten(columns);

					while (true) {
						child = traverse[child.parentIdx];

						if (child.travIdx === parent.travIdx) {
							return true;
						}

						if (child.parentIdx === -1) {
							break;
						}
					}
				}
			}

			return false;
		},

		getLeaves: function (columns) {
			var leaves = [];

			this._getLeaves(columns, leaves);

			return leaves;
		},

		_getLeaves: function (columns, leaves) {
			var i, len, column;

			if (columns) {
				for (i = 0, len = columns.length; i < len; i++) {
					column = columns[i];

					if (column.isLeaf) {
						leaves.push(column);
					}

					if (column.columns) {
						this._getLeaves(column.columns, leaves);
					}
				}
			}
		},

		setTraverseIndex: function (columns) {
			return this._setTraverseIndex(columns, 0, -1); // -> columns length
		},

		_setTraverseIndex: function (columns, idx, parentIdx) {
			var i, len, column;

			if (columns) {
				for (i = 0, len = columns.length; i < len; i++) {
					column = columns[i];

					if (column.options) { // widget
						column = column.options;
					}

					column.linearIdx = i;
					column.travIdx = idx++;
					column.parentIdx = parentIdx;

					if (column.columns) {
						idx = this._setTraverseIndex(column.columns, idx, idx - 1);
					}
				}
			}

			return idx;
		},

		flatten: function (columns) {
			var result = [];

			this.traverse(columns, function (column) {
				result.push(column);
			});

			return result;
		},

		traverse: function (columns, callback) {
			var i, len, column;

			if (columns && ($.isFunction(callback))) {
				for (i = 0, len = columns.length; i < len; i++) {
					column = columns[i];

					if (column.options) { // widget
						column = column.options;
					}

					callback(column);

					if (column.columns) { // go deeper
						this.traverse(column.columns, callback);
					}
				}
			}
		},

		getAriaHeaders: function (visibleLeaves, traverseList) {
			var i, len, leaf, value, result = [];

			for (i = 0, len = visibleLeaves.length; i < len; i++) {
				leaf = visibleLeaves[i];
				value = "";

				do {
					value += escape(leaf.headerText) + " ";
				} while ((leaf = traverseList[leaf.parentIdx])/*&& leaf.parentVis*/);

				result[i] = $.trim(value);
			}

			return result;
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		// section:
		// 1 - tHead
		// 2 - tBody
		// 3 - tFoot
		// otherwise - table
		getTableSection: function (table, section) {
			if (table && !table.nodeType) {
				table = table[0]; // jQuery
			}

			if (table) {
				switch (section) {
					case 1:
						return table.tHead;

					case 2:
						if (table.tBodies) {
							return table.tBodies[0] || null;
						}
						break;

					case 3:
						return table.tFoot;

					default:
						return table;
				}
			}

			return null;
		},

		// section:
		// 1 - tHead
		// 2 - tBody
		// 3 - tFoot
		// otherwise - table
		getTableSectionLength: function (table, section) {
			if (table && !table.nodeType) {
				table = table[0]; // jQuery
			}

			return (table && (section = this.getTableSection(table, section)))
				? section.rows.length
				: 0;
		},

		getTableSectionRow: function (table, section, rowIndex) {
			if (table && !table.nodeType) {
				table = table[0]; // jQuery
			}

			return (table && (section = this.getTableSection(table, section)))
				? section.rows[rowIndex] || null
				: null;
		},

		// section:
		// 1 - tHead
		// 2 - tBody
		// 3 - tFoot
		// otherwise - table
		readTableSection: function (table, section, readAttributes) {
			var ri, rowLen, ci, celLen, row, tmp,
				result = [],
				prevent = function (attrName) {
					attrName = attrName.toLowerCase();
					return attrName === "rowspan" || attrName === "colspan";
				};

			if (table && !table.nodeType) {
				table = table[0]; // jQuery
			}

			if (table && (section = this.getTableSection(table, section))) {
				for (ri = 0, rowLen = section.rows.length; ri < rowLen; ri++) {
					row = section.rows[ri];
					tmp = [];

					if (readAttributes) {
						tmp.rowAttributes = null; // $.wijmo.wijgrid.getAttributes(row);
						tmp.cellsAttributes = [];
					}

					for (ci = 0, celLen = row.cells.length; ci < celLen; ci++) {
						tmp[ci] = row.cells[ci].innerHTML;

						if (readAttributes) {
							tmp.cellsAttributes[ci] = $.wijmo.wijgrid.getAttributes(row.cells[ci], prevent);
						}
					}

					result[ri] = tmp;
				}
			}

			return result;
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		dataMode: {
			dom: 1,
			statical: 2,
			remoteStatical: 4,
			dynamical: 8
		},

		dataStore: function (wijgrid) {
			var _dataSource = null,
				_self = this,
				_isLoaded = false,
				_clonedItems = null,
				_attributes = null, // store attributes here (an array of a { rowAttributes, cellsAttributes }
				_transformedData, // { data: array, totalRows: int }
				_parsed = false,
				_transformed = false;

			this.dataMode = function () {
				return _dataMode();
			};

			this.dataSource = function () {
				return _dataSource;
			};

			this.getFieldNames = function () {

				if (!_isLoaded) {
					throw "data is not loaded yet";
				}

				var result = [],
					key, firstItem;

				if (_dataSource.items && _dataSource.items.length) {
					firstItem = _dataSource.items[0];
				} else {
					if ((_dataMode() === $.wijmo.wijgrid.dataMode.dom) && _dataSource.header && _dataSource.header.length) { // DOMTable contains no data rows but header.
						firstItem = _dataSource.header[0];
					}
				}

				if (firstItem) {
					for (key in firstItem) {
						if (firstItem.hasOwnProperty(key)) {
							result.push((!isNaN(key)) ? parseInt(key, 10) : key);
						}
					}
				}

				return result;
			};

			// { data: array, totalRows: int }
			this.getDataSlice = function () {

				if (!_isLoaded) {
					throw "data is not loaded yet";
				}

				if (!_parsed) {
					_parsed = true; // todo try/ finally
					_parseData(_clonedItems);
				}

				if (!_transformed) {
					_transformed = true; // todo try/ finally

					if (_dataMode() !== $.wijmo.wijgrid.dataMode.dynamical) {
						_transformedData = _transform(_clonedItems, _dataSource.emptyData);
					} else {
						_transformedData = {
							data: _clonedItems, //  $.extend(true, [], _clonedItems),
							totalRows: _dataSource.data.totalRows,
							totals: _dataSource.data.totals || {},
							emptyData: _dataSource.emptyData
						};
					}
				}

				return _transformedData;
			};

			this.load = function (userData) {
				if (!_dataSource) {
					_dataSource = $.proxy(_createDataSource, this)(wijgrid);
				}

				if (_dataMode() === $.wijmo.wijgrid.dataMode.dynamical) { // always load data
					userData.data = _prepareRequest();
					if (_dataSource.proxy) { // remote 
						_dataSource.proxy.options.data = $.extend(_dataSource.proxy.options.data, userData.data);
					}

					_attributes = null; // indicates that we should read attributes
					_dataSource.load(userData, true);
				} else { // local
					if (!_isLoaded) { // first time ?
						_attributes = null; // indicates that we should read attributes
						_dataSource.load(userData);
					} else {
						_dataLoading(_dataSource, userData);
						_dataLoaded(_dataSource, userData);
					}
				}
			};

			this.isLoaded = function () {
				return _isLoaded;
			};

			this.updateValue = function (originalRowIndex, dataKey, newValue) {
				if (!_isLoaded) {
					throw "data is not loaded yet";
				}

				this.dataSource().items[originalRowIndex][dataKey] = newValue;
			};

			// private

			function _createDataSource(grid) {
				var dataSource = null,
					gridData = grid.options.data,
					oldError;

				if (gridData === null) { // DOMTable
					dataSource = new wijdatasource({
						data: grid.element,
						reader: new _dataReaderWrapper(new _domTableDataReader()),
						loading: $.proxy(_dataLoading, this),
						loaded: $.proxy(_dataLoaded, this)
					});
				} else
					if ($.isArray(gridData)) { // Array
						dataSource = new wijdatasource({
							data: gridData,
							reader: new _dataReaderWrapper(new wijarrayreader()),
							loading: $.proxy(_dataLoading, this),
							loaded: $.proxy(_dataLoaded, this)
						});
					} else { // wijdatasource
						dataSource = new wijdatasource(gridData);

						dataSource.reader = new _dataReaderWrapper(gridData.reader);

						dataSource.loading = $.proxy(function (ds, data) {
							if ($.isFunction(gridData.loading)) {
								gridData.loading(ds, data);
							}

							$.proxy(_dataLoading, this)(ds, data);
						}, this);

						dataSource.loaded = $.proxy(function (ds, data) {
							if ($.isFunction(gridData.loaded)) {
								gridData.loaded(ds, data);
							}

							$.proxy(_dataLoaded, this)(ds, data);
						}, this);

						if (dataSource.proxy && dataSource.proxy.options) {
							oldError = dataSource.proxy.options.error;
							dataSource.proxy.options.error = function () {
								_error.apply(this, arguments);

								if ($.isFunction(oldError)) {
									oldError.apply(this, arguments);
								}
							};
						}
					}

				return dataSource;
			}

			function _dataLoading(wijDataSource, userData) {
				if (_self.dataMode() === $.wijmo.wijgrid.dataMode.dynamical || wijgrid.options.alwaysParseData) {
					_parsed = false;  // always parse data
				}

				_transformed = false;
				_transformedData = null;
				_clonedItems = null;
				wijgrid._dataLoading(userData);
			}

			function _dataLoaded(wijDataSource, userData) {
				_isLoaded = true;

				// clone original items and get attributes (optional), extend them to a { value, originalRowIndex, attributes } triplet
				var i, len, item, dataKey, dataValue, tmp,
					mode = _dataMode(),
					readAttributes = (!_attributes && wijgrid.options.readAttributesFromData);

				if (!_attributes) { // first time?
					_attributes = [];
				}

				_clonedItems = [];

				for (i = 0, len = wijDataSource.items.length; i < len; i++) {
					item = wijDataSource.items[i];

					if (readAttributes) {
						if (mode === $.wijmo.wijgrid.dataMode.dom) { // Row and cells attributes are provided by the tableReader within rowAttributes and cellsAttributes properties of the data item itself.
							_attributes.push({
								rowAttributes: item.rowAttributes,
								cellsAttributes: item.cellsAttributes
							});

							delete item.rowAttributes;
							delete item.cellsAttributes;
						} else { // Otherwise cell attributes can be passed within data values as an array of size 2. First element points to a data value, second element points to an attributes hash.
							tmp = {};

							for (dataKey in item) {
								if (item.hasOwnProperty(dataKey) && $.isArray(dataValue = item[dataKey])) {
									tmp[dataKey] = dataValue[1]; // copy attributes to tmp
									item[dataKey] = dataValue[0]; // overwrite item[dataKey] with actual data value
								}
							}

							_attributes.push({
								rowAttributes: {},
								cellsAttributes: tmp
							});
						}
					}

					_clonedItems.push({
						values: item, // important!!: the same object is shared between _clonedItems and wijDataSource(aka _dataSource).items
						originalRowIndex: i,
						attributes: _attributes[i]
					});
				}

				wijgrid._dataLoaded(userData);
			}

			function _error() {
				wijgrid._ajaxError.apply(wijgrid, arguments);
			}

			function _dataMode() {
				if (!_dataSource.data || _dataSource.data.jquery) { // dataSource.data == domTable
					return $.wijmo.wijgrid.dataMode.dom;
				}

				if (_dataSource.dynamic === true) {
					return $.wijmo.wijgrid.dataMode.dynamical;
				}

				return $.wijmo.wijgrid.dataMode.statical;
			}

			function _parseData(data) {
				if (data && data.length) {

					var dataLeaves = [],
						dataLen, ri, len, dataRow, di, value, dataLeaf;

					$.wijmo.wijgrid.traverse(wijgrid.options.columns, function (column) {
						if ($.wijmo.wijgrid.validDataKey(column.dataKey)) {
							dataLeaves.push(column);
						}
					});

					dataLen = Math.min(dataLeaves.length, /*_self.getFieldsCount()*/_self.getFieldNames().length);
					for (ri = 0, len = data.length; ri < len; ri++) {
						dataRow = data[ri];

						for (di = 0; di < dataLen; di++) {
							value = null;
							dataLeaf = dataLeaves[di];

							if (dataLeaf && dataLeaf.dataParser) {
								value = wijgrid._parse(dataLeaf, dataRow.values[dataLeaf.dataKey]);
								dataRow.values[dataLeaf.dataKey] = value;
							}

						} // for di
					} // for ri
				}
			}

			// { data: array, totalRows: int }
			function _transform(data, emptyData) {
				if (data && data.length) {
					var filterRequest = wijgrid._prepareFilterRequest(true),
						pageRequest = wijgrid._preparePageRequest(true),
						sortRequest = wijgrid._prepareSortRequest(true),
						totalsRequest = wijgrid._prepareTotalsRequest(true),
						result = new $.wijmo.wijgrid.dataHelper().getDataSlice(wijgrid, data /*$.extend(true, [], data)*/, filterRequest, pageRequest, sortRequest, totalsRequest);

					return result;
				}

				return {
					data: [],
					totalRows: 0,
					totals: {},
					emptyData: emptyData
				};
			}

			function _prepareRequest() {
				var result = {
					filtering: wijgrid._prepareFilterRequest(false),
					paging: wijgrid._preparePageRequest(false),
					sorting: wijgrid._prepareSortRequest(false),
					totals: wijgrid._prepareTotalsRequest(false)
				};

				return result;
			}

			// * data readers *
			function _dataReaderWrapper(dataReader) {

				this.read = function (dataSource) {
					dataSource.items = null;

					if (dataReader && $.isFunction(dataReader.read)) {
						dataReader.read(dataSource);
					}

					if (!$.isArray(dataSource.items)) {
						dataSource.items = [];

						if ($.isArray(dataSource.data)) {
							dataSource.items = dataSource.data;
						} else {
							if (dataSource.data && $.isArray(dataSource.data.rows)) {
								dataSource.items = dataSource.data.rows; // remoteDynamical
							}
						}
					}

					if (_dataMode() === $.wijmo.wijgrid.dataMode.dynamical) {
						if (!dataSource.data || isNaN(dataSource.data.totalRows)) {
							throw "totalRows value is missing";
						}
					}

					if (!dataSource.items || !$.isArray(dataSource.items)) {
						dataSource.items = [];
					}
				};
			}

			function _domTableDataReader() {
				this.read = function (wijDataSource) {
					wijDataSource.items = [];

					if (wijDataSource && wijDataSource.data && wijDataSource.data.length) {
						if ($.wijmo.wijgrid.getTableSectionLength(wijDataSource.data, 2) === 1 &&
							$($.wijmo.wijgrid.getTableSectionRow(wijDataSource.data, 2, 0)).hasClass("wijmo-wijgrid-emptydatarow")) { // special case - empty data row
							wijDataSource.emptyData = $.wijmo.wijgrid.readTableSection(wijDataSource.data, 2);
						} else { // read data rows
							wijDataSource.items = $.wijmo.wijgrid.readTableSection(wijDataSource.data, 2, wijgrid.options.readAttributesFromData);
						}

						wijDataSource.header = $.wijmo.wijgrid.readTableSection(wijDataSource.data, 1);
						wijDataSource.data = null;
					} else {
						throw "invalid data source";
					}
				};
			}
		},

		dataHelper: function () {

			this.getDataSlice = function (gridView, dataCache, filterRequest, pageRequest, sortRequest, totalsRequest) {
				// apply filtering
				dataCache = _applyFiltering(dataCache, filterRequest, gridView);

				// apply sorting
				$.proxy(_applySort, this)(dataCache, sortRequest);

				var totalRows = dataCache.length, // number of rows in the data source (before paging will be applied)
					start, end, pagedData, i, j, len, pageCount,
					totals = {};

				// calculate totals
				totals = _getTotals(dataCache, totalsRequest, gridView);

				// apply paging
				if (pageRequest) {
					pageCount = Math.ceil(totalRows / pageRequest.pageSize) || 1;

					if (pageRequest.pageIndex >= pageCount) {
						pageRequest.pageIndex = pageCount - 1; // index of the last page
					}

					start = Math.min(dataCache.length - 1, pageRequest.pageIndex * pageRequest.pageSize);

					if (start < 0) {
						start = 0;
					}

					end = Math.min(dataCache.length, start + pageRequest.pageSize);

					pagedData = [];
					for (i = start, len = 0, j = 0; i < end; i++, j++) {
						pagedData[j] = dataCache[i];
					}

					dataCache = pagedData;
				}

				return {
					data: dataCache,
					totalRows: totalRows,
					totals: totals
				};
			};

			// totalsRequest: [ {column, aggregate} ]
			function _getTotals(data, totalsRequest, gridView) {
				var i, len, j, len2, dataItemValues,
					tallies = [],
					result = {};

				for (i = 0, len = totalsRequest.length; i < len; i++) {
					tallies.push(new $.wijmo.wijgrid.tally());
				}

				for (i = 0, len = data.length; i < len; i++) {
					dataItemValues = data[i].values;

					for (j = 0, len2 = tallies.length; j < len2; j++) {
						tallies[j].add(dataItemValues[totalsRequest[j].column.dataKey]);
					}
				}

				for (i = 0, len = tallies.length; i < len; i++) {
					result[totalsRequest[i].column.dataKey] = tallies[i].getValueString(totalsRequest[i].column);
				}

				return result;
			}

			// filterRequest: [ {column, filterOperator} ]
			function _applyFiltering(data, filterRequest, gridView) {
				if (!data || !data.length || !filterRequest || !filterRequest.length) {
					return data;
				}

				// preparation
				$.each(filterRequest, function (i, item) {
					if (!$.isArray(item.filterOperator)) {
						item.filterOperator = [item.filterOperator];
					}

					if (!$.isArray(item.filterValue)) {
						item.filterValue = [item.filterValue];
					}

					$.each(item.filterOperator, function (i, fop) {
						if (typeof (fop) === "string") {
							item.filterOperator[i] = fop = {
								name: fop,
								condition: "or"
							};
						}

						item.filterOperator[i].name = gridView.filterOperatorsCache.getByName(fop.name);
					});

					// parse filter values
					$.each(item.filterValue, function (i, value) {
						if (!$.isArray(value)) {
							item.filterValue[i] = gridView._parse(item.column, value);
						} else {
							$.each(value, function (j, subValue) {
								value[j] = gridView._parse(item.column, subValue);
							});
						}
					});
				});

				// data filtering
				var i, j, k,
				    dataLen, dataRow, dataValue,
					dataRes = [],
					flag, subFlag,
					filterReqLen = filterRequest.length,
					currentReq, filterOp, filterVal;

				for (i = 0, dataLen = data.length; i < dataLen; i++) {
					dataRow = data[i];

					flag = true;

					for (j = 0; j < filterReqLen; j++) {
						currentReq = filterRequest[j];
						dataValue = dataRow.values[currentReq.column.dataKey];

						subFlag = false;

						for (k = 0; k < currentReq.filterOperator.length; k++) {
							filterOp = currentReq.filterOperator[k];
							filterVal = currentReq.filterValue[k];

							if ((k > 0) && (filterOp.condition === "and")) {
								subFlag &= filterOp.name.operator(dataValue, filterVal);
							} else {
								subFlag |= filterOp.name.operator(dataValue, filterVal);
							}
						}

						flag &= subFlag;
					}

					if (flag) {
						dataRes.push(dataRow);
					}
				}

				return dataRes;
			}

			// sortRequest: array of { dataKey, sortDirection } 
			function _applySort(data, sortRequest) {
				if (sortRequest.length) {

					var builder = [],
						i, len, arg, si, dataKey, idx;

					builder.push("var context = this;"); // declare "context" variable explicitly to avoid js minimization issue.
					builder.push("this.sort = function(a, b)\n{\n");

					for (i = 0, len = sortRequest.length; i < len; i++) {
						arg = "arg" + i;
						si = sortRequest[i];

						dataKey = (typeof (si.dataKey) === "string")
							? "\"" + si.dataKey + "\""
							: si.dataKey;

						if (si.sortDirection === "ascending" || si.sortDirection === "descending") {
							if (si.sortDirection === "ascending") {
								builder.push("var ", arg, " = context._sortAsc", "(a.values[", dataKey, "], b.values[", dataKey, "]);\n");
							}
							else {
								builder.push("var ", arg, " = context._sortDesc", "(a.values[", dataKey, "], b.values[", dataKey, "]);\n");
							}
						} else { // sortDirection === none: restore original order
							builder.push("var ", arg, " = context._sortDigitAsc", "(a.originalRowIndex, b.originalRowIndex);\n");
						}

						builder.push("if (", arg, " === 0)\n");
						builder.push("{\n");
					}

					idx = sortRequest.length - 1;
					if (idx >= 0) { // sort identical values using originalRowIndex
						arg = "arg" + idx;
						si = sortRequest[idx];

						dataKey = (typeof (si.dataKey) === "string")
							? "\"" + si.dataKey + "\""
							: si.dataKey;

						if ((si.sortDirection === "ascending") || (si.sortDirection === "descending")) {
							if (si.sortDirection === "ascending") {
								builder.push("var ", arg, " = context._sortDigitAsc", "(a.originalRowIndex, b.originalRowIndex);\n");
							}
							else {
								builder.push("var ", arg, " = context._sortDigitDesc", "(a.originalRowIndex, b.originalRowIndex);\n");
							}
						}
					}

					for (i = sortRequest.length - 1; i >= 0; i--) {
						builder.push("}\n");
						arg = "arg" + i;
						builder.push("return ", arg, ";\n");
					}

					builder.push("}");

					eval(builder.join(""));

					data.sort(this.sort);
				}
			}

			this._sortAsc = function (a, b) {
				if (a instanceof Date) {
					a = a.getTime();
				}

				if (b instanceof Date) {
					b = b.getTime();
				}

				if (a === b) {
					return 0;
				}

				if (a === null) {
					return -1;
				}

				if (b === null) {
					return 1;
				}

				return (a < b) ? -1 : 1;
			};

			this._sortDesc = function (a, b) {
				if (a instanceof Date) {
					a = a.getTime();
				}

				if (b instanceof Date) {
					b = b.getTime();
				}

				if (a === b) {
					return 0;
				}

				if (a === null) {
					return 1;
				}

				if (b === null) {
					return -1;
				}

				return (a < b) ? 1 : -1;
			};

			this._sortDigitAsc = function (a, b) {
				return a - b;
			};

			this._sortDigitDesc = function (a, b) {
				return b - a;
			};
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		groupRange: function (expanded, range, sum, position, hasHeaderOrFooter) {
			this.value = -1;

			this.isExpanded = false;
			this.cr = new $.wijmo.wijgrid.cellRange(-1, -1);
			this.sum = -1;
			this.position = "none";
			this.hasHeaderOrFooter = true;

			if (expanded !== undefined) {
				this.isExpanded = expanded;
			}

			if (range !== undefined) {
				this.cr = range;
			}

			if (sum !== undefined) {
				this.sum = sum;
			}

			if (position !== undefined) {
				this.position = position;
			}

			if (hasHeaderOrFooter !== undefined) {
				this.hasHeaderOrFooter = hasHeaderOrFooter;
			}

			this.isSubRange = function (groupRange) {
				return ((this.cr.r1 >= groupRange.cr.r1) && (this.cr.r2 <= groupRange.cr.r2));
			};

			this.toString = function () {
				return this.cr.r1 + "-" + this.cr.r2;
			};

			this._getHeaderImageClass = function (expanded) {
				var groupInfo = this.owner;

				if (groupInfo) {
					return expanded
						? groupInfo.expandedImageClass || $.wijmo.c1field.prototype.options.groupInfo.expandedImageClass /*"ui-icon-triangle-1-se"*/
						: groupInfo.collapsedImageClass || $.wijmo.c1field.prototype.options.groupInfo.collapsedImageClass /*"ui-icon-triangle-1-e"*/;
				}

				return null;
			};

			this.collapse = function () {
				var groupInfo, column, grid, groupHelper, leaves, groupedColumnsCnt;

				if ((groupInfo = this.owner) && (column = groupInfo.owner) && (grid = column.owner)) {
					groupHelper = new $.wijmo.wijgrid.groupHelper();
					leaves = grid._field("leaves");

					if (groupHelper.isParentExpanded(leaves, this.cr, groupInfo.level)) {
						if ((groupInfo.position !== "footer") && (groupInfo.outlineMode !== "none")) { // do not collapse groups with .position == "footer"
							groupedColumnsCnt = groupHelper.getGroupedColumnsCount(leaves);
							_collapse(groupHelper, grid._rows(), leaves, this, groupedColumnsCnt);
						}
					}
				}
			};

			this.expand = function (expandChildren) {
				var groupInfo, column, grid, groupHelper, leaves, groupedColumnsCnt;

				if ((groupInfo = this.owner) && (column = groupInfo.owner) && (grid = column.owner)) {
					groupHelper = new $.wijmo.wijgrid.groupHelper();
					leaves = grid._field("leaves");

					if (groupHelper.isParentExpanded(leaves, this.cr, groupInfo.level)) {
						groupedColumnsCnt = groupHelper.getGroupedColumnsCount(leaves);
						/*var tbody = grid.$table.find("> tbody")[0];*/

						_expand(groupHelper, grid._rows(), leaves, this, groupedColumnsCnt, expandChildren, true);
					}
				}
			};

			// private members

			function _collapse(groupHelper, rowAccessor, leaves, groupRange, groupedColumnsCnt) {
				var groupInfo = groupRange.owner,
					dataStart = groupRange.cr.r1,
					dataEnd = groupRange.cr.r2,
					i, len,
					childRanges, childRange, j;

				switch (groupInfo.position) {
					case "header":
					case "headerAndFooter":
						_toggleRowVisibility(rowAccessor.item(groupRange.cr.r1), undefined, false);

						dataStart++;
						break;
				}

				// hide child rows
				for (i = dataStart; i <= dataEnd; i++) {
					_toggleRowVisibility(rowAccessor.item(i), false);
				}

				// update isExpanded property
				groupRange.isExpanded = false;
				_updateHeaderIcon(rowAccessor, groupRange);

				for (i = groupInfo.level + 1; i <= groupedColumnsCnt; i++) {
					childRanges = groupHelper.getChildGroupRanges(leaves, groupRange.cr, /*groupRange.owner.level*/i - 1);
					for (j = 0, len = childRanges.length; j < len; j++) {
						childRange = childRanges[j];
						childRange.isExpanded = false;

						switch (childRange.owner.position) {
							case "header":
							case "headerAndFooter":
								_toggleRowVisibility(rowAccessor.item(childRange.cr.r1), undefined, false);
								break;
						}

						_updateHeaderIcon(rowAccessor, childRange);
					}
				}
			}

			function _expand(groupHelper, rowAccessor, leaves, groupRange, groupedColumnsCnt, expandChildren, isRoot) {
				var groupInfo = groupRange.owner,
					dataStart = groupRange.cr.r1,
					dataEnd = groupRange.cr.r2,
					i, len,
					childRanges, childRange, childIsRoot;

				switch (groupInfo.position) {
					case "header":
						_toggleRowVisibility(rowAccessor.item(dataStart), true, isRoot || expandChildren);
						dataStart++;
						break;
					case "footer":
						_toggleRowVisibility(rowAccessor.item(dataEnd), true);
						dataEnd--;
						break;
					case "headerAndFooter":
						_toggleRowVisibility(rowAccessor.item(dataStart), true, isRoot || expandChildren);

						if (isRoot) {
							_toggleRowVisibility(rowAccessor.item(dataEnd), true);
						}
						dataStart++;
						dataEnd--;
						break;
				}

				if (isRoot) {
					groupRange.isExpanded = true;
					_updateHeaderIcon(rowAccessor, groupRange);
				} else {
					return;
				}

				if (groupRange.owner.level === groupedColumnsCnt) { // show data rows
					for (i = dataStart; i <= dataEnd; i++) {
						_toggleRowVisibility(rowAccessor.item(i), true);
					}
				} else {
					childRanges = groupHelper.getChildGroupRanges(leaves, groupRange.cr, groupRange.owner.level);

					if (childRanges.length && (dataStart !== childRanges[0].cr.r1)) { // 
						// a space between parent groupHeader and first child range - show single rows (groupSingleRow = false)
						for (i = dataStart; i < childRanges[0].cr.r1; i++) {
							_toggleRowVisibility(rowAccessor.item(i), true);
						}
					}

					if (expandChildren) { // throw action deeper
						for (i = 0, len = childRanges.length; i < len; i++) {
							childRange = childRanges[i];
							_expand(groupHelper, rowAccessor, leaves, childRange, groupedColumnsCnt, expandChildren, true);
						}
					} else { // show only headers of the child groups or fully expand child groups with .position == "footer"\ .outlineMode == "none"
						for (i = 0, len = childRanges.length; i < len; i++) {
							childRange = childRanges[i];

							childIsRoot = (childRange.owner.position === "footer" || childRange.owner.outlineMode === "none")
								? true
								: false;

							_expand(groupHelper, rowAccessor, leaves, childRange, groupedColumnsCnt, false, childIsRoot);
						}
					}
				}
			}

			function _toggleRowVisibility(rowObj, visible, expanded) {
				if (rowObj) {
					if (rowObj[0]) {
						if (visible !== undefined) {
							rowObj[0].style.display = visible ? "" : "none";
							rowObj[0]["aria-hidden"] = visible ? "false" : "true";
						}

						if (expanded !== undefined) {
							rowObj[0]["aria-expanded"] = expanded ? "true" : false;
						}
					}

					if (rowObj[1]) {
						if (visible !== undefined) {
							rowObj[1].style.display = visible ? "" : "none";
							rowObj[1]["aria-hidden"] = visible ? "false" : "true";
						}

						if (expanded !== undefined) {
							rowObj[1]["aria-expanded"] = expanded ? "true" : false;
						}
					}
				}
			}

			function _updateHeaderIcon(rowAccessor, groupRange) {
				if (groupRange.owner.position !== "footer") {
					var imageDiv = null,
						rowObj = rowAccessor.item(groupRange.cr.r1);

					if (rowObj) {
						if (rowObj[0]) {
							imageDiv = $(rowObj[0]).find("div.wijmo-wijgrid-grouptogglebtn:first-child");
						}
					}

					if (imageDiv && imageDiv.length) {
						imageDiv.toggleClass(groupRange._getHeaderImageClass(!groupRange.isExpanded), false);
						imageDiv.toggleClass(groupRange._getHeaderImageClass(groupRange.isExpanded), true);
					}
				}
			}
		},

		grouper: function () {

			this.group = function (grid, data, leaves) {
				this._grid = grid;
				this._data = data;
				this._leaves = leaves;
				this._groupRowIdx = 0;
				this._groupHelper = new $.wijmo.wijgrid.groupHelper();

				var level = 1,
					i, len, leaf,
					groupCollection = [],
					needReset = false,
					groupLength = 0;

				//get the grouped columns
				for (i = 0, len = leaves.length; i < len; i++) {
					leaf = leaves[i];

					if (leaf.groupInfo) {
						delete leaf.groupInfo.level;
						delete leaf.groupInfo.expandInfo;
					}

					if (/*(leaf.dynamic !== true) && */leaf.groupInfo && (leaf.groupInfo.position && (leaf.groupInfo.position !== "none")) &&
						(leaf.dataIndex >= 0)) {
						if (leaf.groupedIndex === undefined) {
							needReset = true;
						}
					} else {
						if (leaf.groupedIndex !== undefined) {
							delete leaf.groupedIndex;
						}
					}
				}
				if (needReset) {
					for (i = 0, len = leaves.length; i < len; i++) {
						leaf = leaves[i];

						if (/*(leaf.dynamic !== true) && */leaf.groupInfo && (leaf.groupInfo.position && (leaf.groupInfo.position !== "none")) &&
							(leaf.dataIndex >= 0)) {
							leaf.groupedIndex = groupLength++;
							groupCollection.push(leaf);
						}
					}
				} else {
					groupCollection = $.map(leaves, function (element, index) {
						return element.groupedIndex !== undefined ? element : null;
					});
					groupCollection.sort(function (a, b) {
						return a.groupedIndex - b.groupedIndex;
					});
					$.each(groupCollection, function (index, item) {
						item.groupedIndex = index;
					});
				}

				grid._field("groupedColumns", groupCollection);

				for (i = 0, len = groupCollection.length; i < len; i++) {
					leaf = groupCollection[i];
					this._groupRowIdx = 0;

					if (/*(leaf.dynamic !== true) && */leaf.groupInfo && (leaf.groupInfo.position && (leaf.groupInfo.position !== "none")) &&
						(leaf.dataIndex >= 0)) {
						leaf.groupInfo.level = level;
						leaf.groupInfo.expandInfo = [];
						this._processRowGroup(leaf, level++);
					}
				}
				/*
				for (i = 0, len = leaves.length; i < len; i++) {
				leaf = leaves[i];
				this._groupRowIdx = 0;

				if ((leaf.dynamic !== true) && leaf.groupInfo && (leaf.groupInfo.position && (leaf.groupInfo.position !== "none")) &&
				(leaf.dataIndex >= 0) && !leaf.groupInfo.expandInfo) {
				leaf.groupInfo.level = level;
				leaf.groupInfo.expandInfo = [];
				this._processRowGroup(leaf, level++);
				}
				}
				*/
				delete this._grid;
				delete this._data;
				delete this._leaves;
			};

			this._processRowGroup = function (leaf, level) {
				var row, cellRange, isExpanded, startCollapsed, indentRow,
					groupRange, isParentCollapsed, header, footer, i,
					firstVisibleLeafIdx = 0,
					hasHeaderOrFooter = true;


				$.each(this._leaves, function (i, leaf) {
					if (leaf.parentVis) {
						firstVisibleLeafIdx = i;
						return false;
					}
				});

				for (row = 0; row < this._data.length; row++) {
					// if (this._data[row].rowType !== "data") {
					if (!(this._data[row].rowType & $.wijmo.wijgrid.rowType.data)) {
						continue;
					}

					cellRange = this._getGroupCellRange(row, leaf, level);
					isExpanded = true;
					startCollapsed = (leaf.groupInfo.outlineMode === "startCollapsed");

					if (startCollapsed || this._groupHelper.isParentCollapsed(this._leaves, cellRange, level)) {
						if ((leaf.groupInfo.groupSingleRow === false) && (cellRange.r1 === cellRange.r2)) {
							continue;
						}
						isExpanded = false;
					}

					// indent
					if (level && this._grid.options.groupIndent) {
						for (indentRow = cellRange.r1; indentRow <= cellRange.r2; indentRow++) {
							this._addIndent(this._data[indentRow][firstVisibleLeafIdx], level);
						}
					}

					hasHeaderOrFooter = !(leaf.groupInfo.groupSingleRow === false && (cellRange.r1 === cellRange.r2));

					// insert group header/ group footer
					switch (leaf.groupInfo.position) {
						case "header":
							groupRange = this._addGroupRange(leaf.groupInfo, cellRange, isExpanded, hasHeaderOrFooter);

							for (i = cellRange.r1; i <= cellRange.r2; i++) {
								this._data[i].__attr["aria-level"] = level + 1;
								if (!isExpanded) {
									this._data[i].__style.display = "none";
									this._data[i].__attr["aria-hidden"] = true;

								}
							}

							if (!hasHeaderOrFooter) {
								break;
							}

							this._updateByGroupRange(groupRange, level);

							isParentCollapsed = this._groupHelper.isParentCollapsed(this._leaves, groupRange.cr, level);
							header = this._buildGroupRow(groupRange, cellRange, true, isParentCollapsed);

							this._data.splice(cellRange.r1, 0, header); // insert group header

							header.__attr["arial-level"] = level;
							header.__attr["aria-expanded"] = isExpanded;
							if (isParentCollapsed) {
								header.__style.display = "none";
								header.__attr["aria-hidden"] = true;
							}

							row = cellRange.r2 + 1;
							break;

						case "footer":
							groupRange = this._addGroupRange(leaf.groupInfo, cellRange, true, hasHeaderOrFooter);

							if (!hasHeaderOrFooter) {
								break;
							}

							this._updateByGroupRange(groupRange, level);

							footer = this._buildGroupRow(groupRange, cellRange, false, false);
							footer.__attr["aria-level"] = level;

							this._data.splice(cellRange.r2 + 1, 0, footer);
							row = cellRange.r2 + 1;

							isParentCollapsed = this._groupHelper.isParentCollapsed(this._leaves, groupRange.cr, level);
							if (isParentCollapsed) {
								footer.__style.display = "none";
								footer.__attr["aria-hidden"] = true;
							}

							break;

						case "headerAndFooter":
							groupRange = this._addGroupRange(leaf.groupInfo, cellRange, isExpanded, hasHeaderOrFooter);

							for (i = cellRange.r1; i <= cellRange.r2; i++) {
								this._data[i].__attr["aria-level"] = level + 1;
								if (!isExpanded) {
									this._data[i].__style.display = "none";
									this._data[i].__attr["aria-hidden"] = true;
								}
							}

							if (!hasHeaderOrFooter) {
								break;
							}

							this._updateByGroupRange(groupRange, level);

							isParentCollapsed = this._groupHelper.isParentCollapsed(this._leaves, groupRange.cr, level);
							header = this._buildGroupRow(groupRange, cellRange, true, isParentCollapsed);
							footer = this._buildGroupRow(groupRange, cellRange, false, false);

							this._data.splice(cellRange.r2 + 1, 0, footer);
							footer.__attr["aria-level"] = level;
							if (isParentCollapsed || !isExpanded) {
								footer.__style.display = "none";
								footer.__attr["aria-hidden"] = true;
							}

							this._data.splice(cellRange.r1, 0, header);
							header.__attr["aria-level"] = level;
							header.__attr["aria-expanded"] = isExpanded;
							if (isParentCollapsed) {
								header.__style.display = "none";
								header.__attr["aria-hidden"] = true;
							}

							row = cellRange.r2 + 2;
							break;

						default:
							throw $.wijmo.wijgrid.stringFormat("Unknown Position value: \"{0}\"", leaf.groupInfo.position);
					}

					this._groupRowIdx++;
				}
			};

			this._buildGroupRow = function (groupRange, cellRange, isHeader, isParentCollapsed) {
				//when some column is hidden, the group row is not correct.
				var groupInfo = groupRange.owner,
					leaf = groupInfo.owner,
					gridView = leaf.owner,
					row = [],
					groupByText = "",
				//headerOffset = 0,
					aggregate = "",
					tmp, cell, caption, args, span, col, bFirst, agg;

				row.__style = {};
				row.__attr = {};

				row.__attr.id = ((isHeader) ? "GH" : "GF") + this._groupRowIdx + "-" + groupInfo.level;

				row.rowType = (isHeader)
					? $.wijmo.wijgrid.rowType.groupHeader //"groupHeader"
					: $.wijmo.wijgrid.rowType.groupFooter; // "groupFooter";

				//if (cellRange.c1 > -1 && ((tmp = this._data[cellRange.r1][cellRange.c1].value) !== null)) {
				if ((leaf.dataIndex >= 0) && ((tmp = this._data[cellRange.r1][leaf.dataIndex].value) !== null)) {
					groupByText = gridView._toStr(leaf, tmp);
				}

				if (this._grid.options.showRowHeader) {
					row.push({ html: "&nbsp;" });
				}

				// create the summary cell
				cell = { html: "", __attr: {}, __style: {} };
				if (isHeader && groupInfo.outlineMode !== "none") {
					if (groupRange.isExpanded) {
						cell.html = "<div class=\"ui-icon " + groupRange._getHeaderImageClass(true) +
						" wijmo-wijgrid-grouptogglebtn\">&nbsp;</div>";
					}
					else {
						cell.html = "<div class=\"ui-icon " + groupRange._getHeaderImageClass(false) +
						" wijmo-wijgrid-grouptogglebtn\">&nbsp;</div>";
					}
				}

				row.push(cell);

				// add group header text
				if (leaf.aggregate && (leaf.aggregate !== "none")) {
					//aggregate = this._getAggregate(cellRange, leaf, groupInfo.owner, isHeader, groupByText);
					aggregate = this._getAggregate(cellRange, leaf, leaf, isHeader, groupByText);

					//if (leaf.parentVis) {
					//	headerOffset = 1;
					//}
				}

				caption = (isHeader)
					? groupInfo.headerText
					: groupInfo.footerText;

				// format caption

				// The text may include up to three placeholders:
				// "{0}" is replaced with the value being grouped on and
				// "{1}" is replaced with the group's column header
				// "{2}" is replaced with the aggregate
				if (caption === "custom") {
					args = {
						data: this._data, // data object.
						column: leaf, // column that is being grouped.
						groupByColumn: groupInfo.owner, // column initiated grouping.
						groupText: groupByText, // text that is being grouped.
						text: "", // text that will be displayed in the groupHeader or Footer.
						groupingStart: cellRange.r1, // first index for the data being grouped.
						groupingEnd: cellRange.r2, // last index for the data being grouped.
						isGroupHeader: isHeader,
						aggregate: aggregate
					};

					if (this._grid._trigger("groupText", null, args)) {
						caption = args.text;
					}
				} else {
					if ((caption === undefined) || (caption === null)) { // use default formatting
						if (isHeader) {
							caption = "{1}: {0}";
						}

						if (aggregate || (aggregate === 0)) {
							caption = caption
								? caption + " {2}"
								: "{2}";
						}
					}

					caption = $.wijmo.wijgrid.stringFormat(caption, groupByText,
						leaf && leaf.headerText ? leaf.headerText : "",
						aggregate.toString());
				}

				if (!caption) {
					caption = "&nbsp;";
				}

				cell.html += "<span>" + caption + "</span>";
				this._addIndent(cell, groupInfo.level - 1);

				// summary cells span until the end of the row or the first aggregate
				//span = headerOffset;
				span = 1;
				col = (this._grid.options.showRowHeader)
					? 1
					: 0;

				//for (; col < cellRange.c1; col++) { // c1 is an index of the leaf inside the this._leaves
				//	if (this._leaves[col].parentVis) {
				//		span++;
				//	}
				//}

				//col = cellRange.c1 + headerOffset;
				bFirst = true;
				for (; col < this._leaves.length; col++) {
					tmp = this._leaves[col];
					if (tmp.parentVis) {
						if (bFirst) {
							bFirst = false;
							continue;
						}
						if ((tmp.dynamic !== true) && tmp.aggregate && (tmp.aggregate !== "none")) {
							break;
						}

						span++;
					}
				}

				// add aggregates (or blanks) until the end of the row
				for (; col < this._leaves.length; col++) {
					tmp = this._leaves[col];
					if (tmp.parentVis) {
						agg = this._getAggregate(cellRange, tmp, groupInfo.owner, isHeader, groupByText);
						if (!agg && (agg !== 0)) {
							agg = "&nbsp;";
						}

						row.push({
							html: agg.toString(),
							__attr: { groupInfo: { leafIndex: tmp.leavesIdx, purpose: $.wijmo.wijgrid.groupRowCellPurpose.aggregateCell}} // will be passed into the cellStyleFormatter
						});
					}
				}

				cell.__attr.colSpan = span;
				cell.__attr.groupInfo = { leafIndex: leaf.leavesIdx, purpose: $.wijmo.wijgrid.groupRowCellPurpose.groupCell }; // will be passed into the cellStyleFormatter

				return row;
			};

			this._getAggregate = function (cellRange, column, groupByColumn, isGroupHeader, groupByText) {
				var aggregate = "",
					args, tally, row;

				if (!column.aggregate || (column.aggregate === "none")) {
					return aggregate;
				}

				if (column.aggregate === "custom") {
					args = {
						data: this._data, // data object
						column: column, // column that is being grouped.
						groupByColumn: groupByColumn, // column initiated grouping.
						groupText: groupByText, // text that is being grouped.
						text: "", // text that will be displayed in the groupHeader or groupFooter.
						groupingStart: cellRange.r1, // first index for the data being grouped.
						groupingEnd: cellRange.r2, // last index for the data being grouped.
						isGroupHeader: isGroupHeader
					};

					if (this._grid._trigger("groupAggregate", null, args)) {
						aggregate = args.text;
					}
				} else {
					tally = new $.wijmo.wijgrid.tally();

					for (row = cellRange.r1; row <= cellRange.r2; row++) {
						tally.add(this._data[row][column.dataIndex].value);
					}

					aggregate = tally.getValueString(column);
				}

				return aggregate;
			};

			this._getGroupCellRange = function (row, leaf, level) {
				//var range = new $.wijmo.wijgrid.cellRange(row, leaf.dataIndex);
				var idx = leaf.leavesIdx, // $.inArray(leaf, this._leaves);
					range = new $.wijmo.wijgrid.cellRange(row, idx),
					parentRange = this._groupHelper.getParentGroupRange(this._leaves, range, level),
					value, nextValue, count;

				//if (this._data[row].rowType === "data") {
				if (this._data[row].rowType & $.wijmo.wijgrid.rowType.data) {
					value = this._data[row][leaf.dataIndex].value;

					if (value instanceof Date) {
						value = value.getTime();
					}

					for (range.r2 = row, count = this._data.length - 1; range.r2 < count; range.r2++) {
						//if ((this._data[range.r2 + 1].rowType !== "data") || (parentRange && (range.r2 + 1 > parentRange.r2))) {
						if (!(this._data[range.r2 + 1].rowType & $.wijmo.wijgrid.rowType.data) || (parentRange && (range.r2 + 1 > parentRange.r2))) {
							break;
						}

						nextValue = this._data[range.r2 + 1][leaf.dataIndex].value;

						if (nextValue instanceof Date) {
							nextValue = nextValue.getTime();
						}

						if (value !== nextValue) {
							break;
						}
					}
				}

				return range;
			};

			this._addGroupRange = function (groupInfo, cellRange, isExpanded, hasHeaderOrFooter) {
				var result = null,
					idx = this._groupHelper.getChildGroupIndex(cellRange, groupInfo.expandInfo),
					range, expandState, r1, r2;

				if (idx >= 0 && idx < groupInfo.expandInfo.length) {
					result = groupInfo.expandInfo[idx];
				} else {
					range = new $.wijmo.wijgrid.cellRange(cellRange.r1, cellRange.r1, cellRange.r2, cellRange.r2); // clone
					expandState = (groupInfo.position === "footer" || !hasHeaderOrFooter)
						? true
						: isExpanded && (groupInfo.outlineMode !== "startCollapsed");

					result = new $.wijmo.wijgrid.groupRange(expandState, range, -1, groupInfo.position, hasHeaderOrFooter);

					result.owner = groupInfo;

					groupInfo.expandInfo.push(result);
				}

				if (result && hasHeaderOrFooter) {
					r1 = cellRange.r1;
					r2 = cellRange.r2;

					if (groupInfo.position === "headerAndFooter") {
						r2 += 2;
					}

					if (groupInfo.position !== "headerAndFooter") {
						r2++;
					}

					result.cr.r2 = r2;
				}

				return result;
			};

			this._updateByGroupRange = function (groupRange, level) {
				var i, len, groupInfo, len2, j, cur, delta;

				for (i = 0, len = this._leaves.length; i < len; i++) {
					groupInfo = this._leaves[i].groupInfo;

					if (groupInfo && (groupInfo.level < level)) {

						len2 = (groupInfo.expandInfo)
							? groupInfo.expandInfo.length
							: 0;

						for (j = 0; j < len2; j++) {
							cur = groupInfo.expandInfo[j];
							delta = (groupRange.position === "headerAndFooter") ? 2 : 1;

							if (cur.cr.r1 >= groupRange.cr.r1 && !((cur.cr.r1 === groupRange.cr.r1) && (cur.position === "footer"))) {
								cur.cr.r1 += delta;
							}

							if (cur.cr.r2 >= groupRange.cr.r1) {
								cur.cr.r2 += delta;
							}
						}
					}
				}
			};

			this._addIndent = function (cellObj, level) {
				var indent;

				if (level > 0 && (indent = this._grid.options.groupIndent)) {
					cellObj.__style.paddingLeft = (indent * level) + "px";
				}
			};
		}
	});
})(jQuery);
(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		groupHelper: function () {

			this.getGroupInfo = function (domRow) {

				if (domRow) {
					if (!$.wijmo.wijgrid._getGroupInfoRegExp) {
						$.wijmo.wijgrid._getGroupInfoRegExp = new RegExp(".*G([HF]){1}(\\d+)-(\\d+)$");
					}

					var info = $.wijmo.wijgrid._getGroupInfoRegExp.exec(domRow.id),
						level, index, isHeader;

					if (info) {
						level = parseInt(info[3], 10);
						index = parseInt(info[2], 10);
						isHeader = (info[1] === "H");

						return {
							level: level,
							index: index,
							isHeader: isHeader,
							toString: function () {
								return (this.isHeader ? "GH" : "GF") + this.index + "-" + this.level;
							}
						};
					}
				}

				return null;
			};

			this.getColumnByGroupLevel = function (leaves, level) {
				var i, len, leaf;

				for (i = 0, len = leaves.length; i < len; i++) {
					leaf = leaves[i];
					if (leaf.groupInfo && (leaf.groupInfo.level === level)) {
						return leaf;
					}
				}

				return null;
			};

			this.getGroupedColumnsCount = function (leaves) {
				var result = 0,
					i, len, groupInfo;

				for (i = 0, len = leaves.length; i < len; i++) {
					groupInfo = leaves[i].groupInfo;
					if (groupInfo && (groupInfo.position === "header" || groupInfo.position === "headerAndFooter" || groupInfo.position === "footer")) {
						result++;
					}
				}

				return result;
			};

			// cellRange cellRange
			// groupRange[] childExpandInfo
			this.getChildGroupIndex = function (cellRange, childExpandInfo) {
				var left = 0,
					right = childExpandInfo.length - 1,
					median, cmp;

				while (left <= right) {
					median = ((right - left) >> 1) + left;
					cmp = childExpandInfo[median].cr.r1 - cellRange.r1;

					if (cmp === 0) {
						return median;
					}

					if (cmp < 0) {
						left = median + 1;
					} else {
						right = median - 1;
					}
				}

				return left;
				//return ~left;
			};

			// cellRange childRange
			// groupRange[] parentExpandInfo
			this.getParentGroupIndex = function (cellRange, parentExpandInfo) {
				var idx = this.getChildGroupIndex(cellRange, parentExpandInfo);

				if (idx > 0) {
					idx--;
				}

				return (idx < parentExpandInfo.length)
					? idx
					: -1;
			};

			// level: 1-based level of the cellRange;
			this.getChildGroupRanges = function (leaves, cellRange, level) {
				var result = [],
					childRanges, childRange, i, len, firstChildIdx,
					childGroupedColumn = this.getColumnByGroupLevel(leaves, level + 1);

				if (childGroupedColumn) {
					childRanges = childGroupedColumn.groupInfo.expandInfo;

					firstChildIdx = this.getChildGroupIndex(cellRange, childRanges);
					for (i = firstChildIdx, len = childRanges.length; i < len; i++) {
						childRange = childRanges[i];
						if (childRange.cr.r2 <= cellRange.r2) {
							result.push(childRange);
						} else {
							break;
						}
					}

					/*for (var i = 0, len = childRanges.length; i < len; i++) {
					if (childRange.cr.r1 >= cellRange.r1 && childRange.r2 <= cellRange.r2) {
					result.push(childRange);
					}
					}*/
				}

				return result;
			};

			// level: 1-based level of the cellRange; optional.
			this.getParentGroupRange = function (leaves, cellRange, level) {
				var i, groupInfo, idx;

				if (level === undefined) {
					level = 0xFFFF;
				}

				if (level - 2 >= 0) {
					for (i = leaves.length - 1; i >= 0; i--) {
						groupInfo = leaves[i].groupInfo;
						if (!groupInfo || !groupInfo.expandInfo || (groupInfo.level < 0) || (groupInfo.level !== level - 1)) {
							continue;
						}

						idx = this.getParentGroupIndex(cellRange, groupInfo.expandInfo);
						if (idx >= 0) {
							return groupInfo.expandInfo[idx];
						}
					}
				}

				return null;
			};

			// level: 1-based level of the cellRange.
			this.isParentCollapsed = function (leaves, cellRange, level) {
				var i, parentGroupRange;

				if (level === 1) {
					return false;
				}

				for (i = level; i > 1; i--) {
					parentGroupRange = this.getParentGroupRange(leaves, cellRange, i);

					if (parentGroupRange && !parentGroupRange.isExpanded) {
						return true;
					}

					cellRange = parentGroupRange.cr;
				}

				return false;
			};

			// level: 1-based level of the cellRange.
			this.isParentExpanded = function (leaves, cellRange, level) {
				var i, parentGroupRange;

				if (level === 1) {
					return true;
				}

				for (i = level; i > 1; i--) {
					parentGroupRange = this.getParentGroupRange(leaves, cellRange, i);

					if (parentGroupRange && parentGroupRange.isExpanded) {
						return true;
					}

					cellRange = parentGroupRange.cr;
				}

				return false;
			};
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		cellRange: function (row1, col1, row2, col2) {
			switch (arguments.length) {
				case 2:
					this.r1 = this.r2 = row1;
					this.c1 = this.c2 = col1;
					break;
				case 4:
					this.r1 = row1;
					this.r2 = row2;
					this.c1 = col1;
					this.c2 = col2;
					break;
				default:
					this.r1 = 0;
					this.r2 = 0;
					this.c1 = 0;
					this.c2 = 0;
			}

			this.isSingleCell = function () {
				return ((this.r1 === this.r2) && (this.c1 === this.c2));
			};
		},

		merger: function () {
			this.merge = function (data, visibleLeaves) {
				this.leaves = visibleLeaves;
				this.data = data;

				var i, len, leaf;

				for (i = 0, len = visibleLeaves.length; i < len; i++) {
					leaf = visibleLeaves[i];

					if ((leaf.dataIndex >= 0) && !leaf.isBand && (leaf.rowMerge === "free" || leaf.rowMerge === "restricted")) {
						this.mergeColumn(leaf);
					}
				}
				delete this.data;
				delete this.leaves;
			};

			this.mergeColumn = function (column) {
				var dataIdx = column.dataIndex,
					i, len, range, span, spannedRow;

				for (i = 0, len = this.data.length; i < len; i++) {
					//if (this.data[i].rowType !== "data") {
					if (!(this.data[i].rowType & $.wijmo.wijgrid.rowType.data)) {
						continue;
					}

					range = this.getCellRange(i, column);

					if (range.r1 !== range.r2) {
						span = range.r2 - range.r1 + 1;
						//this.data[range.r1][dataIdx].rowSpan = span;
						this.data[range.r1][dataIdx].__attr.rowSpan = span;

						for (spannedRow = range.r1 + 1; spannedRow <= range.r2; spannedRow++) {
							//this.data[spannedRow][dataIdx] = null;
							this.data[spannedRow][dataIdx].visible = false;
						}
					}

					i = range.r2;
				}
			};

			this.getCellRange = function (rowIdx, column) {
				var columnIdx = column.dataIndex,
					range = new $.wijmo.wijgrid.cellRange(rowIdx, columnIdx),
					str = this.data[rowIdx][columnIdx].value,
					dataLen = this.data.length,
					dataItem, leafIdx, prevLeaf, range2;

				for (range.r2 = rowIdx; range.r2 < dataLen - 1; range.r2++) {
					dataItem = this.data[range.r2 + 1];

					//if ((dataItem.rowType !== "data") || (dataItem[columnIdx].value !== str)) {
					if (!(dataItem.rowType & $.wijmo.wijgrid.rowType.data) || (dataItem[columnIdx].value !== str)) {
						break;
					}
				}

				leafIdx = column.leavesIdx; // $.inArray(column, this.leaves);
				if (leafIdx > 0 && column.rowMerge === "restricted") {
					prevLeaf = this.leaves[leafIdx - 1];
					if (prevLeaf.dataIndex >= 0) {
						range2 = this.getCellRange(rowIdx, prevLeaf);
						range.r1 = Math.max(range.r1, range2.r1);
						range.r2 = Math.min(range.r2, range2.r2);
					}
				}

				return range;
			};
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		/// <summary>
		/// Row type.
		/// </summary>
		rowType: {
			/// <summary>
			/// Header row.
			/// </summary>
			header: 1,

			/// <summary>
			/// Data row.
			/// </summary>
			data: 2,

			/// <summary>
			/// Data alternating row (used only as modifier of the rowType.data, not as independent value).
			/// </summary>
			dataAlt: 4,

			/// <summary>
			/// Filter row.
			/// </summary>
			filter: 8,

			/// <summary>
			/// Group header row.
			/// </summary>
			groupHeader: 16,

			/// <summary>
			/// Group footer row.
			/// </summary>
			groupFooter: 32,

			/// <summary>
			/// Footer row.
			/// </summary>
			footer: 64,

			/// <summary>
			/// Empty data row
			/// </summary>
			emptyDataRow: 128
		},

		/// <summary>
		/// Determines an object render state.
		/// </summary>
		renderState: {
			/// <summary>
			/// Normal state.
			/// </summary>
			none: 0,

			/// <summary>
			/// Object is being rendered.
			/// </summary>
			rendering: 1,

			/// <summary>
			/// Object is one of the elements determining the current position of the wijgrid.
			/// </summary>
			current: 2,

			/// <summary>
			/// Object is hovered.
			/// </summary>
			hovered: 4,

			/// <summary>
			/// Object is selected.
			/// </summary>
			selected: 8
		},

		/// <summary>
		/// Determines purpose of the group row cells.
		/// </summary>
		groupRowCellPurpose: {
			groupCell: 0,
			aggregateCell: 1
		},

		stringFormat: function (value, params) {
			var i, len;

			if (!value) {
				return "";
			}

			for (i = 1, len = arguments.length; i < len; i++) {
				value = value.replace(new RegExp("\\{" + (i - 1) + "\\}", "gm"), arguments[i]);
			}

			return value;
		},

		validDataKey: function (dataKey) {
			return (dataKey && !(dataKey < 0)) || (dataKey === 0);
		},

		iterateChildrenWidgets: function (item, callback) {
			if (item && callback) {
				if (item.nodeType) {
					item = $(item);
				}

				item.find(".ui-widget").each(function (domIndex, domValue) {
					$.each($(domValue).data(), function (dataKey, dataValue) {
						if (dataValue.widgetName) {
							callback(domIndex, dataValue);
						}
					});
				});
			}
		},

		remove$dataByPrefix: function ($element, prefix) {
			var data$keys = [];

			$.each($element.data(), function (key) {
				if (key.indexOf(prefix) === 0) {
					data$keys.push(key);
				}
			});

			$.each(data$keys, function (idx, key) {
				$element.removeData(key);
			});
		},

		domSelection: function (dom) {
			// The 'dom' must be an input element
			this.getSelection = function () {
				var start = 0,
					end = 0,
					textRange;

				if (dom.selectionStart !== undefined) { // DOM3
					start = dom.selectionStart;
					end = dom.selectionEnd;
				} else {
					if (document.selection) { // IE
						textRange = document.selection.createRange().duplicate();
						end = textRange.text.length; // selection length
						start = Math.abs(textRange.moveStart("character", -dom.value.length)); // move selection to the beginning
						end += start;
					}
				}

				return { start: start, end: end, length: end - start };
			};

			// The 'dom' must be an input element
			this.setSelection = function (range) {
				if (dom.selectionStart !== undefined) { // DOM3
					dom.setSelectionRange(range.start, range.end);
				} else { // IE
					var textRange = dom.createTextRange();

					textRange.collapse(true);
					textRange.moveStart("character", range.start);
					textRange.moveEnd("character", range.end);
					textRange.select();
				}
			};

			this.toggleSelection = function (enable) {
				if (enable) {
					$(dom)
						.enableSelection()
						.css({ "MozUserSelect": "", "WebkitUserSelect": "" });
				} else {
					$(dom)
						.disableSelection()
						//the problem of inputing in the filter textbox
						//.css({ "MozUserSelect": "none", "WebkitUserSelect": "none" });
						.css({ "MozUserSelect": "-moz-none", "WebkitUserSelect": "none" });
				}
			};
		},

		createDynamicField: function (options) {
			return $.extend(true,
								{},
								$.wijmo.c1basefield.prototype.options,
								$.wijmo.c1field.prototype.options,
								{ dynamic: true, isLeaf: true, isBand: false, parentIdx: -1 },
								options
							);
		},

		bounds: function (element, client) {
			if (element) {
				var $dom = element.nodeType ? $(element) : element,
					offset = $dom.offset();

				if (offset) {
					if (client) {
						return { top: offset.top, left: offset.left, width: $dom[0].clientWidth || 0, height: $dom[0].clientHeight || 0 };
					}

					return { top: offset.top, left: offset.left, width: $dom.outerWidth(), height: $dom.outerHeight() };
				}
			}

			return null;
		},

		_getDOMText: function (domElement, controlDepth, depth) {
			if (depth === undefined) {
				depth = 0;
			}

			if (domElement && (!controlDepth || (controlDepth && depth < 3))) {
				if (domElement.nodeType === 3) { // text node
					return domElement.nodeValue;
				}
				else
					if (domElement.nodeType === 1) { // element node

						switch (domElement.type) {
							case "button":
							case "text":
							case "textarea":
							case "select-one":
								return domElement.value;
							case "checkbox":
								return domElement.checked.toString();
						}

						var result = "",
							i;

						for (i = 0; domElement.childNodes[i]; i++) {
							result += this._getDOMText(domElement.childNodes[i], controlDepth, depth + 1);
						}
						return result;
					}
			}

			return "";
		},

		ensureTBody: function (domTable) {
			if (domTable) {
				return (domTable.tBodies && domTable.tBodies.length > 0)
					? domTable.tBodies[0]
					: domTable.appendChild(document.createElement("tbody"));
			}

			return null;
		},

		rowTypeFromCss: function ($rows) {
			var test = /wijmo-wijgrid-(\S+)row/.exec($rows.attr("class"));

			if (test) {
				switch (test[1]) {
					case "header":
						return $.wijmo.wijgrid.rowType.header;

					case "filter":
						return $.wijmo.wijgrid.rowType.filter;

					case "data":
						if ($rows.hasClass("wijmo-wijgrid-alternatingrow")) {
							return $.wijmo.wijgrid.rowType.data | $.wijmo.wijgrid.rowType.dataAlt;
						}
						return $.wijmo.wijgrid.rowType.data;

					case "alternating":
						return $.wijmo.wijgrid.rowType.data | $.wijmo.wijgrid.rowType.dataAlt;

					case "groupheader":
						return $.wijmo.wijgrid.rowType.groupHeader;

					case "groupfooter":
						return $.wijmo.wijgrid.rowType.groupFooter;
				}
			}
		},

		// deep (boolean, opt), obj, prefix, name (opt), value(s) (opt)
		dataPrefix: function () {
			var len = arguments.length,
				key, value, internalName,
				deep = (typeof (arguments[0]) === "boolean"),
				obj = deep ? arguments[1] : arguments[0],
				is$ = (obj.nodeType === undefined),
				foo, i, currentVal;

			if (len === 3) { // getter
				internalName = arguments[1] + arguments[2];
				return (is$)
					? $.data(obj[0], internalName)
					: $.data(obj, internalName);
			} else { // setter
				if (deep) {
					value = arguments[3];

					for (key in value) {
						currentVal = value[key];
						if (value.hasOwnProperty(key)) {
							internalName = arguments[2] + key;
							if (is$) {
								for (i = 0, len = obj.length; i < len; i++) {
									foo = $.data(obj[i], internalName, currentVal);
								}
							} else {
								$.data(obj, internalName, currentVal);
							}
						}
					}
				} else {
					internalName = arguments[1] + arguments[2];
					currentVal = arguments[3];

					if (is$) {
						for (i = 0, len = obj.length; i < len; i++) {
							foo = $.data(obj[i], internalName, currentVal);
						}
						return foo;
					} else {
						return $.data(obj, internalName, currentVal);
					}
				}
			}
		},

		shallowMerge: function (target, src) {
			if (src && target) {
				var name, value, typeOf;

				for (name in src) {
					if (src.hasOwnProperty(name)) {
						value = src[name];
						typeOf = typeof (value);

						if ((typeOf === "string" || typeOf === "boolean" || typeOf === "number") && (target[name] === undefined)) {
							target[name] = value;
						}
					}
				}
			}
		},

		isCustomObject: function (value) {
			return (value && (typeof (value) === "object") && !(value instanceof Date));
		},

		search: function (value, test) {
			var key, foo,
				isFunc = $.isFunction(test);

			for (key in value) {
				if (value.hasOwnProperty(key)) {

					foo = isFunc
						? test(value[key])
						: (value[key] === test);

					if (foo === true) {
						return {
							at: key,
							found: value[key]
						};
					}
				}
			}

			return {
				at: null,
				found: null
			};
		},

		getAttributes: function (dom, prevent) {
			if (dom) {
				var	i, len,
					cnt = 0,
					result = {},
					attrValue, attrName;

				for (i = 0, len = dom.attributes.length; i < len; i++) {
					attrName = dom.attributes[i].name;
					if (attrName && (!prevent || !prevent(attrName))) {
						attrValue = dom.getAttribute(attrName);

						if (attrName === "style") {
							attrValue = (typeof (attrValue) === "object")
								? attrValue.cssText
								: attrValue;
						}

						if (!attrValue && attrName === "class") {
							attrValue = dom.getAttribute("className");
						}

						if (attrValue && (typeof (attrValue) !== "function")) {
							result[attrName] = attrValue;
							cnt++;
						}
					}
				}

				if (cnt) {
					return result;
				}
			}

			return null;
		}
	});


	/*$.extend($.wijmo.wijgrid, {
	measurments: [],

	timerOn: function (cat) {
	this.measurments[cat] = new Date().getTime();
	},

	timerOff: function (cat) {
	var result = (new Date().getTime() - this.measurments[cat]) / 1000;
	delete this.measurments[cat];
	return result;
	},
	});*/
})(jQuery);(function ($) {
	"use strict";

	$.extend($.wijmo.wijgrid, {
		embeddedParsers: {
			stringParser: {
				// DOM -> string
				parseDOM: function (value, culture, format, nullString, convertEmptyStringToNull) {
					return this.parse($.wijmo.wijgrid._getDOMText(value, true), culture, format, nullString, convertEmptyStringToNull);
				},

				// string -> string
				parse: function (value, culture, format, nullString, convertEmptyStringToNull) {
					switch (value) {
						case null:
							return null;

						case nullString:
							if (convertEmptyStringToNull) {
								return null;
							}

						case undefined:
						case "&nbsp;":
							return "";

						default:
							return "" + value;
					}
				},

				// string -> string
				toStr: function (value, culture, format, nullString, convertEmptyStringToNull) {
					if (value === null && convertEmptyStringToNull) {
						return nullString;
					}
					return "" + value;
				}
			},

			numberParser: {
				// DOM -> number
				parseDOM: function (value, culture, format, nullString, convertEmptyStringToNull) {
					return this.parse($.wijmo.wijgrid._getDOMText(value, true), culture, format, nullString, convertEmptyStringToNull);
				},

				// string\ number -> number
				parse: function (value, culture, format, nullString, convertEmptyStringToNull) {
					var type = typeof (value);

					if (type === "number") {
						return isNaN(value)
							? NaN
							: value;
					}

					if ((!value && value !== 0) || (value === "&nbsp;") || (value === nullString && convertEmptyStringToNull)) {
						return null;
					}

					return Globalize.parseFloat(value, 10, culture.name);
				},

				// number -> string
				toStr: function (value, culture, format, nullString, convertEmptyStringToNull) {
					if (value === null && convertEmptyStringToNull) {
						return nullString;
					}

					return Globalize.format(value, format || "n", culture.name);
				}
			},

			currencyParser: {
				// DOM -> number
				parseDOM: function (value, culture, format, nullString, convertEmptyStringToNull) {
					return this.parse($.wijmo.wijgrid._getDOMText(value, true), culture, format, nullString, convertEmptyStringToNull);
				},

				// string\ number -> number
				parse: function (value, culture, format, nullString, convertEmptyStringToNull) {
					var type = typeof (value);

					if (type === "number") {
						return isNaN(value)
							? NaN
							: value;
					}

					if ((!value && value !== 0) || (value === "&nbsp;") || (value === nullString && convertEmptyStringToNull)) {
						return null;
					}

					if (type === "string") {
						value = value.replace(culture.numberFormat.currency.symbol, "");
					}

					return Globalize.parseFloat(value, 10, culture.name);
				},

				// number -> string (currency)
				toStr: function (value, culture, format, nullString, convertEmptyStringToNull) {
					if (value === null && convertEmptyStringToNull) {
						return nullString;
					}

					return Globalize.format(value, format || "c", culture.name);
				}
			},

			dateTimeParser: {
				// DOM -> datetime
				parseDOM: function (value, culture, format, nullString, convertEmptyStringToNull) {
					return this.parse($.wijmo.wijgrid._getDOMText(value, true), culture, format, nullString, convertEmptyStringToNull);
				},

				// string/ datetime -> datetime
				parse: function (value, culture, format, nullString, convertEmptyStringToNull) {
					var match;

					if (value instanceof Date) {
						return value;
					}

					if (!value || (value === "&nbsp;") || (value === nullString && convertEmptyStringToNull)) {
						return null;
					}

					match = /^\/Date\((\d+)\)\/$/.exec(value);
					if (match) {
						return new Date(parseInt(match[1], 10));
					}

					return Globalize.parseDate(value, format, culture.name);
				},

				// datetime -> string
				toStr: function (value, culture, format, nullString, convertEmptyStringToNull) {
					if (value === null && convertEmptyStringToNull) {
						return nullString;
					}

					return Globalize.format(value, format || "d", culture.name);
				}
			},

			boolParser: {
				// DOM -> bool
				parseDOM: function (value, culture, format, nullString, convertEmptyStringToNull) {
					return this.parse($.wijmo.wijgrid._getDOMText(value, true), culture, format, nullString, convertEmptyStringToNull);
				},

				// string\ bool -> bool
				parse: function (value, culture, format, nullString, convertEmptyStringToNull) {
					var valType = typeof (value);

					if (valType === "boolean") {
						return value;
					}

					if (valType === "string") {
						value = $.trim(value);
					}

					if (!value || (value === "&nbsp;") || (value === nullString && convertEmptyStringToNull)) {
						return null;
					}

					switch (value.toLowerCase()) {
						case "true":
							return true;

						case "false":
							return false;
					}

					return NaN;
				},

				// bool -> string
				toStr: function (value, culture, format, nullString, convertEmptyStringToNull) {
					if (value === null && convertEmptyStringToNull) {
						return nullString;
					}

					return (value) ? "true" : "false";
				}
			}
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		filterOperatorsCache: function () {
			var _cache = {};

			this.add = function (operator) {
				if (operator && operator.name && operator.operator) {
					var name = operator.name.toLowerCase();
					if (!_cache[name]) {
						_cache[name] = operator;
					}
				}
			};

			this.clear = function () {
				_cache.length = 0;
			};

			this.getByName = function (name) {
				return _cache[name.toLowerCase()];
			};

			this.getByDataType = function (dataType) {
				var result = [],
					name, operator;

				for (name in _cache) {
					if (_cache.hasOwnProperty(name)) {
						operator = _cache[name];

						if ($.inArray(dataType, operator.applicableTo) >= 0) {
							result.push(operator);
						}
					}
				}

				return result;
			};

			this.removeCustom = function () {
				var name;

				for (name in _cache) {
					if (_cache[name].custom) {
						delete _cache[name];
					}
				}
			};

			this.sort = function (filtersArray, mode) {
				switch (mode.toLowerCase()) {
					case "alphabetical":
						filtersArray.sort(sortAlpha);
						break;
					case "alphabeticalcustomfirst":
						filtersArray.sort(sortAlphaCustomFirst);
						break;

					case "alphabeticalembeddedFirst":
						filtersArray.sort(sortAlphaEmbeddedFirst);
						break;

					case "none": // do nothing
						break;

					default:
						break;
				}

				return filtersArray;
			};

			function sortAlpha(a, b) {
				var n1 = a.name.toLowerCase(),
					n2 = b.name.toLowerCase();

				if (n1 !== n2) {
					if (n1 === "nofilter") {
						return -1;
					}

					if (n2 === "nofilter") {
						return 1;
					}
				}

				if (n1 === n2) {
					return 0;
				}

				return (n1 < n2)
					? -1
					: 1;
			}

			function sortAlphaEmbeddedFirst(a, b) {
				var n1 = a.name.toLowerCase(),
					n2 = b.name.toLowerCase();

				if (n1 !== n2) {
					if (n1 === "nofilter") {
						return -1;
					}

					if (n2 === "nofilter") {
						return 1;
					}
				}

				if (a.custom !== b.custom) {
					if (a.custom) {
						return 1;
					}

					if (b.custom) {
						return -1;
					}
				}

				if (n1 === n2) {
					return 0;
				}

				return (n1 < n2)
					? -1
					: 1;
			}

			function sortAlphaCustomFirst(a, b) {
				var n1 = a.name.toLowerCase(),
					n2 = b.name.toLowerCase();

				if (n1 !== n2) {
					if (n1 === "nofilter") {
						return -1;
					}

					if (n2 === "nofilter") {
						return 1;
					}
				}

				if (a.custom !== b.custom) {
					if (a.custom) {
						return -1;
					}

					if (b.custom) {
						return 1;
					}
				}

				if (n1 === n2) {
					return 0;
				}

				return (n1 < n2)
					? -1
					: 1;
			}
		}
	});

	$.wijmo.wijgrid.embeddedFiltersImpl = {
		_anyCmp: function (dataVal, filterVal, cmp) {
			var i, len, fv,
				flag = false;

			if (!$.isArray(filterVal)) {
				filterVal = [filterVal];
			}

			if (!(len = filterVal.length)) {
				return false;
			}

			if (dataVal instanceof Date) {
				dataVal = dataVal.getTime();
			}

			if (typeof (dataVal) === "string") {
				dataVal = dataVal.toLowerCase();
			}

			for (i = 0; (i < len) && !flag; i++) { // "or" condition
				fv = filterVal[i];

				if (fv instanceof Date) {
					fv = fv.getTime();
				}

				if (typeof (fv) === "string") {
					fv = fv.toLowerCase();
				}

				flag = cmp(dataVal, fv);
			}

			return flag;
		}
	};

	// note: optional displayName property can be specified in case of localization.
	$.wijmo.wijgrid.embeddedFilters = {
		nofilter: {
			name: "NoFilter",
			arity: 1,
			applicableTo: ["string", "number", "datetime", "currency", "boolean"],
			operator: function (dataVal) {
				return true;
			}
		},

		contains:
		{
			name: "Contains",
			arity: 2,
			applicableTo: ["string"],
			operator: function (dataVal, filterVal) {
				return $.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(dataVal, filterVal, function (dataVal, filterVal) {
					return (dataVal === filterVal) // handle null, undefined, etc
						|| (dataVal ? dataVal.indexOf(filterVal) >= 0 : false);
				});
			}
		},

		notcontain: {
			name: "NotContain",
			arity: 2,
			applicableTo: ["string"],
			operator: function (dataVal, filterVal) {
				return !$.wijmo.wijgrid.embeddedFilters.contains.operator(dataVal, filterVal);
			}
		},

		beginswith: {
			name: "BeginsWith",
			arity: 2,
			applicableTo: ["string"],
			operator: function (dataVal, filterVal) {
				return $.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(dataVal, filterVal, function (dataVal, filterVal) {
					return (dataVal === filterVal) // handle null, undefined, etc
						|| (dataVal ? dataVal.indexOf(filterVal) === 0 : false);
				});
			}
		},

		endswith: {
			name: "EndsWith",
			arity: 2,
			applicableTo: ["string"],
			operator: function (dataVal, filterVal) {
				return $.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(dataVal, filterVal, function (dataVal, filterVal) {
					var flag = (dataVal === filterVal), // handle null, undefined, etc
						idx;

					if (!flag && dataVal) {
						idx = dataVal.lastIndexOf(filterVal);
						if (idx >= 0) {
							flag = (dataVal.length - idx === filterVal.length);
						}
					}

					return flag;
				});
			}
		},

		equals: {
			name: "Equals",
			arity: 2,
			applicableTo: ["string", "number", "datetime", "currency", "boolean"],
			operator: function (dataVal, filterVal) {
				return $.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(dataVal, filterVal, function (dataVal, filterVal) {
					return (dataVal === filterVal);
				});
			}
		},

		notequal: {
			name: "NotEqual",
			arity: 2,
			applicableTo: ["string", "number", "datetime", "currency", "boolean"],
			operator: function (dataVal, filterVal) {
				return $.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(dataVal, filterVal, function (dataVal, filterVal) {
					return (dataVal !== filterVal);
				});
			}
		},

		greater: {
			name: "Greater",
			arity: 2,
			applicableTo: ["string", "number", "datetime", "currency", "boolean"],
			operator: function (dataVal, filterVal) {
				return $.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(dataVal, filterVal, function (dataVal, filterVal) {
					return (dataVal > filterVal);
				});
			}
		},

		less: {
			name: "Less",
			arity: 2,
			applicableTo: ["string", "number", "datetime", "currency", "boolean"],
			operator: function (dataVal, filterVal) {
				return $.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(dataVal, filterVal, function (dataVal, filterVal) {
					return (dataVal < filterVal);
				});
			}
		},

		greaterorequal: {
			name: "GreaterOrEqual",
			arity: 2,
			applicableTo: ["string", "number", "datetime", "currency", "boolean"],
			operator: function (dataVal, filterVal) {
				return $.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(dataVal, filterVal, function (dataVal, filterVal) {
					return (dataVal >= filterVal);
				});
			}
		},

		lessorequal: {
			name: "LessOrEqual",
			arity: 2,
			applicableTo: ["string", "number", "datetime", "currency", "boolean"],
			operator: function (dataVal, filterVal) {
				return $.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(dataVal, filterVal, function (dataVal, filterVal) {
					return (dataVal <= filterVal);
				});
			}
		},

		isempty: {
			name: "IsEmpty",
			arity: 1,
			applicableTo: ["string"],
			operator: function (dataVal) {
				return $.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(dataVal, undefined, function (dataVal) {
					return !dataVal && dataVal !== 0 && dataVal !== false; // null, undefined, or empty string
				});
			}
		},

		notisempty: {
			name: "NotIsEmpty",
			arity: 1,
			applicableTo: ["string"],
			operator: function (dataVal) {
				return $.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(dataVal, undefined, function (dataVal) {
					return !!dataVal || dataVal === 0 || dataVal === false; // ! (null, undefined, or empty string)
				});
			}
		},

		isnull: {
			name: "IsNull",
			arity: 1,
			applicableTo: ["string", "number", "datetime", "currency", "boolean"],
			operator: function (dataVal) {
				return $.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(dataVal, undefined, function (dataVal) {
					return dataVal === null;
				});
			}
		},

		notisnull: {
			name: "NotIsNull",
			arity: 1,
			applicableTo: ["string", "number", "datetime", "currency", "boolean"],
			operator: function (dataVal) {
				return $.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(dataVal, undefined, function (dataVal) {
					return dataVal !== null;
				});
			}
		}
	};
})(jQuery);


(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		filterHelper: {
			// filterValue
			// [filterValue, ..., filterValue]
			// [[filterValue, ..., filterValue], ..., [filterValue, ..., filterValue]]
			getSingleValue: function(filterValue) {
				if ($.isArray(filterValue)) {
					filterValue = filterValue[0];

					if ($.isArray(filterValue)) {
						filterValue = filterValue[0];
					}
				}

				return filterValue;
			},

			// filterOperator -> name | { name, condition }
			// filterOperator -> filterOperator | [ filterOperator, ..., filterOperator]
			getSingleOperatorName: function(filterOperator) {
				if ($.isArray(filterOperator)) {
					filterOperator = filterOperator[0];
				}

				return filterOperator.name || filterOperator || "";
			},

			// filterOperator: opName | [opName, ..., opName] | [ { name, condition }, ..., { name, condition } ]
			// filterValue: filterValue | [filterValue, ... , filterValue] | [[], ..., []]
			verify: function(filterOperator, filterValue, dataType, cache) {
				if (filterOperator) {
					if ($.isArray(filterOperator)) {
						var i, len,
							fop = [],
							fval = [];

						if (!$.isArray(filterValue)) {
							filterValue = [filterValue];
						}

						for (i = 0, len = filterOperator.length; i < len; i++) {
							if (this._verifySingleOp(filterOperator[i], filterValue[i], dataType, cache)) {
								fop.push({
									name: filterOperator[i].name || filterOperator[i],
									condition: filterOperator[i].condition || "or" 
								});
								
								fval.push(filterValue ? filterValue[i] : undefined);
							}
						}

						if (fop.length) {
							return {
								filterOperator: fop,
								filterValue: fval
							};
						}
					} else {
						if (this._verifySingleOp(filterOperator, filterValue, dataType, cache)) { 
							return { // compatibility with old model
								filterOperator: filterOperator,
								filterValue: filterValue
							};
						}
					}
				}

				return null;
			},


			// filterOpeator: name | { name, condition }
			_verifySingleOp : function (filterOperator, filterValue, dataType, cache) {
				if (filterOperator && (filterOperator = (filterOperator.name || filterOperator))) {
					var fop;

					filterOperator = (filterOperator || "").toLowerCase();

					if (filterOperator !== "nofilter" && (fop = cache.getByName(filterOperator))) {
					
						if ($.inArray(dataType || "string", fop.applicableTo) >= 0) {
							if (fop.arity === 1 || (fop.arity > 1 && this.getSingleValue(filterValue) !== undefined)) {
								return true;
							}
						}
					}
				}

				return false;
			}
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		htmlTableAccessor: function (domTable) {
			var offsets = [],
				width = 0,
				table = domTable;

			_buildOffsets();

			function _buildOffsets() {
				var rowSpan = [],
					rowOffsets, i, rowLen, row, j, jOffset, celLen, cell, cs, rowSpanLen;

				for (i = 0, rowLen = table.rows.length; i < rowLen; i++) {
					rowOffsets = [];
					offsets[i] = rowOffsets;

					row = table.rows[i];
					for (j = 0, jOffset = 0, celLen = row.cells.length; j < celLen; j++, jOffset++) {
						cell = row.cells[j];

						// process rowspan
						for (; rowSpan[jOffset] > 1; jOffset++) {
							rowSpan[jOffset]--;
							rowOffsets[jOffset] = { cellIdx: -1, colIdx: -1 };
						}

						if (!(rowSpan[jOffset] > 1)) {
							rowSpan[jOffset] = cell.rowSpan;
						}

						rowOffsets[jOffset] = { cellIdx: j, colIdx: -1 };
						rowOffsets[j].colIdx = jOffset;

						// process colspan
						cs = cell.colSpan;
						for (; cs > 1; cs--) {
							rowOffsets[++jOffset] = { cellIdx: -1, colIdx: -1 };
						}
					}

					rowSpanLen = rowSpan.length;
					for (; jOffset < rowSpanLen; jOffset++) {
						rowSpan[jOffset]--;
						rowOffsets[jOffset] = { cellIdx: -1, colIdx: -1 };
					}

					width = Math.max(width, rowSpanLen);
				}
			}

			this.element = function () {
				return domTable;
			};

			this.getCellIdx = function (colIdx, rowIdx) {
				return (colIdx < width)
					? offsets[rowIdx][colIdx].cellIdx
					: -1;
			};

			// arguments:
			// (cellIdex, rowIdx)
			// or
			// (domCell)
			this.getColumnIdx = function (cellIdx, rowIdx) {
				if (typeof (cellIdx) !== "number") { // domCell
					var domCell = cellIdx;

					cellIdx = domCell.cellIndex;
					rowIdx = domCell.parentNode.rowIndex;
				}

				return (cellIdx < width)
					? offsets[rowIdx][cellIdx].colIdx
					: -1;
			};

			// section:
			// 1 - tHead
			// 2 - tBody
			// 3 - tFoot
			// otherwise - table
			this.getSectionLength = function (section) {
				return $.wijmo.wijgrid.getTableSectionLength(table, section);
			};

			// section:
			// 1 - tHead
			// 2 - tBody
			// 3 - tFoot
			// otherwise - table
			this.getSectionRow = function (rowIndex, section) {
				return $.wijmo.wijgrid.getTableSectionRow(table, section, rowIndex);
			};

			// iterates through the table rows using natural cells order
			this.forEachColumnCellNatural = function (columnIdx, callback, param) {
				var i, rowLen, row, result;

				for (i = 0, rowLen = table.rows.length; i < rowLen; i++) {
					row = table.rows[i];

					if (columnIdx < row.cells.length) {
						result = callback(row.cells[columnIdx], columnIdx, param);
						if (result !== true) {
							return result;
						}
					}
				}

				return true;
			};

			// iterates through the table rows using colSpan\rowSpan offsets
			this.forEachColumnCell = function (columnIdx, callback, param) {
				var i, rowLen, row, offsetCellIdx, result;

				for (i = 0, rowLen = offsets.length; i < rowLen; i++) {
					row = table.rows[i];

					offsetCellIdx = this.getCellIdx(columnIdx, i);
					if (offsetCellIdx >= 0) {
						result = callback(row.cells[offsetCellIdx], i, param);
						if (result !== true) {
							return result;
						}
					}
				}

				return true;
			};

			// iterates throw the cells of a table row
			this.forEachRowCell = function (rowIndex, callback, param) {
				var row = table.rows[rowIndex],
					i, celLen, result;

				for (i = 0, celLen = row.cells.length; i < celLen; i++) {
					result = callback(row.cells[i], i, param);
					if (result !== true) {
						return result;
					}
				}

				return true;
			};

			this.colGroupTag = function () {
				var cgs = table.getElementsByTagName("colgroup");

				return (cgs !== null && cgs.length > 0) ? cgs[0] : null;
			};

			this.colTags = function () {
				var colGroup = this.colGroupTag();

				return (colGroup !== null) ? colGroup.getElementsByTagName("col") : [];
			};
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.wijmo.wijgrid.cellInfo = function (cellIndex, rowIndex) {
		/// <summary>
		/// Creates an object that represents a single cell.
		/// Code example: var cell = new $.wijmo.wijgrid.cellInfo(0, 0);
		/// </summary>
		/// <param name="cellIndex">Zero-based index of the required cell inside the corresponding row.</param>
		/// <param name="rowIndex">Zero-based index of the row that contains required cell.</param>
		/// <returns type="$.wijmo.wijgrid.cellInfo">Object that represents a single cell.</returns>

		var _isEdit = false,
			_gridView = null;

		// public
		this.cellIndex = function (value) {
			/// <summary>
			/// Gets the zero-based index of the cell in the row which it corresponds to.
			/// Code example: var index = cellInfoObj.cellIndex();
			/// </summary>
			/// <returns type="Number" integer="true"></returns>

			if (arguments.length === 0) {
				return cellIndex;
			}

			cellIndex = value;
		};

		this.column = function () {
			/// <summary>
			/// Gets the associated column object.
			/// Code example: var column = cellInfoObj.column();
			/// </summary>
			/// <returns type="Object"></returns>

			if (_gridView && this._isValid()) {
				var offset = _gridView._getDataToAbsOffset();

				return _gridView._field("visibleLeaves")[cellIndex + offset.x];
			}

			return null;
		};

		this.container = function () {
			/// <summary>
			/// Returns the jQuery object containing a cell content.
			/// Code example: var $container = cellInfoObj.container();
			/// </summary>
			/// <returns type="jQuery" />
			var tableCell = this.tableCell(),
				$innerDiv;

			if (tableCell) {
				$innerDiv = $(tableCell).children("div.wijmo-wijgrid-innercell");
				if ($innerDiv) {
					return $innerDiv;
				}
			}

			return null;
		};

		this.isEqual = function (value) {
			/// <summary>
			/// Compares the current object with a specified one and indicates whether they are identical.
			/// Code example: var isEqual = cellInfoObj1.isEqual(cellInfoObj2);
			/// </summary
			/// <param name="value" type="$.wijmo.wijgrid.cellInfo">The object to compare</param>
			/// <returns type="Boolean">True if the objects are identical, otherwise false.</returns>
			return (value && (value.rowIndex() === rowIndex) && (value.cellIndex() === cellIndex));
		};

		this.row = function () {
			/// <summary>
			/// Gets the accociated row's information.
			/// Code example: var row = cellInfoObj.row();
			/// </summary>
			/// <returns type="object">
			/// Information about associated row.
			/// 
			/// The return value has the following properties:
			/// $rows: jQuery object that represents associated rows.
			/// data: associated data.
			/// dataRowIndex: data row index.
			/// dataItemIndex: data item index.
			/// virtualDataItemIndex: virtual data item index.
			/// type: type of the row, one of the $.wijmo.wijgrid.rowType values.
			/// </returns>

			var rowObj = this._row();

			if (rowObj !== null) {
				rowObj = _gridView._createRowInfo(rowObj);
				return rowObj;
			}

			return null;
		};

		this.rowIndex = function (value) {
			/// <summary>
			/// Gets the zero-based index of the row containing the cell.
			/// Code example: var index = cellInfoObj.rowIndex();
			/// </summary>
			/// <returns type="Number" integer="true"></returns>

			if (arguments.length === 0) {
				return rowIndex;
			}

			rowIndex = value;
		};

		this.tableCell = function () {
			/// <summary>
			/// Returns the table cell element corresponding to this object.
			/// Code example: var domCell = cellInfoObj.tableCell();
			/// </summary>
			/// <returns type="Object" domElement="true" />
			if (_gridView && this._isValid()) {
				var offset = _gridView._getDataToAbsOffset();

				return _gridView._view().getCell(cellIndex + offset.x, rowIndex + offset.y);
			}

			return null;
		};

		this.value = function (value/*opt*/) {
			/// <summary>
			/// Gets or sets underlying cell data.
			/// Code example:
			/// -) Getter:
			///   var value = cellInfoObj.value();
			/// -) Setter:
			///   cellInfoObj.value("value");
			/// </summary>
			/// <param name="value" type="Object">Value to set.</param>
			/// <returns type="Object" />
			/// <remarks>
			/// "invalid value" exception will be thrown by the setter if the value does not correspond to associated column.
			/// </remarks>
			var column, dataTableRow;

			if (_gridView && this._isValid()) {
				dataTableRow = _gridView.dataTable[rowIndex];
				if (dataTableRow.rowType & $.wijmo.wijgrid.rowType.data) {
					column = this.column();

					if (arguments.length === 0) { // getter
						return dataTableRow[/*cellIndex*/column.dataIndex].value;
					} else { // setter
						// validation
						value = _gridView._parse(column, value);

						if ((value === null && column.valueRequired) ||
						(column.dataType && column.dataType !== "string" && isNaN(value))) {
							throw "invalid value";
						}

						dataTableRow[column.dataIndex].value = value;
						_gridView._dataStore.updateValue(dataTableRow.originalRowIndex, column.dataKey, value);
					}
				}
			}
		};

		this.toString = function () {
			return cellIndex + ":" + rowIndex;
		};

		// * public

		// internal

		this._absToData = function (offset) {
			cellIndex -= offset.x;
			rowIndex -= offset.y;

			return this;
		};

		this._clip = function (range) {
			var flag = false,
				val;

			if (cellIndex < (val = range.topLeft().cellIndex())) {
				flag = true;
				cellIndex = val;
			}

			if (cellIndex > (val = range.bottomRight().cellIndex())) {
				flag = true;
				cellIndex = val;
			}

			if (rowIndex < (val = range.topLeft().rowIndex())) {
				flag = true;
				rowIndex = val;
			}

			if (rowIndex > (val = range.bottomRight().rowIndex())) {
				flag = true;
				rowIndex = val;
			}

			return flag;
		};

		this._clone = function () {
			return new $.wijmo.wijgrid.cellInfo(cellIndex, rowIndex);
		};

		this._dataToAbs = function (offset) {
			cellIndex += offset.x;
			rowIndex += offset.y;

			return this;
		};

		this._row = function () {
			if (_gridView && this._isValid()) {
				return _gridView._rows().item(rowIndex);
			}

			return null;
		};

		this._isValid = function () {
			return cellIndex >= 0 && rowIndex >= 0;
		};

		this._isEdit = function (value) {
			if (!arguments.length) {
				return _isEdit;
			}

			_isEdit = value;
		};

		this._setGridView = function (value) {
			_gridView = value;
		};

		// internal *
	};

	$.wijmo.wijgrid.cellInfo.prototype.outsideValue = new $.wijmo.wijgrid.cellInfo(-1, -1);

	$.wijmo.wijgrid.cellInfoRange = function (topLeft, bottomRight) {
		/// <summary>
		/// Creates an object that specifies a range of cells determined by two cells.
		/// Code example: var range = $.wijmo.wijgrid.cellInfoRange(new $.wijmo.wijgrid.cellInfo(0, 0), new $.wijmo.wijgrid.cellInfo(0, 0));
		/// </summary>
		/// <param name="topLeft" type="$.wijmo.wijgrid.cellInfo">Object that represents the top left cell of the range.</param>
		/// <param name="bottomRight" type="$.wijmo.wijgrid.cellInfo">Object that represents the bottom right cell of the range.</param>
		/// <returns type="$.wijmo.wijgrid.cellInfoRange"></returns>

		if (!topLeft || !bottomRight) {
			throw "invalid arguments";
		}

		var _topLeft = topLeft._clone(),
			_bottomRight = bottomRight._clone();

		// public 

		this.bottomRight = function () {
			/// <summary>
			/// Gets the object that represents the bottom right cell of the range.
			/// Code example: var cellInfoObj = range.bottomRight();
			/// </summary>
			/// <returns type="$.wijmo.wijgrid.cellInfo" />
			return _bottomRight;
		};

		this.isEqual = function (range) {
			/// <summary>
			/// Compares the current range with a specified range and indicates whether they are identical.
			/// Code example: var isEqual = range1.isEqual(range2);
			/// </summary>
			/// <param name="range" type="$.wijmo.wijgrid.cellInfoRange">Range to compare.</param>
			/// <returns type="Boolean">True if the ranges are identical, otherwise false.</returns>
			return (range && _topLeft.isEqual(range.topLeft()) && _bottomRight.isEqual(range.bottomRight()));
		};

		this.topLeft = function () {
			/// <summary>
			/// Gets the object that represents the top left cell of the range.
			/// Code example: var cellInfoObj = range.topLeft();
			/// </summary>
			/// <returns type="$.wijmo.wijgrid.cellInfo" />
			return _topLeft;
		};

		this.toString = function () {
			return _topLeft.toString() + " - " + _bottomRight.toString();
		};

		// public *

		// internal
		this._isIntersect = function (range) {
			var rangeH, thisH, rangeW, thisW;

			if (range) {
				rangeH = range.bottomRight().rowIndex() - range.topLeft().rowIndex() + 1;
				thisH = _bottomRight.rowIndex() - _topLeft.rowIndex() + 1;

				if ((range.topLeft().rowIndex() + rangeH) - _topLeft.rowIndex() < rangeH + thisH) {
					rangeW = range.bottomRight().cellIndex() - range.topLeft().cellIndex() + 1;
					thisW = _bottomRight.cellIndex() - _topLeft.cellIndex() + 1;

					return ((range.topLeft().cellIndex() + rangeW) - _topLeft.cellIndex() < rangeW + thisW);
				}
			}

			return false;
		};

		this._isValid = function () {
			return _topLeft._isValid() && _bottomRight._isValid();
		};

		this._clip = function (clipBy) {
			return _topLeft._clip(clipBy) | _bottomRight._clip(clipBy);
		};

		this._clone = function () {
			return new $.wijmo.wijgrid.cellInfoRange(_topLeft._clone(), _bottomRight._clone());
		};

		this._containsCellInfo = function (info) {
			return (info && info.cellIndex() >= _topLeft.cellIndex() && info.cellIndex() <= _bottomRight.cellIndex() &&
				info.rowIndex() >= _topLeft.rowIndex() && info.rowIndex() <= _bottomRight.rowIndex());
		};

		this._containsCellRange = function (range) {
			return (range && this._containsCellInfo(range.topLeft()) && this._containsCellInfo(range.bottomRight()));
		};

		// mode:
		//  0: none
		//  1: extendToColumn
		//  2: extendToRow
		//
		// borders - cellInfoRange
		this._extend = function (mode, borders) {
			if (mode === 1) {
				_topLeft.rowIndex(borders.topLeft().rowIndex());
				_bottomRight.rowIndex(borders.bottomRight().rowIndex());
			} else {
				if (mode === 2) {
					_topLeft.cellIndex(borders.topLeft().cellIndex());
					_bottomRight.cellIndex(borders.bottomRight().cellIndex());
				}
			}

			return this;
		};

		this._normalize = function () {
			var x0 = _topLeft.cellIndex(),
				y0 = _topLeft.rowIndex(),
				x1 = _bottomRight.cellIndex(),
				y1 = _bottomRight.rowIndex();

			_topLeft.cellIndex(Math.min(x0, x1));
			_topLeft.rowIndex(Math.min(y0, y1));

			_bottomRight.cellIndex(Math.max(x0, x1));
			_bottomRight.rowIndex(Math.max(y0, y1));
		};

		// internal *
	};
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		classFactory: function (base, props) {
			var fakeMarker = "#fake#",

				overrideTest = (/xyz/.test(function () { xyz; }))
					? /\b_base\b/
					: /.*/,

				proto = base
					? base.prototype
					: function () { },

				subClass = base
					? new base(fakeMarker)
					: new proto(),

				key, propVal, result;

			for (key in props) {
				if (props.hasOwnProperty(key)) {
					propVal = props[key];

					if (proto && (typeof (propVal) === "function") && (typeof (proto[key]) === "function") && overrideTest.test(propVal)) {
						subClass[key] = (function (name, func) {
							return function () {
								var tmp = this._base,
									result;

								this._base = proto[name];
								result = func.apply(this, arguments);

								if (tmp !== undefined) {
									this._base = tmp;
								} else {
									delete this._base;
								}

								return result;
							};
						})(key, propVal);
					} else {
						subClass[key] = propVal;
					}
				}
			}

			result = function (fakeFlag) {
				if ((fakeFlag !== fakeMarker) && this.ctor) {
					this.ctor.apply(this, arguments);
				}
			};

			result.prototype = subClass;
			result.constructor = subClass;

			return result;
		}
	});
})(jQuery);

(function ($) {
	"use strict";

	$.wijmo.wijgrid.baseView = $.wijmo.wijgrid.classFactory(null, {
		// ** public
		ctor: function (wijgrid) {
			if (!wijgrid) {
				throw "'wijgrid' must be specified";
			}

			this._rowHeaderSize = 22;
			this._wijgrid = wijgrid;

			this._wijgrid.element.addClass("wijmo-wijgrid-table");
		},

		dispose: function () {
			this.toggleDOMSelection(true);
			this._wijgrid.element.removeClass("wijmo-wijgrid-table");
		},

		ensureDisabledState: function () {
			var disabledClass = this._wijgrid.widgetBaseClass + "-disabled ui-state-disabled",
				disabled = this._wijgrid.options.disabled;

			$.each(this.subTables(), function (key, table) {
				if (table) {
					var $table = $(table.element());

					if (disabled) {
						$table
							.addClass(disabledClass)
							.attr("aria-disabled", true);
					}
					else {
						$table
							.removeClass(disabledClass)
							.attr("aria-disabled", false);
					}
				}
			});
		},

		ensureWidth: function (index, value, oldValue) {
			this._setColumnWidth(index, value);
		},

		ensureHeight: function (index) {
		},

		getVisibleAreaBounds: function () {
			throw "not implemented";
		},

		getFixedAreaVisibleBounds: function () {
			throw "not implemented";
		},

		render: function () {
			this._preRender();
			this._renderContent();
			this._postRender();
		},

		toggleDOMSelection: function (enable) {
			$.each(this.subTables(), function (index, htmlTableAccessor) {
				(new $.wijmo.wijgrid.domSelection(htmlTableAccessor.element())).toggleSelection(enable);
			});

			(new $.wijmo.wijgrid.domSelection(this._wijgrid.outerDiv)).toggleSelection(enable);
		},

		updateSplits: function (scrollValue) {
			throw "not implemented";
		},

		// public **

		// ** DOMTable abstraction

		focusableElement: function () {
			throw "not implemented";
		},

		forEachColumnCell: function (columnIndex, callback, param) {
			throw "not implemented";
		},

		forEachRowCell: function (rowIndex, callback, param) {
			throw "not implemented";
		},

		getAbsoluteCellInfo: function (domCell) {
			throw "not implemented";
		},

		getAbsoluteRowIndex: function (domRow) {
			throw "not implemented";
		},

		getCell: function (absColIdx, absRowIdx) {
			throw "not implemented";
		},

		getColumnIndex: function (domCell) {
			throw "not implemented";
		},

		getHeaderCell: function (absColIdx) {
			throw "not implemented";
		},

		getJoinedCols: function (columnIndex) {
			throw "not implemented";
		},

		getJoinedRows: function (rowIndex, rowScope) {
			throw "not implemented";
		},

		getJoinedTables: function (byColumn, index) {
			throw "not implemented";
		},

		subTables: function () {
			throw "not implemented";
		},

		// DOMTable abstraction **

		// ** private abstract

		_getMappedScrollMode: function () {
			var scrollMode = this._wijgrid.options.scrollMode,
				vScrollBarVisibility = "auto",
				hScrollBarVisibility = "auto";

			switch (scrollMode) {
				case "horizontal":
					vScrollBarVisibility = "hidden";
					hScrollBarVisibility = "visible";
					break;

				case "vertical":
					vScrollBarVisibility = "visible";
					hScrollBarVisibility = "hidden";
					break;

				case "both":
					vScrollBarVisibility = "visible";
					hScrollBarVisibility = "visible";
					break;
			}

			return { vScrollBarVisibility: vScrollBarVisibility, hScrollBarVisibility: hScrollBarVisibility };
		},

		_postRender: function () {
			this.ensureDisabledState();
		},

		_preRender: function () {
			throw "not implemented";
		},

		_renderContent: function () {
			throw "not implemented";
		},

		_setColumnWidth: function (index, px) {
			var th = this.getHeaderCell(index),
				cols = this.getJoinedCols(index);

			if (px) {
				$(th).setOutWidth(px);
				$.each(cols, function (idx, col) {
					$(col).setOutWidth(px);
				});
			}
		},

		_getColumnWidth: function (index, widthArray) {
			var leaf, colWidth, maxW, joinedTables, relIdx, i, table, rows, cell, cellWidth;

			if (widthArray) {
				leaf = this._wijgrid._field("visibleLeaves")[index];

				if (leaf._realWidth !== undefined) {
					colWidth = { width: leaf._realWidth, real: true };
				} else if (leaf.isRowHeader) {
					colWidth = { width: this._rowHeaderSize, real: true };
				} else {
					maxW = 0;
					joinedTables = this.getJoinedTables(true, index);
					relIdx = joinedTables[2];

					for (i = 0; i < 2; i++) {
						table = joinedTables[i];

						if (table !== null) {
							rows = table.element().rows;

							if (rows.length > 0) {
								cell = rows[rows.length - 1].cells[relIdx]; // skip header rows if possible
								cellWidth = $(cell).outerWidth();

								if (cellWidth > maxW) {
									maxW = cellWidth;
								}
							}
						}
					}

					colWidth = { width: maxW, real: false };
				}

				widthArray.push(colWidth);
			}
		},

		_setTableWidth: function (tableArray, expectedWidth, expandColumnWidth, expandIndex) {
			var after, diff;

			$.each(tableArray, function (index, table) {
				table.css("table-layout", "fixed").setOutWidth(expectedWidth);
			});

			after = tableArray[0].outerWidth();
			diff = after - expectedWidth;
			if (diff !== 0) {
				this._setColumnWidth(expandIndex, expandColumnWidth - diff);
			}
		},

		_sumWidthArray: function (widthArray, startIndex, endIndex) {
			var minWidth = 0;

			$.each(widthArray, function (index, colWidth) {
				if (startIndex !== undefined && endIndex !== undefined
					&& (index < startIndex || index > endIndex)) {
					return true;
				}
				minWidth += colWidth.width;
			});

			return minWidth;
		},

		_adjustWidthArray: function (maxWidthArray, minWidthArray, expectedWidth, ensureColumnsPxWidth, autoExpandColumnIndex) {
			var maxWidth = this._sumWidthArray(maxWidthArray),
				minWidth = this._sumWidthArray(minWidthArray),
				widthArray = [],
				adjustWidth,
				expandCount = 0,
				expandWidth, remainingWidth,
				bFirst = true;

			if (maxWidth <= expectedWidth) {
				$.extend(true, widthArray, maxWidthArray);
				if (maxWidth === expectedWidth || ensureColumnsPxWidth) {
					return widthArray;
				} else {
					adjustWidth = expectedWidth - maxWidth;
				}
			} else {
				$.extend(true, widthArray, minWidthArray);
				if (minWidth >= expectedWidth) {
					return widthArray;
				} else {
					adjustWidth = expectedWidth - minWidth;
				}
			}

			$.each(widthArray, function (index, colWidth) {
				if (!colWidth.real) {
					expandCount++;
				}
			});
			if (expandCount !== 0) {
				if (autoExpandColumnIndex !== undefined
					&& (autoExpandColumnIndex > -1 && autoExpandColumnIndex < widthArray.length)
					&& !widthArray[autoExpandColumnIndex].real) {
					widthArray[autoExpandColumnIndex].width += adjustWidth;
					return widthArray;
				}

				expandWidth = Math.floor(adjustWidth / expandCount);
				remainingWidth = adjustWidth - expandWidth * expandCount;
				$.each(widthArray, function (index, colWidth) {
					if (!colWidth.real) {
						colWidth.width += expandWidth;
						if (bFirst) {
							colWidth.width += remainingWidth;
							bFirst = false;
						}
					}
				});
			}
			return widthArray;
		}

		// private abstract **
	});
})(jQuery);(function ($) {
	"use strict";

	$.wijmo.wijgrid.flatView = $.wijmo.wijgrid.classFactory($.wijmo.wijgrid.baseView, {
		// ** public

		ctor: function (wijgrid) {
			this._base(wijgrid);
			this._dataTable = null;
			this._contentArea = null;
		},

		ensureWidth: function (index, value, oldValue) {
			var $table = $(this._dataTable.element()),
				tableWidth = $table.width() + value - oldValue;

			this._base(index, value, oldValue);

			this._setTableWidth([$table], tableWidth, value, index);
		},

		getVisibleAreaBounds: function () {
			var dataTableBounds = $.wijmo.wijgrid.bounds(this._dataTable.element()),
				splitSEBounds;

			if (this._wijgrid.options.scrollMode === "none") {
				return dataTableBounds;
			} else {
				splitSEBounds = $.wijmo.wijgrid.bounds(this._wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-se:first")[0]);

				return {
					top: dataTableBounds.top,
					left: dataTableBounds.left,
					width: Math.min(splitSEBounds.width, dataTableBounds.width),
					height: Math.min(splitSEBounds.height, dataTableBounds.height)
				};
			}
		},

		updateSplits: function (scrollValue) {
			var self = this,
				wijgrid = this._wijgrid,
				o = wijgrid.options,
				gridElement = wijgrid.element,
				maxWidthArray = [],
				minWidthArray = [],
				resultWidthArray = [],
				visibleLeaves = wijgrid._field("visibleLeaves"),
				outerDiv = wijgrid.outerDiv,
				headerWidth,
				expandIndex;

			gridElement.css({
				"table-layout": "",
				"width": ""
			});

			$.each(visibleLeaves, function (index, leaf) {
				var isPercentage,
					w = leaf.width;

				if (w || (w === 0)) {
					isPercentage = ((typeof (w) === "string") && (w.length > 1) && (w[w.length - 1] === "%"));

					//convert percent to value
					if (isPercentage) {
						w = outerDiv.width() * parseFloat(w) / 100;
					} else {
						w = parseFloat(w);
					}

					if (leaf.ensurePxWidth || (leaf.ensurePxWidth === undefined && o.ensureColumnsPxWidth)) {
						leaf._realWidth = w;
					}
					self._setColumnWidth(index, w);
				}
			});

			// read column widths.
			$.each(visibleLeaves, function (index, leaf) {
				self._getColumnWidth(index, maxWidthArray);
			});

			gridElement.css("width", "1px");

			$.each(visibleLeaves, function (index, leaf) {
				self._getColumnWidth(index, minWidthArray);
			});

			headerWidth = outerDiv.innerWidth();
			resultWidthArray = this._adjustWidthArray(maxWidthArray, minWidthArray, headerWidth, o.ensureColumnsPxWidth, o.autoExpandColumnIndex);

			$.each(resultWidthArray, function (index, colWidth) {
				var leaf = visibleLeaves[index];
				if (leaf._realWidth !== undefined) {
					delete leaf._realWidth;
					return;
				}
				self._setColumnWidth(index, colWidth.width);
			});

			expandIndex = resultWidthArray.length - 1;
			if (expandIndex !== -1) {
				this._setTableWidth([gridElement],
									this._sumWidthArray(resultWidthArray, 0, expandIndex),
									resultWidthArray[expandIndex].width,
									expandIndex);
			}
		},
		// public **

		// ** DOMTable abstraction

		focusableElement: function () {
			return $(this._dataTable.element());
		},

		forEachColumnCell: function (columnIndex, callback, param) {
			return this._dataTable.forEachColumnCell(columnIndex, callback, param);
		},

		forEachRowCell: function (rowIndex, callback, param) {
			return this._dataTable.forEachRowCell(rowIndex, callback, param);
		},

		getAbsoluteCellInfo: function (domCell) {
			return new $.wijmo.wijgrid.cellInfo(this.getColumnIndex(domCell), domCell.parentNode.rowIndex);
		},

		getAbsoluteRowIndex: function (domRow) {
			return domRow.rowIndex;
		},

		getCell: function (absColIdx, absRowIdx) {
			var cellIdx = this._dataTable.getCellIdx(absColIdx, absRowIdx),
				rowObj;

			if (cellIdx >= 0) {
				rowObj = this.getJoinedRows(absRowIdx, 0);
				if (rowObj[0]) {
					return rowObj[0].cells[cellIdx];
				}
			}

			return null;
		},

		getColumnIndex: function (domCell) {
			return this._dataTable.getColumnIdx(domCell);
		},

		getHeaderCell: function (absColIdx) {
			var leaf = this._wijgrid._field("visibleLeaves")[absColIdx],
				headerRow;

			if (leaf && (headerRow = this._wijgrid._headerRows())) {
				return new $.wijmo.wijgrid.rowAccessor().getCell(headerRow.item(leaf.thY), leaf.thX);
			}

			return null;
		},

		getJoinedCols: function (columnIndex) {
			var $colGroup = $(this._dataTable.element()).find("> colgroup");

			if ($colGroup.length) {
				if (columnIndex < $colGroup[0].childNodes.length) {
					return [$colGroup[0].childNodes[columnIndex], null];
				}
			}

			return [null, null];
		},

		getJoinedRows: function (rowIndex, rowScope) {
			return [this._dataTable.getSectionRow(rowIndex, rowScope), null];
		},

		getJoinedTables: function (byColumn, index) {
			return [this._dataTable, null, index];
		},

		subTables: function () {
			return [this._dataTable];
		},

		// DOMTable abstraction **

		// ** private abstract

		_postRender: function () {
			this._wijgrid.element
				.find("> tbody").addClass("ui-widget-content wijmo-wijgrid-data");

			this._dataTable = new $.wijmo.wijgrid.htmlTableAccessor(this._wijgrid.element[0]);

			// set width on td inner div of each column after all styles are applied to grid.
			this._wijgrid.element
				.attr({ "role": "grid", "cellpadding": "0", "border": "0", "cellspacing": "0" })
				.css("border-collapse", "separate");

			this._base();
		},

		_preRender: function () {
		},

		_renderContent: function () {
			var visibleLeaves = this._wijgrid._field("visibleLeaves"),
				table = this._wijgrid.element[0],
				tHead = null,
				columnHeadersTable, span, width, ri, height, domRow, thX, ci,
				$domCell, $container,
				i, len, leaf,
				colGroup, col,
				data, tBody, rowLen,
				dataRow, dataRowLen,
				cellLen, dataIndex, cellIndex, doBreak,
				cellValue, dataValue, rowInfo,
				cellAttr, cellStyle,
				dataRowIndex = -1,
				virtualDataItemIndexBase = 0,
				$rt = $.wijmo.wijgrid.rowType,
				$rs = $.wijmo.wijgrid.renderState,
				isDataRow;

			// colgroup
			colGroup = document.createElement("colgroup");
			for (i = 0, len = visibleLeaves.length; i < len; i++) {
				col = document.createElement("col");
				colGroup.appendChild(col);
			}
			table.appendChild(colGroup);
			// end colgroup

			// create header
			columnHeadersTable = this._wijgrid._field("columnHeadersTable");
			if (columnHeadersTable && columnHeadersTable.length) {
				tHead = table.createTHead();
				width = columnHeadersTable[0].length;

				for (ri = 0, height = columnHeadersTable.length; ri < height; ri++) {
					domRow = this._wijgrid._createRow(tHead, $rt.header, ri);

					rowInfo = this._wijgrid._createRowInfo([domRow], $rt.header, $rs.rendering, -1, -1, -1, -1);
					thX = 0;

					for (ci = 0; ci < width; ci++) {
						span = columnHeadersTable[ri][ci];

						if (span.column && span.column.parentVis) {
							span.column.thX = thX++;
							span.column.thY = ri;

							$domCell = $(this._wijgrid._createCell($rt.header, ri, span.column.dataIndex /*ci*/, span.column));

							$container = $domCell.children("div");
							domRow.appendChild($domCell[0]);
							this._wijgrid.cellFormatter.format($container, span.column, span.column.headerText, rowInfo);
							this._wijgrid._cellCreated($domCell, ci, span.column, rowInfo, $rs.rendering, { colSpan: span.colSpan, rowSpan: span.rowSpan });
						} // end if
					} // for ci

					this._wijgrid._rowCreated(rowInfo);

				} // for ri
			} // end if
			// create header end

			// create filter
			if (this._wijgrid.options.showFilter) {
				if (!tHead) {
					tHead = table.createTHead();
				}

				domRow = this._wijgrid._createRow(tHead, $rt.filter, -1);
				rowInfo = this._wijgrid._createRowInfo([domRow], $rt.filter, $rs.rendering, -1, -1, -1, -1);

				for (i = 0, len = visibleLeaves.length; i < len; i++) {
					leaf = visibleLeaves[i];
					$domCell = $(this._wijgrid._createCell($rt.filter, undefined, /*i*/ leaf.dataIndex, leaf));
					domRow.appendChild($domCell[0]);
					this._wijgrid.cellFormatter.format($domCell, leaf, $.wijmo.wijgrid.filterHelper.getSingleValue(leaf.filterValue), rowInfo);
					this._wijgrid._cellCreated($domCell, i, leaf, rowInfo, $rs.rendering);
				}

				this._wijgrid._rowCreated(rowInfo);
			}
			// create filter end

			// create body **
			data = this._wijgrid.dataTable;

			tBody = $.wijmo.wijgrid.ensureTBody(table);

			if (this._wijgrid._dataStore.dataMode() === $.wijmo.wijgrid.dataMode.dynamical) {
				virtualDataItemIndexBase = this._wijgrid.options.pageIndex * this._wijgrid.options.pageSize;
			}

			// render rows 
			for (ri = 0, rowLen = data.length; ri < rowLen; ri++) {
				dataRow = data[ri];
				dataRowLen = dataRow.length;
				isDataRow = (dataRow.rowType & $rt.data) !== 0;

				domRow = this._wijgrid._createRow(tBody, dataRow.rowType, dataRow.originalRowIndex);

				rowInfo = this._wijgrid._createRowInfo([domRow], dataRow.rowType, $rs.rendering,
					ri,
					isDataRow ? ++dataRowIndex : -1,
					isDataRow ? dataRow.originalRowIndex : -1,
					isDataRow ? virtualDataItemIndexBase + dataRow.originalRowIndex : -1);

				// render cells
				for (ci = 0, cellLen = visibleLeaves.length; ci < cellLen; ci++) {
					leaf = visibleLeaves[ci];
					dataIndex = leaf.dataIndex;

					cellIndex = 0;
					doBreak = false;

					switch (dataRow.rowType) {
						case $rt.data:
						case $rt.data | $rt.dataAlt:
							cellIndex = dataIndex; // use [leaf -> data] mapping

							if (cellIndex >= 0 && (!dataRow[cellIndex] || (dataRow[cellIndex].visible === false))) {
								continue; // spanned cell ?
							}
							break;

						case $rt.emptyDataRow:
						case $rt.groupHeader:
						case $rt.groupFooter:
							cellIndex = ci; // just iterate through all dataRow cells.

							if (cellIndex >= dataRowLen) {
								doBreak = true; // don't extend group headers\ footers with additional cells
							}
							break;
					}

					if (doBreak) {
						break;
					}

					$domCell = $(this._wijgrid._createCell(dataRow.rowType, dataRow.originalRowIndex, cellIndex, leaf));
					$container = $domCell.children("div");

					domRow.appendChild($domCell[0]);

					if ((dataRow.rowType & $rt.data) && leaf.dataParser) {
						cellValue = null;

						if (cellIndex >= 0) { // cellIndex is equal to leaf.dataIndex here
							dataValue = dataRow[cellIndex].value;
							cellValue = this._wijgrid._toStr(leaf, dataValue);
						} else { // unbound column
						}

						this._wijgrid.cellFormatter.format($container, leaf, cellValue, rowInfo);
					} else {
						if (cellIndex >= 0) {
							$container.html(dataRow[cellIndex].html); // use original html
						}
					}

					cellAttr = (cellIndex >= 0) ? dataRow[cellIndex].__attr : null;
					cellStyle = (cellIndex >= 0) ? dataRow[cellIndex].__style : null;

					this._wijgrid._cellCreated($domCell, ci, leaf, rowInfo, $rs.rendering, cellAttr, cellStyle);
				} // for ci

				if (!domRow.cells.length) {
					tBody.removeChild(domRow);
				} else {
					this._wijgrid._rowCreated(rowInfo, dataRow.__attr, dataRow.__style);
				}
			} // for ri
			// ** create body

			// footer **
			if (this._wijgrid.options.showFooter) {
				domRow = this._wijgrid._createRow(table.createTFoot(), $rt.footer, -1);
				rowInfo = this._wijgrid._createRowInfo([domRow], $rt.footer, $rs.rendering, -1, -1, -1, -1);

				for (ci = 0, cellLen = visibleLeaves.length; ci < cellLen; ci++) {
					leaf = visibleLeaves[ci];

					$domCell = $(this._wijgrid._createCell($rt.footer, undefined, leaf.dataIndex /*ci*/, leaf));

					$container = $domCell.children("div");

					domRow.appendChild($domCell[0]);

					this._wijgrid.cellFormatter.format($container, leaf, "", rowInfo);
					this._wijgrid._cellCreated($domCell, ci, leaf, rowInfo, $rs.rendering);
				}

				this._wijgrid._rowCreated(rowInfo);
			}
			// ** footer
		}

		// private abstract **

		// ** private specific

		// private specific **
	});
})(jQuery);(function ($) {
	"use strict";
	$.wijmo.wijgrid.fixedView = $.wijmo.wijgrid.classFactory($.wijmo.wijgrid.baseView, {
		// ** public

		ctor: function (wijgrid) {
			this._base(wijgrid);
			this._verScrollBarSize = 18;
			this._mouseWheelHandler = $.proxy(this._onMouseWheel, this);
			this._rowsCount = null; // total rows count
			this._viewTables = {}; // rendered DOM tables
			this._table00 = null;
			this._table01 = null;
			this._table10 = null;
			this._table11 = null;
			this._scroller = null; // scrolling div
			this.element = wijgrid.element; // table element
		},

		dispose: function () {
			this._base();
			this._wijgrid.outerDiv.unbind("mousewheel", this._mouseWheelHandler);
		},

		ensureWidth: function (index, value, oldValue) {
			var wijgrid = this._wijgrid,
				o = wijgrid.options,
				staticColumnIndex = wijgrid._getRealStaticColumnIndex(),
				bWest = index <= staticColumnIndex,
				$tableNW = $(this._table00.element()),
				$tableNE = $(this._table01.element()),
				$tableSW = $(this._table10.element()),
				$tableSE = $(this._table11.element()),
				tableArray = bWest ? [$tableNW, $tableSW] : [$tableNE, $tableSE],
				tableWidth = (bWest ? $tableNW.width() : $tableNE.width()) + value - oldValue,
				frozener = wijgrid._field("frozener"),
				scrollValue = this.getScrollValue();

			if (this._scroller.data("wijsuperpanel")) {
				this._scroller.wijsuperpanel("destroy");
			}

			this._base(index, value);

			this._setTableWidth(tableArray,
								tableWidth,
								value,
								index);

			try {
				//if (o.staticColumnIndex >= 0) { // interpreted as bool, use _getRealStaticColumnIndex() to get the actual value.
				if (staticColumnIndex >= 0) {
					o.splitDistanceX = $tableNW[0].offsetWidth;
				} else {
					o.splitDistanceX = 0;
				}
			} catch (ex) { }

			this._updateSplitAreaBounds(0);

			$tableSE.css("height", "");

			this._adjustRowHeight();

			$tableSE.height(Math.max($tableSE.height(), $tableSW.height()));

			try {
				if (wijgrid._getRealStaticRowIndex() >= 0) { // interpreted as bool, use _getRealStaticRowIndex() to get the actual value.
					o.splitDistanceY = Math.max($tableNW[0].offsetHeight, $tableNE[0].offsetHeight);
				} else {
					o.splitDistanceY = 0;
				}
			} catch (ex) { }

			this._updateSplitAreaBounds(1);

			this.refreshPanel(scrollValue);

			frozener.refresh();
		},

		ensureHeight: function (index) {
			var rowObjsArray,
				wijgrid = this._wijgrid,
				o = wijgrid.options,
				$tableNW = $(this._table00.element()),
				$tableNE = $(this._table01.element()),
				$tableSW = $(this._table10.element()),
				$tableSE = $(this._table11.element()),
				frozener = wijgrid._field("frozener"),
				scrollValue = this.getScrollValue();

			if (this._scroller.data("wijsuperpanel")) {
				this._scroller.wijsuperpanel("destroy");
			}

			if (arguments.length > 0) {
				rowObjsArray = this.getJoinedRows(index, 2);
				this._setRowHeight(rowObjsArray, this._getRowHeight(rowObjsArray));
			}

			$tableSE.css("height", "");

			$tableSE.height(Math.max($tableSE.height(), $tableSW.height()));

			try {
				if (wijgrid._getRealStaticRowIndex() >= 0) { // interpreted as bool, use _getRealStaticRowIndex() to get the actual value.
					o.splitDistanceY = Math.max($tableNW[0].offsetHeight, $tableNE[0].offsetHeight);
				} else {
					o.splitDistanceY = 0;
				}
			} catch (ex) { }

			this._updateSplitAreaBounds(1);

			this.refreshPanel(scrollValue);

			frozener.refresh();
		},

		getScrollValue: function () {
			var superPanelObj = this._getSuperPanel();

			return (superPanelObj)
				? { type: "fixed",
					hScrollValue: superPanelObj.options.hScroller.scrollValue,
					vScrollValue: superPanelObj.options.vScroller.scrollValue
				}
				: { type: "fixed",
					hScrollValue: null,
					vScrollValue: null
				};
		},

		getVisibleAreaBounds: function () {
			return $.wijmo.wijgrid.bounds(this._wijgrid.outerDiv.find(".wijmo-wijsuperpanel-contentwrapper:first"));
		},

		getFixedAreaVisibleBounds: function () {
			var bounds = this.getVisibleAreaBounds(),
				neBounds = $.wijmo.wijgrid.bounds(this._wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-ne:first")),
				nwBounds = $.wijmo.wijgrid.bounds(this._wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-nw:first")),
				horBounds = null,
				verBounds = null;

			if (neBounds.height || nwBounds.height) {
				horBounds = {
					left: bounds.left,
					top: bounds.top,
					width: bounds.width,
					height: Math.min(neBounds.height || nwBounds.height, bounds.height)
				};
			}

			if (nwBounds.width) {
				verBounds = {
					left: bounds.left,
					top: bounds.top,
					width: Math.min(nwBounds.width, bounds.width),
					height: bounds.height
				};
			}

			return [horBounds, verBounds];
		},

		refreshPanel: function (scrollValue) {
			var self = this,
				wijgrid = this._wijgrid,
				options = wijgrid.options,
				gridWidth = this._getGridWidth(options.scrollMode),
				panelModes = this._getMappedScrollMode(),
				needVBar = this._testNeedVBar(wijgrid.outerDiv, wijgrid.element, $(this._table01.element()), options.scrollMode, wijgrid._autoHeight);

			this._scroller.width(gridWidth);
			wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-ne").width(gridWidth - options.splitDistanceX - (needVBar ? this._verScrollBarSize : 0));

			if (!this._scroller.data("wijsuperpanel")) {
				this._scroller.wijsuperpanel({
					//scrolled: $.proxy(this._onScrolled, this),
					disabled: wijgrid.options.disabled,
					scroll: $.proxy(this._onScroll, this),
					bubbleScrollingEvent: true,
					vScroller: { scrollBarVisibility: panelModes.vScrollBarVisibility, scrollValue: scrollValue.type === "fixed" ? scrollValue.vScrollValue : null },
					hScroller: { scrollBarVisibility: panelModes.hScrollBarVisibility, scrollValue: scrollValue.type === "fixed" ? scrollValue.hScrollValue : null },
					//auto adjusting height with hscrollbar shown
					hScrollerActivating: function (e, data) {
						var diff, areaSW;
						if (wijgrid._autoHeight) {
							diff = wijgrid.element.height() + options.splitDistanceY - data.contentLength;
							if (diff > 0) {
								//areaSW = self._wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-sw");
								//areaSW.height(areaSW.height() + diff);
								self._scroller.height(self._scroller.height() + diff);
								self._scroller.wijsuperpanel("paintPanel");
								return false;
							}
						}
						areaSW = wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-sw");
						areaSW.height(data.contentLength - options.splitDistanceY);
					}
				});
			}
			else {
				this._scroller.wijsuperpanel("paintPanel");
			}

			this._scroller.find(".wijmo-wijsuperpanel-hbarcontainer, .wijmo-wijsuperpanel-vbarcontainer").css("zIndex", 5);

			/*
			this._wijgrid.outerDiv
			.find(".wijmo-wijgrid-split-area-ne") // area ne (01)
			.width(this._scroller.wijsuperpanel("getContentElement").parent().width());
			*/

			// synchronize scroll left of top table with bottom table
			//this._onScrolled();
		},

		scrollTo: function (currentCell) {
			var wijgrid = this._wijgrid,
				o = wijgrid.options,
				superPanelObj = this._getSuperPanel(),
				element = currentCell.tableCell(),
				$dom = element.nodeType ? $(element) : element,
				contentElement, wrapperElement,
				visibleLeft, visibleTop, visibleWidth, visibleHeight,
				elementPosition, elementLeft, elementTop, elementWidth, elementHeight,
				resultLeft = null,
				resultTop = null,
				staticRowIndex, staticColumnIndex, currentRowIndex, currentCellIndex;

			if (superPanelObj && $dom.is(":visible")) {
				contentElement = superPanelObj.getContentElement();
				wrapperElement = contentElement.parent();
				visibleLeft = parseInt((contentElement.css("left") + "").replace("px", ""), 10) * -1;
				visibleTop = parseInt((contentElement.css("top") + "").replace("px", ""), 10) * -1;
				visibleWidth = wrapperElement.outerWidth() - o.splitDistanceX;
				visibleHeight = wrapperElement.outerHeight() - o.splitDistanceY;
				elementPosition = $dom.position();
				elementLeft = elementPosition.left;
				elementTop = elementPosition.top;
				elementWidth = $dom.outerWidth();
				elementHeight = $dom.outerHeight();
				staticRowIndex = wijgrid._getStaticIndex(true);
				staticColumnIndex = wijgrid._getStaticIndex(false);
				currentRowIndex = currentCell.rowIndex();
				currentCellIndex = currentCell.cellIndex();

				if (currentRowIndex <= staticRowIndex) {
					if (currentCellIndex <= staticColumnIndex) {
						resultLeft = 0;
						resultTop = 0;
					} else {
						elementLeft += visibleLeft;
						if (elementLeft + elementWidth > visibleLeft + visibleWidth) {
							visibleLeft = resultLeft = elementLeft + elementWidth - visibleWidth;
						}
						if (elementLeft < visibleLeft) {
							resultLeft = elementLeft;
						}
						resultTop = 0;
					}
				} else {
					if (currentCellIndex <= staticColumnIndex) {
						elementTop += visibleTop;
						if (elementTop + elementHeight > visibleTop + visibleHeight) {
							visibleTop = resultTop = elementTop + elementHeight - visibleHeight;
						}
						if (elementTop < visibleTop) {
							resultTop = elementTop;
						}
						resultLeft = 0;
					} else {
						elementLeft -= o.splitDistanceX;
						if (elementTop + elementHeight > visibleTop + visibleHeight) {
							visibleTop = resultTop = elementTop + elementHeight - visibleHeight;
						}

						if (elementLeft + elementWidth > visibleLeft + visibleWidth) {
							visibleLeft = resultLeft = elementLeft + elementWidth - visibleWidth;
						}

						if (elementTop < visibleTop) {
							resultTop = elementTop;
						}

						if (elementLeft < visibleLeft) {
							resultLeft = elementLeft;
						}
					}
				}

				if (resultLeft !== null) {
					superPanelObj.hScrollTo(resultLeft);
				}

				if (resultTop !== null) {
					superPanelObj.vScrollTo(resultTop);
				}
			}
		},

		updateSplits: function (scrollValue) {
			var wijgrid = this._wijgrid,
				o = wijgrid.options,
				rowObj, fooRow,
				headerWidth,
				self = this,
				resultWidthArray = [],
				minWidthArray = [],
				maxWidthArray = [], // set width to top table th and bottom table td in first row.
				staticColumnIndex = wijgrid._getRealStaticColumnIndex(),
				expandIndex,
				mode = o.scrollMode,
				visibleLeaves = wijgrid._field("visibleLeaves"),
				$tableSE = $(this._table11.element()),
				$tableNE = $(this._table01.element()),
				$tableSW = $(this._table10.element()),
				$tableNW = $(this._table00.element()),
				outerDiv = wijgrid.outerDiv;

			if (this._scroller.data("wijsuperpanel")) {
				this._scroller.wijsuperpanel("destroy");
			}
			outerDiv.unbind("mousewheel", this._mouseWheelHandler);

			// clone a row to expand table in grouping mode.
			rowObj = $tableSE.find("tbody .wijmo-wijgrid-row:not(.wijmo-wijgrid-groupheaderrow):first");

			this.fooRow = fooRow = rowObj
				.clone()
			//.removeClass() // remove all classes
				.removeAttr("datarowindex")
				.addClass("wijmo-wijgrid-foorow")
				.appendTo(rowObj.parent()).show().height(0).css({ "font-size": "0" });

			// fooRowCells belong to the bottom table
			this.fooRowCells = fooRow
				.find(">td")
			//.removeClass() // remove all classes
				.height(0)
				.css({ "border-top": "0", "border-bottom": "0" })
				.find(">div.wijmo-wijgrid-innercell")
			//force the height of fooRow to 0
				.css({ "padding-top": "0px", "padding-bottom": "0px" })
					.empty();

			// hide foo row because it has a 1px height in IE6&7
			fooRow.css("visibility", "hidden"); // use "visibility:hidden" instead of "display:none"

			//if there is no data in table, we must enlarge the table to prevent the width from being 0
			if (fooRow.length === 0) {
				wijgrid.element.css("width", "100%");
			}

			$.each([$tableSE, $tableNE, $tableSW, $tableNW], function (index, table) {
				table.css({
					"table-layout": "",
					"width": ""
				});
			});

			// if any column has width option, we will set the width for inner cells.
			$.each(visibleLeaves, function (index, leaf) {
				var isPercentage,
					w = leaf.width;

				if (w || (w === 0)) {
					isPercentage = ((typeof (w) === "string") && (w.length > 1) && (w[w.length - 1] === "%"));

					//convert percent to value
					if (isPercentage) {
						w = outerDiv.width() * parseFloat(w) / 100;
					} else {
						w = parseFloat(w);
					}

					if (leaf.ensurePxWidth || (leaf.ensurePxWidth === undefined && o.ensureColumnsPxWidth)) {
						leaf._realWidth = w;
					}
					self._setColumnWidth(index, w);
				}
			});

			$.each(visibleLeaves, function (index, leaf) {
				self._getColumnWidth(index, maxWidthArray);
			});

			$.each([$tableNW, $tableNE, $tableSW, $tableSE], function (index, table) {
				table.css({
					"width": "1px"
				});
			});

			$.each(visibleLeaves, function (index, leaf) {
				self._getColumnWidth(index, minWidthArray);
			});

			headerWidth = outerDiv.innerWidth();
			resultWidthArray = this._adjustWidthArray(maxWidthArray, minWidthArray, headerWidth, o.ensureColumnsPxWidth, o.autoExpandColumnIndex);

			$.each(resultWidthArray, function (index, colWidth) {
				var leaf = visibleLeaves[index];
				if (leaf._realWidth !== undefined) {
					delete leaf._realWidth;
					return;
				}
				self._setColumnWidth(index, colWidth.width);
			});

			//if (o.staticColumnIndex >= 0) {
			if (staticColumnIndex >= 0) {
				expandIndex = staticColumnIndex;
				this._setTableWidth([$tableNW, $tableSW],
									this._sumWidthArray(resultWidthArray, 0, expandIndex),
									resultWidthArray[expandIndex].width,
									expandIndex);
			}

			//set the size of area after setting the width of column
			try {
				//if (o.staticColumnIndex >= 0) { // interpreted as bool, use _getRealStaticColumnIndex() to get the actual value.
				if (staticColumnIndex >= 0) {
					o.splitDistanceX = $tableNW[0].offsetWidth;
				} else {
					o.splitDistanceX = 0;
				}
			} catch (ex) { }

			this._updateSplitAreaBounds(0); //width

			if (!o.ensureColumnsPxWidth) {
				$tableNE.parent().width(headerWidth - o.splitDistanceX);
			}

			expandIndex = resultWidthArray.length - 1;
			if (expandIndex !== -1) {
				this._setTableWidth([$tableNE, $tableSE],
									this._sumWidthArray(resultWidthArray, staticColumnIndex + 1, expandIndex),
									resultWidthArray[expandIndex].width,
									expandIndex);
			}

			$tableSE.css("height", "");

			this._adjustRowHeight();

			$tableSE.height(Math.max($tableSE.height(), $tableSW.height()));

			//set the size of area after setting the width of column
			try {
				//if (o.staticRowIndex >= 0) { // interpreted as bool, use _getRealStaticRowIndex() to get the actual value.
				if (wijgrid._getRealStaticRowIndex() >= 0) { // interpreted as bool, use _getRealStaticRowIndex() to get the actual value.
					o.splitDistanceY = Math.max($tableNW[0].offsetHeight, $tableNE[0].offsetHeight);
				} else {
					o.splitDistanceY = 0;
				}
			} catch (ex) { }

			this._updateSplitAreaBounds(1); //height

			//adjust width if showing vertical scrollbar
			if (!o.ensureColumnsPxWidth) {
				if (this._testNeedVBar(wijgrid.outerDiv, $tableSE, $tableNE, mode, wijgrid._autoHeight)) {
					headerWidth -= this._verScrollBarSize;
					resultWidthArray = this._adjustWidthArray(maxWidthArray, minWidthArray, headerWidth, o.ensureColumnsPxWidth, o.autoExpandColumnIndex);

					$.each(resultWidthArray, function (index, colWidth) {
						if (!colWidth.real) {
							self._setColumnWidth(index, colWidth.width);
						}
					});

					//if (o.staticColumnIndex >= 0) {
					if (staticColumnIndex >= 0) {
						expandIndex = staticColumnIndex;
						this._setTableWidth([$tableNW, $tableSW],
											this._sumWidthArray(resultWidthArray, 0, expandIndex),
											resultWidthArray[expandIndex].width,
											expandIndex);
					}

					//set the size of area after setting the width of column
					try {
						//if (o.staticColumnIndex >= 0) { // interpreted as bool, use _getRealStaticColumnIndex() to get the actual value.
						if (staticColumnIndex >= 0) {
							o.splitDistanceX = $tableNW[0].offsetWidth;
						} else {
							o.splitDistanceX = 0;
						}
					} catch (ex) { }

					this._updateSplitAreaBounds(0); //width

					$tableNE.parent().width(headerWidth - o.splitDistanceX);

					expandIndex = resultWidthArray.length - 1;
					if (expandIndex !== -1) {
						this._setTableWidth([$tableNE, $tableSE],
											this._sumWidthArray(resultWidthArray, staticColumnIndex + 1, expandIndex),
											resultWidthArray[expandIndex].width,
											expandIndex);
					}

					$tableSE.css("height", "");

					this._adjustRowHeight();

					$tableSE.height(Math.max($tableSE.height(), $tableSW.height()));

					//set the size of area after setting the width of column
					try {
						//if (o.staticRowIndex >= 0) { // interpreted as bool, use _getRealStaticRowIndex() to get the actual value.
						if (wijgrid._getRealStaticRowIndex() >= 0) { // interpreted as bool, use _getRealStaticRowIndex() to get the actual value.
							o.splitDistanceY = Math.max($tableNW[0].offsetHeight, $tableNE[0].offsetHeight);
						} else {
							o.splitDistanceY = 0;
						}
					} catch (ex) { }

					this._updateSplitAreaBounds(1); //height
				}
			}

			this.refreshPanel(scrollValue); // refresh super panel after width is set.

			outerDiv.bind("mousewheel", this._mouseWheelHandler);
		},
		// public **

		// ** DOMTable abstraction

		focusableElement: function () {
			//return this._table11.element();
			return this._wijgrid.outerDiv;
		},

		forEachColumnCell: function (columnIndex, callback, param) {
			var joinedTables = this.getJoinedTables(true, columnIndex),
				relIdx, callbackRes;

			if (joinedTables[0] !== null) {
				relIdx = joinedTables[2];
				callbackRes = joinedTables[0].forEachColumnCell(relIdx, callback, param);
				if (callbackRes !== true) {
					return callbackRes;
				}

				if (joinedTables[1] !== null) {
					callbackRes = joinedTables[1].forEachColumnCell(relIdx, callback, param);
					if (callbackRes !== true) {
						return callbackRes;
					}
				}
			}

			return true;
		},

		forEachRowCell: function (rowIndex, callback, param) {
			var joinedTables = this.getJoinedTables(false, rowIndex),
				table0 = joinedTables[0],
				table1 = joinedTables[1],
				relIdx, callbackResult;

			if (table0 !== null) {
				relIdx = joinedTables[2];
				if (relIdx < table0.element().rows.length) {
					callbackResult = table0.forEachRowCell(relIdx, callback, param);
					if (callbackResult !== true) {
						return callbackResult;
					}
				}

				if ((table1 !== null) && (relIdx < table1.element().rows.length)) {
					callbackResult = table1.forEachRowCell(relIdx, callback, param);
					if (callbackResult !== true) {
						return callbackResult;
					}
				}
			}

			return true;
		},

		getAbsoluteCellInfo: function (domCell) {
			return new $.wijmo.wijgrid.cellInfo(this.getColumnIndex(domCell), this.getAbsoluteRowIndex(domCell.parentNode));
		},

		getAbsoluteRowIndex: function (domRow) {
			var index = domRow.rowIndex,
				table = domRow.parentNode;

			while (table.tagName.toLowerCase() !== "table") {
				table = table.parentNode;
			}

			return (table === this._table00.element() || table === this._table01.element()) ? index : index + this._wijgrid._getRealStaticRowIndex() + 1;
		},

		getCell: function (absColIdx, absRowIdx) {
			var joinedTablesRow = this.getJoinedTables(false, absRowIdx),
				joinedTablesCol, relRowIdx, relColIdx, table, cellIdx;

			if (joinedTablesRow[0] !== null) {
				joinedTablesCol = this.getJoinedTables(true, absColIdx);
				if (joinedTablesCol[0] !== null) {
					relRowIdx = joinedTablesRow[2];
					relColIdx = joinedTablesCol[2];

					table = null;
					if (joinedTablesRow[1] !== null) {
						table = (absColIdx === relColIdx) ? joinedTablesRow[0] : joinedTablesRow[1];
					}
					else {
						table = joinedTablesRow[0];
					}

					cellIdx = table.getCellIdx(relColIdx, relRowIdx);
					if (cellIdx >= 0) {
						return table.element().rows[relRowIdx].cells[cellIdx];
					}
				}
			}

			return null;
		},

		getColumnIndex: function (domCell) {
			var owner = null,
				htmlTable = null,
				flag = false,
				colIdx;

			for (owner = domCell.parentNode; owner.tagName.toLowerCase() !== "table"; owner = owner.parentNode) {
			}

			if (owner !== null) {
				if (owner === this._table00.element()) {
					htmlTable = this._table00;
				}
				else {
					if (owner === this._table01.element()) {
						htmlTable = this._table01;
						flag = true;
					}
					else {
						if (owner === this._table10.element()) {
							htmlTable = this._table10;
						}
						else {
							if (owner === this._table11.element()) {
								htmlTable = this._table11;
								flag = true;
							}
						}
					}
				}

				if (htmlTable !== null) {
					colIdx = htmlTable.getColumnIdx(domCell);
					if (flag) {
						colIdx += this._wijgrid._getRealStaticColumnIndex() + 1;
					}
					return colIdx;
				}
			}

			return -1;
		},

		getHeaderCell: function (absColIdx) {
			var leaf = this._wijgrid._field("visibleLeaves")[absColIdx],
				headerRow;

			if (leaf && (headerRow = this._wijgrid._headerRows())) {
				return new $.wijmo.wijgrid.rowAccessor().getCell(headerRow.item(leaf.thY), leaf.thX);
			}

			return null;
		},

		getJoinedCols: function (columnIndex) {
			var result = [],
				joinedTables = this.getJoinedTables(true, columnIndex),
				relIndex = joinedTables[2];

			joinedTables.splice(joinedTables.length - 1, 1);
			$.each(joinedTables, function (index, table) {
				result.push(table
					? $(table.element()).find("col")[relIndex]
					: null);
			});

			return result;
		},

		getJoinedRows: function (rowIndex, rowScope) {
			var row0 = null, row1 = null,
				table0 = null, table1 = null,
				fixedRowIdx = this._wijgrid._getRealStaticRowIndex(),
				fixedColIdx = this._wijgrid._getRealStaticColumnIndex(),
				lastColIdx = this._wijgrid._field("visibleLeaves").length - 1,
				lastRowIdx = this._rowsCount - 1,
				allRowsFixed = (fixedRowIdx === lastRowIdx),
				allsRowUnfixed = (fixedRowIdx < 0),
				rowsFixedSlice = !allRowsFixed && !allsRowUnfixed,
				sectionLength = 0;

			if (allRowsFixed || rowsFixedSlice) {
				if (fixedColIdx >= 0 && fixedColIdx < lastColIdx) {
					table0 = this._table00;
					table1 = this._table01;
				}
				else {
					table0 = (fixedColIdx < 0) ? this._table01 : this._table00;
				}
				sectionLength = table0.getSectionLength(rowScope);
				if (rowIndex < sectionLength) {
					row0 = table0.getSectionRow(rowIndex, rowScope);
					if (table1 !== null) {
						row1 = table1.getSectionRow(rowIndex, rowScope);
					}
				}
			}

			if (allsRowUnfixed || (rowsFixedSlice && (row0 === null))) {
				if (!allsRowUnfixed) {
					rowIndex -= sectionLength;
				}

				if (fixedColIdx >= 0 && fixedColIdx < lastColIdx) {
					table0 = this._table10;
					table1 = this._table11;
				}
				else {
					table0 = (fixedColIdx < 0) ? this._table11 : this._table10;
				}

				row0 = table0.getSectionRow(rowIndex, rowScope);

				if (table1 !== null) {
					row1 = table1.getSectionRow(rowIndex, rowScope);
				}
			}

			return (row0 === null && row1 === null) ? null : [row0, row1];
		},

		getJoinedTables: function (byColumn, index) {
			var t0 = null,
				t1 = null,
				idx = index,
				wijgrid = this._wijgrid,
				fixedRowIdx = wijgrid._getRealStaticRowIndex(),
				fixedColIdx = wijgrid._getRealStaticColumnIndex();

			if (byColumn) {
				if (index <= fixedColIdx) {
					t0 = this._table00;
					t1 = this._table10;
				}
				else {
					t0 = this._table01;
					t1 = this._table11;

					idx = idx - (fixedColIdx + 1);
				}

				if (fixedRowIdx < 0) {
					t0 = null;
				}

				if (fixedRowIdx === this._rowsCount - 1) // fixed row is the last row
				{
					t1 = null;
				}
			}
			else {
				if (index <= fixedRowIdx) {
					t0 = this._table00;
					t1 = this._table01;
				}
				else {
					t0 = this._table10;
					t1 = this._table11;

					idx = idx - (fixedRowIdx + 1);
				}

				if (fixedColIdx < 0) {
					t0 = null;
				}
				if (fixedColIdx === wijgrid._field("leaves").length - 1) {
					t1 = null;
				}
			}

			if (t0 === null) {
				t0 = t1;
				t1 = null;
			}
			return [t0, t1, idx];
		},

		subTables: function () {
			return [this._table00, this._table01, this._table10, this._table11];
		},

		// DOMTable abstraction **

		// ** private abstract

		_getGridWidth: function (mode) {
			var wijgrid = this._wijgrid,
				tableWidth = wijgrid.element.outerWidth(true) + wijgrid.options.splitDistanceX,
				outWidth = wijgrid.outerDiv.innerWidth();

			if (this._testNeedVBar(wijgrid.outerDiv, wijgrid.element, $(this._table01.element()), mode, wijgrid._autoHeight)) {
				tableWidth += this._verScrollBarSize;
			}

			if (tableWidth > outWidth) {
				tableWidth = outWidth;
			}

			return tableWidth;
		},

		_getSuperPanel: function () {
			return this._scroller
				? this._scroller.data("wijsuperpanel")
				: null;
		},

		_postRender: function () {
			var key;

			for (key in this._viewTables) {
				if (this._viewTables.hasOwnProperty(key)) {
					$(this._viewTables[key])
						.addClass("wijmo-wijgrid-table")
						.attr("role", "grid")
						.find("> tbody")
							.addClass("ui-widget-content wijmo-wijgrid-data");
				}
			}

			this._table00 = new $.wijmo.wijgrid.htmlTableAccessor(this._viewTables.nw);
			this._table01 = new $.wijmo.wijgrid.htmlTableAccessor(this._viewTables.ne);
			this._table10 = new $.wijmo.wijgrid.htmlTableAccessor(this._viewTables.sw);
			this._table11 = new $.wijmo.wijgrid.htmlTableAccessor(this._viewTables.se);

			this._rowsCount = Math.max(this._viewTables.nw.rows.length, this._viewTables.ne.rows.length) +
				Math.max(this._viewTables.sw.rows.length, this._viewTables.se.rows.length);

			// use separate instead of collapse to avoid a disalignment issue in chrome.
			$.each([this._viewTables.nw, this._viewTables.sw, this._viewTables.ne, this._viewTables.se], function (index, element) {
				$(element)
					.attr({ "cellpadding": "0", "border": "0", "cellspacing": "0" })
					.css("border-collapse", "separate");
			});

			this._base();
		},

		_preRender: function () {
			this._wijgrid.outerDiv.wrapInner("<div class=\"wijmo-wijgrid-fixedview\"><div class=\"wijmo-wijgrid-scroller\"><div class=\"wijmo-wijgrid-split-area-se wijmo-wijgrid-content-area\"></div></div></div>");
			this._scroller = this._wijgrid.outerDiv.find(".wijmo-wijgrid-scroller");

			this._scroller.after("<div class=\"wijmo-wijgrid-split-area wijmo-wijgrid-split-area-nw\" style=\"overflow:hidden;position:absolute;z-index:4;top:0px;left:0px;\"></div>");
			this._scroller.after("<div class=\"wijmo-wijgrid-split-area wijmo-wijgrid-split-area-ne\" style=\"overflow:hidden;position:absolute;z-index:4;top:0px;left:0px;\"></div>");
			this._scroller.after("<div class=\"wijmo-wijgrid-split-area wijmo-wijgrid-split-area-sw\" style=\"overflow:hidden;position:absolute;z-index:4;top:0px;left:0px;\"></div>");
		},

		_renderContent: function () {
			var wijgrid = this._wijgrid,
				visibleLeaves = wijgrid._field("visibleLeaves"),
				docFragment = document.createDocumentFragment(),
				columnHeadersTable = wijgrid._field("columnHeadersTable"),
				staticDataRowIndex = wijgrid._getStaticIndex(true),
				staticColumnIndex = wijgrid._getRealStaticColumnIndex(),
				staticAllColumnIndex = staticColumnIndex === -1 ? -1 : visibleLeaves[staticColumnIndex].leavesIdx,
				tHeads = {},
				width, ri, height,
				dataRow, dataRowLen,
				leftDomRow, rightDomRow,
				thX, ci, span, $domCell,
				i, len, leaf,
				correspondTables, key, colGroup, col, table,
				data,
				tBodies = {},
				rowLen, cellLen, dataIndex, cellIndex, doBreak, $container, cellValue, dataValue,
				nwArea, neArea, swArea, seArea,
				cellAttr, cellStyle, rowInfo,
				dataRowIndex = -1,
				virtualDataItemIndexBase = 0,
				$rt = $.wijmo.wijgrid.rowType,
				$rs = $.wijmo.wijgrid.renderState,
				isDataRow;

			this._viewTables = {
				nw: docFragment.appendChild(document.createElement("table")),
				ne: docFragment.appendChild(document.createElement("table")),
				sw: docFragment.appendChild(document.createElement("table")),
				se: docFragment.appendChild(wijgrid.element[0])
			};

			// colgroup

			// nw - sw
			correspondTables = { t0: this._viewTables.nw, t1: this._viewTables.sw };
			for (key in correspondTables) {
				if (correspondTables.hasOwnProperty(key)) {
					colGroup = document.createElement("colgroup");
					for (i = 0; i <= staticColumnIndex; i++) {
						col = document.createElement("col");
						colGroup.appendChild(col);
					}
					table = correspondTables[key];
					table.appendChild(colGroup);
				}
			}

			// ne - se
			correspondTables = { t0: this._viewTables.ne, t1: this._viewTables.se };
			for (key in correspondTables) {
				if (correspondTables.hasOwnProperty(key)) {
					colGroup = document.createElement("colgroup");
					for (i = staticColumnIndex + 1; i < visibleLeaves.length; i++) {
						col = document.createElement("col");
						colGroup.appendChild(col);
					}
					table = correspondTables[key];
					table.appendChild(colGroup);
				}
			}
			// end colgroup

			// create header
			if (columnHeadersTable && columnHeadersTable.length) {
				tHeads.nw = this._viewTables.nw.createTHead();
				tHeads.ne = this._viewTables.ne.createTHead();
				/*tHeads.sw = this._viewTables.sw.createTHead(); // <-- user can fix the whole header only, not a random row.
				tHeads.sw = this._viewTables.se.createTHead();*/

				width = columnHeadersTable[0].length;

				for (ri = 0, height = columnHeadersTable.length; ri < height; ri++) {
					leftDomRow = null;
					rightDomRow = null;

					//if (ri <= staticRowIndex) {
					// now header rows are always fixed by design, so we can create header cells inside the fixed areas (nw + ne) only.
					//leftDomRow = tHeads.nw.insertRow(-1);
					//rightDomRow = tHeads.ne.insertRow(-1);
					leftDomRow = wijgrid._createRow(tHeads.nw, $rt.header, ri);
					rightDomRow = wijgrid._createRow(tHeads.ne, $rt.header, ri);
					/*} else {
					leftDomRow = this._viewTables["sw"].tHead.insertRow(-1);
					rightDomRow = this._viewTables["se"].tHead.insertRow(-1);
					}*/

					rowInfo = wijgrid._createRowInfo([leftDomRow, rightDomRow], $rt.header, $rs.rendering, -1, -1, -1, -1);

					thX = 0;

					for (ci = 0; ci < width; ci++) {
						span = columnHeadersTable[ri][ci];

						if (span.column && span.column.parentVis) {
							span.column.thX = thX++;
							span.column.thY = ri;

							$domCell = $(wijgrid._createCell($rt.header, ri, span.column.dataIndex /*ci*/, span.column));

							$container = $domCell.children("div");

							if (ci <= staticAllColumnIndex) {
								leftDomRow.appendChild($domCell[0]);
							} else {
								rightDomRow.appendChild($domCell[0]);
							}

							wijgrid.cellFormatter.format($container, span.column, span.column.headerText, rowInfo);
							wijgrid._cellCreated($domCell, ci, span.column, rowInfo, $rs.rendering, { colSpan: span.colSpan, rowSpan: span.rowSpan });
						} // end if
					} // for ci

					wijgrid._rowCreated(rowInfo);
				} // for ri

			} // end if
			// create header end

			// create filter -- now only the whole header can be fixed by design, so the tHeads can contain only "nw" or (and) "ne" keys.
			if (wijgrid.options.showFilter) {
				if (!tHeads.nw) {
					tHeads.nw = this._viewTables.nw.createTHead();
				}

				if (!tHeads.ne) {
					tHeads.ne = this._viewTables.ne.createTHead();
				}

				if (tHeads.nw) { // fixed columns area
					leftDomRow = wijgrid._createRow(tHeads.nw, $rt.filter, -1);
				}

				if (tHeads.ne) { // unfixed columns area
					rightDomRow = wijgrid._createRow(tHeads.ne, $rt.filter, -1);
				}

				rowInfo = wijgrid._createRowInfo([leftDomRow, rightDomRow], $rt.filter, $rs.rendering, -1, -1, -1, -1);

				for (i = 0, len = visibleLeaves.length; i < len; i++) {
					leaf = visibleLeaves[i];

					$domCell = $(wijgrid._createCell($rt.filter, undefined, /*i*/ leaf.dataIndex, leaf));

					if (i <= staticColumnIndex) {
						leftDomRow.appendChild($domCell[0]);
					} else {
						rightDomRow.appendChild($domCell[0]);
					}

					wijgrid.cellFormatter.format($domCell, leaf, $.wijmo.wijgrid.filterHelper.getSingleValue(leaf.filterValue), rowInfo);
					wijgrid._cellCreated($domCell, i, leaf, rowInfo, $rs.rendering);
				}

				wijgrid._rowCreated(rowInfo);
			}
			// create filter end

			// create body **
			data = wijgrid.dataTable;

			tBodies = {
				nw: $.wijmo.wijgrid.ensureTBody(this._viewTables.nw),
				ne: $.wijmo.wijgrid.ensureTBody(this._viewTables.ne),
				sw: $.wijmo.wijgrid.ensureTBody(this._viewTables.sw),
				se: $.wijmo.wijgrid.ensureTBody(this._viewTables.se)
			};

			//staticDataRowIndex = staticRowIndex - (columnHeadersTable.length + (wijgrid.options.showFilter ? 1 : 0));

			if (wijgrid._dataStore.dataMode() === $.wijmo.wijgrid.dataMode.dynamical) {
				virtualDataItemIndexBase = wijgrid.options.pageIndex * wijgrid.options.pageSize;
			}

			// render rows
			for (ri = 0, rowLen = data.length; ri < rowLen; ri++) {
				dataRow = data[ri];
				dataRowLen = dataRow.length;
				isDataRow = (dataRow.rowType & $rt.data) !== 0;

				leftDomRow = null;
				rightDomRow = null;

				if (ri <= staticDataRowIndex) {
					leftDomRow = wijgrid._createRow(tBodies.nw, dataRow.rowType, dataRow.originalRowIndex);
					rightDomRow = wijgrid._createRow(tBodies.ne, dataRow.rowType, dataRow.originalRowIndex);
				} else {
					leftDomRow = wijgrid._createRow(tBodies.sw, dataRow.rowType, dataRow.originalRowIndex);
					rightDomRow = wijgrid._createRow(tBodies.se, dataRow.rowType, dataRow.originalRowIndex);
				}

				rowInfo = wijgrid._createRowInfo([leftDomRow, rightDomRow], dataRow.rowType, $rs.rendering,
						ri,
						isDataRow ? ++dataRowIndex : -1,
						isDataRow ? dataRow.originalRowIndex : -1,
						isDataRow ? virtualDataItemIndexBase + dataRow.originalRowIndex : -1);

				// render cells
				for (ci = 0, cellLen = visibleLeaves.length; ci < cellLen; ci++) {
					leaf = visibleLeaves[ci];
					dataIndex = leaf.dataIndex;

					cellIndex = 0;
					doBreak = false;

					switch (dataRow.rowType) {
						case $rt.data:
						case $rt.data | $rt.dataAlt:
							cellIndex = dataIndex; // use [leaf -> data] mapping

							if (cellIndex >= 0 && (!dataRow[cellIndex] || (dataRow[cellIndex].visible === false))) {
								continue; // spanned cell ?
							}
							break;

						case $rt.emptyDataRow:
						case $rt.groupHeader:
						case $rt.groupFooter:
							cellIndex = ci; // just iterate through all dataRow cells.

							if (cellIndex >= dataRowLen) {
								doBreak = true; // don't extend group headers\ footers with additional cells
							}
							break;
					}

					if (doBreak) {
						break;
					}

					$domCell = $(wijgrid._createCell(dataRow.rowType, dataRow.originalRowIndex, cellIndex, leaf));

					$container = $domCell.children("div");

					if (ci <= staticColumnIndex) {
						leftDomRow.appendChild($domCell[0]);
					} else {
						rightDomRow.appendChild($domCell[0]);
					}

					if ((dataRow.rowType & $rt.data) && leaf.dataParser) {
						cellValue = null;

						if (cellIndex >= 0) { // cellIndex is equal to leaf.dataIndex here
							dataValue = dataRow[cellIndex].value;
							cellValue = wijgrid._toStr(leaf, dataValue);

						} else { // unbound column
						}

						wijgrid.cellFormatter.format($container, leaf, cellValue, rowInfo);
					} else {
						if (cellIndex >= 0) {
							$container.html(dataRow[cellIndex].html); // use original html
						}
					}

					cellAttr = (cellIndex >= 0) ? dataRow[cellIndex].__attr : null;
					cellStyle = (cellIndex >= 0) ? dataRow[cellIndex].__style : null;

					wijgrid._cellCreated($domCell, ci, leaf, rowInfo, $rs.rendering, cellAttr, cellStyle);
				} // for ci

				if (ri <= staticDataRowIndex) {
					if (!leftDomRow.cells.length) {
						tBodies.nw.removeChild(leftDomRow);
						leftDomRow = null;
					}

					if (!rightDomRow.cells.length) {
						tBodies.ne.removeChild(rightDomRow);
						rightDomRow = null;
					}

					if (leftDomRow || rightDomRow) {
						wijgrid._rowCreated(rowInfo, dataRow.__attr, dataRow.__style);
					}
				} else {
					if (!leftDomRow.cells.length) {
						tBodies.sw.removeChild(leftDomRow);
						leftDomRow = null;
					}

					if (!rightDomRow.cells.length) {
						tBodies.se.removeChild(rightDomRow);
						rightDomRow = null;
					}

					if (leftDomRow || rightDomRow) {
						wijgrid._rowCreated(rowInfo, dataRow.__attr, dataRow.__style);
					}
				}
			} // for ri
			// ** create body

			// create footer **
			if (wijgrid.options.showFooter) {
				leftDomRow = wijgrid._createRow(this._viewTables.sw.createTFoot(), $rt.footer, -1);
				rightDomRow = wijgrid._createRow(this._viewTables.se.createTFoot(), $rt.footer, -1);

				rowInfo = wijgrid._createRowInfo([leftDomRow, rightDomRow], $rt.footer, $rs.rendering, -1, -1, -1, -1);

				for (ci = 0, cellLen = visibleLeaves.length; ci < cellLen; ci++) {
					leaf = visibleLeaves[ci];

					$domCell = $(wijgrid._createCell($rt.footer, undefined, leaf.dataIndex /*ci*/, leaf));

					$container = $domCell.children("div");

					if (ci <= staticColumnIndex) {
						leftDomRow.appendChild($domCell[0]);
					} else {
						rightDomRow.appendChild($domCell[0]);
					}

					wijgrid.cellFormatter.format($container, leaf, "", rowInfo);
					wijgrid._cellCreated($domCell, ci, leaf, rowInfo, $rs.rendering);
				}

				wijgrid._rowCreated(rowInfo);
			}
			// ** create footer

			nwArea = wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-nw");
			neArea = wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-ne");
			swArea = wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-sw");
			seArea = wijgrid.outerDiv.find(".wijmo-wijgrid-content-area");

			nwArea[0].innerHTML = "";
			neArea[0].innerHTML = "";
			swArea[0].innerHTML = "";
			seArea[0].innerHTML = "";

			/* Note, empty() throws exception */
			$(this._viewTables.nw).appendTo(nwArea);
			$(this._viewTables.ne).appendTo(neArea);
			$(this._viewTables.sw).appendTo(swArea);
			$(this._viewTables.se).appendTo(seArea);
		},

		_getRowHeight: function (rowObj) {
			if (rowObj[0] && rowObj[1]) {
				var $rowObj = [$(rowObj[0]), $(rowObj[1])],
					row0h, row1h;

				$.each($rowObj, function (index, $el) {
					$el.css("height", "");
				});

				row0h = $rowObj[0].height();
				row1h = $rowObj[1].height();

				if (row0h > row1h) {
					return row0h;
				} else if (row0h < row1h) {
					return row1h;
				}
			}
			return null;
		},

		_setRowHeight: function (rowObj, maxHeight) {
			if (rowObj[0] && rowObj[1]) {
				var $rowObj = [$(rowObj[0]), $(rowObj[1])], dif;

				if (maxHeight === null) {
					return;
				}

				maxHeight += 1;
				$.each($rowObj, function (index, $el) {
					$el.height(maxHeight);
					dif = maxHeight - $el.height();
					if (dif) {
						$el.height(maxHeight + dif);
					}
				});
			}
		},

		_adjustRowHeight: function () {
			/// <summary>
			/// Set row height.
			/// </summary>
			/// <param name="index" type="Number">
			/// The index of the column. Start with 0.
			/// </param>

			/*
			var heightArray = [];
			for (i = 0; i < rowLen; i++) {
			heightArray.push(this._getRowHeight(this.getJoinedRows(i, 9)));
			}

			for (i = 0; i < 4; i++) {
			tableParentArray[i].removeChild(tableArray[i]);
			}

			for (i = 0; i < rowLen; i++) {
			this._setRowHeight(this.getJoinedRows(i, 9), heightArray[i]);
			}

			for (i = 0; i < 4; i++) {
			tableParentArray[i].appendChild(tableArray[i]);
			}
			*/

			var wijgrid = this._wijgrid,
				fixedColIdx = wijgrid._getRealStaticColumnIndex(),
				lastColIdx = wijgrid._field("visibleLeaves").length - 1,
				fixedRowIdx, lastRowIdx,
				tables, tableNE, tableNEParent, tableNW, tableNWParent,
				tableSE, tableSEParent, tableSW, tableSWParent,
				rowCount, i, j, leftRows, rightRows;

			// setting row height only if grid is divided into leftern and rightern parts
			if (fixedColIdx > -1 && fixedColIdx < lastColIdx) {
				var heightArray = [];
				fixedRowIdx = wijgrid._getRealStaticRowIndex();
				lastRowIdx = this._rowsCount - 1;
				tables = this._viewTables;
				// getting the height of northern tables
				if (fixedRowIdx > -1 && fixedRowIdx <= lastRowIdx) {
					tableNE = tables.ne;
					tableNEParent = tableNE.parentNode;
					tableNW = tables.nw;
					tableNWParent = tableNW.parentNode;
					leftRows = tableNW.rows;
					rightRows = tableNE.rows;
					rowCount = leftRows.length;
					for (i = 0; i < rowCount; i++) {
						heightArray.push(this._getRowHeight([leftRows[i], rightRows[i]]));
					}
				}
				// getting the height of southern tables
				if (fixedRowIdx >= -1 && fixedRowIdx < lastRowIdx) {
					tableSE = tables.se;
					tableSEParent = tableSE.parentNode;
					tableSW = tables.sw;
					tableSWParent = tableSW.parentNode;
					leftRows = tableSW.rows;
					rightRows = tableSE.rows;
					rowCount = leftRows.length;
					for (i = 0; i < rowCount; i++) {
						heightArray.push(this._getRowHeight([leftRows[i], rightRows[i]]));
					}
				}

				// removing elments from dom to improve performance
				if (fixedRowIdx > -1 && fixedRowIdx <= lastRowIdx) {
					tableNWParent.removeChild(tableNW);
					tableNEParent.removeChild(tableNE);
				}
				if (fixedRowIdx >= -1 && fixedRowIdx < lastRowIdx) {
					tableSWParent.removeChild(tableSW);
					tableSEParent.removeChild(tableSE);
				}

				// setting the height of northern tables
				if (fixedRowIdx > -1 && fixedRowIdx <= lastRowIdx) {
					leftRows = tableNW.rows;
					rightRows = tableNE.rows;
					rowCount = leftRows.length;
					for (i = 0, j = 0; i < rowCount; i++) {
						this._setRowHeight([leftRows[i], rightRows[i]], heightArray[j++]);
					}
				}
				// setting the height of southern tables
				if (fixedRowIdx >= -1 && fixedRowIdx < lastRowIdx) {
					leftRows = tableSW.rows;
					rightRows = tableSE.rows;
					rowCount = leftRows.length;
					for (i = 0; i < rowCount; i++) {
						this._setRowHeight([leftRows[i], rightRows[i]], heightArray[j++]);
					}
				}

				// adding elments back to dom to improve performance
				if (fixedRowIdx > -1 && fixedRowIdx <= lastRowIdx) {
					tableNWParent.appendChild(tableNW);
					tableNEParent.appendChild(tableNE);
				}
				if (fixedRowIdx >= -1 && fixedRowIdx < lastRowIdx) {
					tableSWParent.appendChild(tableSW);
					tableSEParent.appendChild(tableSE);
				}
			}
		},

		// private abstract **

		// ** private specific

		/*
		adjustCellsSizes: function () {
		var accessor = new $.wijmo.wijgrid.rowAccessor(this, 9, 0),
		rowLen = accessor.length(),
		heights = [], // int[rowLen];
		i, j, rowObj,
		row0, len0, row0Span, row0h,
		row1, len1, row1Span, row1h,
		row;

		for (i = 0; i < rowLen; i++) {
		rowObj = this.getJoinedRows(i, 9); // = accessor[i];

		row0 = rowObj[0];
		len0 = (row0 !== null) ? row0.cells.length : 0;
		row0Span = false;

		for (j = 0; j < len0 && !row0Span; j++) {
		row0Span = (row0.cells[j].rowSpan > 1);
		}

		row1 = rowObj[1];
		len1 = (row1 !== null) ? row1.cells.length : 0;
		row1Span = false;

		if (!row0Span) {
		for (j = 0; j < len1 && !row1Span; j++) {
		row1Span = (row1.cells[j].rowSpan > 1);
		}
		}

		row0h = (row0 !== null && len0 > 0) ? row0.offsetHeight : 0;
		row1h = (row1 !== null && len1 > 0) ? row1.offsetHeight : 0;

		heights[i] = (row0Span || row1Span) ? Math.min(row0h, row1h) : Math.max(row0h, row1h);
		}

		for (i = 0; i < rowLen; i++) {
		row = this.getJoinedRows(i, 9); // = accessor[i];
		accessor.iterateCells(row, this.setCellContentDivHeight, heights[i]);
		}
		},

		adjustColumnSizes: function(topTable, bottomTable) {
		if (topTable.rows.length > 0 && bottomTable.rows.length > 0) {
		var topRowCells = topTable.rows[0].cells;
		var bottomRowCells = bottomTable.rows[0].cells;

		if (topRowCells.length == bottomRowCells.length) {
		for (var i = 0; i < topRowCells.length; i++) {
		topRowCells[i].style.width = bottomRowCells[i].style.width = Math.max(topRowCells[i].offsetWidth, bottomRowCells[i].offsetWidth);
		}
		}
		}

		topTable.style.width = bottomTable.style.width = Math.max(topTable.offsetWidth, bottomTable.offsetWidth) + "px";
		//alert(topTable.style.width + "?w=" + Math.max(topTable.offsetWidth, bottomTable.offsetWidth));

		topTable.style.tableLayout = "fixed";
		bottomTable.style.tableLayout = "fixed";
		},
		*/

		_onScroll: function (event, data) {
			var element, key, property = {};
			if (data.dir === "h") {
				element = this._wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-ne");
				key = "scrollLeft";
			} else {
				element = this._wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-sw");
				key = "scrollTop";
			}
			if (data.animationOptions) {
				property[key] = data.position;
				element.animate(property, data.animationOptions);
			} else {
				element[0][key] = data.position;
			}
		},

		_onScrolled: function () {
			this._wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-ne")[0].scrollLeft = parseInt((this._wijgrid.outerDiv.find(".wijmo-wijsuperpanel-templateouterwrapper").css("left") + "").replace("px", ""), 10) * -1;
			this._wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-sw")[0].scrollTop = parseInt((this._wijgrid.outerDiv.find(".wijmo-wijsuperpanel-templateouterwrapper").css("top") + "").replace("px", ""), 10) * -1;
		},

		_onMouseWheel: function (e, delta) {
			// force superpanel to do scrolling when cursor is placed over then non-scrollable (fixed) areas of the wijgrid.

			var bounds,
				dir = (delta > 0) ? "top" : "bottom",
				isOverFixedArea = false,
				vPos;

			if (this._wijgrid._canInteract()) {
				bounds = this.getFixedAreaVisibleBounds(); // an array

				$.each(bounds, function (i, o) {
					if (o && $.ui.isOver(e.pageY, e.pageX, o.top, o.left, o.height, o.width)) {
						isOverFixedArea = true;
						return false; // break
					}
				});

				if (isOverFixedArea && this._scroller.data("wijsuperpanel")) {
					vPos = this._scroller.wijsuperpanel("option", "vScroller").scrollValue;

					this._scroller.wijsuperpanel("doScrolling", dir);

					// simulate wijsuperpanel behaviour: prevent window scrolling until superpanel is not scrolled to the end.
					if (vPos !== this._scroller.wijsuperpanel("option", "vScroller").scrollValue) {
						e.stopPropagation();
						e.preventDefault();
					}
				}
			}
		},

		/*
		setCellContentDivHeight: function (cell, param) {
		cell.style.height = param + "px";
		return true;
		},
		*/

		_testNeedVBar: function (outerDiv, gridElement, tableNE, mode, autoHeight) {
			var excludeVBarWidth,
				wijgrid = this._wijgrid,
				gridWidth = tableNE.width() + wijgrid.options.splitDistanceX,
				gridHeight = gridElement.height() + wijgrid.options.splitDistanceY,
				outerWidth = outerDiv.width(),
				outerHeight = outerDiv.height(),
				contentHeight, topHeight = 0, bottomHeight = 0;

			if (wijgrid.$superPanelHeader !== null) {
				topHeight = wijgrid.$superPanelHeader.outerHeight(true);
			}
			if (wijgrid.$bottomPagerDiv !== null) {
				bottomHeight = wijgrid.$bottomPagerDiv.outerHeight(true);
			}
			contentHeight = outerHeight - topHeight - bottomHeight;

			if (mode === "both" || mode === "vertical") {
				excludeVBarWidth = true;
			}
			else {
				excludeVBarWidth = (mode === "auto") && (
					(gridHeight > contentHeight) ||
					(!autoHeight && gridWidth > outerWidth && gridHeight > contentHeight - this._verScrollBarSize)); // When the height needs to be auto adjusted, the vertical scrollbar should not be shown
			}

			return excludeVBarWidth;
		},

		//bSet: 0-width, 1-height, 2-all
		_updateSplitAreaBounds: function (bSet) {
			var wijgrid = this._wijgrid,
				o = wijgrid.options,
			//controlWidth = wijgrid.outerDiv.width(),
				controlHeight, contentHeight, topHeight = 0, bottomHeight = 0,
				areaNW = wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-nw"),
				areaNE = wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-ne"),
				areaSW = wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-sw"),
				areaSE = wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-se");

			if (bSet === 0 || bSet === 2) {
				areaNW.width(o.splitDistanceX);
				areaSW.width(o.splitDistanceX);
				areaSE.css("marginLeft", o.splitDistanceX);
				areaNE.css("marginLeft", o.splitDistanceX);
			}
			if (bSet === 1 || bSet === 2) {
				this._scroller.css("height", "");
				areaSE.css("marginTop", 0);

				controlHeight = wijgrid.outerDiv.height();

				if (!wijgrid._autoHeight) {
					this._scroller.height(controlHeight);
				}
				else {
					// no height is set for outer div, we need to expand the grid.
					this._scroller.height(controlHeight + o.splitDistanceY);
					//this._noHeight = true;
				}

				areaNW.height(o.splitDistanceY);
				areaNE.height(o.splitDistanceY);

				if (wijgrid.$superPanelHeader !== null) {
					topHeight = wijgrid.$superPanelHeader.outerHeight(true);
				}
				if (wijgrid.$bottomPagerDiv !== null) {
					bottomHeight = wijgrid.$bottomPagerDiv.outerHeight(true);
				}
				contentHeight = controlHeight - topHeight - bottomHeight;

				if (wijgrid.$superPanelHeader !== null) {
					$.each([areaNW, areaNE], function (index, el) {
						el.css("top", topHeight + "px");
					});
				}

				if (!wijgrid._autoHeight) {
					areaSW.height(contentHeight - o.splitDistanceY);
				}
				else {
					areaSW.height(contentHeight);
				}

				areaSW.css("top", o.splitDistanceY + topHeight);
				areaSE.css("marginTop", o.splitDistanceY);
			}
		}

		// private specific **
	});
})(jQuery);(function ($) {
	"use strict";
	$.wijmo.wijgrid.selection = function (gridView) {
		/// <summary>
		/// Object that represents selection in the grid.
		/// Code example: var selection = new $.wijmo.wijgrid.selection(gridView);
		/// </summary>
		/// <param name="gridview" type="$.wijmo.wijgrid" mayBeNull="false">gridView</param>
		/// <returns type="$.wijmo.wijgrid.selection">Object that represents selection in the grid</returns>
		var _updates = 0,
			_anchorCell,
			_addedCells = new $.wijmo.wijgrid.cellInfoOrderedCollection(gridView),
			_removedCells = new $.wijmo.wijgrid.cellInfoOrderedCollection(gridView),
			_selectedCells = new $.wijmo.wijgrid.cellInfoOrderedCollection(gridView),
			_addedDuringCurTransactionCells = new $.wijmo.wijgrid.cellInfoOrderedCollection(gridView),
			_selectedColumns = null, // ?
			_selectedRows = null, // ?

			// n: none (0), c: extendToColumn (1), r: extendToRow (2)
			//
			//              extendMode
			// selectionMode| n | c | r
			// ------------------------
			// singlecell   | n | n | n
			// singlecolumn | c | c | c
			// singlerow    | r | r | r
			// singlerange  | n | c | r
			// multicolumn  | c | c | c
			// multirow     | r | r | r
			// multirange   | n | c | r
			_extend_rules = {
				"singlecell": [0, 0, 0],
				"singlecolumn": [1, 1, 1],
				"singlerow": [2, 2, 2],
				"singlerange": [0, 1, 2],
				"multicolumn": [1, 1, 1],
				"multirow": [2, 2, 2],
				"multirange": [0, 1, 2]
			};

		this.selectedCells = function () {
			/// <summary>
			/// Gets a read-only collection of the selected cells.
			/// Code example: var selectedCells = selectionObj.selectedCells();
			/// </summary>
			/// <returns type="$.wijmo.wijgrid.cellInfoOrderedCollection"/>
			return _selectedCells;
		};

		this.addColumns = function (start, end /* opt */) {
			/// <summary>
			/// Adds a column range to the current selection.
			///
			/// Usage:
			/// 1. addColumns(0)
			/// 2. addColumns(0, 2)
			/// 
			/// The result depends upon the chosen selection mode in the grid. For example, if current selection mode
			/// does not allow multiple selection the previous selection will be removed.
			///
			/// Code example: selectionObj.addColumns(0);
			/// </summary>
			/// <param name="start" type="Number" integer="true">The index of the first column to select.</param>
			/// <param name="end" type="Number" integer="true">The index of the last column to select. Optional.</param>

			if (!end && end !== 0) {
				end = start;
			}

			this.addRange(start, 0, end, 0xFFFFFF);
		};

		this.addRange = function (cellRange /* x0 */, y0 /* opt */, x1 /* opt */, y1 /* opt */) {
			/// <summary>
			/// Adds a cell range to the current selection.
			///
			/// Usage:
			/// 1. addRange(cellRange)
			/// 2. addRange(x0, y0, x1, y1)
			/// 
			/// The result depends upon the chosen selection mode in the grid. For example, if current selection mode
			/// does not allow multiple selection the previous selection will be removed.
			///
			/// Code example: selectionObj.addRange(0, 0, 1, 1);
			/// </summary>
			/// <param name="cellRange" type="$.wijmo.wijgrid.cellInfoRange">Cell range to select.</param>
			/// <param name="x0" type="Number" integer="true">The x-coordinate that represents the top left cell of the range.</number>
			/// <param name="y0" type="Number" integer="true">The y-coordinate that represents the top left cell of the range.</number>
			/// <param name="x1" type="Number" integer="true">The x-coordinate that represents the bottom right cell of the range.</number>
			/// <param name="y1" type="Number" integer="true">The y-coordinate that represents the bottom right cell of the range.</number>

			if (!cellRange && (arguments.length === 1)) {
				throw "invalid argument";
			}

			var range = (arguments.length === 4)
				? new $.wijmo.wijgrid.cellInfoRange(new $.wijmo.wijgrid.cellInfo(cellRange /* ie x0 */, y0), new $.wijmo.wijgrid.cellInfo(x1, y1))
				: cellRange._clone();

			range._normalize();

			if (!range._isValid()) {
				throw "invalid argument";
			}

			this.beginUpdate();

			this._startNewTransaction(gridView._field("currentCell"));
			this._selectRange(range, false, true, 0 /* none*/, null);

			this.endUpdate();
		};

		this.addRows = function (start, end /* opt */) {
			/// <summary>
			/// Adds a row range to the current selection.
			///
			/// Usage:
			/// 1. addRows(0)
			/// 2. addRows(0, 2)
			/// 
			/// The result depends upon the chosen selection mode in the grid. For example, if current selection mode
			/// does not allow multiple selection the previous selection will be removed.
			///
			/// Code example: selectionObj.addRows(0);
			/// </summary>
			/// <param name="start" type="Number" integer="true">The index of the first row to select.</param>
			/// <param name="end" type="Number" integer="true">The index of the last row to select. Optional.</param>

			if (!end && end !== 0) {
				end = start;
			}

			this.addRange(0, start, 0xFFFFFF, end);
		};

		this.removeRange = function (cellRange /* x0 */, y0 /* opt */, x1 /* opt */, y1 /* opt */) {
			/// <summary>
			/// Removes a cell range from the current selection.
			///
			/// Usage:
			/// 1. removeRange(cellRange)
			/// 2. removeRange(x0, y0, x1, y1)
			/// 
			/// The result depends upon the chosen selection mode in the grid.
			///
			/// Code example: selectionObj.removeRange(0, 0, 1, 1);
			/// </summary>
			/// <param name="cellRange" type="$.wijmo.wijgrid.cellInfoRange">Cell range to remove.</param>
			/// <param name="x0" type="Number" integer="true">The x-coordinate that represents the top left cell of the range.</number>
			/// <param name="y0" type="Number" integer="true">The y-coordinate that represents the top left cell of the range.</number>
			/// <param name="x1" type="Number" integer="true">The x-coordinate that represents the bottom right cell of the range.</number>
			/// <param name="y1" type="Number" integer="true">The y-coordinate that represents the bottom right cell of the range.</number>

			if (!cellRange && (arguments.length === 1)) {
				throw "invalid argument";
			}

			var range = (arguments.length === 4)
				? new $.wijmo.wijgrid.cellInfoRange(new $.wijmo.wijgrid.cellInfo(cellRange, y0), new $.wijmo.wijgrid.cellInfo(x1, y1))
				: cellRange._clone();

			range._normalize();

			if (!range._isValid()) {
				throw "invalid argument";
			}

			this.beginUpdate();

			this._startNewTransaction(gridView._field("currentCell"));
			this._clearRange(range, 0 /* none */);

			this.endUpdate();
		};

		this.removeColumns = function (start, end /* opt */) {
			/// <summary>
			/// Removes a column range from the current selection.
			///
			/// Usage:
			/// 1. removeColumns(0)
			/// 2. removeColumns(0, 2)
			/// 
			/// The result depends upon the chosen selection mode in the grid.
			///
			/// Code example: selectionObj.removeColumns(0);
			/// </summary>
			/// <param name="start" type="Number" integer="true">The index of the first column to remove.</param>
			/// <param name="end" type="Number" integer="true">The index of the last column to remove. Optional.</param>

			if (!end && end !== 0) {
				end = start;
			}

			this.removeRange(start, 0, end, 0xFFFFFF);
		};

		this.removeRows = function (start, end /* opt */) {
			/// <summary>
			/// Removes a row range from the current selection.
			///
			/// Usage:
			/// 1. removeRows(0)
			/// 2. removeRows(0, 2)
			/// 
			/// The result depends upon the chosen selection mode in the grid.
			///
			/// Code example: selectionObj.removeRows(0);
			/// </summary>
			/// <param name="start" type="Number" integer="true">The index of the first row to remove.</param>
			/// <param name="end" type="Number" integer="true">The index of the last row to remove. Optional.</param>

			if (!end && end !== 0) {
				end = start;
			}

			this.removeRange(0, start, 0xFFFFFF, end);
		};


		this.addRows = function (start, end /* opt */) {
			/// <summary>
			/// Adds a rows range to the current selection.
			///
			/// Usage:
			/// 1. addRows(0)
			/// 2. addRows(0, 2)
			/// 
			/// The result depends upon the chosen selection mode in the grid. For example, if current selection mode
			/// does not allow multiple selection the previous selection will be removed.
			///
			/// Code example: selectionObj.addRows(0);
			/// </summary>
			/// <param name="start" type="Number" integer="true">The index of the first row to select.</param>
			/// <param name="end" type="Number" integer="true">The index of the last row to select. Optional.</param>

			if (!end && end !== 0) {
				end = start;
			}

			this.addRange(0, start, 0xFFFF, end);
		};

		this.clear = function () {
			/// <summary>
			/// Clears the selection.
			/// Code example: selectionObj.clear();
			/// </summary>
			this.beginUpdate();

			_removedCells._clear();
			_removedCells._addFrom(_selectedCells);

			this.endUpdate();
		};

		this.selectAll = function () {
			/// <summary>
			/// Selects all the cells in a grid.
			///
			/// The result depends upon the chosen selection mode in the grid.
			/// For example, if the selection mode is "singleCell", only the top left cell will be selected.
			///
			/// Code example: selectionObj.selectAll();
			/// </summary>
			this.beginUpdate();

			this._selectRange(gridView._getDataCellsRange(), false, false, 0 /* none */, null);

			this.endUpdate();
		};

		this.beginUpdate = function () {
			/// <summary>
			/// Begins the update.
			/// The changes won't have effect until endUpdate() is called.
			/// Code example: selectionObj.beginUpdate();
			/// </summary>
			_updates++;
		};

		this.endUpdate = function () {
			/// <summary>
			/// Ends the update.
			/// The pending changes are executed and the corresponding events are raised.
			/// Code example: selectionObj.endUpdate();
			/// </summary>
			if (_updates > 0) {
				_updates--;

				if (_updates === 0) {
					doSelection(); // values must be clipped before this step

					if (_addedCells.length() || _removedCells.length()) {

						if (_selectedColumns !== null) {
							_selectedColumns.UnderlyingDataChanged(); // notify
						}

						if (_selectedRows !== null) {
							_selectedRows.UnderlyingDataChanged(); // notify
						}

						gridView._trigger("selectionChanged", null, { addedCells: _addedCells, removedCells: _removedCells });
					}

					_addedCells = new $.wijmo.wijgrid.cellInfoOrderedCollection(gridView);
					_removedCells._clear();
				}
			}
		};

		// * internal

		this._multipleRangesAllowed = function () {
			var mode = gridView.options.selectionMode;

			return (mode && ((mode = mode.toLowerCase()) === "multicolumn" || mode === "multirow" || mode === "multirange"));
		};

		this._anchorCell = function () {
			return _anchorCell;
		};

		this._startNewTransaction = function (dataCellInfo) {
			if (dataCellInfo) {
				_anchorCell = dataCellInfo._clone();
				_addedDuringCurTransactionCells = new $.wijmo.wijgrid.cellInfoOrderedCollection(gridView);
			}
		};

		this._clearRange = function (range, extendMode) {
			var selectionMode = gridView.options.selectionMode.toLowerCase(),
				rangeToClear, rowsLen, cellsLen, flag, row, cell,
				i, len, cellInfo,
				dataRange = gridView._getDataCellsRange();

			if (range._isValid() && (selectionMode !== "none") && (_selectedCells.length() > 0)) {
				rangeToClear = range._clone();

				rangeToClear._normalize();
				rangeToClear._clip(dataRange);

				if (!range._isValid()) {
					return;
				}

				// extend
				rangeToClear._extend(_extend_rules[selectionMode][extendMode], dataRange);

				this.beginUpdate();

				// remove selected cells only, do not use doRange(rangeToClear, false) here.
				for (i = 0, len = _selectedCells.length(); i < len; i++) {
					cellInfo = _selectedCells.item(i);

					if (rangeToClear._containsCellInfo(cellInfo)) {
						_removedCells._add(cellInfo);
					}
				}

				/*switch (selectionMode) {
				case "singlecell":
				if (rangeToClear._containsCellInfo(_selectedCells.item(0))) {
				this.clear();
				}
				break;

				case "singlecolumn":
				case "singlerow":
				case "singlerange":
				rowsLen = rangeToClear.bottomRight().rowIndex();
				cellsLen = rangeToClear.bottomRight().cellIndex();

				flag = false;
				for (row = rangeToClear.topLeft().rowIndex(); !flag && row <= rowsLen; row++) {
				for (cell = rangeToClear.topLeft().cellIndex(); !flag && cell <= cellsLen; cell++) {
				flag = _selectedCells.indexOf(cell, row) >= 0;
				if (flag) {
				this.clear();
				}
				}
				}
				break;

				case "multicolumn":
				case "multirow":
				case "multirange":
				for (i = 0, len = _selectedCells.length(); i < len; i++) {
				cellInfo = _selectedCells.item(i);

				if (rangeToClear._containsCellInfo(cellInfo)) {
				_removedCells._add(cellInfo);
				}
				}

				break;
				}*/

				this.endUpdate();
			}
		};

		this._selectRange = function (range, ctrlKey, shiftKey, extendMode, endPoint) {
			var selectionMode = gridView.options.selectionMode.toLowerCase(),
				rangeToSelect,
				dataRange = gridView._getDataCellsRange();

			if ((selectionMode !== "none") && range._isValid()) {
				rangeToSelect = range._clone();
				rangeToSelect._normalize();
				rangeToSelect._clip(dataRange);

				if (!rangeToSelect._isValid()) {
					return;
				}

				this.beginUpdate();

				if (!this._multipleRangesAllowed()) {
					this.clear();
				}
				else {
					if (ctrlKey || shiftKey) {
						if (shiftKey) {
							_removedCells._clear();
							_removedCells._addFrom(_addedDuringCurTransactionCells);
						}
					}
					else {
						this.clear();
					}
				}

				// truncate range by selectionMode
				switch (selectionMode) {
					case "singlecell":
					case "singlecolumn":
					case "singlerow":
						rangeToSelect = (endPoint === null)
							? new $.wijmo.wijgrid.cellInfoRange(rangeToSelect.topLeft(), rangeToSelect.topLeft()) // top-left cell only is taken into consideration.
							: new $.wijmo.wijgrid.cellInfoRange(endPoint, endPoint);
						break;
				}

				// extend
				rangeToSelect._extend(_extend_rules[selectionMode][extendMode], dataRange);

				// do selection
				doRange(rangeToSelect, true);

				this.endUpdate();
			}
		};

		// * internal

		// * private

		function doSelection() {
			var offsets = gridView._getDataToAbsOffset(),
				cellOffset = offsets.x,
				rowOffset = offsets.y,
				view = gridView._view(),
				i, len, info, cell, $cell, index,
				$rs = $.wijmo.wijgrid.renderState,
				rowInfo, state,
				prevRowIndex = -1;

			for (i = 0, len = _removedCells.length(); i < len; i++) {
				info = _removedCells.item(i);

				if (_addedCells.indexOf(info) < 0) {
					cell = view.getCell(info.cellIndex() + cellOffset, info.rowIndex() + rowOffset);

					if (cell) {
						if (prevRowIndex !== info.rowIndex()) {
							rowInfo = gridView._createRowInfo(info._row());
							prevRowIndex = info.rowIndex();
						}

						$cell = $(cell);
						state = gridView._changeRenderState($cell, $rs.selected, false);
						gridView.cellStyleFormatter.format($cell, info.cellIndex(), info.column(), rowInfo, state);
					}

					_selectedCells._remove(info);
					_addedDuringCurTransactionCells._remove(info);
				}
				else {
					_removedCells._removeAt(i);
					i--;
					len--;
				}
			}

			prevRowIndex = -1;

			for (i = 0, len = _addedCells.length(); i < len; i++) {
				info = _addedCells.item(i);

				index = _selectedCells.indexOf(info);
				if (index < 0) {
					cell = view.getCell(info.cellIndex() + cellOffset, info.rowIndex() + rowOffset);
					if (cell) {
						if (prevRowIndex !== info.rowIndex()) {
							rowInfo = gridView._createRowInfo(info._row());
							prevRowIndex = info.rowIndex();
						}

						$cell = $(cell);
						state = gridView._changeRenderState($cell, $rs.selected, true);
						gridView.cellStyleFormatter.format($cell, info.cellIndex(), info.column(), rowInfo, state);
					}
					_selectedCells._insertUnsafe(info, ~index);
					_addedDuringCurTransactionCells._add(info);
				}
				else {
					_addedCells._removeAt(i);
					i--;
					len--;
				}
			}
		}

		function doRange(range, add) {
			var x0 = range.topLeft().cellIndex(),
				y0 = range.topLeft().rowIndex(),
				x1 = range.bottomRight().cellIndex(),
				y1 = range.bottomRight().rowIndex(),
				cnt, row, col, cell;

			if (add) {
				cnt = _addedCells.length();
				for (row = y0; row <= y1; row++) {
					if (gridView.dataTable[row].rowType & $.wijmo.wijgrid.rowType.data) {
						for (col = x0; col <= x1; col++) {
							cell = new $.wijmo.wijgrid.cellInfo(col, row);

							if (cnt === 0) {
								_addedCells._appendUnsafe(cell);
							}
							else {
								_addedCells._add(cell);
							}
						}
					}
				}
			}
			else {
				cnt = _removedCells.length();
				for (row = y0; row <= y1; row++) {
					for (col = x0; col <= x1; col++) {
						cell = new $.wijmo.wijgrid.cellInfo(col, row);

						if (cnt === 0) {
							_removedCells._appendUnsafe(cell);
						}
						else {
							_removedCells._add(cell);
						}
					}
				}
			}
		}
		// * private
	};

	$.wijmo.wijgrid.cellInfoOrderedCollection = function (gridView) {
		/// <summary>
		/// Creates an ordered read-only collection of $.wijmo.wijgrid.cellInfo objects.
		/// Code example: var collection = new $.wijmo.wijgrid.cellInfoOrderedCollection(gridView);
		/// </summary>
		/// <param name="gridView" type="$.wijmo.wijgrid" mayBeNull="false">gridView</param>
		/// <returns type="$.wijmo.wijgrid.cellInfoOrderedCollection" />
		if (!gridView) {
			throw "argument is null";
		}

		var _list = [];

		// public
		this.item = function (index) {
			/// <summary>
			/// Gets an item at the specified index.
			/// Code example: var cellInfoObj = collection.item(0);
			/// </summary>
			/// <param name="index" type="Number" integer="true">The zero-based index of the item to get.</param>
			/// <returns type="$.wijmo.wijgrid.cellInfo">The $.wijmo.wijgrid.cellInfo object at the specified index.</returns>
			return _list[index];
		};

		this.length = function () {
			/// <summary>
			/// Gets the total number of the items in the collection.
			/// Code example: var len = collection.length();
			/// </summary>
			/// <returns type="Number" integet="true">The total number of the items in the collection.</returns>
			return _list.length;
		};

		// (cellInfo)
		// (cellIndex, rowIndex)
		this.indexOf = function (cellIndex, rowIndex) {
			/// <summary>
			/// Returns the zero-based index of specified collection item.
			///
			/// Usage:
			/// 1. indexOf(cellInfo) (note: search is done by value, not by reference).
			/// 2. indexOf(cellIndex, rowIndex)
			///
			/// Code example: var index = collection.indexOf(0, 0);
			/// </summary>
			///
			/// <param name="cellInfo" type="$.wijmo.wijgrid.cellInfo">A cellInfo object to return the index of.</param>
			/// <param name="cellIndex" type="Number" integer="true">A zero-based cellIndex component of the cellInfo object to return the index of.</param>
			/// <param name="rowIndex" type="Number" integer="true">A zero-based rowIndex component of the cellInfo object to return the index of.</param>
			/// <returns type="Number" integer="true">The zero-based index of the specified object, or -1 if the specified object is not a member of the collection.</returns>
			if (arguments.length === 1) {
				rowIndex = cellIndex.rowIndex();
				cellIndex = cellIndex.cellIndex();
			}

			var lo = 0,
				hi = _list.length - 1,
				med, current, cmp;

			while (lo <= hi) {
				med = lo + ((hi - lo) >> 1);
				current = _list[med];

				cmp = current.rowIndex() - rowIndex;
				if (cmp === 0) {
					cmp = current.cellIndex() - cellIndex;
				}

				if (cmp < 0) {
					lo = med + 1;
				} else {
					if (cmp > 0) {
						hi = med - 1;
					} else {
						return med;
					}
				}
			}

			return ~lo;
		};

		this.toString = function () {
			var val = "",
				i, len;

			for (i = 0, len = _list.length; i < len; i++) {
				val += _list[i].toString() + "\n";
			}

			return val;
		};

		// public *

		// internal

		this._add = function (value) {
			var idx = this.indexOf(value);
			if (idx < 0) {
				_list.splice(~idx, 0, value);
				value._setGridView(gridView);
				return true;
			}

			return false;
		};

		// addFrom - an cellInfoOrderedCollection instance
		this._addFrom = function (addFrom) {
			if (addFrom) {
				var fromLen = addFrom.length(),
				thisLen = _list.length,
				i;

				if (thisLen === 0) {
					_list.length = fromLen;

					for (i = 0; i < fromLen; i++) {
						_list[i] = addFrom.item(i);
						_list[i]._setGridView(gridView);
					}
				} else {
					for (i = 0; i < fromLen; i++) {
						this._add(addFrom.item(i));
					}
				}
			}
		};

		this._appendUnsafe = function (value) {
			_list[_list.length] = value;
			value._setGridView(gridView);
		};

		this._insertUnsafe = function (value, index) {
			_list.splice(index, 0, value);
		};

		this._clear = function () {
			_list.length = 0;
		};

		this._remove = function (value) {
			var idx = this.indexOf(value);
			if (idx >= 0) {
				_list.splice(idx, 1);
				return true;
			}

			return false;
		};

		this._removeAt = function (index) {
			_list.splice(index, 1);
		};

		this._getColumnsIndicies = function () {
			var columns = [],
				len = _list.length,
				tmpColumns, i, len2;

			if (len) {
				tmpColumns = [];
				for (i = 0; i < len; i++) {
					tmpColumns[_list[i].cellIndex()] = 1;
				}

				len = tmpColumns.length;
				len2 = 0;
				for (i = 0; i < len; i++) {
					if (tmpColumns[i]) {
						columns[len2++] = i;
					}
				}
			}

			return columns;
		};

		this._getSelectedRowsIndicies = function () {
			var rows = [],
				len = _list.length,
				tmpRows, i, len2;

			if (len) {
				tmpRows = [];
				for (i = 0; i < len; i++) {
					tmpRows[_list[i].rowIndex()] = 1;
				}

				len = tmpRows.length;
				len2 = 0;
				for (i = 0; i < len; i++) {
					if (tmpRows[i]) {
						rows[len2++] = i;
					}
				}
			}

			return rows;
		};

		this._rectangulate = function () {
			var len = _list.length,
				x0 = 0xFFFFFFFF,
				y0 = 0xFFFFFFFF,
				x1 = 0,
				y1 = 0,
				i, cellInfo;

			if (len) {
				for (i = 0; i < len; i++) {
					cellInfo = _list[i];

					x0 = Math.min(x0, cellInfo.cellIndex());
					y0 = Math.min(y0, cellInfo.rowIndex());
					x1 = Math.max(x1, cellInfo.cellIndex());
					y1 = Math.max(y1, cellInfo.rowIndex());
				}

				return new $.wijmo.wijgrid.cellInfoRange(new $.wijmo.wijgrid.cellInfo(x0, y0),
					new $.wijmo.wijgrid.cellInfo(x1, y1));
			}

			return null;
		};

		// internal *
	};
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		selectionui: function (gridView) {
			var _gap_to_start = 10,
				_evntFormat = "{0}." + gridView.widgetName + ".selectionui",
				_addedCells = new $.wijmo.wijgrid.cellInfoOrderedCollection(gridView),
				_startPos,
				_startCellInfo,
				_endCellInfo,
				_prevMouseMoveRange,
				_inProgress = false,
				_additionalEventsAttached = false,
				_view = gridView._view(),
				_visLeavesLen = gridView._field("visibleLeaves").length,
				_rootElement = _view.focusableElement(); //gridView.element;

			_rootElement.bind(_eventKey("mousedown"), _onGridMouseDown);

			this.dispose = function () {
				_rootElement.unbind(_eventKey("mousedown"), _onGridMouseDown);
				_detachAdditionalEvents();
			};

			function _onGridMouseDown(args) {
				if (!gridView._canInteract() || gridView.options.selectionMode.toLowerCase() === "none") {
					return;
				}

				var visibleBounds = _view.getVisibleAreaBounds(),
					mouse = { x: args.pageX, y: args.pageY },
					tag = ((args.target && args.target.tagName !== undefined)
						? args.target.tagName.toLowerCase()
						: undefined),
					$target = $(args.target);

				if ((!tag || $target.is("td.wijgridtd, th.wijgridtd, div.wijmo-wijgrid-innercell")) &&
					(mouse.x > visibleBounds.left && mouse.x < visibleBounds.left + visibleBounds.width) &&
					(mouse.y > visibleBounds.top && mouse.y < visibleBounds.top + visibleBounds.height)) {

					_attachAdditionalEvents();
					_startPos = mouse;

					_startCellInfo = _coordToDataCellInfo(_startPos);
				}
			}

			function _onDocumentMouseMove(args) {
				if (!_startCellInfo || !_startCellInfo._isValid()) {
					return;
				}

				var mouse = { x: args.pageX, y: args.pageY },
					tmp, range, dataOffset, desiredCells, rowsLen, cellsLen,
					row, cell, i, len, info, $cell,
					rowInfo, prevRowIndex, state,
					$rs = $.wijmo.wijgrid.renderState;

				if (!_inProgress) {
					_inProgress = (Math.abs(_startPos.x - mouse.x) > _gap_to_start) ||
						(Math.abs(_startPos.y - mouse.y) > _gap_to_start);
				}

				if (_inProgress) {
					tmp = _coordToDataCellInfo(mouse);
					if (!tmp._isValid()) {
						return;
					}

					_endCellInfo = tmp;

					range = new $.wijmo.wijgrid.cellInfoRange(_startCellInfo, _endCellInfo);
					range._normalize();
					range._clip(gridView._getDataCellsRange());

					if (range._isValid() && !range.isEqual(_prevMouseMoveRange)) {
						dataOffset = gridView._getDataToAbsOffset();

						_prevMouseMoveRange = range;

						desiredCells = new $.wijmo.wijgrid.cellInfoOrderedCollection(gridView);
						rowsLen = range.bottomRight().rowIndex();
						cellsLen = range.bottomRight().cellIndex();

						for (row = range.topLeft().rowIndex(); row <= rowsLen; row++) {
							if (gridView.dataTable[row].rowType & $.wijmo.wijgrid.rowType.data) {
								for (cell = range.topLeft().cellIndex(); cell <= cellsLen; cell++) {
									desiredCells._appendUnsafe(new $.wijmo.wijgrid.cellInfo(cell, row));
								}
							}
						}

						prevRowIndex = -1;
						for (i = 0, len = _addedCells.length(); i < len; i++) {
							info = _addedCells.item(i);
							if (desiredCells.indexOf(info) < 0) // remove css
							{
								if (gridView.selection().selectedCells().indexOf(info) < 0) {
									cell = _view.getCell(info.cellIndex() + dataOffset.x, info.rowIndex() + dataOffset.y);
									if (cell) {
										if (prevRowIndex !== info.rowIndex()) {
											rowInfo = gridView._createRowInfo(info._row());
											prevRowIndex = info.rowIndex();
										}

										$cell = $(cell);
										state = gridView._changeRenderState($cell, $rs.selected, false);
										gridView.cellStyleFormatter.format($cell, info.cellIndex(), info.column(), rowInfo, state);
									}
								}

								_addedCells._removeAt(i);
								i--;
								len--;
							}
						}

						prevRowIndex = -1;
						for (i = 0, len = desiredCells.length(); i < len; i++) {
							info = desiredCells.item(i);
							if (_addedCells.indexOf(info) < 0 && gridView.selection().selectedCells().indexOf(info) < 0) {
								if (_addedCells._add(info)) {
									cell = _view.getCell(info.cellIndex() + dataOffset.x, info.rowIndex() + dataOffset.y);
									if (cell) {
										if (prevRowIndex !== info.rowIndex()) {
											rowInfo = gridView._createRowInfo(info._row());
											prevRowIndex = info.rowIndex();
										}

										$cell = $(cell);
										state = gridView._changeRenderState($cell, $rs.selected, true);
										gridView.cellStyleFormatter.format($cell, info.cellIndex(), info.column(), rowInfo, state);
									}
								}
							}
						}
					} // end if
				}
			}

			function _onDocumentMouseUp(args) {
				_detachAdditionalEvents();

				if (_inProgress) {
					_inProgress = false;

					if (_prevMouseMoveRange && _prevMouseMoveRange._isValid()) {
						gridView._changeCurrentCell(_endCellInfo);

						if (!args.shiftKey || (!gridView.selection()._multipleRangesAllowed() && gridView.options.selectionMode.toLowerCase() !== "singleRange")) {
							gridView.selection()._startNewTransaction(_startCellInfo);
						}

						gridView.selection().beginUpdate();
						gridView.selection()._selectRange(_prevMouseMoveRange, args.shiftKey, args.ctrlKey, 0 /* none */, _endCellInfo);
						gridView.selection().endUpdate();

						var view = gridView._view(),
							dataOffset = gridView._getDataToAbsOffset(),
							i, len, info, cell, $cell,
							prevRowIndex = -1, rowInfo, state,
							$rs = $.wijmo.wijgrid.renderState;

						// clear remained cells
						for (i = 0, len = _addedCells.length(); i < len; i++) {
							info = _addedCells.item(i);
							if (gridView.selection().selectedCells().indexOf(info) < 0) {
								cell = view.getCell(info.cellIndex() + dataOffset.x, info.rowIndex() + dataOffset.y);
								if (cell !== null) {
									if (prevRowIndex !== info.rowIndex()) {
										rowInfo = gridView._createRowInfo(info._row());
										prevRowIndex = info.rowIndex();
									}

									$cell = $(cell);
									state = gridView._changeRenderState($cell, $rs.selected, false);
									gridView.cellStyleFormatter.format($cell, info.cellIndex(), info.column(), rowInfo, state);
								}
							}
						}

						_addedCells._clear();
						_startCellInfo = _endCellInfo = _prevMouseMoveRange = null;

						return false; // cancel bubbling
					}
				}
			}

			function _attachAdditionalEvents() {
				if (!_additionalEventsAttached) {
					try {
						_view.toggleDOMSelection(false); // disable selection

						$(document)
							.bind(_eventKey("mousemove"), _onDocumentMouseMove)
							.bind(_eventKey("mouseup"), _onDocumentMouseUp);
					}
					finally {
						_additionalEventsAttached = true;
					}
				}
			}

			function _detachAdditionalEvents() {
				if (_additionalEventsAttached) {
					try {
						_view.toggleDOMSelection(true); // enable selection

						$(document)
							.unbind(_eventKey("mousemove"), _onDocumentMouseMove)
							.unbind(_eventKey("mouseup"), _onDocumentMouseUp);
					} finally {
						_additionalEventsAttached = false;
					}
				}
			}

			function _eventKey(eventType) {
				return $.wijmo.wijgrid.stringFormat(_evntFormat, eventType);
			}

			function _coordToDataCellInfo(pnt /* {x, y} */) {
				var left = 0,
					right = _visLeavesLen - 1,
					median = 0,
					cellIdx = -1,
					bounds,
					gridRowsAccessor = new $.wijmo.wijgrid.rowAccessor(_view, 2 /* tbody */, 0, 0),
					rowIdx, rowObj, dataOffset, result;

				// get cell index
				while (left <= right) {
					median = ((right - left) >> 1) + left;

					bounds = $.wijmo.wijgrid.bounds(_view.getHeaderCell(median)); // get header cell
					if (!bounds) { // no header?
						rowObj = gridRowsAccessor.item(0);
						bounds = $.wijmo.wijgrid.bounds(gridRowsAccessor.getCell(rowObj, median)); // get data cell
					}

					if (!bounds) {
						break;
					}

					if (pnt.x < bounds.left) { // -1 
						right = median - 1;
					}
					else
						if (pnt.x > bounds.left + bounds.width) { // 1
							left = median + 1;
						} else { // 0
							cellIdx = median;
							break;
						}
				}

				if (cellIdx === -1) {
					return $.wijmo.wijgrid.cellInfo.prototype.outsideValue;
				}

				gridRowsAccessor = new $.wijmo.wijgrid.rowAccessor(_view, 0 /* all */, 0, 0);

				rowIdx = -1;
				left = 0;
				right = gridRowsAccessor.length() - 1;
				median = 0;

				// get row index
				while (left <= right) {
					median = ((right - left) >> 1) + left;
					rowObj = gridRowsAccessor.item(median);
					bounds = $.wijmo.wijgrid.bounds(gridRowsAccessor.getCell(rowObj, 0));

					if (pnt.y < bounds.top) { // -1
						right = median - 1;
					}
					else
						if (pnt.y > bounds.top + bounds.height) { // 1
							left = median + 1;
						} else { // 0
							rowIdx = median;
							break;
						}
				} // end while { }


				if (rowIdx === -1) {
					return $.wijmo.wijgrid.cellInfo.prototype.outsideValue;
				}

				dataOffset = gridView._getDataToAbsOffset();

				result = new $.wijmo.wijgrid.cellInfo(cellIdx - dataOffset.x, rowIdx - dataOffset.y);
				result._clip(gridView._getDataCellsRange());

				return result;
			}
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.wijmo.wijgrid.rowAccessor = function (view, scope, offsetTop, offsetBottom) {
		/// <summary>
		/// Object for convenient access to rows of a wijgrid widget.
		/// </summary>

		if (!offsetTop) {
			offsetTop = 0;
		}

		if (!offsetBottom) {
			offsetBottom = 0;
		}

		this.item = function (index) {
			/// <summary>
			/// Gets an array of the table row elements that represents a wijgrid widget row at the specified index.
			/// remark: size of returning array is always two.
			/// </summary>
			/// <param name="index" type="Number" integer="true">
			/// The zero-based index of the row to retrieve.
			/// </param>
			/// <returns type="Array" elementType="object" elementDomElement="true">
			/// The array of the table row elements at the specified index.
			/// </returns>
			var len = this.length();

			return (index < len)
				? view.getJoinedRows(index + offsetTop, scope)
				: null;
		};

		this.length = function () {
			/// <summary>
			/// Gets the total number of elements.
			/// </summary>
			var joinedTables = view.getJoinedTables(true, 0),
				len = 0, htmlAccessor;

			if (htmlAccessor = joinedTables[0]) {
				len = htmlAccessor.getSectionLength(scope);
			}

			if (htmlAccessor = joinedTables[1]) {
				len += htmlAccessor.getSectionLength(scope);
			}

			len -= offsetTop + offsetBottom;

			if (len < 0) {
				len = 0;
			}

			return len;
		};

		this.iterateCells = function (rowObj, callback, param) {
			/// <summary>
			/// Sequentially iterates the cells in a <paramref name="rows"/> array.
			///
			/// example:
			/// Suppose rows is an array containing the following data:
			/// [ ["a", "b"], ["c", "d", "e"] ]
			///
			/// When it is iterated it will sequentially return:
			/// "a", "b", "c", "d", "e"
			/// </summary>
			/// <param name="rowObj" type="Array" elementType="Object" elementDomElement="true">Array of rows to be iterated.</param>
			/// <param name="callback" type="Function">Function that will be called each time a new cell is reached.</param>
			/// <param name="param" type="Object" optional="true">Parameter that can be handled within the callback function.</param>
			if (rowObj && callback) {
				var globCellIdx = 0,
					i, len, domRow, j, cellLen, result;

				for (i = 0, len = rowObj.length; i < len; i++) {
					domRow = rowObj[i];

					if (domRow) {
						for (j = 0, cellLen = domRow.cells.length; j < cellLen; j++) {
							result = callback(domRow.cells[j], globCellIdx++, param);
							if (result !== true) {
								return;
							}
						}
					}
				}
			}
		};

		this.getCell = function (rowObj, globCellIndex) {
			/// <summary>
			/// Gets a cell by its global index in a row's array passed in rowObj.
			/// 
			/// example:
			/// Suppose rows is an array containing the following data:
			/// [ ["a", "b"], ["c", "d", "e"] ]
			///
			/// "a" symbol has a global index 0.
			/// "c" symbol has a global index 2.
			/// </summary>
			/// <param name="rowObj" type="Array" elementType="Object" elementDomElement="true">Array of table row elements.</param>
			/// <param name="index" type="Number" integer="true">Zero-based global index of a cell.</param>
			/// <returns type="Object" domElement="true" elementMayBeNull="true">
			/// A cell or null if a cell with provided index is not found.
			/// </returns>
			var domRow, cellLen;

			if (rowObj && (domRow = rowObj[0])) {
				cellLen = domRow.cells.length;
				if (globCellIndex < cellLen) {
					return domRow.cells[globCellIndex];
				}

				globCellIndex -= cellLen;

				if (domRow = rowObj[1]) {
					cellLen = domRow.cells.length;
					if (globCellIndex < cellLen) {
						return domRow.cells[globCellIndex];
					}
				}
			}

			return null;
		};

		this.cellsCount = function (rowObj) {
			/// <summary>
			/// Gets the number of cells in a array of table row elements.
			/// </summary>
			/// <param name="rowObj" type="Array" elementType="Object" elementDomElement="true">Array of table row elements.</param>
			/// <returns type="Number" integer="true">The number of cells in a array of table row elements.</returns>
			var res = 0,
				domRow;

			if (rowObj && (domRow = rowObj[0])) {
				res = domRow.cells.Length;

				if (domRow = rowObj[1]) {
					res += domRow.cells.Length;
				}
			}

			return res;
		};
	};
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		cellEditorHelper: function () {
			this.currentCellEditStart = function (grid, e) {
				var result = false,
					currentCell = grid.currentCell(),
					rowObj, args, $innerDiv, rowType;

				if (currentCell._isValid() && !currentCell._isEdit() && (currentCell.column().dataIndex >= 0)) {
					rowObj = currentCell._row();

					if (rowObj && rowObj.length) {
						//rowType = $.wijmo.wijgrid.dataPrefix($(rowObj[0]), grid._data$prefix, "rowType");
						rowType = $.wijmo.wijgrid.dataPrefix(rowObj[0], grid._data$prefix, "rowType");

						if (rowType & $.wijmo.wijgrid.rowType.data) {

							args = {
								cell: currentCell,
								event: e,
								handled: false
							};

							if (result = grid._trigger("beforeCellEdit", null, args)) { // todo
								if (!args.handled) {
									result = defaultBeforeCellEdit(grid, args);
								}
							}

							if (result) {
								currentCell._isEdit(true);

								if (grid.options.showRowHeader) {
									$innerDiv = $(rowObj[0].cells[0]).children("div.wijmo-wijgrid-innercell");
									if ($innerDiv.length) {
										$innerDiv.empty();
										$innerDiv.append($("<div>&nbsp;</div>").addClass("ui-icon ui-icon-pencil"));
									}
								}
							}
						}
					}
				}

				return result;
			};

			this.currentCellEditEnd = function (grid, e) {
				var currentCell = grid.currentCell(),
					result = false,
					rowObj, rowType, escPressed, args, valueIsChanged, a, b;

				if (!currentCell._isValid() || !currentCell._isEdit()) {
					return;
				}

				rowObj = currentCell._row();
				if (rowObj && rowObj.length) {
					//rowType = $.wijmo.wijgrid.dataPrefix($(rowObj[0]), grid._data$prefix, "rowType");
					rowType = $.wijmo.wijgrid.dataPrefix(rowObj[0], grid._data$prefix, "rowType");

					if (!(rowType & $.wijmo.wijgrid.rowType.data)) {
						return result;
					}

					escPressed = (e && e.which === $.ui.keyCode.ESCAPE);

					if (!e || (!escPressed)) {
						args = {
							cell: currentCell,
							value: undefined
						};

						if (result = grid._trigger("beforeCellUpdate", null, args)) {
							if (args.value === undefined) {
								args.value = getCellValue(grid, currentCell); // trying to get value using default implementation.
							}

							valueIsChanged = false;
							if (args.cell.column().dataType === "datetime") {
								a = args.value ? args.value.getTime() : null;
								b = currentCell.value() ? currentCell.value().getTime() : null;
								valueIsChanged = a !== b;

							} else {
								valueIsChanged = args.value !== currentCell.value();
							}

							if (valueIsChanged) {
								// ** update datasource
								try {
									currentCell.value(args.value);
								} catch (ex) {
									result = false;
									grid._trigger("invalidCellValue", null, { cell: currentCell, value: args.value });
								}

								if (result) {
									grid._trigger("afterCellUpdate", null, { cell: currentCell });
								}
							}
						}
					} else {
						// ESC key
						result = true;
					}

					if (result) {
						args = {
							cell: currentCell,
							event: e,
							handled: false
						};

						grid._trigger("afterCellEdit", null, args);

						if (!args.handled) {
							result = defaultAfterCellEdit(grid, args);
						}

						if (result) {
							currentCell._isEdit(false);
						}

						if (grid.options.showRowHeader) {
							$(rowObj[0].cells[0]).children("div.wijmo-wijgrid-innercell").html("&nbsp;"); // remove ui-icon-pencil
						}

						window.setTimeout(function () {
							if (!grid.destroyed) {
								grid.element.focus();
								$(grid._view().focusableElement()).focus();
								currentCell.tableCell().focus();
							}
						}, 50);
					}
				}

				return result;
			};

			// private

			function defaultBeforeCellEdit(grid, args) {
				var leafOpt = args.cell.column(),
					result = false,
					value, $container, $input, len, kbEvent;

				if (leafOpt.dataIndex >= 0) {
					value = args.cell.value();
					result = true;

					try {
						$container = args.cell.container();

						if (leafOpt.dataType === "boolean") {
							$input = $container.children("input");
							$input.focus();
							if (args.event && args.event.type === "keypress") {
								$input.one("keyup", function (e) {
									if (e.which === $.ui.keyCode.SPACE) {
										e.preventDefault();
										$input[0].checked = !value;
									}
								});
							}
						} else {
							$input = $("<input />")
								.attr("type", "text")
								.addClass("wijgridinput wijmo-wijinput ui-state-focus")
								.bind("keydown", grid, checkBoxOrInputKeyDown);

							//the problem of inputing
							$input.bind(($.support.selectstart ? "selectstart" : "mousedown"), function (event) {
								event.stopPropagation();
							});

							if (args.event && args.event.type === "keypress" && args.event.which) {
								$input.val(String.fromCharCode(args.event.which));
							} else {
								switch (args.cell.column().dataType) {
									case "currency":
									case "number":
										if (value !== null) {
											$input.val(value); // ignore formatting
											break;
										}
										// fall through
									default:
										$input.val(grid._toStr(args.cell.column(), value));
										break;
								}
							}

							$container
								.empty()
								.append($input);

							// move caret to the end of the text
							len = $input.val().length;
							new $.wijmo.wijgrid.domSelection($input[0]).setSelection({ start: len, end: len });

							$input.focus();

							if ($.browser.msie) {
								setTimeout(function () {
									$input.focus();
								}, 0);
							}

							// FF issue: text does not track to the new position of the caret
							if ($.browser.mozilla && document.createEvent && $input[0].dispatchEvent) {
								kbEvent = document.createEvent("KeyboardEvent");
								kbEvent.initKeyEvent("keypress", false, true, null, false, false, false, false, 0, $.ui.keyCode.SPACE);
								$input[0].dispatchEvent(kbEvent);
								kbEvent = document.createEvent("KeyboardEvent");
								kbEvent.initKeyEvent("keypress", false, true, null, false, false, false, false, $.ui.keyCode.BACKSPACE, 0);
								$input[0].dispatchEvent(kbEvent);
							}
						}
					}
					catch (ex) {
						alert(ex.message);
						result = false;
					}
				}

				return result;
			}

			function defaultAfterCellEdit(grid, args) {
				var leafOpt = args.cell.column(),
					result = false,
					$container, cellValue, dataRow, sourceDataRow, input;

				if (leafOpt.dataIndex >= 0) {
					result = true;

					try {
						$container = args.cell.container();
						cellValue = grid._toStr(leafOpt, args.cell.value());

						dataRow = grid.dataTable[args.cell.rowIndex()];
						sourceDataRow = grid.data()[dataRow.originalRowIndex];
						if (leafOpt.dataType === "boolean") {
							input = $container.children("input");

							if (cellValue === "true") {
								input.attr("checked", "checked");
							}
							else {
								input.removeAttr("checked");
							}
						}
						else {
							grid.cellFormatter.format($container, leafOpt, cellValue, dataRow.rowType, sourceDataRow);
						}
					}
					catch (ex) {
						alert("defaultAfterCellEdit: " + ex.message);
						result = false;
					}
				}

				return result;
			}

			function checkBoxOrInputKeyDown(args) {
				if (args.which === $.ui.keyCode.ENTER) { // stop editing when Enter key is pressed
					var grid = args.data;

					if (grid) {
						grid._endEditInternal(args);
						return false; // prevent submit behaviour.
					}
				}
			}

			function getCellValue(gridView, currentCell) {
				var $input = currentCell.container().find(":input:first"),
					result = null;

				if ($input.length) {
					result = ($input.attr("type") === "checkbox")
						? $input[0].checked
						: $input.val();

					result = gridView._parse(currentCell.column(), result);
				}

				return result;
			}

			// private *
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {

		resizer: function (gridView) {
			var _elements = [],
				_gap = 10,
				_step = 1,
				_evntFormat = "{0}." + gridView.widgetName + ".resizer",
				_inProgress = false,
				_hoveredField = null,
				_docCursor,
				_startLocation = null,
				_lastLocation = null,
				_proxy = null;

			this.addElement = function (c1basefield) {
				if (c1basefield && c1basefield.element) {
					c1basefield.element
					.bind(eventKey("mousemove"), _onMouseMove)
					.bind(eventKey("mousedown"), _onMouseDown)
					.bind(eventKey("mouseout"), _onMouseOut);

					_elements.push(c1basefield);
				}
			};

			this.dispose = function () {
				$.each(_elements, function (index, c1basefield) {
					c1basefield.element
						.unbind(eventKey("mousemove"), _onMouseMove)
						.unbind(eventKey("mousedown"), _onMouseDown)
						.unbind(eventKey("mouseout"), _onMouseOut);
				});

				detachDocEvents();
			};

			this.inProgress = function () {
				return _inProgress;
			};

			function _onMouseMove(e) {
				if (!_inProgress) {
					var hoveredField = getFieldByPos({ x: e.pageX, y: e.pageY });
					if (hoveredField && hoveredField._canSize() && gridView._canInteract()) {
						hoveredField.element.css("cursor", "e-resize");
						//hoveredField.element.find("> a").css("cursor", "e-resize");
						_hoveredField = hoveredField;
						// prevent frozener from taking effect
						e.stopPropagation();
					} else {
						_onMouseOut(e);
					}
				}
			}

			function _onMouseOut(e) {
				if (!_inProgress) {
					if (_hoveredField) {
						_hoveredField.element.css("cursor", "");
						//_hoveredField.element.find("> a").css("cursor", "");
						_hoveredField = null;
					}
				}
			}

			function _onMouseDown(e) {
				_hoveredField = getFieldByPos({ x: e.pageX, y: e.pageY });
				if (_hoveredField && _hoveredField._canSize() && gridView._canInteract()) {
					try {
						_hoveredField.element.css("cursor", "");
						// _hoveredField.element.find("> a").css("cursor", "");

						_docCursor = document.body.style.cursor;
						document.body.style.cursor = "e-resize";
						_startLocation = _lastLocation = $.wijmo.wijgrid.bounds(_hoveredField.element);

						_proxy = $("<div class=\"wijmo-wijgrid-resizehandle ui-state-highlight\">&nbsp;</div>");

						var visibleAreaBounds = gridView._view().getVisibleAreaBounds();

						_proxy.css({ "left": e.pageX, "top": _startLocation.top,
							"height": visibleAreaBounds.height + visibleAreaBounds.top - _startLocation.top
						});

						$(document.body).append(_proxy);
					}
					finally {
						attachDocEvents();
						_inProgress = true;
						// prevent frozener from taking effect
						e.stopPropagation();
					}
				}
			}

			function _onDocumentMouseMove(e) {
				var deltaX = _step * Math.round((e.pageX - _lastLocation.left) / _step);

				_lastLocation = { left: _lastLocation.left + deltaX, top: e.pageY };
				_proxy.css("left", _lastLocation.left);
			}

			function _onDocumentMouseUp(e) {
				try {
					document.body.style.cursor = _docCursor;

					// destroy proxy object
					_proxy.remove();

					if (_startLocation !== _lastLocation) {
						gridView._fieldResized(_hoveredField, _startLocation.width, _lastLocation.left - _startLocation.left);
					}
				}
				finally {
					_hoveredField = null;
					_proxy = null;
					detachDocEvents();
					_inProgress = false;
				}
			}

			function _onSelectStart(e) {
				e.preventDefault();
			}

			function attachDocEvents() {
				if (!_inProgress) {
					$(document)
						.bind(eventKey("mousemove"), _onDocumentMouseMove)
						.bind(eventKey("mouseup"), _onDocumentMouseUp);

					$(document.body).disableSelection();

					if ($.browser.msie) {
						$(document.body).bind("selectstart", _onSelectStart);
					}
				}
			}

			function detachDocEvents() {
				if (_inProgress) {
					$(document)
						.unbind(eventKey("mousemove"), _onDocumentMouseMove)
						.unbind(eventKey("mouseup"), _onDocumentMouseUp);

					$(document.body).enableSelection();
					if ($.browser.msie) {
						$(document.body).unbind("selectstart", _onSelectStart);
					}
				}
			}

			function getFieldByPos(mouse) {
				var i, len, c1basefield, bounds, res;

				for (i = 0, len = _elements.length; i < len; i++) {
					c1basefield = _elements[i];
					bounds = $.wijmo.wijgrid.bounds(c1basefield.element);

					res = $.ui.isOver(mouse.y, mouse.x,
					bounds.top, bounds.left + bounds.width - _gap,
					bounds.height, _gap);

					if (res) {
						return c1basefield;
					}
				}

				return null;
			}

			function eventKey(eventType) {
				return $.wijmo.wijgrid.stringFormat(_evntFormat, eventType);
			}
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {

		frozener: function (gridView) {
			var _vHeaderLen, _hHeaderLen, _vIndex, _hIndex,
				_evntFormat = "{0}." + gridView.widgetName + ".frozener",
				_inProgress = false,
				_docCursor,
				_startVLocation = null,
				_startHLocation = null,
				_lastVLocation = null,
				_lastHLocation = null,
				_vBar = $("<div class=\"wijmo-wijgrid-frozener-v ui-widget-header\"></div>"),
				_hBar = $("<div class=\"wijmo-wijgrid-frozener-h ui-widget-header\"></div>"),
				_vProxy = null,
				_hProxy = null,
				_outerDiv = gridView.outerDiv.find(".wijmo-wijgrid-fixedview"),
				_gap = 10;

			this.refresh = function () {
				this.dispose();
				this.addVElement(gridView._getStaticIndex(false));
				this.addHElement(gridView._getStaticIndex(true));
				this.attachDivEvent();
			};

			this.attachDivEvent = function () {
				_outerDiv
					.bind("mousemove", _onGridMouseMove)
					.bind("mouseout", _onGridMouseOut)
					.bind("mousedown", _onGridMouseDown);
			};

			this.addVElement = function (columnIndex) {
				var size = $.wijmo.wijgrid.bounds(_outerDiv.find(".wijmo-wijgrid-split-area-nw")),
					containerSize = $.wijmo.wijgrid.bounds(_outerDiv),
					visibleBounds = gridView._view().getVisibleAreaBounds(),
					barLeft = size.left + size.width;

				if (barLeft <= visibleBounds.left + visibleBounds.width) {
					_vBar
						.css({ "left": barLeft - containerSize.left - 1, "top": size.top - containerSize.top,
								"width": "0px",
								"height": visibleBounds.height + visibleBounds.top - size.top
						})
						.appendTo(_outerDiv);

					_vHeaderLen = gridView._getRealStaticColumnIndex(true);
					_vIndex = columnIndex;
				}
			};

			this.addHElement = function (rowIndex) {
				var size = $.wijmo.wijgrid.bounds(_outerDiv.find(".wijmo-wijgrid-split-area-nw")),
					containerSize = $.wijmo.wijgrid.bounds(_outerDiv),
					visibleBounds = gridView._view().getVisibleAreaBounds(),
					barTop = size.top + size.height;

				if (barTop <= visibleBounds.top + visibleBounds.height) {
					_hBar
						.css({ "left": size.left - containerSize.left, "top": barTop - containerSize.top - 1,
								"width": visibleBounds.width + visibleBounds.left - size.left,
								"height": "0px"
						})
						.appendTo(_outerDiv);

					_hHeaderLen = gridView._getRealStaticRowIndex(true);
					_hIndex = rowIndex;
				}
			};

			this.dispose = function () {
				_vBar.remove();

				_hBar.remove();

				_outerDiv
					.unbind("mousemove", _onGridMouseMove)
					.unbind("mouseout", _onGridMouseOut)
					.unbind("mousedown", _onGridMouseDown);

				detachDocEvents();
			};

			this.inProgress = function () {
				return _inProgress;
			};

			function _onGridMouseMove (e) {
				var size, center, visibleBounds = gridView._view().getVisibleAreaBounds();
				if (!_inProgress) {
					if (gridView._canInteract()
						&& $.ui.isOver(
										e.pageY, e.pageX,
										visibleBounds.top, visibleBounds.left,
										visibleBounds.height, visibleBounds.width)) {
						size = $.wijmo.wijgrid.bounds(_vBar);
						center = size.left + size.width / 2;
						if (Math.abs(e.pageX - center) < _gap) {
							_outerDiv.css("cursor", "pointer");
							return;
						}
						size = $.wijmo.wijgrid.bounds(_hBar);
						center = size.top + size.height / 2;
						if (Math.abs(e.pageY - center) < _gap) {
							_outerDiv.css("cursor", "pointer");
							return;
						}
						_onGridMouseOut(e);
					}
				}
			}

			function _onGridMouseOut (e) {
				if (!_inProgress) {
					_outerDiv.css("cursor", "");
				}
			}

			function _onGridMouseDown (e) {
				var size, center, staticHeaderRowIndex, visibleBounds = gridView._view().getVisibleAreaBounds();
				if (gridView._canInteract()
					&& $.ui.isOver(
									e.pageY, e.pageX,
									visibleBounds.top, visibleBounds.left,
									visibleBounds.height, visibleBounds.width)) {
					size = $.wijmo.wijgrid.bounds(_vBar);
					center = size.left + size.width / 2;
					if (Math.abs(e.pageX - center) < _gap) {
						if (_vIndex === -1) {
							_startVLocation = _lastVLocation = -1;
						} else {
							_startVLocation = _lastVLocation = gridView._getRealStaticColumnIndex() - _vHeaderLen;
						}

						_vProxy = $("<div class=\"wijmo-wijgrid-resizehandle ui-widget-header\"></div>");

						e.data = { bVertical: true };
						//showArrow(e);

						$(document.body).append(_vProxy);
					} else {
						size = $.wijmo.wijgrid.bounds(_hBar);
						center = size.top + size.height / 2;
						if (Math.abs(e.pageY - center) < _gap) {
							if (_hIndex === -1) {
								_startHLocation = _lastHLocation = -1;
							} else {
								_startHLocation = _lastHLocation = gridView._getRealStaticRowIndex() - _hHeaderLen;
							}

							_hProxy = $("<div class=\"wijmo-wijgrid-resizehandle ui-widget-header\"></div>");

							e.data = { bVertical: false };
							//showArrow(e);

							$(document.body).append(_hProxy);
						}
					}

					if (e.data) {
						_outerDiv.css("cursor", "");
						_docCursor = document.body.style.cursor;
						document.body.style.cursor = "pointer";

						attachDocEvents(e.data);
						_inProgress = true;
					}
				}
			}

			function _onDocumentMouseMove(e) {
				var superPanel = gridView._view()._getSuperPanel();
				if (e.data.bVertical && superPanel.options.hScroller.scrollValue) {
					superPanel.hScrollTo(0);
				} else if (!e.data.bVertical && superPanel.options.vScroller.scrollValue) {
					superPanel.vScrollTo(0);
				}
				showArrow(e);
			}

			function _onDocumentMouseUp(e) {
				try {
					document.body.style.cursor = _docCursor;

					// destroy proxy object
					if (e.data.bVertical) {
						_vProxy.remove();

						if (_startVLocation !== _lastVLocation) {
							gridView.option("staticColumnIndex", _lastVLocation);
						}
					} else {
						_hProxy.remove();

						if (_startHLocation !== _lastHLocation) {
							gridView.option("staticRowIndex", _lastHLocation);
						}
					}
				}
				finally {
					if (e.data.bVertical) {
						_vProxy = null;
					} else {
						_hProxy = null;
					}
					detachDocEvents();
					_inProgress = false;
				}
			}

			function _onSelectStart(e) {
				e.preventDefault();
			}

			function attachDocEvents(data) {
				if (!_inProgress) {
					if (data.bVertical) {
						$(document)
							.bind(eventKey("mousemove"), { bVertical: true }, _onDocumentMouseMove)
							.bind(eventKey("mouseup"), { bVertical: true }, _onDocumentMouseUp);
					} else {
						$(document)
							.bind(eventKey("mousemove"), { bVertical: false }, _onDocumentMouseMove)
							.bind(eventKey("mouseup"), { bVertical: false }, _onDocumentMouseUp);
					}

					$(document.body).disableSelection();

					if ($.browser.msie) {
						$(document.body).bind("selectstart", _onSelectStart);
					}
				}
			}

			function detachDocEvents() {
				if (_inProgress) {
					$(document)
						.unbind(eventKey("mousemove"), _onDocumentMouseMove)
						.unbind(eventKey("mouseup"), _onDocumentMouseUp);

					$(document.body).enableSelection();
					if ($.browser.msie) {
						$(document.body).unbind("selectstart", _onSelectStart);
					}
				}
			}

			function showArrow(e) {
				var currentElement,
					currentSize,
					centerXOrY,
					bLeftOrTop,
					currentIdx,
					prevIdx,
					leftPosition,
					topPosition,
					visibleBounds = gridView._view().getVisibleAreaBounds();
				if (e.data.bVertical) {
					currentSize = $.wijmo.wijgrid.bounds(_vBar);
					centerXOrY = currentSize.left + currentSize.width / 2;
					if (Math.abs(e.pageX - centerXOrY) < _gap) {
						_lastVLocation = _startVLocation;
						_vProxy.hide();
						return;
					}
					currentElement = getFieldByPos({ x: e.pageX, y: e.pageY });
					if (currentElement) {
						currentSize = $.wijmo.wijgrid.bounds(currentElement.element);
						centerXOrY = currentSize.left + currentSize.width / 2;
						currentIdx = currentElement.options.visLeavesIdx - _vHeaderLen;
						prevIdx = getPrevColumnIndex(currentIdx);
						bLeftOrTop = e.pageX < centerXOrY ? (prevIdx !== _startVLocation) : (currentIdx === _startVLocation);
						leftPosition = bLeftOrTop ? currentSize.left : currentSize.left + currentSize.width;
						if (!$.ui.isOverAxis(leftPosition,
											visibleBounds.left - 1,
											visibleBounds.width + 2)) {
							return;
						}
						_lastVLocation = bLeftOrTop ? prevIdx : currentIdx;
						_vProxy.show().css({"left": leftPosition, "top": currentSize.top,
									"width": 3,
									"height": visibleBounds.height + visibleBounds.top - currentSize.top});
					}
				} else {
					currentSize = $.wijmo.wijgrid.bounds(_hBar);
					centerXOrY = currentSize.top + currentSize.height / 2;
					if (Math.abs(e.pageY - centerXOrY) < _gap) {
						_lastHLocation = _startHLocation;
						_hProxy.hide();
						return;
					}
					currentElement = getRowByPos({ x: e.pageX, y: e.pageY });
					if (currentElement) {
						currentSize = $.wijmo.wijgrid.bounds(currentElement);
						centerXOrY = currentSize.top + currentSize.height / 2;
						currentIdx = gridView._view().getAbsoluteRowIndex(currentElement) - _hHeaderLen;
						prevIdx = getPrevRowIndex(currentIdx);
						bLeftOrTop = e.pageY < centerXOrY ? (prevIdx !== _startHLocation) : (currentIdx === _startHLocation);
						topPosition = bLeftOrTop ? currentSize.top : currentSize.top + currentSize.height;
						if (!$.ui.isOverAxis(topPosition,
											visibleBounds.top - 1,
											visibleBounds.height + 2)) {
							return;
						}
						_lastHLocation = bLeftOrTop ? prevIdx : currentIdx;
						_hProxy.show().css({"left": currentSize.left, "top": topPosition,
									"width": visibleBounds.width + visibleBounds.left - currentSize.left,
									"height": 3});
					}
				}
			}

			function getPrevColumnIndex(index) {
				return index > -1 ? index - 1 : -1;
			}

			function getPrevRowIndex(index) {
				return index > -1 ? index - 1 : -1;
			}

			function getFieldByPos(mouse) {
				var columns = gridView.columns(),
				i = 0,
				len = columns.length,
				colWidget, o, bounds, res;

				for (; i < len; i++) {
					colWidget = columns[i];
					o = colWidget.options;

					if (o.visible && o.parentVis && o.isLeaf) {
						bounds = $.wijmo.wijgrid.bounds(colWidget.element);

						res = $.ui.isOverAxis(mouse.x, bounds.left, bounds.width);

						if (res) {
							return colWidget;
						}
					}
				}
				
				return null;
			}

			function getRowByPos(mouse) {
				var rows = gridView._rows(),
					rowsLength = rows.length(),
					index = 0,
					row,
					bounds,
					res;
				for (;index < rowsLength; index++) {
					row = rows.item(index)[0];
					bounds = $.wijmo.wijgrid.bounds($(row));
					res = $.ui.isOverAxis(mouse.y, bounds.top, bounds.height);
					if (res) {
						return row;
					}
				}
				return null;
			}

			function eventKey(eventType) {
				return $.wijmo.wijgrid.stringFormat(_evntFormat, eventType);
			}
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		cellFormatterHelper: function () {
			this.format = function ($container, column, formattedValue, rowInfo) {
				if (rowInfo.type & $.wijmo.wijgrid.rowType.footer) {
					if (column.aggregate && (column.aggregate !== "none")) {
						formattedValue = $.wijmo.wijgrid.stringFormat(column.footerText || "{0}", column._totalsValue || "");
					} else {
						formattedValue = column.footerText || column._footerTextDOM || "";
					}
				}

				var useDefault = true,
					defaultFormatter = null,
					args = {
						$container: $container,
						column: column,
						formattedValue: formattedValue,
						row: rowInfo,
						afterDefaultCallback: null
					};

				if ($.isFunction(column.cellFormatter)) {
					useDefault = !column.cellFormatter(args);
				}

				if (useDefault) {
					switch (column.dataType) {
						case "boolean":
							defaultFormatter = boolFormatter;
							break;

						default:
							defaultFormatter = textFormatter;
					}

					if (defaultFormatter) {
						defaultFormatter(args);

						if ($.isFunction(args.afterDefaultCallback)) {
							args.afterDefaultCallback(args);
						}
					}
				}
			};

			// * private
			function textFormatter(args) {
				switch (args.row.type) {
					case $.wijmo.wijgrid.rowType.filter:
						defFormatFilterCell(args);
						break;

					default:
						args.$container.html(args.formattedValue ? args.formattedValue : "&nbsp;");
				}
			}

			function boolFormatter(args) {
				var grid, allowEditing, disableStr = "disabled='disabled'", targetElement, currentCell,
					$rt = $.wijmo.wijgrid.rowType;

				switch (args.row.type) {
					case $rt.data:
					case $rt.data | $rt.dataAlt:
						grid = args.column.owner;
						allowEditing = grid.options.allowEditing && (args.column.readOnly !== true);

						if (allowEditing) {
							disableStr = "";
						}

						if (grid._parse(args.column, args.row.data[args.column.dataKey]) === true) {
							args.$container.html("<input class='wijgridinput' type='checkbox' checked='checked' " + disableStr + " />");
						} else {
							args.$container.html("<input class='wijgridinput' type='checkbox' " + disableStr + " />");
						}

						if (allowEditing) {
							args.$container.children("input").bind("mousedown", function (e) {
								targetElement = args.$container.parent()[0];
								currentCell = grid.currentCell();
								if (currentCell.tableCell() !== targetElement) {
									grid._onClick({ target: targetElement });
								}
								if (!currentCell._isEdit()) {
									grid.beginEdit();
								}
							}).bind("keydown", function (e) {
								if (e.which === $.ui.keyCode.ENTER) {
									grid._endEditInternal(e);
									return false;
								}
							});
						}
						break;

					default:
						textFormatter(args);
				}
			}

			function defFormatFilterCell(args) {
				if ((args.column.dataIndex >= 0) && !args.column.isBand && args.column.showFilter) {
					args.$container.html("<div class=\"wijmo-wijgrid-filter ui-widget ui-state-default ui-corner-all\"><input type=\"text\" class=\"wijmo-wijgrid-filter-input\" style=\"width:1px\" /><a class=\"wijmo-wijgrid-filter-trigger ui-corner-right ui-state-default\" href=\"#\"><span class=\"ui-icon ui-icon-triangle-1-s\"></span></a></div>");
				} else {
					args.$container.html("&nbsp;");
				}
			}

			// * private
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		dragAndDropHelper: function (wijgrid) {
			var _scope_guid = "scope_" + new Date().getTime(),
				_$bottomArrow = null,
				_$topArrow = null,
				_droppableWijField = null, // to use inside the draggable.drag event.
				_dragEnd = false,
				_dropTargetRedirected, // handles the situation when draggable is moved over the non-empty group area, in this case we assume the rightmost header in the group area as droppable instead of group area itself.
				_wrapHtml = "<div class=\"ui-widget wijmo-wijgrid ui-widget-content ui-corner-all\">" +
								"<table class=\"wijmo-wijgrid-root wijmo-wijgrid-table\">" +
									"<tr class=\"wijmo-wijgrid-headerrow\">" +
									"</tr>" +
								 "</table>" +
							"</div>";

			this.attachGroupArea = function (element) {
				var draggedWijField;
				element.droppable({
					scope: _scope_guid,
					tolerance: "pointer",
					greedy: true,

					accept: function (draggable) {
						if (wijgrid.options.allowColMoving) {
							draggedWijField = _getWijFieldInstance(draggable);

							if (draggedWijField) {
								// The rightmost column header in the the group area can't be dragged to the end of the group area again.
								if ((draggedWijField instanceof $.wijmo.c1groupedfield) && (draggedWijField.options.groupedIndex === wijgrid._field("groupedColumns").length - 1)) {
									return false;
								}

								return !draggedWijField.options.isBand && (draggedWijField.options.groupedIndex === undefined || (draggedWijField instanceof $.wijmo.c1groupedfield));
							}
						}
						return false;
					},

					drop: function (e, ui) {
						if (!_isInElement(e, ui.draggable) && (draggedWijField = _getWijFieldInstance(ui.draggable))) {
							_dragEnd = true;
						}
					},

					over: function (e, ui) {
						var cnt = wijgrid._field("groupedWidgets").length;

						_dropTargetRedirected = (cnt > 0);
						_droppableWijField = (cnt > 0)
							? wijgrid._field("groupedWidgets")[cnt - 1] // use the rightmost header as a drop target
							: element; // special case, the drop target is the group area itself

						element.data("thisDroppableWijField", _droppableWijField);
					},

					out: function (e, ui) {
						if (_droppableWijField === element.data("thisDroppableWijField")) {
							_droppableWijField = null;
						}

						//if (draggedWijField = _getWijFieldInstance(ui.draggable)) {
						//	_hideArrows();
						//}
					}
				});
			};

			this.attach = function (wijField) {
				var element, draggedWijField;

				if (!wijField || !(element = wijField.element)) {
					return;
				}

				element
				.draggable({
					helper: function (e) {
						if (wijField instanceof $.wijmo.c1groupedfield) {
							return element
								.clone()
								.addClass("wijmo-wijgrid-dnd-helper");
						} else {
							return element
								.clone()
								.wrap(_wrapHtml)
								.width(element.width())
								.height(element.height())
								.closest(".wijmo-wijgrid")
								.addClass("wijmo-wijgrid-dnd-helper");

							/*return element
							.clone()
							.width(element.width())
							.height(element.height())
							.addClass("wijmo-wijgrid-dnd-helper");*/
						}
					},

					appendTo: "body",
					//cursor: "pointer",
					scope: _scope_guid,

					drag: function (e, ui) {
						_hideArrows();

						if (_droppableWijField && !_isInElement(e, element)) {
							// indicate insertion position

							var $arrowsTarget = _droppableWijField.element;
							if (!$arrowsTarget) { // _droppableWijField is the group area element
								$arrowsTarget = _droppableWijField;
							}

							_showArrows($arrowsTarget, _getPosition(wijField, _droppableWijField, e, ui));
						}
					},

					start: function (e, ui) {
						if (wijgrid._canInteract() && wijgrid.options.allowColMoving && !wijgrid._field("resizer").inProgress()) {
							//return (wijField._canDrag() === true);

							var column = wijField.options,
								travIdx = wijField.options.travIdx,
								dragInGroup = (wijField instanceof $.wijmo.c1groupedfield),
								dragSource = dragInGroup ? "groupArea" : "columns";

							if (dragInGroup) {
								column = $.wijmo.wijgrid.search(wijgrid.columns(), function (test) {
									return test.options.travIdx === travIdx;
								});

								column = (!column.found) // grouped column is invisible?
									? $.wijmo.wijgrid.getColumnByTravIdx(wijgrid.options.columns, travIdx).found
									: column.found.options;
							}

							if (wijField._canDrag() && wijgrid._trigger("columnDragging", null, { drag: column, dragSource: dragSource })) {
								wijgrid._trigger("columnDragged", null, { drag: column, dragSource: dragSource });
								return true;
							}
						}

						return false;
					},

					stop: function (e, ui) {
						_hideArrows();

						try {
							if (_dragEnd) {
								if (!_droppableWijField.element) { // _droppableWijField is the group area element
									wijgrid._handleDragnDrop(wijField.options.travIdx,
											-1,
											"left",
											wijField instanceof $.wijmo.c1groupedfield,
											true
										);
								} else {
									wijgrid._handleDragnDrop(wijField.options.travIdx,
										_droppableWijField.options.travIdx,
										_getPosition(wijField, _droppableWijField, e, ui),
										wijField instanceof $.wijmo.c1groupedfield,
										_droppableWijField instanceof $.wijmo.c1groupedfield
									);
								}
							}
						}
						finally {
							_droppableWijField = null;
							_dragEnd = false;
						}
					}
				}) // ~draggable

				.droppable({
					hoverClass: "ui-state-hover",
					scope: _scope_guid,
					tolerance: "pointer",
					greedy: true,

					accept: function (draggable) {
						if (wijgrid.options.allowColMoving) {
							if (element[0] !== draggable[0]) { // different DOM elements
								draggedWijField = _getWijFieldInstance(draggable); // dragged column

								if (draggedWijField) {
									return draggedWijField._canDropTo(wijField);
								}
							}
						}
						return false;
					},

					drop: function (e, ui) {
						if (draggedWijField = _getWijFieldInstance(ui.draggable)) {
							// As droppable.drop fires before draggable.stop, let draggable to finish action.
							// Otherwise exception is thrown as during re-rendering element bound to draggable will be already deleted.
							_dragEnd = true;

							// an alternative:
							//window.setTimeout(function () {
							//wijgrid._handleDragnDrop(draggedWijField, wijField, _getPosition(draggedWijField, wijField, e, ui));
							//}, 100);
						}
					},

					over: function (e, ui) {
						_dropTargetRedirected = false;
						_droppableWijField = wijField;

						// to track when droppable.over event of other element fires before droppable.out of that element.
						element.data("thisDroppableWijField", _droppableWijField);
					},

					out: function (e, ui) {
						if (_droppableWijField === wijField.element.data("thisDroppableWijField")) {
							_droppableWijField = null;
						}

						//if (draggedWijField = _getWijFieldInstance(ui.draggable)) {
						//	_hideArrows();
						//}
					}
				}); // ~droppable
			};

			this.detach = function (wijField) {
				var element;

				if (wijField && (element = wijField.element)) {
					if (element.data("draggable")) {
						element.draggable("destroy");
					}

					if (element.data("droppable")) {
						element.droppable("destroy");
					}
				}
			};

			this.dispose = function () {
				if (_$topArrow) {
					_$topArrow.remove();
					_$topArrow = null;
				}

				if (_$bottomArrow) {
					_$bottomArrow.remove();
					_$bottomArrow = null;
				}
			};

			// private
			function _getWijFieldInstance(draggable) {
				var widgetName = draggable.data($.wijmo.c1basefield.prototype._data$prefix + "widgetName");
				if (!widgetName) {
					return draggable.data($.wijmo.c1groupedfield.prototype._data$prefix);
				} else {
					return draggable.data(widgetName);
				}
			}

			// position: "left", "right", "center"
			function _showArrows($element, position) {
				_topArrow()
					.show()
					.position({
						my: "center",
						at: position + " top",
						of: $element
					});

				_bottomArrow()
					.show()
					.position({
						my: "center",
						at: position + " bottom",
						of: $element
					});
			}

			function _hideArrows() {
				_topArrow().hide();
				_bottomArrow().hide();
			}

			function _topArrow() {
				if (!_$topArrow) {
					_$topArrow = $("<div />")
						.addClass("wijmo-wijgrid-dnd-arrow-top")
						.append($("<span />").addClass("ui-icon ui-icon-arrowthick-1-s"))
						.hide()
						.appendTo(document.body);
				}

				return _$topArrow;
			}

			function _bottomArrow() {
				if (!_$bottomArrow) {
					_$bottomArrow = $("<div />")
						.addClass("wijmo-wijgrid-dnd-arrow-bottom")
						.append($("<span />").addClass("ui-icon ui-icon-arrowthick-1-n"))
						.hide()
						.appendTo(document.body);
				}

				return _$bottomArrow;
			}

			function _isInElement(e, element) {
				var bounds = $.wijmo.wijgrid.bounds(element, false);
				return ((e.pageX > bounds.left && e.pageX < bounds.left + bounds.width) && (e.pageY > bounds.top && e.pageY < bounds.top + bounds.height));
			}

			function _getPosition(drag, drop, e, dragui) {
				if (!drop.element) { // drop is the group area element
					return "left";
				}

				if (_dropTargetRedirected) {
					return "right";
				}

				var bounds = $.wijmo.wijgrid.bounds(drop.element, false),
					sixth = bounds.width / 6,
					centerX = bounds.left + (bounds.width / 2),
					result = "right",
					distance;

				if (e.pageX < centerX) {
					result = "left";
				}

				if (drop instanceof $.wijmo.c1groupedfield) { // drag is moved over a grouped column
					if (drag instanceof $.wijmo.c1groupedfield) { // drag is a grouped column too
						distance = drop.options.groupedIndex - drag.options.groupedIndex;

						if (Math.abs(distance) === 1) {
							result = (distance < 0)
								? "left"
								: "right";
						}
					}

					return result;
				}

				// both drag and drop are non-grouped columns
				distance = drop.options.linearIdx - drag.options.linearIdx;

				if (drop.options.isBand &&
					(drag.options.parentIdx !== drop.options.travIdx) && // drag is not an immediate child of drop
					(Math.abs(e.pageX - centerX) < sixth)) {
					return "center";
				}

				// drag and drop are contiguous items of the same level
				if (drag.options.parentIdx === drop.options.parentIdx && Math.abs(distance) === 1) {
					result = (distance < 0)
						? "left"
						: "right";
				}

				return result;
			}
			// ~private
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		cellStyleFormatterHelper: function (wijgrid) {
			if (!wijgrid) {
				throw "invalid arguments";
			}

			this.format = function ($cell, cellIndex, column, rowInfo, state, cellAttr, cellStyle) {
				var $rs = $.wijmo.wijgrid.renderState,
					$rt = $.wijmo.wijgrid.rowType,
					rowType = rowInfo.type,
					args,
					groupRowCellInfo = null;

				if (cellIndex === 0 && wijgrid.options.showRowHeader) {
					column = null;
				}

				if (rowType === $rt.groupHeader || rowType === $rt.groupFooter) {
					column = null;

					if (cellAttr && (groupRowCellInfo = cellAttr.groupInfo)) {
						column = wijgrid._field("leaves")[groupRowCellInfo.leafIndex]; // replace "column" with the one associated with the $cell's content
						delete cellAttr.groupInfo;
					}
				}

				args = {
					$cell: $cell,
					state: state,
					row: rowInfo,
					column: column,
					_cellIndex: cellIndex,
					_purpose: groupRowCellInfo
						? groupRowCellInfo.purpose
						: undefined
				};

				if (state === $rs.rendering) {
					renderingStateFormatter(args, cellAttr, cellStyle);
				} else {
					currentStateFormatter(args, state & $rs.current);
					//hoveredStateFormatter(args, state & $rs.hovered);
					selectedStateFormatter(args, state & $rs.selected);
				}

				if ($.isFunction(wijgrid.options.cellStyleFormatter)) {
					wijgrid.options.cellStyleFormatter(args);
				}
			};

			// private ---

			function renderingStateFormatter(args, cellAttr, cellStyles) {
				var $rt = $.wijmo.wijgrid.rowType,
					key, value,
					leaf = args.column,
					rowType = args.row.type;

				switch (rowType) {
					case $rt.header:
						args.$cell.addClass("wijgridth");
						break;

					default:
						args.$cell.addClass("wijgridtd");
				}

				// copy attributes
				if (cellAttr) {
					for (key in cellAttr) {
						if (cellAttr.hasOwnProperty(key)) {
							value = cellAttr[key];

							if ((key === "colSpan" || key === "rowSpan") && !(value > 1)) {
								continue;
							}

							if (key === "class") {
								args.$cell.addClass(value);
							} else {
								args.$cell.attr(key, value);
							}
						}
					}
				}

				// copy inline css
				if (cellStyles) {
					for (key in cellStyles) {
						if (cellStyles.hasOwnProperty(key)) {
							if (key === "paddingLeft") { // groupIndent
								args.$cell.children(".wijmo-wijgrid-innercell").css(key, cellStyles[key]);
								continue;
							}
							args.$cell.css(key, cellStyles[key]);
						}
					}
				}

				if (args._cellIndex === 0 && wijgrid.options.showRowHeader) {
					args.$cell
						.attr({ "role": "rowheader", "scope": "row" })
						.addClass("ui-state-default ui-widget-content wijmo-wijgrid-rowheader");
				} else {
					switch (rowType) {
						case ($rt.header):
							args.$cell.attr({ "role": "columnheader", "scope": "col" });
							break;
						case ($rt.footer):
							args.$cell.attr({ "role": "columnfooter", "scope": "col" });
							break;
						default:
							args.$cell.attr("role", "gridcell");
					}
				}

				//if ((rowType & $rt.data) === $rt.data) {
				if (rowType & $rt.data) {
					if (args._cellIndex >= 0 && leaf && leaf.dataParser) {
						args.$cell.attr("headers", escape(leaf.headerText));

						if (leaf.readOnly) {
							args.$cell.attr("aria-readonly", true);
						}

						if (leaf.dataIndex >= 0) {
							args.$cell.addClass("wijdata-type-" + (leaf.dataType || "string"));
						}
					}
				}

				if (rowType === $rt.groupHeader || rowType === $rt.groupFooter) {
					// append wijdata-type class only to the aggregate cells of the group row, not grouped cells.
					if (leaf && args._purpose === $.wijmo.wijgrid.groupRowCellPurpose.aggregateCell) {
						args.$cell.addClass("wijdata-type-" + (leaf.dataType || "string"));
					}
				}
			}

			function currentStateFormatter(args, add) {
				var $rt = $.wijmo.wijgrid.rowType;

				if (add) {
					args.$cell.addClass("ui-state-active");

					if (args.row.type === $rt.header) {
						args.$cell.addClass("wijmo-wijgrid-current-headercell");
					} else {
						args.$cell.addClass("wijmo-wijgrid-current-cell");
					}
				} else {
					args.$cell.removeClass("ui-state-active");

					if (args.row.type === $rt.header) {
						args.$cell.removeClass("wijmo-wijgrid-current-headercell");
					} else {
						args.$cell.removeClass("wijmo-wijgrid-current-cell");
					}
				}
			}

			function hoveredStateFormatter(args, add) {
				if (add) {
				} else {
				}
			}

			function selectedStateFormatter(args, add) {
				if (add) {
					args.$cell
						.addClass("ui-state-highlight")
						.attr("aria-selected", "true");
				} else {
					args.$cell
						.removeClass("ui-state-highlight")
						.removeAttr("aria-selected");
				}
			}

			// --- private
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		rowStyleFormatterHelper: function (wijgrid) {
			if (!wijgrid) {
				throw "invalid arguments";
			}

			this.format = function (rowInfo, rowAttr, rowStyle) {
				var $rs = $.wijmo.wijgrid.renderState,
					state = rowInfo.state,
					args = rowInfo;

				if (state === $rs.rendering) {
					renderingStateFormatter(args, rowAttr, rowStyle);
				} else {
					currentStateFormatter(args, state & $rs.current);
					hoveredStateFormatter(args, state & $rs.hovered);
					selectedStateFormatter(args, state & $rs.selected);
				}

				if ($.isFunction(wijgrid.options.rowStyleFormatter)) {
					wijgrid.options.rowStyleFormatter(args);
				}
			};

			// * private
			function renderingStateFormatter(args, rowAttr, rowStyle) {
				var className = "wijmo-wijgrid-row ui-widget-content",
					contentClass = "wijmo-wijgrid-row ui-widget-content",
					$rt = $.wijmo.wijgrid.rowType,
					key;

				args.$rows.attr("role", "row");

				// copy attributes
				if (rowAttr) {
					for (key in rowAttr) {
						if (rowAttr.hasOwnProperty(key)) {
							if (key === "class") {
								args.$rows.addClass(rowAttr[key]);
							} else {
								args.$rows.attr(key, rowAttr[key]);
							}
						}
					}
				}

				// copy inline css
				if (rowStyle) {
					for (key in rowStyle) {
						if (rowStyle.hasOwnProperty(key)) {
							args.$rows.css(key, rowStyle[key]);
						}
					}
				}

				switch (args.type & ~$rt.dataAlt) { // clear dataAlt modifier
					case ($rt.header):
						className = "wijmo-wijgrid-headerrow";
						break;

					case ($rt.data):
						className = contentClass + " wijmo-wijgrid-datarow";

						if (args.type & $rt.dataAlt) {
							className += " wijmo-wijgrid-alternatingrow";
						}

						break;

					case ($rt.emptyDataRow):
						className = contentClass + " wijmo-wijgrid-emptydatarow";
						break;

					case ($rt.filter):
						className = "wijmo-wijgrid-filterrow";
						break;

					case ($rt.groupHeader):
						className = contentClass + " wijmo-wijgrid-groupheaderrow";
						break;

					case ($rt.groupFooter):
						className = contentClass + " wijmo-wijgrid-groupfooterrow";
						break;

					case ($rt.footer):
						className = "wijmo-wijgrid-footerrow ui-state-highlight";
						break;

					default:
						throw $.wijmo.wijgrid.stringFormat("unknown rowType: {0}", args.row.type);
				}

				args.$rows.addClass(className);
			}

			function currentStateFormatter(args, flag) {
				if (wijgrid.options.showRowHeader) {
					// make deal with the row header cell
					if (flag) { // add formatting
						$(args.$rows[0].cells[0]).addClass("ui-state-active wijmo-wijgrid-current-rowheadercell");
					} else { // remove formatting
						$(args.$rows[0].cells[0]).removeClass("ui-state-active wijmo-wijgrid-current-rowheadercell");
					}
				}
			}

			function hoveredStateFormatter(args, flag) {
				if (flag) { // add formatting
					args.$rows.addClass("ui-state-hover");
				} else {  // remove formatting
					args.$rows.removeClass("ui-state-hover");
				}
			}

			function selectedStateFormatter(args, flag) {
				if (flag) { // add formatting
				} else { // remove formatting
				}
			}

			// private *
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {

		tally: function () {
			var _sum = 0,
				_sum2 = 0,
				_cntNumbers = 0,
				_cntStrings = 0,
				_max = 0,
				_min = 0,
				_minString,
				_maxString;

			this.add = function (value) {
				if (value === null || value === "") {
					return;
				}

				_cntStrings++;

				if (typeof (value) === "string") {

					if ((_minString === undefined) || (value < _minString)) {
						_minString = value;
					}

					if ((_maxString === undefined) || (value > _maxString)) {
						_maxString = value;
					}

					// value = _parseValue(value);
				}

				//if (!isNaN(value)) { // number
				if (typeof (value) === "number") {
					if (_cntNumbers === 0) {
						_min = value;
						_max = value;
					}

					_cntNumbers++;
					_sum += value;
					_sum2 += value * value;

					if (value < _min) {
						_min = value;
					}

					if (value > _max) {
						_max = value;
					}
				}
			};

			this.getValueString = function (column) {
				if (_cntNumbers) {
					var value = _getValue(column.aggregate),
						gridView = column.owner;

					return gridView._toStr(column, value);
				}

				if (_cntStrings) {
					// we only support max/min and count for strings
					switch (column.aggregate) {
						case "max":
							return _maxString;

						case "min":
							return _minString;

						case "count":
							return _cntStrings.toString();
					}
				}

				return "";
			};

			function _getValue(aggregate) {
				switch (aggregate) {
					case "average":
						return (_cntNumbers === 0)
							? 0
							: _sum / _cntNumbers;

					case "count":
						return _cntStrings;

					case "max":
						return _max;

					case "min":
						return _min;

					case "sum":
						return _sum;

					case "std":
						if (_cntNumbers <= 1) {
							return 0;
						}

						return Math.sqrt(_getValue("var"));

					case "stdPop":
						if (_cntNumbers <= 1) {
							return 0;
						}

						return Math.sqrt(_getValue("varPop"));

					case "var":
						if (_cntNumbers <= 1) {
							return 0;
						}

						return _getValue("varPop") * _cntNumbers / (_cntNumbers - 1);

					case "vapPop":
						if (_cntNumbers <= 1) {
							return 0;
						}

						var tmp = _sum / _cntNumbers;
						return _sum2 / _cntNumbers - tmp * tmp;
				}

				return 0;
			}
		}
	});
})(jQuery);(function ($) {
	"use strict";
	$.extend($.wijmo.wijgrid, {
		columnsGenerator: function (gridView) {
			this.generate = function (mode, dataStore, columns) {
				switch (mode) {
					case "append":
						_processAppendMode(dataStore, columns);
						break;

					case "merge":
						_processMergeMode(dataStore, columns);
						break;

					default:
						throw $.wijmo.wijgrid.stringFormat("Unsupported value: \"{0}\"", mode);
				}
			};

			function _processAppendMode(dataStore, columns) {
				var availableDataKeys = dataStore.getFieldNames(),
					i, len, leaf;

				for (i = 0, len = availableDataKeys.length; i < len; i++) {
					leaf = _createAutoField(availableDataKeys[i]);
					columns.push(leaf);
				}
			}

			function _processMergeMode(dataStore, columns) {
				var columnsHasNoDataKey = [],
					dataFields = dataStore.getFieldNames(),
					dataKeys = {},
					i, len, dataKey, key, leaf;

				for (i = 0, len = dataFields.length; i < len; i++) {
					dataKeys[key = dataFields[i]] = key;
				}

				$.wijmo.wijgrid.traverse(columns, function (column) {
					if (column.isLeaf && !column.isBand) {
						dataKey = column.dataKey;

						if ($.wijmo.wijgrid.validDataKey(dataKey)) {
							if (dataKeys[dataKey] !== undefined) {
								delete dataKeys[dataKey];
							}
						} else {
							if (dataKey !== null) { // don't linkup with any data field if dataKey is null
								columnsHasNoDataKey.push(column);
							}
						}
					}
				});

				if (columnsHasNoDataKey.length) {
					i = 0;
					for (dataKey in dataKeys) {
						if (dataKeys.hasOwnProperty(dataKey)) {
							leaf = columnsHasNoDataKey[i++];
							if (leaf) {
								leaf.dataKey = dataKeys[dataKey];
								delete dataKeys[dataKey];
							}
						}
					}
				}

				for (dataKey in dataKeys) {
					if (dataKeys.hasOwnProperty(dataKey)) {
						leaf = _createAutoField(dataKeys[dataKey]);
						columns.push(leaf);
					}
				}
			}

			function _createAutoField(dataKey) {
				return $.wijmo.wijgrid.createDynamicField({ dataKey: dataKey });
			}
		}
	});
})(jQuery);
/*globals $, Raphael, jQuery, document, window, Globalize*/
/*
*
* Wijmo Library 1.1.2
* http://wijmo.com/
*
* Copyright(c) ComponentOne, LLC.  All rights reserved.
* 
* Dual licensed under the Wijmo Commercial or GNU GPL Version 3 licenses.
* licensing@wijmo.com
* http://wijmo.com/license
*/

(function () {
	"use strict";
	/*
	Raphael.el.wijGetBBox = function () {
	var box = this.getBBox();
	if (Raphael.vml && this.type === 'text') {
	this.shape.style.display = "inline";
	box.width = this.shape.scrollWidth;
	box.height = this.shape.scrollHeight;
	}
	return box;
	};
	*/
	if (!window.Raphael) {
		return;
	}

	$.extend({
		round: function (val, digits) {
			/// Errors occur when using Math.round and toFixed() 
			/// because JavaScript's method of storing numbers is not perfect. 
			/// JavaScript uses a floating-point number format which cannot 
			/// store certain numbers "exactly". 
			/// In other words, some numbers are approximations.
			/// So if need accuracy, a workaround is required for rounding numbers.
			if (!val) {
				return 0;
			}
			//var value = Globalize.format(val, "N" + digits);
			//return Globalize.parseFloat(value);
			return Globalize.parseFloat(val.toFixed(digits), 10, Globalize.culture("en"));
		},
		toOADate: function (time) {
			var day = 24 * 60 * 60 * 1000,
				oaDate = time - new Date(1900, 0, 1) + 2 * day;

			return oaDate;
		},

		fromOADate: function (oaDate) {
			var day = 24 * 60 * 60 * 1000,
				time = new Date(oaDate - 2 * day +
					new Date(1900, 0, 1).getTime());

			return time;
		}
	});

	$.wijraphael = {

		isSVGElem: function (node) {
			var svgNS = "http://www.w3.org/2000/svg";
			return (node.nodeType === 1 && node.namespaceURI === svgNS);
		},

		//methods for jQuery extention
		addClass: function (ele, classNames) {
			classNames = classNames || '';

			$.each(ele, function () {
				if ($.wijraphael.isSVGElem(this)) {
					var node = this;
					$.each(classNames.split(/\s+/), function (i, className) {
						var classes = (node.className ?
							node.className.baseVal : node.getAttribute('class'));
						if ($.inArray(className, classes.split(/\s+/)) === -1) {
							classes += (classes ? ' ' : '') + className;

							if (node.className) {
								node.className.baseVal = classes;
							} else {
								node.setAttribute('class', classes);
							}
						}
					});
				} else {
					$(this).addClass(classNames);
				}
			});
		},

		clearRaphaelCache: function () {			
			Raphael.path2curve.cache = null;
			Raphael.path2curve.count = null;
			Raphael.parseTransformString.cache = null;
			Raphael.parseTransformString.count = null;
			Raphael.parsePathString.cache = null;
			Raphael.parsePathString.count = null;
			Raphael._pathToAbsolute.cache = null;
			Raphael._pathToAbsolute.count = null;
		},

		getPositionByAngle: function (cx, cy, r, angle) {
			var point = {},
				rad = Raphael.rad(angle);

			point.x = cx + r * Math.cos(-1 * rad);
			point.y = cy + r * Math.sin(-1 * rad);

			return point;
		},

		hasClass: function (ele, className) {
			if (!className || className.length === 0) {
				return false;
			}
			if ($.wijraphael.isSVGElem(ele)) {
				var cName = ele.className ?
						ele.className.baseVal : ele.getAttribute('class'),
					hasClass = false;

				$.each(cName.split(/\s+/), function (i, c) {
					if (c === className) {
						hasClass = true;
						return false;
					}
				});
				return hasClass;
				//return !!cName.match(new RegExp(className));
			} else {
				return $(ele).hasClass(className);
			}
		},
		sector: function (cx, cy, r, startAngle, endAngle) {
			var start = $.wijraphael.getPositionByAngle(cx, cy, r, startAngle),
				end = $.wijraphael.getPositionByAngle(cx, cy, r, endAngle);

			return ["M", cx, cy, "L", start.x, start.y, "A", r, r, 0,
					+(endAngle - startAngle > 180), 0, end.x, end.y, "z"];
		}
	};

	$.expr.filter.CLASS = function (elem, match) {
		var className = (!$.wijraphael.isSVGElem(elem) ? elem.className :
			(elem.className ? elem.className.baseVal : elem.getAttribute('class')));
		return (' ' + className + ' ').indexOf(match) > -1;
	};

	$.expr.preFilter.CLASS = function (match, curLoop, inplace, result, not, isXML) {
		var i = 0,
			elem = null,
			className = null;
		match = ' ' + match[1].replace(/\\/g, '') + ' ';
		if (isXML) {
			return match;
		}
		for (i = 0, elem = {}; elem; i++) {
			elem = curLoop[i];
			if (!elem) {
				try {
					elem = curLoop.item(i);
				} catch (e) { }
			}
			if (elem) {
				className = (!$.wijraphael.isSVGElem(elem) ? elem.className :
					(elem.className ? elem.className.baseVal : '') ||
					elem.getAttribute('class'));
				if (not ^ (className && (' ' + className + ' ').indexOf(match) > -1)) {
					if (!inplace) {
						result.push(elem);
					}
				} else if (inplace) {
					curLoop[i] = false;
				}
			}
		}
		return false;
	};

	Raphael.fn.tri = function (x, y, length) {
		var x1 = x,
			y1 = y - length,
			offsetX = Math.cos(30 * Math.PI / 180) * length,
			offsetY = Math.tan(60 * Math.PI / 180) * offsetX,
			x2 = x + offsetX,
			y2 = y + offsetY,
			x3 = x - offsetX,
			y3 = y + offsetY,
			arrPath = ["M", x1, y1, "L", x2, y2, "L", x3, y3, "z"];
		return this.path(arrPath.concat(" "));
	};

	Raphael.fn.invertedTri = function (x, y, length) {
		var x1 = x,
			y1 = y + length,
			offsetX = Math.cos(30 * Math.PI / 180) * length,
			offsetY = Math.tan(60 * Math.PI / 180) * offsetX,
			x2 = x + offsetX,
			y2 = y - offsetY,
			x3 = x - offsetX,
			y3 = y - offsetY,
			arrPath = ["M", x1, y1, "L", x2, y2, "L", x3, y3, "z"];
		return this.path(arrPath.concat(" "));
	};

	Raphael.fn.box = function (x, y, length) {
		var offset = Math.cos(45 * Math.PI / 180) * length,
			arrPath = ["M", x - offset, y - offset, "L", x + offset, y - offset,
				"L", x + offset, y + offset, "L", x - offset, y + offset, "z"];
		return this.path(arrPath.concat(" "));
	};

	Raphael.fn.diamond = function (x, y, length) {
		var arrPath = ["M", x, y - length, "L", x + length, y, "L", x, y + length,
			"L", x - length, y, "z"];
		return this.path(arrPath.concat(" "));
	};

	Raphael.fn.cross = function (x, y, length) {
		var offset = Math.cos(45 * Math.PI / 180) * length,
			arrPath = ["M", x - offset, y - offset, "L", x + offset, y + offset,
				"M", x - offset, y + offset, "L", x + offset, y - offset];
		return this.path(arrPath.concat(" "));
	};

	Raphael.fn.paintMarker = function (type, x, y, length) {
		var self = this,
			marker = null;
		if (!type) {
			type = "circle";
		}
		switch (type) {
		case "circle":
			marker = self.circle(x, y, length);
			break;
		case "tri":
			marker = self.tri(x, y, length);
			break;
		case "invertedTri":
			marker = self.invertedTri(x, y, length);
			break;
		case "box":
			marker = self.box(x, y, length);
			break;
		case "diamond":
			marker = self.diamond(x, y, length);
			break;
		case "cross":
			marker = self.cross(x, y, length);
			break;
		}
		return marker;
	};

	Raphael.prototype.htmlText = function (x, y, text, attrs, wordSpace, lineSpace) {
		function applyStyle(txt, sp, attrs) {
			var strongRegx = /<(b|strong)>/,
				italicRegx = /<(i|em)>/,
				hrefRegex = /href=[\"\']([^\"\']+)[\"\']/,
				aRegex = /<a/;
			if (attrs) {
				txt.attr(attrs);
			}
			if (strongRegx.test(sp)) {
				txt.attr("font-weight", "bold");
			}
			if (italicRegx.test(sp)) {
				txt.attr("font-style", "italic");
			}
			if (aRegex.test(sp)) {
				if (sp.match(hrefRegex)[1]) {
					txt.attr("href", sp.match(hrefRegex)[1]);
				}
			}
		}

		var texts = text.toString().split(/<br\s?\/>|\\r/i),
			self = this,
			st = self.set(),
			totalX = 0,
			totalY = 0;
		//set default value of word spacing and line spacing
		wordSpace = wordSpace || 3;
		lineSpace = lineSpace || 5;

		$.each(texts, function (ridx, item) {
			var maxHeight = 0,
				spans = item.split('|||');
			item = item.replace(/<([A-Za-z]+(.|\n)*?)>/g, '|||<$1>')
				.replace(/<\/([A-Za-z]*)>/g, '</$1>|||');

			$.each(spans, function (cidx, span) {
				var temp = null,
					box = null,
					offsetX = 0,
					offsetY = 0;
				if (span !== '') {
					temp = span;
					temp = $.trim(temp.replace(/<(.|\n)*?>/g, ''));
					text = self.text(0, 0, temp);
					applyStyle(text, span, attrs);

					box = text.wijGetBBox();
					offsetX = box.width / 2 + totalX;
					offsetY = -box.height / 2 + totalY;
					totalX = totalX + box.width + wordSpace;
					text.translate(offsetX, offsetY);

					st.push(text);
					if (maxHeight < box.height) {
						maxHeight = box.height;
					}
				}
			});
			totalY += maxHeight + lineSpace;
			totalX = maxHeight = 0;
		});
		totalY = 0;
		//st.translate(x - st.getBBox().x, y - st.getBBox().y);
		st.transform(Raphael.format("...t{0},{1}",
			x - st.getBBox().x, y - st.getBBox().y));

		return st;
	};
	Raphael.fn.line = function (startX, startY, endX, endY) {
		return this.path(["M", startX, startY, "L", endX, endY]);
	};

	Raphael.fn.roundRect = function (x, y, width, height, tlCorner,
			lbCorner, brCorner, rtCorner) {
		var rs = [],
			posFactors = [-1, 1, 1, 1, 1, -1, -1, -1],
			orientations = ["v", "h", "v", "h"],
			pathData = null,
			lens = null;
		$.each([tlCorner, lbCorner, brCorner, rtCorner], function (idx, corner) {
			if (typeof (corner) === "number") {
				rs = rs.concat({ x: corner, y: corner });
			} else if (typeof (corner) === "object") {
				rs = rs.concat(corner);
			} else {
				rs = rs.concat({ x: 0, y: 0 });
			}
		});

		pathData = ["M", x + rs[0].x, y];
		lens = [height - rs[0].y - rs[1].y, width - rs[1].x - rs[2].x,
				rs[2].y + rs[3].y - height, rs[3].x + rs[0].x - width];

		$.each(rs, function (idx, r) {
			if (r.x && r.y) {
				pathData = pathData.concat("a", r.x, r.y, 0, 0, 0,
						posFactors[2 * idx] * r.x, posFactors[2 * idx + 1] * r.y);
			}

			pathData = pathData.concat(orientations[idx], lens[idx]);
		});

		pathData.push("z");

		return this.path(pathData);
	};

	Raphael.fn.wrapText = function (x, y, text, width, textAlign, textStyle) {
		var self = this,
			rotation = textStyle.rotation,
			style = rotation ? $.extend(true, {}, textStyle, { rotation: 0 })
				: textStyle,
			top = y,
			texts = self.set(),
			bounds = null,
			center = null,
			textBounds = [];

		function splitString(text, width, textStyle) {
			var tempText = null,
				bounds = null,
				words = text.toString().split(' '),
				lines = [],
				line = [],
				tempTxt = "";
			while (words.length) {
				tempTxt += ' ' + words[0];
				tempText = self.text(-1000, -1000, tempTxt);
				tempText.attr(textStyle);
				bounds = tempText.wijGetBBox();

				if (bounds.width > width) {
					if (line.length) {
						lines.push(line);
						tempTxt = words[0];
					}
					line = [words.shift()];
				} else {
					line.push(words.shift());
				}

				if (words.length === 0) {
					lines.push(line);
				}

				tempText.wijRemove();
				tempText = null;
			}

			return lines;
		}

		$.each(splitString(text, width, style), function (idx, line) {
			var lineText = line.join(' '),
				align = textAlign || "near",
				txt = self.text(x, top, lineText),
				offsetX = 0,
				offsetY = 0;

			txt.attr(style);
			bounds = txt.wijGetBBox();

			switch (align) {
			case "near":
				offsetX = width - bounds.width / 2;
				//offsetY += bounds.height / 2;
				//top += bounds.height;
				break;
			case "center":
				offsetX += width / 2;
				//offsetY += bounds.height / 2;
				//top += bounds.height;
				break;
			case "far":
				offsetX += bounds.width / 2;
				//offsetY += bounds.height / 2;
				//top += bounds.height;
				break;
			}
			//add comments to fix tfs issue 19384
			if (rotation) {
				offsetY += bounds.height / 2 / Math.abs(Math.sin(rotation));
				top += bounds.height / Math.abs(Math.sin(rotation));
			} else {
				offsetY += bounds.height / 2;
				top += bounds.height;
			}
			//end comments
			bounds.x += offsetX;
			bounds.y += offsetY;
			if (rotation) {
				txt.attr({
					x: txt.attr("x") + offsetX,
					y: txt.attr("y") + offsetY
				});
			} else {
				txt.transform(Raphael.format("...T{0},{1}", offsetX, offsetY));
			}
			texts.push(txt);
			textBounds.push(bounds);
		});

		if (rotation) {
			bounds = texts.wijGetBBox();
			if (texts.length > 1) {
				$.each(texts, function (idx, txt) {
					txt.attr({ y: txt.attr("y") - bounds.height / 2 });
					textBounds[idx].y -= bounds.height / 2;
				});
				center = {
					x: bounds.x + bounds.width / 2,
					y: bounds.y + bounds.height / 2
				};


				$.each(texts, function (idx, txt) {
					var math = Math,
						tb = textBounds[idx],
						txtCenter = {
							x: tb.x + tb.width / 2,
							y: tb.y + tb.height / 2
						},
						len = math.sqrt(math.pow(txtCenter.x - center.x, 2) +
							math.pow(txtCenter.y - center.y, 2)),
						theta = 0,
						rotatedTB = null,
						newTxtCenter = null;

					txt.attr({ rotation: rotation });

					if (len === 0) {
						return true;
					}
					rotatedTB = txt.wijGetBBox();

					theta = Raphael.deg(math.asin(
						math.abs(txtCenter.y - center.y) / len
					));

					if (txtCenter.y > center.y) {
						if (txtCenter.x > center.x) {
							theta -= 360;
						} else {
							theta = -1 * (theta + 180);
						}
					} else {
						if (txtCenter.x > center.x) {
							theta *= -1;
						} else {
							theta = -1 * (180 - theta);
						}
					}
					newTxtCenter = $.wijraphael.getPositionByAngle(center.x,
						center.y, len, -1 * (rotation + theta));


					txt.attr({
						y: txt.attr("y") + newTxtCenter.y -
							rotatedTB.y - rotatedTB.height / 2
					});
				});
			} else {
				texts[0].transform(Raphael.format("...R{0}", rotation));
			}
		}

		return texts;
	};

	Raphael.fn.getSVG = function () {
		function createSVGElement(type, options) {
			var element = '<' + type + ' ',
				val = null,
				styleExist = false;

			$.each(options, function (name, val) {
				if (name === "text" || name === "opacity" ||
						name === "transform" || name === "path" ||
						name === "w" || name === "h" || name === "translation") {
					return true;
				}

				if (val) {
					if (name === "stroke" && val === 0) {
						val = "none";
					}

					element += name + "='" + val + "' ";
				}
			});
			/*
			for (name in options) {
			if (name === "text" || name === "opacity" ||
			name === "transform" || name === "path" ||
			name === "w" || name === "h" || name === "translation") {
			continue;
			}

			if ((val = options[name]) !== null) {
			if (name === "stroke" && val === 0) {
			val = "none";
			}

			element += name + "='" + val + "' ";
			}
			}
			*/
			if (options.opacity) {
				val = options.opacity;
				element += "opacity='" + val + "' style='opacity:" + val + ";";
				styleExist = true;
			}

			if (options.transform && options.transform.length > 0) {
				val = options.transform;
				if (styleExist) {
					element += "transform:" + val;
				} else {
					element += "style='transform:" + val;
					styleExist = true;
				}
			}

			if (styleExist) {
				element += "'";
			}

			if (options.text) {
				val = options.text;
				element += "><tspan>" + val + "</tspan>";
			} else {
				element += ">";
			}

			element += "</" + type + ">";

			return element;
		}

		var paper = this,
			svg = '<svg xmlns="http://www.w3.org/2000/svg" ' +
				'xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="' +
				paper.canvas.offsetWidth + '" height="' + paper.canvas.offsetHeight +
				'"><desc>Created with Raphael</desc><defs></defs>',
			node,
			path = "",
			trans,
			group,
			value,
			idx = 0,
			len1 = 0,
			index = 0,
			len2 = 0;

		for (node = paper.bottom; node; node = node.next) {
			if (node && node.type) {
				switch (node.type) {
				case "path":
					for (idx = 0, len1 = node.attrs.path.length; idx < len1; idx++) {
						group = node.attrs.path[idx];

						for (index = 0, len2 = group.length; index < len2; index++) {
							value = group[index];

							if (index < 1) {
								path += value;
							} else {
								if (index === (len2 - 1)) {
									path += value;
								} else {
									path += value + ',';
								}
							}
						}
					}

					if (path && path.length > 0) {
						node.attrs.d = path.replace(/,/g, ' ');
					}
					break;
				case "text":
					if (!node.attrs["text-anchor"]) {
						node.attrs["text-anchor"] = "middle";
					}
					break;
				case "image":
					trans = node.transformations;
					node.attrs.transform = trans ? trans.join(' ') : '';
					break;
				case "ellipse":
				case "rect":
					svg += createSVGElement(node.type, node.attrs);
					break;
				}
			}
		}

		svg += '</svg>';

		return svg;
	};

	Raphael.el.wijRemove = function () {
		var self = this,
			jqobj;
		if (self.removed) {
			return;
		}
		if (self.node.parentNode) {
			jqobj = $(self.node);
			self.stop().remove();
			jqobj.remove();
		}
	};

	Raphael.st.wijRemove = function () {
		$.each(this, function (idx, obj) {
			if (obj.wijRemove) {
				obj.wijRemove();
			}
		});
	};

	Raphael.el.wijGetBBox = function () {
		//Add comments to fix tfs issue 19384
		//getBBox issue is fixed in raphael2, so return getBBox() directly.
		return this.getBBox();
		/*
		var self = this,
		box = self.getBBox();
		if (Raphael.vml && self.type === 'text') {
		self.shape.style.display = "inline";
		box.width = self.shape.scrollWidth;
		box.height = self.shape.scrollHeight;
		}
		return box;
		*/
		//end comments
		/*
		var self = this,
		box = self.getBBox(),
		degreesAsRadians = null,
		points = [],
		newX,
		newY,
		newWidth,
		newHeight,
		p,
		bb = { left: 0, right: 0, top: 0, bottom: 0 },
		_px = 0,
		transform = self.transform().toString();
		//if (this.attrs && this.attrs.rotation) {
		if (/r[^0]/i.test(transform)) {
		//degreesAsRadians = self._.deg * Math.PI / 180;
		degreesAsRadians = self._.deg;
		points.push({ x: 0, y: 0 });
		points.push({ x: box.width, y: 0 });
		points.push({ x: 0, y: box.height });
		points.push({ x: box.width, y: box.height });
		for (_px = 0; _px < points.length; _px++) {
		p = points[_px];
		newX = parseInt((p.x * Math.cos(degreesAsRadians)) +
		(p.y * Math.sin(degreesAsRadians)), 10);
		newY = parseInt((p.x * Math.sin(degreesAsRadians)) +
		(p.y * Math.cos(degreesAsRadians)), 10);
		bb.left = Math.min(bb.left, newX);
		bb.right = Math.max(bb.right, newX);
		bb.top = Math.min(bb.top, newY);
		bb.bottom = Math.max(bb.bottom, newY);
		}
		newWidth = parseInt(Math.abs(bb.right - bb.left), 10);
		newHeight = parseInt(Math.abs(bb.bottom - bb.top), 10);
		newX = (box.x + (box.width) / 2) - newWidth / 2;
		newY = (box.y + (box.height) / 2) - newHeight / 2;

		return { x: newX, y: newY, width: newWidth, height: newHeight };
		}

		box = self.getBBox();
		if (Raphael.vml && self.type === 'text') {
		self.shape.style.display = "inline";
		box.width = self.shape.scrollWidth;
		box.height = self.shape.scrollHeight;
		}
		return box;
		*/
	};

	Raphael.el.wijAnimate = function (params, ms, easing, callback) {
		if (!params || $.isEmptyObject(params)) {
			return;
		}

		var shadow = this.shadow,
			offset = 0,
			jQEasing = {
				easeInCubic: ">",
				easeOutCubic: "<",
				easeInOutCubic: "<>",
				easeInBack: "backIn",
				easeOutBack: "backOut",
				easeOutElastic: "elastic",
				easeOutBounce: "bounce"
			};

		if (jQEasing[easing]) {
			easing = jQEasing[easing];
		}
		this.animate(params, ms, easing, callback);
		jQEasing = null;
		if (shadow && shadow.offset) {
			offset = shadow.offset;
			if (params.x) {
				params.x += offset;
			}
			if (params.y) {
				params.y += offset;
			}
			this.shadow.animate(params, ms, easing, callback);
		}
	};

	Raphael.el.wijAttr = function (name, value) {
		this.attr(name, value);

		if (this.shadow) {
			if (typeof (name) === "object") {
				var newName = $.extend(true, {}, name);
				if (newName.fill) {
					delete newName.fill;
				}
				if (newName.stroke) {
					delete newName.stroke;
				}
				if (newName["stroke-width"]) {
					delete newName["stroke-width"];
				}
				this.shadow.attr(newName, value);
			} else if (typeof (name) === "string") {
				switch (name) {
				case "clip-rect":
				case "cx":
				case "cy":
				case "fill-opacity":
				case "font":
				case "font-family":
				case "font-size":
				case "font-weight":
				case "height":
				case "opacity":
				case "path":
				case "r":
				case "rotation":
				case "rx":
				case "ry":
				case "scale":
				case "stroke-dasharray":
				case "stroke-linecap":
				case "stroke-linejoin":
				case "stroke-miterlimit":
				case "stroke-opacity":
				case "stroke-width":
				case "translation":
				case "width":
					this.shadow.attr(name, value);
					break;
				case "x":
					this.shadow.attr(name, value);
					//this.shadow.attr("translation", "1 0");
					this.shadow.attr("transform", "...t1,0");
					break;
				case "y":
					this.shadow.attr(name, value);
					//this.shadow.attr("translation", "0 1");
					this.shadow.attr("transform", "...t0,1");
					break;
				default:
					break;
				}
			}
		}
	};

	Raphael.st.wijAttr = function (name, value) {
		$.each(this.items, function (idx, item) {
			item.wijAttr(name, value);
		});
		return this;
	};

	Raphael.st.wijAnimate = function (params, ms, easing, callback) {
		var i = 0,
			ii = 0,
			item = null;
		for (i = 0, ii = this.items.length; i < ii; i++) {
			item = this.items[i];
			item.wijAnimate(params, ms, easing, callback);
		}
		return this;
	};

	Raphael.st.wijGetBBox = function () {
		var x = [],
			y = [],
			w = [],
			h = [],
			mmax = Math.max,
			mmin = Math.min,
			push = "push",
			apply = "apply",
			box = null,
			i = 0;
		for (i = this.items.length - 1; i >= 0; i--) {
			box = this.items[i].wijGetBBox();
			x[push](box.x);
			y[push](box.y);
			w[push](box.x + box.width);
			h[push](box.y + box.height);
		}
		x = mmin[apply](0, x);
		y = mmin[apply](0, y);
		return {
			x: x,
			y: y,
			width: mmax[apply](0, w) - x,
			height: mmax[apply](0, h) - y
		};
	};
} ());
/*globals $, Raphael, jQuery, document, window, Globalize, wijmoASPNetParseOptions*/
/*
*
* Wijmo Library 1.1.2
* http://wijmo.com/
*
* Copyright(c) ComponentOne, LLC.  All rights reserved.
* 
* Dual licensed under the Wijmo Commercial or GNU GPL Version 3 licenses.
* licensing@wijmo.com
* http://wijmo.com/license
*
*
* * Wijmo Chart Core Widget.
*
* Depends:
*  raphael.js
*  globalize.js
*  jquery.svgdom.js
*  jquery.ui.widget.js
*
*/

(function ($) {
	"use strict";
	if (!window.Raphael) {
		return;
	}

	$.wijchart = {

		getDiffAttrs: function (attrs, newAttrs) {
			var result = {};

			$.each(newAttrs, function (key, attr) {
				if (typeof (attrs) === "undefined") {
					return true;
				} else if (typeof (attrs[key]) === "undefined") {
					result[key] = newAttrs[key];
				} else if (attrs[key] !== newAttrs[key]) {
					result[key] = newAttrs[key];
				}
			});

			return result;
		},

		paintShadow: function (element, offset, stroke) {
			if (element.removed || $(element).parent().length === 0) {
				return;
			}
			var shadow = element.clone(),
				newOffset = offset || 1,
				newStroke = stroke || "#cccccc";

			shadow.insertBefore(element);
			shadow.attr({
				// translation: newOffset + " " + newOffset,
				transform: Raphael.format("...T{0},{1}", newOffset, newOffset),
				stroke: newStroke,
				"stroke-width": newOffset
			});
			shadow.toBack();
			shadow.offset = newOffset;
			element.shadow = shadow;
		},

		getScaling: function (isVertical, max, min, length) {
			var dx = max - min;

			if (dx === 0) {
				dx = 1;
			}

			if (isVertical) {
				dx = -dx;
			}

			return length / dx;
		},

		getTranslation: function (isVertical, location, max, min, scaling) {
			var translation = 0;

			if (isVertical) {
				translation = location.y;
				translation -= scaling * max;
			} else {
				translation = location.x;
				translation -= scaling * min;
			}

			return translation;
		},

		getXSortedPoints: function (series) {
			var seriesX = series.data.x,
				tempX = [].concat(seriesX),
				tempY = [].concat(series.data.y),
				points = [],
				sortedX = seriesX;

			if (seriesX === undefined || seriesX.length === 0) {
				return;
			}

			function sortNumber(a, b) {
				return a - b;
			}

			if (typeof (seriesX[0]) === "number") {
				sortedX = [].concat(seriesX).sort(sortNumber);
			}

			$.each(sortedX, function (i, nSortedX) {
				$.each(tempX, function (j, nx) {
					if (nSortedX === nx) {
						if (typeof (nx) !== "number") {
							nx = i;
						}
						points.push({ x: nx, y: tempY[j] });
						tempX.splice(j, 1);
						tempY.splice(j, 1);
						return false;
					}
				});
			});

			return points;
		},

		sector: function (cx, cy, r, startAngle, endAngle) {
			var start = $.wijraphael.getPositionByAngle(cx, cy, r, startAngle),
				end = $.wijraphael.getPositionByAngle(cx, cy, r, endAngle);

			return ["M", cx, cy, "L", start.x, start.y, "A", r, r, 0,
					+(endAngle - startAngle > 180), 0, end.x, end.y, "z"];
		},

		donut: function (cx, cy, outerR, innerR, startAngle, endAngle) {
			var outerS = $.wijraphael.getPositionByAngle(cx, cy, outerR, startAngle),
				outerE = $.wijraphael.getPositionByAngle(cx, cy, outerR, endAngle),
				innerS = $.wijraphael.getPositionByAngle(cx, cy, innerR, startAngle),
				innerE = $.wijraphael.getPositionByAngle(cx, cy, innerR, endAngle),
				largeAngle = endAngle - startAngle > 180;

			return ["M", outerS.x, outerS.y,
				"A", outerR, outerR, 0, +largeAngle, 0, outerE.x, outerE.y,
				"L", innerE.x, innerE.y,
				"A", innerR, innerR, 0, +largeAngle, 1, innerS.x, innerS.y,
				"L", outerS.x, outerS.y, "z"];
		},

		getFirstValidListValue: function (values) {
			var val;
			$.each(values, function (idx, value) {
				if (value === null) {
					return true;
				} else if (typeof value === "undefined") {
					return true;
				}
				val = value;
				return false;
			});
			return val;
		},

		getLastValidListValue: function (values) {
			var vals = [].concat(values).reverse();
			return $.wijchart.getFirstValidListValue(vals);
		},

		isHole: function (val, hole) {
			if (val === null) {
				return true;
			} else if (typeof val === "undefined") {
				return true;
			}
			if (typeof val !== "undefined") {
				if (val === hole) {
					return true;
				}
				return false;
			}
			return false;
		}
	};

	var defaultOptions = {
		content: "",
		contentStyle: {},
		title: "",
		titleStyle: {},
		style: {
			fill: "white",
			"fill-opacity": 0.5
		},
		closeBehavior: "auto",
		mouseTrailing: true,
		triggers: "hover",
		animated: "fade",
		showAnimated: null,
		hideAnimated: null,
		duration: 500,
		showDuration: 500,
		hideDuration: 500,
		easing: null,
		showEasing: null,
		hideEasing: null,
		showDelay: 150,
		hideDelay: 150,
		relativeTo: "mouse",
		compass: "east",
		offsetX: 0,
		offsetY: 0,
		showCallout: true,
		calloutFilled: false,
		calloutFilledStyle: {
			fill: "black"
		},
		calloutLength: 12,
		calloutOffset: 0,
		calloutAnimation: {
			easing: null,
			duration: 500
		},
		windowCollisionDetection: true,
		calloutSide: null,
		width: null,
		height: null,
		beforeShowing: null
	};

	Raphael.fn.closeBtn = function (x, y, length) {
		var offset = Math.cos(45 * Math.PI / 180) * length,
			set = this.set(),
			arrPath = ["M", x - offset, y - offset, "L", x + offset, y + offset,
				"M", x - offset, y + offset, "L", x + offset, y - offset],
			path = this.path(arrPath.concat(" ")),
			rect = null;
		path.attr({ cursor: "pointer" });
		set.push(path);

		rect = this.rect(x - length, y - length, length * 2, length * 2);
		rect.attr({
			fill: "white",
			"fill-opacity": 0,
			cursor: "pointer",
			stroke: "none"
		});
		set.push(rect);
		return set;
	};

	Raphael.fn.tooltip = function (targets, options) {
		var o = $.extend(true, {}, defaultOptions, options),
			self = this,
			position = null,
			offsetX = 0,
			offsetY = 0,
			content,
			title,
			container,
			closeBtn,
			callout,
			intentShowTimer = null,
			intentHideTimer = null,
			lastPoint = null,
			closeBtnLength = 5,
			elements = null,
			animations = self.tooltip.animations,
			calloutOffset = o.calloutOffset,
			width = o.width,
			height = o.height,
			gapLength = o.calloutLength / 2,
			offsetLength = 0,
		// oX,oY is the default offset of the tooltip
			oX = 0,
			oY = 0,
			selector,

			_getShowPoint = function (raphaelObj, compass) {
				var box = raphaelObj.getBBox(),
					point = {
						x: 0,
						y: 0
					};
				switch (compass.toLowerCase()) {
				case "east":
					point.x = box.x + box.width;
					point.y = box.y + box.height / 2;
					break;
				case "eastnorth":
					point.x = box.x + box.width;
					point.y = box.y;
					break;
				case "eastsouth":
					point.x = box.x + box.width;
					point.y = box.y + box.height;
					break;
				case "west":
					point.x = box.x;
					point.y = box.y + box.height / 2;
					break;
				case "westnorth":
					point.x = box.x;
					point.y = box.y;
					break;
				case "westsouth":
					point.x = box.x;
					point.y = box.y + box.height;
					break;
				case "north":
					point.x = box.x + box.width / 2;
					point.y = box.y;
					break;
				case "northeast":
					point.x = box.x + box.width;
					point.y = box.y;
					break;
				case "northwest":
					point.x = box.x;
					point.y = box.y;
					break;
				case "south":
					point.x = box.x + box.width / 2;
					point.y = box.y + box.height;
					break;
				case "southeast":
					point.x = box.x + box.width;
					point.y = box.y + box.height;
					break;
				case "southwest":
					point.x = box.x;
					point.y = box.y + box.height;
					break;
				}
				return point;
			},

			_clearIntentTimer = function (timer) {
				if (timer) {
					window.clearTimeout(timer);
					timer = null;
				}
			},

			_removeTooltip = function (duration) {
				if (elements) {
					var animated,
						d,
						op;
					if (o.hideAnimated || o.animated) {
						animated = o.hideAnimated;
						if (!animated) {
							animated = o.animated;
						}
						if (animated && animations[animated]) {
							op = {
								animated: animated,
								duration: o.hideDuration || o.duration,
								easing: o.hideEasing || o.easing,
								context: elements,
								show: false
							};
							animations[animated](op);
						}
					}
					d = o.hideDuration;
					if (duration) {
						d = duration;
					}
					window.setTimeout(function () {
						var i,
							ii;
						if (content) {
							content.wijRemove();
							content = null;
						}
						if (title) {
							title.wijRemove();
							title = null;
						}
						if (container) {
							container.wijRemove();
							container = null;
						}
						if (closeBtn) {
							for (i = 0, ii = closeBtn.length; i < ii; i++) {
								closeBtn[i].unclick();
							}
							closeBtn.wijRemove();
							closeBtn = null;
						}
						if (callout) {
							callout.wijRemove();
							callout = null;
						}
						lastPoint = null;
						elements = null;
					}, d);
				}
			},

			_clearTimers = function () {
				if (intentShowTimer) {
					_clearIntentTimer(intentShowTimer);
				}
				if (intentHideTimer) {
					_clearIntentTimer(intentHideTimer);
				}
			},

			_hide = function () {
				_clearTimers();
				if (o.hideDelay) {
					intentHideTimer = window.setTimeout(function () {
						_removeTooltip();
					}, o.hideDelay);
				} else {
					_removeTooltip();
				}
			},

			_convertCompassToPosition = function (compass) {
				var position = "";
				switch (compass.toLowerCase()) {
				case "east":
					position = "right-middle";
					oX = 2;
					oY = 0;
					break;
				case "eastnorth":
					position = "right-top";
					oX = 2;
					oY = -2;
					break;
				case "eastsouth":
					position = "right-bottom";
					oX = 2;
					oY = 2;
					break;
				case "west":
					position = "left-middle";
					oX = -2;
					oY = 0;
					break;
				case "westnorth":
					position = "left-top";
					oX = -2;
					oY = -2;
					break;
				case "westsouth":
					position = "left-bottom";
					oX = -2;
					oY = 2;
					break;
				case "north":
					position = "top-middle";
					oX = 0;
					oY = -2;
					break;
				case "northeast":
					position = "top-right";
					oX = 2;
					oY = -2;
					break;
				case "northwest":
					position = "top-left";
					oX = -2;
					oY = -2;
					break;
				case "south":
					position = "bottom-middle";
					oX = 0;
					oY = 2;
					break;
				case "southeast":
					position = "bottom-right";
					oX = 2;
					oY = 2;
					break;
				case "southwest":
					position = "bottom-left";
					oX = -2;
					oY = 2;
					break;
				}
				return position;
			},

			_getCalloutArr = function (p, offset) {
				var arr = [],
					compass = o.compass;
				if (o.calloutSide) {
					compass = o.calloutSide;
				}
				switch (compass.toLowerCase()) {
				case "east":
				case "eastsouth":
				case "eastnorth":
					arr = ["M", p.x + offset, p.y + offset, "l",
					-offset, -offset, "l", offset, -offset, "Z"];
					break;
				case "west":
				case "westsouth":
				case "westnorth":
					arr = ["M", p.x - offset, p.y - offset, "l",
					offset, offset, "l", -offset, offset, "Z"];
					break;
				case "north":
				case "northeast":
				case "northwest":
					arr = ["M", p.x - offset, p.y - offset, "l",
					offset, offset, "l", offset, -offset, "Z"];
					break;
				case "south":
				case "southeast":
				case "southwest":
					arr = ["M", p.x - offset, p.y + offset, "l",
					offset, -offset, "l", offset, offset, "Z"];
					break;
				}
				return arr;
			},

			_getFuncText = function (text, e) {
				if ($.isFunction(text)) {
					var fmt = null, objTar,
						obj = {
							target: null,
							fmt: text
						},
						t;
					if (e && e.target) {
						// obj.target = $(e.target).data("raphaelObj");
						// objTar = $(e.target).data("raphaelObj");
						// if (!objTar) {
						// objTar = $(e.target.parentNode).data("raphaelObj");
						// }
						// obj.target = objTar;
						t = e.target;
						if (!t.raphael || !t.raphaelid) {
							t = t.parentNode;
						}
						if (t.raphael && t.raphaelid) {
							objTar = self.getById(t.raphaelid);
							obj.target = objTar;
						}
						else {
							obj.target = e.target;
						}
					}
					fmt = $.proxy(obj.fmt, obj);
					return fmt().toString();
				}
				return text;
			},

			_translateCallout = function (duration) {
				if (o.calloutSide) {
					var offset = gapLength || offsetLength;
					switch (o.calloutSide) {
					case "south":
					case "north":
						if (duration) {
							callout.animate({
								"translation": (-width / 2 + offset + calloutOffset) +
								",0"
							}, duration);
						} else {
							callout.translate(-width / 2 + offset + calloutOffset, 0);
						}
						break;
					case "east":
					case "west":
						if (duration) {
							callout.animate({
								"translation": "0," + (-height / 2 +
							offset + calloutOffset)
							}, duration);
						} else {
							callout.translate(0, -height / 2 + offset + calloutOffset);
						}
						break;
					}
				}
			},

			tokenRegex = /\{([^\}]+)\}/g,
		// matches .xxxxx or ["xxxxx"] to run over object properties
			objNotationRegex = /(?:(?:^|\.)(.+?)(?=\[|\.|$|\()|\[('|")(.+?)\2\])(\(\))?/g,
			replacer = function (all, key, obj) {
				var res = obj;
				key.replace(objNotationRegex,
					function (all, name, quote, quotedName, isFunc) {
						name = name || quotedName;
						if (res) {
							if (res[name] !== typeof ('undefined')) {
								res = res[name];
							}
							if (typeof res === "function" && isFunc) {
								res = res();
							}
						}
					});
				res = (res === null || res === obj ? all : res).toString();
				return res;
			},
			fill = function (str, obj) {
				return String(str).replace(tokenRegex, function (all, key) {
					return replacer(all, key, obj);
				});
			},
			_createPath = function (point, position, set, gapLength, offsetLength) {
				var pos = position.split("-"),
					r = 5,
					bb = set.getBBox(),
					w = Math.round(bb.width),
					h = Math.round(bb.height),
					x = Math.round(bb.x) - r,
					y = Math.round(bb.y) - r,
					gap = 0,
					off = 0,
					dx = 0,
					dy = 0,
					shapes = null,
					mask = null,
					out = null;
				if (o.width) {
					w = w > o.width ? w : o.width;
				}
				if (o.height) {
					h = h > o.height ? h : o.height;
				}
				width = w;
				height = h;
				gap = Math.min(h / 4, w / 4, gapLength);
				if (offsetLength) {
					offsetLength = Math.min(h / 4, w / 4, offsetLength);
				}
				if (offsetLength) {
					off = offsetLength;
					shapes = {
						top: "M{x},{y}h{w4},{w4},{w4},{w4}a{r},{r},0,0,1,{r},{r}" +
							"v{h4},{h4},{h4},{h4}a{r},{r},0,0,1,-{r},{r}l-{right}," +
							"0-{offset},0,-{left},0a{r},{r},0,0,1-{r}-{r}" +
							"v-{h4}-{h4}-{h4}-{h4}a{r},{r},0,0,1,{r}-{r}z",
						bottom: "M{x},{y}l{left},0,{offset},0,{right},0a{r},{r}," +
							"0,0,1,{r},{r}v{h4},{h4},{h4},{h4}a{r},{r},0,0,1,-{r}," +
							"{r}h-{w4}-{w4}-{w4}-{w4}a{r},{r},0,0,1-{r}-{r}" +
							"v-{h4}-{h4}-{h4}-{h4}a{r},{r},0,0,1,{r}-{r}z",
						right: "M{x},{y}h{w4},{w4},{w4},{w4}a{r},{r},0,0,1,{r},{r}" +
							"v{h4},{h4},{h4},{h4}a{r},{r},0,0,1,-{r},{r}" +
							"h-{w4}-{w4}-{w4}-{w4}a{r},{r},0,0,1-{r}-{r}" +
							"l0-{bottom},0-{offset},0-{top}a{r},{r},0,0,1,{r}-{r}z",
						left: "M{x},{y}h{w4},{w4},{w4},{w4}a{r},{r},0,0,1,{r},{r}" +
							"l0,{top},0,{offset},0,{bottom}a{r},{r},0,0,1,-{r}," +
							"{r}h-{w4}-{w4}-{w4}-{w4}a{r},{r},0,0,1-{r}-{r}" +
							"v-{h4}-{h4}-{h4}-{h4}a{r},{r},0,0,1,{r}-{r}z"
					};
				} else {
					shapes = {
						top: "M{x},{y}h{w4},{w4},{w4},{w4}a{r},{r},0,0,1,{r},{r}" +
							"v{h4},{h4},{h4},{h4}a{r},{r},0,0,1,-{r},{r}" +
							"l-{right},0-{gap},{gap}-{gap}-{gap}-{left},0a{r},{r},0,0,1" +
							"-{r}-{r}v-{h4}-{h4}-{h4}-{h4}a{r},{r},0,0,1,{r}-{r}z",
						bottom: "M{x},{y}l{left},0,{gap}-{gap},{gap},{gap},{right},0" +
							"a{r},{r},0,0,1,{r},{r}v{h4},{h4},{h4},{h4}a{r},{r},0,0,1," +
							"-{r},{r}h-{w4}-{w4}-{w4}-{w4}a{r},{r},0,0," +
							"1-{r}-{r}v-{h4}-{h4}-{h4}-{h4}a{r},{r},0,0,1,{r}-{r}z",
						right: "M{x},{y}h{w4},{w4},{w4},{w4}a{r},{r},0,0,1,{r},{r}" +
							"v{h4},{h4},{h4},{h4}a{r},{r},0,0,1,-{r},{r}h-{w4}-{w4}" +
							"-{w4}-{w4}a{r},{r},0,0,1-{r}-{r}l0-{bottom}-{gap}-{gap}," +
							"{gap}-{gap},0-{top}a{r},{r},0,0,1,{r}-{r}z",
						left: "M{x},{y}h{w4},{w4},{w4},{w4}a{r},{r},0,0,1,{r},{r}" +
							"l0,{top},{gap},{gap}-{gap},{gap},0,{bottom}a{r},{r},0,0,1," +
							"-{r},{r}h-{w4}-{w4}-{w4}-{w4}a{r},{r},0,0,1-{r}-{r}" +
							"v-{h4}-{h4}-{h4}-{h4}a{r},{r},0,0,1,{r}-{r}z"
					};
				}
				mask = [{
					x: x + r,
					y: y,
					w: w,
					w4: w / 4,
					h4: h / 4,
					left: 0,
					right: w - gap * 2 - off * 2,
					top: 0,
					bottom: h - gap * 2 - off * 2,
					r: r,
					h: h,
					gap: gap,
					offset: off * 2
				}, {
					x: x + r,
					y: y,
					w: w,
					w4: w / 4,
					h4: h / 4,
					left: w / 2 - gap - off,
					right: w / 2 - gap - off,
					top: h / 2 - gap - off,
					bottom: h / 2 - gap - off,
					r: r,
					h: h,
					gap: gap,
					offset: off * 2
				}, {
					x: x + r,
					y: y,
					w: w,
					w4: w / 4,
					h4: h / 4,
					right: 0,
					left: w - gap * 2 - off * 2,
					bottom: 0,
					top: h - gap * 2 - off * 2,
					r: r,
					h: h,
					gap: gap,
					offset: off * 2
				}][pos[1] === "middle" ? 1 : (pos[1] === "left" || pos[1] === "top") * 2];
				out = self.path(fill(shapes[pos[0]], mask));
				switch (pos[0]) {
				case "top":
					dx = point.x - (x + r + mask.left + gap + offsetLength);
					dy = point.y - (y + r + h + r + gap + offsetLength);
					break;
				case "bottom":
					dx = point.x - (x + r + mask.left + gap + offsetLength);
					dy = point.y - (y - gap - offsetLength);
					break;
				case "left":
					dx = point.x - (x + r + w + r + gap + offsetLength);
					dy = point.y - (y + r + mask.top + gap + offsetLength);
					break;
				case "right":
					dx = point.x - (x - gap - off);
					dy = point.y - (y + r + mask.top + gap + off);
					break;
				}
				out.translate(dx, dy);
				set.translate(dx, dy);
				return out;
			},

			_isWindowCollision = function (container, compass, offsetX, offsetY, ox, oy) {
				var box = container.getBBox(),
					counter = 0,
					cps = compass,
					x = box.x + ox,
					y = box.y + oy,
					w = self.width,
					h = self.height,
					offX = offsetX,
					offY = offsetY;
				if (self.raphael.vml) {
					w = $(self.canvas).width();
					h = $(self.canvas).height();
				}
				if (x + offsetX < 0) {
					// counter++;
					if (cps.toLowerCase().indexOf("west") === -1) {
						// check if window collision after change compass.
						if (x + box.width / 2 + box.width - offsetX <= w) {
							counter++;
							cps = cps.toLowerCase() + "east";
							offX = 0 - offsetX;
						}
					} else {
						if (x + box.width + box.width - offsetX <= w) {
							counter++;
							cps = cps.toLowerCase().replace("west", "east");
							offX = 0 - offsetX;
						}
					}
				}
				if (y + offsetY < 0) {
					// counter++;
					if (cps.toLowerCase().indexOf("north") === -1) {
						// check if window collision after change compass.
						if (y + box.height / 2 + box.height - offsetY <= h) {
							counter++;
							cps = cps.toLowerCase() + "south";
							offY = 0 - offsetY;
						}
					} else {
						if (y + box.height + box.height - offsetY <= h) {
							counter++;
							cps = cps.toLowerCase().replace("north", "south");
							offY = 0 - offsetY;
						}
					}
				}
				if (x + box.width + offsetX > w) {
					// counter++;
					if (cps.toLowerCase().indexOf("east") === -1) {
						// check if window collision after change compass.
						if (x - box.width / 2 - offsetX >= 0) {
							counter++;
							cps = cps.toLowerCase() + "west";
							offX = 0 - offsetX;
						}
					} else {
						if (x - box.width - offsetX >= 0) {
							counter++;
							cps = cps.toLowerCase().replace("east", "west");
							offX = 0 - offsetX;
						}
					}
				}
				if (y + box.height + offsetY > h) {
					// counter++;
					if (cps.toLowerCase().indexOf("south") === -1) {
						// check if window collision after change compass.
						if (y - box.height / 2 - offsetY >= 0) {
							counter++;
							cps = cps.toLowerCase() + "north";
							offY = 0 - offsetY;
						}
					} else {
						if (y - box.height - offsetY >= 0) {
							counter++;
							cps = cps.toLowerCase().replace("south", "north");
							offY = 0 - offsetY;
						}
					}
				}
				if (counter) {
					return {
						compass: cps,
						offsetX: offX,
						offsetY: offY
					};
				}
				return false;
			},

			_createTooltipEles = function (point, tit, cont, windowCollisionDetection,
					compass, offsetX, offsetY) {
				var titleBox,
					contentBox,
					position,
					set = self.set(),
					arrPath = null,
					animated = null,
					op = null,
					ox = 0,
					oy = 0,
					duration = 250,
					idx = 0,
					len = 0,
					isWindowCollision,
					newPoint = {
						x: point.x,
						y: point.y
					},
					anim = null;

				$.wijraphael.clearRaphaelCache();
				position = _convertCompassToPosition(compass);
				newPoint.x += offsetX + oX;
				newPoint.y += offsetY + oY;
				elements = self.set();
				if (title) {
					$.each(title, function (i, t) {
						$(t.node).unbind(".Rtooltip");
					});
					title.wijRemove();
				}
				if (tit && tit.length > 0) {
					title = self.htmlText(-1000, -1000, tit, o.titleStyle);
					elements.push(title);
					titleBox = title.getBBox();
				} else {
					titleBox = {
						left: -1000,
						top: -1000,
						width: 0,
						height: 0
					};
				}
				if (content) {
					$.each(content, function (i, c) {
						$(c.node).unbind(".Rtooltip");
					});
					content.wijRemove();
				}
				if (cont && cont.length > 0) {
					content = self.htmlText(-1000, -1000, cont, o.contentStyle);
					elements.push(content);
					contentBox = content.getBBox();
				} else {
					contentBox = {
						left: -1000,
						top: -1000,
						width: 0,
						height: 0
					};
				}
				if (closeBtn) {
					for (idx = 0, len = closeBtn.length; idx < len; idx++) {
						closeBtn[idx].unclick();
					}
					closeBtn.wijRemove();
				}
				if (content) {
					// content.translate(0, titleBox.height / 2 +
					// contentBox.height / 2);
					content.transform(Raphael.format("T0,{0}",
					titleBox.height / 2 + contentBox.height / 2));
				}
				if (o.closeBehavior === "sticky") {
					closeBtn = self.closeBtn(-1000, -1000, closeBtnLength);
					elements.push(closeBtn);
					if (o.width && o.width > titleBox.width + closeBtnLength * 2 &&
							o.width > contentBox.width + closeBtnLength * 2) {
						// closeBtn.translate(o.width - closeBtnLength,
						// closeBtnLength);
						closeBtn.transform(Raphael.format("T{0},{1}",
						o.width - closeBtnLength, closeBtnLength));
					} else if (titleBox.width >= contentBox.width - closeBtnLength * 2) {
						// closeBtn.translate(titleBox.width +
						// closeBtnLength, closeBtnLength);
						closeBtn.transform(Raphael.format("T{0},{1}",
						titleBox.width + closeBtnLength, closeBtnLength));
					} else {
						// closeBtn.translate(contentBox.width -
						// closeBtnLength, closeBtnLength);
						closeBtn.transform(Raphael.format("T{0},{1}",
						contentBox.width - closeBtnLength, closeBtnLength));
					}

					// bind click event.
					$.each(closeBtn, function () {
						this.click(function (e) {
							_hide(e);
						});
					});
				}
				if (title) {
					set.push(title);
					if (o.relatedElement) {
						title.insertBefore(o.relatedElement);
					}
				}
				if (content) {
					set.push(content);
					if (o.relatedElement) {
						content.insertBefore(o.relatedElement);
					}
				}
				if (closeBtn) {
					set.push(closeBtn);
					if (o.relatedElement) {
						closeBtn.insertBefore(o.relatedElement);
					}
				}
				if (!o.showCallout) {
					gapLength = 0;
				}
				if (o.calloutSide || o.calloutFilled) {
					gapLength = 0;
					offsetLength = o.calloutLength / 2;
					if (o.calloutSide) {
						position = _convertCompassToPosition(o.calloutSide);
					}
				}
				if (o.calloutSide && set.length === 0) {
					content = self.htmlText(-1000, -1000, " ");
					set.push(content);
					if (o.relatedElement) {
						content.insertBefore(o.relatedElement);
					}
				}
				if (callout) {
					$(callout.node).unbind(".Rtooltip");
					callout.wijRemove();
				}
				if (container) {
					$(container.node).unbind(".Rtooltip");
					container.wijRemove();
				}
				// container = self.path();
				if (lastPoint) {
					if (o.showCallout && (o.calloutSide || o.calloutFilled)) {
						arrPath = _getCalloutArr(lastPoint, offsetLength);

						callout = self.path(arrPath.concat(" "));
						if (o.relatedElement) {
							callout.insertBefore(o.relatedElement);
						}
						if (o.calloutFilled) {
							callout.attr(o.calloutFilledStyle);
						}
						if (o.calloutSide) {
							_translateCallout(0);
						}
					}
					container = _createPath(lastPoint, position,
						set, gapLength, offsetLength);
					if (o.relatedElement) {
						container.insertBefore(o.relatedElement);
					}
					if (windowCollisionDetection) {
						isWindowCollision = _isWindowCollision(container,
							compass, offsetX, offsetY, newPoint.x - lastPoint.x,
							newPoint.y - lastPoint.y);
						// TODO: window collision
						if (isWindowCollision) {
							_createTooltipEles(point, tit, cont, false,
								isWindowCollision.compass, isWindowCollision.offsetX,
								isWindowCollision.offsetY);
							return;
						}
					}
					elements.push(callout);
					elements.push(container);
					ox = newPoint.x - lastPoint.x;
					oy = newPoint.y - lastPoint.y;
					anim = Raphael.animation({ transform: Raphael
					.format("...T{0},{1}", ox, oy)
					}, duration);
					if (container) {
						// container.animate({ "translation": ox + "," + oy },
						// duration);
						container.animate(anim);
					}
					if (title) {
						// title.animate({ "translation": ox + "," + oy },
						// duration);
						title.animate(anim);
					}
					if (content) {
						// content.animate({ "translation": ox + "," + oy },
						// duration);
						content.animate(anim);
					}
					if (closeBtn) {
						// closeBtn.animate({ "translation": ox + "," + oy },
						// duration);
						closeBtn.animate(anim);
					}
					if (callout) {
						// callout.animate({ "translation": ox + "," + oy },
						// duration);
						callout.animate(anim);
					}
				} else {
					if (o.showCallout && (o.calloutSide || o.calloutFilled)) {
						arrPath = _getCalloutArr(newPoint, offsetLength);
						callout = self.path(arrPath.concat(" "));
						if (o.relatedElement) {
							callout.insertBefore(o.relatedElement);
						}
						if (o.calloutFilled) {
							callout.attr(o.calloutFilledStyle);
						}
						if (o.calloutSide) {
							_translateCallout(0);
						}
					}
					container = _createPath(newPoint, position,
						set, gapLength, offsetLength);
					if (o.relatedElement) {
						container.insertBefore(o.relatedElement);
					}
					if (windowCollisionDetection) {
						isWindowCollision = _isWindowCollision(container,
							compass, offsetX, offsetY, 0, 0);
						// TODO: window collision
						if (isWindowCollision) {
							_createTooltipEles(point, tit, cont, false,
								isWindowCollision.compass, isWindowCollision.offsetX,
								isWindowCollision.offsetY);
							return;
						}
					}
					elements.push(callout);
					elements.push(container);
					if (o.showAnimated || o.animated) {
						animated = o.showAnimated;
						if (!animated) {
							animated = o.animated;
						}
						if (animated && animations[animated]) {
							op = {
								animated: animated,
								duration: o.showDuration || o.duration,
								easing: o.showEasing || o.easing,
								context: elements,
								show: true
							};
							animations[animated](op);
						}
					}
				}
				lastPoint = newPoint;
				container.attr(o.style);
				// container.toFront();
				if (o.relatedElement) {
					if (title) {
						title.insertBefore(o.relatedElement);
					}
					if (content) {
						content.insertBefore(o.relatedElement);
					}
					if (closeBtn) {
						closeBtn.insertBefore(o.relatedElement);
					}
				} else {
					set.toFront();
				}
				// set.toFront();
				/*
				* if (o.closeBehavior === "auto") {
				* $(container.node).bind("mouseover.Rtooltip", function (e) {
				* _clearTimers(); }).bind("mouseout.Rtooltip", function (e) {
				* _hide(e); }); if (title) { $.each(title, function (i, t) {
				* $(t.node).bind("mouseover.Rtooltip", function (e) {
				* _clearTimers(); }).bind("mouseout.Rtooltip", function (e) {
				* _hide(e); }); }); } if (content) { $.each(content, function
				* (i, c) { $(c.node).bind("mouseover.Rtooltip", function (e) {
				* _clearTimers(); }).bind("mouseout.Rtooltip", function (e) {
				* _hide(e); }); }); } if (callout) {
				* $(callout.node).bind("mouseover.Rtooltip", function (e) {
				* _clearTimers(); }).bind("mouseout.Rtooltip", function (e) {
				* _hide(e); }); } }
				*/
			},

			_createTooltip = function (point, e) {
				var tit = null,
					cont = null,
					fmt = null,
					obj = null,
					objTar, t;
				if ($.isFunction(o.beforeShowing)) {
					fmt = null;
					obj = {
						target: null,
						options: o,
						fmt: o.beforeShowing
					};
					if (e && e.target) {
						// objTar = $(e.target).data("raphaelObj");
						// if (!objTar) {
						// objTar = $(e.target.parentNode).data("raphaelObj");
						// }
						// obj.target = objTar;
						t = e.target;
						if (!t.raphael || !t.raphaelid) {
							t = t.parentNode;
						}
						if (t.raphael && t.raphaelid) {
							objTar = self.getById(t.raphaelid);
							obj.target = objTar;
						} else {
							objTar = e.target;
							obj.target = objTar;
						}
					}
					fmt = $.proxy(obj.fmt, obj);
					fmt();
				}
				tit = o.title;
				cont = o.content;
				tit = _getFuncText(tit, e);
				cont = _getFuncText(cont, e);
				if (!tit && !cont) {
					return;
				}

				_createTooltipEles(point, tit, cont, o.windowCollisionDetection,
					o.compass, o.offsetX, o.offsetY);
			},

			_showAt = function (point, e) {
				_clearTimers();
				if (o.showDelay) {
					intentShowTimer = window.setTimeout(function () {
						_createTooltip(point, e);
					}, o.showDelay);
				} else {
					_createTooltip(point, e);
				}
			},

			_show = function (e) {
				position = $(self.canvas.parentNode).offset();
				offsetX = position.left;
				offsetY = position.top;
				var relativeTo = o.relativeTo,
					point = {
						x: 0,
						y: 0
					},
					raphaelObj = null,
					t = e.target;
				switch (relativeTo) {
				case "mouse":
					point.x = e.pageX - offsetX;
					point.y = e.pageY - offsetY;
					break;
				case "element":
					if (!t.raphael || !t.raphaelid) {
						t = t.parentNode;
					}
					if (t.raphael && t.raphaelid) {
						raphaelObj = self.getById(t.raphaelid);
						point = _getShowPoint(raphaelObj, o.compass);
					}
					// raphaelObj = $(e.target).data("raphaelObj");
					// if (!raphaelObj) {
					// raphaelObj = $(e.target.parentNode).data("raphaelObj");
					// }
					// point = _getShowPoint(raphaelObj, o.compass);
					break;
				}
				_showAt(point, e);
			},

			_bindEvent = function (tar) {
				switch (o.triggers) {
				case "hover":
					$(tar.node).bind("mouseover.Rtooltip", function (e) {
						_show(e);
					}).bind("mouseout.Rtooltip", function (e) {
						if (o.closeBehavior === "auto") {
							_hide(e);
						}
					});
					if (o.mouseTrailing && o.relativeTo === "mouse") {
						$(tar.node).bind("mousemove.Rtooltip", function (e) {
							_show(e);
						});
					}
					break;
				case "click":
					$(tar.node).bind("click.Rtooltip", function (e) {
						_show(e);
					});
					break;
				case "custom":
					break;
					/*
					* case "rightClick": $(tar.node).bind("contextmenu.Rtooltip",
					* function (e) { _show(e); }); break;
					*/ 
				}
			},

			_bindLiveEvent = function (tars) {
				var i,
					ii;
				if (tars) {
					if (tars.length) {
						for (i = 0, ii = tars.length; i < ii; i++) {
							_bindEvent(tars[i]);
						}
					} else {
						_bindEvent(tars);
					}
				}
			},

			_bindLiveEventBySelector = function () {
				if (selector) {
					switch (o.triggers) {
					case "hover":
						selector.live("mouseover.Rtooltip", function (e) {
							_show(e);
						}).live("mouseout.Rtooltip", function (e) {
							if (o.closeBehavior === "auto") {
								_hide(e);
							}
						});
						if (o.mouseTrailing && o.relativeTo === "mouse") {
							selector.live("mousemove.Rtooltip", function (e) {
								_show(e);
							});
						}
						break;
					case "click":
						selector.live("click.Rtooltip", function (e) {
							_show(e);
						});
						break;
					case "custom":
						break;
						/*
						* case "rightClick":
						* $(tar.node).bind("contextmenu.Rtooltip", function (e) {
						* _show(e); }); break;
						*/ 
					}
				}
			},

			_unbindLiveEvent = function () {
				var i,
					ii;
				if (targets) {
					if (targets.length) {
						for (i = 0, ii = targets.length; i < ii; i++) {
							$(targets[i].node).unbind(".Rtooltip");
						}
					} else {
						$(targets.node).unbind(".Rtooltip");
					}
				}
				if (selector) {
					selector.die("Rtooltip")
					// for jQuery 1.7.1
					.die(".Rtooltip");
				}
			},

			_destroy = function () {
				_unbindLiveEvent();
				_removeTooltip(0);
			},

			Tooltip = function () {

				this.hide = function () {
					_hide();
				};

				// this.show = function () {
				// };

				this.showAt = function (point) {
					_showAt(point);
				};

				this.resetCalloutOffset = function (offset) {
					var currentOffset = o.calloutOffset,
						side = o.calloutSide,
						ani = o.calloutAnimation;
					if (callout) {
						if (side === "south" || side === "north") {
							callout.animate({
								"translation": (offset - currentOffset) + ",0"
							}, ani.duration, ani.easing);
						} else if (side === "east" || side === "west") {
							callout.animate({
								"translation": "0," + (offset - currentOffset)
							}, ani.duration, ani.easing);
						}
					}
					o.calloutOffset = offset;
				};

				this.destroy = function () {
					_destroy();
				};

				this.getOptions = function () {
					return o;
				};

				this.setTargets = function (targets) {
					_bindLiveEvent(targets);
				};

				this.setSelector = function (sel) {
					selector = sel;
					_bindLiveEventBySelector();
				};

				this.setOptions = function (options) {
					o = $.extend(true, o, options);
				};
			};


		// bind event.
		if (targets) {
			_bindLiveEvent(targets);
		}
		if (selector) {
			_bindLiveEventBySelector(selector);
		}

		return new Tooltip();
	};

	Raphael.fn.tooltip.animations = {
		fade: function (options) {
			var eles = options.context;
			if (options.show) {
				eles.attr({ "opacity": 0 });
				eles.animate({ "opacity": 1 }, options.duration, options.easing);
			} else {
				eles.animate({ "opacity": 0 }, options.duration, options.easing);
			}
		}
	};
} (jQuery));

(function ($) {
	"use strict";

	$.widget("wijmo.wijchartcore", {
		options: {
			// / <summary>
			// / A value that indicates the width of wijchart.
			// / Default: null.
			// / Type: Number.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / width: 600
			// / });
			// / <remarks>
			// / If the value is null, then the width will be calculated
			// / by dom element which is used to put the canvas.
			// / </remarks>
			// / </summary>
			width: null,
			// / <summary>
			// / A value that indicates the height of wijchart.
			// / Default: null.
			// / Type: Number.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / height: 400
			// / });
			// / <remarks>
			// / If the value is null, then the height will be calculated
			// / by dom element which is used to put the canvas.
			// / </remarks>
			// / </summary>
			height: null,
			/// <summary>
			/// a value that determines the culture ID name.
			/// Default: "",
			/// Type: String
			/// Code example:
			/// $("#chartcore").wijchartcore({culture: "zh"})
			/// </summary>
			culture: "",
			// / <summary>
			// / An array collection that contains the data to be charted.
			// / Default: [].
			// / Type: Array.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / seriesList: [{
			// / label: "Q1",
			// / legendEntry: true,
			// / data: {
			// / x: [1, 2, 3, 4, 5],
			// / y: [12, 21, 9, 29, 30]
			// / },
			// / offset: 0
			// / }, {
			// / label: "Q2",
			// / legendEntry: true,
			// / data: {
			// / xy: [1, 21, 2, 10, 3, 19, 4, 31, 5, 20]
			// / },
			// / offset: 0
			// / }]
			// / OR
			// / seriesList: [{
			// / label: "Q1",
			// / legendEntry: true,
			// / data: {
			// / x: ["A", "B", "C", "D", "E"],
			// / y: [12, 21, 9, 29, 30]
			// / },
			// / offset: 0
			// / }]
			// / OR
			// / seriesList: [{
			// / label: "Q1",
			// / legendEntry: true,
			// / data: {
			// / x: [new Date(1978, 0, 1), new Date(1980, 0, 1),
			// / new Date(1981, 0, 1), new Date(1982, 0, 1),
			// / new Date(1983, 0, 1)],
			// / y: [12, 21, 9, 29, 30]
			// / },
			// / offset: 0
			// / }]
			// / });
			// / </summary>
			seriesList: [],
			// / <summary>
			// / An array collection that contains the style to be charted.
			// / Default: [{stroke: "#00cc00", opacity: 0.9, "stroke-width": 1},
			// {
			// / stroke: "#0099cc", opacity: 0.9, "stroke-width": 1}, {
			// / stroke: "#0055cc", opacity: 0.9, "stroke-width": 1}, {
			// / stroke: "#2200cc", opacity: 0.9, "stroke-width": 1}, {
			// / stroke: "#8800cc", opacity: 0.9, "stroke-width": 1}, {
			// / stroke: "#d9007e", opacity: 0.9, "stroke-width": 1}, {
			// / stroke: "#ff0000", opacity: 0.9, "stroke-width": 1}, {
			// / stroke: "#ff6600", opacity: 0.9, "stroke-width": 1}, {
			// / stroke: "#ff9900", opacity: 0.9, "stroke-width": 1}, {
			// / stroke: "#ffcc00", opacity: 0.9, "stroke-width": 1}, {
			// / stroke: "#ffff00", opacity: 0.9, "stroke-width": 1}, {
			// / stroke: "#ace600", opacity: 0.9, "stroke-width": 1}].
			// / Type: Array.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / seriesStyles: [
			// / {fill: "rgb(255,0,0)", stroke:"none"},
			// / { fill: "rgb(255,125,0)", stroke: "none" }
			// / ]});
			// / </summary>
			seriesStyles: [{
				stroke: "#00cc00",
				opacity: 0.9,
				"stroke-width": 1
			}, {
				stroke: "#0099cc",
				opacity: 0.9,
				"stroke-width": 1
			}, {
				stroke: "#0055cc",
				opacity: 0.9,
				"stroke-width": 1
			}, {
				stroke: "#2200cc",
				opacity: 0.9,
				"stroke-width": 1
			}, {
				stroke: "#8800cc",
				opacity: 0.9,
				"stroke-width": 1
			}, {
				stroke: "#d9007e",
				opacity: 0.9,
				"stroke-width": 1
			}, {
				stroke: "#ff0000",
				opacity: 0.9,
				"stroke-width": 1
			}, {
				stroke: "#ff6600",
				opacity: 0.9,
				"stroke-width": 1
			}, {
				stroke: "#ff9900",
				opacity: 0.9,
				"stroke-width": 1
			}, {
				stroke: "#ffcc00",
				opacity: 0.9,
				"stroke-width": 1
			}, {
				stroke: "#ffff00",
				opacity: 0.9,
				"stroke-width": 1
			}, {
				stroke: "#ace600",
				opacity: 0.9,
				"stroke-width": 1
			}],
			// / <summary>
			// / An array collection that contains the style to
			// / be charted when hovering the chart element.
			// / Default: [{opacity: 1, "stroke-width": 1.5}, {
			// / opacity: 1, "stroke-width": 1.5}, {
			// / opacity: 1, "stroke-width": 1.5}, {
			// / opacity: 1, "stroke-width": 1.5}, {
			// / opacity: 1, "stroke-width": 1.5}, {
			// / opacity: 1, "stroke-width": 1.5}, {
			// / opacity: 1, "stroke-width": 1.5}, {
			// / opacity: 1, "stroke-width": 1.5}, {
			// / opacity: 1, "stroke-width": 1.5}, {
			// / opacity: 1, "stroke-width": 1.5}, {
			// / opacity: 1, "stroke-width": 1.5}, {
			// / opacity: 1, "stroke-width": 1.5}].
			// / Type: Array.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / seriesHoverStyles: [
			// / {fill: "rgb(255,0,0)", stroke:"none"},
			// / { fill: "rgb(255,125,0)", stroke: "none" }
			// / ]});
			// / </summary>
			seriesHoverStyles: [{
				opacity: 1,
				"stroke-width": 1.5
			}, {
				opacity: 1,
				"stroke-width": 1.5
			}, {
				opacity: 1,
				"stroke-width": 1.5
			}, {
				opacity: 1,
				"stroke-width": 1.5
			}, {
				opacity: 1,
				"stroke-width": 1.5
			}, {
				opacity: 1,
				"stroke-width": 1.5
			}, {
				opacity: 1,
				"stroke-width": 1.5
			}, {
				opacity: 1,
				"stroke-width": 1.5
			}, {
				opacity: 1,
				"stroke-width": 1.5
			}, {
				opacity: 1,
				"stroke-width": 1.5
			}, {
				opacity: 1,
				"stroke-width": 1.5
			}, {
				opacity: 1,
				"stroke-width": 1.5
			}],
			// / <summary>
			// / A value that indicates the top margin of the chart area.
			// / Default: 25.
			// / Type: Number.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / marginTop: 20
			// / });
			// / </summary>
			marginTop: 25,
			// / <summary>
			// / A value that indicates the right margin of the chart area.
			// / Default: 25.
			// / Type: Number.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / marginRight: 20
			// / });
			// / </summary>
			marginRight: 25,
			// / <summary>
			// / A value that indicates the bottom margin of the chart area.
			// / Default: 25.
			// / Type: Number.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / marginBottom: 20
			// / });
			// / </summary>
			marginBottom: 25,
			// / <summary>
			// / A value that indicates the left margin of the chart area.
			// / Default: 25.
			// / Type: Number.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / marginLeft: 20
			// / });
			// / </summary>
			marginLeft: 25,
			// / <summary>
			// / A value that indicates the style of the chart text.
			// / Default: {fill:"#888", "font-size": 10, stroke:"none"}.
			// / Type: Object.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / textStyle: {fill: "red"}
			// / });
			// / </summary>
			textStyle: {
				fill: "#888",
				"font-size": 10,
				stroke: "none"
			},
			// / <summary>
			// / An object that value indicates the header of the chart element.
			// / Type: Object.
			// / Default: { text:"",visible:true, style:{fill:"none", stroke:"none"},
			// / textStyle:{"font-size": 18, fill:"#666", stroke:"none"},
			// / compass:"north", orientation:"horizontal"}
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / header: {
			// / text:"header",
			// / style:{
			// / fill:"#f1f1f1",
			// / stroke:"#010101"
			// / }}
			// / });
			// / </summary>
			header: {
				// / <summary>
				// / A value that indicates the text of the header.
				// / Default: "".
				// / Type: String.
				// / </summary>
				text: "",
				// / <summary>
				// / A value that indicates the style of the header.
				// / Default: {fill:"none", stroke:"none"}.
				// / Type: Object.
				// / </summary>
				style: {
					fill: "none",
					stroke: "none"
				},
				// / <summary>
				// / A value that indicates the style of the header text.
				// / Default: {"font-size": 18, fill:"#666", stroke:"none"}.
				// / Type: Object.
				// / </summary>
				textStyle: {
					"font-size": 18,
					fill: "#666",
					stroke: "none"
				},
				// / <summary>
				// / A value that indicates the compass of the header.
				// / Default: "north".
				// / Type: String.
				// / </summary>
				// / <remarks>
				// / Options are 'north', 'south', 'east' and 'west'.
				// / </remarks>
				compass: "north",
				// / <summary>
				// / A value that indicates the orientation of the header.
				// / Default: "horizontal".
				// / Type: String.
				// / </summary>
				// / <remarks>
				// / Options are 'horizontal' and 'vertical'.
				// / </remarks>
				orientation: "horizontal",
				// / <summary>
				// / A value that indicates the visibility of the header.
				// / Default: true.
				// / Type: Boolean.
				// / </summary>
				visible: true
			},
			// / <summary>
			// / An object value that indicates the footer of the chart element.
			// / Type: Object.
			// / Default: {text:"",visible:false, style:{fill:"#fff", stroke:"none"},
			// / textStyle:{fille:"#000", stroke:"none"}, compass:"south",
			// / orientation:"horizontal"}
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / footer: {
			// / text:"footer",
			// / style:{
			// / fill:"#f1f1f1",
			// / stroke:"#010101"
			// / }}
			// / });
			// / </summary>
			footer: {
				// / <summary>
				// / A value that indicates the text of the footer.
				// / Default: "".
				// / Type: String.
				// / </summary>
				text: "",
				// / <summary>
				// / A value that indicates the style of the footer.
				// / Default: {fill:"#fff", stroke:"none"}.
				// / Type: Object.
				// / </summary>
				style: {
					fill: "#fff",
					stroke: "none"
				},
				// / <summary>
				// / A value that indicates the style of the footer text.
				// / Default: {fill:"#000", stroke:"none"}.
				// / Type: Object.
				// / </summary>
				textStyle: {
					fill: "#000",
					stroke: "none"
				},
				// / <summary>
				// / A value that indicates the compass of the footer.
				// / Default: "south".
				// / Type: String.
				// / </summary>
				// / <remarks>
				// / Options are 'north', 'south', 'east' and 'west'.
				// / </remarks>
				compass: "south",
				// / <summary>
				// / A value that indicates the orientation of the footer.
				// / Default: "horizontal".
				// / Type: String.
				// / </summary>
				// / <remarks>
				// / Options are 'horizontal' and 'vertical'.
				// / </remarks>
				orientation: "horizontal",
				// / <summary>
				// / A value that indicates the visibility of the footer.
				// / Default: false.
				// / Type: Boolean.
				// / </summary>
				visible: false
			},
			// / <summary>
			// / An object value indicates the legend of the chart element.
			// / Type: Object.
			// / Default: {text:"", textMargin:{left:2,top:2,right:2,bottom:2},
			// / titleStyle:{"font-weight":"bold",fill:"#000",stroke:"none},
			// / visible:true, style:{fill:"#none", stroke:"none"},
			// / textStyle:{fille:"#333", stroke:"none"}, compass:"east",
			// / orientation:"vertical"}
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / legend: {
			// / text:"legend",
			// / style:{
			// / fill:"#f1f1f1",
			// / stroke:"#010101"
			// / }}
			// / });
			// / </summary>
			legend: {
				// / <summary>
				// / A value that indicates the text of the legend.
				// / Default: "".
				// / Type: String.
				// / </summary>
				text: "",
				// / <summary>
				// / A value that indicates the text margin of the legend item.
				// / Default: {left:2, top:2, right:2, bottom:2}.
				// / Type: Object.
				// / </summary>
				textMargin: { left: 2, top: 2, right: 2, bottom: 2 },
				// / <summary>
				// / A value that indicates the style of the legend.
				// / Default: {fill:"#none", stroke:"none"}.
				// / Type: Object.
				// / </summary>
				style: {
					fill: "none",
					stroke: "none"
				},
				// / <summary>
				// / A value that indicates the style of the legend text.
				// / Default: {fill:"#333", stroke:"none"}.
				// / Type: Object.
				// / </summary>
				textStyle: {
					fill: "#333",
					stroke: "none"
				},
				// / <summary>
				// / A value that indicates the style of the legend title.
				// / Default: {"font-weight": "bold", fill:"#000",
				// stroke:"none"}.
				// / Type: Object.
				// / </summary>
				titleStyle: {
					"font-weight": "bold",
					fill: "#000",
					stroke: "none"
				},
				// / <summary>
				// / A value that indicates the compass of the legend.
				// / Default: "east".
				// / Type: String.
				// / </summary>
				// / <remarks>
				// / Options are 'north', 'south', 'east' and 'west'.
				// / </remarks>
				compass: "east",
				// / <summary>
				// / A value that indicates the orientation of the legend.
				// / Default: "vertical".
				// / Type: String.
				// / </summary>
				// / <remarks>
				// / Options are 'horizontal' and 'vertical'.
				// / </remarks>
				orientation: "vertical",
				// / <summary>
				// / A value that indicates the visibility of the legend.
				// / Default: true.
				// / Type: Boolean.
				// / </summary>
				visible: true
			},
			// / <summary>
			// / A value that provides information about the axes.
			// / Default: {x:{alignment:"center",
			// / style:{stroke:"#999999","stroke-width":0.5}, visible:true,
			// / textVisible:true, text:"", textStyle:{fill: "#888", "font-size": 15,
			// / "font-weight": "bold"},labels: {style: {fill: "#333",
			// / "font-size": 11},textAlign: "near", width: null},
			// / compass:"south",
			// / autoMin:true,autoMax:true,autoMajor:true,autoMinor:true,
			// / gridMajor:{visible:false,style:{stroke:"#CACACA",
			// / "stroke-dasharray":"- "}}},gridMinor:{visible:false,
			// / style:{stroke:"#CACACA","stroke-dasharray":"- "}}},
			// / tickMajor:{position:"none",style:{fill:"black"},factor:1},
			// / tickMinor:{position:"none",style:{fill:"black"},factor:1},
			// / annoMethod:"values", annoFormatString:"",valueLabels:[]},
			// / y:{alignment:"center",style:{stroke: "#999999",
			// / "stroke-width": 0.5},visible:false, text:"", textVisible:true,
			// / textStyle: {fill: "#888","font-size": 15,
			// / "font-weight": "bold"},labels: {style: {fill: "#333",
			// / "font-size": 11},textAlign: "center", width: null},
			// / compass:"west",
			// / autoMin:true,autoMax:true,autoMajor:true,autoMinor:true,
			// / gridMajor:{visible:true, style:{stroke:"#999999",
			// / "stroke-width": 0.5,"stroke-dasharray":"none"}}},
			// / gridMinor:{visible:false, style:{stroke:"#CACACA",
			// / "stroke-dasharray":"- "}}},tickMajor:{position:"none",
			// / style:{fill:"black"},factor:1},tickMinor:{position:"none",
			// /
			/// style:{fill:"black"},factor:1},annoMethod:"values", 
			/// annoFormatString:"",valueLabels:[]}.
			// / Type: Object.
			// / Code example:
			// / $("#chartcore").wijchartcore({axis:{
			// /	x: { text:"x" }, y: { text: "y" }
			// / }}) 
			// / </summary>
			axis: {
				// / <summary>
				// / A value that provides information for the X axis.
				// / Default: {alignment:"center",style:{stroke:"#999999",
				// / "stroke-width":0.5}, visible:true, text:"", textVisible:true,
				// / textStyle:{fill: "#888", "font-size": 15,
				// / "font-weight": "bold"}, labels: {style: {fill: "#333",
				// / "font-size": 11},textAlign: "near", width: null},
				// / compass:"south",
				// / autoMin:true,autoMax:true,autoMajor:true,autoMinor:true,
				// / gridMajor:{visible:false, style:{stroke:"#CACACA",
				// / "stroke-dasharray":"- "}}},gridMinor:{visible:false,
				// / style:{stroke:"#CACACA","stroke-dasharray":"- "}}},
				// / tickMajor:{position:"none",style:{fill:"black"},factor:1},
				// / tickMinor:{position:"none",style:{fill:"black"},factor:1},
				// / annoMethod:"values", annoFormatString:"",valueLabels:[]}.
				// / Type: Object.
				// / </summary>
				x: {
					// / <summary>
					// / A value that indicates the alignment of the X axis
					// text.
					// / Default: "center".
					// / Type: String.
					// / </summary>
					// / <remarks>
					// / Options are 'center', 'near', 'far'.
					// / </remarks>
					alignment: "center",
					// / <summary>
					// / A value that indicates the style of the X axis.
					// / Default: {stroke: "#999999", "stroke-width": 0.5}.
					// / Type: Object.
					// / </summary>
					style: {
						stroke: "#999999",
						"stroke-width": 0.5
					},
					// / <summary>
					// / A value that indicates the visibility of the X axis.
					// / Default: true.
					// / Type: Boolean.
					// / </summary>
					visible: true,
					// / <summary>
					// / A value that indicates the visibility of the X axis
					// text.
					// / Default: true.
					// / Type: Boolean.
					// / </summary>
					textVisible: true,
					// / <summary>
					// / A value that indicates the text of the X axis text.
					// / Default: "".
					// / Type: String.
					// / </summary>
					text: "",
					// / <summary>
					// / A value that indicates the style of text of the X axis.
					// / Default: {fill: "#888","font-size": 15,"font-weight":
					// "bold"}.
					// / Type: Object.
					// / </summary>
					textStyle: {
						fill: "#888",
						"font-size": 15,
						"font-weight": "bold"
					},
					// / <summary>
					// / A value that provides information for the labels.
					// / Default: {style: {fill: "#333","font-size": 11},
					// / textAlign: "near", width: null}.
					// / Type: Object.
					// / </summary>
					labels: {
						// / <summary>
						// / A value that indicates the style of major text of
						// the X axis.
						// / Default: {fill: "#333","font-size": 11}.
						// / Type: Object.
						// / </summary>
						style: {
							fill: "#333",
							"font-size": 11
						},
						// / <summary>
						// / A value that indicates the alignment
						// / of major text of the X axis.
						// / Default: "near".
						// / Type: String.
						// / </summary>
						// / <remarks>
						// / Options are 'near', 'center' and 'far'.
						// / </remarks>
						textAlign: "near",
						// / <summary>
						// / A value that indicates the width of major text of
						// the X axis.
						// / Default: null.
						// / Type: Number.
						// / <remarks>
						// / If the value is null, then the width
						// / will be calculated automatically.
						// / </remarks>
						// / </summary>
						width: null
					},
					// / <summary>
					// / A value that indicates the compass of the X axis.
					// / Default: "south".
					// / Type: String.
					// / </summary>
					// / <remarks>
					// / Options are 'north', 'south', 'east' and 'west'.
					// / </remarks>
					compass: "south",
					// / <summary>
					// / A value that indicates whether the minimum axis
					// / value is calculated automatically.
					// / Default: true.
					// / Type: Boolean.
					// / </summary>
					autoMin: true,
					// / <summary>
					// / A value that indicates whether the maximum axis
					// / value is calculated automatically.
					// / Default: true.
					// / Type: Boolean.
					// / </summary>
					autoMax: true,
					// / <summary>
					// / A value that indicates the minimum value of the X axis.
					// / Default: null.
					// / Type: Number.
					// / </summary>
					min: null,
					// / <summary>
					// / A value that indicates the maximum value of the X axis.
					// / Default: null.
					// / Type: Number.
					// / </summary>
					max: null,
					// / <summary>
					// / A value that indicates the origin value of the X axis.
					// / Default: null.
					// / Type: Number.
					// / </summary>
					origin: null,
					// / <summary>
					// / A value that indicates whether the major tick mark
					// / values are calculated automatically.
					// / Default: true.
					// / Type: Boolean.
					// / </summary>
					autoMajor: true,
					// / <summary>
					// / A value that indicates whether the minor tick mark
					// / values are calculated automatically.
					// / Default: true.
					// / Type: Boolean.
					// / </summary>
					autoMinor: true,
					// / <summary>
					// / A value that indicates the units between major tick
					// marks.
					// / Default: null.
					// / Type: Number.
					// / </summary>
					unitMajor: null,
					// / <summary>
					// / A value that indicates the units between minor tick
					// marks.
					// / Default: null.
					// / Type: Number.
					// / </summary>
					unitMinor: null,
					// / <summary>
					// / A value that provides information for the major grid
					// line.
					// / Default: {visible:false,
					// / style:{stroke:"#CACACA","stroke-dasharray":"- "}}.
					// / Type: Object.
					// / </summary>
					gridMajor: {
						// / <summary>
						// / A value that indicates the visibility of the major
						// grid line.
						// / Default: false.
						// / Type: Boolean.
						// / </summary>
						visible: false,
						// / <summary>
						// / A value that indicates the style of the major grid
						// line.
						// / Default: {stroke:"#CACACA", "stroke-dasharray": "-
						// "}.
						// / Type: Object.
						// / </summary>
						style: {
							stroke: "#CACACA",
							"stroke-dasharray": "- "
						}
					},
					// / <summary>
					// / A value that provides information for the minor grid
					// line.
					// / Default: {visible:false,
					// / style:{stroke:"#CACACA","stroke-dasharray":"- "}}.
					// / Type: Object.
					// / </summary>
					gridMinor: {
						// / <summary>
						// / A value that indicates the visibility of the minor
						// grid line.
						// / Default: false.
						// / Type: Boolean.
						// / </summary>
						visible: false,
						// / <summary>
						// / A value that indicates the style of the minor grid
						// line.
						// / Default: {stroke:"#CACACA", "stroke-dasharray": "-
						// "}.
						// / Type: Object.
						// / </summary>
						style: {
							stroke: "#CACACA",
							"stroke-dasharray": "- "
						}
					},
					// / <summary>
					// / A value that provides information for the major tick.
					// / Default: {position:"none", style:{fill:"black"},
					// factor:1}.
					// / Type: Object.
					// / </summary>
					tickMajor: {
						// / <summary>
						// / A value that indicates the type of major tick mark.
						// / Default: "none".
						// / Type: String.
						// / </summary>
						// / <remarks>
						// / Options are 'none', 'inside', 'outside' and
						// 'cross'.
						// / </remarks>
						position: "none",
						// / <summary>
						// / A value that indicates the style of major tick
						// mark.
						// / Default: {fill: "black"}.
						// / Type: Object.
						// / </summary>
						style: { fill: "black" },
						// / <summary>
						// / A value that indicates an integral
						// / factor for major tick mark length.
						// / Default: 1.
						// / Type: Number.
						// / </summary>
						factor: 1
					},
					// / <summary>
					// / A value that provides information for the minor tick.
					// / Default: {position:"none", style:{fill:"black"},
					// factor:1}.
					// / Type: Object.
					// / </summary>
					tickMinor: {
						// / <summary>
						// / A value that indicates the type of minor tick mark.
						// / Default: "none".
						// / Type: String.
						// / </summary>
						// / <remarks>
						// / Options are 'none', 'inside', 'outside' and
						// 'cross'.
						// / </remarks>
						position: "none",
						// / <summary>
						// / A value that indicates the style of minor tick
						// mark.
						// / Default: {fill: "black"}.
						// / Type: Object.
						// / </summary>
						style: { fill: "black" },
						// / <summary>
						// / A value that indicates an integral
						// / factor for minor tick mark length.
						// / Default: 1.
						// / Type: Number.
						// / </summary>
						factor: 1
					},
					// / <summary>
					// / A value that indicates the method of annotation.
					// / Default: "values".
					// / Type: String.
					// / </summary>
					// / <remarks>
					// / Options are 'values', 'valueLabels'.
					// / </remarks>
					annoMethod: "values",
					// / <summary>
					// / A value that indicates the format string of annotation.
					// / Default: "".
					// / Type: String.
					// / </summary>
					annoFormatString: "",
					// / <summary>
					// / A value that shows a collection of valueLabels for the
					// X axis.
					// / Default: [].
					// / Type: Array.
					// / </summary>
					valueLabels: []
					// todo.
					// autoOrigin: true,
					// origin: null,
					// tickLabel: "nextToAxis",
				},
				// / <summary>
				// / A value that provides infomation for the Y axis.
				// / Default: {alignment:"center",style:{stroke: "#999999",
				// / "stroke-width": 0.5},visible:false, textVisible:true,
				// / text:"", textStyle: {fill: "#888","font-size": 15,
				// / "font-weight": "bold"}, labels: {style: {fill: "#333",
				// / "font-size": 11},textAlign: "center", width: null},
				// / compass:"west",
				// / autoMin:true,autoMax:true,autoMajor:true,autoMinor:true,
				// / gridMajor:{visible:true, style:{stroke:"#999999",
				// / "stroke-width": 0.5, "stroke-dasharray":"none"}}},
				// / gridMinor:{visible:false, style:{stroke:"#CACACA",
				// / "stroke-dasharray":"- "}}},tickMajor:{position:"none",
				// / style:{fill:"black"},factor:1},tickMinor:{position:"none",
				// / style:{fill:"black"},factor:1},annoMethod:"values",
				// / annoFormatString:"", valueLabels:[]}
				// / Type: Object.
				// / </summary>
				y: {
					// / <summary>
					// / A value that indicates the alignment of the Y axis
					// text.
					// / Default: "center".
					// / Type: String.
					// / </summary>
					// / <remarks>
					// / Options are 'center', 'near', 'far'.
					// / </remarks>
					alignment: "center",
					// / <summary>
					// / A value that indicates the style of the Y axis.
					// / Default: {stroke:"#999999", "stroke-width": 0.5}.
					// / Type: Object.
					// / </summary>
					style: {
						stroke: "#999999",
						"stroke-width": 0.5
					},
					// / <summary>
					// / A value that indicates the visibility of the Y axis.
					// / Default: false.
					// / Type: Boolean.
					// / </summary>
					visible: false,
					// / <summary>
					// / A value that indicates the visibility of the Y axis
					// text.
					// / Default: true.
					// / Type: Boolean.
					// / </summary>
					textVisible: true,
					// / <summary>
					// / A value that indicates the text of the Y axis text.
					// / Default: "".
					// / Type: String.
					// / </summary>
					text: "",
					// / <summary>
					// / A value that indicates the style of text of the Y axis.
					// / Default: {fill: "#888", "font-size": 15,
					// / "font-weight": "bold"}.
					// / Type: Object.
					// / </summary>
					textStyle: {
						fill: "#888",
						"font-size": 15,
						"font-weight": "bold"
					},
					// / <summary>
					// / A value that provides information for the labels.
					// / Default: {style: {fill: "#333","font-size": 11},
					// / textAlign: "center", width: null}.
					// / Type: Object.
					// / </summary>
					labels: {
						// / <summary>
						// / A value that indicates the style of major text of
						// the Y axis.
						// / Default: {fill: "#333","font-size": 11}.
						// / Type: Object.
						// / </summary>
						style: {
							fill: "#333",
							"font-size": 11
						},
						// / <summary>
						// / A value that indicates the
						// / of major text of the Y axis.
						// / Default: "center".
						// / Type: String.
						// / </summary>
						// / <remarks>
						// / Options are 'near', 'center' and 'far'.
						// / </remarks>
						textAlign: "center",
						// / <summary>
						// / A value that indicates the width major text of the
						// Y axis.
						// / Default: null.
						// / Type: Number.
						// / <remarks>
						// / If the value is null, then the width
						// / will be calculated automatically.
						// / </remarks>
						// / </summary>
						width: null
					},
					// / <summary>
					// / A value that indicates the compass of the Y axis.
					// / Default: "west".
					// / Type: String.
					// / </summary>
					// / <remarks>
					// / Options are 'north', 'south', 'east' and 'west'.
					// / </remarks>
					compass: "west",
					// / <summary>
					// / A value that indicates whether the minimum axis
					// / value is calculated automatically.
					// / Default: true.
					// / Type: Boolean.
					// / </summary>
					autoMin: true,
					// / <summary>
					// / A value that indicates whether the maximum axis
					// / value is calculated automatically.
					// / Default: true.
					// / Type: Boolean.
					// / </summary>
					autoMax: true,
					// / <summary>
					// / A value that indicates the minimum value of the Y axis.
					// / Default: null.
					// / Type: Number.
					// / </summary>
					min: null,
					// / <summary>
					// / A value that indicates the maximum value of the Y axis.
					// / Default: null.
					// / Type: Number.
					// / </summary>
					max: null,
					// / <summary>
					// / A value that indicates the origin value of the Y axis.
					// / Default: null.
					// / Type: Number.
					// / </summary>
					origin: null,
					// / <summary>
					// / A value that indicates whether the major tick mark
					// / values are calculated automatically.
					// / Default: true.
					// / Type: Boolean.
					// / </summary>
					autoMajor: true,
					// / <summary>
					// / A value that indicates whether the minor tick mark
					// / values are calculated automatically.
					// / Default: true.
					// / Type: Boolean.
					// / </summary>
					autoMinor: true,
					// / <summary>
					// / A value that indicates the units between major tick
					// marks.
					// / Default: null.
					// / Type: Number.
					// / </summary>
					unitMajor: null,
					// / <summary>
					// / A value that indicates the units between minor tick
					// marks.
					// / Default: null.
					// / Type: Number.
					// / </summary>
					unitMinor: null,
					// / <summary>
					// / A value that provides information for the major grid
					// line.
					// / Default: {visible:true, style:{stroke:"#999999",
					// / "stroke-width": 0.5,"stroke-dasharray":"none"}}.
					// / Type: Object.
					// / </summary>
					gridMajor: {
						// / <summary>
						// / A value that indicates the visibility of the major
						// grid line.
						// / Default: true.
						// / Type: Boolean.
						// / </summary>
						visible: true,
						// / <summary>
						// / A value that indicates the style of the major grid
						// line.
						// / Default: {stroke:"#999999", "stroke-width": 0.5,
						// / "stroke-dasharray": "none"}.
						// / Type: Object.
						// / </summary>
						style: {
							stroke: "#999999",
							"stroke-width": 0.5,
							"stroke-dasharray": "none"
						}
					},
					// / <summary>
					// / A value that provides information for the minor grid
					// line.
					// / Default: {visible:false, style:{stroke:"#CACACA",
					// / "stroke-dasharray":"- "}}.
					// / Type: Object.
					// / </summary>
					gridMinor: {
						// / <summary>
						// / A value that indicates the visibility of the minor
						// grid line.
						// / Default: false.
						// / Type: Boolean.
						// / </summary>
						visible: false,
						// / <summary>
						// / A value that indicates the style of the minor grid
						// line.
						// / Default: {stroke:"#CACACA", "stroke-dasharray": "-
						// "}.
						// / Type: Object.
						// / </summary>
						style: {
							stroke: "#CACACA",
							"stroke-dasharray": "- "
						}
					},
					// / <summary>
					// / A value that provides information for the major tick.
					// / Default: {position:"none", style:{fill:"black"},
					// factor:1}.
					// / Type: Object.
					// / </summary>
					tickMajor: {
						// / <summary>
						// / A value that indicates the type of major tick mark.
						// / Default: "none".
						// / Type: String.
						// / </summary>
						// / <remarks>
						// / Options are 'none', 'inside', 'outside' and
						// 'cross'.
						// / </remarks>
						position: "none",
						// / <summary>
						// / A value that indicates the style of major tick
						// mark.
						// / Default: {fill: "black"}.
						// / Type: Object.
						// / </summary>
						style: { fill: "black" },
						// / <summary>
						// / A value that indicates an integral factor
						// / for major tick mark length.
						// / Default: 1.
						// / Type: Number.
						// / </summary>
						factor: 1
					},
					// / <summary>
					// / A value that provides information for the minor tick.
					// / Default: {position:"none", style:{fill:"black"},
					// factor:1}.
					// / Type: Object.
					// / </summary>
					tickMinor: {
						// / <summary>
						// / A value that indicates the type of minor tick mark.
						// / Default: "none".
						// / Type: String.
						// / </summary>
						// / <remarks>
						// / Options are 'none', 'inside', 'outside' and
						// 'cross'.
						// / </remarks>
						position: "none",
						// / <summary>
						// / A value that indicates the style of minor tick
						// mark.
						// / Default: {fill: "black"}.
						// / Type: Object.
						// / </summary>
						style: { fill: "black" },
						// / <summary>
						// / A value that indicates an integral
						// / factor for minor tick mark length.
						// / Default: 1.
						// / Type: Number.
						// / </summary>
						factor: 1
					},
					// / <summary>
					// / A value that indicates the method of annotation.
					// / Default: "values".
					// / Type: String.
					// / </summary>
					// / <remarks>
					// / options are 'values', 'valueLabels'.
					// / </remarks>
					annoMethod: "values",
					// / <summary>
					// / A value that indicates the format string of annotation.
					// / Default: "".
					// / Type: String.
					// / </summary>
					annoFormatString: "",
					// / <summary>
					// / A value that shows a collection of valueLabels for the
					// y axis.
					// / Default: [].
					// / Type: Array.
					// / </summary>
					valueLabels: []
					// todo.
					// autoOrigin: true,
					// origin: null,
					// tickLabel: "nextToAxis",
				}
			},
			// / <summary>
			// / A value that is used to indicate whether to show
			// / and what to show on the open tooltip.
			// / Default: {enable:true, content:null,
			// / contentStyle: {fill: "#d1d1d1","font-size": 16},
			// / title:null,
			// / titleStyle: {fill: "#d1d1d1","font-size": 16},
			// / style: {fill: "#000000", "stroke-width": "2"},
			// / animated: "fade", showAnimated: "fade", hideAnimated: "fade",
			// / duration: 120, showDuration: 120, hideDuration: 120,
			// / showDelay: 0, hideDelay: 150, easing: "",
			// / showEasing: "", hideEasing: "",
			// / compass:"north", offsetX: 0, offsetY: 0,
			// / showCallout: true, calloutFilled: false,
			// / calloutFilledStyle: {fill: "#000"}}.
			// / Type: Object.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / hint: {
			// / enable:true,
			// / content:function(){
			// / return this.data.label + " : " +
			// / this.value/this.total*100 + "%";
			// / }});
			// / </summary>
			hint: {
				// / <summary>
				// / A value that indicates whether to show the tooltip.
				// / Default: true.
				// / Type: Boolean.
				// / </summary>
				enable: true,
				// / <summary>
				// / A value that will be shown in the content part of the
				// tooltip
				// / or a function which is used to get a value for the tooltip
				// shown.
				// / Default: null.
				// / Type: String or Function.
				// / </summary>
				content: null,
				// / <summary>
				// / A value that indicates the style of content text.
				// / Default: {fill: "#d1d1d1","font-size": 16}.
				// / Type: Object.
				// / </summary>
				contentStyle: {
					fill: "#d1d1d1",
					"font-size": 16
				},
				// / <summary>
				// / A value that will be shown in the title part of the tooltip
				// / or a function which is used to get a value for the tooltip
				// shown.
				// / Default: null.
				// / Type: String or Function.
				// / </summary>
				title: null,
				// / <summary>
				// / A value that indicates the style of title text.
				// / Default: {fill: "#d1d1d1","font-size": 16}.
				// / Type: Object.
				// / </summary>
				titleStyle: {
					fill: "#d1d1d1",
					"font-size": 16
				},
				// / <summary>
				// / A value that indicates the style of container.
				// / Default: {fill: "#000000", "stroke-width":
				// 2}.
				// / Type: Object.
				// / </summary>
				style: {
					fill: "#000000",
					"stroke-width": 2
				},
				// / <summary>
				// / A value that indicates the effect during show or hide
				// / when showAnimated or hideAnimated isn't specified.
				// / Default:"fade".
				// / Type:String.
				// / </summary>
				animated: "fade",
				// / <summary>
				// / A value that indicates the effect during show.
				// / Default:"fade".
				// / Type:String.
				// / </summary>
				showAnimated: "fade",
				// / <summary>
				// / A value that indicates the effect during hide.
				// / Default:"fade".
				// / Type:String.
				// / </summary>
				hideAnimated: "fade",
				// / <summary>
				// / A value that indicates the millisecond to show or hide the
				// tooltip
				// / when showDuration or hideDuration isn't specified.
				// / Default:120.
				// / Type:Number.
				// / </summary>
				duration: 120,
				// / <summary>
				// / A value that indicates the millisecond to show the tooltip.
				// / Default:120.
				// / Type:Number.
				// / </summary>
				showDuration: 120,
				// / <summary>
				// / A value that indicates the millisecond to hide the tooltip.
				// / Default:120.
				// / Type:Number.
				// / </summary>
				hideDuration: 120,
				// / <summary>
				// / A value that indicates the easing during show or hide when
				// / showEasing or hideEasing isn't specified.
				// / Default: "".
				// / Type: String.
				// / </summary>
				easing: "",
				// / <summary>
				// / A value that indicates the easing during show.
				// / Default: "".
				// / Type: String.
				// / </summary>
				showEasing: "",
				// / <summary>
				// / A value that indicates the easing during hide.
				// / Default: "".
				// / Type: String.
				// / </summary>
				hideEasing: "",
				/// <summary>
				/// A value that indicates the millisecond delay to show the tooltip.
				/// Default: 0.
				/// Type: Number.
				/// </summary>
				showDelay: 0,
				// / <summary>
				// / A value that indicates the millisecond delay to hide the
				// tooltip.
				// / Default: 150.
				// / Type: Number.
				// / </summary>
				hideDelay: 150,
				// / <summary>
				// / A value that indicates the compass of the tooltip.
				// / Default: "north".
				// / Type: String.
				// / </summary>
				// / <remarks>
				// / Options are 'west', 'east', 'south', 'north',
				// / 'southeast', 'southwest', 'northeast', 'northwest'.
				// / </remarks>
				compass: "north",
				// / <summary>
				// / A value that indicates the horizontal offset
				// / of the point to show the tooltip.
				// / Default: 0.
				// / Type: Number.
				// / </summary>
				offsetX: 0,
				// / <summary>
				// / A value that indicates the vertical offset
				// / of the point to show the tooltip.
				// / Default: 0.
				// / Type: Number.
				// / </summary>
				offsetY: 0,
				// / <summary>
				// / Determines whether to show the callout element.
				// / Default:true.
				// / Type:Boolean.
				// / </summary>
				showCallout: true,
				// / <summary>
				// / Determines whether to fill the callout.
				// / If true, then the callout triangle will be filled.
				// / Default:false.
				// / Type:Boolean.
				// / </summary>
				calloutFilled: false,
				// / <summary>
				// / A value that indicates the style of the callout filled.
				// / Default: {fill: "#000"}.
				// / Type: Object.
				// / </summary>
				calloutFilledStyle: {
					fill: "#000"
				}
			},
			// / <summary>
			// / A value that indicates whether to show default chart labels.
			// / Default: true.
			// / Type: Boolean.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / showChartLabels:false
			// / });
			// / </summary>
			showChartLabels: true,
			// / <summary>
			// / A value that indicates style of the chart labels.
			// / Default: {}.
			// / Type: Object.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / chartLabelStyle: {fill: "red"}
			// / });
			// / </summary>
			chartLabelStyle: {},
			// / <summary>
			// / A value that indicates the format string of the chart labels.
			// / Default: "".
			// / Type: String.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / chartLabelFormatString: "n0"
			// / });
			// / </summary>
			chartLabelFormatString: "",
			// / <summary>
			// / A value that indicates whether to disable the default text
			// style.
			// / Default: false.
			// / Type: Boolean.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / disableDefaultTextStyle:true
			// / });
			// / </summary>
			disableDefaultTextStyle: false,
			// / <summary>
			// / A value that indicates whether to show shadow for the chart.
			// / Default: false.
			// / Type: Boolean.
			// / Code example:
			// / $("#chartcore").wijchartcore({
			// / shadow: false
			// / });
			// / </summary>
			shadow: true,
			// / <summary>
			// / Fires before the series changes. This event can be cancelled.
			// / "return false;" to cancel the event.
			// / Default: null.
			// / Type: Function.
			// / </summary>
			// / <param name="e" type="eventObj">
			// / jQuery.Event object.
			// / </param>
			// / <param name="data" type="Object">
			// / An object that contains old and new series values.
			// / data.oldSeriesList: old series list before change.
			// / data.newSeriesList: new series list that will replace old one.
			// / </param>
			beforeSeriesChange: null,
			// / <summary>
			// / Fires when the series changes.
			// / Default: null.
			// / Type: Function.
			// / </summary>
			// / <param name="e" type="eventObj">
			// / jQuery.Event object.
			// / </param>
			// / <param name="data" type="Object">
			// / An object that contains new series values.
			// / </param>
			seriesChanged: null,
			// / <summary>
			// / Fires before the canvas is painted. This event can be
			// cancelled.
			// / "return false;" to cancel the event.
			// / Default: null.
			// / Type: Function.
			// / </summary>
			// / <param name="e" type="eventObj">
			// / jQuery.Event object.
			// / </param>
			beforePaint: null,
			// / <summary>
			// / Fires after the canvas is painted.
			// / Default: null.
			// / Type: Function.
			// / </summary>
			// / <param name="e" type="eventObj">
			// / jQuery.Event object.
			// / </param>
			painted: null
		},

		innerState: {},

		// handle option changes:
		_setOption: function (key, value) {
			var self = this,
				o = self.options,
				ev = null,
				len = 0,
				idx = 0,
				oldXMajorFactor = o.axis.x.tickMajor.factor,
				oldXMinorFactor = o.axis.x.tickMinor.factor,
				oldYMajorFactor = o.axis.y.tickMajor.factor,
				oldYMinorFactor = o.axis.y.tickMinor.factor,
				styleLen,
				hoverStyleLen;


			if (key === "seriesList") {
				if (!value) {
					value = [];
				}
				
				ev = $.Event("beforeserieschange");
				if (self._trigger("beforeSeriesChange", ev, {
					oldSeriesList: o.seriesList,
					newSeriesList: value
				}) === false) {
					return false;
				}
				o.seriesList = value;
				self._trigger("seriesChanged", null, value);
				self.seriesTransition = true;
				self._init();
			} else {
				if ($.isPlainObject(o[key])) {
					$.extend(true, o[key], value);
					if (key === "axis") {
						if (o.axis.x.tickMajor.factor < 0) {
							o.axis.x.tickMajor.factor = oldXMajorFactor;
						}
						if (o.axis.x.tickMinor.factor < 0) {
							o.axis.x.tickMinor.factor = oldXMinorFactor;
						}
						if (o.axis.y.tickMajor.factor < 0) {
							o.axis.y.tickMajor.factor = oldYMajorFactor;
						}
						if (o.axis.y.tickMinor.factor < 0) {
							o.axis.y.tickMinor.factor = oldYMinorFactor;
						}
					}
				} else {
					$.Widget.prototype._setOption.apply(self, arguments);
					// o[key] = value;
				}
			}

			// Add for support disabled option at 2011/7/8
			if (key === "disabled") {
				self._handleDisabledOption(value, self.chartElement);
			}
			// end for disabled option

			// fixed a issue that when set the disabled option, 
			// because the chart is paint by
			// wij***chart plugin, and the disabled set to the plugin 
			// as a value, not a refrence,
			// so the plugin's disabled value can't change 
			// when set the disabled to charts.
			// now, we just repaint the chart.

			if (key === "seriesTransition" || key === "animation") {
			//||
			//	key === "disabled") {
				return;
			}

			len = o.seriesList.length;

			if (key === "seriesList" || key === "seriesStyles") {
				for (styleLen = o.seriesStyles.length, idx = styleLen; idx < len; idx++) {
					o.seriesStyles[idx] = o.seriesStyles[idx % styleLen];
				}
			}

			if (key === "seriesList" || key === "seriesStyles" ||
				key === "seriesHoverStyles") {
				self._initStyles();
			}

			if (key === "seriesList" || key === "seriesHoverStyles") {
				hoverStyleLen = o.seriesHoverStyles.length;
				for (idx = hoverStyleLen; idx < len; idx++) {
					o.seriesHoverStyles[idx] = o.seriesHoverStyles[idx % hoverStyleLen];
				}
			}

			self.redraw();
		},

		// if the series's lenth is more than the styles's length, extend the styles.
		_initStyles: function () {
			var o = this.options,
				styles = o.seriesStyles,
				hoverStyles = o.seriesHoverStyles,
				stylesLen, seriesLen, hoverStylesLen, i;

			if (o.seriesList) {
				seriesLen = o.seriesList.length || 0;
			}

			if (o.seriesStyles) {
				stylesLen = o.seriesStyles.length || 0;
			}

			if (o.seriesHoverStyles) {
				hoverStylesLen = o.seriesHoverStyles.length || 0;
			}

			if (seriesLen > stylesLen && stylesLen) {
				for (i = stylesLen; i < seriesLen; i++) {
					styles[i] = styles[i % stylesLen];
				}
			}

			if (seriesLen > hoverStylesLen && hoverStylesLen) {
				for (i = hoverStylesLen; i < seriesLen; i++) {
					hoverStyles[i] = hoverStyles[i % hoverStylesLen];
				}
			}
		},

		// widget creation:
		_create: function () {
			var self = this,
				o = self.options,
				width = o.width || self.element.width(),
				height = o.height || self.element.height(),
				newEle = null,
				canvas;

			self.updating = 0;
			self.innerState = {};

			// Add for parse date options for jUICE. D.H
			if ($.isFunction(window["wijmoASPNetParseOptions"])) {
				wijmoASPNetParseOptions(o);
			}

			// Extend seriesStyle
			self._initStyles();

			if (o.hint && typeof o.hint.content === "string" && window[o.hint.content]) {
				o.hint.content = window[o.hint.content];
			}
			if (o.hint && typeof o.hint.title === "string" && window[o.hint.title]) {
				o.hint.title = window[o.hint.title];
			}

			if (self.element.length > 0) {
				if (self.element.is("table")) {
					self._parseTable();
					newEle = $("<div></div>");

					if (width) {
						newEle.css("width", width);
					}

					if (height) {
						newEle.css("height", height);
					}

					self.element.after(newEle);
					self.chartElement = newEle;
				} else {
					self.chartElement = self.element;
				}

				// add for fixing bug 16039 by wuhao 2011/7/7
				if (o.disabled) {
					self.disable();
				}
				// end for bug 16039

				self.chartElement.addClass("ui-widget");
				canvas = new Raphael(self.chartElement[0], width, height);
				self.canvas = canvas;
				
				// add custom attribute to canvas
				// fixed the issue 20422 by dail on 2012-3-12, If user set 
				// rotation and scale. the transform will only effect on scale.
				canvas.customAttributes.rotation = function (num) {
				    //return {transform: "...R" + num};
					this.transform("...R" + num);
				};
				canvas.customAttributes.scale = function (num) {
					//return {transform: "...S" + num};
					this.transform("...S" + num);
				};
				canvas.customAttributes.translation = function (x, y) {
					//return {transform: Raphael.format("...T{0},{1}", x, y)};
					this.transform(Raphael.format("...T{0},{1}", x, y));
				};
				// end

				self._bindLiveEvents();
			}

			self.headerEles = [];
			self.footerEles = [];
			self.legendEles = [];
			self.axisEles = [];
			self.legends = [];
			self.legendIcons = [];
			self.legendDots = [];
			self.chartLabelEles = [];
			self.seriesEles = [];
		},
		
		_getDefFill: function () {
			var defFill = [
					"#00cc00",
					"#0099cc",
					"#0055cc",
					"#2200cc",
					"#8800cc",
					"#d9007e",
					"#ff0000",
					"#ff6600",
					"#ff9900",
					"#ffcc00",
					"#ffff00",
					"#ace600"
				];
			return defFill;
		},

		_getCulture: function (name) {
            return Globalize.findClosestCulture(name || this.options.culture);
        },

		_handleDisabledOption: function (disabled, ele) {
			var self = this;

			if (disabled) {
				if (!self.disabledDiv) {
					self.disabledDiv = self._createDisabledDiv(ele);
				}
				self.disabledDiv.appendTo("body");
			}
			else {
				if (self.disabledDiv) {
					self.disabledDiv.remove();
					self.disabledDiv = null;
				}
			}
		},

		_createDisabledDiv: function (outerEle) {
			var self = this,
				o = self.options,
				// Change your outerelement here
				ele = outerEle || self.element,
				eleOffset = ele.offset(),
				disabledWidth = o.width || ele.outerWidth(),
				disabledHeight = o.height || ele.outerHeight();

			return $("<div></div>")
					.addClass("ui-disabled")
					.css({
					"z-index": "99999",
					position: "absolute",
					width: disabledWidth,
					height: disabledHeight,
					left: eleOffset.left,
					top: eleOffset.top
				});
		},

		_init: function () {
			var self = this,
				o = self.options;
			
			$.each(o.seriesList, function (i, series) {
				var data = series.data,
					idx;
				if (typeof data === 'undefined' || data === null) {
					idx = $.inArray(series, o.seriesList);
					o.seriesList.splice(idx, 1);
				}
			});
			/*
			 * o.seriesList = $.grep(o.seriesList, function(series, i) { var
			 * data = series.data; if (typeof data === 'undefined' || data ===
			 * null) { return false; } return true; });
			 */

			if (!self.rendered) {
				self._paint();
			}
			$.Widget.prototype._init.apply(self, arguments);
		},

		destroy: function () {
			///Remove the functionality completely. 
			///This will return the element back to its pre-init state. 
			var self = this;
			self._unbindLiveEvents();
			self._clearChartElement();
			self.chartElement.removeClass("ui-widget");

			$(".wijchart-canvas-object", self.chartElement[0])
				.die(self.widgetName)
				// for jQuery 1.7.1
				.die("." + self.widgetName);

			if (self.element !== self.chartElement) {
				self.chartElement.remove();
			}

			self.element.empty();

			// Add for fixing bug 16039
			if (self.disabledDiv) {
				self.disabledDiv.remove();
				self.disabledDiv = null;
			}
			// end for bug 16039

			$.Widget.prototype.destroy.apply(self, arguments);
		},

		/***********************************************************************
		 * Widget specific implementation
		 **********************************************************************/
		/** public methods */
		getCanvas: function () {
			// / <summary>
			// / Returns a reference to the Raphael canvas object.
			// / </summary>
			// / <returns type="Raphael">
			// / Reference to raphael canvas object.
			// / </returns>
			return this.canvas;
		},

		addSeriesPoint: function (seriesIndex, point, shift) {
			// / <summary>
			// / Add series point to the series list.
			// / </summary>
			// / <param name="seriesIndex" type="Number">
			// / The index of the series that the point will be inserted to.
			// / </param>
			// / <param name="point" type="Object">
			// / The point that will be inserted to.
			// / </param>
			// / <param name="shift" type="Boolean">
			// / A value that indicates whether to shift the first point.
			// / </param>
			var seriesList = this.options.seriesList,
				series = null,
				data = null;

			if (seriesIndex >= seriesList.length) {
				return;
			}

			series = seriesList[seriesIndex];
			data = series.data || [];
			data.x.push(point.x);
			data.y.push(point.y);

			if (shift) {
				data.x.shift();
				data.y.shift();
			}

			this._setOption("seriesList", seriesList);
		},

		beginUpdate: function () {
			///Suspend automatic updates to the chart while reseting the options.
			var self = this;
			self.updating++;
		},

		endUpdate: function () {
			///Restore automatic updates to the chart after 
			///the options has been reset.
			var self = this;
			self.updating--;
			self.redraw();
		},

		redraw: function (drawIfNeeded) {
			// / <summary>
			// / Redraw the chart.
			// / </summary>
			// / <param name="drawIfNeeded" type="Boolean">
			// / A value that indicates whether to redraw the chart
			// / no matter whether the chart is painted.
			// / If true, then only when the chart is not created before,
			// / it will be redrawn. Otherwise, the chart will be forced to
			// redraw.
			// / The default value is false.
			// / </param>
			var self = this,
				o = self.options,
				width = 0,
				height = 0;

			if (self.updating > 0) {
				return;
			}

			if (drawIfNeeded && self.rendered) {
				return;
			}

			width = o.width || self.element.width();
			height = o.height || self.element.height();

			if (width < 1 || height < 1) {
				return;
			}

			self.canvas.setSize(width, height);

			self._paint();
		},

		/*
		getSVG: function () {
			if (Raphael.type === "SVG") {
				return this.chartElement.html();
			}

			return this.canvas.wij.getSVG();
		},

		exportChart: function () {
			var form = document.createElement("form"),
				svg = this.getSVG();

			form.action = "http://export.highcharts.com/";
			form.method = "post";
			form.style.display = "none";
			document.body.appendChild(form);

			$.each(['filename', 'type', 'width', 'svg'], function (idx, name) {
				var input = document.createElement("input");

				$(input).attr("name", name).attr("type", "hidden").attr("value", {
					filename: 'chart',
					type: "image/png",
					width: 600,
					svg: svg
				}[name]);

				form.appendChild(input);
			});

			form.submit();
			document.body.removeChild(form);
		},
		*/

		/** Private methods */
		_parseTable: function () {
			if (!this.element.is("table")) {
				return;
			}
			var self = this,
				ele = self.element,
				o = self.options,
				// header & footer
				captions = $("caption", ele),
				theaders = $("thead th", ele),
				seriesList = [],
				sList = $("tbody tr", ele);

			if (captions.length) {
				o.header = $.extend({
					visible: true,
					text: $.trim($(captions[0]).text())
				}, o.header);
				if (captions.length > 1) {
					o.footer = $.extend({
						visibel: true,
						text: $.trim($(captions[1]).text())
					}, o.footer);
				}
			}
			// legend
			o.legend = $.extend({
				visible: true
			}, o.legend);

			self._getSeriesFromTR(theaders, sList, seriesList);

			self.options.seriesList = seriesList;
		},

		_getSeriesFromTR: function (theaders, sList, seriesList) {
			var valuesX = [],
				val = null,
				series = null;
			// seriesList
			if (theaders.length) {
				theaders.each(function () {
					val = $.trim($(this).text());
					valuesX.push(val);
				});
			}
			if (sList.length) {
				sList.each(function () {
					var th = $("th", $(this)),
						label = $.trim(th.text()),
						valuesY = [],
						tds = $("td", $(this));
					
					if (tds.length) {
						tds.each(function () {
							var td = $(this);
							valuesY.push(parseFloat($.trim(td.text())));
						});
					}
					series = {
						label: label,
						legendEntry: true,
						data: {
							x: valuesX,
							y: valuesY
						}
					};
					seriesList.push(series);
				});
			}
		},

		_destroyRaphaelArray: function (objs) {
			var len = objs.length, 
				i = 0, ele, obj;

			for (; len && i < len; i++) {
				ele = objs[i];
				if (ele && ele[0]) {
					obj = $(ele.node);
					obj.unbind().removeData();
					ele.wijRemove();
					obj.remove();
					obj = null;
				}
				objs[i] = null;
			}
		},

		_clearChartElement: function () {
			var self = this,
				fields = self.chartElement.data("fields");				

			self._destroyRaphaelArray(self.headerEles);
			self._destroyRaphaelArray(self.footerEles);
			self._destroyRaphaelArray(self.legendEles);
			self._destroyRaphaelArray(self.legends);
			self._destroyRaphaelArray(self.legendIcons);
			self._destroyRaphaelArray(self.legendDots);
			self._destroyRaphaelArray(self.axisEles);
			self._destroyRaphaelArray(self.chartLabelEles);

			if (self.tooltip) {
				self.tooltip.destroy();
				self.tooltip = null;
			}

			if (fields && fields.trackers) {
				self._destroyRaphaelArray(fields.trackers);
				fields.trackers = null;
			}
			self.headerEles = [];
			self.footerEles = [];
			self.legendEles = [];
			self.legends = [];
			self.legendIcons = [];
			self.legendDots = [];
			self.axisEles = [];
			self.chartLabelEles = [];		

			if (fields && fields.chartElements) {
				$.each(fields.chartElements, function (key, eles) {
					self._destroyRaphaelArray(eles);
				});
				fields.chartElements = null;
			}

			if (fields && fields.seriesEles) {
				fields.seriesEles = null;
			}
			
			self.canvas.clear();
			self.innerState = null;			
			self.axisInfo = null;
			self.seriesGroup = null;
			self.lastAxisOffset = null;			
			self.innerState = {};
		},

		_text: function (x, y, text) {
			var textElement = this.canvas.text(x, y, text);

			if (this.options.disableDefaultTextStyle) {
				textElement.node.style.cssText = "";
			}

			return textElement;
		},

		_paint: function () {
			var self = this,
				o = self.options,
				element = self.element,
				hidden = element.css("display") === "none" ||
						element.css("visibility") === "hidden",
				oldLeft = {},
				oldPosition = null;
			// ev = $.Event("beforepaint");

			if (hidden) {
				oldLeft = element.css("left");
				oldPosition = element.css("position");
				element.css("left", "-10000px");
				element.css("position", "absolute");
				element.show();
			}

			if (element.is(":hidden")) {
				if (hidden) {
					element.css("left", oldLeft);
					element.css("position", oldPosition);
					element.hide();
				}
				return;
			}

			self._clearChartElement();
			if (self._trigger("beforePaint") === false) {
				return;
			}
			// self._trigger("beforepaint", ev);

			self.canvasBounds = {
				startX: 0,
				endX: o.width || element.width(),
				startY: 0,
				endY: o.height || element.height()
			};
			self._paintHeader();
			self._paintFooter();
			self._paintLegend();
			self._paintChartArea();
			self._paintChartLabels();
			self._paintTooltip();
			self._trigger("painted");

			self.rendered = true;
			//$.wijraphael.clearRaphaelCache();
			if (hidden) {
				element.css("left", oldLeft);
				element.css("position", oldPosition);
				element.hide();
			}
		},

		_calculatePosition: function (compass, width, height) {
			var point = { x: 0, y: 0 },
				marginX = 5,
				marginY = 5,
				canvasBounds = this.canvasBounds;
			switch (compass) {
			case "north":
				point.x = (canvasBounds.endX - canvasBounds.startX) / 2;
				point.y = canvasBounds.startY + height / 2 + marginY;
				canvasBounds.startY = canvasBounds.startY + marginY * 2 + height;
				break;
			case "south":
				point.x = (canvasBounds.endX - canvasBounds.startX) / 2;
				point.y = canvasBounds.endY - height / 2 - marginY;
				canvasBounds.endY = canvasBounds.endY - marginY * 2 - height;
				break;
			case "east":
				point.x = canvasBounds.endX - width / 2 - marginX;
				point.y = (canvasBounds.endY - canvasBounds.startY) / 2;
				canvasBounds.endX = canvasBounds.endX - marginX * 2 - width;
				break;
			case "west":
				point.x = canvasBounds.startX + width / 2 + marginX;
				point.y = (canvasBounds.endY - canvasBounds.startY) / 2;
				canvasBounds.startX = canvasBounds.startX + marginX * 2 + width;
				break;
			}
			return point;
		},

		_paintHeader: function () {
			var headerMargin = 2,
				self = this,
				o = self.options,
				header = o.header,
				compass = null,
				headerText = null,
				textStyle = null,
				bBox = null,
				point = null,
				box = null,
				rotation = 0, 
				headerContainer = null;

			if (header.text && header.text.length > 0 && header.visible) {
				compass = header.compass;
				headerText = self._text(0, 0, header.text);
				$.wijraphael.addClass($(headerText.node), "wijchart-header-text");
				// update for fixing bug 15884 at 2011/7/5
				// textStyle = $.extend(true, {}, o.textStyle,
				// header.textStyle);
				rotation = self._getRotationByCompass(compass);
				textStyle = $.extend(true, {}, o.textStyle,  header.textStyle);
				// end for fixing bug 15884.
				headerText.attr(textStyle);
				headerText.transform("...R" + rotation);
				bBox = headerText.wijGetBBox();
				point = self._calculatePosition(compass, bBox.width, bBox.height);

				// headerText.translate(point.x, point.y);
				headerText.transform(Raphael.format("...T{0},{1}", point.x, point.y));
				box = headerText.wijGetBBox();
				headerContainer = self.canvas.rect(
					box.x - headerMargin,
					box.y - headerMargin,
					box.width + 2 * headerMargin,
					box.height + 2 * headerMargin
				);
				$.wijraphael.addClass($(headerContainer.node), 
				"wijchart-header-container");
				headerContainer.attr(header.style);
				headerContainer.toBack();

				self.headerEles.push(headerText);
				self.headerEles.push(headerContainer);
			}
		},

		_paintFooter: function () {
			var footerMargin = 2,
				self = this,
				o = self.options,
				footer = o.footer,
				compass = null,
				footerText = null,
				textStyle = null,
				bBox = null,
				point = null,
				box = null,
				rotation = 0,
				footerContainer = null;

			if (footer.text && footer.text.length > 0 && footer.visible) {
				compass = footer.compass;
				footerText = self._text(0, 0, footer.text);
				$.wijraphael.addClass($(footerText.node), "wijchart-footer-text");
				// update for fixing bug 15884 at 2011/7/5
				// textStyle = $.extend(true, {}, o.textStyle,
				// footer.textStyle);
				rotation = self._getRotationByCompass(compass);
				textStyle = $.extend(true, {}, o.textStyle, footer.textStyle);
				// end for fixing bug 15884

				footerText.attr(textStyle);
				footerText.transform("...R" + rotation);
				bBox = footerText.wijGetBBox();
				point = self._calculatePosition(compass, bBox.width, bBox.height);

				// footerText.translate(point.x, point.y);
				footerText.transform(Raphael.format("...T{0},{1}", point.x, point.y));
				box = footerText.wijGetBBox();
				footerContainer = self.canvas.rect(
					box.x - footerMargin,
					box.y - footerMargin,
					box.width + 2 * footerMargin,
					box.height + 2 * footerMargin
				);
				$.wijraphael.addClass($(footerContainer.node), 
				"wijchart-footer-container");

				footerContainer.attr(footer.style);
				footerContainer.toBack();

				self.footerEles.push(footerText);
				self.footerEles.push(footerContainer);
			}
		},

		_getRotationByCompass : function (compass) {
			var rotation = 0;

			if (compass === "east") {
				rotation = 90;
			} else if (compass === "west") {
				rotation = -90;
			}

			return rotation;
		},

		_paintLegend: function () {
			if (!this.options.legend.visible) {
				return;
			}
			
			var self = this,
				o = self.options,
				legend = $.extend(true, {size: {
					width: 22,
					height: 10
				}}, o.legend),
				legendMargin = 2,
				seriesStyles = o.seriesStyles,
				tempSeriesList = [].concat(o.seriesList),
				compass = legend.compass,
				orientation = legend.orientation,
				legendTitle,
				textStyle,
				legendLen,
				textMargin,
				canvasBounds = self.canvasBounds,
				canvasWidth = canvasBounds.endX - canvasBounds.startX,
				canvasHeight = canvasBounds.endY - canvasBounds.startY,
				iconWidth = legend.size.width,
				iconHeight = legend.size.height,
				titleBox,
				titleHeight = 0,
				titleWidth = 0,
				maxWidth = 0,
				maxHeight = 0,
				totalWidth = 0,
				totalHeight = 0,
				columnNum = 1,
				rowNum = 0,
				width = 0,
				height = 0,
				offsetY = 0,
				index = 0,
				point,
				left,
				top,
				legendContainer,
				legendIconStyles = [],
				idx = 0,
				legendIndex = 0;

			if (legend.text && legend.text.length) {
				legendTitle = self._text(0, 0, legend.text);
				$.wijraphael.addClass($(legendTitle.node), "wijchart-legend-title");
				textStyle = $.extend(true, {}, o.textStyle,
					legend.textStyle, legend.titleStyle);
				legendTitle.attr(textStyle);
				self.legendEles.push(legendTitle);
			}

			if (legend.reversed) {
				tempSeriesList = tempSeriesList.reverse();
			}

			$.each(tempSeriesList, function (i, series) {
				// support hole.
				series = $.extend(true, { legendEntry: true, display: "show" }, series);
				// series = $.extend(true, { legendEntry: true }, series);
				// end comments.

				function drawSeriesLegend(series) {
					var index = legend.reversed ? tempSeriesList.length - 1 - idx : idx,
						seriesStyle = seriesStyles[index],
						chartStyle = $.extend(true, {
							fill: "none",
							opacity: 1,
							stroke: "black"
						}, seriesStyle),
						text,
						textStyle,
						chtStyle,
						isline = false,
						seriesType = series.type,
						icon;
						
						
					// if (series.legendEntry) {
					if (series.legendEntry && 
						series.display !== "exclude") {						
						text = self._text(0, 0, series.label);
						$.wijraphael.addClass($(text.node), 
						"wijchart-legend-text wijchart-legend");
						textStyle = $.extend(true, {}, o.textStyle, legend.textStyle);
						text.attr(textStyle);
						self.legends.push(text);
						chtStyle = $.extend(chartStyle, { "stroke-width": 1 });
						icon = self.canvas.rect(0, 0, iconWidth, iconHeight);
						$.wijraphael.addClass($(icon.node), 
						"wijchart-legend-icon wijchart-legend");
						icon.attr(chtStyle);
						self.legendIcons.push(icon);
						legendIconStyles.push(chtStyle);
						if (self.widgetName === "wijcompositechart") {
							isline = seriesType === "line" ||
								seriesType === "spline" ||
								seriesType === "bezier" ||
								seriesType === "area";
						}
						else {
							isline = self.widgetName === "wijlinechart";
						}
						if (series.visible === false && !isline) {
							$(text.node).data("hidden", true)
							.data("textOpacity", 
								text.attr("opacity") || 1);							
							text.attr("opacity", 0.3);
						}
						$(text.node).data("legendIndex", legendIndex)
							.data("index", idx);
						//$(icon.node).data("legendIndex", legendIndex)
						//	.data("index", idx);

						legendIndex++;
					}
					idx++;
				}

				if (series.type === "pie" && series.legendEntry) {
					$.each(series.data, function (j, data) {
						data = $.extend({ legendEntry: series.legendEntry }, data);	
						drawSeriesLegend(data);						
					});
				} else if (self._isPieChart()) {
					//fix tfs issue 20705
					drawSeriesLegend(series);
				} else {
					if ((series.data.x === undefined && series.data.xy === undefined) ||
						(series.data.xy === undefined && series.data.y === undefined)
					) {
						return true;
					}					
					drawSeriesLegend(series);
				}
			});

			legendLen = self.legends.length;
			textMargin = legend.textMargin;

			if (legendTitle) {
				titleBox = legendTitle.wijGetBBox();
				titleHeight = titleBox.height;
				titleWidth = titleBox.width;
			}

			$.each(self.legends, function (idx, legend) {
				var bBox = legend.wijGetBBox();

				if (bBox.width > maxWidth) {
					maxWidth = bBox.width;
				}

				if (bBox.height > maxHeight) {
					maxHeight = bBox.height;
				}
			});

			if (compass === "east" || compass === "west") {
				if (orientation === "horizontal") {
					totalWidth = legendLen * (maxWidth + iconWidth + legendMargin) +
						legendLen * (textMargin.left + textMargin.right);
					if (totalWidth > canvasWidth / 2) {
						columnNum = Math.floor(canvasWidth / 2 / maxWidth);
						if (columnNum < 1) {
							columnNum = 1;
						}
					} else {
						columnNum = legendLen;
					}
				} else if (orientation === "vertical") {
					totalHeight = maxHeight * legendLen + titleHeight + legendLen *
						(textMargin.top + textMargin.bottom);
					if (totalHeight > canvasHeight) {
						columnNum = Math.ceil(totalHeight / canvasHeight);
					} else {
						columnNum = 1;
					}
				}
			} else if (compass === "south" || compass === "north") {
				if (orientation === "horizontal") {
					totalWidth = (maxWidth + iconWidth + legendMargin) * legendLen +
						legendLen * (textMargin.left + textMargin.right);
					if (totalWidth > canvasWidth) {
						columnNum = Math.floor(legendLen / totalWidth * canvasWidth);
						if (columnNum < 1) {
							columnNum = 1;
						}
					} else {
						columnNum = legendLen;
					}
				} else if (orientation === "vertical") {
					totalHeight = maxHeight * legendLen + titleHeight +
						legendLen * (textMargin.top + textMargin.bottom);
					if (totalHeight > canvasHeight / 2) {
						rowNum = Math.floor(canvasHeight - titleHeight) /
							2 / maxHeight;
						columnNum = Math.ceil(legendLen / rowNum);
					} else {
						columnNum = 1;
					}
				}
			}

			// Fixed issue 20405 by dail. If all series 's legendEntry set to false.
			// and the compass set to south or north, the columnNum is zero.
			if (columnNum === 0) {
				columnNum = 1;
			}

			width = columnNum * (maxWidth + iconWidth + legendMargin) +
				columnNum * (textMargin.left + textMargin.right);
			height = maxHeight * Math.ceil(legendLen / columnNum) +
				titleHeight + Math.ceil(legendLen / columnNum) *
				(textMargin.top + textMargin.bottom);
			
			//fix tfs 20705
			width = width > titleWidth ? width : titleWidth;
			//end comments

			point = self._calculatePosition(compass, width, height);
			left = point.x - width / 2;
			top = point.y - height / 2;
			legendContainer = self.canvas.rect(left - legendMargin, top - legendMargin,
					width + 2 * legendMargin, height + 2 * legendMargin);
			$.wijraphael.addClass($(legendContainer.node), "wijchart-legend-container");
			legendContainer.attr(legend.style);
			legendContainer.toBack();
			self.legendEles.push(legendContainer);

			if (legendTitle) {
				// legendTitle.translate(left + width / 2, top + titleHeight /
				// 2);
				legendTitle.transform(Raphael.format("...T{0},{1}", left + width / 2, 
					top + titleHeight / 2));
			}

			offsetY = titleHeight;

			$.each(self.legends, function (idx, leg) {
				var bBox = leg.wijGetBBox(),
					icon = self.legendIcons[idx],
					x = left + index * (iconWidth + maxWidth + legendMargin) +
						(index + 1) * textMargin.left + index * textMargin.right,
					y = top + offsetY + bBox.height / 2 + textMargin.top,
					iconY = y - icon.wijGetBBox().height / 2, chtStyle;

				// icon.translate(x, y - icon.wijGetBBox().height / 2);
				// icon.transform(Raphael.format("...T{0},{1}", x, y -
				// icon.wijGetBBox().height / 2));
				icon.wijRemove();
				icon = null;
				icon = self.canvas.rect(x, iconY, iconWidth, iconHeight);

				$(icon.node).data("legendIndex", $(leg.node).data("legendIndex"))
					.data("index", $(leg.node).data("index"));
				//$(icon.node).data("index", seriesIdx);
				$.wijraphael.addClass($(icon.node), 
				"wijchart-legend-icon wijchart-legend");
				self.legendIcons[idx] = icon;
				chtStyle = legendIconStyles[idx];
				if (chtStyle) {
					icon.attr(chtStyle);
					if ($(leg.node).data("hidden") === true) {
						$(leg.node).data("iconOpacity", icon.attr("opacity") || 1);
						icon.attr("opacity", 0.3);
					}
				}

				// leg.translate(x + iconWidth + legendMargin + bBox.width / 2,
				// y);
				leg.transform(Raphael.format("...T{0},{1}", 
				x + iconWidth + legendMargin + bBox.width / 2, y));
				leg.toFront();
				//$(leg.node).data("index", seriesIdx);

				index++;

				if (index === columnNum) {
					index = 0;
					offsetY += maxHeight + textMargin.top + textMargin.bottom;
				}
			});
		},

		_hasAxes: function () {
			if (this.widgetName === "wijpiechart") {
				return false;
			}
			return true;
		},

		_applyAxisText: function (axisOptions, axisInfo) {
			var self = this,
				text = axisOptions.text,
				textBounds = null,
				tempText = null,
				textStyle = null,
				textMarginVer = 0,
				textMarginHor = 0,
				canvasBounds = self.canvasBounds;

			if (text !== null && text !== undefined && text.length > 0) {
				tempText = self._text(-100, -100, text);
				textStyle = $.extend(true, {},
					self.options.textStyle, axisOptions.textStyle);
				tempText.attr(textStyle);
				textBounds = tempText.wijGetBBox();
				if (textStyle["margin-left"]) {
					textMarginHor += parseFloat(textStyle["margin-left"]);
				}
				if (textStyle["margin-top"]) {
					textMarginVer += parseFloat(textStyle["margin-top"]);
				}
				if (textStyle["margin-right"]) {
					textMarginHor += parseFloat(textStyle["margin-right"]);
				}
				if (textStyle["margin-bottom"]) {
					textMarginVer += parseFloat(textStyle["margin-bottom"]);
				}

				switch (axisOptions.compass) {
				case "north":
					canvasBounds.startY += (textBounds.height + textMarginVer);
					break;
				case "south":
					canvasBounds.endY -= (textBounds.height + textMarginVer);
					break;
				case "east":
					canvasBounds.endX -= (textBounds.height + textMarginHor);
					break;
				case "west":
					canvasBounds.startX += (textBounds.height + textMarginHor);
					break;
				}
				tempText.wijRemove();
				tempText = null;
			}

			return textBounds;
		},

		_isSeriesDataEmpty: function () {
			var self = this,
				sl = self.options.seriesList;

			if (!sl || sl.length === 0) {
				return true;
			}

			$.each(sl, function (idx, s) {
				if (!s.data || ((!s.data.x || !s.data.y) && !s.data.xy)) {
					return true;
				}
			});

			return false;
		},

		_paintTooltip: function () {
			var self = this,
				o = self.options,
				hint = o.hint,
				hintEnable = !o.disabled && hint.enable,
				hintEx = hint,
				title,
				content,
				isFunction = $.isFunction;

			if (hintEnable && !self.tooltip) {
				hintEx = $.extend(true, {}, hint, {
					// closeBehavior: "none",
					// triggers: "custom"
				});
				title = hint.title;
				content = hint.content;

				if (isFunction(title)) {
					hintEx.title = function () {
						return self._getTooltipText(title, this.target);
					};
				}

				if (isFunction(content)) {
					hintEx.content = function () {
						return self._getTooltipText(content, this.target);
					};
				}

				hintEx.beforeShowing = function () {
					self._onBeforeTooltipShowing(this);
				};

				self.tooltip = self.canvas.tooltip(null, hintEx);
			}
		},

		_getTooltipText: function (fmt, target) {
			var dataObj = $(target.node).data("wijchartDataObj"),
				obj = {
					data: dataObj,
					label: dataObj.label,
					x: dataObj.x,
					y: dataObj.y,
					target: target,
					fmt: fmt
				};
			return $.proxy(fmt, obj)();
		},

		_onBeforeTooltipShowing: function (tooltip) {
			var target = tooltip.target;

			if (target) {
				tooltip.options.style.stroke = tooltip.options.style.stroke ||
					target.attrs.stroke ||
					target.attrs.fill;
			}
		},

		_paintChartArea: function () {
			var self = this,
				o = self.options,
				axisOption = o.axis,
			// The value is used to offset the tick major
			// text from the tick rect.
				axisTextOffset = 2,
				xTextBounds = null,
				yTextBounds = null,
				extremeValue = {},
				maxtries = 5,
				offsetX = 0,
				offsetY = 0,
				isMultiYAxis = $.isArray(axisOption.y),
				yAxisCount = 0, yIdx, yaxisOpt, key;

			self._applyMargins();

			self.isMultiYAxis = isMultiYAxis;
			
			if (self._isSeriesDataEmpty()) {
				return;
			}

			if (isMultiYAxis) {
				$.each(axisOption.y, function (i, yaxis) {
					axisOption.y[i] = $.extend(true, {
						alignment: "center",
						style: {
							stroke: "#999999",
							"stroke-width": 0.5
						},
						visible: false,
						textVisible: true,
						text: "",
						textStyle: {
							fill: "#888",
							"font-size": 15,
							"font-weight": "bold"
						},
						labels: {
							style: {
								fill: "#333",
								"font-size": 11
							},
							textAlign: "center",
							width: null
						},
						compass: "west",
						autoMin: true,
						autoMax: true,
						min: null,
						max: null,
						origin: null,
						autoMajor: true,
						autoMinor: true,
						unitMajor: null,
						unitMinor: null,
						gridMajor: {
							visible: true,
							style: {
								stroke: "#999999",
								"stroke-width": "0.5",
								"stroke-dasharray": "none"
							}
						},
						gridMinor: {
							visible: false,
							style: {
								stroke: "#CACACA",
								"stroke-dasharray": "- "
							}
						},
						tickMajor: {
							position: "none",
							style: { fill: "black" },
							factor: 1
						},
						tickMinor: {
							position: "none",
							style: { fill: "black" },
							factor: 1
						},
						annoMethod: "values",
						annoFormatString: "",
						valueLabels: []
					}, yaxis);
				});
			}

			if (self._hasAxes()) {
				// Restore from cache.
				if (self.innerState.axisInfo) {
					self.axisInfo = self.innerState.axisInfo;
					self.canvasBounds = self.innerState.canvasBounds;
				} else {
					xTextBounds = self._applyAxisText(axisOption.x, {});
					self.axisInfo = {
						x: {
							id: "x",
							tprec: 0,
							isTime: false,
							offset: 0,
							vOffset: 0,
							max: 0,
							min: 0,
							majorTickRect: null,
							minorTickRect: null,
							annoFormatString: null,
							textBounds: xTextBounds,
							axisTextOffset: axisTextOffset,
							autoMax: true,
							autoMin: true,
							autoMajor: true,
							autoMinor: true
						},
						y: {}
					};

					if (isMultiYAxis) {
						$.each(axisOption.y, function (i, axisY) {
							yTextBounds = self._applyAxisText(axisY, {});
							self.axisInfo.y[i.toString()] = {
								id: "y" + i,
								tprec: 0,
								isTime: false,
								offset: 0,
								vOffset: 0,
								max: 0,
								min: 0,
								majorTickRect: null,
								minorTickRect: null,
								annoFormatString: null,
								textBounds: yTextBounds,
								axisTextOffset: axisTextOffset,
								autoMax: true,
								autoMin: true,
								autoMajor: true,
								autoMinor: true
							};
						});				
					} else
					{
						yTextBounds = self._applyAxisText(axisOption.y, {});
						self.axisInfo.y["0"] = {
							id: "y",
							tprec: 0,
							isTime: false,
							offset: 0,
							vOffset: 0,
							max: 0,
							min: 0,
							majorTickRect: null,
							minorTickRect: null,
							annoFormatString: null,
							textBounds: yTextBounds,
							axisTextOffset: axisTextOffset,
							autoMax: true,
							autoMin: true,
							autoMajor: true,
							autoMinor: true
						};
					}

					self._getSeriesGroup();
					extremeValue = self._getDataExtreme(isMultiYAxis);

					// handle x axis.
					if (axisOption.x.autoMin && self.axisInfo.x.autoMin) {
						axisOption.x.min = extremeValue.txn;
					} else if (axisOption.x.min && self._isDate(axisOption.x.min)) {
						// if is date time, convert to number.
						axisOption.x.min = $.toOADate(axisOption.x.min);
					}
					if (axisOption.x.autoMax && self.axisInfo.x.autoMax) {
						axisOption.x.max = extremeValue.txx;
					} else if (axisOption.x.max && self._isDate(axisOption.x.max)) {
						// if is date time, convert to number.
						axisOption.x.max = $.toOADate(axisOption.x.max);
					}


					$.each(extremeValue.y, function (key, exval) {
						yAxisCount++;
					});


					for (yIdx = 0; yIdx < yAxisCount; yIdx++) {
						yaxisOpt = axisOption.y[yIdx] || axisOption.y;
						key = yIdx.toString();
						if (yaxisOpt.autoMin && self.axisInfo.y[key].autoMin) {
							yaxisOpt.min = extremeValue.y[key].tyn;
						} else if (yaxisOpt.min && self._isDate(yaxisOpt.min)) {
							// if is date time, convert to number.
							yaxisOpt.min = $.toOADate(yaxisOpt.min);
						}

						if (yaxisOpt.autoMax && self.axisInfo.y[key].autoMax) {
							yaxisOpt.max = extremeValue.y[key].tyx;
						} else if (yaxisOpt.max && self._isDate(yaxisOpt.max)) {
							// if is date time, convert to number.
							yaxisOpt.max = $.toOADate(yaxisOpt.max);
						}

						do {
							offsetY = self._autoPosition(self.axisInfo, 
							axisOption, "y", key);
							offsetX = self._autoPosition(self.axisInfo, 
							axisOption, "x", key);

							if (offsetY === self.axisInfo.y[key].offset &&
									offsetX === self.axisInfo.x.offset) {
								maxtries = 0;
								break;
							}
							if (!isNaN(offsetX) && !isNaN(offsetY)) {
								if (offsetY !== self.axisInfo.y[key].offset && 
									offsetY !== 0) {
									self.axisInfo.y[key].offset = offsetY;
									self.axisInfo.y[key].vOffset = offsetX;
								}
								if (offsetX !== self.axisInfo.x.offset && 
									offsetX !== 0) {
									self.axisInfo.x.offset = offsetX;
									self.axisInfo.x.vOffset = offsetY;
								}
							}
							maxtries--;
						} while (maxtries > 0);
					}

					self._adjustPlotArea(axisOption.x, self.axisInfo.x);
					self._adjustPlotArea(axisOption.y, self.axisInfo.y, true);

					self.innerState.axisInfo = self.axisInfo;
					self.innerState.canvasBounds = self.canvasBounds;
				}
				self._paintAxes();
				self._paintPlotArea();
			} else {
				self._paintPlotArea();
			}
		},


		_getSeriesGroup: function () {
			var self = this,
				o = self.options, 
				group = {};

			$.each(o.seriesList, function (i, serie) {
				if (serie.yAxis) {
					if (group[serie.yAxis.toString()]) {
						group[serie.yAxis.toString()].push(serie);
					}
					else {
						group[serie.yAxis.toString()] = [serie];
					}
				}
				else {
					if (group["0"]) {
						group["0"].push(serie);
					}
					else {
						group["0"] = [serie];
					}
				}
			});
			self.seriesGroup = group;
		},

		_adjustPlotArea: function (axisOptions, axisInfo, isYAxis) {
			var canvasBounds = this.canvasBounds, maxKey, maxOffsets = {
				east: Number.MIN_VALUE,
				west: Number.MIN_VALUE,
				south: Number.MIN_VALUE,
				north: Number.MIN_VALUE
			};

			if (isYAxis) {
				$.each(axisInfo, function (key, axisInf) {
					maxKey = key;
				});
				$.each(axisInfo, function (key, axisInf) {
					var opt = axisOptions[key] || axisOptions,
						compass = opt.compass;
					opt.max = axisInf.max;
					opt.min = axisInf.min;

					switch (compass) {
					case "north":
						maxOffsets.north = Math.max(axisInf.offset, maxOffsets.north);
						break;
					case "south":
						maxOffsets.south = Math.max(axisInf.offset, maxOffsets.south);
						break;
					case "east":
						maxOffsets.east = Math.max(axisInf.offset, maxOffsets.east);
						break;
					case "west":
						maxOffsets.west = Math.max(axisInf.offset, maxOffsets.west);
						
						break;
					}
				});
				
				if (maxOffsets.north !== Number.MIN_VALUE) {
					canvasBounds.startY += maxOffsets.north;
				}

				if (maxOffsets.south !== Number.MIN_VALUE) {
					canvasBounds.endY -= maxOffsets.south;
				}

				if (maxOffsets.east !== Number.MIN_VALUE) {
					canvasBounds.endX -= maxOffsets.east;
				}
				
				if (maxOffsets.west !== Number.MIN_VALUE) {
					canvasBounds.startX += maxOffsets.west;
				}			
			}
			else {
				axisOptions.max = axisInfo.max;
				axisOptions.min = axisInfo.min;

				switch (axisOptions.compass) {
				case "north":
					canvasBounds.startY += axisInfo.offset;
					break;
				case "south":
					canvasBounds.endY -= axisInfo.offset;
					break;
				case "east":
					canvasBounds.endX -= axisInfo.offset;
					break;
				case "west":
					canvasBounds.startX += axisInfo.offset;
					break;
				}
			}
		},

		_autoPosition: function (axisInfo, axisOptions, dir, key) {
			// this._adjustCartesianCompass();
			// base._autoPosition();
			return this._autoPositionCartesianAxis(axisInfo, axisOptions, dir, key);
		},

		_autoPositionCartesianAxis: function (axisInfo, axisOptions, dir, key) {
			var self = this,
				extent = null,
				innerAxisInfo, innerAxisOptions,
				oppositeAxisInfo, oppositeAxisOptions,
				//bounds = self.canvasBounds,
				compass, origin, max, min,				
				//oppositeDir = dir === "x" ? "y" : "x",

				lastAxisOffset = self.lastAxisOffset || {},

				//origin = axisOptions[oppositeDir].origin,
				//max = axisInfo[oppositeDir].max,
				//min = axisInfo[oppositeDir].min,
				//d = 0, 
				offset, lastOffset;

			if (dir === "y") {
				innerAxisInfo = axisInfo.y[key];
				innerAxisOptions = axisOptions.y[key] || axisOptions.y;
				oppositeAxisOptions = axisOptions.x;
				oppositeAxisInfo = axisInfo.x;
			}
			else {
				innerAxisInfo = axisInfo.x;
				innerAxisOptions = axisOptions.x;
				oppositeAxisInfo = axisInfo.y[key];
				oppositeAxisOptions = axisOptions.y[key] || axisOptions.y;
			}
			compass = innerAxisOptions.compass;
			origin = oppositeAxisOptions.origin;
			max = oppositeAxisInfo.max;
			min = oppositeAxisInfo.min;

			if (origin !== null && self._isDate(origin)) {
				origin = $.toOADate(origin);
			}

			self._calculateParameters(innerAxisInfo, innerAxisOptions);
			extent = self._getMaxExtents(innerAxisInfo, innerAxisOptions);
			switch (compass) {
			case "north":
			case "south":
				offset = extent.height;
				innerAxisInfo.maxExtent = offset;
			
//				
//			if (origin !== null && origin >= min && origin <= max) {
//				if (compass === "south") {
//					d = (origin - min) / (max - min) * (bounds.endY - bounds.startY);
//				} else {
//					d = (max - origin) / (max - min) * (bounds.endY - bounds.startY);
//				}

//				offset -= d;

//				if (offset < 0) {
//					offset = 0;
//				}
//			}
				break;				
			case "east":
			case "west":
				offset = extent.width;
				innerAxisInfo.maxExtent = offset;				
//			if (origin !== null && origin >= min && origin <= max) {
//				if (compass === "west") {
//				d = (origin - min) / (max - min) * (bounds.endX - bounds.startX);

//				} else {
//					d = (max - origin) / (max - min) * (bounds.endX - bounds.startX);
//				}				

//				offset -= d;

//				if (offset < 0) {
//					offset = 0;
//				}
//			}
				break;
			}
			if (dir === "y" && lastAxisOffset[compass]) {
				$.each(lastAxisOffset[compass], function (k, offsetObj) {
					if (k !== key) {
						lastOffset = offsetObj;
					}
				});
				if (lastOffset) {
					innerAxisInfo.preStartOffset = lastOffset;
					offset += (lastOffset);
				}				
			}
			if (dir === "y") {
				if (lastAxisOffset[compass] === undefined) {
					lastAxisOffset[compass] = {};
				}

				lastAxisOffset[compass][key] = offset + 
				self._getAxisLabelBox(innerAxisOptions).width;
				self.lastAxisOffset = lastAxisOffset;
			}
			
			return offset;
						
		},


		_getAxisLabelBox: function (axisOption) {
			var self = this,
				o = self.options,
				text = axisOption.text,
				marginTop = 0,
				marginRight = 0,
				marginLeft = 0,
				marginBottom = 0,
				textElement, bbox,
				isVertical = self._isVertical(axisOption.compass),
				textStyle = $.extend(true, {}, o.textStyle, axisOption.textStyle);

			if (textStyle["margin-top"]) {
				marginTop = parseFloat(textStyle["margin-top"]);
			}
			if (textStyle["margin-left"]) {
				marginLeft = parseFloat(textStyle["margin-left"]);
			}
			if (textStyle["margin-right"]) {
				marginRight = parseFloat(textStyle["margin-right"]);
			}
			if (textStyle["margin-bottom"]) {
				marginBottom = parseFloat(textStyle["margin-bottom"]);
			}
			textElement = self._text(0, 0, text);
			textElement.attr(textStyle);
			if (isVertical) {
				textElement.transform("...R-90");
			}
			bbox = textElement.wijGetBBox();
			textElement.wijRemove();
			textElement = null;
			return {
				width: bbox.width + marginLeft + marginRight,
				height: bbox.height + marginBottom + marginTop
			};
		},

		_getMaxExtents: function (axisInfo, axisOptions, axisRect) {
			var self = this,
				o = self.options,
				majorTickValues = null,
				maxExtent = {
					width: 0,
					height: 0
				},
				min = axisInfo.min,
				max = axisInfo.max,
				isTime = axisInfo.isTime,
				formatString = axisOptions.annoFormatString,
				is100pc = o.is100Percent,
				index = 0,
				compass = axisOptions.compass,
				labels = axisOptions.labels,
				textStyle,
				hasDefaultRotation = false,
				canvasBounds = self.canvasBounds,
				width,
				transform;

			axisInfo.majorTickRect = self._getTickRect(axisInfo, axisOptions,
														true, true, axisRect);
			axisInfo.minorTickRect = self._getTickRect(axisInfo, axisOptions,
														false, true, axisRect);
			majorTickValues = self._getMajorTickValues(axisInfo, axisOptions);
			
			if (!axisOptions.textVisible) {
				return maxExtent;
			}
			if (!formatString || formatString.length === 0) {
				formatString = axisInfo.annoFormatString;
			}

			textStyle = $.extend(true, {}, o.textStyle,
				axisOptions.textStyle, labels.style);
			transform = textStyle.transform;
			if (transform && transform.length) {
				$.each(transform, function (i, t) {
					if (t[0].toLowerCase() === "r") {
						hasDefaultRotation = true;
						return false;
					}
				});
			}
			// hasDefaultRotation = typeof (textStyle.rotation) !== "undefined";
			textStyle = $.extend(true, textStyle, axisInfo.textStyle);
			width = canvasBounds.endX - canvasBounds.startX -
				axisInfo.vOffset - axisInfo.axisTextOffset;
			if (majorTickValues && majorTickValues.length) {
				width = width / (majorTickValues.length - 1);
				$.each(majorTickValues, function (idx, mtv) {
					var txt,
						size,
						txtClone;

					if (mtv < min || mtv > max) {
						return true;
					}

					if (axisOptions.annoMethod === "valueLabels") {
						if (mtv < 0) {
							return true;
						}

						if (index >= axisOptions.valueLabels.length) {
							return false;
						}

						// mtv = axisOptions.valueLabels[index].text;
						mtv = axisOptions.valueLabels[index];
						if (mtv.text) {
							mtv = mtv.text;
						} else if (typeof mtv.value !== "undefined") {
							mtv = mtv.value;
							if (formatString && formatString.length) {
								// mtv = $.format(mtv, formatString);
								mtv = Globalize.format(mtv, formatString, 
									self._getCulture());
							}
						}
					} else if (axisOptions.annoMethod === "values") {
						if (formatString && formatString.length) {
							if (isTime) {
								mtv = $.fromOADate(mtv);
							}

							// mtv = $.format(mtv, formatString);
							mtv = Globalize.format(mtv, formatString, self._getCulture());
						} else if (is100pc && axisInfo.id === "y") {
							// mtv = $.format(mtv, "p0");
							mtv = Globalize.format(mtv, "p0", 
								self._getCulture());
						}
					}

					if (labels.width) {
						txt = self.canvas.wrapText(-100, -100, mtv,
								labels.width, labels.textAlign, textStyle);
					} else {
						txt = self._text(-100, -100, mtv).attr(textStyle);
					}

					size = txt.wijGetBBox();

					if (!self._isVertical(compass) && !hasDefaultRotation &&
							axisOptions.annoMethod === "valueLabels") {
						if (size.width > width) {
							txt.attr({transform: "r-45"});
							size = txt.wijGetBBox();
							/*
							 * if (!txt.attr().rotation) { txt.attr({ rotation:
							 * -45 }); textStyle.rotation = -45;
							 * axisInfo.textStyle = { rotation: -45 }; size =
							 * txt.wijGetBBox(); }
							 */
							if (idx === 0) {
								textStyle.transform = "r-45";
								axisInfo.textStyle = {
									transform: "r-45"	
								};
								txtClone = txt.clone();
								txtClone.attr({ transform: "r0" });
								size = txtClone.wijGetBBox();
								if (Math.sqrt(2) * size.height > width) {
									txt.attr({transform: "r-90"});
									// textStyle.transform.push(["r", -90]);
									textStyle.transform = "r-90";
									axisInfo.textStyle = {
											transform: "r-90"	
										};
								}
								txtClone.wijRemove();
								txtClone = null;
								size = txt.wijGetBBox();
							}
						}
						/*
						 * if (idx === 0 && txt.attr().rotation &&
						 * txt.attr().rotation === -45) { txtClone =
						 * txt.clone(); txtClone.attr({ rotation: 0 }); size =
						 * txtClone.wijGetBBox(); if (Math.sqrt(2) * size.height >
						 * width) { txt.attr({ rotation: -90 });
						 * textStyle.rotation = -90; axisInfo.textStyle = {
						 * rotation: -90 }; } txtClone.wijRemove(); size =
						 * txt.wijGetBBox(); }
						 */
					}
					txt.wijRemove();
					txt = null;
					if (size.width > maxExtent.width) {
						maxExtent.width = size.width;
					}

					if (size.height > maxExtent.height) {
						maxExtent.height = size.height;
					}

					index++;
				});
			}
			if (maxExtent.width < labels.width) {
				maxExtent.width = labels.width;
			}

			axisInfo.labelWidth = maxExtent.width;
			return maxExtent;
		},

		_getMajorTickValues: function (axisInfo, axisOptions) {
			var rc = [],
				valueLabels = axisOptions.valueLabels;
			if (valueLabels && valueLabels.length > 0) {
				$.each(valueLabels, function (idx, valueLabel) {
					if (typeof valueLabel.text !== "undefined" ||
							 typeof valueLabel.value !== "undefined") {
						return false;
					}
					if (typeof valueLabel === "string") {
						valueLabels[idx] = {
							text: valueLabel,
							gridLine: false
						};
					} else {
						valueLabels[idx] = {
							value: valueLabel,
							gridLine: false
						};
					}
				});
			}
			if (axisOptions.annoMethod === "valueLabels" && 
					valueLabels && valueLabels.length > 0 && 
					typeof valueLabels[0].value !== "undefined") {
				rc = this._getSortedDataValues(axisInfo, axisOptions);
				return rc;
			}
			// rc = this._getTickValues(axisInfo.max, axisInfo.min,
			// axisOptions.unitMajor, axisInfo.tprec, !axisInfo.isTime);
			rc = this._getTickValues(axisInfo.max, axisInfo.min,
				axisOptions.unitMajor, axisInfo.tprec, !axisInfo.isTime,
				axisOptions.autoMajor);
			return rc;
		},
		
		_getSortedDataValues: function (axisInfo, axisOptions) {
			var self = this,
				rc = [],
				// isXAxis = (axisInfo.id === "x"),
				valueLabels = axisOptions.valueLabels;
			$.each(valueLabels, function (idx, label) {
				var val = label.value;
				if (self._isDate(val)) {
					rc.push($.toOADate(val));
				} else if (typeof val === 'number') {
					rc.push(val);
				} else {
					rc.push(idx);
				}
				// if (self._isDate(label)) {
				// rc.push($.toOADate(label));
				// } else if (typeof label === 'number') {
				// rc.push(label);
				// } else {
				// rc.push(idx);
				// }
			});
			// TODO: ignore blank labels.
			
			return rc;
		},

		_getMinorTickValues: function (axisInfo, axisOptions) {
			var rc = [];
			// rc = this._getTickValues(axisInfo.max, axisInfo.min,
			// axisOptions.unitMinor, axisInfo.tprec, !axisInfo.isTime);
			rc = this._getTickValues(axisInfo.max, axisInfo.min,
				axisOptions.unitMinor, axisInfo.tprec, !axisInfo.isTime,
				axisOptions.autoMinor);
			return rc;
		},

		// _getTickValues: function (smax, smin, unit, tickprec, round) {
		_getTickValues: function (smax, smin, unit, tickprec, round, autoTick) {
			var self = this,
				vals = [],
				sminOriginal = smin,
				i = 0,
				xs = 0,
				imax = 0,
				imin = 0,
				n = 0,
				smin2 = 0;

			try {
				if (unit === 0) {
					vals = [smax, smin];
				} else {
					if (autoTick) {
						if (tickprec + 1 < 0) {
							tickprec = -1;
						} else if (tickprec + 1 > 15) {
							tickprec = 14;
						}
						smin2 = $.round(self._signedCeiling(smin / unit) * unit,
											tickprec + 1);
						if (smin2 < smax) {
							smin = smin2;
						}
						imax = parseInt($.round(smax / unit, 5), 10);
						imin = parseInt($.round(smin / unit, 5), 10);
						n = parseInt(imax - imin + 1, 10);
						if (n > 1) {
							xs = imin * unit;
							if (xs < smin) {
								n--;
								smin += unit;
							}
							xs = smin + (n - 1) * unit;
							if (xs > smax) {
								n--;
							}
						}
						if (n < 1) {
							n = 2;
							smin = sminOriginal;
							unit = smax - smin;
						}
					} else {
						n = parseInt((smax - smin) / unit + 1, 10);
						if (n > 1) {
							xs = smin + (n - 1) * unit;
							if (xs > smax) {
								n--;
							}
						}
						if (n < 1) {
							n = 2;
							unit = smax - smin;
						}
					}

					for (i = 0; i < n; i++) {
						if (round) {
							// vals[i] = $.round(smin + i * unit, tickprec + 1);
							if (autoTick) {
								vals[i] = $.round(smin + i * unit, tickprec + 1);
							} else {
								vals[i] = smin + i * unit;
							}
						} else {
							vals[i] = smin + i * unit;
						}
					}
				}
			} catch (error) { }

			return vals;
		},

		_getTickRect: function (axisInfo, axisOptions, isMajor, inAxisRect) {
			var compass = axisOptions.compass,
				sizeFactor = 0,
				tick = null,
				majorSizeFactor = 3,
				minorSizeFactor = 2,
				thickness = 2,
				majorFactor = axisOptions.tickMajor.factor,
				minorFactor = axisOptions.tickMinor.factor,
				r = {
					x: 0,
					y: 0,
					width: 0,
					height: 0
				};
			if (isMajor) {
				tick = axisOptions.tickMajor.position;
				majorFactor = majorFactor > 0 ? majorFactor : 1;
				sizeFactor = (majorSizeFactor * majorFactor);
			} else {
				tick = axisOptions.tickMinor.position;
				minorFactor = minorFactor > 0 ? minorFactor : 1;
				sizeFactor = (minorSizeFactor * minorFactor);
			}
			if (tick === "none" || (tick === "inside" && inAxisRect)) {
				sizeFactor = 0;
			}
			// if(isVertical) {
			if (compass === "east" || compass === "west") {
				r = {
					x: 0,
					y: -1,
					width: sizeFactor * thickness,
					height: thickness
				};
				if ((compass === "east" && (tick === "outside" ||
						(tick === "cross" && inAxisRect))) ||
						(compass === "west" && tick === "inside")) {
					// r.x = axisRect.x;
					// if(inAxisRect) {
					// r.x += axisRect.width;
					// }
					// else {
					// r.width += axisRect.width;
					// }
					r.width += 2; // default value of axisRect is 2.
				} else {
					// r.x = axisRect.x - sizeFactor * thickness;
					if (!inAxisRect) {
						if (tick === "cross") {
							r.width <<= 1;
						}
						// r.width += axisRect.width;
						r.width += 2;
					}
				}
			} else {
				r = {
					x: -1,
					y: 0,
					width: thickness,
					height: sizeFactor * thickness
				};
				if ((compass === "south" && (tick === "outside" ||
						(tick === "corss" && inAxisRect))) ||
						(compass === "north" && tick === "inside")) {
					// r.y = axisRect.y;
					// if(inAxisRect) {
					// r.y += axisRect.height;
					// }
					// else {
					// r.height += axisRect.height;
					// }
					r.height += 2;
				} else {
					// r.y = axisRect.y - sizeFactor * thickness;
					if (!inAxisRect) {
						if (tick === "cross") {
							r.height <<= 1;
						}
						// r.height += axisRect.height;
						r.height += 2;
					}
				}
			}
			return r;
		},

		_applyMargins: function () {
			var self = this,
				o = self.options,
				canvasBounds = self.canvasBounds;

			canvasBounds.startX += o.marginLeft;
			canvasBounds.endX -= o.marginRight;
			canvasBounds.startY += o.marginTop;
			canvasBounds.endY -= o.marginBottom;
		},

		_paintAxes: function () {
			// paint x axis
			var self = this,
				axis = self.options.axis,
				axisInfo = self.axisInfo,
				ox = axis.x,
				oy = axis.y,
				x = axisInfo.x,
				y = axisInfo.y,
				axisElements;
			axisElements = self._paintAxis(ox, x);

			$.each(y, function (key, yaxis) {
				var opt = oy[key] || oy;
				if (opt.origin !== null) {
					self._translateAxisIfNeeded(axisElements, ox.compass, 
						opt.origin, opt.compass, yaxis.max, yaxis.min);
				}
			});

//			if (oy.origin !== null) {
//				self._translateAxisIfNeeded(axisElements, ox.compass, 
//					oy.origin, oy.compass, y.max, y.min);
//			}

			$.each(y, function (key, yaxis) {
				var opt = oy[key] || oy;
				axisElements = self._paintAxis(opt, yaxis);			
				if (ox.origin !== null) {
					self._translateAxisIfNeeded(axisElements, opt.compass, 
						ox.origin, ox.compass, x.max, x.min);
				}					
			});
		},

		_translateAxisIfNeeded: function (xAxisElements, 
			xCompass, yOrigin, yCompass, yMax, yMin) {
			var self = this,
				isVertical = yCompass === "west" || yCompass === "east",
				bounds = self.canvasBounds,
				origin = yOrigin,
				offset;
			
			if (self._isDate(origin)) {
				origin = $.toOADate(origin);
			}

			if (!isVertical) {
				if (xCompass === "west") {
					offset = (origin - yMin) / (yMax - yMin) *
						(bounds.endX - bounds.startX);
				} else {
					offset = (origin - yMax) / (yMax - yMin) *
						(bounds.endX - bounds.startX);
				}

				$.each(xAxisElements, function (idx, element) {
					// element.translate(offset, 0);
					element.transform(Raphael.format("...T{0},{1}", offset, 0));
				});
			} else {
				if (xCompass === "south") {
					offset = (yMin - origin) / (yMax - yMin) *
						(bounds.endY - bounds.startY);
				} else {
					offset = (yMax - origin) / (yMax - yMin) *
						(bounds.endY - bounds.startY);
				}

				$.each(xAxisElements, function (idx, element) {
					// element.translate(0, offset);
					element.transform(Raphael.format("...T{0},{1}", 0, offset));
				});
			}
		},

		_paintAxis: function (axisOptions, axisInfo) {
			var self = this,
				o = self.options,
				canvasBounds = self.canvasBounds,
				startPoint = {
					x: 0,
					y: 0
				},
				endPoint = {
					x: 0,
					y: 0
				},
				compass = axisOptions.compass,
				thickness = 2,
				isVertical = true,
				ax = null,
			// paint tick & ticklabel
				majorTickValues = [],
				tempMinorTickValues = [],
				minorTickValues = [],
				max = axisInfo.max,
				min = axisInfo.min,
				unitMajor = axisOptions.unitMajor,
				unitMinor = axisOptions.unitMinor,
				tickMajor = axisOptions.tickMajor.position,
				tickMinor = axisOptions.tickMinor.position,
				axisSize = axisInfo.maxExtent,// axisInfo.offset,
				tickMajorStyle = axisOptions.tickMajor.style,
				tickMinorStyle = axisOptions.tickMinor.style,
				tickRectMajor = axisInfo.majorTickRect,
				tickRectMinor = axisInfo.minorTickRect,
				axisTextOffset = axisInfo.axisTextOffset,
				gridMajor = axisOptions.gridMajor,
				gridMinor = axisOptions.gridMinor,
				labels = axisOptions.labels,
				maxLen = 0,
				textInfos = [],
				index = 0, 
				formatString = axisOptions.annoFormatString,
				textStyle = null,
				axisElements = [];
			
			tickRectMajor = self._getTickRect(axisInfo, axisOptions, true, false);
			tickRectMinor = self._getTickRect(axisInfo, axisOptions, false, false);

			if (!formatString || formatString.length === 0) {
				formatString = axisInfo.annoFormatString;
			}
			majorTickValues = self._getMajorTickValues(axisInfo, axisOptions);

			//if (tickMinor !== "none") {
			tempMinorTickValues = self._getMinorTickValues(axisInfo, axisOptions);
			minorTickValues = self._resetMinorTickValues(tempMinorTickValues,
						majorTickValues);
			//}

			//add comments here to fix tfs issue 20415,paint the axis inside the plotarea.
			switch (compass) {
			case "south":
				startPoint.x = canvasBounds.startX;
				startPoint.y = canvasBounds.endY;
				endPoint.x = canvasBounds.endX;
				endPoint.y = canvasBounds.endY;
				isVertical = false;
				break;
			case "north":
				startPoint.x = canvasBounds.startX;
				startPoint.y = canvasBounds.startY - thickness;
				endPoint.x = canvasBounds.endX;
				endPoint.y = canvasBounds.startY - thickness;
				isVertical = false;
				break;
			case "east":
				//startPoint.x = canvasBounds.endX;
				startPoint.x = canvasBounds.endX - thickness;
				if (axisInfo.preStartOffset) {
					startPoint.x += axisInfo.preStartOffset;
				}
				startPoint.y = canvasBounds.endY;
				//endPoint.x = canvasBounds.endX;
				endPoint.x = canvasBounds.endX - thickness;
				endPoint.y = canvasBounds.startY;
				break;
			case "west":				
				//startPoint.x = canvasBounds.startX - thickness;
				startPoint.x = canvasBounds.startX;
				if (axisInfo.preStartOffset) {
					startPoint.x -= axisInfo.preStartOffset;
				}
				startPoint.y = canvasBounds.endY;
				//endPoint.x = canvasBounds.startX - thickness;
				endPoint.x = canvasBounds.startX;
				endPoint.y = canvasBounds.startY;
				break;
			}

			if (axisOptions.visible) {
				ax = self.canvas
					.line(startPoint.x, startPoint.y, endPoint.x, endPoint.y)
					.attr(axisOptions.style);
				$.wijraphael.addClass($(ax.node), "wijchart-axis");

				self.axisEles.push(ax);
				axisElements.push(ax);
			}

			$.each(majorTickValues, function (idx, val) {
				var text = val,
					isTime = axisInfo.isTime,
					is100Percent = o.is100Percent,
					retInfo, textInfo,
					vlGridLine = false,
					vlGridLineStyle = {};

				if (val < min || val > max) {
					return true;
				}

				if (axisOptions.annoMethod === "valueLabels") {
					// if (val < 0) {
					// return true;
					// }

					if (index >= axisOptions.valueLabels.length) {
						return false;
					}

					// text = axisOptions.valueLabels[index].text;
					text = axisOptions.valueLabels[index];
					vlGridLine = text.gridLine;
					vlGridLineStyle = text.gridLineStyle;
					if (text.text) {
						text = text.text;
					} else if (typeof text.value !== "undefined") {
						text = text.value;
						if (formatString && formatString.length) {
							// text = $.format(text, formatString);
							text = Globalize.format(text, formatString, 
								self._getCulture());
						}
					}
				} else if (axisOptions.annoMethod === "values") {
					if (formatString && formatString.length) {
						if (isTime) {
							text = $.fromOADate(val);
						}
						// text = $.format(text, formatString);
						text = Globalize.format(text, formatString, self._getCulture());
					} else if (is100Percent && axisInfo.id === "y") {
						// text = $.format(val, "p0");
						text = Globalize.format(val, "p0", self._getCulture());
					}
				}
				/*
				 * //TODO: mixed else { }
				 */

				textStyle = $.extend(true, {}, o.textStyle,
						axisOptions.textStyle, labels.style, axisInfo.textStyle);

				retInfo = self._paintMajorMinor(max, min, val, tickMajor, 
						unitMajor, tickRectMajor, compass, startPoint,
						endPoint, axisSize, axisTextOffset, tickMajorStyle,
						text, gridMajor, axisOptions.textVisible, textStyle,
						labels.textAlign, labels.width ? axisInfo.labelWidth : null,
						vlGridLine, vlGridLineStyle);

				if (retInfo) {
					if (retInfo.elements) {
						axisElements = axisElements.concat(retInfo.elements);
					}

					textInfo = retInfo.textInfo;
				}

				if (textInfo) {
					textInfos.push(textInfo);
					if (maxLen < textInfo.len) {
						maxLen = textInfo.len;
					}
				}

				index++;
			});

			
			if (!labels.width) { 
				$.each(textInfos, function (idx, textInfo) {
					var textElement = textInfo.text, offset = (textInfo.len - maxLen) / 2;
					offset = labels.textAlign === "near" ? offset * -1 : offset;
			  
					if (isVertical) { 
						//textElement.translate(offset, 0);
						textElement.transform(Raphael.format("...T{0},{1}", offset, 0)); 
					}
					else { 
						//textElement.translate(0, offset);
						textElement.transform(Raphael.format("...T{0},{1}", 0, offset)); 
					}
				}); 
			}
			 

			$.each(minorTickValues, function (idx, val) {
				var retInfo;

				if (val > min && val < max) {
					retInfo = self._paintMajorMinor(max, min, val, tickMinor, 
						unitMinor, tickRectMinor, compass, startPoint, 
						endPoint, axisSize, axisTextOffset, tickMinorStyle, 
						null, gridMinor, axisOptions.textVisible, textStyle, 
						labels.textAlign, labels.width ? axisInfo.labelWidth : null);

					if (retInfo && retInfo.elements) {
						axisElements = axisElements.concat(retInfo.elements);
					}
				}
			});

			if (axisOptions.text && axisOptions.text.length > 0) {
				axisElements.push(self._paintAxisText(axisOptions, axisInfo));
			}

			return axisElements;
		},

		_paintAxisText: function (axisOptions, axisInfo) {
			if (!axisOptions.text || axisOptions.text.length === 0) {
				return;
			}
			var self = this,
				text = axisOptions.text,
				compass = axisOptions.compass,
				align = axisOptions.alignment,
				canvasBounds = self.canvasBounds,
				startX = canvasBounds.startX,
				startY = canvasBounds.startY,
				endX = canvasBounds.endX,
				endY = canvasBounds.endY,
				x = startX,
				y = startY,
				textBounds = axisInfo.textBounds,
				isVertical = self._isVertical(compass),
				axisTextOffset = axisInfo.axisTextOffset,
				tickRectMajor = axisInfo.majorTickRect,
				tick = axisOptions.tickMajor.position,
				tickLength = isVertical ? tickRectMajor.width : tickRectMajor.height,
				textStyle = null,
				textElement = null,
				marginTop = 0,
				marginLeft = 0,
				marginRight = 0,
				marginBottom = 0;

			textStyle = $.extend(true, {},
				self.options.textStyle, axisOptions.textStyle);
			if (textStyle["margin-top"]) {
				marginTop = parseFloat(textStyle["margin-top"]);
			}
			if (textStyle["margin-left"]) {
				marginLeft = parseFloat(textStyle["margin-left"]);
			}
			if (textStyle["margin-right"]) {
				marginRight = parseFloat(textStyle["margin-right"]);
			}
			if (textStyle["margin-bottom"]) {
				marginBottom = parseFloat(textStyle["margin-bottom"]);
			}
			if (tick === "cross") {
				tickLength = tickLength / 2;
			} else if (tick === "inside") {
				tickLength = 0;
			}

			if (isVertical) {
				switch (align) {
				case "near":
					y = endY - textBounds.width / 2;
					break;
				case "center":
					y = (startY + endY) / 2;
					break;
				case "far":
					y = startY + textBounds.width / 2;
					break;
				}

				if (compass === "west") {
					x = startX - (axisInfo.offset + axisTextOffset +
						tickLength + textBounds.height / 2 + marginRight);
				} else {
					x = endX + axisInfo.offset + axisTextOffset +
						tickLength + textBounds.height / 2 + marginLeft;
				}
			} else {
				switch (align) {
				case "near":
					x = startX + textBounds.width / 2;
					break;
				case "center":
					x = (startX + endX) / 2;
					break;
				case "far":
					x = endX - textBounds.width / 2;
					break;
				}

				if (compass === "north") {
					y = startY - (axisInfo.offset + axisTextOffset +
						tickLength + textBounds.height / 2 + marginBottom);
				} else {
					y = endY + axisInfo.offset + axisTextOffset +
						tickLength + textBounds.height / 2 + marginTop;
				}
			}

			textElement = self._text(x, y, text);
			$.wijraphael.addClass($(textElement.node), "wijchart-axis-text");
			self.axisEles.push(textElement);
			textElement.attr(textStyle);

			if (isVertical) {
				// textElement.rotate(-90);
				textElement.transform("...R-90");
			}

			return textElement;
		},

		_resetMinorTickValues: function (minorTickValues, majorTickValues) {
			var i = 0,
				j = 0,
				minorTickValue = null,
				majorTickValue = null;
			for (i = minorTickValues.length - 1; i >= 0; i--) {
				minorTickValue = minorTickValues[i];
				for (j = majorTickValues.length - 1; j >= 0; j--) {
					majorTickValue = majorTickValues[j];
					if (minorTickValue === majorTickValue) {
						minorTickValues.splice(i, 1);
					}
				}
			}

			return minorTickValues;
		},

		_paintMajorMinor: function (max, min, val, tick, unit, tickRect, compass,
						startPoint, endPoint, axisSize, axisTextOffset, tickStyle,
						text, grid, textVisible, textStyle, textAlign, labelWidth,
						vlGridLine, vlGridLineStyle) {
			var self = this,
				x = startPoint.x,
				y = startPoint.y,
				tickX = -1,
				tickY = -1,
				isVertical = true,
				bs = self.canvasBounds,
				textInfo = null,
				tickElement = null,
				pathArr = [],
				arrPath = [],
				p = null,
				style = { "stroke-width": 2 },
				txt = { text: null, len: 0 },
				textBounds = null,
				retInfo = {},
				majorMinorElements = [];
				
			switch (compass) {
			case "south":
				if (tick === "inside") {
					y -= tickRect.height;
				} else if (tick === "cross") {
					y -= tickRect.height / 2;
				}

				if (labelWidth) {
					tickY = y + axisTextOffset + tickRect.height;
				} else {
					tickY = y + axisTextOffset + tickRect.height + axisSize / 2;
				}

				isVertical = false;
				break;
			case "west":
				if (tick === "outside") {
					x -= tickRect.width;
				} else if (tick === "cross") {
					x -= tickRect.width / 2;
				}

				if (labelWidth) {
					tickX = x - (axisTextOffset + axisSize);
				} else {
					tickX = x - (axisTextOffset + axisSize / 2);
				}
				break;
			case "north":
				if (tick === "outside") {
					y -= tickRect.height;
				} else if (tick === "cross") {
					y -= tickRect.height / 2;
				}

				if (labelWidth) {
					tickY = y - (axisTextOffset + axisSize);
				} else {
					tickY = y - (axisTextOffset + axisSize / 2);
				}
				isVertical = false;
				break;
			case "east":
				if (tick === "inside") {
					x -= tickRect.width;
				} else if (tick === "cross") {
					x -= tickRect.width / 2;
				}

				if (labelWidth) {
					tickX = x + axisTextOffset + tickRect.width;
				} else {
					tickX = x + axisTextOffset + tickRect.width + axisSize / 2;
				}
				break;
			}

			if (isVertical) {
				y += (val - min) / (max - min) * (endPoint.y - startPoint.y);
				arrPath = ["M", bs.startX, y, "H", bs.endX];
				if (grid.visible) {
					if ((y !== bs.startY && compass === "east") ||
							(y !== bs.endY && compass === "west")) {
						p = self.canvas.path(arrPath.concat(" "));
						$.wijraphael.addClass($(p.node), "wijchart-axis-gridline");
						p.attr(grid.style);
						self.axisEles.push(p);
					}
				}
				if (vlGridLine) {
					if ((y !== bs.startY && compass === "east") || 
							(y !== bs.endY && compass === "west")) {
						p = self.canvas.path(arrPath.concat(" "));
						$.wijraphael.addClass($(p.node), "wijchart-axis-gridline");
						p.attr($.extend(true, grid.style, vlGridLineStyle));
						self.axisEles.push(p);
					}
				}

				tickY = y;

				if (tick !== "none") {
					pathArr = ["M", x, y, "h", tickRect.width];
					tickStyle["stroke-width"] = tickRect.height;
				}
			} else {
				x += (val - min) / (max - min) * (endPoint.x - startPoint.x);
				arrPath = ["M", x, bs.startY, "V", bs.endY];
				if (grid.visible) {
					if ((x !== bs.startX && compass === "south") ||
							(x !== bs.endX && compass === "north")) {
						p = self.canvas.path(arrPath.concat(" "));
						$.wijraphael.addClass($(p.node), "wijchart-axis-gridline");
						p.attr(grid.style);
						self.axisEles.push(p);
					}
				}
				if (vlGridLine) {
					if ((y !== bs.startY && compass === "south") || 
							(y !== bs.endY && compass === "north")) {
						p = self.canvas.path(arrPath.concat(" "));
						$.wijraphael.addClass($(p.node), "wijchart-axis-gridline");
						p.attr($.extend(true, {}, grid.style, vlGridLineStyle));
						self.axisEles.push(p);
					}
				}

				if (labelWidth) {
					tickX = x - labelWidth / 2;
				} else {
					tickX = x;
				}

				if (tick !== "none") {
					pathArr = ["M", x, y, "v", tickRect.height];
					tickStyle["stroke-width"] = tickRect.width;
				}
			}

			if (tick !== "none") {
				tickElement = self.canvas.path(pathArr.concat(" "));
				$.wijraphael.addClass($(tickElement.node), "wijchart-axis-tick");
				style = $.extend(style, tickStyle);
				tickElement.attr(style);
				self.axisEles.push(tickElement);
				majorMinorElements.push(tickElement);
			}

			if (text !== null && textVisible) {
				if (labelWidth) {
					txt = self.canvas.wrapText(tickX,
						tickY, text.toString(), labelWidth, textAlign, textStyle);
					$.wijraphael.addClass($(txt.node), "wijchart-axis-label");

					//if (isVertical) {
						// txt.translate(0, -txt.getBBox().height / 2);
						//txt.transform(Raphael.format("...T{0},{1}", 0, 
						//-txt.getBBox().height / 2));
					//}
				} else {
					txt = self._text(tickX, tickY, text.toString());
					$.wijraphael.addClass($(txt.node), "wijchart-axis-label");
					txt.attr(textStyle);
				}

				self.axisEles.push(txt);
				majorMinorElements.push(txt);
				if (!textVisible) {
					txt.hide();
				}
				if (textAlign !== "center") {
					textBounds = txt.getBBox();
					textInfo = {
						text: txt,
						len: isVertical ? textBounds.width : textBounds.height
					};
				}
			}

			retInfo = {textInfo: textInfo, elements: majorMinorElements};

			return retInfo;
		},

		_paintPlotArea: function () {
		},

		_paintChartLabels: function () {
			var self = this,
				chartLabels = self.options.chartLabels;

			if (chartLabels && chartLabels.length) {
				$.each(chartLabels, function (idx, chartLabel) {
					var point;

					chartLabel = $.extend(true, {
						compass: "east",
						attachMethod: "coordinate",
						attachMethodData: {
							seriesIndex: -1,
							pointIndex: -1,
							x: -1,
							y: -1
						},
						offset: 0,
						visible: false,
						text: "",
						connected: false
					}, chartLabel);

					if (chartLabel.visible) {
						point = self._getChartLabelPointPosition(chartLabel);
						if (typeof (point.x) !== "number" ||
								typeof (point.y) !== "number") {
							return false;
						}
						self._setChartLabel(chartLabel, point);
					}
				});
			}
		},

		_getChartLabelPointPosition: function (chartLabel) {
		},

		_setChartLabel: function (chartLabel, point, angle, calloutStyle) {
			var self = this,
				compass = chartLabel.compass,
				o = self.options,
				textStyle = $.extend(true, {}, o.textStyle, o.chartLabelStyle),
				text = self._text(0, 0, chartLabel.text).attr(textStyle),
				offset = chartLabel.offset,
				transX = 0,
				transY = 0,
				position = null,
				p = null;

			$.wijraphael.addClass($(text.node), "wijchart-label-text");
			self.chartLabelEles.push(text);

			position = self._getCompassTextPosition(compass,
							text.wijGetBBox(), offset, point, angle);

			if (offset && chartLabel.connected) {
				p = self.canvas.path("M" + point.x + " " + point.y + "L" +
							position.endPoint.x + " " + position.endPoint.y);
				$.wijraphael.addClass($(p.node), "wijchart-label-connect");
				p.attr(calloutStyle);
				self.chartLabelEles.push(p);
			}

			transX = position.endPoint.x + position.offsetX;
			transY = position.endPoint.y + position.offsetY;

			// text.translate(transX, transY)
			// .toFront();
			text.transform(Raphael.format("...T{0},{1}", transX, transY)).toFront();
		},

		_getCompassTextPosition: function (compass, box, offset, point, angle) {
			var offsetX = 0, offsetY = 0,
				endPoint = { x: 0, y: 0 };

			switch (compass.toLowerCase()) {
			case "east":
				angle = 0;
				break;
			case "west":
				angle = 180;
				break;
			case "north":
				angle = 90;
				break;
			case "south":
				angle = 270;
				break;
			case "northeast":
				angle = 45;
				break;
			case "northwest":
				angle = 135;
				break;
			case "southeast":
				angle = 315;
				break;
			case "southwest":
				angle = 225;
				break;
			}

			if ((angle >= 0 && angle < 45 / 2) || (angle > 675 / 2 && angle < 360)) {
				offsetX = box.width / 2;
			} else if (angle >= 45 / 2 && angle < 135 / 2) {
				offsetX = box.width / 2;
				offsetY = -1 * box.height / 2;
			} else if (angle >= 135 / 2 && angle < 225 / 2) {
				offsetY = -1 * box.height / 2;
			} else if (angle >= 225 / 2 && angle < 315 / 2) {
				offsetX = -1 * box.width / 2;
				offsetY = -1 * box.height / 2;
			} else if (angle >= 315 / 2 && angle < 405 / 2) {
				offsetX = -1 * box.width / 2;
			} else if (angle >= 405 / 2 && angle < 495 / 2) {
				offsetX = -1 * box.width / 2;
				offsetY = box.height / 2;
			} else if (angle >= 495 / 2 && angle < 585 / 2) {
				offsetY = box.height / 2;
			} else {
				offsetX = box.width / 2;
				offsetY = box.height / 2;
			}

			endPoint = $.wijraphael.getPositionByAngle(point.x, point.y, offset, angle);

			return {
				endPoint: endPoint,
				offsetX: offsetX,
				offsetY: offsetY
			};
		},
		
		_mouseDown: function (e, args) {
			this._trigger("mouseDown", e, args);
		},
		
		_mouseUp: function (e, args) {
			this._trigger("mouseUp", e, args);
		},
		
		_mouseOver: function (e, args) {
			this._trigger("mouseOver", e, args);
		},
		
		_mouseOut: function (e, args) {
			this._trigger("mouseOut", e, args);
		},
		
		_mouseMove: function (e, args) {
			this._trigger("mouseMove", e, args);
		},
		
		_click: function (e, args) {
			this._trigger("click", e, args);
		},
		
		_mouseMoveInsidePlotArea: function (e, mousePos) {
		},
		
		_mouseMoveOutsidePlotArea: function (e, mousePos) {
		},

		_bindLiveEvents: function () {
			this._bindLegendEvents();
			this._bindCanvasEvents();
		},
		
		_bindCanvasEvents: function () {
			var self = this,
				element = self.chartElement;
			
			element
				.bind("mousemove", function (e) {
					var elePos = element.offset(),
						cBounds = self.canvasBounds,
						mousePos = {
							left: e.pageX - elePos.left,
							top: e.pageY - elePos.top
						},
						disabled = self.options.disabled;
					if (disabled) {
						return;
					}
	
					if (mousePos.left >= cBounds.startX && 
							mousePos.left <= cBounds.endX && 
							mousePos.top >= cBounds.startY && 
							mousePos.top <= cBounds.endY) {
						self._mouseMoveInsidePlotArea(e, mousePos);
					} else {
						self._mouseMoveOutsidePlotArea(e, mousePos);
					}
				});
		},
		
		_bindLegendEvents: function () {
			var self = this,
				element = self.chartElement,
				widgetName = self.widgetName;
			$(".wijchart-legend", element[0])
				.live("click." + widgetName, function (e) {
					if (self.options.disabled) {
						return;
					}
					var tar = $(e.target);
					if (tar[0].tagName && tar[0].tagName === "tspan") {
						tar = tar.parent();
					}
					self._legendClick(tar);
				});
		},
		
		_legendClick: function (obj) {
			if (typeof obj.data("index") === "undefined") {
				return;
			}
			var self = this,
				l = self.options.legend,
				i = obj.data("index"),
				legendIndex = obj.data("legendIndex"),
				fields = self.chartElement.data("fields"),
				seriesEles = self.seriesEles, seriesEle,
				legendIcon = self.legendIcons[legendIndex], 
				legend = self.legends[legendIndex], 
				legendNode = $(legend.node),
				idx = i, legendDot;
	
			if (fields && fields.seriesEles) {
				seriesEles = fields.seriesEles;
			}
			
			if (self.legendDots && self.legendDots.length > i) {
				legendDot = self.legendDots[i];
			}
	
			if (l.reversed) {
				idx = self.legends.length - 1 - i;
			}
			seriesEle = seriesEles[idx];
	
			if (seriesEle) {
				if (!legendNode.data("hidden")) {
					self._hideSerieEles(seriesEle);
					if (!legendNode.data("textOpacity")) {
						legendNode.data("textOpacity", legend.attr("opacity") || 1);
					}
	
					if (!legendNode.data("iconOpacity")) {
						legendNode.data("iconOpacity", 
						legendIcon.attr("opacity") || 1);
					}
					
					if (legendDot && !legendNode.data("dotOpacity")) {
						legendNode.data("dotOpacity", 
								legendIcon.attr("opacity") || 1);
					}
	
					legend.attr("opacity", "0.3");
					legendIcon.attr("opacity", "0.3");
					if (legendDot) {
						legendDot.attr("opacity", "0.3");
					}
					legendNode.data("hidden", true);
				}
				else {
					self._showSerieEles(seriesEle);
					legend.attr("opacity", legendNode.data("textOpacity"));
					legendIcon.attr("opacity", legendNode.data("iconOpacity"));
					if (legendDot) {
						legendDot.attr("opacity", legendNode.data("dotOpacity"));
					}
					legendNode.data("hidden", false);
				}
			}
		},

		_showSerieEles: function (seriesEle) {
			
		},

		_hideSerieEles: function (seriesEle) {
			
		},

		_unbindLiveEvents: function () {
			var self = this,
				element = this.chartElement,
				widgetName = self.widgetName;
			$(".wijchart-legend", element[0]).die(widgetName)
			// for jQuery 1.7.1
			.die("." + widgetName);
			element.unbind("mousemove");
		},

		_isBarChart: function () {
			return false;
		},

		_isPieChart: function () {
			return false;
		},

		// methods for Axis
		_calculateParameters: function (axisInfo, axisOptions) {
			var self = this,
				maxData = axisOptions.max,
				minData = axisOptions.min,
				autoMax = axisOptions.autoMax && axisInfo.autoMax,
				autoMin = axisOptions.autoMin && axisInfo.autoMin,
				autoMajor = axisOptions.autoMajor && axisInfo.autoMajor,
				autoMinor = axisOptions.autoMinor && axisInfo.autoMinor,
				axisAnno = null,
				prec = null,
				isVL = axisOptions.annoMethod === "valueLabels",
				major = 0,
				newmax = 0,
				newmin = 0,
				dx = 0,
				tinc = 0,
				isTime = axisInfo.isTime,
				adjustMinValue = self.options.adjustMinValue;

			if (autoMax && maxData !== Number.MIN_VALUE) {
				if (axisInfo.id !== "x" && self._isBarChart()) {
					if (maxData < 0.0 && (0.5 * (maxData - minData) > -maxData)) {
						maxData = 0.0;
					}
				}
			}

			if (autoMin && minData !== Number.MAX_VALUE) {
				if (axisInfo.id !== "x" && self._isBarChart()) {
					if (minData > 0.0 && (0.5 * (maxData - minData) > minData)) {
						minData = 0.0;
					}
				}
			}

			if (maxData === minData) {
				if (minData !== 0) {
					minData -= 1;
				}
				maxData += 1;
			}
			dx = maxData - minData;

			if (isTime) {
				axisAnno = axisOptions.annoFormatString;
				if (!axisAnno || axisAnno.length === 0) {
					axisAnno = self._getTimeDefaultFormat(maxData, minData);
					axisInfo.annoFormatString = axisAnno;
				}
				tinc = self._niceTimeUnit(0.0, axisAnno);
			}
			prec = self._nicePrecision(dx);
			axisInfo.tprec = prec;
			if (autoMax) {
				if (isTime) {
					newmax = self._roundTime(maxData, tinc, true);
					if (newmax < maxData) {
						maxData = newmax + tinc;
					} else {
						maxData = newmax;
					}
				} else {
					newmax = self._precCeil(-prec, maxData);
					if (typeof (newmax) === "number") {
						maxData = newmax;
					}
				}
			}
			if (autoMin) {
				if (isTime) {
					newmin = self._roundTime(minData, tinc, false);
					if (newmin > minData) {
						minData = newmin - tinc;
					} else {
						minData = newmin;
					}
				} else {
					newmin = self._precFloor(-prec, minData);
					if (typeof (newmin) === "number") {
						minData = newmin;
					}
				}
			}

			axisInfo.max = maxData;
			axisInfo.min = minData;
			axisInfo.annoFormatString = axisAnno;
			axisInfo.tinc = tinc;

			if (autoMajor || autoMinor) {
				dx = maxData - minData;
				self._calculateMajorMinor(axisOptions, axisInfo);
				// var minor = axisOptions.unitMinor;
				major = axisOptions.unitMajor;
				if (autoMax && major !== 0 && !isTime && !isVL) {
					dx = maxData - parseInt(maxData / major, 10) * major;

					if (dx !== 0) {
						maxData += (major - dx);
						maxData = self._precCeil(-prec, maxData);
					}
				}

				if (autoMin && major !== 0 && !isTime && !isVL) {
					dx = minData - parseInt(minData / major, 10) * major;

					if (dx !== 0) {
						if (dx < 0) {
							dx += major;
						}

						minData -= Math.abs(dx); // should always be less.
						minData = self._precFloor(-prec, minData);
					}
				}
				
				if (autoMin && major !== 0 && !isVL &&
						(typeof adjustMinValue === "undefined" || 
						adjustMinValue === false) && 
						autoMin && minData === axisOptions.min &&
						minData - major >= 0 && axisInfo.id === "y") {
					minData -= major;
				}
			}

			/*
			 * //TODO: if (!autoMajor || !autoMinor) { }
			 */

			axisInfo.max = maxData;
			axisInfo.min = minData;
		},

		_roundTime: function (timevalue, unit, roundup) {
			var self = this,
			// tunit = unit * self._tmInc.day,
				tunit = unit,
				tv = $.fromOADate(timevalue),
				th,
				td,
				tx,
				tz;

			if (tunit > 0) {
				th = {
					year: tv.getFullYear(),
					month: tv.getMonth(),
					day: tv.getDate(),
					hour: tv.getHours(),
					minute: tv.getMinutes(),
					second: tv.getSeconds()
				};
				if (tunit < self._tmInc.minute) {
					th.second = self._tround(th.second, tunit, roundup);
					return self._getTimeAsDouble(th);
				}

				th.second = 0;
				if (tunit < self._tmInc.hour) {
					tunit /= self._tmInc.minute;
					th.minute = self._tround(th.minute, tunit, roundup);
					return self._getTimeAsDouble(th);
				}

				th.minute = 0;
				if (tunit < self._tmInc.day) {
					tunit /= self._tmInc.hour;
					th.hour = self._tround(th.hour, tunit, roundup);
					return self._getTimeAsDouble(th);
				}

				th.hour = 0;
				if (tunit < self._tmInc.month) {
					tunit /= self._tmInc.day;
					th.day = self._tround(th.day, tunit, roundup);
					return self._getTimeAsDouble(th);
				}

				th.day = 1;
				if (tunit < self._tmInc.year) {
					tunit /= self._tmInc.month;
					th.month = self._tround(th.month, tunit, roundup);
					return self._getTimeAsDouble(th);
				}

				// th.month = 1;
				th.month = 0; // the month start from 0 in javascript.
				tunit /= self._tmInc.year;
				th.year = self._tround(th.year, tunit, roundup);
				return self._getTimeAsDouble(th);
			} else {
				td = tv;
				tx = td - tunit;
				tz = parseInt(tx / unit, 10) * unit;
				if (roundup && tz !== tx) {
					tz += unit;
				}
				td = tunit + tz;
				return td;
			}
		},

		_tround: function (tval, tunit, roundup) {
			var test = parseInt((tval / tunit) * tunit, 10);
			if (roundup && test !== tval) {
				test += parseInt(tunit, 10);
			}
			return test;
		},

		_getTimeAsDouble: function (th) {
			var smon = 0,
				sday = 0,
				newDate = null;
			if (th.day < 1) {
				sday = -1 - th.day;
				th.day = 1;
			} else if (th.day > 28) {
				sday = th.day - 28;
				th.day = 28;
			}

			/*
			 * if (th.month < 1) { smon = -1 - th.day; th.month = 1; } else if
			 * (th.month > 12) { smon = th.month - 12; th.month = 12; }
			 */
			// the month start from 0 & end with 11 in javascript.
			if (th.month < 0) {
				smon = -1 - th.day;
				th.month = 0;
			} else if (th.month > 11) {
				smon = th.month - 11;
				th.month = 11;
			}
			newDate = new Date(th.year, th.month, th.day,
				th.hour, th.minute, th.second);
			newDate.setDate(newDate.getDate() + sday);
			newDate.setMonth(newDate.getMonth() + smon);
			return $.toOADate(newDate);
		},

		_getTimeDefaultFormat: function (max, min) {
			var self = this,
			// range = (max - min) * self._tmInc.day,
				range = max - min,
				format = "d";
				// format = "s";
			if (range > 2 * self._tmInc.year) {
				format = "yyyy";
			} else if (range > self._tmInc.year) {
				format = "MMM yy";
			} else if (range > 3 * self._tmInc.month) {
				format = "MMM";
			} else if (range > 2 * self._tmInc.week) {
				format = "MMM d";
			} else if (range > 2 * self._tmInc.day) {
				format = "ddd d";
			} else if (range > self._tmInc.day) {
				format = "ddd H:mm";
			} else if (range > self._tmInc.hour) {
				format = "H:mm";
			} else if (range >= 1000) {
				format = "H:mm:ss";
			}
			/*
			 * else if (range > 0) { //TODO: return millisecond }
			 */
			return format;
		},

		_niceTimeUnit: function (timeinc, manualFormat) {
			var self = this,
			// tsRange = timeinc * self._tmInc.day;
				tsRange = timeinc;

			tsRange = self._niceTimeSpan(tsRange, manualFormat);

			// return tsRange / self._tmInc.day;
			return tsRange;
		},

		_niceTimeSpan: function (range, manualFormat) {
			var self = this,
				minSpan = self._manualTimeInc(manualFormat),
				tsinc = 0,
				tinc = 0;
			/*
			 * if (minSpan < this._tmInc.second) { //TODO: calculate when
			 * millisecond }
			 */
			tsinc = Math.ceil(range);
			if (tsinc === 0) {
				return self._timeSpanFromTmInc(minSpan);
			}
			tinc = 1;
			if (minSpan < self._tmInc.minute) {
				if (tsinc < self._tmInc.minute) {
					tinc = self._getNiceInc([1, 2, 5, 10, 15, 30], tsinc, minSpan);
					if (tinc !== 0) {
						return tinc;
					}
				}
				minSpan = self._tmInc.minute;
			}
			if (minSpan < self._tmInc.hour) {
				if (tsinc < self._tmInc.hour) {
					tinc = self._getNiceInc([1, 2, 5, 10, 15, 30], tsinc, minSpan);
					if (tinc !== 0) {
						return tinc;
					}
				}
				minSpan = self._tmInc.hour;
			}
			if (minSpan < self._tmInc.day) {
				if (tsinc < self._tmInc.day) {
					tinc = self._getNiceInc([1, 3, 6, 12], tsinc, minSpan);
					if (tinc !== 0) {
						return tinc;
					}
				}
				minSpan = self._tmInc.day;
			}
			if (minSpan < self._tmInc.month) {
				if (tsinc < self._tmInc.month) {
					tinc = self._getNiceInc([1, 2, 7, 14], tsinc, minSpan);
					if (tinc !== 0) {
						return tinc;
					}
				}
				minSpan = self._tmInc.month;
			}
			if (minSpan < self._tmInc.year) {
				if (tsinc < self._tmInc.year) {
					tinc = self._getNiceInc([1, 2, 3, 4, 6], tsinc, minSpan);
					if (tinc !== 0) {
						return tinc;
					}
				}
				minSpan = self._tmInc.year;
			}
			tinc = 100 * self._tmInc.year;
			if (tsinc < tinc) {
				tinc = self._getNiceInc([1, 2, 5, 10, 20, 50], tsinc, minSpan);
				if (tinc === 0) {
					tinc = 100 * self._tmInc.year;
				}
			}
			return tinc;
		},

		_getNiceInc: function (tik, ts, mult) {
			var i = 0,
				tikm = 0,
				ii = tik.length;

			for (i = 0; i < ii; i++) {
				tikm = tik[i] * mult;
				if (ts <= tikm) {
					return tikm;
				}
			}

			return 0;
		},

		_timeSpanFromTmInc: function (ti) {
			var rv = 1000,
				rti = ti,
				ticks = 1;

			if (ti !== this._tmInc.maxtime) {
				if (ti > this._tmInc.tickf1) {
					rv = ti;
				} else {
					ti += 7;
					while (rti > 0) {
						ticks *= 10;
						rti--;
					}
					rv = ticks;
				}
			}
			return rv;
		},

		_manualTimeInc: function (manualFormat) {
			var self = this,
				minSpan = self._tmInc.second;
			if (!manualFormat || manualFormat.length === 0) {
				return minSpan;
			}
			// var f = manualFormat.indexOf("f");
			// if (f > 0) {
			// //TODO: when _getTimeDefaultFormat return millisecond
			// }
			// else if (manualFormat.indexOf("s") >= 0) {
			if (manualFormat.indexOf("s") >= 0) {
				minSpan = self._tmInc.second;
			} else if (manualFormat.indexOf("m") >= 0) {
				minSpan = self._tmInc.minute;
			} else if (manualFormat.indexOf("h") >= 0 || manualFormat.indexOf("H") >= 0) {
				minSpan = self._tmInc.hour;
			} else if (manualFormat.indexOf("d") >= 0) {
				minSpan = self._tmInc.day;
			} else if (manualFormat.indexOf("M") >= 0) {
				minSpan = self._tmInc.month;
			} else if (manualFormat.indexOf("y") >= 0) {
				minSpan = self._tmInc.year;
			}
			return minSpan;
		},

		_tmInc: {
			tickf7: -7000,
			tickf6: -6000,
			tickf5: -5000,
			tickf4: -4000,
			tickf3: -3000,
			tickf2: -2000,
			tickf1: -1,
			second: 1000,
			minute: 60 * 1000,
			hour: 60 * 60 * 1000,
			day: 24 * 60 * 60 * 1000,
			week: 7 * 24 * 60 * 60 * 1000,
			month: 31 * 24 * 60 * 60 * 1000,
			year: 365 * 24 * 60 * 60 * 1000,
			maxtime: 2147483647	// int.max
		},

		_niceTickNumber: function (x) {
			if (parseFloat(x) === 0.0) {
				return x;
			} else if (x < 0) {
				x = -x;
			}
			var log10 = Math.log(x) / Math.log(10),
				exp = parseInt(this._signedFloor(log10), 10),
				f = x / Math.pow(10.0, exp),
				nf = 10.0;
			if (f <= 1.0) {
				nf = 1.0;
			} else if (f <= 2.0) {
				nf = 2.0;
			} else if (f <= 5.0) {
				nf = 5.0;
			}
			return (nf * Math.pow(10.0, exp));
		},

		_niceNumber: function (x, exp, round) {
			if (parseFloat(x) === 0.0) {
				return x;
			} else if (x < 0) {
				x = -x;
			}

			var f = x / Math.pow(10.0, exp),
				nf = 10.0;

			if (round) {
				if (f < 1.5) {
					nf = 1.0;
				} else if (f < 3.0) {
					nf = 2.0;
				} else if (f < 7.0) {
					nf = 5.0;
				}
			} else {
				if (f <= 1.0) {
					nf = 1.0;
				} else if (f <= 2.0) {
					nf = 2.0;
				} else if (f <= 5.0) {
					nf = 5.0;
				}
			}

			return (nf * Math.pow(10.0, exp));
		},

		_nicePrecision: function (range) {
			if (range <= 0 || typeof (range) !== "number") {
				return 0;
			}

			var log10 = Math.log(range) / Math.log(10),
				exp = parseInt(this._signedFloor(log10), 10),
				f = range / Math.pow(10.0, exp);

			if (f < 3.0) {
				exp = -exp + 1;
			}

			return exp;
		},

		_precCeil: function (prec, value) {
			var f = Math.pow(10.0, prec),
				x = value / f;

			x = Math.ceil(x);

			return x * f;
		},

		_precFloor: function (prec, value) {
			var f = Math.pow(10.0, prec),
				x = value / f;

			x = Math.floor(x);

			return x * f;
		},

		_signedCeiling: function (val) {
			if (val < 0.0) {
				return Math.floor(val);
			}

			return Math.ceil(val);
		},

		_signedFloor: function (val) {
			if (val < 0.0) {
				return Math.ceil(val);
			}

			return Math.floor(val);
		},

		_getDataExtreme: function (isMultiYAxis) {
			var val = {
				txx: 0,
				txn: 0,
				tyx: 0,
				tyn: 0
			}, valGroup;

			valGroup = this._getDataExtremes(val, isMultiYAxis);
			if (valGroup) {
				if (valGroup.txn > valGroup.txx) {
					valGroup.txn = 0;
					valGroup.txx = 1;
				}
				return valGroup;
			}
			else {
				if (val.txn > val.txx) {
					val.txn = 0;
					val.txx = 1;
				}
				return val;
			}
		},

		_getDataExtremes: function (val, isMultiYAxis) {
			var self = this,
				o = self.options,
				seriesList = o.seriesList,
				stacked = o.stacked,
				is100Percent = o.is100Percent,
				axis = o.axis,
				axisInfo = self.axisInfo,
				valuesX = [],				
				lastValuesY = [],
				valueLabels = [],
				validValue,
				valGroup = { y: {} };

			if (!seriesList || seriesList.length === 0) {
				return val;
			}
			
			if (self.seriesGroup) {
				$.each(self.seriesGroup, function (key, seriesL) {
					var valuesY = [];
					$.each(seriesL, function (i, series) {
						if (series.type === "pie") {
							return true;
						}
						// support hole.
						series = $.extend(true, {display: "show"}, series);
						// end comments

						var data = series.data,
							index = 0,
							k = 0,
							valuesXY = [].concat(data.xy),
							len = valuesXY.length,
							xMinMax, 
							yMinMax;
				
						// support hole.
						if (series.display === "exclude") {
							return true;
						}
						// end comments

						valuesX = [].concat(data.x);
						valuesY = [].concat(data.y);

						if (data.xy && len) {
							valuesX = [];
							valuesY = [];

							while (k < len) {
								valuesX[index] = valuesXY[k];
								valuesY[index] = valuesXY[k + 1];
								k += 2;
								index++;
								data.x = valuesX;
								data.y = valuesY;
							}
						} else if (!data.x) {
							valuesX = [];

							$.each(valuesY, function (i) {
								valuesX.push(i);
							});

							data.x = valuesX;
						}

						if (stacked && i > 0) {
							$.each(valuesY, function (j) {
								// if (j === 0) {
								// return true;
								// }

								// valuesY[j] += valuesY[j - 1];
								valuesY[j] += lastValuesY[j];
							});
						}
						lastValuesY = valuesY;

						xMinMax = self._getMinMaxValue(valuesX);
						yMinMax = self._getMinMaxValue(valuesY);

						if (i === 0) {
							val.txx = xMinMax.max;
							val.txn = xMinMax.min;
							val.tyx = yMinMax.max;
							val.tyn = yMinMax.min;
						} else {
							if (val.txx < xMinMax.max) {
								val.txx = xMinMax.max;
							}
							if (val.txn > xMinMax.min) {
								val.txn = xMinMax.min;
							}
							if (val.tyx < yMinMax.max) {
								val.tyx = yMinMax.max;
							}
							if (val.tyn > yMinMax.min) {
								val.tyn = yMinMax.min;
							}
						}
						i++;									
					});

					if (is100Percent) {
						val.tyx = 1;
						val.tyn = 0;
					}

					valGroup.y[key] = {tyx: val.tyx, tyn: val.tyn};
					valGroup.txx = val.txx;
					valGroup.txn = val.txn;
					val.tyx = 0;
					val.tyn = 0;
					//val = {txx: val.txx, txn: val.txn, tyx: 0, tyn: 0 };

					if (valuesY.length) {
						validValue = $.wijchart.getFirstValidListValue(valuesY);
						if (self._isDate(validValue)) {
							axisInfo.y[key].isTime = true;
						} else if (typeof (validValue) !== "number") {
							$.each(valuesY, function (idx, valueY) {
								// valueLabels.push({
								// text: valueY,
								// value: idx
								// });
								// Add comments by RyanWu@20110707.
								// For fixing the issue#15881.
								// valueLabels.push(valueY);
								var formatString = axis.y.annoFormatString,
									value = valueY;

								if (formatString && formatString.length > 0) {
									// value = $.format(value, formatString);
									value = Globalize.format(value, formatString, 
										self._getCulture());
								} else {
									value = value.toString();
								}

								// valueLabels.push(value);
								valueLabels.push({
									text: value,
									value: valueY,
									gridLine: false
								});
								// end by RyanWu@20110707.
							});

							axis.y[parseInt(key, 10)].annoMethod = "valueLabels";
							axis.y[parseInt(key, 10)].valueLabels = valueLabels;
							axis.x.max = valuesY.length - 1;
							axis.x.min = 0;
							axis.y[parseInt(key, 10)].unitMajor = 1;
							axis.x.unitMinor = 0.5;
							axisInfo.y[key].autoMax = false;
							axisInfo.y[key].autoMin = false;
							axisInfo.y[key].autoMajor = false;
							axisInfo.y[key].autoMinor = false;
						}
					}
				});
			}
			
			
			if (valuesX.length) {
				validValue = $.wijchart.getFirstValidListValue(valuesX);
				if (self._isDate(validValue)) {
					axisInfo.x.isTime = true;
				} else if (typeof (validValue) !== "number") {
					$.each(valuesX, function (idx, valueX) {
						valueLabels.push({
							text: valueX,
							value: idx,
							gridLine: false
						});
						// valueLabels.push(valueX);
					});

					axis.x.annoMethod = "valueLabels";
					axis.x.valueLabels = valueLabels;
					axis.x.max = valuesX.length - 1;
					axis.x.min = 0;
					axis.x.unitMajor = 1;
					axis.x.unitMinor = 0.5;
					axisInfo.x.autoMax = false;
					axisInfo.x.autoMin = false;
					axisInfo.x.autoMajor = false;
					axisInfo.x.autoMinor = false;
				}
			}

			return valGroup;
			//return val;
		},

		_isDate: function (obj) {
			if (!obj) {
				return false;
			}
			return (typeof obj === 'object') && obj.constructor === Date;
		},

		_getMinMaxValue: function (array) {
			var self = this,
				val = {
					min: 0,
					max: 0
				},
				i = 0,
				validValue;

			if (!array.length) {
				return;
			}

			validValue = $.wijchart.getFirstValidListValue(array);
			if (typeof (validValue) !== "number") {
				if (self._isDate(validValue)) {
					val.min = validValue;
					val.max = validValue;
				} else {
					val.min = 0;
					val.max = array.length - 1;
					return val;
				}
			} else {
				val.min = validValue;
				val.max = validValue;
			}

			for (i = 0; i < array.length; i++) {
				if (array[i] === null || typeof array[i] === "undefined") {
					continue;
				}
				if (array[i] < val.min) {
					val.min = array[i];
				} else if (array[i] > val.max) {
					val.max = array[i];
				}
			}

			if (self._isDate(val.min)) {
				val.min = $.toOADate(val.min);
				val.max = $.toOADate(val.max);
			}

			return val;
		},

		_isVertical: function (compass) {
			return compass === "west" || compass === "east";
		},

		_calculateMajorMinor: function (axisOptions, axisInfo) {
			var self = this,
				o = self.options,
				canvasBounds = self.canvasBounds,
				autoMajor = axisOptions.autoMajor,
				autoMinor = axisOptions.autoMinor,
				maxData = axisInfo.max,
				minData = axisInfo.min,
				isTime = axisInfo.isTime,
				tinc = axisInfo.tinc,
				formatString = axisInfo.annoFormatString,
				maxText = null,
				minText = null,
				sizeMax = null,
				sizeMin = null,
				mx = null,
				mn = null,
				prec = null,
				_prec = null,
				textStyle = null,
				dx = maxData - minData,
				width = 0,
				height = 0,
				nticks = 0,
				major = 0;

			if (autoMajor) {
				textStyle = $.extend(true, {}, o.textStyle,
					axisOptions.textStyle, axisOptions.labels.style);

				if (isTime) {
					// maxText = $.format($.fromOADate(maxData), formatString);
					maxText = 
					Globalize.format($.fromOADate(maxData), formatString, 
						self._getCulture());
					// minText = $.format($.fromOADate(minData), formatString);
					minText = 
					Globalize.format($.fromOADate(minData), formatString, 
						self._getCulture());

					mx = self._text(-1000, -1000, maxText).attr(textStyle);
					mn = self._text(-1000, -1000, minText).attr(textStyle);

					sizeMax = mx.wijGetBBox();
					sizeMin = mn.wijGetBBox();

					mx.wijRemove();
					mx = null;
					mn.wijRemove();
					mn = null;
				} else {
					prec = self._nicePrecision(dx);
					_prec = prec + 1;

					if (_prec < 0 || _prec > 15) {
						_prec = 0;
					}

					mx = self._text(-1000, -1000,
						$.round(maxData, _prec)).attr(textStyle);
					mn = self._text(-1000, -1000,
						$.round(minData, _prec)).attr(textStyle);

					sizeMax = mx.wijGetBBox();
					sizeMin = mn.wijGetBBox();

					mx.wijRemove();
					mx = null;
					mn.wijRemove();
					mn = null;
				}

				if (sizeMax.width < sizeMin.width) {
					sizeMax.width = sizeMin.width;
				}

				if (sizeMax.height < sizeMin.height) {
					sizeMax.height = sizeMin.height;
				}

				if (!self._isVertical(axisOptions.compass)) {
					// Add comments by RyanWu@20100907.
					// Subtract axisTextOffset because we must left
					// the space between major text and major rect.
					width = canvasBounds.endX - canvasBounds.startX -
						axisInfo.vOffset - axisInfo.axisTextOffset;
					major = width / sizeMax.width;

					if (Number.POSITIVE_INFINITY === major) {
						nticks = 0;
					} else {
						nticks = parseInt(major, 10);
					}
				} else {
					height = canvasBounds.endY - canvasBounds.startY -
						axisInfo.vOffset - axisInfo.axisTextOffset;
					major = height / sizeMax.height;

					if (Number.POSITIVE_INFINITY === major) {
						nticks = 0;
					} else {
						nticks = parseInt(major, 10);
					}
				}

				major = dx;
				if (nticks > 0) {
					dx /= nticks;
					if (isTime) {
						if (dx < tinc) {
							major = tinc;
						} else {
							major = self._niceTimeUnit(dx, axisInfo.annoFormatString);
						}
					} else {
						axisInfo.tprec = self._nicePrecision(dx);
						major = self._niceNumber(2 * dx, -prec, true);

						if (major < dx) {
							major = self._niceNumber(dx, -prec + 1, false);
						}

						if (major < dx) {
							major = self._niceTickNumber(dx);
						}
					}
				}

				axisOptions.unitMajor = major;
			}

			if (autoMinor && axisOptions.unitMajor && !isNaN(axisOptions.unitMajor)) {
				axisOptions.unitMinor = axisOptions.unitMajor / 2;
			}
		}
		// end of methods for Axis
		// end of methods
	});
} (jQuery));

/*globals jQuery, Globalize*/
/*
 *
 * Wijmo Library 1.1.2
 * http://wijmo.com/
 *
 * Copyright(c) ComponentOne, LLC.  All rights reserved.
 * 
 * Dual licensed under the Wijmo Commercial or GNU GPL Version 3 licenses.
 * licensing@wijmo.com
 * http://wijmo.com/license
 *
 *
 * * Wijmo BarChart widget
 *
 * Depends:
 *  raphael.js
 *  globalize.js
 *  jquery.ui.widget.js
 *  jquery.wijmo.wijchartcore.js
 *
 */

(function ($) {
	"use strict";

	$.widget("wijmo.wijbarchart", $.wijmo.wijchartcore, {
		options: {
			/// <summary>
			/// A value that determines whether the bar chart 
			///	renders horizontal or vertical.
			/// Default: true.
			/// Type: Boolean.
			/// Code example:
			///  $("#barchart").wijbarchart({
			///      horizontal: false
			///  });
			/// </summary>
			horizontal: true,
			/// <summary>
			/// A value that determines whether to show a stacked chart.
			/// Default: false.
			/// Type: Boolean.
			/// Code example:
			///  $("#barchart").wijbarchart({
			///      stacked: true
			///  });
			/// </summary>
			stacked: false,
			/// <summary>
			/// A value that determines whether to show a stacked and percentage chart.
			/// Default: false.
			/// Type: Boolean.
			/// Code example:
			///  $("#barchart").wijbarchart({
			///      is100Percent: true
			///  });
			/// </summary>
			is100Percent: false,
			/// <summary>
			/// A value that indicates the percentage of bar elements 
			///	in the same cluster overlap.
			/// Default: 0.
			/// Type: Number.
			/// Code example:
			///  $("#barchart").wijbarchart({
			///      clusterOverlap: 10
			///  });
			/// </summary>
			clusterOverlap: 0,
			/// <summary>
			/// A value that indicates the percentage of the plot area 
			///	that each bar cluster occupies.
			/// Default: 85.
			/// Type: Number.
			/// Code example:
			///  $("#barchart").wijbarchart({
			///      clusterWidth: 75
			///  });
			/// </summary>
			clusterWidth: 85,
			/// <summary>
			/// A value that indicates the corner-radius for the bar.
			/// Default: 0.
			/// Type: Number.
			/// Code example:
			///  $("#barchart").wijbarchart({
			///      clusterRadius: 5
			///  });
			/// </summary>
			clusterRadius: 0,
			/// <summary>
			/// A value that indicates the spacing between the adjacent bars.
			/// Default: 0.
			/// Type: Number.
			/// Code example:
			///  $("#barchart").wijbarchart({
			///      clusterSpacing: 3
			///  });
			/// </summary>
			clusterSpacing: 0,
			/// <summary>
			/// A value that indicates whether to show animation 
			///	and the duration for the animation.
			/// Default: {enabled:true, duration:400, easing: ">"}.
			/// Type: Object.
			/// Code example:
			///  $("#barchart").wijbarchart({
			///      animation: {
			///			enabled: true, duration: 1000, easing: "<"
			///		}
			///  });
			/// </summary>
			animation: {
				/// <summary>
				/// A value that determines whether to show animation.
				/// Default: true.
				/// Type: Boolean.
				/// </summary>
				enabled: true,
				/// <summary>
				/// A value that indicates the duration for the animation.
				/// Default: 400.
				/// Type: Number.
				/// </summary>
				duration: 400,
				/// <summary>
				/// A value that indicates the easing for the animation.
				/// Default: ">".
				/// Type: string.
				/// </summary>
				easing: ">"
			},
			/// <summary>
			/// A value that indicates whether to show animation 
			///	and the duration for the animation when reloading data.
			/// Default: {enabled:true, duration:400, easing: ">"}.
			/// Type: Object.
			/// Code example:
			///  $("#barchart").wijbarchart({
			///      seriesTransition: {enabled: true, duration: 1000, easing: "<"}
			///  });
			/// </summary>
			seriesTransition: {
				/// <summary>
				/// A value that determines whether to show animation when reloading data.
				/// Default: true.
				/// Type: Boolean.
				/// </summary>
				enabled: true,
				/// <summary>
				/// A value that indicates the duration for the series transition.
				/// Default: 400.
				/// Type: Number.
				/// </summary>
				duration: 400,
				/// <summary>
				/// A value that indicates the easing for the series transition.
				/// Default: ">".
				/// Type: string.
				/// </summary>
				easing: ">"
			},
			/// <summary>
			/// Fires when the user clicks a mouse button.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a function as an option.
			///  $("#barchart").wijbarchart({mouseDown: function(e, data) { } });
			/// Bind to the event by type: wijbarchartmousedown
			/// $("#barchart").bind("wijbarchartmousedown", function(e, data) {} );
			/// </summary>
			/// <param name="e" type="eventObj">
			/// jQuery.Event object.
			///	</param>
			/// <param name="data" type="Object">
			/// An object that contains all the series info of the mouse down bar.
			/// data.bar: the Raphael object of the bar.
			/// data.data: data of the series of the bar.
			/// data.hoverStyle: hover style of series of the bar.
			/// data.index: index of the bar.
			/// data.label: label of the series of the bar.
			/// data.legendEntry: legend entry of the series of the bar.
			/// data.style: style of the series of the bar.
			/// data.type: "bar"
			/// data.x: The x value of the bar.
			/// data.y: the y valuue of the bar.
			///	</param>
			mouseDown: null,
			/// <summary>BarChartSeries
			/// Fires when the user releases a mouse button
			/// while the pointer is over the chart element.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a function as an option.
			///  $("#barchart").wijbarchart({mouseUp: function(e, data) { } });
			/// Bind to the event by type: wijbarchartmouseup
			/// $("#barchart").bind("wijbarchartmouseup", function(e, data) {} );
			/// </summary>
			/// <param name="e" type="eventObj">
			/// jQuery.Event object.
			///	</param>
			/// <param name="data" type="Object">
			/// An object that contains all the series info of the mouse up bar.
			/// data.bar: the Raphael object of the bar.
			/// data.data: data of the series of the bar.
			/// data.hoverStyle: hover style of series of the bar.
			/// data.index: index of the bar.
			/// data.label: label of the series of the bar.
			/// data.legendEntry: legend entry of the series of the bar.
			/// data.style: style of the series of the bar.
			/// data.type: "bar"
			/// data.x: The x value of the bar.
			/// data.y: the y valuue of the bar.
			///	</param>
			mouseUp: null,
			/// <summary>
			/// Fires when the user first places the pointer over the chart element.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a function as an option.
			///  $("#barchart").wijbarchart({mouseOver: function(e, data) { } });
			/// Bind to the event by type: wijbarchartmouseover
			/// $("#barchart").bind("wijbarchartmouseover", function(e, data) {} );
			/// </summary>
			/// <param name="e" type="eventObj">
			/// jQuery.Event object.
			///	</param>
			/// <param name="data" type="Object">
			/// An object that contains all the series infos of the mouseover bar.
			/// data.bar: the Raphael object of the bar.
			/// data.data: data of the series of the bar.
			/// data.hoverStyle: hover style of series of the bar.
			/// data.index: index of the bar.
			/// data.label: label of the series of the bar.
			/// data.legendEntry: legend entry of the series of the bar.
			/// data.style: style of the series of the bar.
			/// data.type: "bar"
			/// data.x: The x value of the bar.
			/// data.y: the y valuue of the bar.
			///	</param>
			mouseOver: null,
			/// <summary>
			/// Fires when the user moves the pointer off of the chart element.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a function as an option.
			///  $("#barchart").wijbarchart({mouseOut: function(e, data) { } });
			/// Bind to the event by type: wijbarchartmouseout
			/// $("#barchart").bind("wijbarchartmouseout", function(e, data) {} );
			/// </summary>
			/// <param name="e" type="eventObj">
			/// jQuery.Event object.
			///	</param>
			/// <param name="data" type="Object">
			/// An object that contains all the series infos of the mouseout bar.
			/// data.bar: the Raphael object of the bar.
			/// data.data: data of the series of the bar.
			/// data.hoverStyle: hover style of series of the bar.
			/// data.index: index of the bar.
			/// data.label: label of the series of the bar.
			/// data.legendEntry: legend entry of the series of the bar.
			/// data.style: style of the series of the bar.
			/// data.type: "bar"
			/// data.x: The x value of the bar.
			/// data.y: the y valuue of the bar.
			///	</param>
			mouseOut: null,
			/// <summary>
			/// Fires when the user moves the mouse pointer
			/// while it is over a chart element.
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a function as an option.
			///  $("#barchart").wijbarchart({mouseMove: function(e, data) { } });
			/// Bind to the event by type: wijbarchartmousemove
			/// $("#barchart").bind("wijbarchartmousemove", function(e, data) {} );
			/// </summary>
			/// <param name="e" type="eventObj">
			/// jQuery.Event object.
			///	</param>
			/// <param name="data" type="Object">
			/// An object that contains all the series infos of the mousemove bar.
			/// data.bar: the Raphael object of the bar.
			/// data.data: data of the series of the bar.
			/// data.hoverStyle: hover style of series of the bar.
			/// data.index: index of the bar.
			/// data.label: label of the series of the bar.
			/// data.legendEntry: legend entry of the series of the bar.
			/// data.style: style of the series of the bar.
			/// data.type: "bar"
			/// data.x: The x value of the bar.
			/// data.y: the y valuue of the bar.
			///	</param>
			mouseMove: null,
			/// <summary>
			/// Fires when the user clicks the chart element. 
			/// Default: null.
			/// Type: Function.
			/// Code example:
			/// Supply a function as an option.
			///  $("#barchart").wijbarchart({click: function(e, data) { } });
			/// Bind to the event by type: wijbarchartclick
			/// $("#barchart").bind("wijbarchartclick", function(e, data) {} );
			/// </summary>
			/// <param name="e" type="eventObj">
			/// jQuery.Event object.
			///	</param>
			/// <param name="data" type="Object">
			/// An object that contains all the series infos of the clicked bar.
			/// data.bar: the Raphael object of the bar.
			/// data.data: data of the series of the bar.
			/// data.hoverStyle: hover style of series of the bar.
			/// data.index: index of the bar.
			/// data.label: label of the series of the bar.
			/// data.legendEntry: legend entry of the series of the bar.
			/// data.style: style of the series of the bar.
			/// data.type: "bar"
			/// data.x: The x value of the bar.
			/// data.y: the y valuue of the bar.
			///	</param>
			click: null
		},

		_create: function () {
			var self = this,
				o = self.options,
				defFill = self._getDefFill();

//			if (o.horizontal) {
//				$.extend(true, o.axis, {
//					x: {
//						compass: "west"
//					},
//					y: {
//						compass: "south"
//					}
//				});
//			}

			$.extend(true, {
				compass: "east"
			}, o.hint);

			// default some fills
			$.each(o.seriesStyles, function (idx, style) {
				if (!style.fill) {
					style.fill = defFill[idx];
				}
			});
			defFill = null;

			$.wijmo.wijchartcore.prototype._create.apply(self, arguments);
			self.chartElement.addClass("wijmo-wijbarchart");
		},

		_setOption: function (key, value) {
			if (key === "horizontal" && !value) {
				$.extend(true, this.options.axis, {
					x: {
						compass: "south"
					},
					y: {
						compass: "west"
					}
				});
			}

			$.wijmo.wijchartcore.prototype._setOption.apply(this, arguments);
		},

		destroy: function () {
			/// <summary>
			/// Remove the functionality completely. This will return the 
			/// element back to its pre-init state.
			/// Code example:
			/// $("#barchart").wijbarchart("destroy");
			/// </summary>
			var self = this,
				element = self.chartElement,
				fields = element.data("fields"),
				aniBarsAttr = fields && fields.bars;

			element.removeClass("wijmo-wijbarchart");
			$.wijmo.wijchartcore.prototype.destroy.apply(this, arguments);

			if (aniBarsAttr && aniBarsAttr.length) {
				$.each(aniBarsAttr, function (idx, barAttr) {
					barAttr = null;
				});
			}

			element.data("fields", null);
		},

		_clearChartElement: function () {
			var self = this,
				o = self.options,
				fields = self.chartElement.data("fields");

			$.wijmo.wijchartcore.prototype._clearChartElement.apply(self, arguments);
			self.element.removeData("plotInfos");

			if (!o.seriesTransition.enabled) {
				if (fields && fields.aniBarsAttr) {
					fields.aniBarsAttr = null;
				}
			}
		},

		_isBarChart: function () {
			return true;
		},

		/*****************************
		Widget specific implementation
		******************************/
		/** public methods */
		getBar: function (index) {
			/// <summary>
			/// Returns the bar which has a set of the Raphael's objects(rects) 
			/// that represents bars for the series data with the given index.
			/// Code example:
			/// $("#barchart").wijbarchart("getBar", 2);
			/// </summary>
			/// <param name="index" type="Number">
			/// The index of the bar.
			/// </param>
			/// <returns type="Raphael element">
			/// The bar object.
			/// </returns>
			var element = this.chartElement,
				fields = element.data("fields");

			return fields.chartElements.bars[index];
		},
		/** end of public methods */


		_paintTooltip: function () {
			var self = this,
				element = self.chartElement,
				fields = element.data("fields");

			$.wijmo.wijchartcore.prototype._paintTooltip.apply(this, arguments);

			if (self.tooltip) {
				if (fields && fields.trackers && fields.trackers.length) {
					self.tooltip.setTargets(fields.trackers);
					self.tooltip.setOptions({ relatedElement: fields.trackers[0] });
				}
			}
		},

		_getTooltipText: function (fmt, target) {
			var tar = $(target.node),
				dataObj,
			//value = dataObj.data,
				obj;
			if (tar.data("owner")) {
				tar = tar.data("owner");
			}
			dataObj = tar.data("wijchartDataObj");
			obj = {
				data: dataObj,
				value: dataObj.value,
				label: dataObj.label,
				total: dataObj.total,
				target: target,
				fmt: fmt,
				x: dataObj.x,
				y: dataObj.y
			};
			return $.proxy(fmt, obj)();
		},

		_paintPlotArea: function () {
			var self = this,
				o = self.options;

			self.chartElement.wijbar({
				canvas: self.canvas,
				bounds: self.canvasBounds,
				tooltip: self.tooltip,
				widgetName: self.widgetName,
				horizontal: o.horizontal,
				stacked: o.stacked,
				axis: o.axis,
				seriesList: o.seriesList,
				seriesStyles: o.seriesStyles,
				seriesHoverStyles: o.seriesHoverStyles,
				seriesTransition: o.seriesTransition,
				showChartLabels: o.showChartLabels,
				textStyle: o.textStyle,
				chartLabelStyle: o.chartLabelStyle,
				chartLabelFormatString: o.chartLabelFormatString,
				shadow: o.shadow,
				disabled: o.disabled,
				clusterOverlap: o.clusterOverlap,
				clusterWidth: o.clusterWidth,
				clusterSpacing: o.clusterSpacing,
				is100Percent: o.is100Percent,
				clusterRadius: o.clusterRadius,
				animation: o.animation,
				isYTime: self.axisInfo.y[0].isTime,
				isXTime: self.axisInfo.x.isTime,
				mouseDown: $.proxy(self._mouseDown, self),
				mouseUp: $.proxy(self._mouseUp, self),
				mouseOver: $.proxy(self._mouseOver, self),
				mouseOut: $.proxy(self._mouseOut, self),
				mouseMove: $.proxy(self._mouseMove, self),
				click: $.proxy(self._click, self)
			});
		},

		_showSerieEles: function (seriesEle) {
			$.each(seriesEle, function (i, bar) {
				if (bar.bar) {
					bar.bar.show();
					if (bar.bar.shadow) {
						bar.bar.shadow.show();
					}
					if (bar.bar.tracker) {
						bar.bar.tracker.show();
					}
				}
				if (bar.dcl) {
					bar.dcl.show();
				}

				if (bar.animatedBar && !bar.animatedBar.removed) {
					bar.animatedBar.show();
				}
			});
		},

		_hideSerieEles: function (seriesEle) {
			$.each(seriesEle, function (i, bar) {
				if (bar.bar) {
					bar.bar.hide();
					if (bar.bar.shadow) {
						bar.bar.shadow.hide();
					}
					if (bar.bar.tracker) {
						bar.bar.tracker.hide();
					}
				}
				if (bar.dcl) {
					bar.dcl.hide();
				}

				if (bar.animatedBar && !bar.animatedBar.removed) {
					bar.animatedBar.hide();
				}
			});
		},

		_calculateParameters: function (axisInfo, options) {
			$.wijmo.wijchartcore.prototype._calculateParameters.apply(this, arguments);

			// check for bar chart and x axis expansion
			if (axisInfo.id === "x") {
				var minor = options.unitMinor,
				//autoMin = options.autoMin,
				//autoMax = options.autoMax,
					adj = this._getBarAdjustment(axisInfo);

				if (adj === 0) {
					adj = minor;
				} else {
					if (minor < adj && minor !== 0) {
						adj = Math.floor(adj / minor) * minor;
					}
				}

				/*if (autoMin) {
				axisInfo.min -= adj;
				}

				if (autoMax) {
				axisInfo.max += adj;
				}*/

				axisInfo.min -= adj;
				axisInfo.max += adj;

				this._calculateMajorMinor(options, axisInfo);
			}
		},

		_getBarAdjustment: function (axisInfo) {
			var len = 0,
				o = this.options,
				max = axisInfo.max,
				min = axisInfo.min,
				seriesList = o.seriesList,
				i = 0,
				xLen = 0;

			for (i = 0; i < seriesList.length && seriesList[i].data.x; i++) {
				xLen = seriesList[i].data.x.length;

				if (len < xLen) {
					len = xLen;
				}
			}

			if (len > 1) {
				return (max - min) / len * o.clusterWidth * 0.0125;
			} else if (len === 1) {
				if (min === 0.0 && max === 1.0) {
					min = -1.0;
					axisInfo.min = min;
				}

				return (max - min) * 0.0125;
			} else {
				return 0;
			}
		}
	});

	function XSpec(nx) {
		var self = this;

		self.x = nx;
		self.paSpec = [];

		self.stackValues = function () {
			var len = self.paSpec.length,
							ps0;

			if (len > 1) {
				ps0 = self.paSpec[0];
				$.each(self.paSpec, function (idx, ps) {
					if (idx === 0) {
						return true;
					}

					ps.y += ps0.y;
					ps0 = ps;
				});
			}
		};
	}

	$.fn.extend({
		wijbar: function (options) {
			var paintShadow = function (element, offset, stroke) {
				if (options.shadow) {
					$.wijchart.paintShadow(element, offset, stroke);
				}
			},
				addClass = $.wijraphael.addClass,
				getScaling = $.wijchart.getScaling,
				getTranslation = $.wijchart.getTranslation,
				element = this,
				canvas = options.canvas,
				widgetName = options.widgetName,
				inverted = options.horizontal,
				stacked = options.stacked,
				seriesList = [].concat(options.seriesList),
				nSeries = seriesList.length,
				seriesStyles = [].concat(options.seriesStyles.slice(0, nSeries)),
				seriesHoverStyles = [].concat(
					options.seriesHoverStyles.slice(0, nSeries)),
				bounds = options.bounds,
				animation = options.animation,
				animated = animation && animation.enabled,
				startLocation = { x: bounds.startX, y: bounds.startY },
				width = bounds.endX - startLocation.x,
				height = bounds.endY - startLocation.y,
				xaxis = options.axis.x,
				yaxis = options.axis.y,
				disabled = options.disabled,
				mouseDown = options.mouseDown,
				mouseUp = options.mouseUp,
				mouseOver = options.mouseOver,
				mouseOut = options.mouseOut,
				mouseMove = options.mouseMove,
				click = options.click,
							xscale = getScaling(inverted, xaxis.max,
										xaxis.min, inverted ? height : width),
			//				yscale = getScaling(!inverted, yaxis.max,
			//							yaxis.min, inverted ? width : height),
							xlate = getTranslation(inverted, startLocation,
										xaxis.max, xaxis.min, xscale),
			//				ylate = getTranslation(!inverted, startLocation,
			//							yaxis.max, yaxis.min, yscale),
				yscale, ylate,
			fields = element.data("fields") || {},
				chartElements = fields.chartElements || {},
				aniBarsAttr = fields.aniBarsAttr,
			//bars = chartElements.bars,
			//animatedBars = chartElements.animatedBars,
			//chartLabels = chartElements.chartLabels,
				clusterInfos,
				isYTime = options.isYTime,
				isXTime = options.isXTime;



			function getMinDX(x) {
				var minDx = Number.MAX_VALUE,
					len = x.length,
					idx,
					dx;

				for (idx = 1; idx < len; idx++) {
					dx = x[idx].x - x[idx - 1].x;

					if (dx < minDx && dx > 0) {
						minDx = dx;
					}
				}

				if (minDx === Number.MAX_VALUE) {
					return 2;
				}

				return minDx;
			}

			function stackValues(x) {
				$.each(x, function (idx, xSpec) {
					xSpec.stackValues();
				});

				return x;
			}



			function barPointList(seriesList) {
				var x = [],
					getXSortedPoints = $.wijchart.getXSortedPoints;

				function addSeriesData(idx, series) {
					var points = getXSortedPoints(series),
						nSeries = series.length,
						xs = null,
						lim = 0,
						j = 0,
						jlim = 0,
						first_point = true,
						xprev = 0,
						dupl = false;

					if (points) {
						lim = points.length;
					}

					if (x) {
						jlim = x.length;
					}

					if (points === undefined) {
						return;
					}

					$.each(points, function (p, point) {
						if (first_point) {
							first_point = false;
							xprev = point.x;
						} else {
							if (xprev === point.x) {
								dupl = true;
							} else {
								dupl = false;
							}
							xprev = point.x;
						}

						while (j < jlim && x[j].x < point.x) {
							j++;
						}

						if (j < jlim) {
							// use or insert before the existing item
							if (x[j].x !== point.x) {
								xs = new XSpec(point.x, nSeries);
								x.splice(j, 0, xs);
								jlim = x.length;
							} else {
								xs = x[j];
							}
						} else {
							// add a new item
							xs = new XSpec(point.x, nSeries);
							x.push(xs);
							jlim = x.length;
						}

						xs.paSpec.push({ y: point.y, sIdx: idx, pIdx: p, dupl: dupl });
					});
				}

				$.each(seriesList, function (idx, series) {
					addSeriesData(idx, series);
				});

				return x;
			}

			function adjustToLimits(val, min, max) {
				if (val < min) {
					return min;
				}

				if (val > max) {
					return max;
				}

				return val;
			}

			function transformPoints(inverted, xscale, yscale, xlate, ylate, points) {
				$.each(points, function (idx, point) {
					var x = point.x,
						y = point.y,
						temp = 0;
					point.x = xscale * x + xlate;
					point.y = yscale * y + ylate;

					if (inverted) {
						temp = point.x;
						point.x = point.y;
						point.y = temp;
					}
				});

				return points;
			}

			function paintDefaultChartLabel(rf, y, isTime, seriesTextStyle) {
				var textStyle = $.extend(true, {},
						options.textStyle, options.chartLabelStyle),
					pos = inverted ? { x: rf.x + rf.width, y: rf.y + rf.height / 2} :
									{ x: rf.x + rf.width / 2, y: rf.y },
					chartLabelFormatString = options.chartLabelFormatString,
					dclBox,
					defaultChartLabel,
					text = y;

				if (seriesTextStyle) {
					textStyle = $.extend(true, textStyle, seriesTextStyle);
				}

				/*if (isTime) {
				text = $.wijchart.fromOADate(y);
				} else {
				text = $.wijchart.round(y, 2);
				}*/
				if (isTime) {
					text = $.fromOADate(y);
				}

				if (chartLabelFormatString && chartLabelFormatString.length) {
					//text = $.format(text, o.chartLabelFormatString);
					text = Globalize.format(text, options.chartLabelFormatString);
				} else if (!isTime) {
					text = $.round(text, 2);
				}

				defaultChartLabel = canvas.text(pos.x, pos.y, text)
					.attr(textStyle);
				addClass($(defaultChartLabel.node), "wijbarchart-label");
				dclBox = defaultChartLabel.getBBox();
				if (inverted) {
					defaultChartLabel.attr({ x: pos.x + dclBox.width / 2 });
				} else {
					defaultChartLabel.attr({ y: pos.y - dclBox.height / 2 });
				}

				return defaultChartLabel;
			}

			function paintBar(rp, y, height, xAxisInfo, yAxisInfo, seriesStyle,
					animated, shadowOffset, startLocation,
					clusterOverlap, preY, lastY, isYTime, seriesTextStyle, yaxis) {
				var is100Percent = options.is100Percent,
					xmin = xAxisInfo.min,
					xmax = xAxisInfo.max,
					ymin = yAxisInfo.min,
					ymax = yAxisInfo.max,
					xscale = xAxisInfo.scale,
					xlate = xAxisInfo.late,
					yscale = yAxisInfo.scale,
					ylate = yAxisInfo.late,
					hold,
					x,
					inPlotArea,
					rf,
					defaultChartLabel = null,
					r,
					style = seriesStyle,
					strokeWidth = seriesStyle["stroke-width"],
					stroke = seriesStyle.stroke,
					bar,
					barWidth,
					barHeight,
					animatedBar,
					start = -1;

				if (yaxis.origin !== null) {
					start = yscale * yaxis.origin + ylate;
				}

				if (stacked) {
					if (is100Percent) {
						if (lastY > 0) {
							rp.height = y / lastY;
						}

						if (preY || preY === 0) {
							rp.y = preY / lastY;
							rp.height -= rp.y;
						}
					} else {
						rp.height = y;

						if (preY || preY === 0) {
							rp.height -= preY;
							rp.y = preY;
						}
					}
				} else {
					if (preY || preY === 0) {
						// 1 bar over less overlap and 1 pixel
						rp.x += rp.width * (1 - clusterOverlap);
						rp.height = y;
					}
				}

				x = [{ x: rp.x, y: rp.y }, { x: rp.x + rp.width, y: rp.y + rp.height}];
				inPlotArea = ((xmin <= x[0].x && x[0].x <= xmax) ||
					(xmin <= x[1].x && x[1].x <= xmax)) &&
					((ymin <= x[0].y && x[0].y <= ymax) ||
					(ymin <= x[1].y && x[1].y <= ymax));

				x[0].x = adjustToLimits(x[0].x, xmin, xmax);
				x[0].y = adjustToLimits(x[0].y, ymin, ymax);
				x[1].x = adjustToLimits(x[1].x, xmin, xmax);
				x[1].y = adjustToLimits(x[1].y, ymin, ymax);

				x = transformPoints(inverted, xscale, yscale, xlate, ylate, x);

				if (x[0].x > x[1].x) {
					hold = x[0].x;
					x[0].x = x[1].x;
					x[1].x = hold;
				}

				if (x[0].y > x[1].y) {
					hold = x[0].y;
					x[0].y = x[1].y;
					x[1].y = hold;
				}

				rf = {
					x: x[0].x,
					y: x[0].y,
					width: x[1].x - x[0].x,
					height: x[1].y - x[0].y
				};

				if (inPlotArea) {
					if (rf.width === 0) {
						rf.width = 0.5;
					}

					if (rf.height === 0) {
						rf.height = 0.5;
					}
				}

				if (options.showChartLabels) {
					defaultChartLabel = paintDefaultChartLabel(rf, y,
						isYTime, seriesTextStyle);
				}

				r = seriesStyle.r ? seriesStyle.r : options.clusterRadius;

				if (r) {
					style = $.extend(true, {}, seriesStyle, {
						r: 0
					});
				}

				if (stroke !== "none" && strokeWidth) {
					strokeWidth = parseInt(strokeWidth, 10);
				}

				if (!strokeWidth || isNaN(strokeWidth)) {
					strokeWidth = 0;
				}

				barWidth = rf.width - strokeWidth;
				barHeight = rf.height - strokeWidth;

				if (barWidth < 0) {
					barWidth = 0;
				}
				if (barHeight < 0) {
					barHeight = 0;
				}

				if (animated) {
					if (start === -1) {
						if (inverted) {
							start = startLocation.x;
						} else {
							start = startLocation.y + height - strokeWidth;
						}
					}

					if (r) {
						if (inverted) {
							if (y > yaxis.origin) {
								bar = canvas.roundRect(rf.x, rf.y, barWidth,
											barHeight, 0, 0, r, r).hide();
							}
							else {
								bar = canvas.roundRect(rf.x, rf.y, barWidth,
											barHeight, r, r, 0, 0).hide();
							}
							animatedBar = canvas.rect(start, rf.y, 0,
											barHeight);
						} else {
							if (y > yaxis.origin) {
								bar = canvas.roundRect(rf.x, rf.y, barWidth,
											barHeight, r, 0, 0, r).hide();
							}
							else {
								bar = canvas.roundRect(rf.x, rf.y, barWidth,
											barHeight, 0, r, r, 0).hide();
							}

							animatedBar = canvas.rect(rf.x, start,
											rf.width, 0);
						}

						paintShadow(animatedBar, shadowOffset);
						animatedBar.wijAttr(style);
						animatedBar.bar = bar;
					} else {
						if (inverted) {
							bar = canvas.rect(start, rf.y,
										0, barHeight);
						} else {
							bar = canvas.rect(rf.x, start,
										rf.width, 0);
						}
						animatedBar = bar;
					}

					if (defaultChartLabel) {
						defaultChartLabel.attr({ opacity: 0 });
						animatedBar.chartLabel = defaultChartLabel;
					}

					animatedBar.left = rf.x;
					animatedBar.top = rf.y;
					animatedBar.width = barWidth;
					animatedBar.height = barHeight;
					animatedBar.r = r;
				} else {
					if (r) {
						if (inverted) {
							if (y > yaxis.origin) {
								bar = canvas.roundRect(rf.x, rf.y,
							barWidth, barHeight, 0, 0, r, r);
							}
							else {
								bar = canvas.roundRect(rf.x, rf.y,
							barWidth, barHeight, r, r, 0, 0);
							}
						}
						else {
							if (y > yaxis.origin) {
								bar = canvas.roundRect(rf.x, rf.y, barWidth,
											barHeight, r, 0, 0, r);
							}
							else {
								bar = canvas.roundRect(rf.x, rf.y, barWidth,
											barHeight, 0, r, r, 0);
							}
						}

					} else {
						bar = canvas.rect(rf.x, rf.y,
							barWidth, barHeight);
					}
				}

				paintShadow(bar, shadowOffset);
				if (animated && r) {
					if (bar.shadow) {
						bar.shadow.hide();
					}
				}
				bar.wijAttr(seriesStyle);

				return {
					rect: rf,
					dcl: defaultChartLabel,
					animatedBar: animatedBar,
					bar: bar
				};
			}

			function paintClusters(seriesList, seriesStyles, seriesHoverStyles,
					xAxisInfo, yAxisInfo, width, height, startLocation,
					isYTime, isXTime) {
				var clusterOverlap = options.clusterOverlap / 100,
					clusterWidth = options.clusterWidth / 100,
					shadowOffset = 1,
					clusterSpacing = options.clusterSpacing + shadowOffset,
					nSeries = seriesList.length,
					bpl,
					bw,
					chartLabels = [],
					bars = [],
					animatedBars = [],
					rects = [],
				//isYTime = yAxisInfo.isTime,
					sList = [],
					seriesEles = [],
					trackers = canvas.set();

				if (isYTime || isXTime) {
					$.each(seriesList, function (i, s) {
						var se = $.extend(true, {}, s);
						if (se.data && se.data.y && se.data.y.length && isYTime) {
							$.each(se.data.y, function (idx, data) {
								se.data.y[idx] = $.toOADate(data);
							});
						}
						if (se.data && se.data.x && se.data.x.length && isXTime) {
							$.each(se.data.x, function (idx, data) {
								se.data.x[idx] = $.toOADate(data);
							});
						}
						sList.push(se);
					});
					bpl = barPointList(sList);
				} else {
					bpl = barPointList(seriesList);
				}


				if (stacked) {
					bpl = stackValues(bpl);
				}

				bw = getMinDX(bpl) * clusterWidth;

				// adjust the bar width (bw) to account for overlap
				if (nSeries > 1 && !stacked) {
					clusterOverlap -= (bpl.length * (nSeries - 1) * clusterSpacing) /
						(inverted ? height : width);
					bw /= (nSeries * (1 - clusterOverlap) + clusterOverlap);
				}

				$.each(bpl, function (pIdx, xs) {
					var ps = xs.paSpec,
						ns = ps.length,
						sx,
						rp,
						bar,
						barInfo;

					if (stacked) {
						sx = bw;
					} else {
				