﻿<%
If request("BackUrl") =" " Then
    BackUrl = Trim(Request.ServerVariables("HTTP_REFERER"))
else
    BackUrl = Trim(request("BackUrl"))
End If

'**************************************************
'函数名：GetCaptcha
'作  用：检查验证码合法性
'作  者：王国强
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function GetCAPTCHA()
	Dim TestObj
	On Error Resume Next
	Set TestObj = Server.CreateObject("Adodb.Stream")
	Set TestObj = Nothing
	If Err Then
		Dim TempNum
		Randomize timer
		TempNum = cint(8999*Rnd+1000)
		Session("GetCAPTCHA") = TempNum
		GetCAPTCHA = session("GetCAPTCHA")		
	Else
		GetCAPTCHA = "<img src=""/include/captcha.asp"" id=""safecode"" border=""0"" onclick=""reloadcode()"" />"
	End If
End Function

'**************************************************
'函数名：IsValIDEmail
'作  者：王国强
'作  用：检查Email地址合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDEmail(strng) 
	IsValIDEmail = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDEmail= true 
End Function

'**************************************************
'函数名：IsValIDUserName
'作  者：王国强
'作  用：检查用户名的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDUserName(strng) 
	IsValIDUserName = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^[a-zA-Z][a-zA-Z0-9_]{3,15}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDUserName= true 
End Function

'**************************************************
'函数名：IsValIDPassword
'作  者：王国强
'作  用：检查密码的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDPassword(strng) 
	IsValIDPassword = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^[a-zA-Z0-9_]{4,15}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDPassword= true 
End Function

'**************************************************
'函数名：IsValIDURL
'作  者：王国强
'作  用：检查URL的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDURL(strng) 
	IsValIDURL = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^[a-zA-z]+://[\s\S]*$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDURL= true 
End Function

'**************************************************
'函数名：IsValIDPhone
'作  者：王国强
'作  用：检查电话的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDPhone(strng) 
	IsValIDPhone = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^((\(\d{3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDPhone= true 
End Function

'**************************************************
'函数名：IsValIDZip
'作  者：王国强
'作  用：检查邮政编码的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDZip(strng) 
	IsValIDZip = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^\d{6}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDZip= true 
End Function

'**************************************************
'函数名：IsValIDMobile
'作  者：王国强
'作  用：检查手机的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDMobile(strng) 
	IsValIDMobile = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^1[3|5|8]\d{9}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDMobile= true 
End Function

'**************************************************
'函数名：IsValIDInteger
'作  者：王国强
'作  用：检查是否为正整数
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDInteger(strng) 
	IsValIDInteger = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^[0-9]*[1-9][0-9]*$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDInteger= true 
End Function

'**************************************************
'函数名：IsValIDData
'作  者：王国强
'作  用：检查是否为日期0000-00-00
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDData(strng) 
	IsValIDData = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^((19\d{2})|2\d{3})-((0\d{1})|(\d{1})|(1[0-2]{1}))-(([0-2]\d{1})|30|31)$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDData= true 
End Function

'**************************************************
'函数名：IsValIDPrice
'作  者：王国强
'作  用：价格的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDPrice(strng) 
	IsValIDPrice = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^(\d|([1-9]\d{1,}))(\.\d{1,3}){0,1}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDPrice= true 
End Function

'**************************************************
'函数名：IsBadWords
'作  者：王国强
'作  用：不良字符过滤
'**************************************************
Function IsBadWords(fString)  
iBadWords = BadWords  
If Not(IsNull(iBadWords) or IsNull(fString)) Then  
	strng = Split(iBadWords, "|")  
	For i = 0 to UBound(strng)  
	fString = Replace(fString, strng(i), string(Len(strng(i)),"*"))  
	Next  
	IsBadWords = fString  
End If  
End Function 

'**************************************************
'函数名：IsObjInstalled
'作  用：检查组件是否已经安装
'参  数：strClassString ----组件名
'返回值：True  ----已经安装
'       False ----没有安装
'**************************************************
Function IsObjInstalled(ByVal strClassString)
	Dim xTestObj,ClsString
	On Error Resume Next
	IsObjInstalled = False
	ClsString = strClassString
	Err = 0
	Set xTestObj = Server.CreateObject(ClsString)
	If Err = 0 Then IsObjInstalled = True
	If Err = -2147352567 Then IsObjInstalled = True
	Set xTestObj = Nothing
	Err = 0
	Exit Function
End Function

'********************************
'返回当前页的完整URL(带参数)
'********************************
Function getCurrentPageURL()
	dim strReturnPage,strQuery,thing
	strReturnPage="http://" & Request.ServerVariables("HTTP_HOST") & Request.ServerVariables("SCRIPT_NAME")
	strQuery=""
	for each thing in Request.QueryString
	    if  thing<>"Page" then
	   		if strQuery="" then
	   			strQuery=thing & "=" & Request.QueryString(thing) 
	   		else
	   			strQuery=strQuery & "&" & thing & "=" & Request.QueryString(thing) 
	   		end if
	    end if
	next
	if strQuery="" then
		getCurrentPageURL=strReturnPage
	else
		getCurrentPageURL=strReturnPage & "?" & strQuery
	end if
end Function

'**************************************************
'函数名：strCLng
'作  用：将字符转为整型数值 
'**************************************************
Function strCLng(ByVal str)
    If IsNumeric(str) Then
        strCLng = Fix(CDbl(str))
    Else
        strCLng = 0
    End If
End Function

'**************************************************
'函数名：strleach
'作  用：过滤非法字符函数 
'**************************************************
function strLeach(str)'
	dim tempstr 
	if str="" then exit function 
	tempstr=replace(str,chr(34),"")' " 
	tempstr=replace(tempstr,chr(39),"")' ' 
	tempstr=replace(tempstr,chr(60),"")' < 
	tempstr=replace(tempstr,chr(62),"")' > 
	tempstr=replace(tempstr,chr(37),"")' % 
	tempstr=replace(tempstr,chr(38),"")' & 
	tempstr=replace(tempstr,chr(40),"")' ( 
	tempstr=replace(tempstr,chr(41),"")' ) 
	tempstr=replace(tempstr,chr(59),"")' ; 
	tempstr=replace(tempstr,chr(43),"")' + 
	tempstr=replace(tempstr,chr(45),"")' - 
	tempstr=replace(tempstr,chr(91),"")' [ 
	tempstr=replace(tempstr,chr(93),"")' ] 
	tempstr=replace(tempstr,chr(123),"")' { 
	tempstr=replace(tempstr,chr(125),"")' } 
	strleach=tempstr 
end function 

'**************************************************
'函数名：strLength
'作  用：求字符串长度。汉字算两个字符，英文算一个字符。
'参  数：str  ----要求长度的字符串
'返回值：字符串长度
'**************************************************
function strLength(str)
	ON ERROR RESUME NEXT
	dim WINNT_CHINESE
	WINNT_CHINESE    = (len("中国")=2)
	if WINNT_CHINESE then
        dim l,t,c
        dim i
        l=len(str)
        t=l
        for i=1 to l
        	c=asc(mID(str,i,1))
            if c<0 then c=c+65536
            if c>255 then
                t=t+1
            end if
        next
        strLength=t
    else 
        strLength=len(str)
    end if
    if err.number<>0 then err.clear
end function

'**************************************************
'函数名：GetIsAdmin
'作  用：检查后台用户是否登录
'参  数：无
'返回值：True ----已经登录
'        False ---没有登录
'**************************************************
function GetIsAdmin()
	Logined=True
	strUserName=session("strUserName")
	strPassword=session("strPassword")
	strInherited=session("strInherited")

	if strUserName="" then
		Logined=False
	end if
	if strPassword="" then
		Logined=False
	end if
	if strInherited="" then
		Logined=False
	end if

	if Logined=True then
		strUserName=replace(trim(strUserName),"'","")
		strPassword=replace(trim(strPassword),"'","")
		strInherited=cint(trim(strInherited))

		set txtRs = server.createobject("adodb.recordset")
		sql="select * from db_system where UserName='" & strUserName & "' and password='" & strPassword &"' and Inherited=" & strInherited &""
		'response.write sql
		'response.End
		txtRs.open sql,conn,1,1
		if txtRs.bof and txtRs.eof then
			Logined=False
		else
			if strUserName<>txtRs("UserName") or strPassword<>txtRs("password") then
				Logined=False
			end if
		end if
		txtRs.close
		set txtRs=nothing
	end if
	GetIsAdmin=Logined
end function

'**************************************************
'函数名：GetUserLogined
'作  用：检查用户是否登录
'参  数：无
'返回值：True ----已经登录
'        False ---没有登录
'**************************************************
function GetUserLogined()
	Logined=True
	email=Request.Cookies("isCookies")("email")
	password=Request.Cookies("isCookies")("password")
	ghid=Request.Cookies("isCookies")("ghid")
	
	if email="" then
		Logined=False
	end if
	
	if password="" then
		Logined=False
	end if
	
	if ghid="" then
		Logined=False
	end if
	if Logined=True then
		email=replace(trim(email),"'","")
		password=replace(trim(password),"'","")
		ghid=cint(trim(ghid))
		
		set strRS=server.createobject("adodb.recordset")
		SQL="select * from db_passport where email='" & email & "' and password='" & password &"'"
		'response.write sql
		'response.End
		strRS.open SQL,conn,1,1
		if strRS.bof and strRS.eof then
			Logined=False
		else
			if password<>strRS("password") or ghid<>strRS("ghid") then
				Logined=False
			end if
		end if
		strRS.close
		set strRS=nothing
	end if
	GetUserLogined=Logined
end function

'****************************************************
'过程名：ErrMsg
'作  用：显示错误提示信息
'参  数：无
'****************************************************
sub ErrMsg(Message)
	dim strErr
	strErr=strErr & "<html><head><title>提示信息</title><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>" & vbcrlf
	strErr=strErr & "<style type='text/css'>" & vbcrlf
	strErr=strErr & "<!--" & vbcrlf
	strErr=strErr & "body {font:12.8px Arial, Helvetica, sans-serif;margin-top: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;COLOR: #6e6e6e;}td {font: 12px/1.6em Tahoma,Verdana;line-height: 18.8px;}A:link {COLOR: #000000; TEXT-DECORATION: none}A:active {COLOR: #000000;TEXT-DECORATION: underline}A:visited {COLOR: #000000; TEXT-DECORATION: none}A:hover {COLOR: #000000;TEXT-DECORATION: underline}" & vbcrlf
	strErr=strErr & "-->" & vbcrlf
	strErr=strErr & "</style>" & vbcrlf
	strErr=strErr & "</head><body><br><br>" & vbcrlf
	strErr=strErr & "<table width=""50%"" border=""0"" cellpadding=""5"" cellspacing=""1"" bgcolor=""cad9ea"" align=""center"">" & vbcrlf
	strErr=strErr & "<tr>" & vbcrlf
	strErr=strErr & "<td bgcolor=""e8f3fd"">提示信息</td>" & vbcrlf
	strErr=strErr & "</tr>" & vbcrlf
	strErr=strErr & "<tr>" & vbcrlf
	strErr=strErr & "<td bgcolor=""#FFFFFF"">" & Message &"" & vbcrlf
	strErr=strErr & "<br>" & vbcrlf
	strErr=strErr & "<a href=""javascript:history.back(1)"">点击这里返回</a>" & vbcrlf
	strErr=strErr & "</td>" & vbcrlf
	strErr=strErr & "</tr>" & vbcrlf
	strErr=strErr & "</table>" & vbcrlf
	strErr=strErr &  vbCrlf
	strErr=strErr & "</body></html>" & vbcrlf
	response.write strErr
end sub

'****************************************************
'过程名：performMsg
'作  用：显示成功提示信息
'参  数：无
'****************************************************
Sub performMsg(Perform, BackUrl)
    Dim strPerform
	strPerform=strPerform & "<html><head><title>提示信息</title><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>" & vbcrlf
	strPerform=strPerform & "<style type='text/css'>" & vbcrlf
	strPerform=strPerform & "<!--" & vbcrlf
	strPerform=strPerform & "body {font:12.8px Arial, Helvetica, sans-serif;margin-top: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;COLOR: #6e6e6e;}td {font: 12px/1.6em Tahoma,Verdana;line-height: 18.8px;}A:link {COLOR: #000000; TEXT-DECORATION: none}A:active {COLOR: #000000;TEXT-DECORATION: underline}A:visited {COLOR: #000000; TEXT-DECORATION: none}A:hover {COLOR: #000000;TEXT-DECORATION: underline}" & vbcrlf
	strPerform=strPerform & "-->" & vbcrlf
	strPerform=strPerform & "</style>" & vbcrlf
	strPerform=strPerform & "</head><body><br><br>" & vbcrlf
	strPerform=strPerform & "<table width=""50%"" border=""0"" cellpadding=""5"" cellspacing=""1"" bgcolor=""cad9ea"" align=""center"">" & vbcrlf
	strPerform=strPerform & "<tr>" & vbcrlf
	strPerform=strPerform & "<td bgcolor=""e8f3fd"">提示信息</td>" & vbcrlf
	strPerform=strPerform & "</tr>" & vbcrlf
	strPerform=strPerform & "<tr>" & vbcrlf
	strPerform=strPerform & "<td bgcolor=""#FFFFFF"">" & Perform &"" & vbcrlf
	strPerform=strPerform & "<br>" & vbcrlf
    If BackUrl <> "" Then
	strPerform = strPerform & "<a href='" & BackUrl & "'>点击这里返回</a>"
    Else
	strPerform = strPerform & "<a href='" & Trim(Request.ServerVariables("HTTP_REFERER")) & "'>点击这里返回</a>"
    End If
	strPerform=strPerform & "</td>" & vbcrlf
	strPerform=strPerform & "</tr>" & vbcrlf
	strPerform=strPerform & "</table>" & vbcrlf
	strPerform=strPerform & "</body></html>" & vbcrlf
	response.write strPerform
end Sub

'**************************************************
'函数名：GetFormatDate
'作  者：王国强
'作  用：日期格式化
'**************************************************
Public Function GetFormatDate(DateAndTime, para)
	On Error Resume Next
	Dim y, m, d, h, mi, s, strDateTime
	GetFormatDate = DateAndTime
	If Not IsNumeric(para) Then Exit Function
	If Not IsDate(DateAndTime) Then Exit Function
	y = CStr(Year(DateAndTime))
	m = CStr(Month(DateAndTime))
	If Len(m) = 1 Then m = "0" & m
	d = CStr(Day(DateAndTime))
	If Len(d) = 1 Then d = "0" & d
	h = CStr(Hour(DateAndTime))
	If Len(h) = 1 Then h = "0" & h
	mi = CStr(Minute(DateAndTime))
	If Len(mi) = 1 Then mi = "0" & mi
	s = CStr(Second(DateAndTime))
	If Len(s) = 1 Then s = "0" & s
	Select Case para
	Case "1"
    '显示格式：09年07月06日 13:44 
    strDateTime = y & "-" & m & "-" & d & " " & h & ":" & mi & ":" & s
     Case "2"
    '显示格式：2009-07-06
    strDateTime = y & "-" & m & "-" & d
     Case "3"
    '显示格式：2009/07/06
    strDateTime = y & "/" & m & "/" & d
     Case "4"
    '显示格式：2009年07月06日
    strDateTime = y & "年" & m & "月" & d & "日"
     Case "5"
    '显示格式：07-06 13:45
    strDateTime = m & "-" & d & " " & h & ":" & mi
     Case "6"
    '显示格式：07/06
    strDateTime = m & "/" & d
     Case "7"
    '显示格式：07月06日
    strDateTime = m & "月" & d & "日"
     Case "8"
    '显示格式：2009年07月
    strDateTime = y & "年" & m & "月"
	Case "9"
    '显示格式：2009-07
    strDateTime = y & "-" & m
	Case "10"
    '显示格式：2009/07
    strDateTime = y & "/" & m
	Case "11"
	'显示格式：09年07月06日 13:45
    strDateTime = right(y,2) & "年" &m & "月" & d & "日 " & h & ":" & mi
	Case "12"
    '显示格式：09-07-06
    strDateTime = right(y,2) & "-" &m & "-" & d
	Case "13"
    '显示格式：07-06
    strDateTime = m & "-" & d
	Case "14"
    '显示格式：13:45
    strDateTime = h & ":" & mi
	Case Else
    strDateTime = DateAndTime
	End Select
	GetFormatDate = strDateTime
End Function

'********************************
'字符串加密类
'********************************
const BASE_64_MAP_INIT = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/" 
dim newline 
dim Base64EncMap(63) 
dim Base64DecMap(127) 
'初始化函数 
PUBLIC SUB initCodecs() 
	' 初始化变量 
	newline = "<P>" & chr(13) & chr(10) 
	dim max, IDx 
	max = len(BASE_64_MAP_INIT) 
	for IDx = 0 to max - 1 
	Base64EncMap(IDx) = mID(BASE_64_MAP_INIT, IDx + 1, 1) 
	next 
	for IDx = 0 to max - 1 
	Base64DecMap(ASC(Base64EncMap(IDx))) = IDx 
	next 
END SUB

'Base64加密函数 
PUBLIC FUNCTION base64Encode(plain) 
	if len(plain) = 0 then 
	base64Encode = "" 
	exit function 
	end if 
	dim ret, ndx, by3, first, second, third 
	by3 = (len(plain) \ 3) * 3 
	ndx = 1 
	do while ndx <= by3 
	first = asc(mID(plain, ndx+0, 1)) 
	second = asc(mID(plain, ndx+1, 1)) 
	third = asc(mID(plain, ndx+2, 1)) 
	ret = ret & Base64EncMap( (first \ 4) AND 63 ) 
	ret = ret & Base64EncMap( ((first * 16) AND 48) + ((second \ 16) AND 15 ) ) 
	ret = ret & Base64EncMap( ((second * 4) AND 60) + ((third \ 64) AND 3 ) ) 
	ret = ret & Base64EncMap( third AND 63) 
	ndx = ndx + 3 
	loop 
	if by3 < len(plain) then 
	first = asc(mID(plain, ndx+0, 1)) 
	ret = ret & Base64EncMap( (first \ 4) AND 63 ) 
	if (len(plain) MOD 3 ) = 2 then 
	second = asc(mID(plain, ndx+1, 1)) 
	ret = ret & Base64EncMap( ((first * 16) AND 48) + ((second \ 16) AND 15 ) ) 
	ret = ret & Base64EncMap( ((second * 4) AND 60) ) 
	else 
	ret = ret & Base64EncMap( (first * 16) AND 48) 
	ret = ret '& "=" 
	end if 
	ret = ret '& "=" 
	end if 
	base64Encode = ret 
END FUNCTION 

'Base64解密函数 
PUBLIC FUNCTION base64Decode(scrambled) 
	if len(scrambled) = 0 then 
	base64Decode = "" 
	exit function 
	end if 
	dim realLen 
	realLen = len(scrambled) 
	do while mID(scrambled, realLen, 1) = "=" 
	realLen = realLen - 1 
	loop 
	dim ret, ndx, by4, first, second, third, fourth 
	ret = "" 
	by4 = (realLen \ 4) * 4 
	ndx = 1 
	do while ndx <= by4 
	first = Base64DecMap(asc(mID(scrambled, ndx+0, 1))) 
	second = Base64DecMap(asc(mID(scrambled, ndx+1, 1))) 
	third = Base64DecMap(asc(mID(scrambled, ndx+2, 1))) 
	fourth = Base64DecMap(asc(mID(scrambled, ndx+3, 1))) 
	ret = ret & chr( ((first * 4) AND 255) + ((second \ 16) AND 3)) 
	ret = ret & chr( ((second * 16) AND 255) + ((third \ 4) AND 15)) 
	ret = ret & chr( ((third * 64) AND 255) + (fourth AND 63)) 
	ndx = ndx + 4 
	loop 
	if ndx < realLen then 
	first = Base64DecMap(asc(mID(scrambled, ndx+0, 1))) 
	second = Base64DecMap(asc(mID(scrambled, ndx+1, 1))) 
	ret = ret & chr( ((first * 4) AND 255) + ((second \ 16) AND 3)) 
	if realLen MOD 4 = 3 then 
	third = Base64DecMap(asc(mID(scrambled,ndx+2,1))) 
	ret = ret & chr( ((second * 16) AND 255) + ((third \ 4) AND 15)) 
	end if 
	end if 
	base64Decode = ret 
END FUNCTION

'****************************************************
'函数名：SendMail
'作  用：用Jmail组件发送邮件
'参  数：MailtoAddress  ----收信人地址
'        MailtoName    -----收信人姓名
'        Subject       -----主题
'        MailBody      -----信件内容
'        FromName      -----发信人姓名
'        MailFrom      -----发信人地址
'        Priority      -----信件优先级
'****************************************************
function SendMail(MailtoAddress,MailtoName,Subject,MailBody,FromName,MailFrom,Priority)
	on error resume next
	Dim JMail
	Set JMail=Server.CreateObject("JMail.Message")
	if err then
		SendMail= "<li>没有安装JMail组件</li>"
		err.clear
		exit function
	end if
	JMail.Charset="utf-8"          '邮件编码
	JMail.silent=true
	JMail.ContentType = "text/html"     '邮件正文格式
	'JMail.ServerAddress=MailServer     '用来发送邮件的SMTP服务器
   	'如果服务器需要SMTP身份验证则还需指定以下参数
	JMail.MailServerUserName = MailServerUserName    '登录用户名
   	JMail.MailServerPassWord = MailServerPassword        '登录密码
  	JMail.MailDomain = MailDomain       '域名（如果用“name@domain.com”这样的用户名登录时，请指明domain.com
	JMail.AddRecipient MailtoAddress,MailtoName     '收信人
	JMail.Subject=Subject         '主题
	JMail.HMTLBody=MailBody       '邮件正文（HTML格式）
	JMail.Body=MailBody          '邮件正文（纯文本格式）
	JMail.FromName=FromName         '发信人姓名
	JMail.From = MailFrom         '发信人Email
	JMail.Priority=Priority              '邮件等级，1为加急，3为普通，5为低级
	JMail.Send(MailServer)
	SendMail =JMail.ErrorMessage
	JMail.Close
	Set JMail=nothing
end function

'********************************
'函数名：getSplit
'按换行符分隔
'********************************
function getSplit(text)
	dim textsplit
	text=replace(text,chr(13),"")
	textsplit=split(text,chr(10))
	text=""
	for i=0 to ubound(textsplit)
		if not isnull(textsplit(i)) and textsplit(i)<>"" then
			text=text&trim(textsplit(i))&"$$"
		end if
	next
	text=left(text,len(text)-2)
	textsplit=split(text,"$$")
	getSplit=textsplit
end function

'********************************
'函数名：getZone
'权限组
'********************************
Private Function getZone(text,i)
Dim txt
txt = text
	if not isNull(txt) or txt <> "" then
	txt = mid(txt, i+(i-1), 1)
		if txt = "1" then
			getZone = False'表示通过验证
		else
			getZone = True '表示没通过
		end if
	else
		getZone = True '表示没通过
	end if
End Function

'********************************
'函数名：getSixNumber
'生成随机数字ID
'********************************
function getSixNumber(digits)
	dim rndnum,num
	Randomize
	Do while Len(rndnum)<digits
	num = Cstr(Chr((57-48)*rnd+48))
	rndnum = rndnum & num
	Loop
	getSixNumber = rndnum
End function

'****************************************************
'函数名：GetIsFolder
'作  用：判断目录是否存在
'****************************************************
Function GetIsFolder(str)
	dim fso
	Set fso = CreateObject("Scripting.FileSystemObject")
	If fso.FolderExists(Server.MapPath(str)) then
		GetIsFolder = True
	Else
		GetIsFolder = False
	End if
	Set fso = nothing
End Function

'****************************************************
'函数名：GetCreateFolder
'作  用：创建目录
'****************************************************
Function GetCreateFolder(str)
	dim fso,f
	Set fso = Server.CreateObject("Scripting.FileSystemObject")
    Set f = fso.CreateFolder(Server.MapPath(str))
    GetCreateFolder = True
 Set fso = nothing
End Function

'****************************************************
'函数名：GetIsFile
'作  用：测试某一文件是否存在
'****************************************************
Public Function GetIsFile(ByVal str)
	GetIsFile=False
	Set fso = CreateObject("Scripting.FileSystemObject")
	If fso.FileExists(Server.MapPath(str)) Then
		GetIsFile=True
	End If
	Set fso = Nothing
End Function

'****************************************************
'函数名：GetFormatFileSize
'作  用：格式化文件大小
'****************************************************
Function GetFormatFileSize(FileSize)
	If FileSize<1024 then GetFormatFileSize = FileSize & " Byte"
		If FileSize/1024 <1024 And FileSize/1024 > 1 then 
			FileSize = FileSize/1024
            GetFormatFileSize=round(FileSize*100)/100 & " KB"
        Elseif FileSize/(1024*1024) > 1 Then
            FileSize = FileSize/(1024*1024)
            GetFormatFileSize = round(FileSize*100)/100 & " MB"
	End If
End function

'****************************************************
'函数名：GetCopyFile
'作  用：文件复制
'****************************************************
Function GetCopyFile(SourceFile,DestinationFile)
	Set fso = CreateObject("Scripting.FileSystemObject")
	If GetIsFile(SourceFile) = True Then
		Set f = fso.GetFile(Server.MapPath(SourceFile))
		f.Copy (Server.MapPath(DestinationFile))
		GetCopyFile = 1
	Else
		GetCopyFile = -1
	End if
	Set fso = Nothing
End Function

'****************************************************
'函数名：GetFileDel
'作  用：删除文件
'****************************************************
Sub GetFileDel(str)
	On Error Resume Next
	Dim FSO
	Set FSO = Server.CreateObject("Scripting.FileSystemObject")
	FSO.DeleteFile(Server.MapPath(str))
	Set FSO = Nothing
End Sub

'****************************************************
'函数名：GetFileSize
'作  用：取得文件的大小
'****************************************************
Function GetFileSize(str)
	Set fso = CreateObject("Scripting.FileSystemObject")
	If GetIsFile(str) = True Then
		Set f = fso.Getfile(Server.MapPath(str))
		GetFileSize = f.Size
	Else
		GetFileSize = 0
	End if
	Set fso = Nothing
End Function 

'****************************************************
'函数名：GetFileExt
'作  用：获得文件扩展名
'****************************************************
Function GetFileExt(str)
	GetFileExt = MID(str,InstrRev(str,".")+1)
End Function

'********************************
'过程名：过滤目录名
'参  数：无
'********************************
function GeLeach(fString,str)
	if isnull(fString) or trim(fString)="" then
		GeLeach=""
		exit function
	end if
	if str=1 then
	fString = replace(fString, ".", "_")
    fString = replace(fString, ";", "_")
    end if
	fString = replace(fString, "..", "_")
    fString = replace(fString, "//", "_")
    fString = replace(fString, ";", "_")
    fString = replace(fString, ":", "_")
    GeLeach = fString
end function

'****************************************************
'函数名：GetFormatFolder
'作  用：格式化目录名称
'****************************************************
Function GetFormatFolder(str)
	if isnull(str) or trim(str)="" then
		GetFormatFolder=""
		exit function
	end if
	if left(str, 1) <> "/" Then str = "/"& str
	if right(str, 1) <> "/" Then str = str & "/"
	str = replace(str, "//", "/")
	GetFormatFolder=str
End Function 

'****************************************************
'函数名：格式化文件大小
'作  用：GetFormatSize
'****************************************************
sub GetFormatSize(itemsize)
	Response.Write "<td>" &vbCrLf
	Select case Len(itemsize)
	Case "1", "2", "3" 
		Response.Write itemsize & " bytes"
	Case "4", "5", "6"
		Response.Write Round(itemsize/1000) & " kb"
	Case "7", "8", "9"
		Response.Write Round(itemsize/1000000) & " mb"
	End Select
	Response.Write "</td>" &vbCrLf
end Sub

'****************************************************
'过程名：GetFileName
'作  用：生成文件名
'参  数：无
'****************************************************
function GetFileName() 
	dim rannum 
	dim dtnow 
	dtnow=now() 
	randomize 
	rannum=int(90*rnd)+10 
	GetFileName=year(dtnow) &"_"& right("0" & month(dtnow),2) &"_"& right("0" & day(dtnow),2) &"_"& right("0" & hour(dtnow),2) & right("0" & minute(dtnow),2) & right("0" & second(dtnow),2) & rannum 
end function

'****************************************************
'函数名：GetFileMove
'作  用：移动文件或文件夹
'****************************************************
Function GetFileMove(SourceFile,DestinationFile,oType) 
	SourceFile = Server.MapPath(SourceFile) 
	DestinationFile = Server.MapPath(DestinationFile) 
	Set fso = CreateObject("Scripting.FileSystemObject")
	if oType=0 then
		if not fso.fileExists(SourceFile) then exit function 'IF文件不存在，退出
		fso.MoveFile SourceFile,DestinationFile
	else
		if not fso.folderExists(SourceFile) then exit function 'IF文件夹不存在，退出
		fso.MoveFolder SourceFile,DestinationFile
	end if
	Set fso = Nothing 
End Function

'****************************************************
'函数名：GetIP
'作  用：将IP地址最后一位换成*
'****************************************************
Function GetIP(TempVar)
	Dim arrip,IP 
	arrIP=TempVar
	arrIP=split(arrip,".") 
	IP=arrIP(0)&"."&arrIP(1)&"."&arrIP(2)&".*" 
	response.write IP 
End Function

'**************************************************
'信息无限分类
'**************************************************
sub OptionChannel(ShowType,CurrentID)
	if ShowType=0 then
	    response.write "<option value='0'"
		if CurrentID=0 then response.write " selected"
		response.write ">无（作为一级栏目）</option>"
	end if

	dim arrShowLine(20)
	for i=0 to ubound(arrShowLine)
		arrShowLine(i)=False
	next
	sql="Select * From db_channel order by RootID,OrderID"
	set doRs=conn.execute(sql)
	if doRs.bof and doRs.eof then
		response.write "<option value=''>请先添加栏目</option>"
	else
		do while not doRs.eof
			tmpDepth=doRs("Depth")
			if doRs("NextID")>0 then
				arrShowLine(tmpDepth)=True
			else
				arrShowLine(tmpDepth)=False
			end if
				strTemp="<option value='" & doRs("pageID") & "'"
			if CurrentID>0 and doRs("pageID")=CurrentID then
				 strTemp=strTemp & " selected"
			end if
			strTemp=strTemp & ">"
			
			if tmpDepth>0 then
				for i=1 to tmpDepth
					strTemp=strTemp & "&nbsp;&nbsp;"
					if i=tmpDepth then
						if doRs("NextID")>0 then
							strTemp=strTemp & "├&nbsp;"
						else
							strTemp=strTemp & "└&nbsp;"
						end if
					else
						if arrShowLine(i)=True then
							strTemp=strTemp & "│"
						else
							strTemp=strTemp & "&nbsp;"
						end if
					end if
				next
			end if
			strTemp=strTemp & doRs("pageName")
			strTemp=strTemp & "</option>"
			response.write strTemp
			doRs.movenext
		loop
	end if
	doRs.close
	set doRs=nothing
end sub

'****************************************************
'函数名：Getkind
'作  用：信息属性
'****************************************************
Public Sub Getkind(kind)
	Dim tmpstr
	tmpstr = "<select name='kind'><option value='0'>无</option><option value='1'>推荐</option></select>"
	response.Write (tmpstr)
if kind<>"" then
%>
<SCRIPT language=javascript>
    var GetkindObject = document.thisform["kind"];
    for(var i = 0; i < document.thisform["kind"].options.length; i++) {
        if (document.thisform["kind"].options[i].value=="<%=trim(kind)%>")
        {
            document.thisform["kind"].selectedIndex = i;
        }
    }
</SCRIPT>
<%
end if
End Sub

'****************************************************
'函数名：GetTransfer
'作  用：是否显示
'****************************************************
Public Sub GetTransfer(Transfer)
	Dim tmpstr
	tmpstr = "<select name='Transfer'><option value='0'>显示</option><option value='1'>不显示</option></select>"
	response.Write (tmpstr)
if Transfer<>"" then
%>
<SCRIPT language=javascript>
    var GetTransferObject = document.thisform["Transfer"];
    for(var i = 0; i < document.thisform["Transfer"].options.length; i++) {
        if (document.thisform["Transfer"].options[i].value=="<%=trim(Transfer)%>")
        {
            document.thisform["Transfer"].selectedIndex = i;
        }
    }
</SCRIPT>
<%
end if
End Sub

'****************************************************
'函数名：IsTransfer
'作  用：显示是否显示
'****************************************************
sub IsTransfer(TempVar)
	select case TempVar
		case 0
			Response.write "显示"
		case 1
			Response.Write "不显示"
	end select
end sub

'****************************************************
'函数名：GetPageMode
'作  用：页面模式
'****************************************************
Public Sub GetPageMode(PageMode)
	Dim tmpstr
	tmpstr = "<select name='PageMode'><option value='0'>单页模式</option><option value='1'>信息模式</option><option value='2'>产品模式</option><option value='3'>下载模式</option><option value='4'>单页索引</option><option value='5'>友情链接</option></select>"
	response.Write (tmpstr)
if PageMode<>"" then
%>
<SCRIPT language=javascript>
    var GetPageModeObject = document.thisform["PageMode"];
    for(var i = 0; i < document.thisform["PageMode"].options.length; i++) {
        if (document.thisform["PageMode"].options[i].value=="<%=trim(PageMode)%>")
        {
            document.thisform["PageMode"].selectedIndex = i;
        }
    }
</SCRIPT>
<%
end if
End Sub

'****************************************************
'函数名：IsPageMode
'作  用：显示页面模式
'****************************************************
sub IsPageMode(TempVar)
	select case TempVar
		case 0
			Response.write "单页模式"
		case 1
			Response.Write "信息模式"
		case 2
			Response.Write "产品模式"
		case 3
			Response.Write "下载模式"
		case 4
			Response.Write "单页索引"
		case 5
			Response.Write "链接模式"
	end select
end sub

'****************************************************
'函数名：GetWhether
'作  用：是否
'****************************************************
Public Sub GetWhether(Whether)
	Dim tmpstr
	tmpstr = "<select name='Whether'><option value='0'>否</option><option value='1'>是</option></select>"
	response.Write (tmpstr)
if Whether<>"" then
%>
<SCRIPT language=javascript>
    var GetWhetherObject = document.thisform["Whether"];
    for(var i = 0; i < document.thisform["Whether"].options.length; i++) {
        if (document.thisform["Whether"].options[i].value=="<%=trim(Whether)%>")
        {
            document.thisform["Whether"].selectedIndex = i;
        }
    }
</SCRIPT>
<%
end if
End Sub

'****************************************************
'函数名：Getinherited
'作  用：权限继承
'****************************************************
Public Sub Getinherited(inherited)
	Dim tmpstr
	tmpstr = "<select name='inherited'><option value='0'>否</option><option value='1'>是</option></select>"
	response.Write (tmpstr)
if inherited<>"" then
%>
<SCRIPT language=javascript>
    var GetinheritedObject = document.thisform["inherited"];
    for(var i = 0; i < document.thisform["inherited"].options.length; i++) {
        if (document.thisform["inherited"].options[i].value=="<%=trim(inherited)%>")
        {
            document.thisform["inherited"].selectedIndex = i;
        }
    }
</SCRIPT>
<%
end if
End Sub

'****************************************************
'函数名：Getlocked
'作  用：锁定
'****************************************************
Public Sub Getlocked(locked)
	Dim tmpstr
	tmpstr = "<select name='locked'><option value='0'>否</option><option value='1'>是</option></select>"
	response.Write (tmpstr)
if locked<>"" then
%>
<SCRIPT language=javascript>
    var GetlockedObject = document.thisform["locked"];
    for(var i = 0; i < document.thisform["locked"].options.length; i++) {
        if (document.thisform["locked"].options[i].value=="<%=trim(locked)%>")
        {
            document.thisform["locked"].selectedIndex = i;
        }
    }
</SCRIPT>
<%
end if
End Sub

'****************************************************
'函数名：IsLocked
'作  用：显示锁定
'****************************************************
sub IsLocked(TempVar)
	select case TempVar
		case 0
			Response.write "否"
		case 1
			Response.Write "是"
	end select
end sub

'****************************************************
'函数名：SelPlay
'作  用：自动识别媒体
'****************************************************
Sub SelPlay(strUrl,strWIDth,StrHeight)
Dim Exts,isExt
If strUrl <> "" Then
	isExt = LCase(MID(strUrl,InStrRev(strUrl, ".")+1))
Else
	isExt = ""
End If

If strWidth="" then strWidth=512
If StrHeight="" then StrHeight=384

Exts = "avi,wmv,asf,mov,rm,ra,ram,mpg,mpeg,swf,flv,gif,jpg,png"
If Instr(Exts,isExt)=0 Then
	Response.write "非法文件"
Else
Select Case isExt
	Case "avi","wmv","asf","mov","mpg","mpeg"
		Response.write "<embed pluginspage='http://www.microsoft.com/Windows/Downloads/Contents/MediaPlayer/' src="&strUrl&" wIDth="&strWIDth&" height="&strHeight&" type='application/x-mplayer2' filename="&strUrl&" autostart='true' showcontrols='true' showstatusbar='false' showdisplay='false' autorewind='true' />"
	Case "mov","rm","ra","ram"
		Response.Write "<OBJECT height="&strHeight&" wIDth="&strWIDth&" classID=clsID:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA>"
		Response.Write "<PARAM NAME=""_ExtentX"" VALUE=""12700"">"
		Response.Write "<PARAM NAME=""_ExtentY"" VALUE=""9525"">"
		Response.Write "<PARAM NAME=""AUTOSTART"" VALUE=""-1"">"
		Response.Write "<PARAM NAME=""SHUFFLE"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""PREFETCH"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""NOLABELS"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""SRC"" VALUE="""&strUrl&""">"
		Response.Write "<PARAM NAME=""CONTROLS"" VALUE=""ImageWindow"">"
		Response.Write "<PARAM NAME=""CONSOLE"" VALUE=""Clip"">"
		Response.Write "<PARAM NAME=""LOOP"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""NUMLOOP"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""CENTER"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""MAINTAINASPECT"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""BACKGROUNDCOLOR"" VALUE=""#000000"">"
		Response.Write "</OBJECT>"
		Response.Write "<BR>"
		Response.Write "<OBJECT height=32 wIDth="&strWIDth&" classID=clsID:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA>"
		Response.Write "<PARAM NAME=""_ExtentX"" VALUE=""12700"">"
		Response.Write "<PARAM NAME=""_ExtentY"" VALUE=""847"">"
		Response.Write "<PARAM NAME=""AUTOSTART"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""SHUFFLE"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""PREFETCH"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""NOLABELS"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""CONTROLS"" VALUE=""ControlPanel,StatusBar"">"
		Response.Write "<PARAM NAME=""CONSOLE"" VALUE=""Clip"">"
		Response.Write "<PARAM NAME=""LOOP"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""NUMLOOP"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""CENTER"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""MAINTAINASPECT"" VALUE=""0"">"
		Response.Write "<PARAM NAME=""BACKGROUNDCOLOR"" VALUE=""#000000"">"
		Response.Write "</OBJECT>"
	Case "swf"
		Response.Write "<object classid=clsid:D27CDB6E-AE6D-11cf-96B8-444553540000 codebase=""http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,19,0"" width="&strWIDth&" height="&strHeight&">"
		Response.Write "<param name=""movie"" value="""&strUrl&""">"
		Response.Write "<param name=""quality"" value=""high"">"
		Response.Write "<embed src="""&strUrl&""" quality=""high"" pluginspage=""http://www.macromedia.com/go/getflashplayer"" type=""application/x-shockwave-flash"" width="&strWIDth&" height="&strHeight&"></embed>"
		Response.Write "</object>"
	Case "flv"
		Response.Write "<div id=""player"" align=""center""><a href=""http://www.macromedia.com/go/getflashplayer"">Get Flash</a> to see this player.</div>"
		Response.Write "<script type=""text/javascript"">"
		Response.Write "var so = new SWFObject('/common/player.swf','player','"&strWIDth&"','"&strHeight&"','7');"
		Response.Write "so.addParam(""allowfullscreen"",""true"");"
		Response.Write "so.addVariable(""file"","""&strUrl&""");"
		Response.Write "so.write('player');"
		Response.Write "</script>"
	Case "jpg","gif","png"
		Response.write "<img src="&strUrl&">"
End Select
End If
End Sub

'********************************
'过程名：过滤目录名
'参  数：无
'********************************
function GeLeach(fString,str)
	if isnull(fString) or trim(fString)="" then
		GeLeach=""
		exit function
	end if
	if str=1 then
	fString = replace(fString, ".", "_")
    end if
	fString = replace(fString, "..", "_")
    fString = replace(fString, "//", "_")
    GeLeach = fString
end function

'********************************
'过程名：HTML格式化
'参  数：无
'********************************
function HTMLEncode(byval fString)
	if isnull(fString) or trim(fString)="" then
		HTMLEncode=""
		exit function
	end if
    fString = replace(fString, ">", "&gt;")
    fString = replace(fString, "<", "&lt;")

    fString = Replace(fString, CHR(32), "&nbsp;")
    fString = Replace(fString, CHR(9), "&nbsp;")
    fString = Replace(fString, CHR(34), "&quot;")
    fString = Replace(fString, CHR(39), "&#39;")
    fString = Replace(fString, CHR(13), "")
    fString = Replace(fString, CHR(10) & CHR(10), "</P><P> ")
    fString = Replace(fString, CHR(10), "<BR> ")

    HTMLEncode = fString
end function

function HTMLDecode(byval fString)
	if isnull(fString) or trim(fString)="" then
		HTMLDecode=""
		exit function
	end if
    fString = replace(fString, "&gt;", ">")
    fString = replace(fString, "&lt;", "<")

    fString = Replace(fString,  "&nbsp;"," ")
    fString = Replace(fString, "&quot;", CHR(34))
    fString = Replace(fString, "&#39;", CHR(39))
    fString = Replace(fString, "</P><P> ",CHR(10) & CHR(10))
    fString = Replace(fString, "<BR> ", CHR(10))

    HTMLDecode = fString
end function

'********************************
'去除所有HTML标记
'********************************
Function cutStr(str,strlen) 
	dim re 
	Set re=new RegExp 
	re.IgnoreCase =True 
	re.Global=True 
	re.Pattern="<(.[^>]*)>" 
	str=re.Replace(str,"") 
	set re=Nothing 
	Dim l,t,c,i 
	l=Len(str) 
	t=0 
	For i=1 to l 
	c=Abs(Asc(MID(str,i,1))) 
	If c>255 Then 
	t=t+2 
	Else 
	t=t+1 
	End If 
	If t>=strlen Then 
	cutStr=left(str,i)&"..." 
	Exit For 
	Else 
	cutStr=str 
	End If 
	Next 
	cutStr=Replace(cutStr,chr(10),"") 
	cutStr=Replace(cutStr,chr(13),"") 
End Function

'****************************************************
'函数名：GetKeyWord
'作  用：关键字替换函数
'****************************************************
Function GetKeyWord(str)
tempText = str
	set rs = Server.CreateObject("ADODB.RECORDSET")
	rs.Open "select * from db_setting", conn, 1, 1
	If Not rs.EOF Then
	KeyWord = rs("KeyWord")
	tempTxt = Split(KeyWord, vbCrLf)
	For i = 0 To UBound(tempTxt)
		txt = tempTxt(i)
	If txt <> "" Then
	txts = Split(txt, "|")
	For n = 0 To UBound(txts)
		Select Case n
		Case 0
			KeyWordTxt = txts(n)
		Case 1
			KeyWordUrl = txts(n)
		End Select
	Next
	tempText = Replace(tempText, KeyWordTxt, "<a href=" & KeyWordUrl & " target=_blank>" & KeyWordTxt & "</a>")
	End If
				
	Next
	End If
	rs.Close
	Set rs = Nothing
	GetKeyWord = tempText
End Function

'****************************************************
'函数名：getCheck
'作  用：check验证
'****************************************************
function getCheck(txt,str)
	if txt="" then
		exit function
	else
		if txt=str then
			Getcheck="checked"
		end if
	end if
end function

'****************************************************
'函数名：IsBlank
'作  用：验证为空
'****************************************************
Function IsBlank(ByRef TempVar)
	IsBlank = False
	Select Case VarType(TempVar)
	Case 0, 1
	IsBlank = True
	Case 8
	If Len(TempVar) = 0 Then
	IsBlank = True
	End If
	Case 9
	tmpType = TypeName(TempVar)
	If (tmpType = "Nothing") Or (tmpType = "Empty") Then
	IsBlank = True
	End If
	Case 8192, 8204, 8209
	If UBound(TempVar) = -1 Then
	IsBlank = True
	End If
	End Select
End Function

'****************************************************
'函数名：GeIsPicture
'作  用：验证是否图片
'****************************************************
Function GeIsPicture(str)
	Select Case GetFileExt(Lcase(str))
		Case "jpg","gif","peg","bmp","png":GeIsPicture=1
		Case Else:GeIsPicture=0
   End Select
End Function

'********************************
'过程名：图片水印
'参  数：无
'********************************
Function Jpeg_Canvas(JpegFiles)
	IF Not IsObjInstalled("Persits.Jpeg") Or Not IsJpeg Then Exit Function
	IF GeIsPicture(JpegFiles)=0 Then Exit Function
	Set AspJpeg=Server.CreateObject("Persits.Jpeg")
	IF AspJpeg.Expires < Now Then Exit Function
	AspJpeg.Open Trim(JpegFiles)
	IF AspJpeg.OriginalWidth>JpegCoordinate(0)*2 Then
		IF JpegStyle Then
			IF Len(JpegPrintText)>0 And Len(JpegColor)>0 Then
				LogoWidth=(JpegSize+1)*strLength(JpegPrintText)/2
				LogoHeight=JpegSize+1
				iLeft=GetPosition_X(AspJpeg.OriginalWidth, LogoWidth, JpegCoordinate(0))
				iTop=GetPosition_Y(AspJpeg.OriginalHeight, LogoHeight, JpegCoordinate(1))
				AspJpeg.Canvas.Font.COLOR=JpegColor         ' 文字的颜色
				AspJpeg.Canvas.Font.Family=JpegFamily         ' 文字的字体
				AspJpeg.Canvas.Font.Size=JpegSize          ' 文字的大小
				AspJpeg.Canvas.Font.Bold=JpegBold              ' 文字是否粗体
				AspJpeg.Canvas.Font.Quality=4                              ' Antialiased
				AspJpeg.Canvas.PrintText iLeft,iTop,JpegPrintText         ' 加入文字及坐标位置
				AspJpeg.Canvas.Pen.COLOR=&H0               ' 边框的颜色
				AspJpeg.Canvas.Pen.Width=1                 ' 边框的粗细
				AspJpeg.Canvas.Brush.Solid=False           ' 图片边框内是否填充颜色
				AspJpeg.Quality=JpegQuality
				AspJpeg.save JpegFiles     ' 生成文件
			End IF
		Else
			Set fso=CreateObject("Scripting.FileSystemObject")
			IF Not fso.FileExists(Server.MapPath(JpegImage)) Then
				Exit Function
			End IF
			Set fso=Nothing
			Dim iAspJpeg
			Set iAspJpeg=Server.CreateObject("Persits.Jpeg")
			iAspJpeg.Open Server.MapPath(JpegImage)  '打开水印图片
			
			iLeft=GetPosition_X(AspJpeg.OriginalWidth,iAspJpeg.Width,JpegCoordinate(0))
			iTop=GetPosition_Y(AspJpeg.OriginalHeight,iAspJpeg.Height,JpegCoordinate(1))
			
			IF JpegBackground="" Then
				AspJpeg.DrawImage iLeft,iTop,iAspJpeg,JpegLucency,100
			Else
				AspJpeg.DrawImage iLeft,iTop,iAspJpeg,JpegLucency,JpegBackground,100
			End IF
			AspJpeg.Quality=JpegQuality
			AspJpeg.Save JpegFiles
			Set iAspJpeg=Nothing	
		End IF
	End IF
	Set AspJpeg = Nothing
End Function

'********************************
'过程名：图片缩略图
'参  数：无
'********************************
Function Jpeg_Thumb(JpegFiles,ObjectFiles)
	IF Not IsObjInstalled("Persits.Jpeg") Or Not IsJpeg Then Exit Function
	IF GeIsPicture(JpegFiles)=0 Then Exit Function
	Set AspJpeg=Server.CreateObject("Persits.Jpeg")
	Set iAspJpeg=Server.CreateObject("Persits.Jpeg")
	IF AspJpeg.Expires < Now Then Exit Function
	AspJpeg.Open Trim(JpegFiles)
	iAspJpeg.Open Trim(JpegFiles)	
	bl_w=JpegThumbWidth/AspJpeg.OriginalWidth
	bl_h=JpegThumbHeight/AspJpeg.OriginalHeight
	IF JpegThumbWidth>0 Then
		IF JpegThumbHeight>0 Then
			Select Case JpegaMeans
			Case "0"'常规算法：宽度和高度都大于0时，直接缩小成指定大小，其中一个为0时，按比例缩小
				IF bl_w<1 Or bl_h<1 Then
					AspJpeg.Width=JpegThumbWidth
					AspJpeg.Height=JpegThumbHeight
					AspJpeg.Quality=JpegQuality
					AspJpeg.save ObjectFiles
				End IF
			Case "1"'裁剪法：宽度和高度都大于0时，先按最佳比例缩小再裁剪成指定大小，其中一个为0时，按比例缩小
				IF bl_w<1 Or bl_h<1 Then
					If bl_w<bl_h Then
						AspJpeg.Height=JpegThumbHeight
						AspJpeg.Width=Round(AspJpeg.OriginalWidth * bl_h)   '按缩小成大比例者
					Else
						AspJpeg.Width=JpegThumbWidth
						AspJpeg.Height=Round(AspJpeg.OriginalHeight * bl_w)
					End IF
					AspJpeg.Crop 0, 0, JpegThumbWidth, JpegThumbHeight
					AspJpeg.Quality=JpegQuality
					AspJpeg.Save ObjectFiles
				End IF
			Case "2"'补充法：在指定大小的背景图上附加上按最佳比例缩小的图片
				'创建一个指定大小的背景图
				iAspJpeg.Width=JpegThumbWidth
				iAspJpeg.Height=JpegThumbHeight
				iAspJpeg.Canvas.Brush.Solid=True            ' 图片边框内是否填充颜色
				iAspJpeg.Canvas.Brush.COLOR="&HFFFFFF"  '设定背景颜色
				iAspJpeg.Canvas.Bar -1, -1, iAspJpeg.Width+1, iAspJpeg.Height+1 '填充

				'按最佳比例缩小图片
				IF bl_w>bl_h Then
					IF bl_h<1 Then
						AspJpeg.Height=JpegThumbHeight
						AspJpeg.Width=Round(AspJpeg.OriginalWidth*bl_h)   '按缩小成小比例者
					End IF
				Else
					IF bl_w<1 Then
						AspJpeg.Width=JpegThumbWidth
						AspJpeg.Height=Round(AspJpeg.OriginalHeight*bl_w)
					End IF
				End IF

				'得到缩略图的坐标
				iLeft=(iAspJpeg.Width-AspJpeg.Width)/2
				iTop=(iAspJpeg.Height-AspJpeg.Height)/2
				iAspJpeg.DrawImage iLeft,iTop,AspJpeg   '将缩略图附加到背景上
				iAspJpeg.Quality=JpegQuality
				iAspJpeg.Save ObjectFiles
			End Select
		Else
			IF bl_w<1 Then
				AspJpeg.Width=JpegThumbWidth
				AspJpeg.Height=Round(AspJpeg.OriginalHeight*bl_w)
				AspJpeg.Quality=JpegQuality
				AspJpeg.Save ObjectFiles
			End IF
		End If
	Else
		IF JpegThumbHeight>0 And bl_h<1 Then
			AspJpeg.Height=JpegThumbHeight
			AspJpeg.Width=Round(AspJpeg.OriginalWidth*bl_h)
			AspJpeg.Quality=JpegQuality
			AspJpeg.Save ObjectFiles
		End IF
	End If
	Set AspJpeg=Nothing
	Set iAspJpeg=Nothing
End Function

Function GetPosition_X(strOriginalWidth, strWidthHeight, strCoordinate)
    Select Case JpegCoordinateStart
		Case 0:GetPosition_X=strCoordinate'左上
		Case 1:GetPosition_X=strCoordinate'左下
		Case 2:GetPosition_X=(strOriginalWidth-strWidthHeight)/2'居中
		Case 3:GetPosition_X=strOriginalWidth-strWidthHeight-strCoordinate'右上
		Case 4:GetPosition_X=strOriginalWidth-strWidthHeight-strCoordinate'右下
		Case Else:GetPosition_X=0'不显示
	End Select
End Function

Function GetPosition_Y(strOriginalWidth,strWidthHeight,strCoordinate)
    Select Case JpegCoordinateStart
		Case 0:GetPosition_Y=strCoordinate'左上
		Case 1:GetPosition_Y=strOriginalWidth-strWidthHeight-strCoordinate'左下
		Case 2:GetPosition_Y=(strOriginalWidth-strWidthHeight)/2'居中
		Case 3:GetPosition_Y=strCoordinate'右上
		Case 4:GetPosition_Y=strOriginalWidth-strWidthHeight-strCoordinate'右下
		Case Else:GetPosition_Y=0'不显示
    End Select
End Function

'**************************
'目的：通用的实现<SELECT>内容的函数
'输入：idname <select的名字>
'liststr 以逗号分开的待显示内容
'valusestr 以逗号分开的待显示对应数值内容
'selectstr 选中的内容
'返回指：无
'例如：CommonSelect("provience","北京,天津,上海","bj,tj,sh","bj")
'**************************
Sub CommonSelect(idname,liststr,valuestr,selectstr)
	Dim arrlist
	Dim arrvalue
	Dim markstr
	arrlist=split(liststr,",")
	IF len(trim(valuestr))=0 Then valuestr=liststr
	IF selectstr="" Then selectstr=arrlist(0)
	arrvalue=split(valuestr,",")
	IF Ubound(arrlist)<>Ubound(arrvalue) Then
		Exit sub
	End IF
	Response.write "<select name=""" & idname & """ id=""" & idname & """>"
	For i=0 to Ubound(arrlist)
	    IF Cstr(arrvalue(i)) = Cstr(selectstr) Then
	       markstr=" selected "
	    Else   
	       markstr=""
	    End IF
	    Response.write "<option " &  markstr & "value='" & arrvalue(i) &"'>" &  arrlist(i) & "</option>"
	Next
	Response.write "</select>"
End Sub

'**************************
'目的：通用单选框
'输入：idname <select的名字>
'       liststr 以逗号分开的待显示内容
'       valusestr 以逗号分开的待显示对应数值内容
'       checkstr 选中的内容
'*************************
Sub CommonRadio(idname,liststr,valuestr,checkstr)
	Dim arrlist
	Dim arrvalue
	Dim markstr
	arrlist=split(liststr,",")
	IF len(trim(valuestr))=0 Then valuestr=liststr
	IF selectstr="" Then selectstr=arrlist(0)

	arrvalue=split(valuestr,",")
	IF Ubound(arrlist)<>Ubound(arrvalue) Then
		Exit sub
	End IF
	marked=false
	For i=0 to Ubound(arrlist)
	    if checkstr=""  and not marked then
		     markstr=" checked "
		     marked=true
		  else
		    IF Cstr(arrvalue(i)) = Cstr(checkstr)  Then
		       markstr=" checked "
		    Else   
		       markstr=""
		    End IF
		 end if
	    Response.write "<input type=radio " & markstr & " value='" & arrvalue(i) &"' name='" & idname & "' id='" & idname & "'>" & arrlist(i) & "&nbsp;"
	Next
End Sub

'****************************************************
'函数名：GetLeverChannel
'作  用：递归搜当前目录下所有的下级目录
'****************************************************
Function GetLeverChannel(Parent)
	SQL = "Select PageID From db_channel Where ParentID="&Parent
    Set doRs=Conn.execute(SQL)
	While Not doRs.Eof
		GetLeverChannel=GetLeverChannel&","&doRs("PageID")
		GetLeverChannel=GetLeverChannel&GetLeverChannel(doRs("PageID"))
	doRs.MoveNext
	Wend
End Function

'****************************************************
'函数名：GetThumb
'作  用：相册
'****************************************************
Function GetThumb(Id,DataType)
	set pRS=server.CreateObject("adodb.recordset")
	SQL="Select * From db_Page where Id="&Id
	pRS.open SQL,conn,1,1
	If Not (pRS.Eof and pRS.Bof) Then
		If IsBlank(Trim(pRS("thumb")))=False Then
			pThumb = Split(pRS("thumb"), "|")  
			For i = 0 to UBound(pThumb)
				If i=0 Then
					HTML = HTML & "<div class=""picture"" id=""bigpicture"" title=""""><img src="""&pThumb(i)&""" /></div>" & vbCrlf
				End if
				strHTML = strHTML & "<li><a href=""javascript:void(0);"""
				If i=0 Then
					strHTML = strHTML & " class=""current"""
				End if
				strHTML = strHTML & ">"
				strHTML = strHTML & "<img src="""&pThumb(i)&""" /></a></li>" & vbCrlf
			Next 
			Response.Write "<div class="""&DataType&""">" & vbCrlf
			Response.Write HTML
			Response.Write "<div class=""switch"">" & vbCrlf
			Response.Write "<div class=""previous""><a href=""javascript:void(0);"" title=""上一个"" onfocus=""this.blur();"">上一个</a></div>" & vbCrlf
			Response.Write "<div class=""content"" id=""smallpicture"">" & vbCrlf
			Response.Write "<ul>" & vbCrlf
			Response.Write strHTML
			Response.Write "</ul>" & vbCrlf
			Response.Write "</div>" & vbCrlf
			Response.Write "<div class=""next""><a href=""javascript:void(0);"" title=""下一个"" onfocus=""this.blur();"">下一个</a></div>" & vbCrlf
			Response.Write "<div class=""clear""></div>" & vbCrlf
			Response.Write "</div>" & vbCrlf
			Response.Write "</div>" & vbCrlf
		End if
	End if
	pRS.close
	set pRS=nothing
End Function
%>