﻿<%@ WebHandler Language="C#" Class="FunctionList" %>

using System;
using System.Web;
using System.Text;
using System.Data;
using DataOper;
public class FunctionList : IHttpHandler {
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/plain";
        try
        {

            StringBuilder sb = new StringBuilder("<table border=\"0\" cellspacing=\"5\" >");
            DataTable table = new FunctionDemand().ProjectDemand(context.Request["cid"].ToString());
            if (table.Rows.Count == 0)
            {
                sb.Append("<tr><td>没有对应的功能需求!</td><tr>");
                sb.Append("</table>");
                context.Response.Write(sb.ToString());
            }
            else
            {

                sb.Append("</tr><th style='white-space:nowrap;'>状态</th><th style='white-space:nowrap;' >进度</th><th style='white-space:nowrap;'>功能录入日期</th><th style='white-space:nowrap;'>功能名</th><th style='white-space:nowrap;'>操作</th></tr>");
                foreach (DataRow row in table.Rows)
                {
                    sb.Append("<tr><td style='white-space:nowrap;'> " + (Convert.ToBoolean(row["Complete"]) ? "<span style='color:#008000'>完成</span>" : "<span style='color:#800000'>未完成</span>") + "</td>");
                    sb.Append("<td style='white-space:nowrap; color:green' >" + row["Progress"].ToString() + "%</td>");
                    sb.Append("<td style='white-space:nowrap;'>" + DateTime.Parse(row["IDate"].ToString()).ToString("yyyy-MM-dd") + "</td>");
                    sb.Append("<td style='white-space:nowrap;'> " + row["Beizhu"].ToString() + "</td>");
                    sb.Append("<td style='white-space:nowrap;'>");
                    
                    if (context.Request["type"]!=null)
	                {
                            sb.Append("&ensp;|&ensp;<a href='#' onclick='showFunction(\"" + row["CID"] + "\")'>查看</a>");
                            sb.Append("&ensp;|&ensp;<a href='#' onclick='editProgress(\"" + row["CID"] + "\")'>设置进度</a>");
                            if(!Convert.ToBoolean(row["Complete"]))
                            sb.Append("&ensp;|&ensp;<a href='#' onclick='UpCode(\"" + row["CID"] + "\")'>上传代码</a>");
                    }else{
                            sb.Append("&ensp;|&ensp;<a href='#' onclick='showFunction(\"" + row["CID"] + "\")'>查看</a>");
                            sb.Append("&ensp;|&ensp;<a href='#' onclick='editFunction(\"" + row["CID"] + "\")'>编辑</a>");
                            sb.Append("&ensp;|&ensp;<a href='#' onclick='DetailsProgress(\"" + row["CID"] + "\")'>进度详细</a>");
                            sb.Append("&ensp;|&ensp;<a href='#' onclick='FunctionCode(\"" + row["CID"] + "\")'>上传代码列表</a>");
                    }
                    sb.Append("</td></tr>");
                }
                sb.Append("</table>");
                
                context.Response.Write(sb.ToString());
              
            }
        }
        catch (Exception exe)
        {
            context.Response.Write("运行错误！"+exe.Message);
        }
        
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }

}