﻿<%@ WebHandler Language="C#" Class="PaymentList" %>

using System;
using System.Web;
using System.Text;
using DataOper;
using System.Data;
public class PaymentList : IHttpHandler {
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/plain";
        try
        {

            StringBuilder sb = new StringBuilder("<table border=\"0\" cellspacing=\"5\" >");
           
            DataTable table = new Payment().ProjectPaymentList(context.Request["cid"].ToString());
            if (table.Rows.Count == 0)
            {
                sb.Append("<tr><td>没有对应的付款记录!</td><tr>");
                sb.Append("</table>");
                context.Response.Write(sb.ToString());
            }
            else
            {
                sb.Append("<caption  align=left><a href='#' onclick=\"editPayment('" + context.Request["cid"].ToString() + "')\">编辑付款记录</a></caption>");
                sb.Append("</tr><th style='white-space:nowrap;'>日期</th><th style='white-space:nowrap;' >付款金额</th><th style='white-space:nowrap;'>备注</th></tr>");
                foreach (DataRow row in table.Rows)
                {
                    sb.Append("<tr><td style='white-space:nowrap;'> " + DateTime.Parse(row["IDate"].ToString()).ToString("yyyy-MM-dd") + "</td>");
                    sb.Append("<td style='white-space:nowrap; color:green' >" + row["Payment"].ToString() + "￥</td>");
                    sb.Append("<td style='white-space:nowrap;'>" + row["Beizhu"].ToString() + "</td>");
                    sb.Append("</tr>");
                }
                sb.Append("</table>");

                context.Response.Write(sb.ToString());

            }
        }
        catch (Exception exe)
        {
            context.Response.Write("运行错误！" + exe.Message);
        }
        
        
        
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }

}