﻿<%@ WebHandler Language="C#" Class="Programmer" %>

using System;
using System.Web;
using DataOper;
using System.Data;
using System.Text;
public class Programmer : IHttpHandler {
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/plain";
        try
        {

            StringBuilder sb = new StringBuilder("<table border=\"0\" cellspacing=\"5\" >");
            DataTable table = new ProjectProgrammer().SelectProjectProgrammer(context.Request["cid"]);
            if (table.Rows.Count == 0)
            {
                sb.Append("<tr><td>该项目没有开发人员!</td><tr>");
                sb.Append("</table>");
                context.Response.Write(sb.ToString());
            }
            else
            {
                sb.Append("</tr><th style='white-space:nowrap;'>开发人员</th><th style='white-space:nowrap;'>性别</th></tr>");
                foreach (DataRow row in table.Rows)
                {
                    sb.Append("<tr><td>"+row["Name"].ToString()+"</td>");
                    sb.Append("<td>"+row["Sex"].ToString()+"</td>");
                    sb.Append("<tr>");
                }
                sb.Append("</table>");
                context.Response.Write(sb.ToString());

            }
        }
        catch (Exception exe)
        {
            context.Response.Write("运行错误！" + exe.Message);
        }
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }

}