﻿<%@ WebHandler Language="C#" Class="Progress" %>

using System;
using System.Web;
using DataOper;
using System.Data;
using System.Text;
public class Progress : IHttpHandler {
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/plain";
        try
        {

            StringBuilder sb = new StringBuilder("<table border=\"0\" cellspacing=\"5\" >");
            DataTable table = new FunctionDemand().ProjectDemandProgress(context.Request["cid"].ToString());
            if (table.Rows.Count == 0)
            {
                sb.Append("<tr><td>没有对应的功能需求!</td><tr>");
                sb.Append("</table>");
                context.Response.Write(sb.ToString());

            }
            else
            {
                sb.Append("</tr><th style='white-space:nowrap;'>状态</th><th style='white-space:nowrap;'>进度</th><th style='white-space:nowrap;'>功能录入日期:</th><th style='white-space:nowrap;'>功能名</th><th style='white-space:nowrap;'>操作</th></tr>");
                foreach (DataRow row in table.Rows)
                {
                    sb.Append("<tr ><td style='white-space:nowrap;'>" + (Convert.ToBoolean(row["Complete"]) ? "<span style='color:#008000'>完成</span>" : "<span style='color:#800000'>未完成</span>") + "</span></td>");
                    sb.Append("<td style='white-space:nowrap;'>" + row["Progress"].ToString() + "%</td>");
                    sb.Append("<td style='white-space:nowrap;'>" + DateTime.Parse(row["IDate"].ToString()).ToString("yyyy-MM-dd") + "</td>");
                    sb.Append("<td style='white-space:nowrap;'> " + row["Beizhu"].ToString() + "</td>");

                    sb.Append("<td style='white-space:nowrap;'><a href='#' onclick='DetailsProgress(\"" + row["CID"] + "\")'>进度详细</a></td>");
                    sb.Append("</tr>");
                }
                sb.Append("</table>");

                context.Response.Write(sb.ToString());

            }
        }
        catch (Exception exe)
        {
            context.Response.Write("运行错误！" + exe.Message);

        }
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }

}