﻿<%@ WebHandler Language="C#" Class="SelectArea" %>

using System;
using System.Web;
using System.Data;
using DataOper;
using System.Text;
public class SelectArea : IHttpHandler {
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/plain";
        object area = context.Request["Area"];
        if (area!=null)
        {
            DataTable data = new Area().SelectArea(area);
            StringBuilder sb = new StringBuilder("<table border=\"0\" cellspacing=\"3\" >");
            sb.Append("<tr>");
            for (int index = 0; index < data.Rows.Count; index++)
            {
                DataRow row = data.Rows[index];
                sb.Append("<td>");
                sb.Append("<a href='#' onclick='getArea('" + row["cid"] + "')' >" + row["AreaName"] + "</a>");
                sb.Append("</td>");
                if ((index + 1) % 5 == 0)
                {
                    sb.Append("</tr>");
                    if ((index + 1) != data.Rows.Count)
                        sb.Append("<tr>");
                }
                else if((index+1)==data.Rows.Count)
                {
                    sb.Append("</tr>");
                }
            }
            context.Response.Write(sb.ToString());
        }
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }

}