﻿<%@ WebHandler Language="C#" Class="source" %>

using System;
using System.Web;
using System.Text;
using Jayrock.Json;
using System.Data;
using DataOper;
public class source : IHttpHandler {
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/plain";
        object root = null;
        if (context.Request["root"] == "source")
            root = "-1";
        else
            root = context.Request["root"];
        if(root!=null)
            context.Response.Write(getNode(root));
    }

    public string getNode(object root)
    {
        DataTable table = new Area().SelectAll(root);
        JsonArray jsonList = new JsonArray();
        JsonObject json;
        foreach (DataRow row in table.Rows)
        {

            json = new JsonObject();
            json.Accumulate("text", row["AreaName"].ToString());
            json.Accumulate("id", row["CID"].ToString());
            json.Accumulate("parent", row["Parent"].ToString());
            json.Accumulate("depth", row["depth"].ToString());
            if (!Convert.ToBoolean(row["isLeaf"]))
            {
                json.Accumulate("hasChildren", true);
            }
            jsonList.Add(json);
        }

        return jsonList.ToString();
    }
    public bool IsReusable {
        get {
            return false;
        }
    }

}