﻿<%@ WebHandler Language="C#" Class="CustomerOper" %>
using System;
using System.Web;

using System.Data;  
using Jayrock.Json;
using Jayrock.Json.Conversion;
using System.IO;  
using System.Collections.Specialized;
using DataOper;
public class CustomerOper : IHttpHandler {
    private Customer customer = new Customer();
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/plain";
        JsonObject jsonData = null;
        if (context.Request.Form.AllKeys.Length==1 &&context.Request.Form.AllKeys[0]==null)
        {
            Stream instream = context.Request.InputStream;
            System.IO.StreamReader streamReader = new StreamReader(instream, System.Text.Encoding.GetEncoding("UTF-8"));
            string content = streamReader.ReadToEnd();

            JsonTextReader reader = new JsonTextReader(new StringReader(content));
            //以下是转换为JSON数据
            jsonData = new JsonObject();
            jsonData.Import(reader);
        }
        else
        {
                object obj = context.Request.Form;
        }

        switch ((OperType)Enum.Parse(typeof(OperType), jsonData["type"].ToString()))
        {
            case OperType.Insert:
                break;
            case OperType.Delete:
                context.Response.Write(Delete(jsonData));
                break;
            case OperType.Update:
                break;
            case OperType.PageInfo:
                context.Response.Write(OutJson("1", Pager(jsonData)));
                break;
            case OperType.Select:
                context.Response.Write(Select(jsonData));
                break;
            default:
                context.Response.Write(OutJson("-1", "未知操作！"));
                break;
        }
    }
    private string Insert(HttpContext context)
    {
        return "";
    }
    private string Delete(JsonObject jsonData)
    {
        string items = jsonData["item"].ToString();
        if (items.ToString()!="")
        {
            int count = customer.Delete(items);
            JsonObject json = OutJson("1",count);
            
            json.Accumulate("allcount",customer.SelectCount());

            if (jsonData["param"] != null)
            {
                JsonArray list = jsonData["param"] as JsonArray;
                MapColumn(list);
                MarkSelect mark = new MarkSelect(list);
                System.Data.SqlClient.SqlParameter[] plist = mark.SqlParamList;
                String where = mark.Where;
                json.Accumulate("querycount", customer.SelectCount(where, plist));
            }
            return json.ToString();
        }
        return OutJson("-1","没有选项！").ToString();
    }
    private string Update(HttpContext context)
    {
        return "";
    }
    private string Pager(JsonObject jsonData)
    {
        DataTable data = customer.PageInfo(
            Convert.ToInt32(jsonData["pageIndex"].ToString()),
            Convert.ToInt32(jsonData["pageSize"].ToString())
        );
        return markInfo(data);
    }

    private string Select(JsonObject jsonData)
    { 
        JsonArray list = jsonData["param"] as JsonArray;
        MapColumn(list);
        
        MarkSelect mark = new MarkSelect(list);
        System.Data.SqlClient.SqlParameter[] plist = mark.SqlParamList;
        String where = mark.Where;
        int querycount = customer.SelectCount(where,plist);
        DataTable data = customer.PageInfo(
                        Convert.ToInt32(jsonData["pageIndex"].ToString()),
                        Convert.ToInt32(jsonData["pageSize"].ToString()),
                        where,
                        plist
                        );
        JsonObject outjson = OutJson("1",markInfo(data));
        outjson.Accumulate("pagecount", querycount);
        return outjson.ToString();
    }
    //构造表格显示数据
    private string markInfo(DataTable data)
    {
        JsonArray list = new JsonArray();
        foreach (DataRow row in data.Rows)
        {
            JsonObject json = new JsonObject();
            json.Accumulate("id",row["CID"].ToString());
            json.Accumulate("custindustry",row["CustIndustry"].ToString());
            json.Accumulate("custww",row["CustWW"].ToString());
            json.Accumulate("custname",row["CustName"].ToString());
            json.Accumulate("custsourse",row["CustSourse"].ToString());
            json.Accumulate("custgrade",row["CustGrade"].ToString());
            json.Accumulate("custclass",row["CustClass"].ToString());
            json.Accumulate("custphone",row["CustPhone"].ToString());
            json.Accumulate("custurl",row["CustUrl"].ToString());
            json.Accumulate("custaddress",row["CustAddress"].ToString());
            json.Accumulate("custemail",row["CustEMAIL"].ToString());
            json.Accumulate("custqq",row["CustQQ"].ToString());
            json.Accumulate("idate",row["IDate"].ToString());
            json.Accumulate("linkman",row["LinkMan"].ToString());
            json.Accumulate("linkmanphone",row["LinkManPhone"].ToString());
            json.Accumulate("sales",row["Sales"].ToString());
            json.Accumulate("city",row["City"].ToString());
            list.Add(json);
        }
        return list.ToString();
    }
    private JsonObject OutJson(object type, object value)
    {
        JsonObject json;
        json = new JsonObject();
        json.Accumulate("type", type.ToString());
        json.Accumulate("value", value.ToString());
        return json;
    }

    private void MapColumn(JsonArray list)
    {
        foreach (JsonObject item in list)
        {
            switch (item["column"].ToString())
            {
                case "0":
                    item["column"] = "Cust.Sales";
                    break;
                case "1":
                    item["column"] = "Cust.CustName";
                    break;
                case "2":
                    item["column"] = "Cust.CustUrl";
                    break;
                case "3":
                    item["column"] = "Cust.CustEMAIL";
                    break;
                case "4":
                    item["column"] = "Cust.CustQQ";
                    break;
                case "5":
                    item["column"] = "Cust.CustWW";
                    break;
                case "6":
                    item["column"] = "Cust.LinkMan";
                    break;
                case "7":
                    item["column"] = "Cust.LinkManPhone";
                    break;
                case "8":
                    item["column"] = "Cust.City";
                    break;
                case "9":
                    item["column"] = "Cust.CustSourse";
                    break;
                case "10":
                    item["column"] = "Cust.CustClass";
                    break;
                case "11":
                    item["column"] = "Cust.CustGrade";
                    break;
                case "12":
                    item["column"] = "Cust.CustIndustry";
                    break;
                case "13":
                    item["column"] = "Cust.IDate";
                    break;
                case "14":
                    item["column"] = "Cust.IDate";
                    break;
            }
        }
    }
    public bool IsReusable {
        get {
            return false;
        }
    }

}