﻿// JScript 文件
/* 表数据操作页 javascript通用 代码
  方法： message  弹出消息框 可自主定义消息显示
  方法： dataRows 获取当前数据
  方法： dataInfo 格式数据显示 
  方法： load     设置屏蔽
  方法： unload   取消屏蔽
  方法： bgclickcolor  设置显示数据TR 单击背景颜色改变
  方法： currentbgcolor 当前点击项 颜色 主要用于 编辑行 后重新设置背景选中
  方法： allPager 表所有数据分页组件设置 
  方法： pageselectCallback 表所有数据分页组件单击事件
  方法： selectPager  查询数据分页组件
  方法： pagerQueryCallback 查询数据分页组件分页事件
  方法： FormatData 格式JSON数据 返回HTML
  方法： select 查询点击事件 获取查询参数 设置查询数据分页组件 
  方法： paramter 查询参数对象
  //--------删除-----------
  方法： allSelect 设置选中所有checkbox
  方法： selectDelete 删除所有选中行 
  //----未定义有-----
  录入界面弹出
  方法： showInsertDialog 弹出录入界面方法
  方法： insert 确认录入点击事件
  方法： insertValid 录入数据验证
  方法： insertComplete 录入数据 服务器返回处理方法
 */
 //----------------特定表辅助方法 不通用---------------------------

function builderUrl(url)
{
    url = url.toLocaleLowerCase();
    var i = url.indexOf("http");
    if (i != -1)
    {
        return url;
    }
    else
    {
        return "http://"+url;
    }
}
 
 //----------------------------------------------

//弹出消息框 可自主定义消息显示 
function message(msg){
    alert(msg);
}
function dataRows(){
    return $("#content tr");
}
//格式数据显示 并设置点击变色事件
function dataInfo(data){
    $("#content").html(data);
    bgclickcolor();
}
//设置屏蔽
function load(str){
       $("body").elapsor({
             color:'#000',
             opacity:10,
             image:'../images/loading/elapsor.gif',
             text:str?"执行中...":str,
             text_style:{
                  color:'#000',
                  'font-size':11
             }
       });
};  
//取消屏蔽
function unload(){
     $("body").hideElapsor();
};
//设置显示数据TR 单击背景颜色改变
var currentSelectItem =null;
function bgclickcolor(){
        $("#content tr").click(
            function(){
                $("#content tr").each(function(){
                    $(this).css({background: "#fff" });
                })
                    $(this).css({background: "#ffffe0" });
                
                currentSelectItem = $(this).attr("id");
            }
        );
}
//当前点击项 颜色 主要用于 编辑行 后重新设置背景选中
function currentbgcolor()
{
      $("#"+currentSelectItem).css({background: "#ffffe0" });
}
//所有数据分页组件        
function allPager(count,isfull){

     var pagecount = Math.ceil(parseInt(count)/parseInt(param.pagesize)) ;
     $("#pagecount").text(count);
     $("#AllPagerTop,#AllPagerButtom").pagination(pagecount,{
                                     num_edge_entries: 2,
                                     num_display_entries: 15,
                                     callback: pageselectCallback,
                                     items_per_page:1,
                                     prev_text:"下一页",
                                     next_text:"上一页",
                                     ispage:isfull
                      }); 
}
//所有数据分页事件
function pageselectCallback(page_index,jq){
             load("加载中...");
             page_index = page_index+1;
             
             var json={
                "type":param.pager,
                "pageIndex":page_index,
                "pageSize":param.pagesize
      
             }
             $.ajax({
                       type: "POST",
                       dataType:"json",
                       processData:false,
                       async:param.async,        
                       url: param.url,
                       data:$.toJSON(json),
                       success: function(data){
                            unload();
                            if(data.type=="1"){
                                dataInfo(FormatData(data.value));
                            }else{
                                message(data.value);
                            }
                       
                       },
                       error:function (XMLHttpRequest, textStatus, errorThrown) {
                            alert("错误");
                            unload();
                       },
                       beforeSend: function(XMLHttpRequest){ 
              
                 
                       }
              });
            return false;
}
//查询分页组件
function selectPager(count,isfull,currentpageindex)
{
     var pagecount = Math.ceil(parseInt(count)/param.pagesize) ;
     $("#selectcount").text("当前查询："+count+" 行");
     $("#SelectPagerTop,#SelectPagerButtom").pagination(pagecount,{
                                     num_edge_entries: 2,
                                     num_display_entries: 15,
                                     callback: pagerQueryCallback,
                                     items_per_page:1,
                                     prev_text:"下一页",
                                     next_text:"上一页",
                                     current_page:currentpageindex,
                                     ispage:isfull
                      }); 
}
//查询分页组件分页事件
function pagerQueryCallback(page_index,jq){
             var pageinfoIndex = page_index+1;
             var json={
                "type":param.select,
                "pageIndex":pageinfoIndex,
                "pageSize":param.pagesize,
                "param":queryParam
             }
             load("查询中...");
             $.ajax({
                       type: "POST",
                       dataType:"json",
                       processData:false,        
                       url: param.url,
                       data: $.toJSON(json),
                       async:param.async,
                       success: function(data){
                              unload();
                              if(data.type=="-1"){
                                message(data.value);
                              }else if(data.type=="1"){
                                selectPager(data.pagecount,false,page_index);
                                dataInfo(FormatData(data.value));
                              }
                       },
                       error:function (XMLHttpRequest, textStatus, errorThrown) {
                            alert("错误");
                            unload();
                       },
                       beforeSend: function(XMLHttpRequest){ 
              
                 
                       }
                  });  
              return false;
}
//列表数据格式化
function FormatData(value){
        var list  = eval(value);
        var sb = new StringBuilder();
        for(var i in list) 
        {
            sb.append("<tr id=\"item_" + list[i].id + "\" >");
            sb.append("<td   style=\"white-space: nowrap;\" width='10px'><input  type=\"checkbox\" value='"+list[i].id+"' /></td>");
            sb.append("<td style=\"white-space: nowrap;\">");
            sb.append("&nbsp;<a href=\"javascript:void(0)\" onclick=\"studentlook('" + list[i].id + "')\" >详细</a>");
            sb.append("&nbsp;<a href=\"javascript:void(0)\"  onclick=\"studentedit('" + list[i].id + "')\">编辑</a>");
            sb.append("&nbsp;<a href=\"javascript:void(0)\" onclick=\"studentdelete('" + list[i].id + "')\">删除</a>");
            sb.append("</td>");
            sb.append("<td>" + list[i].custname + "</td>");
            if(list[i].custurl!=""){
                sb.append("<td ><a href=\"" + builderUrl(list[i].custurl) + "\" target=\"_blank\" >连接</a></td>");
            }else{
                if(list[i].custqq!="")
                sb.append("<td ><a href=\"http://user.qzone.qq.com/" + list[i].custqq + "\" target=\"_blank\" >QQ空间</a></td>");
                else
                sb.append("<td></td>")
            }
            if(list[i].custemail!=""){
                sb.append("<td ><a href=\"mailto:" + list[i].custemail + "\" >EMAIL</a></td>");
            }else{
                 if (list[i].custqq != "")
                    sb.append("<td ><a href=\"mailto:" + list[i].custqq + "@qq.com\" >QQ_EMAIL</a></td>");
                 else
                    sb.append("<td></td>");
            }
            sb.append("<td ><a href=\"tencent://message/?uin=" + list[i].custqq + "&amp;&amp;Site=LICENSE_ShopEx&amp;&amp;Menu=yes\" target=\"_blank\"><img border=\"0\" src=\"http://wpa.qq.com/pa?p=1:" + list[i].custqq + ":14\"></a></td>");
            sb.append("<td ><a target=\"_blank\" href=\"http://amos.im.alisoft.com/msg.aw?v=2&uid=" + list[i].custww  + "&site=cntaobao&s=1&charset=utf-8\" ><img border=\"0\" src=\"http://amos.im.alisoft.com/online.aw?v=2&uid=" + list[i].custww  + "&site=cntaobao&s=1&charset=utf-8\" alt=\"联系我！\" /></a></td>");
            sb.append("<td >" + list[i].linkman + "</td>");
            sb.append("<td >" + list[i].linkmanphone + "</td>");
            sb.append("<td >" + list[i].city + "</td>");
            sb.append("<td >" + list[i].sales + "</td>");
            sb.append("<td >" + list[i].custsourse + "</td>");
            sb.append("<td >" + list[i].custclass + "</td>");
            sb.append("<td >" + list[i].custgrade + "</td>");
            sb.append("<td >" + list[i].custindustry + "</td>");
            sb.append("<td >" + list[i].idate + "</td>");
            sb.append("</tr>")
        }
        return sb.tostring();
}
    
//查询参数设置 并执行查询操作
var queryParam = null;
function select(){
        queryParam= new Array();
        queryParam.push(new paramter("0",param.equals ,$("#SelectQuerySales").val(),param.int));
        queryParam.push(new paramter("1", $("#SelectQueryNameTerm").val(), $("#txtQueryName").val(), param.nvarchar));
        queryParam.push(new paramter("2", $("#SelectQueryUrlTerm").val(), $("#txtQueryUrl").val(), param.nvarchar));
        queryParam.push(new paramter("3", $("#SelectQueryEmailTerm").val(), $("#txtQueryEmail").val(), param.nvarchar));
        queryParam.push(new paramter("4", $("#SelectTermQQ").val(), $("#txtQueryQQ").val(), param.nvarchar));
        queryParam.push(new paramter("5", $("#SelectWWTerm").val(), $("#txtQueryWW").val(), param.nvarchar));
        queryParam.push(new paramter("6", $("#SelectQueryLinkManTerm").val(), $("#txtQueryLinkMan").val(), param.nvarchar));
        queryParam.push(new paramter("7", $("#SelectLinkPhoneTerm").val(), $("#txtQueryLinkManPhone").val(), param.nvarchar));
        queryParam.push(new paramter("8", $("#SelectAreaTerm").val(), $("#txtQueryArea").val(), param.nvarchar));
        queryParam.push(new paramter("9",  param.equals, $("#SelectCustSourse").val(), param.int));
        queryParam.push(new paramter("10", param.equals, $("#SelectCustClass").val(), param.int));
        queryParam.push(new paramter("11", param.equals, $("#SelectCustGrade").val(), param.int));
        queryParam.push(new paramter("12", param.equals, $("#SelectCustIndust").val(), param.int));
        queryParam.push(new paramter("13", param.lessthen, $("#txtQueryIDateStart").val(), param.nvarchar));
        queryParam.push(new paramter("14", param.greaterthen, $("#txtQueryIDateEnd").val(), param.nvarchar)); 
        pagerQueryCallback(0,null);
     
     
}


//参数对象
paramter = function(_column,_term,_value,_type){
    this.column = _column;
    this.term = _term;
    this.value = _value;
    this.type = _type;
}

/*
表格操作 

方法：allSelect 全选 
方法：selectDelete 选中删除项
*/
function selectDelete(){
           var list = dataRows();
           var items = new Array();
           var removelist = new Array();
           for(var index=0;index<list.size();index++){
                  var cb = list.eq(index).children(":eq(0)").children("input[type='checkbox']");
                  if(cb.attr("checked")){
                    var id =cb.attr("value");
                    items.push("'"+id+"'");
                    removelist.push(id);
                  }
           }
           var json;
           if(queryParam==null)
              json = {"type":param.remove,"item":items.join(',')}
           else
              json = {"type":param.remove,"item":items.join(','),"param":queryParam};
                      
           if(items.length>0){
                load("删除中...");
                $.ajax({
                       type: "POST",
                       dataType:"json",
                       processData:false,        
                       url: param.url,
                       data: $.toJSON(json),
                       async:param.async,
                       success: function(data){
                             unload();
                             if(data.type=="-1"){
                                alert(data.value);
                             }else if(data.type=="1"){
                                  allPager(data.allcount,false);
                                if(data.querycount!=null){
                                  selectPager(data.querycount,false);
                                }
                                for(var index=0;index<removelist.length;index++){
                                    $("#item_"+removelist[index]).remove();
                                    
                                }
                                message("共删除 "+data.value+" 行数据");
                             }
                       },
                       error:function (XMLHttpRequest, textStatus, errorThrown) {
                            alert("错误");
                            unload();
                       },
                       beforeSend: function(XMLHttpRequest){ 
              
                       }
              });  
             
          }else{
                message('没有选中项！');
          }
}
function allSelect(obj){
          var list = dataRows();
           for(var index=0;index<list.size();index++){
                  var cb = list.eq(index).children(":eq(0)").children("input[type='checkbox']");
                  if($(obj).attr("checked")){
                    cb.attr("checked",true);
                  }else{
                    cb.attr("checked",false);
                  }
           }
}

//录入操作
// 录入客户资料
function showInsertDialog(){
    var options = { 
            url:param.url,
            dataType:  'json', 
            beforeSubmit:insertValid, 
            success:insertComplete,
            error: function() {unload(); alert("保存失败！"); return false; } 
    }; 
    $("#dialogInsert").dialog(
                        {
                            width:540,
                            height:500,
                            title:"客户信息录入",
                            buttons: {
                             "录入": function() {
                                  load("保存中...");
                                  $('#insertForm').ajaxSubmit(options); 
                              },
                              "重置":function(){
                                  $('#insertForm').resetForm();
                              }
                            }
				        });
}
function insertValid(){
    return true;
}
function insertComplete(){
    message("成功了");
}
