﻿<%
'过滤单引号
Function CheckPar(par)
   If Isnull(Str) Then
      CheckPar = ""
      Exit Function 
   End If
   par=replace(par,"'","''")
   CheckPar=par    
End Function

'HTMLEncode
Function Encode(par)
   if Isnull(par) Then
      Encode=""
	  Exit Function
   End If
   par=replace(par,"""","&quot;")
   par=replace(par,"'","&#039;")
   par=replace(par,"<","&lt;")
   par=replace(par,">","&gt;")
   Encode=par
End Function

Function Decode(par)
   if Isnull(par) Then
      Encode=""
	  Exit Function
   End If
   par=replace(par,"&quot;","""")
   par=replace(par,"&#039;","'")
   par=replace(par,"&lt;","<")
   par=replace(par,"&gt;",">")
   Decode=par
End Function

'过滤写成变量的内容
Function writePar(par)
   If Isnull(Str) Then
      CheckPar = ""
      Exit Function 
   End If
   par=replace(par,vbcrlf," ")
   par=replace(par,"""","&quot;")
   par=replace(par,"<","&lt;")
   par=replace(par,">","&gt;")
   writePar=par   
End Function

'*******过滤危险字符、JS、html******
Function CheckStr(Str)
 If Isnull(Str) Then
  CheckStr = ""
  Exit Function 
 End If
 Str = Replace(Str,Chr(0),"", 1, -1, 1)
 Str = Replace(Str, """", "&quot;", 1, -1, 1)
 Str = Replace(Str,"<","&lt;", 1, -1, 1)
 Str = Replace(Str,">","&gt;", 1, -1, 1) 
 Str = Replace(Str, "script", "&#115;cript", 1, -1, 0)
 Str = Replace(Str, "SCRIPT", "&#083;CRIPT", 1, -1, 0)
 Str = Replace(Str, "Script", "&#083;cript", 1, -1, 0)
 Str = Replace(Str, "script", "&#083;cript", 1, -1, 1)
 Str = Replace(Str, "object", "&#111;bject", 1, -1, 0)
 Str = Replace(Str, "OBJECT", "&#079;BJECT", 1, -1, 0)
 Str = Replace(Str, "Object", "&#079;bject", 1, -1, 0)
 Str = Replace(Str, "object", "&#079;bject", 1, -1, 1)
 Str = Replace(Str, "applet", "&#097;pplet", 1, -1, 0)
 Str = Replace(Str, "APPLET", "&#065;PPLET", 1, -1, 0)
 Str = Replace(Str, "Applet", "&#065;pplet", 1, -1, 0)
 Str = Replace(Str, "applet", "&#065;pplet", 1, -1, 1)
 Str = Replace(Str, "[", "&#091;")
 Str = Replace(Str, "]", "&#093;")
 Str = Replace(Str, """", "", 1, -1, 1)
 Str = Replace(Str, "=", "&#061;", 1, -1, 1)
 Str = Replace(Str, "select", "sel&#101;ct", 1, -1, 1)
 Str = Replace(Str, "execute", "&#101xecute", 1, -1, 1)
 Str = Replace(Str, "exec", "&#101xec", 1, -1, 1)
 Str = Replace(Str, "join", "jo&#105;n", 1, -1, 1)
 Str = Replace(Str, "union", "un&#105;on", 1, -1, 1)
 Str = Replace(Str, "where", "wh&#101;re", 1, -1, 1)
 Str = Replace(Str, "insert", "ins&#101;rt", 1, -1, 1)
 Str = Replace(Str, "delete", "del&#101;te", 1, -1, 1)
 Str = Replace(Str, "update", "up&#100;ate", 1, -1, 1)
 Str = Replace(Str, "like", "lik&#101;", 1, -1, 1)
 Str = Replace(Str, "drop", "dro&#112;", 1, -1, 1)
 Str = Replace(Str, "create", "cr&#101;ate", 1, -1, 1)
 Str = Replace(Str, "rename", "ren&#097;me", 1, -1, 1)
 Str = Replace(Str, "count", "co&#117;nt", 1, -1, 1)
 Str = Replace(Str, "chr", "c&#104;r", 1, -1, 1)
 Str = Replace(Str, "mid", "m&#105;d", 1, -1, 1)
 Str = Replace(Str, "truncate", "trunc&#097;te", 1, -1, 1)
 Str = Replace(Str, "nchar", "nch&#097;r", 1, -1, 1)
 Str = Replace(Str, "char", "ch&#097;r", 1, -1, 1)
 Str = Replace(Str, "alter", "alt&#101;r", 1, -1, 1)
 Str = Replace(Str, "cast", "ca&#115;t", 1, -1, 1)
 Str = Replace(Str, "exists", "e&#120;ists", 1, -1, 1)
 Str = Replace(Str,Chr(13),"<br>", 1, -1, 1)
 CheckStr = Replace(Str,"'","&#39;", 1, -1, 1)
End Function
'*******去掉HTML代码******
Function removeHtml(str)
    dim re
    Set re=new RegExp
    re.IgnoreCase =true
    re.Global=True
    re.Pattern="(\<.[^\<]*\>)"
    str=re.replace(str," ")
    re.Pattern="(\<\/[^\<]*\>)"
    str=re.replace(str," ")
    removeHtml=str
    set re=nothing
end Function



'*************************************************
'函数名：gotTopic
'作  用：截字符串，汉字一个算两个字符，英文算一个字符
'参  数：str   ----原字符串
'       strlen ----截取长度
'返回值：截取后的字符串
'*************************************************
function gotTopic(str,strlen)
	if str="" then
		gotTopic=""
		exit function
	end if
	dim l,t,c, i
	str=replace(replace(replace(replace(str,"&nbsp;"," "),"&quot;",chr(34)),"&gt;",">"),"&lt;","<")
	l=len(str)
	t=0
	for i=1 to l
		c=Abs(Asc(Mid(str,i,1)))
		if c>255 then
			t=t+2
		else
			t=t+1
		end if
		if t>=strlen then
			gotTopic=left(str,i) & "…"
			exit for
		else
			gotTopic=str
		end if
	next
	'gotTopic=replace(replace(replace(replace(gotTopic," ","&nbsp;"),chr(34),"&quot;"),">","&gt;"),"<","&lt;")
end function

'========================= 
'获取当前Url参数的函数 
Private Function GetUrl() 
Dim ScriptAddress, M_ItemUrl, M_item 
ScriptAddress = CStr(Request.ServerVariables("SCRIPT_NAME")) '取得当前地址 
M_ItemUrl = "" 
If (Request.QueryString <> "") Then 
ScriptAddress = ScriptAddress & "?" 
For Each M_item In Request.QueryString 
If InStr(page,M_Item)=0 Then 
M_ItemUrl = M_ItemUrl & M_Item &"="& Server.URLEncode(Request.QueryString(""&M_Item&"")) & "&" 
End If 
Next 
end if 
GetUrl = ScriptAddress & M_ItemUrl 
End Function 
'=============================

'得到网站服务器的地址     
Function   GetUrlRoot()         
Dim   strTemp,strUrl     
If   LCase(Request.ServerVariables("HTTPS"))   =   "off"   Then     
strTemp   =   "http://"     
Else     
strTemp   =   "https://"     
End   If     
strTemp   =   strTemp   &   Request.ServerVariables("SERVER_NAME")     
If   Request.ServerVariables("SERVER_PORT")   <>   80   Then   strTemp   =   strTemp   &   ":"   &   Request.ServerVariables("SERVER_PORT")  
strUrl=Request.ServerVariables("URL") 
strUrl=right(strUrl,len(strUrl)-1)  
i=InstrRev(strUrl,"/")
strUrl   =   Mid(strUrl,1,i-1)  
strTemp   =   strTemp   & "/"&   strUrl &"/"
    
GetUrl   =   strTemp     
End   Function 
'=============================




'***************************************************
'函数名：IsObjInstalled
'作  用：检查组件是否已经安装
'参  数：strClassString ----组件名
'返回值：True  ----已经安装
'       False ----没有安装
'***************************************************
Function IsObjInstalled(strClassString)
	On Error Resume Next
	IsObjInstalled = False
	Err = 0
	Dim xTestObj
	Set xTestObj = Server.CreateObject(strClassString)
	If 0 = Err Then IsObjInstalled = True
	Set xTestObj = Nothing
	Err = 0
End Function

'**************************************************
'函数名：SendMail
'作  用：用Jmail组件发送邮件
'参  数：MailtoAddress  ----收信人地址
'        MailtoName    -----收信人姓名
'        Subject       -----主题
'        MailBody      -----信件内容
'        FromName      -----发信人姓名
'        MailFrom      -----发信人地址
'        Priority      -----信件优先级
'**************************************************
function SendMail(MailtoAddress,MailtoName,Subject,MailBody)
	on error resume next
	Dim JMail
	Set JMail=Server.CreateObject("JMAIL.Message")
	if err then
		SendMail= "<br><li>没有安装JMail组件</li>"
		err.clear
		exit function
	end if	
	JMail.Charset="gb2312"          '邮件编码
	JMail.silent=true
	JMail.ContentType = "text/html"     '邮件正文格式
	JMail.ServerAddress=EmailSMTP     '用来发送邮件的SMTP服务器
   	'如果服务器需要SMTP身份验证则还需指定以下参数
	JMail.MailServerUserName = EmailUserName    '登录用户名
   	JMail.MailServerPassWord = EmailPassword        '登录密码
    'JMail.MailDomain = MailDomain       '域名（如果用“name@domain.com”这样的用户名登录时，请指明domain.com
	
	JMail.AddRecipient MailtoAddress,MailtoName     '收信人
	JMail.Subject=Subject         '主题
	JMail.HMTLBody=MailBody       '邮件正文（HTML格式）
	JMail.Body=MailBody          '邮件正文（纯文本格式）
	JMail.FromName=EmailName         '发信人姓名
	JMail.From = EmailAccount         '发信人Email
	JMail.Priority=3              '邮件等级，1为加急，3为普通，5为低级
	JMail.Send(EmailSMTP)
	SendMail =JMail.ErrorMessage
	JMail.Close
	Set JMail=nothing
end function

'**************************************************
'函数名：strLength
'作  用：求字符串长度。汉字算两个字符，英文算一个字符。
'参  数：str  ----要求长度的字符串
'返回值：字符串长度
'**************************************************
function strLength(str)
	ON ERROR RESUME NEXT
	dim WINNT_CHINESE
	WINNT_CHINESE    = (len("中国")=2)
	if WINNT_CHINESE then
        dim l,t,c
        dim i
        l=len(str)
        t=l
        for i=1 to l
        	c=asc(mid(str,i,1))
            if c<0 then c=c+65536
            if c>255 then
                t=t+1
            end if
        next
        strLength=t
    else 
        strLength=len(str)
    end if
    if err.number<>0 then err.clear
end function


'***********************************************
'函数名：JoinChar
'作  用：向地址中加入 ? 或 &
'参  数：strUrl  ----网址
'返回值：加了 ? 或 & 的网址
'pos=InStr(1,"abcdefg","cd") 
'则pos会返回3表示查找到并且位置为第三个字符开始。
'这就是“查找”的实现，而“查找下一个”功能的
'实现就是把当前位置作为起始位置继续查找。
'***********************************************
function JoinChar(strUrl)
	if strUrl="" then
		JoinChar=""
		exit function
	end if
	if InStr(strUrl,"?")<len(strUrl) then 
		if InStr(strUrl,"?")>1 then
			if InStr(strUrl,"&")<len(strUrl) then 
				JoinChar=strUrl & "&"
			else
				JoinChar=strUrl
			end if
		else
			JoinChar=strUrl & "?"
		end if
	else
		JoinChar=strUrl
	end if
end function

Function GetIP() 
	Dim strIPAddr 
	If Request.ServerVariables("HTTP_X_FORWARDED_FOR") = "" Or InStr(Request.ServerVariables("HTTP_X_FORWARDED_FOR"), "unknown") > 0 Then 
		strIPAddr = Request.ServerVariables("REMOTE_ADDR") 
	ElseIf InStr(Request.ServerVariables("HTTP_X_FORWARDED_FOR"), ",") > 0 Then 
		strIPAddr = Mid(Request.ServerVariables("HTTP_X_FORWARDED_FOR"), 1, InStr(Request.ServerVariables("HTTP_X_FORWARDED_FOR"), ",")-1) 
	ElseIf InStr(Request.ServerVariables("HTTP_X_FORWARDED_FOR"), ";") > 0 Then 
		strIPAddr = Mid(Request.ServerVariables("HTTP_X_FORWARDED_FOR"), 1, InStr(Request.ServerVariables("HTTP_X_FORWARDED_FOR"), ";")-1)
	Else 
		strIPAddr = Request.ServerVariables("HTTP_X_FORWARDED_FOR") 
	End If 
	getIP = Checkstr(Trim(Mid(strIPAddr, 1, 30)))
	If getIP="" then getIP="127.0.0.1"
End Function

'删除文件
sub deleteFile(path)
    set fso=server.createobject("scripting.filesystemobject")
    filepath=server.mappath(path)
    if fso.fileexists(filepath) then
       fso.deletefile filepath
    end if
end sub
'删除文件夹
sub deletefolder(path)
    set fso=server.createobject("scripting.filesystemobject")
    filepath=server.mappath(path)
    if fso.folderexists(filepath) then
       fso.deletefolder filepath
    end if
end sub




'------------------------------------------------- 
'函数名称:ReadTextFile 
'作用:利用AdoDb.Stream对象来读取UTF-8格式的文本文件 
'---------------------------------------------------- 
function ReadFromTextFile (FileUrl,CharSet) 
dim str 
set stm=server.CreateObject("adodb.stream") 
stm.Type=2 '以本模式读取 
stm.mode=3 
stm.charset=CharSet 
stm.open 
stm.loadfromfile server.MapPath(FileUrl) 
str=stm.readtext 
stm.Close 
set stm=nothing 
ReadFromTextFile=str 
end function 
'------------------------------------------------- 
'函数名称:WriteToTextFile 
'作用:利用AdoDb.Stream对象来写入UTF-8格式的文本文件 
'---------------------------------------------------- 
Sub WriteToTextFile (FileUrl,byval Str,CharSet) 
set stm=server.CreateObject("adodb.stream") 
stm.Type=2 '以本模式读取 
stm.mode=3 
stm.charset=CharSet 
stm.open 
stm.WriteText str 
stm.SaveToFile server.MapPath(FileUrl),2 
stm.flush 
stm.Close 
set stm=nothing 
end Sub

Sub CreateFolder(FolderPath)
Set fso = CreateObject("Scripting.FileSystemObject") 
if  fso.FolderExists(Server.mappath(FolderPath))=false then  
   fso.createfolder(Server.mappath(FolderPath)) 
end if 
Set fso = nothing
end Sub


'判断是否是整数
Function isInteger(strng) 
   patrn="^\d+$"
   Dim regEx
   Set regEx = New RegExp ' 建立正则表达式。 
   regEx.Pattern = patrn ' 设置模式。 
   regEx.IgnoreCase = False ' 设置是否区分大小写。 
   isInteger= regEx.Test(strng) ' 执行搜索测试。 
End Function

'********************************************
'函数名：IsValidEmail
'作  用：检查Email地址合法性
'参  数：email ----要检查的Email地址
'返回值：True  ----Email地址合法
'       False ----Email地址不合法
'********************************************
function IsValidEmail(email)
	dim names, name, i, c
	IsValidEmail = true
	names = Split(email, "@")
	if UBound(names) <> 1 then
	   IsValidEmail = false
	   exit function
	end if
	for each name in names
		if Len(name) <= 0 then
			IsValidEmail = false
    		exit function
		end if
		for i = 1 to Len(name)
		    c = Lcase(Mid(name, i, 1))
			if InStr("abcdefghijklmnopqrstuvwxyz_-.", c) <= 0 and not IsNumeric(c) then
		       IsValidEmail = false
		       exit function
		     end if
	   next
	   if Left(name, 1) = "." or Right(name, 1) = "." then
    	  IsValidEmail = false
	      exit function
	   end if
	next
	if InStr(names(1), ".") <= 0 then
		IsValidEmail = false
	   exit function
	end if
	i = Len(names(1)) - InStrRev(names(1), ".")
	if i <> 2 and i <> 3 then
	   IsValidEmail = false
	   exit function
	end if
	if InStr(email, "..") > 0 then
	   IsValidEmail = false
	end if
end function


%>