///import editor.js
/**
 * @class baidu.editor.browser     ж
 */

baidu.editor.browser = function(){
    var agent = navigator.userAgent.toLowerCase(),
        opera = window.opera,
        browser = {
        /**
         * ǷΪIE
         * @name baidu.editor.browser.ie
         * @property    ǷΪIE
         * @grammar     baidu.editor.browser.ie
         * @return     {Boolean}    ǷΪie
         */
        ie		: !!window.ActiveXObject,

        /**
         * ǷΪOpera
         * @name baidu.editor.browser.opera
         * @property    ǷΪOpera
         * @grammar     baidu.editor.browser.opera
         * @return     {Boolean}    ǷΪopera
         */
        opera	: ( !!opera && opera.version ),

        /**
         * ǷΪWebKitں
         * @name baidu.editor.browser.webkit
         * @property    ǷΪWebKitں
         * @grammar     baidu.editor.browser.webkit
         * @return     {Boolean}    ǷΪWebKitں
         */
        webkit	: ( agent.indexOf( ' applewebkit/' ) > -1 ),

        /**
         * ǷΪAdobe AIR
         * @name baidu.editor.browser.air
         * @property    ǷΪAdobe AIR
         * @grammar     baidu.editor.browser.air
         * @return     {Boolean}    ǷΪAdobe AIR
         */
        air		: ( agent.indexOf( ' adobeair/' ) > -1 ),

        /**
         * ǷΪMacintoshϵͳ
         * @name baidu.editor.browser.mac
         * @property    ǷΪMacintoshϵͳ
         * @grammar     baidu.editor.browser.mac
         * @return     {Boolean}    ǷΪMacintoshϵͳ
         */
        mac	: ( agent.indexOf( 'macintosh' ) > -1 ),

        /**
         * ǷΪquirksģʽ
         * @name baidu.editor.browser.quirks
         * @property    ǷΪquirksģʽ
         * @grammar     baidu.editor.browser.quirks
         * @return     {Boolean}    ǷΪquirksģʽ
         */
        quirks : ( document.compatMode == 'BackCompat' )
    };

    /**
     * ǷΪGeckoںˣFirefox
     * @name baidu.editor.browser.gecko
     * @property    ǷΪGeckoں
     * @grammar     baidu.editor.browser.gecko
     * @return     {Boolean}    ǷΪGeckoں
     */
    browser.gecko = ( navigator.product == 'Gecko' && !browser.webkit && !browser.opera );

    var version = 0;

    // Internet Explorer 6.0+
    if ( browser.ie )
    {
        version = parseFloat( agent.match( /msie (\d+)/ )[1] );

        /**
         * ǷΪ IE8 
         * @name baidu.editor.browser.IE8
         * @property    ǷΪ IE8 
         * @grammar     baidu.editor.browser.IE8
         * @return     {Boolean}    ǷΪ IE8 
         */
        browser.ie8 = !!document.documentMode;

        /**
         * ǷΪ IE8 ģʽ
         * @name baidu.editor.browser.ie8Compat
         * @property    ǷΪ IE8 ģʽ
         * @grammar     baidu.editor.browser.ie8Compat
         * @return     {Boolean}    ǷΪ IE8 ģʽ
         */
        browser.ie8Compat = document.documentMode == 8;

        /**
         * Ƿ IE7ģʽ
         * @name baidu.editor.browser.ie7Compat
         * @property    ǷΪIE7ģʽ
         * @grammar     baidu.editor.browser.ie7Compat
         * @return     {Boolean}    ǷΪIE7ģʽ
         */
        browser.ie7Compat = ( ( version == 7 && !document.documentMode )
                || document.documentMode == 7 );

        /**
         * ǷIE6ģʽģʽ
         * @name baidu.editor.browser.ie6Compat
         * @property    ǷIE6 ģʽģʽ
         * @grammar     baidu.editor.browser.ie6Compat
         * @return     {Boolean}    ǷΪIE6 ģʽģʽ
         */
        browser.ie6Compat = ( version < 7 || browser.quirks );

    }

    // Gecko.
    if ( browser.gecko )
    {
        var geckoRelease = agent.match( /rv:([\d\.]+)/ );
        if ( geckoRelease )
        {
            geckoRelease = geckoRelease[1].split( '.' );
            version = geckoRelease[0] * 10000 + ( geckoRelease[1] || 0 ) * 100 + ( geckoRelease[2] || 0 ) * 1;
        }
    }
    /**
     * ǷΪchrome
     * @name baidu.editor.browser.chrome
     * @property    ǷΪchrome
     * @grammar     baidu.editor.browser.chrome
     * @return     {Boolean}    ǷΪchrome
     */
    if (/chrome\/(\d+\.\d)/i.test(agent)) {
        browser.chrome = + RegExp['\x241'];
    }
    /**
     * ǷΪsafari
     * @name baidu.editor.browser.safari
     * @property    ǷΪsafari
     * @grammar     baidu.editor.browser.safari
     * @return     {Boolean}    ǷΪsafari
     */
    if(/(\d+\.\d)?(?:\.\d)?\s+safari\/?(\d+\.\d+)?/i.test(agent) && !/chrome/i.test(agent)){
    	browser.safari = + (RegExp['\x241'] || RegExp['\x242']);
    }


    // Opera 9.50+
    if ( browser.opera )
        version = parseFloat( opera.version() );

    // WebKit 522+ (Safari 3+)
    if ( browser.webkit )
        version = parseFloat( agent.match( / applewebkit\/(\d+)/ )[1] );

    /**
     * 汾
     *
     * geckoںİ汾ת( 1.9.0.2 -> 10900).
     *
     * webkitں汾ʹbuild ( 522).
     * @name baidu.editor.browser.version
     * @grammar     baidu.editor.browser.version
     * @return     {Boolean}    汾
     * @example
     * if ( baidu.editor.browser.ie && <b>baidu.editor.browser.version</b> <= 6 )
     *     alert( "Ouch!" );
     */
    browser.version = version;

    /**
     * ǷǼģʽ
     * @name baidu.editor.browser.isCompatible
     * @grammar     baidu.editor.browser.isCompatible
     * @return     {Boolean}    ǷǼģʽ
     * @example
     * if ( baidu.editor.browser.isCompatible )
     *     alert( "Your browser is pretty cool!" );
     */
    browser.isCompatible =
        !browser.mobile && (
        ( browser.ie && version >= 6 ) ||
        ( browser.gecko && version >= 10801 ) ||
        ( browser.opera && version >= 9.5 ) ||
        ( browser.air && version >= 1 ) ||
        ( browser.webkit && version >= 522 ) ||
        false );
    return browser;
}();

