///import editor.js
///import core/utils.js
/**
 * @class baidu.editor.utils     
 */

(function() {
	baidu.editor.utils = {};
	var noop = new Function();
	var utils = baidu.editor.utils =
	/**@lends baidu.editor.utils.prototype*/
	{
		/**
         * objΪԭʹʵ
         * @public
         * @function
         * @param {Object} obj
         * @return {Object} µĶ
         */
		makeInstance: function(obj) {
			noop.prototype = obj;
			obj = new noop;
			noop.prototype = null;
			return obj;
		},
        /**
         * sеչt
         * @public
         * @function
         * @param {Object} t
         * @param {Object} s
         * @param {Boolean} b Ƿ
         * @returns {Object}  t չsԵt
         */
		extend: function(t, s, b) {
			if (s) {
				for (var k in s) {
					if (!b || ! t.hasOwnProperty(k)) {
						t[k] = s[k];
					}
				}
			}
			return t;
		},
		/**
         * жǷΪ
         * @public
         * @function
         * @param {Object} array
         * @return {Boolean} trueΪ飬falseΪ
         */
		isArray: function(array) {
			return Object.prototype.toString.apply(array) === '[object Array]'
		},
		/**
         * жǷΪַ
         * @public
         * @function
         * @param {Object} str
         * @return {Boolean} trueΪַ falseΪַ
         */
		isString: function(str) {
			return typeof str == 'string' || str.constructor == String;
		},
//		/**
//         * Ԫִе
//         * @public
//         * @function
//         * @param {Array|Object} eachable    ҪĶ
//         * @param {Function} iterator        
//         * @param {Object} this_             
//         */
//		each: function(eachable, iterator, this_) {
//			if (utils.isArray(eachable)) {
//				for (var i = 0; i < eachable.length; i++) {
//					iterator.call(this_, eachable[i], i, eachable);
//				}
//			} else {
//				for (var k in eachable) {
//					iterator.call(this_, eachable[k], k, eachable);
//				}
//			}
//		},
		/**
         * subClass̳superClass
         * @public
         * @function
         * @param {Object} subClass       
         * @param {Object} superClass    
         * @return    {Object}    չ¶
         */
		inherits: function(subClass, superClass) {
			var oldP = subClass.prototype;
			var newP = utils.makeInstance(superClass.prototype);
			utils.extend(newP, oldP, true);
			subClass.prototype = newP;
			return (newP.constructor = subClass);
		},

		/**
         * Ϊ󶨺
         * @public
         * @function
         * @param {Function} fn        
         * @param {Object} this_       
         * @return {Function}  󶨺ĺ
         */
		bind: function(fn, this_) {
			return function() {
				return fn.apply(this_, arguments);
			};
		},

		/**
         * ӳִеĺ
         * @public
         * @function
         * @param {Function} fn       Ҫִеĺ
         * @param {Number} delay      ӳʱ䣬λΪ
         * @param {Boolean} exclusion Ƿ񻥳ִУtrueִһdeferʱȰǰһεӳٺɾ
         * @return {Function}    ӳִеĺ
         */
		defer: function(fn, delay, exclusion) {
			var timerID;
			return function() {
				if (exclusion) {
					clearTimeout(timerID);
				}
				timerID = setTimeout(fn, delay);
			};
		},



		/**
         * Ԫе, Ҳ-1
         * @public
         * @function
         * @param {Array} array     Ҫҵ
         * @param {*} item          ҵԪ
         * @param {Number} at       ʼҵλ
         * @returns {Number}        е
         */
		indexOf: function(array, item, at) {
			at = at || 0;
			while (at < array.length) {
				if (array[at] === item) {
					return at;
				}
				at++;
			}
			return - 1;
		},

		/**
         * ƳеԪ
         * @public
         * @function
         * @param {Array} array       ҪɾԪص
         * @param {*} item            ҪɾԪ
         */
		removeItem: function(array, item) {
			var k = array.length;
			if (k) while (k--) {
				if (array[k] === item) {
					array.splice(k, 1);
					break;
				}
			}
		},

		/**
         * ɾַβո
         * @public
         * @function
         * @param {String} str        ַ
         * @return {String} str       ɾոַ
         */
		trim: function() {
			// "non-breaking spaces" &nbsp;ܱԲ\s
			var trimRegex = /(^[ \t\n\r]+)|([ \t\n\r]+$)/g;
			return function(str) {
				return str.replace(trimRegex, '');
			};
		}(),

		/**
         * ַתhashmap
         * @public
         * @function
         * @param {String} list       ַԡ
         * @returns {Object}          תhashmapĶ
         */
		listToMap: function(list) {
			if (!list) {
				return {};
			}
			var array = list.split(/,/g),
			k = array.length,
			map = {};
			if (k) while (k--) {
				map[array[k]] = 1;
			}
			return map;
		},

		/**
         * strеhtmlת
         * @public
         * @function
         * @param {String} str      Ҫתַ
         * @returns {String}        תַ
         */
		unhtml: function() {
			var map = {
				'<': '&lt;',
				'&': '&amp',
				'"': '&quot;',
				'>': '&gt;'
			};
			function rep(m) {
				return map[m];
			}
			return function(str) {
				return str ? str.replace(/[&<">]/g, rep) : '';
			};
		}(),

		/**
         * cssʽתΪշʽfont-size -> fontSize
         * @public
         * @function
         * @param {String} cssName      Ҫתʽ
         * @returns {String}        תʽ
         */
		cssStyleToDomStyle: function() {
			var test = document.createElement('div').style,
			cssFloat = test.cssFloat != undefined ? 'cssFloat': test.styleFloat != undefined ? 'styleFloat': 'float',
			cache = {
				'float': cssFloat
			};
			function replacer(match) {
				return match.charAt(1).toUpperCase();
			}
			return function(cssName) {
				return cache[cssName] || (cache[cssName] = cssName.toLowerCase().replace(/-./g, replacer));
			};
		}(),
		/**
         * cssļִлص
         * @public
         * @function
         * @param {document}   doc  document
         * @param {String}    path  ļ·
         * @param {Function}   fun  ص
         * @param {String}     id   Ԫid
         */
        loadFile : function(doc,obj,fun){
            if (obj.id && doc.getElementById(obj.id)) {
				return;
			}
            var element = doc.createElement(obj.tag);
            delete obj.tag;
            for(var p in obj){
                element.setAttribute(p,obj[p]);
            }
			element.onload = element.onreadystatechange = function() {
				if (!this.readyState || this.readyState == 'loaded' || this.readyState == 'complete') {
					if (fun) fun();
					element.onload = element.onreadystatechange = null;
				}
			};

			doc.getElementsByTagName("head")[0].appendChild(element);

        },
        isEmptyObject : function(obj){
            for ( var p in obj ) {
                return false;
            }
            return true;
        },
        fixColor : function (name, value) {
            if (/color/i.test(name) && /rgba?/.test(value)) {
                var array = value.split(",");
                if (array.length > 3)
                    return "";
                value = "#";
                for (var i = 0, color; color = array[i++];) {
                    color = parseInt(color.replace(/[^\d]/gi, ''), 10).toString(16);
                    value += color.length == 1 ? "0" + color : color;
                }

                value = value.toUpperCase();
            }
            return  value;
        }

	}
})();


