﻿using System;
using System.Data;
using System.Xml;
using System.Data.Common;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;

public static class DbHelper
{
    public static DbProviderFactory m_factory;
    public static string connstr = ConfigurationManager.ConnectionStrings["cms"].ConnectionString;
    public static DbProviderFactory Factory
    {
        get
        {
            if (m_factory == null)
            {
                string provider = ConfigurationManager.ConnectionStrings["cms"].ProviderName;
                m_factory = DbProviderFactories.GetFactory(provider);
            }
            return m_factory;
        }
    }
    public static DbDataReader ExecuteReader(string commandText)
    {
        return ExecuteReader(commandText, null);
    }
    public static DbDataReader ExecuteReader(string commandText, DbParameter[] paras)
    {
        DbConnection conn = Factory.CreateConnection();
        conn.ConnectionString = connstr;
        conn.Open();
        DbCommand comm = conn.CreateCommand();
        comm.CommandText = commandText;
        if (paras != null)
          {
             for(int i=0;i<paras.Length;i++){
                comm.Parameters.Add(paras[i]);
             }
          }
       return comm.ExecuteReader(CommandBehavior.CloseConnection);
    }

    public static DataTable ExecuteDataTable(string commandText)
    {
        return ExecuteDataTable(commandText,null);
    }
    public static DataTable ExecuteDataTable(string commandText, DbParameter[] paras)
    {
        DbConnection conn = Factory.CreateConnection();
        conn.ConnectionString = connstr;
        conn.Open();
        DbCommand comm = conn.CreateCommand();
        comm.CommandText = commandText;
        if (paras != null)
        {
            for (int i = 0; i < paras.Length; i++)
            {
                comm.Parameters.Add(paras[i]);
            }
        }
        DbDataAdapter ad = Factory.CreateDataAdapter();
        ad.SelectCommand = comm;
        DataSet ds = new DataSet();
        ad.Fill(ds);
        ad.Dispose();
        comm.Dispose();
        conn.Dispose();
        DataTable dt= null;
        if (ds != null && ds.Tables.Count > 0)
        {
            dt = ds.Tables[0];
        }
        return dt;
       

    }

    public static object ExecuteScalar(string commandText)
    {
        return ExecuteScalar(commandText,null);
    }
    public static object ExecuteScalar(string commandText, DbParameter[] paras)
    {
        DbConnection conn = Factory.CreateConnection();
        conn.ConnectionString = connstr;
        conn.Open();
        DbCommand comm = conn.CreateCommand();
        comm.CommandText = commandText;
        if (paras != null)
        {
            for (int i = 0; i < paras.Length; i++)
            {
                comm.Parameters.Add(paras[i]);
            }
        }
        object flag = comm.ExecuteScalar();
        comm.Dispose();
        conn.Dispose();
        return flag;
    }

    public static int ExecuteNonQuery(string commandText)
    {
        return ExecuteNonQuery(commandText,null);
    }
    public static int ExecuteNonQuery(string commandText, DbParameter[] paras)
    {
        DbConnection conn = Factory.CreateConnection();
        conn.ConnectionString = connstr;
        conn.Open();
        DbCommand comm = conn.CreateCommand();
        comm.CommandText = commandText;
        if (paras != null)
        {
            for (int i = 0; i < paras.Length; i++)
            {
                comm.Parameters.Add(paras[i]);
            }
        }
        int flag = comm.ExecuteNonQuery();
        comm.Dispose();
        conn.Dispose();
        return flag;
    }

}