﻿using System;
using System.Drawing;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Security.Cryptography;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using System.Web.UI;
using Microsoft.VisualBasic;
using System.Collections;
using System.Net;
using System.Runtime.Serialization.Formatters.Binary;
using System.Collections.Specialized;
using System.Data;
/// <summary>
///Utils 的摘要说明
/// </summary>
public class Utils
{
    private static Regex RegexBr = new Regex(@"(\r\n)", RegexOptions.IgnoreCase);

    public static Regex RegexFont = new Regex(@"<font color=" + "\".*?\"" + @">([\s\S]+?)</font>", Utils.GetRegexCompiledOptions());

    private static FileVersionInfo AssemblyFileVersion = FileVersionInfo.GetVersionInfo(Assembly.GetExecutingAssembly().Location);

    private static string TemplateCookieName = string.Format("dnttemplateid_{0}_{1}_{2}", AssemblyFileVersion.FileMajorPart, AssemblyFileVersion.FileMinorPart, AssemblyFileVersion.FileBuildPart);

    /// <summary>
    /// 得到正则编译参数设置
    /// </summary>
    /// <returns>参数设置</returns>
    public static RegexOptions GetRegexCompiledOptions()
    {
        return RegexOptions.None;
    }

    public string Block(int id)
    {
        string str = "";
        try
        {
           
            DataRow dr1 = DbHelper.ExecuteDataTable("select top 1 * from block where id=" + id).Rows[0];
            if (dr1 == null)
            {
                return str;
            }

            if (dr1["typeid"].ToString() == "2")
            {
                return dr1["cont"].ToString();
            }


            DataTable dt = DbHelper.ExecuteDataTable(dr1["sql"].ToString());
            if (dt == null || dt.Rows.Count == 0)
            {
                return str;
            }


            str += "";
            foreach (DataRow item in dt.Rows)
            {
                string t1 = dr1["temp"].ToString();
                Regex reg = new Regex(@"{([a-zA-Z0-9_-]+)}");

                Match m = reg.Match(t1);
                while (m.Success)
                {
                    if (m.Groups[1].Value.Contains("date"))
                    {
                        t1 = t1.Replace(m.Groups[0].Value, GetDate(item[m.Groups[1].Value].ToString()));
                    }
                    t1 = t1.Replace(m.Groups[0].Value, item[m.Groups[1].Value].ToString());
                    m = reg.Match(t1);
                }
                str += t1;
            }
        }
        catch
        {
        }
        
        return str;
    }

    /// <summary>
    /// 返回字符串真实长度, 1个汉字长度为2
    /// </summary>
    /// <returns>字符长度</returns>
    public static int GetStringLength(string str)
    {
        return Encoding.Default.GetBytes(str).Length;
    }

    public static  NameValueCollection GetQueryParameters(string queryString)
    {
        if (queryString.StartsWith("?"))
        {
            queryString = queryString.Remove(0, 1);
        }
        NameValueCollection result = new NameValueCollection();
        if (!string.IsNullOrEmpty(queryString))
        {
            string[] p = queryString.Split('&');
            foreach (string s in p)
            {
                if (!string.IsNullOrEmpty(s))
                {
                    if (s.IndexOf('=') > -1)
                    {
                        string[] temp = s.Split('=');
                        result.Add(temp[0], temp[1]);
                    }
                }
            }
        }

        return result;
    }
   

    /// <summary>
    /// 判断指定字符串在指定字符串数组中的位置
    /// </summary>
    /// <param name="strSearch">字符串</param>
    /// <param name="stringArray">字符串数组</param>
    /// <param name="caseInsensetive">是否不区分大小写, true为不区分, false为区分</param>
    /// <returns>字符串在指定字符串数组中的位置, 如不存在则返回-1</returns>
    public static int GetInArrayID(string strSearch, string[] stringArray, bool caseInsensetive)
    {
        for (int i = 0; i < stringArray.Length; i++)
        {
            if (caseInsensetive)
            {
                if (strSearch.ToLower() == stringArray[i].ToLower())
                    return i;
            }
            else if (strSearch == stringArray[i])
                return i;
        }
        return -1;
    }


    /// <summary>
    /// 判断指定字符串在指定字符串数组中的位置
    /// </summary>
    /// <param name="strSearch">字符串</param>
    /// <param name="stringArray">字符串数组</param>
    /// <returns>字符串在指定字符串数组中的位置, 如不存在则返回-1</returns>		
    public static int GetInArrayID(string strSearch, string[] stringArray)
    {
        return GetInArrayID(strSearch, stringArray, true);
    }

    /// <summary>
    /// 判断指定字符串是否属于指定字符串数组中的一个元素
    /// </summary>
    /// <param name="strSearch">字符串</param>
    /// <param name="stringArray">字符串数组</param>
    /// <param name="caseInsensetive">是否不区分大小写, true为不区分, false为区分</param>
    /// <returns>判断结果</returns>
    public static bool InArray(string strSearch, string[] stringArray, bool caseInsensetive)
    {
        return GetInArrayID(strSearch, stringArray, caseInsensetive) >= 0;
    }

    /// <summary>
    /// 判断指定字符串是否属于指定字符串数组中的一个元素
    /// </summary>
    /// <param name="str">字符串</param>
    /// <param name="stringarray">字符串数组</param>
    /// <returns>判断结果</returns>
    public static bool InArray(string str, string[] stringarray)
    {
        return InArray(str, stringarray, false);
    }

    public static bool InArray(string str, string stringarray)
    {
        return InArray(str, stringarray.Split(','));
    }
 
    


    /// <summary>
    /// 删除字符串尾部的回车/换行/空格
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static string RTrim(string str)
    {
        for (int i = str.Length; i >= 0; i--)
        {
            if (str[i].Equals(" ") || str[i].Equals("\r") || str[i].Equals("\n"))
            {
                str.Remove(i, 1);
            }
        }
        return str;
    }


    /// <summary>
    /// 清除给定字符串中的回车及换行符
    /// </summary>
    /// <param name="str">要清除的字符串</param>
    /// <returns>清除后返回的字符串</returns>
    public static string ClearBR(string str)
    {
        Match m = null;

        for (m = RegexBr.Match(str); m.Success; m = m.NextMatch())
        {
            str = str.Replace(m.Groups[0].ToString(), "");
        }
        return str;
    }

    /// <summary>
    /// 从字符串的指定位置截取指定长度的子字符串
    /// </summary>
    /// <param name="str">原字符串</param>
    /// <param name="startIndex">子字符串的起始位置</param>
    /// <param name="length">子字符串的长度</param>
    /// <returns>子字符串</returns>
    public static string CutString(string str, int startIndex, int length)
    {
        if (startIndex >= 0)
        {
            if (length < 0)
            {
                length = length * -1;
                if (startIndex - length < 0)
                {
                    length = startIndex;
                    startIndex = 0;
                }
                else
                    startIndex = startIndex - length;
            }

            if (startIndex > str.Length)
                return "";
        }
        else
        {
            if (length < 0)
                return "";
            else
            {
                if (length + startIndex > 0)
                {
                    length = length + startIndex;
                    startIndex = 0;
                }
                else
                    return "";
            }
        }

        if (str.Length - startIndex < length)
            length = str.Length - startIndex;

        return str.Substring(startIndex, length);
    }

    /// <summary>
    /// 从字符串的指定位置开始截取到字符串结尾的了符串
    /// </summary>
    /// <param name="str">原字符串</param>
    /// <param name="startIndex">子字符串的起始位置</param>
    /// <returns>子字符串</returns>
    public static string CutString(string str, int startIndex)
    {
        return CutString(str, startIndex, str.Length);
    }



    /// <summary>
    /// 获得当前绝对路径
    /// </summary>
    /// <param name="strPath">指定的路径</param>
    /// <returns>绝对路径</returns>
    public static string GetMapPath(string strPath)
    {
        if (HttpContext.Current != null)
        {
            return HttpContext.Current.Server.MapPath(strPath);
        }
        else //非web程序引用
        {
            strPath = strPath.Replace("/", "\\");
            if (strPath.StartsWith("\\"))
            {
                strPath = strPath.Substring(strPath.IndexOf('\\', 1)).TrimStart('\\');
            }
            return System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, strPath);
        }
    }



    /// <summary>
    /// 返回文件是否存在
    /// </summary>
    /// <param name="filename">文件名</param>
    /// <returns>是否存在</returns>
    public static bool FileExists(string filename)
    {
        return System.IO.File.Exists(filename);
    }



    /// <summary>
    /// 以指定的ContentType输出指定文件文件
    /// </summary>
    /// <param name="filepath">文件路径</param>
    /// <param name="filename">输出的文件名</param>
    /// <param name="filetype">将文件输出时设置的ContentType</param>
    public static void ResponseFile(string filepath, string filename, string filetype)
    {
        Stream iStream = null;

        // 缓冲区为10k
        byte[] buffer = new Byte[10000];
        // 文件长度
        int length;
        // 需要读的数据长度
        long dataToRead;

        try
        {
            // 打开文件
            iStream = new FileStream(filepath, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);

            // 需要读的数据长度
            dataToRead = iStream.Length;

            HttpContext.Current.Response.ContentType = filetype;
            HttpContext.Current.Response.AddHeader("Content-Disposition", "attachment;filename=" + Utils.UrlEncode(filename.Trim()).Replace("+", " "));

            while (dataToRead > 0)
            {
                // 检查客户端是否还处于连接状态
                if (HttpContext.Current.Response.IsClientConnected)
                {
                    length = iStream.Read(buffer, 0, 10000);
                    HttpContext.Current.Response.OutputStream.Write(buffer, 0, length);
                    HttpContext.Current.Response.Flush();
                    buffer = new Byte[10000];
                    dataToRead = dataToRead - length;
                }
                else
                {
                    // 如果不再连接则跳出死循环
                    dataToRead = -1;
                }
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("Error : " + ex.Message);
        }
        finally
        {
            if (iStream != null)
            {
                // 关闭文件
                iStream.Close();
            }
        }
        HttpContext.Current.Response.End();
    }

    /// <summary>
    /// 判断文件名是否为浏览器可以直接显示的图片文件名
    /// </summary>
    /// <param name="filename">文件名</param>
    /// <returns>是否可以直接显示</returns>
    public static bool IsImgFilename(string filename)
    {
        filename = filename.Trim();
        if (filename.EndsWith(".") || filename.IndexOf(".") == -1)
            return false;

        string extname = filename.Substring(filename.LastIndexOf(".") + 1).ToLower();
        return (extname == "jpg" || extname == "jpeg" || extname == "png" || extname == "bmp" || extname == "gif");
    }


    /// <summary>
    /// int型转换为string型
    /// </summary>
    /// <returns>转换后的string类型结果</returns>
    public static string IntToStr(int intValue)
    {
        return Convert.ToString(intValue);
    }
    /// <summary>
    /// MD5函数
    /// </summary>
    /// <param name="str">原始字符串</param>
    /// <returns>MD5结果</returns>
    public static string MD5(string str)
    {
        byte[] b = Encoding.UTF8.GetBytes(str);
        b = new MD5CryptoServiceProvider().ComputeHash(b);
        string ret = "";
        for (int i = 0; i < b.Length; i++)
            ret += b[i].ToString("x").PadLeft(2, '0');

        return ret;
    }

    /// <summary>
    /// SHA256函数
    /// </summary>
    /// /// <param name="str">原始字符串</param>
    /// <returns>SHA256结果</returns>
    public static string SHA256(string str)
    {
        byte[] SHA256Data = Encoding.UTF8.GetBytes(str);
        SHA256Managed Sha256 = new SHA256Managed();
        byte[] Result = Sha256.ComputeHash(SHA256Data);
        return Convert.ToBase64String(Result);  //返回长度为44字节的字符串
    }

    /// <summary>
    /// 字符串如果操过指定长度则将超出的部分用指定字符串代替
    /// </summary>
    /// <param name="p_SrcString">要检查的字符串</param>
    /// <param name="p_Length">指定长度</param>
    /// <param name="p_TailString">用于替换的字符串</param>
    /// <returns>截取后的字符串</returns>
    public static string GetSubString(string p_SrcString, int p_Length, string p_TailString)
    {
        return GetSubString(p_SrcString, 0, p_Length, p_TailString);
    }

    public static string GetUnicodeSubString(string str, int len, string p_TailString)
    {
        string result = string.Empty;// 最终返回的结果
        int byteLen = System.Text.Encoding.Default.GetByteCount(str);// 单字节字符长度
        int charLen = str.Length;// 把字符平等对待时的字符串长度
        int byteCount = 0;// 记录读取进度
        int pos = 0;// 记录截取位置
        if (byteLen > len)
        {
            for (int i = 0; i < charLen; i++)
            {
                if (Convert.ToInt32(str.ToCharArray()[i]) > 255)// 按中文字符计算加2
                    byteCount += 2;
                else// 按英文字符计算加1
                    byteCount += 1;
                if (byteCount > len)// 超出时只记下上一个有效位置
                {
                    pos = i;
                    break;
                }
                else if (byteCount == len)// 记下当前位置
                {
                    pos = i + 1;
                    break;
                }
            }

            if (pos >= 0)
                result = str.Substring(0, pos) + p_TailString;
        }
        else
            result = str;

        return result;
    }

    /// <summary>
    /// 取指定长度的字符串
    /// </summary>
    /// <param name="p_SrcString">要检查的字符串</param>
    /// <param name="p_StartIndex">起始位置</param>
    /// <param name="p_Length">指定长度</param>
    /// <param name="p_TailString">用于替换的字符串</param>
    /// <returns>截取后的字符串</returns>
    public static string GetSubString(string p_SrcString, int p_StartIndex, int p_Length, string p_TailString)
    {
        string myResult = p_SrcString;

        Byte[] bComments = Encoding.UTF8.GetBytes(p_SrcString);
        foreach (char c in Encoding.UTF8.GetChars(bComments))
        {    //当是日文或韩文时(注:中文的范围:\u4e00 - \u9fa5, 日文在\u0800 - \u4e00, 韩文为\xAC00-\xD7A3)
            if ((c > '\u0800' && c < '\u4e00') || (c > '\xAC00' && c < '\xD7A3'))
            {
                //if (System.Text.RegularExpressions.Regex.IsMatch(p_SrcString, "[\u0800-\u4e00]+") || System.Text.RegularExpressions.Regex.IsMatch(p_SrcString, "[\xAC00-\xD7A3]+"))
                //当截取的起始位置超出字段串长度时
                if (p_StartIndex >= p_SrcString.Length)
                    return "";
                else
                    return p_SrcString.Substring(p_StartIndex,
                                                   ((p_Length + p_StartIndex) > p_SrcString.Length) ? (p_SrcString.Length - p_StartIndex) : p_Length);
            }
        }

        if (p_Length >= 0)
        {
            byte[] bsSrcString = Encoding.Default.GetBytes(p_SrcString);

            //当字符串长度大于起始位置
            if (bsSrcString.Length > p_StartIndex)
            {
                int p_EndIndex = bsSrcString.Length;

                //当要截取的长度在字符串的有效长度范围内
                if (bsSrcString.Length > (p_StartIndex + p_Length))
                {
                    p_EndIndex = p_Length + p_StartIndex;
                }
                else
                {   //当不在有效范围内时,只取到字符串的结尾

                    p_Length = bsSrcString.Length - p_StartIndex;
                    p_TailString = "";
                }

                int nRealLength = p_Length;
                int[] anResultFlag = new int[p_Length];
                byte[] bsResult = null;

                int nFlag = 0;
                for (int i = p_StartIndex; i < p_EndIndex; i++)
                {
                    if (bsSrcString[i] > 127)
                    {
                        nFlag++;
                        if (nFlag == 3)
                            nFlag = 1;
                    }
                    else
                        nFlag = 0;

                    anResultFlag[i] = nFlag;
                }

                if ((bsSrcString[p_EndIndex - 1] > 127) && (anResultFlag[p_Length - 1] == 1))
                    nRealLength = p_Length + 1;

                bsResult = new byte[nRealLength];

                Array.Copy(bsSrcString, p_StartIndex, bsResult, 0, nRealLength);

                myResult = Encoding.Default.GetString(bsResult);
                myResult = myResult + p_TailString;
            }
        }

        return myResult;
    }

    /// <summary>
    /// 自定义的替换字符串函数
    /// </summary>
    public static string ReplaceString(string SourceString, string SearchString, string ReplaceString, bool IsCaseInsensetive)
    {
        return Regex.Replace(SourceString, Regex.Escape(SearchString), ReplaceString, IsCaseInsensetive ? RegexOptions.IgnoreCase : RegexOptions.None);
    }

    /// <summary>
    /// 生成指定数量的html空格符号
    /// </summary>
    public static string GetSpacesString(int spacesCount)
    {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < spacesCount; i++)
        {
            sb.Append(" &nbsp;&nbsp;");
        }
        return sb.ToString();
    }

    /// <summary>
    /// 检测是否符合email格式
    /// </summary>
    /// <param name="strEmail">要判断的email字符串</param>
    /// <returns>判断结果</returns>
    public static bool IsValidEmail(string strEmail)
    {
        return Regex.IsMatch(strEmail, @"^[\w\.]+([-]\w+)*@[A-Za-z0-9-_]+[\.][A-Za-z0-9-_]");
    }

    public static bool IsValidDoEmail(string strEmail)
    {
        return Regex.IsMatch(strEmail, @"^@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$");
    }

    /// <summary>
    /// 检测是否是正确的Url
    /// </summary>
    /// <param name="strUrl">要验证的Url</param>
    /// <returns>判断结果</returns>
    public static bool IsURL(string strUrl)
    {
        return Regex.IsMatch(strUrl, @"^(http|https)\://([a-zA-Z0-9\.\-]+(\:[a-zA-Z0-9\.&%\$\-]+)*@)*((25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])|localhost|([a-zA-Z0-9\-]+\.)*[a-zA-Z0-9\-]+\.(com|edu|gov|int|mil|net|org|biz|arpa|info|name|pro|aero|coop|museum|[a-zA-Z]{1,10}))(\:[0-9]+)*(/($|[a-zA-Z0-9\.\,\?\'\\\+&%\$#\=~_\-]+))*$");
    }

    public static string GetEmailHostName(string strEmail)
    {
        if (strEmail.IndexOf("@") < 0)
        {
            return "";
        }
        return strEmail.Substring(strEmail.LastIndexOf("@")).ToLower();
    }

    /// <summary>
    /// 判断是否为base64字符串
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static bool IsBase64String(string str)
    {
        //A-Z, a-z, 0-9, +, /, =
        return Regex.IsMatch(str, @"[A-Za-z0-9\+\/\=]");
    }
    /// <summary>
    /// 检测是否有Sql危险字符
    /// </summary>
    /// <param name="str">要判断字符串</param>
    /// <returns>判断结果</returns>
    public static bool IsSafeSqlString(string str)
    {
        return !Regex.IsMatch(str, @"[-|;|,|\/|\(|\)|\[|\]|\}|\{|%|@|\*|!|\']");
    }

    /// <summary>
    /// 检测是否有危险的可能用于链接的字符串
    /// </summary>
    /// <param name="str">要判断字符串</param>
    /// <returns>判断结果</returns>
    public static bool IsSafeUserInfoString(string str)
    {
        return !Regex.IsMatch(str, @"^\s*$|^c:\\con\\con$|[%,\*" + "\"" + @"\s\t\<\>\&]|游客|^Guest");
    }

    /// <summary>
    /// 清理字符串
    /// </summary>
    public static string CleanInput(string strIn)
    {
        return Regex.Replace(strIn.Trim(), @"[^\w\.@-]", "");
    }

    /// <summary>
    /// 返回URL中结尾的文件名
    /// </summary>		
    public static string GetFilename(string url)
    {
        if (url == null)
        {
            return "";
        }
        string[] strs1 = url.Split(new char[] { '/' });
        return strs1[strs1.Length - 1].Split(new char[] { '?' })[0];
    }

    /// <summary>
    /// 根据阿拉伯数字返回月份的名称(可更改为某种语言)
    /// </summary>	
    public static string[] Monthes
    {
        get
        {
            return new string[] { "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" };
        }
    }

    /// <summary>
    /// 替换回车换行符为html换行符
    /// </summary>
    public static string StrFormat(string str)
    {
        string str2;

        if (str == null)
        {
            str2 = "";
        }
        else
        {
            str = str.Replace("\r\n", "<br />");
            str = str.Replace("\n", "<br />");
            str2 = str;
        }
        return str2;
    }

    /// <summary>
    /// 返回标准日期格式string
    /// </summary>
    public static string GetDate()
    {
        return DateTime.Now.ToString("yyyy-MM-dd");
    }
    public string GetDate(object e)
    {
        return GetDate(e, "yyyy-MM-dd");
    }
    public string GetDate(object e, string key)
    {
        string str = "";
        try
        {
            str = Convert.ToDateTime(e).ToString(key);
        }
        catch
        {

        }
        return str;
    }

    public string GetName(string tb, object id, string field)
    {
        try
        {
            return DbHelper.ExecuteScalar(string.Format("select {2} from {0} where id={1}", tb, id, field)).ToString();
        }
        catch
        {
            return "";
        }
    }
    public string GetName(string tb, object id)
    {
        return GetName(tb, id, "title");
    }

    /// <summary>
    /// 返回指定日期格式
    /// </summary>
    public static string GetDate(string datetimestr, string replacestr)
    {
        if (datetimestr == null)
            return replacestr;

        if (datetimestr.Equals(""))
            return replacestr;

        try
        {
            datetimestr = Convert.ToDateTime(datetimestr).ToString("yyyy-MM-dd").Replace("1900-01-01", replacestr);
        }
        catch
        {
            return replacestr;
        }
        return datetimestr;
    }


    /// <summary>
    /// 返回标准时间格式string
    /// </summary>
    public static string GetTime()
    {
        return DateTime.Now.ToString("HH:mm:ss");
    }

    /// <summary>
    /// 返回标准时间格式string
    /// </summary>
    public static string GetDateTime()
    {
        return DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
    }

    /// <summary>
    /// 返回相对于当前时间的相对天数
    /// </summary>
    public static string GetDateTime(int relativeday)
    {
        return DateTime.Now.AddDays(relativeday).ToString("yyyy-MM-dd HH:mm:ss");
    }

    /// <summary>
    /// 返回标准时间格式string
    /// </summary>
    public static string GetDateTimeF()
    {
        return DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss:fffffff");
    }

    /// <summary>
    /// 返回标准时间 
    /// </sumary>
    public static string GetStandardDateTime(string fDateTime, string formatStr)
    {
        if (fDateTime == "0000-0-0 0:00:00")
            return fDateTime;
        DateTime time = new DateTime(1900, 1, 1, 0, 0, 0, 0);
        if (DateTime.TryParse(fDateTime, out time))
            return time.ToString(formatStr);
        else
            return "N/A";
    }

    /// <summary>
    /// 返回标准时间 yyyy-MM-dd HH:mm:ss
    /// </sumary>
    public static string GetStandardDateTime(string fDateTime)
    {
        return GetStandardDateTime(fDateTime, "yyyy-MM-dd HH:mm:ss");
    }

    /// <summary>
    /// 返回标准时间 yyyy-MM-dd
    /// </sumary>
    public static string GetStandardDate(string fDate)
    {
        return GetStandardDateTime(fDate, "yyyy-MM-dd");
    }

    /// <summary>
    /// 
    /// </summary>
    /// <returns></returns>
    public static bool IsTime(string timeval)
    {
        return Regex.IsMatch(timeval, @"^((([0-1]?[0-9])|(2[0-3])):([0-5]?[0-9])(:[0-5]?[0-9])?)$");
    }


    public static string GetRealIP()
    {
        string result = HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"];
        if (string.IsNullOrEmpty(result))
            result = HttpContext.Current.Request.ServerVariables["HTTP_X_FORWARDED_FOR"];

        if (string.IsNullOrEmpty(result))
            result = HttpContext.Current.Request.UserHostAddress;

        if (string.IsNullOrEmpty(result) || !Utils.IsIP(result))
            return "127.0.0.1";

        return result;
    }

    /// <summary>
    /// 改正sql语句中的转义字符
    /// </summary>
    public static string mashSQL(string str)
    {
        return (str == null) ? "" : str.Replace("\'", "'");
    }

    /// <summary>
    /// 替换sql语句中的有问题符号
    /// </summary>
    public static string ChkSQL(string str)
    {
        return (str == null) ? "" : str.Replace("'", "''");
    }


    /// <summary>
    /// 转换为静态html
    /// </summary>
    public void transHtml(string path, string outpath)
    {
        Page page = new Page();
        StringWriter writer = new StringWriter();
        page.Server.Execute(path, writer);
        FileStream fs;
        if (File.Exists(page.Server.MapPath("") + "\\" + outpath))
        {
            File.Delete(page.Server.MapPath("") + "\\" + outpath);
            fs = File.Create(page.Server.MapPath("") + "\\" + outpath);
        }
        else
        {
            fs = File.Create(page.Server.MapPath("") + "\\" + outpath);
        }
        byte[] bt = Encoding.Default.GetBytes(writer.ToString());
        fs.Write(bt, 0, bt.Length);
        fs.Close();
    }


    
 

    /// <summary>
    /// 过滤字符串数组中每个元素为合适的大小
    /// 当长度小于minLength时，忽略掉,-1为不限制最小长度
    /// 当长度大于maxLength时，取其前maxLength位
    /// 如果数组中有null元素，会被忽略掉
    /// </summary>
    /// <param name="minLength">单个元素最小长度</param>
    /// <param name="maxLength">单个元素最大长度</param>
    /// <returns></returns>
    public static string[] PadStringArray(string[] strArray, int minLength, int maxLength)
    {
        if (minLength > maxLength)
        {
            int t = maxLength;
            maxLength = minLength;
            minLength = t;
        }

        int iMiniStringCount = 0;
        for (int i = 0; i < strArray.Length; i++)
        {
            if (minLength > -1 && strArray[i].Length < minLength)
            {
                strArray[i] = null;
                continue;
            }
            if (strArray[i].Length > maxLength)
                strArray[i] = strArray[i].Substring(0, maxLength);

            iMiniStringCount++;
        }

        string[] result = new string[iMiniStringCount];
        for (int i = 0, j = 0; i < strArray.Length && j < result.Length; i++)
        {
            if (strArray[i] != null && strArray[i] != string.Empty)
            {
                result[j] = strArray[i];
                j++;
            }
        }
        return result;
    }

    

    

    /// <summary>
    /// 清除字符串数组中的重复项
    /// </summary>
    /// <param name="strArray">字符串数组</param>
    /// <param name="maxElementLength">字符串数组中单个元素的最大长度</param>
    /// <returns></returns>
    public static string[] DistinctStringArray(string[] strArray, int maxElementLength)
    {
        Hashtable h = new Hashtable();

        foreach (string s in strArray)
        {
            string k = s;
            if (maxElementLength > 0 && k.Length > maxElementLength)
            {
                k = k.Substring(0, maxElementLength);
            }
            h[k.Trim()] = s;
        }

        string[] result = new string[h.Count];

        h.Keys.CopyTo(result, 0);

        return result;
    }

    /// <summary>
    /// 清除字符串数组中的重复项
    /// </summary>
    /// <param name="strArray">字符串数组</param>
    /// <returns></returns>
    public static string[] DistinctStringArray(string[] strArray)
    {
        return DistinctStringArray(strArray, 0);
    }

    /// <summary>
    /// 替换html字符
    /// </summary>
    public static string EncodeHtml(string strHtml)
    {
        if (strHtml != "")
        {
            strHtml = strHtml.Replace(",", "&def");
            strHtml = strHtml.Replace("'", "&dot");
            strHtml = strHtml.Replace(";", "&dec");
            return strHtml;
        }
        return "";
    }

    

     
     
    

    /// <summary>
    /// 获得页码显示链接
    /// </summary>
    /// <param name="curPage">当前页数</param>
    /// <param name="countPage">总页数</param>
    /// <param name="url">超级链接地址</param>
    /// <param name="extendPage">周边页码显示个数上限</param>
    /// <returns>页码html</returns>
    public static string GetPageNumbers(int curPage, int countPage, string url, int extendPage)
    {
        return GetPageNumbers(curPage, countPage, url, extendPage, "page");
    }

    /// <summary>
    /// 获得页码显示链接
    /// </summary>
    /// <param name="curPage">当前页数</param>
    /// <param name="countPage">总页数</param>
    /// <param name="url">超级链接地址</param>
    /// <param name="extendPage">周边页码显示个数上限</param>
    /// <param name="pagetag">页码标记</param>
    /// <returns>页码html</returns>
    public static string GetPageNumbers(int curPage, int countPage, string url, int extendPage, string pagetag)
    {
        return GetPageNumbers(curPage, countPage, url, extendPage, pagetag, null);
    }

    /// <summary>
    /// 获得页码显示链接
    /// </summary>
    /// <param name="curPage">当前页数</param>
    /// <param name="countPage">总页数</param>
    /// <param name="url">超级链接地址</param>
    /// <param name="extendPage">周边页码显示个数上限</param>
    /// <param name="pagetag">页码标记</param>
    /// <param name="anchor">锚点</param>
    /// <returns>页码html</returns>
    public static string GetPageNumbers(int curPage, int countPage, string url, int extendPage, string pagetag, string anchor)
    {

        if (pagetag == "")
            pagetag = "page";
        int startPage = 1;
        int endPage = 1;
      
          if (url.IndexOf("?") >-1)
            url = url + "&";
        else
            url = url + "?";
       
        string t1 = "<li><a href=\"" + url + "&" + pagetag + "=1";
        string t2 = "<li><a href=\"" + url + "&" + pagetag + "=" + countPage;
        if (anchor != null)
        {
            t1 += anchor;
            t2 += anchor;
        }
        t1 += "\">&laquo;</a></li>";
        t2 += "\">&raquo;</a></li>";

        if (countPage < 1)
            countPage = 1;
        if (countPage == 1)
        {
            return "";
        }

        if (extendPage < 3)
            extendPage = 2;

        if (countPage > extendPage)
        {
            if (curPage - (extendPage / 2) > 0)
            {
                if (curPage + (extendPage / 2) < countPage)
                {
                    startPage = curPage - (extendPage / 2);
                    endPage = startPage + extendPage - 1;
                }
                else
                {
                    endPage = countPage;
                    startPage = endPage - extendPage + 1;
                    t2 = "";
                }
            }
            else
            {
                endPage = extendPage;
                t1 = "";
            }
        }
        else
        {
            startPage = 1;
            endPage = countPage;
            t1 = "";
            t2 = "";
        }

        StringBuilder s = new StringBuilder("");
         s.Append("<ul>");
        s.Append(t1);
        for (int i = startPage; i <= endPage; i++)
        {
            if (i == curPage)
            {
                s.Append("<li class=\"active\"><a >");
                s.Append(i);
                s.Append("</a></li>");
            }
            else
            {
                s.Append("<li><a href=\"");
                s.Append(url);
                s.Append(pagetag);
                s.Append("=");
                s.Append(i);
                if (anchor != null)
                {
                    s.Append(anchor);
                }
                s.Append("\">");
                s.Append(i);
                s.Append("</a></li>");
            }
        }
        s.Append(t2);
        s.Append("</ul>");
        return s.ToString();
    }

    /// <summary>
    /// 返回 HTML 字符串的编码结果
    /// </summary>
    /// <param name="str">字符串</param>
    /// <returns>编码结果</returns>
    public static string HtmlEncode(string str)
    {
        return HttpUtility.HtmlEncode(str);
    }

    /// <summary>
    /// 返回 HTML 字符串的解码结果
    /// </summary>
    /// <param name="str">字符串</param>
    /// <returns>解码结果</returns>
    public static string HtmlDecode(string str)
    {
        return HttpUtility.HtmlDecode(str);
    }

    /// <summary>
    /// 返回 URL 字符串的编码结果
    /// </summary>
    /// <param name="str">字符串</param>
    /// <returns>编码结果</returns>
    public static string UrlEncode(string str)
    {
        return HttpUtility.UrlEncode(str);
    }

    /// <summary>
    /// 返回 URL 字符串的编码结果
    /// </summary>
    /// <param name="str">字符串</param>
    /// <returns>解码结果</returns>
    public static string UrlDecode(string str)
    {
        return HttpUtility.UrlDecode(str);
    }


   

    

    
    /// <summary>
    /// 格式化字节数字符串
    /// </summary>
    /// <param name="bytes"></param>
    /// <returns></returns>
    public static string FormatBytesStr(int bytes)
    {
        if (bytes > 1073741824)
            return ((double)(bytes / 1073741824)).ToString("0") + "G";

        if (bytes > 1048576)
            return ((double)(bytes / 1048576)).ToString("0") + "M";

        if (bytes > 1024)
            return ((double)(bytes / 1024)).ToString("0") + "K";

        return bytes.ToString() + "Bytes";
    }

     
    /// <summary>
    /// 返回相差的秒数
    /// </summary>
    /// <param name="Time"></param>
    /// <param name="Sec"></param>
    /// <returns></returns>
    public static int StrDateDiffSeconds(string Time, int Sec)
    {
        TimeSpan ts = DateTime.Now - DateTime.Parse(Time).AddSeconds(Sec);
        if (ts.TotalSeconds > int.MaxValue)
            return int.MaxValue;

        else if (ts.TotalSeconds < int.MinValue)
            return int.MinValue;

        return (int)ts.TotalSeconds;
    }

    /// <summary>
    /// 返回相差的分钟数
    /// </summary>
    /// <param name="time"></param>
    /// <param name="minutes"></param>
    /// <returns></returns>
    public static int StrDateDiffMinutes(string time, int minutes)
    {
        if (Utils.StrIsNullOrEmpty(time))
            return 1;

        TimeSpan ts = DateTime.Now - DateTime.Parse(time).AddMinutes(minutes);
        if (ts.TotalMinutes > int.MaxValue)
            return int.MaxValue;
        else if (ts.TotalMinutes < int.MinValue)
            return int.MinValue;

        return (int)ts.TotalMinutes;
    }

    /// <summary>
    /// 返回相差的小时数
    /// </summary>
    /// <param name="time"></param>
    /// <param name="hours"></param>
    /// <returns></returns>
    public static int StrDateDiffHours(string time, int hours)
    {
        if (Utils.StrIsNullOrEmpty(time))
            return 1;

        TimeSpan ts = DateTime.Now - DateTime.Parse(time).AddHours(hours);
        if (ts.TotalHours > int.MaxValue)
            return int.MaxValue;
        else if (ts.TotalHours < int.MinValue)
            return int.MinValue;

        return (int)ts.TotalHours;
    }

     
    /// <summary>
    /// 为脚本替换特殊字符串
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static string ReplaceStrToScript(string str)
    {
        return str.Replace("\\", "\\\\").Replace("'", "\\'").Replace("\"", "\\\"");
    }

    /// <summary>
    /// 是否为ip
    /// </summary>
    /// <param name="ip"></param>
    /// <returns></returns>
    public static bool IsIP(string ip)
    {
        return Regex.IsMatch(ip, @"^((2[0-4]\d|25[0-5]|[01]?\d\d?)\.){3}(2[0-4]\d|25[0-5]|[01]?\d\d?)$");
    }

    public static bool IsIPSect(string ip)
    {
        return Regex.IsMatch(ip, @"^((2[0-4]\d|25[0-5]|[01]?\d\d?)\.){2}((2[0-4]\d|25[0-5]|[01]?\d\d?|\*)\.)(2[0-4]\d|25[0-5]|[01]?\d\d?|\*)$");
    }


    

   

    

  
     


    /// <summary>
    /// 写cookie值
    /// </summary>
    /// <param name="strName">名称</param>
    /// <param name="strValue">值</param>
    public static void WriteCookie(string strName, string strValue)
    {
        HttpCookie cookie = HttpContext.Current.Request.Cookies[strName];
        if (cookie == null)
        {
            cookie = new HttpCookie(strName);
        }
        cookie.Value = strValue;
        HttpContext.Current.Response.AppendCookie(cookie);
    }

    /// <summary>
    /// 写cookie值
    /// </summary>
    /// <param name="strName">名称</param>
    /// <param name="strValue">值</param>
    public static void WriteCookie(string strName, string key, string strValue)
    {
        HttpCookie cookie = HttpContext.Current.Request.Cookies[strName];
        if (cookie == null)
        {
            cookie = new HttpCookie(strName);
        }
        cookie[key] = strValue;
        HttpContext.Current.Response.AppendCookie(cookie);
    }

    /// <summary>
    /// 写cookie值
    /// </summary>
    /// <param name="strName">名称</param>
    /// <param name="strValue">值</param>
    /// <param name="strValue">过期时间(分钟)</param>
    public static void WriteCookie(string strName, string strValue, int expires)
    {
        HttpCookie cookie = HttpContext.Current.Request.Cookies[strName];
        if (cookie == null)
        {
            cookie = new HttpCookie(strName);
        }
        cookie.Value = strValue;
        cookie.Expires = DateTime.Now.AddMinutes(expires);
        HttpContext.Current.Response.AppendCookie(cookie);
    }

    /// <summary>
    /// 读cookie值
    /// </summary>
    /// <param name="strName">名称</param>
    /// <returns>cookie值</returns>
    public static string GetCookie(string strName)
    {
        if (HttpContext.Current.Request.Cookies != null && HttpContext.Current.Request.Cookies[strName] != null)
            return HttpContext.Current.Request.Cookies[strName].Value.ToString();

        return "";
    }

    /// <summary>
    /// 读cookie值
    /// </summary>
    /// <param name="strName">名称</param>
    /// <returns>cookie值</returns>
    public static string GetCookie(string strName, string key)
    {
        if (HttpContext.Current.Request.Cookies != null && HttpContext.Current.Request.Cookies[strName] != null && HttpContext.Current.Request.Cookies[strName][key] != null)
            return HttpContext.Current.Request.Cookies[strName][key].ToString();

        return "";
    }

    /// <summary>
    /// 得到论坛的真实路径
    /// </summary>
    /// <returns></returns>
    public static string GetTrueForumPath()
    {
        string forumPath = HttpContext.Current.Request.Path;
        if (forumPath.LastIndexOf("/") != forumPath.IndexOf("/"))
            forumPath = forumPath.Substring(forumPath.IndexOf("/"), forumPath.LastIndexOf("/") + 1);
        else
            forumPath = "/";

        return forumPath;
    }

    /// <summary>
    /// 判断字符串是否是yy-mm-dd字符串
    /// </summary>
    /// <param name="str">待判断字符串</param>
    /// <returns>判断结果</returns>
    public static bool IsDateString(string str)
    {
        return Regex.IsMatch(str, @"(\d{4})-(\d{1,2})-(\d{1,2})");
    }

    /// <summary>
    /// 移除Html标记
    /// </summary>
    /// <param name="content"></param>
    /// <returns></returns>
    public static string RemoveHtml(string content)
    {
        return Regex.Replace(content, @"<[^>]*>", string.Empty, RegexOptions.IgnoreCase);
    }

    /// <summary>
    /// 过滤HTML中的不安全标签
    /// </summary>
    /// <param name="content"></param>
    /// <returns></returns>
    public static string RemoveUnsafeHtml(string content)
    {
        content = Regex.Replace(content, @"(\<|\s+)o([a-z]+\s?=)", "$1$2", RegexOptions.IgnoreCase);
        content = Regex.Replace(content, @"(script|frame|form|meta|behavior|style)([\s|:|>])+", "$1.$2", RegexOptions.IgnoreCase);
        return content;
    }

    /// <summary>
    /// 将用户组Title中的font标签去掉
    /// </summary>
    /// <param name="title">用户组Title</param>
    /// <returns></returns>
    public static string RemoveFontTag(string title)
    {
        Match m = RegexFont.Match(title);
        if (m.Success)
            return m.Groups[1].Value;

        return title;
    }

  
   

    /// <summary>
    /// 从HTML中获取文本,保留br,p,img
    /// </summary>
    /// <param name="HTML"></param>
    /// <returns></returns>
    public static string GetTextFromHTML(string HTML)
    {
        System.Text.RegularExpressions.Regex regEx = new System.Text.RegularExpressions.Regex(@"</?(?!br|/?p|img)[^>]*>", System.Text.RegularExpressions.RegexOptions.IgnoreCase);

        return regEx.Replace(HTML, "");
    }

  
 
   
    
    

    

    /// <summary>
    /// string型转换为float型
    /// </summary>
    /// <param name="strValue">要转换的字符串</param>
    /// <param name="defValue">缺省值</param>
    /// <returns>转换后的int类型结果</returns>
   

    public static string AdDeTime(int times)
    {
        return (DateTime.Now).AddMinutes(times).ToString();
    }

    /// <summary>
    /// 验证是否为正整数
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static bool IsInt(string str)
    {
        return Regex.IsMatch(str, @"^[0-9]*$");
    }

  

    /// <summary>
    /// 删除最后一个字符
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static string ClearLastChar(string str)
    {
        return (str == "") ? "" : str.Substring(0, str.Length - 1);
    }

    /// <summary>
    /// 备份文件
    /// </summary>
    /// <param name="sourceFileName">源文件名</param>
    /// <param name="destFileName">目标文件名</param>
    /// <param name="overwrite">当目标文件存在时是否覆盖</param>
    /// <returns>操作是否成功</returns>
    public static bool BackupFile(string sourceFileName, string destFileName, bool overwrite)
    {
        if (!System.IO.File.Exists(sourceFileName))
            throw new FileNotFoundException(sourceFileName + "文件不存在！");

        if (!overwrite && System.IO.File.Exists(destFileName))
            return false;

        try
        {
            System.IO.File.Copy(sourceFileName, destFileName, true);
            return true;
        }
        catch (Exception e)
        {
            throw e;
        }
    }


    /// <summary>
    /// 备份文件,当目标文件存在时覆盖
    /// </summary>
    /// <param name="sourceFileName">源文件名</param>
    /// <param name="destFileName">目标文件名</param>
    /// <returns>操作是否成功</returns>
    public static bool BackupFile(string sourceFileName, string destFileName)
    {
        return BackupFile(sourceFileName, destFileName, true);
    }


    /// <summary>
    /// 恢复文件
    /// </summary>
    /// <param name="backupFileName">备份文件名</param>
    /// <param name="targetFileName">要恢复的文件名</param>
    /// <param name="backupTargetFileName">要恢复文件再次备份的名称,如果为null,则不再备份恢复文件</param>
    /// <returns>操作是否成功</returns>
    public static bool RestoreFile(string backupFileName, string targetFileName, string backupTargetFileName)
    {
        try
        {
            if (!System.IO.File.Exists(backupFileName))
                throw new FileNotFoundException(backupFileName + "文件不存在！");

            if (backupTargetFileName != null)
            {
                if (!System.IO.File.Exists(targetFileName))
                    throw new FileNotFoundException(targetFileName + "文件不存在！无法备份此文件！");
                else
                    System.IO.File.Copy(targetFileName, backupTargetFileName, true);
            }
            System.IO.File.Delete(targetFileName);
            System.IO.File.Copy(backupFileName, targetFileName);
        }
        catch (Exception e)
        {
            throw e;
        }
        return true;
    }

    public static bool RestoreFile(string backupFileName, string targetFileName)
    {
        return RestoreFile(backupFileName, targetFileName, null);
    }

   
    /// <summary>
    /// 将全角数字转换为数字
    /// </summary>
    /// <param name="SBCCase"></param>
    /// <returns></returns>
    public static string SBCCaseToNumberic(string SBCCase)
    {
        char[] c = SBCCase.ToCharArray();
        for (int i = 0; i < c.Length; i++)
        {
            byte[] b = System.Text.Encoding.Unicode.GetBytes(c, i, 1);
            if (b.Length == 2)
            {
                if (b[1] == 255)
                {
                    b[0] = (byte)(b[0] + 32);
                    b[1] = 0;
                    c[i] = System.Text.Encoding.Unicode.GetChars(b)[0];
                }
            }
        }
        return new string(c);
    }

   

  
    //public static string GetFileExtName(string filename)
    //{
    //    string[] array = filename.Trim().Split('.');
    //    Array.Reverse(array);
    //    return array[0].ToString();
    //}


    /// <summary>
    /// 将数据表转换成JSON类型串
    /// </summary>
    /// <param name="dt">要转换的数据表</param>
    /// <returns></returns>
    public static StringBuilder DataTableToJSON(System.Data.DataTable dt)
    {
        return DataTableToJson(dt, true);
    }

    /// <summary>
    /// 将数据表转换成JSON类型串
    /// </summary>
    /// <param name="dt">要转换的数据表</param>
    /// <param name="dispose">数据表转换结束后是否dispose掉</param>
    /// <returns></returns>
    public static StringBuilder DataTableToJson(System.Data.DataTable dt, bool dt_dispose)
    {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.Append("[\r\n");

        //数据表字段名和类型数组
        string[] dt_field = new string[dt.Columns.Count];
        int i = 0;
        string formatStr = "{{";
        string fieldtype = "";
        foreach (System.Data.DataColumn dc in dt.Columns)
        {
            dt_field[i] = dc.Caption.ToLower().Trim();
            formatStr += "" + dc.Caption.Trim() + ":";
            fieldtype = dc.DataType.ToString().Trim().ToLower();
            if (fieldtype.IndexOf("int") > 0 || fieldtype.IndexOf("deci") > 0 ||
                fieldtype.IndexOf("floa") > 0 || fieldtype.IndexOf("doub") > 0 ||
                fieldtype.IndexOf("bool") > 0)
            {
                formatStr += "{" + i + "}";
            }
            else
            {
                formatStr += "'{" + i + "}'";
            }
            formatStr += ",";
            i++;
        }

        if (formatStr.EndsWith(","))
            formatStr = formatStr.Substring(0, formatStr.Length - 1);//去掉尾部","号

        formatStr += "}},";

        i = 0;
        object[] objectArray = new object[dt_field.Length];
        foreach (System.Data.DataRow dr in dt.Rows)
        {

            foreach (string fieldname in dt_field)
            {   //对 \ , ' 符号进行转换 
                objectArray[i] = dr[dt_field[i]].ToString().Trim().Replace("\\", "\\\\").Replace("'", "\\'");
                switch (objectArray[i].ToString())
                {
                    case "True":
                        {
                            objectArray[i] = "true"; break;
                        }
                    case "False":
                        {
                            objectArray[i] = "false"; break;
                        }
                    default: break;
                }
                i++;
            }
            i = 0;
            stringBuilder.Append(string.Format(formatStr, objectArray));
        }
        if (stringBuilder.ToString().EndsWith(","))
            stringBuilder.Remove(stringBuilder.Length - 1, 1);//去掉尾部","号

        if (dt_dispose)
            dt.Dispose();

        return stringBuilder.Append("\r\n];");
    }



    /// <summary>
    /// 字段串是否为Null或为""(空)
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static bool StrIsNullOrEmpty(string str)
    {
        if (str == null || str.Trim() == string.Empty)
            return true;

        return false;
    }

    
 
   
    /// <summary>
    /// 根据Url获得源文件内容
    /// </summary>
    /// <param name="url">合法的Url地址</param>
    /// <returns></returns>
    public static string GetSourceTextByUrl(string url)
    {
        WebRequest request = WebRequest.Create(url);
        request.Timeout = 20000;//20秒超时
        WebResponse response = request.GetResponse();

        Stream resStream = response.GetResponseStream();
        StreamReader sr = new StreamReader(resStream);
        return sr.ReadToEnd();
    }

    /// <summary>
    /// 转换时间为unix时间戳
    /// </summary>
    /// <param name="date">需要传递UTC时间,避免时区误差,例:DataTime.UTCNow</param>
    /// <returns></returns>
    public static double ConvertToUnixTimestamp(DateTime date)
    {
        DateTime origin = new DateTime(1970, 1, 1, 0, 0, 0, 0);
        TimeSpan diff = date - origin;
        return Math.Floor(diff.TotalSeconds);
    }


    /// <summary>
    /// Json特符字符过滤，参见http://www.json.org/
    /// </summary>
    /// <param name="sourceStr">要过滤的源字符串</param>
    /// <returns>返回过滤的字符串</returns>
    public static string JsonCharFilter(string sourceStr)
    {
        sourceStr = sourceStr.Replace("\\", "\\\\");
        sourceStr = sourceStr.Replace("\b", "\\\b");
        sourceStr = sourceStr.Replace("\t", "\\\t");
        sourceStr = sourceStr.Replace("\n", "\\\n");
        sourceStr = sourceStr.Replace("\n", "\\\n");
        sourceStr = sourceStr.Replace("\f", "\\\f");
        sourceStr = sourceStr.Replace("\r", "\\\r");
        return sourceStr.Replace("\"", "\\\"");
    }


    /// <summary>
    /// 合并字符
    /// </summary>
    /// <param name="source">要合并的源字符串</param>
    /// <param name="target">要被合并到的目的字符串</param>
    /// <param name="mergechar">合并符</param>
    /// <returns>合并到的目的字符串</returns>
    public static string MergeString(string source, string target)
    {
        return MergeString(source, target, ",");
    }

    /// <summary>
    /// 合并字符
    /// </summary>
    /// <param name="source">要合并的源字符串</param>
    /// <param name="target">要被合并到的目的字符串</param>
    /// <param name="mergechar">合并符</param>
    /// <returns>并到字符串</returns>
    public static string MergeString(string source, string target, string mergechar)
    {
        if (Utils.StrIsNullOrEmpty(target))
            target = source;
        else
            target += mergechar + source;

        return target;
    }


    /// <summary>
    /// 清除UBB标签
    /// </summary>
    /// <param name="sDetail">帖子内容</param>
    /// <returns>帖子内容</returns>
    public static string ClearUBB(string sDetail)
    {
        return Regex.Replace(sDetail, @"\[[^\]]*?\]", string.Empty, RegexOptions.IgnoreCase);
    }

    /// <summary>
    /// 获取站点根目录URL
    /// </summary>
    /// <returns></returns>
    public static string GetRootUrl(string forumPath)
    {
        int port = HttpContext.Current.Request.Url.Port;
        return string.Format("{0}://{1}{2}{3}",
                             HttpContext.Current.Request.Url.Scheme,
                             HttpContext.Current.Request.Url.Host.ToString(),
                             (port == 80 || port == 0) ? "" : ":" + port,
                             forumPath);
    }


    /// <summary>
    /// 获取指定文件的扩展名
    /// </summary>
    /// <param name="fileName">指定文件名</param>
    /// <returns>扩展名</returns>
    public static string GetFileExtName(string fileName)
    {
        if (Utils.StrIsNullOrEmpty(fileName) || fileName.IndexOf('.') <= 0)
            return "";

        fileName = fileName.ToLower().Trim();

        return fileName.Substring(fileName.LastIndexOf('.'), fileName.Length - fileName.LastIndexOf('.'));
    }

    public static string GetHttpWebResponse(string url)
    {
        return GetHttpWebResponse(url, string.Empty);
    }

    /// <summary>
    /// http POST请求url
    /// </summary>
    /// <param name="apiUrl"></param>
    /// <param name="method_name"></param>
    /// <param name="postData"></param>
    /// <returns></returns>
    private static string GetHttpWebResponse(string url, string postData)
    {
        HttpWebRequest request = (HttpWebRequest)HttpWebRequest.Create(url);
        request.Method = "POST";
        request.ContentType = "application/x-www-form-urlencoded";
        request.ContentLength = postData.Length;
        request.Timeout = 20000;

        HttpWebResponse response = null;

        try
        {
            StreamWriter swRequestWriter = new StreamWriter(request.GetRequestStream());
            swRequestWriter.Write(postData);
            if (swRequestWriter != null)
                swRequestWriter.Close();

            response = (HttpWebResponse)request.GetResponse();
            using (StreamReader reader = new StreamReader(response.GetResponseStream(), Encoding.UTF8))
            {
                return reader.ReadToEnd();
            }
        }
        finally
        {
            if (response != null)
                response.Close();
        }
    }
    public static void WriteCache(string name,object obj)
    {
        string filename = HttpContext.Current.Server.MapPath("/tmp/") + MD5(name) + ".txt";
        FileStream sw = new FileStream(filename,FileMode.Create);
        BinaryFormatter aa = new BinaryFormatter();
        aa.Serialize(sw,obj);
        sw.Flush();
        sw.Dispose();
    }
    public static object ReadCache(string name)
    {
        string filename = HttpContext.Current.Server.MapPath("/tmp/") + MD5(name)+".txt";
        FileStream sw = new FileStream(filename, FileMode.Open);
        BinaryFormatter aa = new BinaryFormatter();
        object obj = aa.Deserialize(sw);
        sw.Flush();
        sw.Close();
        sw.Dispose();
        return obj;
    }
    public static void DeleteCache(string name)
    {
        string filename = HttpContext.Current.Server.MapPath("/tmp/") + MD5(name);
        File.Delete(filename);
    }

    public static DataTable FindAll(string name, int top, string where, string orderby)
    {
        DataTable dt = null;
        if (!string.IsNullOrEmpty(orderby))
        {
            if (orderby.IndexOf("id") > -1)
            {
                orderby = "order by " + orderby;
            }
            else
            {
                orderby = "order by " + orderby + ",id desc";
            }
        }
        else
        {
            orderby = "order by id desc";
        }
        string sql = string.Format("select top {2} * from [{0}] where {1} {3}", name, where, top, orderby);
        dt = DbHelper.ExecuteDataTable(sql);
        return dt;
    }
   
}