<?php

class Category {

	//清除包含對應字段的分類
	static public function clearCate($cate, $status = 'status', $value = 1) {

		$arr = array();
		foreach ($cate as $v) {
			if ($v[$status] != $value) {
				$arr[] = $v;
			}
		}
		return $arr;		
	}

	//欄目顯示只針對XYHCMS（清除單頁模型(modelid=2)和外鏈(type!=0)）
	static public function clearPageAndLink($cate, $modelid = 2, $type = 0) {

		$arr = array();
		foreach ($cate as $v) {
			if ($v['modelid'] != $modelid && $v['type'] == $type) {
				$arr[] = $v;
			}
		}
		return $arr;		
	}


	
	//一維數組
	static public function toLevel($cate, $delimiter = '———', $pid = 0, $level = 0) {
		
		$arr = array();
		foreach ($cate as $v) {
			if ($v['pid'] == $pid) {
				$v['level'] = $level + 1;
				$v['delimiter'] = str_repeat($delimiter, $level);
				$arr[] = $v;
				$arr = array_merge($arr, self::toLevel($cate, $delimiter, $v['id'], $v['level']));
			}
		}

		return $arr;
		
	}


	//組成多維數組
	static public function toLayer($cate, $name = 'child', $pid = 0){

		$arr = array();
		foreach ($cate as $v) {
			if ($v['pid'] == $pid) {
				$v[$name] = self::toLayer($cate, $name, $v['id']);
				$arr[] = $v;
			}
		}

		return $arr;
	}


	//一維數組(同模型)(model = tablename相同)，刪除其他模型的分類
	static public function getLevelOfModel($cate, $tablename = 'article') {

		$arr = array();
		foreach ($cate as $v) {
			if ($v['tablename'] == $tablename) {
				$arr[] = $v;
			}
		}

		return $arr;
		
	}

	//一維數組(同模型)(modelid)，刪除其他模型的分類
	static public function getLevelOfModelId($cate, $modelid = 0) {

		$arr = array();
		foreach ($cate as $v) {
			if ($v['modelid'] == $modelid) {
				$arr[] = $v;
			}
		}

		return $arr;
		
	}

	//傳遞一個子分類ID返回他的所有父級分類
	static public function getParents($cate, $id) {
		$arr = array();
		foreach ($cate as $v) {
			if ($v['id'] == $id) {
				$arr[] = $v;
				$arr = array_merge(self::getParents($cate, $v['pid']), $arr);
			}
		}
		return $arr;
	}

	//傳遞一個子分類ID返回他的同級分類
	static public function getSameCate($cate, $id) {
		$arr = array();
		$self = self::getSelf($cate, $id);
		if (empty($self)) {
			return $arr;
		}

		foreach ($cate as $v) {
			if ($v['id'] == $self['pid']) {
				$arr[] = $v;
			}
		}
		return $arr;
	}



	//判斷分類是否有子分類,返回false,true
	static public function hasChild($cate, $id) {
		$arr = false;
		foreach ($cate as $v) {
			if ($v['pid'] == $id) {
				$arr = true;
				return $arr;
			}
		}

		return $arr;
	}

	//傳遞一個父級分類ID返回所有子分類ID
	/**
	*@param $cate 全部分類數組
	*@param $pid 父級ID
	*@param $flag 是否包括父級自己的ID，默認不包括
	**/
	static public function getChildsId($cate, $pid, $flag = 0) {
		$arr = array();
		if ($flag) {
			$arr[] = $pid;
		}
		foreach ($cate as $v) {
			if ($v['pid'] == $pid) {
				$arr[] = $v['id'];
				$arr = array_merge($arr , self::getChildsId($cate, $v['id']));
			}
		}

		return $arr;
	}


	//傳遞一個父級分類ID返回所有子級分類
	static public function getChilds($cate, $pid) {
		$arr = array();
		foreach ($cate as $v) {
			if ($v['pid'] == $pid) {
				$arr[] = $v;
				$arr = array_merge($arr, self::getChilds($cate, $v['id']));
			}
		}
		return $arr;
	}

	//傳遞一個分類ID返回該分類相當信息
	static public function getSelf($cate, $id) {
		$arr = array();
		foreach ($cate as $v) {
			if ($v['id'] == $id) {
				$arr = $v;
				return $arr;
			}
		}
		return $arr;
	}

	//傳遞一個分類ID返回該分類相當信息
	static public function getSelfByEName($cate, $ename) {
		$arr = array();
		foreach ($cate as $v) {
			if ($v['ename'] == $ename) {
				$arr = $v;
				return $arr;
			}
		}
		return $arr;
	}


}


?>