<?php

class MemberAction extends CommonAction {
	
	public function index() {


		$uid = get_cookie('uid');
		$user = D('MemberView')->nofield('password,encrypt')->find($uid);
		if (!$user) {
			$this->error('請重新登錄',U(GROUP_NAME.'/Public/login'));
		}
		$user['detail'] = M('memberdetail')->find($uid);
		if (empty($user['detail'])) {
			$user['detail'] = array(
					'realname' => '還沒設置',
					'sex' => '保密',
					'birthday' => '0000-00-00',
					'animal' => '保密',
					'star' => '保密',
					'province' => '保密',
					'area' => '保密',
				);
		}else {
			$user['detail']['sex'] = $user['detail']['sex']? '女士' : '男士';
			$user['detail']['animal'] = GetValueOfItem('animal', $user['detail']['animal']);
			$user['detail']['star'] = GetValueOfItem('animal', $user['detail']['star']);
		}
		

		$this->user = $user;
		$this->title = '會員中心';
		$this->display();
	}

	public function name() {
		$uid = get_cookie('uid');
		$user = M('member')->find($uid);
		if (!$user) {
			$this->error('請重新登錄',U(GROUP_NAME.'/Public/login'));
		}

		if (IS_POST) {
			$data['nickname'] = I('nickname', '', 'htmlspecialchars,trim');
			$data['id'] = $uid;
			if (empty($data['nickname'])) {
				$this->error('你還沒有輸入暱稱！');
			}

			$notallowname = explode(',', C('cfg_member_notallow'));
			if (in_array($data['nickname'], $notallowname)) {
				$this->error('此暱稱系統禁用，請重新更換一個！');
			}

			if (M('member')->save($data) !== false) {
				set_cookie( array('name' => 'nickname', 'value' => $data['nickname'], 'expire' => get_cookie('expire') ));
				$this->success('修改成功',U(GROUP_NAME. '/Member/index'));
			}else{
				$this->error('修改暱稱失敗！');
			}
			exit();
		}
		
		$this->user = $user;
		$this->title = '修改暱稱';
		$this->display();
	}


	public function password() {
		$uid = get_cookie('uid');
		if (IS_POST) {
			$oldpassword = I('oldpassword', '');
			$password = I('password', '');
			$repassword = I('repassword', '');
			if (empty($oldpassword)) {
				$this->error('請填寫舊密碼！');
			}
			if (empty($password)) {
				$this->error('請填寫新密碼！');
			}

			if ($password != $repassword) {
				$this->error('兩次密碼不一樣，請重新填寫！');
			}
			
			$self = M('member')->field(array('email', 'password' ,'encrypt'))->where(array('id' => $uid))->find();
			if (!self) {
				$this->error('用戶不存在，請重新登錄');
			}

			if (get_password($oldpassword, $self['encrypt']) != $self['password']) {
				$this->error('舊密碼錯誤');
			}

			$passwordinfo = get_password($password);

			$data = array(
				'id'		=> $uid,
				'password'		=> $passwordinfo['password'],		
				'encrypt'		=> $passwordinfo['encrypt']
				);

			if (false !== M('member')->save($data)) {
				$this->success('修改密碼成功', U(GROUP_NAME. '/Member/password'));
			}else {

				$this->error('修改密碼失敗');
			}
			exit();
		}

		$this->title = '修改密碼';
		$this->display();
	}

	public function avatar() {

		//$this->display();
	}


	public function person() {
		$uid = get_cookie('uid');
		if (IS_POST) {
			$data['realname'] = I('realname', '', 'htmlspecialchars,trim');
			$data['birthday'] = I('birthday', '0000-00-00');
			$data['sex'] = I('sex', 0, 'intval');			
			$data['address'] = I('address', '');
			$data['tel'] = I('tel', '');
			$data['mobile'] = I('mobile', '');
			$data['qq'] = I('qq', '');
			$data['maxim'] = I('maxim', '');

			$data['userid'] = $uid;
			$data['updatetime'] = time();
			$new = I('new', 0,'intval');
			if (empty($data['realname'])) {
				$this->error('請輸入姓名！');
			}
			
			$result = true;
			if ($new) {
				$result = M('memberdetail')->add($data);
			}else {
				$result = M('memberdetail')->save($data);
			}
			
			if (false !== $result) {
				$this->success('修改基本資料成功', U(GROUP_NAME. '/Member/person'));
			}else {

				$this->error('修改基本資料失敗');
			}
			exit();
		}

		$userdetail = M('memberdetail')->where(array('userid' => $uid))->find();
		if (!$userdetail) {
			$userdetail = array(
				'uid' => $uid,
				'email' => get_cookie('email'),
				'realname' => '',
				'sex' => 0,
				'birthday' => '1990-1-1',
				'address'	=> '',
				'tel'	=> '',
				'mobile'	=> '',
				'qq'	=> '',
				'maxim' => '',
			);
			$userdetail['new'] = 1;
		}else {
			$userdetail['new'] = 0;
			$userdetail['uid'] = $uid;
			$userdetail['email'] =  get_cookie('email');
		}
		$this->vo = $userdetail;
		$this->title = '基本資料';
		$this->display();
	}




}

?>