<?php

class AbcAction extends CommonAction {
	
	public function index() {
					
		//分頁
		import('Class.Page', APP_PATH);
		$count = M('abc')->count();

		$page = new Page($count, 10);
		$page->rollPage = 7;
		$page->setConfig('theme','%totalRow% %header%  %first% %upPage% %linkPage% %downPage% %end% %nowPage%/%totalPage% 頁');
		$limit = $page->firstRow. ',' .$page->listRows;
		$list = M('abc')->order('id desc')->limit($limit)->select();

		$this->page = $page->show();
		$this->vlist = $list;
		$this->type = '廣告位列表';

		$this->display();
	}
	//添加
	public function add() {
		//當前控制器名稱		
		$actionName = strtolower($this->getActionName());
		if (IS_POST) {
			$type = I('type', 0,'intval');
			$data = I('post.', '');
			$data['name'] = trim($data['name']);
			$data['type'] = I('type', 0,'intval');
			$data['setting'] = I('setting', '','');

			if (1 == $data['type']) {
				$data['width'] = 0;
				$data['height'] = 0;
			}
			if (empty($data['name'])) {
				$this->error('廣告位名稱必須填寫！');
			}

			if (empty($data['type'])) {
				$this->error('請選擇廣告類型！');
			}


			$ad = M('abc')->where(array('name' => $data['name']))->find();
			if ($ad) {
				$this->error('廣告位名稱已經存在！');
			}


			if($id = M('abc')->add($data)) {
				$this->success('添加成功',U(GROUP_NAME. '/Abc/index'));
			}else {
				$this->error('添加失敗');
			}
			exit();
		}
		$this->display();
	}



	//編輯文章
	public function edit() {
		//當前控制器名稱
		$id = I('id', 0, 'intval');
		$actionName = strtolower($this->getActionName());
		if (IS_POST) {
			$data = I('post.', '');
			$data['id'] = intval($data['id']);
			$data['type'] = intval($data['type']);
			$data['setting'] = I('setting', '','');
		
			$data['name'] = trim($data['name']);
			if (empty($data['name'])) {
				$this->error('廣告位名稱必須填寫！');
			}
			if (empty($data['type'])) {
				$this->error('請選擇廣告類型！');
			}
			if (1 == $data['type']) {
				$data['width'] = 0;
				$data['height'] = 0;
			}
			
			if (M('abc')->where(array('name' => $data['name'], 'id' => array('neq', $id)))->find()) {
				$this->error('廣告位名稱已經存在！');
			}

			if (false !== M('abc')->save($data)) {
				$this->success('修改成功', U(GROUP_NAME. '/Abc/index'));
			}else {

				$this->error('修改失敗');
			}
			exit();
		}
		$vo = M($actionName)->find($id);		
		$vo['setting'] = htmlspecialchars($vo['setting']);//ueditor
		$this->vo = $vo;
		$this->display();
	}




	//刪除
	public function del() {

		$id = I('id',0 , 'intval');
		$Model =M();			

		//getField('id'),返回一個結果，getField('id',true),返回滿足的所有(數組)
		$child= M('abcDetail')->where(array('aid' => $id))->find();
		if($child) {
			$this->error('刪除失敗!請先刪除廣告位下的廣告內容!');
		}

		if (M('abc')->delete($id)) {
			$this->success('徹底刪除成功', U(GROUP_NAME. '/Abc/index'));
		}else {
			$this->error('徹底刪除失敗');
		}
	}



	//廣告列表
	public function detail() {
		$aid = I('aid', 0, 'intval');
		if (empty($aid)) {
			$this->error('參數錯誤！');
		}

		$cate = M('abc')->find($aid);

		$where['aid'] = $aid;

		//分頁
		import('Class.Page', APP_PATH);
		$count = M('abcDetail')->where($where)->count();

		$page = new Page($count, 10);
		$page->rollPage = 7;
		$page->setConfig('theme','%totalRow% %header%  %first% %upPage% %linkPage% %downPage% %end% %nowPage%/%totalPage% 頁');
		$limit = $page->firstRow. ',' .$page->listRows;
		$list = M('abcDetail')->where($where)->order('sort,id')->limit($limit)->select();

		$this->page = $page->show();
		$this->vlist = $list;
		$this->type = $cate['name'].'-廣告列表';
		$this->cate = $cate;

		$this->display();
	}

		//添加
	public function addDetail() {
		$aid = I('aid', 0, 'intval');
		if (IS_POST) {
			//M驗證
			$data = I('post.');
			$data['content'] = I('content', '', '');
			$data['starttime'] = I('starttime', time(),'strtotime');			
			$data['endtime'] = I('endtime', strtotime('+1 months'),'strtotime');
			switch ($data['type']) {
				case 1:
					$txt = '內容';
					break;
				case 2:
					$txt = '圖片';
					break;
				case 3:
					$txt = 'flash';
					break;
			}
			if ($data['url'] == 'http://') {
				$data['url'] = '';
			}
			$db = M('abcDetail');
			if (empty($data['aid'])) {
				$this->error('廣告位不存在，不能添加廣告內容');
			}
			if (empty($data['title'])) {
				$this->error('標題不能為空');
			}
			if (empty($data['content'])) {
				$this->error($txt.'不能為空');
			}
			

			if($id = M('abcDetail')->add($data)) {
				M('abc')->where(array('id' => $data['aid']))->setInc('items');

				$attid = M('attachment')->where(array('filepath' => $data['content']))->getField('id');
				if($attid){
					M('attachmentindex')->add(array('attid' => $attid,'arcid' => $id, 'modelid' => 0, 'desc' => 'abc'));
				}

				$this->success('添加成功',U(GROUP_NAME. '/Abc/detail', array('aid'=> $data['aid'])));
			}else {
				$this->error('添加失敗');
			}
			exit();
		}
		$this->cate = M('abc')->find($aid);
		$this->display();
	}

	//編輯文章
	public function editDetail() {
		//當前控制器名稱
		$id = I('id', 0, 'intval');
		if (IS_POST) {
			$data = I('post.', '');
			$data['id'] = intval($data['id']);
		
			$data['content'] = I('content', '', '');
			$data['starttime'] = I('starttime', time(),'strtotime');			
			$data['endtime'] = I('endtime', strtotime('+1 months'),'strtotime');
			switch ($data['type']) {
				case 1:
					$txt = '內容';
					break;
				case 2:
					$txt = '圖片';
					break;
				case 3:
					$txt = 'flash';
					break;
			}
			if ($data['url'] == 'http://') {
				$data['url'] = '';
			}
			$db = M('abcDetail');
			if (empty($data['id'])) {
				$this->error('參數錯誤！');
			}
			if (empty($data['aid'])) {
				$this->error('廣告位不存在，不能修改對應的廣告內容');
			}
			if (empty($data['title'])) {
				$this->error('標題不能為空');
			}
			if (empty($data['content'])) {
				$this->error($txt.'不能為空');
			}

			if (false !== M('abcDetail')->save($data)) {

				M('attachmentindex')->where(array('arcid' => $id, 'modelid' => 0, 'desc' => 'abc'))->delete();
				$attid = M('attachment')->where(array('filepath' => $data['content']))->getField('id');
				if($attid){
					M('attachmentindex')->add(array('attid' => $attid,'arcid' => $id, 'modelid' => 0, 'desc' => 'abc'));
				}
				$this->success('修改成功',U(GROUP_NAME. '/Abc/detail', array('aid'=> $data['aid'])));
			}else {

				$this->error('修改失敗');
			}
			exit();
		}

		$vo = M('abcDetail')->find($id);
		$vo['content'] = htmlspecialchars($vo['content']);//ueditor
		$this->cate = M('abc')->find($vo['aid']);
		$this->vo = $vo;
		$this->display();
	}


	//刪除
	public function delDetail() {

		$id = I('id',0 , 'intval');
		$aid = I('aid',0 , 'intval');
		
		if (M('abcDetail')->delete($id)) {			
			M('attachmentindex')->where(array('arcid' => $id, 'modelid' => 0, 'desc' => 'abc'))->delete();
			M('abc')->where(array('id' => $aid))->setDec('items');
			$this->success('徹底刪除成功', U(GROUP_NAME. '/Abc/detail', array('aid' => $aid)));
		}else {
			$this->error('徹底刪除失敗');
		}
	}

	//批量更新排序
	public function sort() {
		$aid = I('aid', 0, 'intval');
		$sortlist = I('sortlist', array(), 'intval');
		if (empty($aid)) {
			$this->error('參數錯誤！');
		}

		foreach ($sortlist as $k => $v) {
			$data = array(
					'id' => $k,
					'sort' => $v,
				);
			M('abcDetail')->save($data);		
		}
		$this->redirect(GROUP_NAME. '/Abc/detail', array('aid' => $aid));
	}


	//獲取廣告代碼
	public function getcode() {
		$id = I('id', 0, 'intval');
		if (empty($id)) {
			$this->error('參數錯誤！');
		}
		
		$this->id = $id;
		$this->display();
	}






}



?>