<?php

class CommentAction extends CommonAction {
	
	public function index() {
					
		//分頁
		import('Class.Page', APP_PATH);
		$count = D('CommentView')->count();

		$page = new Page($count, 10);
		$page->rollPage = 7;
		$page->setConfig('theme','%totalRow% %header%  %first% %upPage% %linkPage% %downPage% %end% %nowPage%/%totalPage% 頁');
		$limit = $page->firstRow. ',' .$page->listRows;
		$list = D('CommentView')->order('id DESC')->limit($limit)->select();

		$this->page = $page->show();
		$this->vlist = $list;
		$this->type = '評論管理';

		$this->display();
	}


	//編輯文章
	public function edit() {
		//當前控制器名稱
		$id = I('id', 0, 'intval');
		$actionName = strtolower($this->getActionName());
		if (IS_POST) {
			$data = I('post.');
			$data['content'] = I('content', '', '');
			if (false !== M('comment')->save($data)) {
				$this->success('修改成功', U(GROUP_NAME. '/Comment/index'));
			}else {

				$this->error('修改失敗');
			}
			exit();
		}

		$this->vo = M($actionName)->find($id);
		$this->display();
	}




	//徹底刪除
	public function del() {

		$id = I('id',0 , 'intval');
		$batchFlag = I('get.batchFlag', 0, 'intval');
		//批量刪除
		if ($batchFlag) {
			$this->delBatch();
			return;
		}
		
		if (M('comment')->delete($id)) {
			$this->success('徹底刪除成功', U(GROUP_NAME. '/Comment/index'));
		}else {
			$this->error('徹底刪除失敗');
		}
	}


	//批量徹底刪除
	public function delBatch() {

		$idArr = I('key',0 , 'intval');		
		if (!is_array($idArr)) {
			$this->error('請選擇要徹底刪除的項');
		}
		$where = array('id' => array('in', $idArr));

		if (M('comment')->where($where)->delete()) {
			$this->success('徹底刪除成功', U(GROUP_NAME. '/Comment/index'));
		}else {
			$this->error('徹底刪除失敗');
		}
	}




}



?>