<?php
/***
***公共驗證控制器CommonAction
***
***/
class CommonAction extends Action {
	
	//_initialize自動運行方法，在每個方法前，系統會首先運動這個方法
	public function _initialize() {

		
		if (!isset($_SESSION[C('USER_AUTH_KEY')])) {
			$this->redirect(GROUP_NAME . '/Login/index');
		}

		$noAuth = in_array(MODULE_NAME, explode(',', C('NOT_AUTH_MODULE'))) || in_array(ACTION_NAME, explode(',',C('NOT_AUTH_ACTION')));
		
		//是否開啟驗證 且 需要驗證控制器或方法
		if (C('USER_AUTH_ON') && !$noAuth) {

			import('ORG.Util.RBAC');
			//單方文件(非分組)，GROUP_NAME不需要，留空，即RBAC::AccessDecision()
			RBAC::AccessDecision(GROUP_NAME) || $this->error('沒有權限');//如果沒有權限則返回error			

		}



	}
}


?>