<?php

class ItemgroupAction extends CommonAction {
	
	public function index() {
					
		//分頁
		import('Class.Page', APP_PATH);
		$count = M('itemgroup')->count();

		$page = new Page($count, 10);
		$page->rollPage = 7;
		$page->setConfig('theme','%totalRow% %header%  %first% %upPage% %linkPage% %downPage% %end% %nowPage%/%totalPage% 頁');
		$limit = $page->firstRow. ',' .$page->listRows;
		$list = M('itemgroup')->order('id')->limit($limit)->select();

		$this->page = $page->show();
		$this->vlist = $list;
		$this->type = '聯動分組列表';

		$this->display();
	}
	//添加
	public function add() {
		//當前控制器名稱		
		$actionName = strtolower($this->getActionName());
		if (IS_POST) {
			//M驗證
			$validate = array(
				array('remark','require','組名必須填寫！'), 
				array('name','require','英文組名必須填寫！'), 
				array('name','','英文組名已經存在！',0,'unique',1), 
			);
			$db = M('itemgroup');
			if (!$db->validate($validate)->create()) {
				$this->error($db->getError());
			}
			if($id = M('itemgroup')->add()) {
				$this->success('添加成功',U(GROUP_NAME. '/Itemgroup/index'));
			}else {
				$this->error('添加失敗');
			}
			exit();
		}
		$this->display();
	}



	//編輯文章
	public function edit() {
		//當前控制器名稱
		$id = I('id', 0, 'intval');
		$actionName = strtolower($this->getActionName());
		if (IS_POST) {
			$name = I('name', '', 'htmlspecialchars,trim');
			$remark = I('remark', '', 'htmlspecialchars,trim');
			if (empty($remark)) {
				$this->error('組名必須填寫！');
			}
			if (empty($name)) {
				$this->error('英文組名必須填寫！');
			}
			
			if (M('itemgroup')->where(array('name' => $name, 'id' => array('neq', $id)))->find()) {
				$this->error('英文組名已經存在！');
			}

			if (false !== M('itemgroup')->save($_POST)) {
				$this->success('修改成功', U(GROUP_NAME. '/Itemgroup/index', array('pid' => $pid)));
			}else {

				$this->error('修改失敗');
			}
			exit();
		}
		$this->vo = M($actionName)->find($id);
		$this->display();
	}




	//徹底刪除文章
	public function del() {

		$id = I('id',0 , 'intval');
		$Model =M();		
		$batchFlag = intval($_GET['batchFlag']);
		//批量刪除
		if ($batchFlag) {
			$this->delBatch();
			return;
		}

		//getField('id'),返回一個結果，getField('id',true),返回滿足的所有(數組)
		$child= $Model->table(C('DB_PREFIX'). 'iteminfo I')->join('inner join '. C('DB_PREFIX').'itemgroup G on I.group = G.name')->where(array('G.id' => $id))->getField('I.id');
		if($child) {
			$this->error('請先刪除分組下的聯動信息，再刪除分組');
		}

		if (M('itemgroup')->delete($id)) {
			$this->success('徹底刪除成功', U(GROUP_NAME. '/Itemgroup/index'));
		}else {
			$this->error('徹底刪除失敗');
		}
	}


	//批量徹底刪除文章
	public function delBatch() {

		$idArr = I('key',0 , 'intval');		
		if (!is_array($idArr)) {
			$this->error('請選擇要徹底刪除的項');
		}
		$where = array('id' => array('in', $idArr));

		//getField('id'),返回一個結果，getField('id',true),返回滿足的所有(數組)
		$Model =M();
		$child= $Model->table(C('DB_PREFIX'). 'iteminfo I')->join('inner join '. C('DB_PREFIX').'itemgroup G on I.group = G.name')->where(array('G.id' => array('in', $idArr)))->getField('I.id');
		if($child) {
			$this->error('請先刪除分組下的聯動信息，再刪除分組');
		}


		if (M('itemgroup')->where($where)->delete()) {
			$this->success('徹底刪除成功', U(GROUP_NAME. '/Itemgroup/index'));
		}else {
			$this->error('徹底刪除失敗');
		}
	}




}



?>