<?php

class IteminfoAction extends CommonAction {
	
	public function index() {

		$group = I('group', '','trim');
		if (empty($group)) {
			$this->error('參數不正確!');
		}

		//分頁
		import('Class.Page', APP_PATH);
		$count = M('iteminfo')->where(array('group' => $group))->count();

		$page = new Page($count, 10);
		$page->rollPage = 7;
		$page->setConfig('theme','%totalRow% %header%  %first% %upPage% %linkPage% %downPage% %end% %nowPage%/%totalPage% 頁');
		$limit = $page->firstRow. ',' .$page->listRows;
		$list = M('iteminfo')->where(array('group' => $group))->order('sort')->limit($limit)->select();

		$this->page = $page->show();
		$this->vlist = $list;
		$this->group = $group;
		$this->type = '聯動信息列表';

		$this->display();
	}
	//添加
	public function add() {
		//當前控制器名稱		
		$actionName = strtolower($this->getActionName());
		$group = I('group', '','trim');

		if (IS_POST) {
			//M驗證
			$data['name'] = I('name', '', 'trim');
			$data['value'] = I('value', 1, 'intval');
			$data['group'] = I('group', '', 'trim');
			$data['sort'] = I('sort',  0, 'intval');

			if (empty($data['name'])) {
				$this->error('名稱不能為空');
			}
			if (empty($data['group'])) {
				$this->error('請選擇分組！');
			}
			$vo = M('iteminfo')->where(array('group' => $data['group'], 'value' => $data['value']))->find();
			if ($vo) {
				$this->error('枚舉值已經存在，請重新填寫');
			}


			if($id = M('iteminfo')->add($data)) {
				$this->success('添加成功',U(GROUP_NAME. '/Iteminfo/index', array('group' => $data['group'])));
			}else {
				$this->error('添加失敗');
			}
			exit();
		}


		$this->vlist = M('itemgroup')->select();
		$data = M('iteminfo')->where(array('group' => $group))->field('MAX(value) as maxV')->find();
	
		$this->maxValue = isset($data['maxV'])? $data['maxV'] + 1 : 1;
		$this->group = $group;
		$this->type = '添加聯動信息';
		$this->display();
	}



	//編輯
	public function edit() {
		//當前控制器名稱
		$id = I('id', 0, 'intval');
		$actionName = strtolower($this->getActionName());
		if (IS_POST) {
			//M驗證
			$data['id'] = I('id',  0, 'intval');
			$data['name'] = I('name', '', 'trim');
			$data['value'] = I('value', 1, 'intval');
			$data['group'] = I('group', '', 'trim');			
			$data['sort'] = I('sort',  0, 'intval');

			if (empty($data['name'])) {
				$this->error('名稱不能為空');
			}
			if (empty($data['group'])) {
				$this->error('請選擇分組！');
			}
			$vo = M('iteminfo')->where(array('id' => array('neq', $data['id']), 'group' => $data['group'], 'value' => $data['value']))->find();
			if ($vo) {
				$this->error('枚舉值已經存在，請重新填寫');
			}


			if (false !== M('iteminfo')->save($data)) {
				$this->success('修改成功',U(GROUP_NAME. '/Iteminfo/index', array('group' => $data['group'])));
			}else {

				$this->error('修改失敗');
			}
			exit();
		}
		$group = I('group', '','trim');
		$this->vlist = M('itemgroup')->select();
		$this->vo = M($actionName)->find($id);
		$this->group = $group;
		$this->type = '修改聯動信息';
		$this->display();
	}



	//批量更新排序
	public function sort() {
		$group = $_GET['group'];
		//exit();
		foreach ($_POST as $k => $v) {
			if ($k == 'key') {
				continue;
			}
			M('iteminfo')->where(array('id'=>$k))->setField('sort',$v);
			//echo 'id:'.$k.'___v:'.$v.'<br/>';//debug
		}
		$this->redirect(GROUP_NAME. '/Iteminfo/index', array('group' => $group));
	}


	//徹底刪除
	public function del() {

		$id = I('id',0 , 'intval');
		$batchFlag = intval($_GET['batchFlag']);
		//批量刪除
		if ($batchFlag) {
			$this->delBatch();
			return;
		}
		
		$group = I('group', '', 'trim');
		if (M('iteminfo')->delete($id)) {
			$this->success('徹底刪除成功', U(GROUP_NAME. '/Iteminfo/index' , array('group' => $group)));
		}else {
			$this->error('徹底刪除失敗');
		}
	}


	//批量徹底刪除
	public function delBatch() {

		$idArr = I('key',0 , 'intval');	
		$group = $_GET['group'];
		if (!is_array($idArr)) {
			$this->error('請選擇要徹底刪除的項');
		}
		$where = array('id' => array('in', $idArr));

		if (M('iteminfo')->where($where)->delete()) {
			$this->success('徹底刪除成功', U(GROUP_NAME. '/Iteminfo/index', array('group' => $group)));
		}else {
			$this->error('徹底刪除失敗');
		}
	}




}



?>