<?php

class LoginAction extends Action{
	
	public function index(){

		$this->display();
	}


	//登錄驗證
	public function login(){

		if (!IS_POST)  halt('頁面不存在');

		$username = I('username','','trim');
		$password = I('password','');
		$verify = I('code','','md5');
	
		if ($_SESSION['verify'] != $verify) {
			$this->error('驗證碼不正確');
		}


		if ($username == '' || $password == '') {
			$this->error('賬號或密碼不能為空');
		}

		$user = M('admin')->where(array('username' => $username))->find();

		if (!$user || ($user['password'] != get_password($password, $user['encrypt']))) {
			$this->error('賬號或密碼錯誤');
		}

		if ($user['islock']) {
			$this->error('用戶被鎖定！');
		}
		//更新數據庫的參數
		$data = array('id' => $user['id'] ,//保存時會自動為此ID的更新
				'logintime' => time(),
				'loginip' => get_client_ip()
		);
		//更新數據庫
		M('admin')->save($data);
		$user['roleid'] = M('roleUser')->where(array('user_id' => $user['id']))->getField('role_id');
		$user['roleid'] = empty($user['roleid']) ? 0 : $user['roleid'];

		//保存Session
		session(C('USER_AUTH_KEY'), $user['id']);
		session('yang_adm_username', $user['username']);
		session('yang_adm_roleid', intval($user['roleid']));
		session('yang_adm_logintime', date('Y-m-d H:i:s', $user['logintime']));
		session('yang_adm_loginip', $user['loginip']);

		//超級管理員
		if (9 == $user['usertype']) {
			session(C('ADMIN_AUTH_KEY'),true);
		}

		import('ORG.Util.RBAC');
		RBAC::saveAccessList();//靜態方法，讀取權限放到session


		//跳轉
		$this->redirect(GROUP_NAME.'/Index/index');
		


	}


	//退出
	public function logout() {

		session_unset();
		session_destroy();
		$this->redirect(GROUP_NAME.'/Login/index');
	}



	//登錄驗證碼
	public function verify(){

		//導入ThinkPHP擴展類庫
		//文件位置：./ThinkPHP/Extend/Library/ORG/Util/Image.class.php
		import('ORG.Util.Image');//導入驗證碼Image類庫
		return Image::buildImageVerify(4, 1);//直接調用類靜態方法
	}

	//js 用戶名
	public function checkusername() {
		$username = I('username','','trim');
		$id = I('id', 0,'intval');
		if (empty($username)) {
			exit(0);
		}
		$user = M('admin')->where(array('username' => $username, 'id' => array('neq' , $id)))->find();
		if ($user) {
			echo 1;
		}else {
			echo 0;
		}
	}
	//js email
	public function checkemail() {
		$email = I('email','','trim');
		$id = I('id', 0,'intval');

		if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
			exit(-1);
		}

		$user = M('admin')->where(array('email' => $email, 'id' => array('neq' , $id)))->find();
		if ($user) {
			echo 1;
		}else {
			echo 0;
		}
	}
	//js密碼
	public function checkpassword() {
		$username = I('username','','trim');		
		$password = I('password','');
		if (empty($username) || $password == '') {
			exit(0);
		}
		$user = M('admin')->where(array('username' => $username))->find();
		if ($user && $user['password'] == get_password($password, $user['encrypt'])) {
			echo 1;
		}else {
			echo 0;
		}
	}

	//js驗證碼
	public function checkcode() {
		$verify = I('code','','md5');
	
		if ($_SESSION['verify'] == $verify) {
			echo 1;
		}else {
			echo 0;
		}
	}



	//RBAC

	//js 角色名
	public function checkRoleName() {
		$name = I('name','','trim');
		$id = I('id', 0,'intval');
		if (empty($name)) {
			exit(0);
		}
		$data = M('role')->where(array('name' => $name, 'id' => array('neq' , $id)))->find();
		if ($data) {
			echo 1;
		}else {
			echo 0;
		}
	}

	//js 節點名//debug
	public function checkNodeName() {
		$name = I('name','','trim');
		$id = I('id', 0,'intval');
		if (empty($name)) {
			exit(0);
		}
		$data = M('node')->where(array('name' => $name, 'id' => array('neq' , $id)))->find();
		if ($data) {
			echo 1;
		}else {
			echo 0;
		}
	}
}


?>