<?php

class MemberAction extends CommonAction {
	
	public function index() {
		
		$keyword = I('keyword', '', 'htmlspecialchars,trim');//關鍵字	
		$where = array('member.id' => array('gt', 0));
		if (!empty($keyword)) {
			if (strpos($keyword, '@')) {
				$where['member.email'] = $keyword;
			}else {
				$where['member.nickname'] = $keyword;
			}
		}
		//分頁
		import('Class.Page', APP_PATH);
		$count = D('MemberView')->where($where)->count();

		$page = new Page($count, 10);
		$page->rollPage = 7;
		$page->setConfig('theme','%totalRow% %header%  %first% %upPage% %linkPage% %downPage% %end% %nowPage%/%totalPage% 頁');
		$limit = $page->firstRow. ',' .$page->listRows;
		$list = D('MemberView')->nofield('password,encrypt')->where($where)->order('member.id desc')->limit($limit)->select();

		$this->page = $page->show();
		$this->vlist = $list;
		$this->type = '會員列表';
		$this->keyword = $keyword;

		$this->display();
	}
	//添加
	public function add() {
		//當前控制器名稱		
		$actionName = strtolower($this->getActionName());
		if (IS_POST) {
			$this->addPost();
			exit();
		}
		$this->vlist = M('membergroup')->where(array('id'=> array('gt',1)))->select();
		$this->display();
	}

	//
	public function addPost() {
		$password = I('password', '');
		//M驗證
		$validate = array(
			array('email','email','郵箱格式不正確'), // 內置正則驗證郵箱
			array('groupid','require','請選擇會員組！'), 
			array('password','require','密碼必須填寫！'), 
			array('email','','郵箱已經存在！',0,'unique',1), //使用這個是否存在，auto就不能自動完成
		);


		$db = M('member');
		if (!$db->validate($validate)->create()) {
			$this->error($db->getError());
		}


		$data = I('post.');
		$passwordinfo = I('password', '','get_password');
		$data['regtime'] = time();
		$data['password'] = $passwordinfo['password'];
		$data['encrypt'] = $passwordinfo['encrypt'];


		if($id = $db->add($data)) {
			$this->success('添加成功',U(GROUP_NAME. '/Member/index'));
		}else {
			$this->error('添加失敗');
		}
	}

	//編輯
	public function edit() {
		//當前控制器名稱
		$id = I('id', 0, 'intval');
		$actionName = strtolower($this->getActionName());

		if (IS_POST) {
			$this->editPost();
			exit();
		}
		
		$this->vlist = M('membergroup')->where(array('id'=> array('gt',1)))->select();
		$this->vo = M($actionName)->find($id);
		$this->display();
	}


	//修改文章處理
	public function editPost() {

		$data = I('post.');
		$id = $data['id'] = I('id', 0, 'intval');
		$data['email'] = trim($data['email']);

		if (empty($data['email'])) {
			$this->error('電子郵箱必須填寫！');
		}
		if (!filter_var($data['email'], FILTER_VALIDATE_EMAIL)) {
				$this->error('電子郵箱格式不正確！');
		}
		
		if (M('member')->where(array('email' => $data['email'], 'id' => array('neq', $id)))->find()) {
			$this->error('失敗，郵箱已經存在！');
		}

		$data['groupid'] = I('groupid', 0, 'intval');
		$data['islock'] = I('islock', 0, 'intval');
		
		if(!empty($data['password'])) {
			$passwordinfo = I('password', '','get_password');
			$data['password'] = $passwordinfo['password'];
			$data['encrypt'] = $passwordinfo['encrypt'];
		}else {
			unset($data['password']);//刪除密碼，防止被添加
		}
	

		if (false !== M('member')->save($data)) {
			$this->success('修改成功', U(GROUP_NAME. '/Member/index'));
		}else {

			$this->error('修改失敗');
		}
		
	}



	//用戶資料
	public function person() {
		//當前控制器名稱
		$id = I('id', 0, 'intval');
		$actionName = strtolower($this->getActionName());
		if (empty($id)) {
			$this->error('參數錯誤');
		}

		if (IS_POST) {
			$data['realname'] = I('realname', '', 'htmlspecialchars,trim');
			$data['birthday'] = I('birthday', '0000-00-00');
			$data['sex'] = I('sex', 0, 'intval');			
			$data['address'] = I('address', '');
			$data['tel'] = I('tel', '');
			$data['mobile'] = I('mobile', '');
			$data['qq'] = I('qq', '');
			$data['maxim'] = I('maxim', '');

			$data['userid'] = $id;
			$data['updatetime'] = time();
			$new = I('new', 0,'intval');
			if (empty($data['realname'])) {
				$this->error('請輸入姓名！');
			}
			
			$result = true;
			if ($new) {
				$result = M('memberdetail')->add($data);
			}else {
				$result = M('memberdetail')->save($data);
			}
			
			if (false !== $result) {
				$this->success('修改用戶資料成功', U(GROUP_NAME. '/Member/index'));
			}else {

				$this->error('修改用戶資料失敗');
			}
			exit();
		}
		
		$userdetail = M('memberdetail')->where(array('userid' => $id))->find();
		if (!$userdetail) {
			$userdetail = array(
				'userid' => $id,
				'realname' => '',
				'sex' => 0,
				'birthday' => '1990-1-1',
				'address'	=> '',
				'tel'	=> '',
				'mobile'	=> '',
				'qq'	=> '',
				'maxim' => '',
			);
			$userdetail['new'] = 1;
		}else {
			$userdetail['new'] = 0;		
		}
		$this->vo = $userdetail;	
		$this->type = '用戶基本資料';	
		$this->display();
	}



	//徹底刪除
	public function del() {

		$id = I('id',0 , 'intval');
		$batchFlag = I('get.batchFlag', 0, 'intval');
		//批量刪除
		if ($batchFlag) {
			$this->delBatch();
			return;
		}
		
		if (M('member')->delete($id)) {			
			M('memberdetail')->delete($id);
			$this->success('徹底刪除成功', U(GROUP_NAME. '/Member/index'));
		}else {
			$this->error('徹底刪除失敗');
		}
	}


	//批量徹底刪除
	public function delBatch() {

		$idArr = I('key',0 , 'intval');		
		if (!is_array($idArr)) {
			$this->error('請選擇要徹底刪除的項');
		}
		$where = array('id' => array('in', $idArr));

		if (M('member')->where($where)->delete()) {			
			M('memberdetail')->where(array('userid' => array('in', $idArr)))->delete();
			$this->success('徹底刪除成功', U(GROUP_NAME. '/Member/index'));
		}else {
			$this->error('徹底刪除失敗');
		}
	}




}



?>