<?php

class RbacAction extends CommonAction {
	

	public function index() {

		$keyword = I('keyword','','trim');
		$where = '';
		//$this->user = M('admin')->select();
		
		if (empty($keyword)) {
			$where = array('id' => array('GT', '0'));
		}else {
			$where = array('username'=>array('like', "%$keyword%"));
		}


		//當成一對一來處理 
		$count = M('admin')->field('password', true)->where($where)->count();
		import('Class.Page', APP_PATH);
		$page = new Page($count, 10);
		$page->rollPage = 7;
		$page->setConfig('theme','%totalRow% %header%  %first% %upPage% %linkPage% %downPage% %end% %nowPage%/%totalPage% 頁');
		$limit = $page->firstRow. ',' .$page->listRows;
		$user = M('admin')->field('password', true)->where($where)->limit($limit)->select() ;	//view
		if ($user) {
			foreach ($user as $k => $v) {
				$user[$k]['role'] = D('RoleView')->where(array('user_id' => $v['id']))->select();
			}
		}
		
		/*
		//使用關聯模型(多對多),讀取除password 字段外 所有字段
		//$this->user = D('UserRelation')->field('password', true)->relation(true)->select() ;	//relation顯示關係表
		//總數
		$count = D('UserRelation')->field('password', true)->relation(true)->where($where)->count();

		import('Class.Page', APP_PATH);
		$page = new Page($count, 10);
		$page->rollPage = 7;
		$page->setConfig('theme','%totalRow% %header%  %first% %upPage% %linkPage% %downPage% %end% %nowPage%/%totalPage% 頁');
		$limit = $page->firstRow. ',' .$page->listRows;
		$this->user = D('UserRelation')->field('password', true)->relation(true)->where($where)->limit($limit)->select() ;	//relation顯示關係表
		
		*/
		$this->user = $user;
		$this->page = $page->show();
		$this->keyword = $keyword;
		$this->display();

	}

	//添加/編輯用戶
	public function addUser() {

		if (IS_POST) {
			$this->addUserPost();
			exit();
		}

		$uid = I('uid' ,0, 'intval');

		$user = M('admin')->find($uid);
		if ($user) {
			$user['password'] = '';
		}
		$userRote = M('role_user')->where(array('user_id' => $uid))->getField('role_id',true);
		if (!is_array($userRote)) {
			$userRote = array(0);
		}

		$this->uid = $uid;
		$this->user = $user;
		$this->userRote = $userRote;
		$this->role =M('role')->select();
		$this->display();
	}

	//添加用戶處理
	public function addUserPost() {

		//M驗證
		$validate = array(
			array('username','require','用戶名必須填寫！'), 
			array('username','','用戶名已經存在！',0,'unique',1), 
		);
		$data = M('admin');
		if (!$data->validate($validate)->create()) {
			$this->error($data->getError());
		}

		$passwordinfo = I('password','','get_password');
		$userData = array(
			'username' => I('username','','trim'),
			'password' => $passwordinfo['password'],
			'encrypt' => $passwordinfo['encrypt'],
			'logintime' => time(),
			'loginip' => get_client_ip(),
			'islock' => I('islock',0,'intval')
		);

		if ($uid = M('admin')->add($userData)) {
			
			$role = array();
			foreach ($_POST['role_id'] as $v) {
				$role[] = array(
					'user_id' => $uid,
					'role_id' => $v
				);
			}

			M('role_user')->addAll($role);
			$this->success('添加成功', U(GROUP_NAME. '/Rbac/index'));
		}else {

			$this->error('添加失敗');
		}

	}

	//修改用戶處理
	public function editUser() {

		if (!IS_POST) {
			$this->error('參數錯誤!');
		}
		//M驗證		
		$password = trim($_POST['password']);
		$username = I('username', '', 'trim');
		$uid = I('uid',0, 'intval');
		if (empty($username)) {
			$this->error('用戶名必須填寫！');
		}

		if (M('admin')->where(array('username' => $username, 'id' => array('neq' , $uid)))->find()) {
			$this->error('用戶名已經存在！');
		}


		$data = array(
			'id' => $uid,
			'username' => $username,
			'realname' => I('realname', '', 'trim'),
			'logintime' => time(),
			'islock' => I('islock',0,'intval')
		);

		//如果密碼不為空，即是修改
		if (!$password == '') {
			$passwordinfo = I('password','','get_password');
			$data['password'] = $passwordinfo['password'];
			$data['encrypt'] = $passwordinfo['encrypt'];
		}
		


		if (false !== M('admin')->save($data)) {
			
			$role = array();
			foreach ($_POST['role_id'] as $v) {
				$role[] = array(
					'user_id' => $uid,
					'role_id' => $v
				);
			}
			M('role_user')->where(array('user_id' => $uid))->delete();
			M('role_user')->addAll($role);
			$this->success('修改成功', U(GROUP_NAME. '/Rbac/index'));
		}else {

			$this->error('修改失敗');
		}

	}

	//刪除用戶處理
	public function delUser() {

		$uid = I('uid',0, 'intval');
		$batchFlag = intval($_GET['batchFlag']);
		//批量刪除
		if ($batchFlag) {
			$this->delUserAll();
			return;
		}
		
		if (M('admin')->delete($uid)) {
			
			M('role_user')->where(array('user_id' => $uid))->delete();
			$this->success('刪除成功', U(GROUP_NAME. '/Rbac/index'));
		}else {

			$this->error('刪除失敗');
		}
		

	}

	//指量刪除用戶處理
	public function delUserAll() {

		$idArr = I('key');
		if (isset($idArr) && !is_array($idArr)) {
			$this->error('請選擇要刪除的列');
		}

		/*

		$errFlag = false;
		$errStr = '';
		foreach ($idArr as $v) {
			if (M('admin')->delete($v)) {			
				M('role_user')->where(array('user_id' => $v))->delete();
			}else {
				$errorflag = ture;
				$errStr .= '刪除失敗ID: '. $v. '<br/>';
			}
		}


		if ($errFlag == ture) {			
			$this->error($errStr);
		}else {
			$this->success('刪除成功', U(GROUP_NAME. '/Rbac/index'));
		}	
		*/

		if (M('admin')->where(array('id' => array('in', $idArr)) )->delete()) {			
			M('role_user')->where(array('user_id' => array('in', $idArr)) )->delete();
			$this->success('刪除成功', U(GROUP_NAME. '/Rbac/index'));
		}else {
			$this->error('刪除成功');
		}	
		
		

	}

	//角色列表
	public function role() {

		$keyword = I('keyword','','trim');
		$where = '';


		if (empty($keyword)) {
			$where = array('id' => array('GT', '0'));
		}else {
			$where = array('name'=>array('like', "%$keyword%"));
		}

		//總數
		$count = M('role')->where($where)->count();

		import('Class.Page', APP_PATH);
		$page = new Page($count, 10);
		$page->rollPage = 7;
		$page->setConfig('theme','%totalRow% %header%  %first% %upPage% %linkPage% %downPage% %end% %nowPage%/%totalPage% 頁');
		$limit = $page->firstRow. ',' .$page->listRows;
		$this->role = M('role')->where($where)->limit($limit)->select() ;	//relation顯示關係表		
		$this->page = $page->show();



		$this->keyword = $keyword;
		$this->display();
	}

	//添加角色
	public function addRole() {
		if (IS_POST) {
			$this->addRolePost();
			exit();
		}
		$id = I('id', 0, 'intval');
		if (!$id) {
			$this->type = '添加';
		}else {
			$this->type = '編輯';
		}

		$this->role = M('role')->find($id);
		$this->id =$id;
		$this->display();
	}

	//添加角色處理
	public function addRolePost() {

		//M驗證
		$validate = array(
			array('name','require','用戶組名必須填寫！'), 
			array('name','','用戶組名已經存在！',0,'unique',1), 
		);
		$data = M('role');
		if (!$data->validate($validate)->create()) {
			$this->error($data->getError());
		}

		if (M('role')->add($_POST)) {
			$this->success('添加用戶組成功', U(GROUP_NAME. '/Rbac/role'));
		}else {
			$this->error('添加用戶組失敗');
		}
	}


	//修改角色處理
	public function editRole() {

		if (!IS_POST) {
			$this->error('參數錯誤');
			exit();
		}

		$data = I('post.');
		$id = $data['id'] = I('id',0, 'intval');
		$name = $data['name'] = trim($data['name']);
		if (empty($name)) {
			$this->error('用戶組名必須填寫！');
		}

		if (M('role')->where(array('name' => $name, 'id' => array('neq' , $id)))->find()) {
			$this->error('用戶組已經存在！');
		}


		if (false !== M('role')->save($data)) {
			$this->success('修改用戶組成功', U(GROUP_NAME. '/Rbac/role'));
		}else {
			$this->error('修改用戶組失敗');
		}
	}

	//刪除角色
	public function delRole() {
		$id = I('id',0 , 'intval');
		$batchFlag = I('get.batchFlag', 0, 'intval');// intval($_GET['batchFlag']);
		//批量刪除
		if ($batchFlag) {
			$this->delRoleAll();
			return;
		}
		
		if (M('role')->delete($id)) {
		
			$where = array('role_id' => $id);
			//角色用戶中間表		
			M('role_user')->where($where)->delete();
			//權限
			M('access')->where($where)->delete();
			$this->success('刪除用戶組成功', U(GROUP_NAME. '/Rbac/role'));
		}else {
			$this->error('刪除用戶組失敗');
		}
	}



	//指量刪除用戶處理
	public function delRoleAll() {

		$idArr = I('key');
		if (isset($idArr) && !is_array($idArr)) {
			$this->error('請選擇要刪除的列');
		}

		if (M('role')->where(array('id' => array('in', $idArr)) )->delete()) {	
			$where = array('role_id' => array('in', $idArr));
			//角色用戶中間表		
			M('role_user')->where($where)->delete();
			//權限
			M('access')->where($where)->delete();
			$this->success('刪除用戶組成功', U(GROUP_NAME. '/Rbac/role'));
		}else {
			$this->error('刪除用戶組失敗');
		}	
		
		

	}




	//配置權限
	public function access() {
		if (IS_POST) {
			$this->accessPost();
			exit();
		}
		$rid = I('rid', 0, 'intval');
		$access = M('access')->where(array('role_id' => $rid))->getField('node_id' ,true);
		$where = array('status' => 1);
		$node = M('node')->where($where)->order('sort')->select();
		$this->node = nodeForLayer($node, $access);

		$this->rid =$rid;
		$this->display();
	}

	//配置權限處理
	public function accessPost() {
		$rid =I('rid',0 , 'intval');
		$access =array();
		//組合權限
		foreach ($_POST['access'] as $v) {
			$tmp = explode('_', $v);
			$access[]= array('role_id' => $rid, 'node_id' => $tmp[0], 'level' => $tmp[1]);
		}
		//p($access);
		//清空原權限
		M('access')->where(array('role_id'=>$rid))->delete();
		//插入新權限
		if (M('access')->addAll($access)) {
			$this->success('配置成功', U(GROUP_NAME. '/Rbac/role'));
		}else {
			$this->error('配置失敗');
		}

	}



	//節點列表
	public function node() {

		$node = M('node')->order('sort')->select();
		$node = nodeForLayer($node);

		$this->node = $node;
		$this->display();

	}

	//添加節點
	public function addNode() {

		if (IS_POST) {
			$this->addNodePost();
			exit();
		}

		$this->level = I('level', 1, 'intval');
		$this->pid = I('pid', 0, 'intval');

		$type = '';
		switch ($this->level) {
			case 1:
				$type='應用';
				break;
			case 2:
				$type='控制器';
				break;
			case 3:
				$type='方法';
				break;
		}

		$this->type = $type;
		$this->display();
	}


	//添加節點處理
	public function addNodePost() {

		$data = I('post.', '');
		$data['name'] = trim($data['name']);
		$data['title'] = trim($data['title']);
		$data['sort'] = I('sort', 0, 'intval');		
		$data['status'] = I('status', 0, 'intval');
		if (empty($data['name']) || empty($data['title'])) {
			$this->error('名稱和描述不能為空');
		}

		if (M('node')->add($data)) {
			$this->success('添加成功', U(GROUP_NAME. '/Rbac/node'));
		}else {

			$this->error('添加失敗');
		}
	}

	//修改節點
	public function editNode() {
		
		if (IS_POST) {
			$this->editNodePost();
			exit();
		}

		$id = I('id', 0, 'intval');
		$node = M('node')->find($id);
		if (!$node) {
			$this->error('記錄不存在');
		}
		switch ($node['level']) {
			case 1:
				$this->type='應用';
				break;
			case 2:
				$this->type='控制器';
				break;
			case 3:
				$this->type='方法';
				break;
			
		}
		$this->id = $id;
		$this->node = $node;
		$this->display();
	}


	//修改節點處理
	public function editNodePost() {

		$data = I('post.', '');
		$data['name'] = trim($data['name']);
		$data['title'] = trim($data['title']);
		if (empty($data['name']) || empty($data['title'])) {
			$this->error('名稱和描述不能為空');
		}

		if (false !== M('node')->save($data)) {
			$this->success('修改成功', U(GROUP_NAME. '/Rbac/node'));
		}else {

			$this->error('修改失敗');
		}
		
	}

	//刪除節點
	public function delNode() {

		$id = I('id', 0, 'intval');

		$childNode = M('node')->where(array('pid'=>$id))->select();
		if ($childNode) {
			$this->error('刪除失敗，請先刪除下面的子節點');
		}

		if (M('node')->delete($id)) {		
			//權限
			M('access')->where(array('node_id' => $id))->delete();
			$this->success('刪除成功', U(GROUP_NAME. '/Rbac/node'));
		}else {

			$this->error('刪除失敗');
		}
	}


}

?>