<?php

class SpecialAction extends CommonAction {
	
	public function index() {

	
		$keyword = I('keyword', '', 'htmlspecialchars,trim');//關鍵字	

		$where = array('special.status' => 0);		

		
		if (!empty($keyword)) {
			$where['special.title'] = array('LIKE', "%{$keyword}%");
		}
		
		//分頁
		import('Class.Page', APP_PATH);
		$count = D('SpecialView')->where($where)->count();

		$page = new Page($count, 10);
		$page->rollPage = 7;
		$page->setConfig('theme','%totalRow% %header%  %first% %upPage% %linkPage% %downPage% %end% %nowPage%/%totalPage% 頁');
		$limit = $page->firstRow. ',' .$page->listRows;
		$art = D('SpecialView')->nofield('content')->where($where)->order('id DESC')->limit($limit)->select();

		
		$this->keyword = $keyword;
		$this->page = $page->show();
		$this->vlist = $art;
		$this->type = '專題列表';

		$this->display();
	}
	//添加
	public function add() {

		
		//當前控制器名稱		
		$actionName = strtolower($this->getActionName());
		$this->pid = I('pid', 0, 'intval');

		if (IS_POST) {
			$this->addPost();
			exit();
		}

		$cate = getCategory(2);
		import('Class.Category', APP_PATH);
		$this->cate = Category::toLevel($cate);
		$_styleShowList = getFileFolderList(APP_PATH . C('APP_GROUP_PATH') . '/Home/Tpl/' .C('cfg_themestyle') , 2, 'Special_*');

		$styleShowList = array();
		foreach ($_styleShowList as $v) {
			if (strpos($v, 'Special_index') === false) {
				$styleShowList[] = $v;
			}
		}
		$this->styleShowList = $styleShowList;
		$this->type = '添加專題';
		$this->flagtypelist = getArrayOfItem('flagtype');//文檔屬性
		$this->display();
	}

	//
	public function addPost() {


		$cid = I('cid', 0, 'intval');
		$title = I('title', '', 'htmlspecialchars,rtrim');		
		$flags = I('flags', array(),'intval');
		$jumpurl = I('jumpurl', '');
		$description = I('description', '');
		$template = I('template', '');

		$pic = I('litpic', '', 'htmlspecialchars,trim');
		if (empty($title)) {
			$this->error('專題名稱不能為空');
		}

		if (empty($template)) {
			$this->error('請選擇專題模板');
		}


		//圖片標誌
		if (!empty($pic) && !in_array(B_PIC, $flags)) {
			$flags[] = B_PIC;
		}
		$flag = 0;
		foreach ($flags as $v) {
			$flag += $v;
		}
	
	

		//獲取屬於分類信息,得到modelid
		//import('Class.Category', APP_PATH);			
		//$selfCate = Category::getSelf(getCategory(0), $cid);//當前欄目信息
		//$modelid = $selfCate['modelid'];

		$data =array(
			'title' => $title ,
			'shorttitle' => I('shorttitle', ''),
			'color' => I('color'),
			'cid'	=> $cid,
			'author'	=> '',
			'keywords' => I('keywords','','htmlspecialchars,trim'),
			'litpic'	=> $pic,
			'description' => $description,
			//'content' => '',
			'publishtime' => I('publishtime', time(),'strtotime'),
			'updatetime' => time(),
			'click' => rand(10,95),
			'commentflag' => I('commentflag', 0,'intval'),	
			'status' => 0,		
			'filename' => I('filename', ''),			
			'template' => $template,
			'flag'	=> $flag,
			'jumpurl' => $jumpurl,
			'aid'	=> $_SESSION[C('USER_AUTH_KEY')]

		);
		
		if($id = M('special')->add($data)) {

			//更新上傳附件表
			if (!empty($pic)) {

				$pic = preg_replace('/!(\d+)X(\d+)\.jpg$/i', '', $pic);//清除縮略圖的!200X200.jpg後綴
				$attid = M('attachment')->where(array('filepath' => $pic))->getField('id');
				if($attid){
					M('attachmentindex')->add(array('attid' => $attid,'arcid' => $id, 'modelid' => 0, 'desc' => 'special'));
				}
			}	

			//更新靜態緩存
			delCacheHtml('Special/index', false, 'special:index');	
			delCacheHtml('Index_index', false, 'index:index');		


			$this->success('添加成功',U(GROUP_NAME. '/Special/index'));
		}else {
			$this->error('添加失敗');
		}
	}

	//編輯
	public function edit() {
		//當前控制器名稱
		$id = I('id', 0, 'intval');
		$actionName = strtolower($this->getActionName());
		$this->pid = I('pid', 0, 'intval');

		if (IS_POST) {
			$this->editPost();
			exit();
		}


		$cate = getCategory(2);
		import('Class.Category', APP_PATH);
		$this->cate = Category::toLevel($cate);
		$_styleShowList = getFileFolderList(APP_PATH . C('APP_GROUP_PATH') . '/Home/Tpl/' .C('cfg_themestyle') , 2, 'Special_*');
		$styleShowList = array();		
		foreach ($_styleShowList as $v) {
			if (strpos($v, 'Special_index') === false) {
				$styleShowList[] = $v;
			}
		}
		$this->type = '修改專題';

		$this->styleShowList = $styleShowList;
		$vo = M($actionName)->find($id);
		$vo['content'] = htmlspecialchars($vo['content']);//ueditor
		$this->vo = $vo;
		$this->flagtypelist = getArrayOfItem('flagtype');//文檔屬性
		$this->display();
	}


	//修改處理
	public function editPost() {


		$data =array(
			'id' => I('id', 0, 'intval'),
			'title' => I('title', '', 'htmlspecialchars,rtrim'),
			'shorttitle' => I('shorttitle', ''),
			'color' => I('color'),
			'cid'	=> I('cid', 0, 'intval'),
			'author'	=> '',
			'keywords' => I('keywords','','htmlspecialchars,trim'),
			'litpic'	=> I('litpic',''),
			'description' => I('description',''),
			//'content' => '',
			'publishtime' => I('publishtime', time(),'strtotime'),
			'updatetime' => time(),
			'commentflag' => I('commentflag', 0,'intval'),			
			'filename' => I('filename', ''),			
			'template' => I('template', ''),
			'jumpurl' => I('jumpurl', ''),
		);
		$id = $data['id'] = intval($data['id']);
		$flags = I('flags', array(),'intval');
		$pic = $data['litpic'];

		if (empty($data['title'])) {
			$this->error('專題名稱不能為空');
		}
		
		if (empty($data['template'])) {
			$this->error('請選擇專題模板');
		}


		//圖片標誌
		if (!empty($pic) && !in_array(B_PIC, $flags)) {
			$flags[] = B_PIC;
		}
		$data['flag'] = 0;
		foreach ($flags as $v) {
			$data['flag'] += $v;
		}


		//獲取屬於分類信息,得到modelid
		//import('Class.Category', APP_PATH);			
		//$selfCate = Category::getSelf(getCategory(0), $data['cid']);//當前欄目信息
		//$modelid = $selfCate['modelid'];

	
		if (false !== M('special')->save($data)) {
			//del
			M('attachmentindex')->where(array('arcid' => $id, 'modelid' => 0, 'desc' => 'special'))->delete();
			
			//更新上傳附件表
			if (!empty($pic)) {

				$pic = preg_replace('/!(\d+)X(\d+)\.jpg$/i', '', $pic);//清除縮略圖的!200X200.jpg後綴
				$attid = M('attachment')->where(array('filepath' => $pic))->getField('id');
				if($attid){
					M('attachmentindex')->add(array('attid' => $attid,'arcid' => $id, 'modelid' => 0, 'desc' => 'special'));
				}
				//halt(M('attachment')->getlastsql());
			}

			//更新靜態緩存
			delCacheHtml('Special/index', false, 'special:index');
			delCacheHtml('Special/shows_'.$id, false, 'special:shows');


			$this->success('修改成功', U(GROUP_NAME. '/Special/index'));
		}else {

			$this->error('修改失敗');
		}
		
	}


	//回收站列表
	public function trach() {
		import('Class.Page', APP_PATH);
		$where = array('special.status' => 1);
		$count = D('SpecialView')->where($where)->count();

		$page = new Page($count, 10);
		$page->rollPage = 7;
		$page->setConfig('theme','%totalRow% %header%  %first% %upPage% %linkPage% %downPage% %end% %nowPage%/%totalPage% 頁');
		$limit = $page->firstRow. ',' .$page->listRows;
		$art = D('SpecialView')->nofield('content')->where($where)->limit($limit)->select();

		$this->pid = I('pid', 0, 'intval');
		$this->page = $page->show();
		$this->vlist = $art;		
		$this->type = '回收站';
		$this->subcate = '';
		$this->display('index');
	}

	//刪除到回收站
	public function del() {

		$id = I('id',0 , 'intval');
		$batchFlag = I('get.batchFlag', 0, 'intval');
		//批量刪除
		if ($batchFlag) {
			$this->delBatch();
			return;
		}


		if (false !== M('special')->where(array('id' => $id))->setField('status', 1)) {
			
			//更新靜態緩存
			delCacheHtml('Special/index', false, 'special:index');
			delCacheHtml('Special/shows_'.$id, false, 'special:shows');

			$this->success('刪除成功', U(GROUP_NAME. '/Special/index'));
			
		}else {
			$this->error('刪除失敗');
		}
	}

	//批量刪除到回收站
	public function delBatch() {

		$idArr = I('key',0 , 'intval');

		if (!is_array($idArr)) {
			$this->error('請選擇要刪除的項');
		}

		if (false !== M('special')->where(array('id' => array('in', $idArr)))->setField('status', 1)) {
			
			//getlastsql();
			//更新靜態緩存
			delCacheHtml('Special/index', false, 'special:index');
			foreach ($idArr as $v) {
				delCacheHtml('Special/shows_'.$v, false, 'special:shows');
			}

			
			$this->success('批量刪除成功', U(GROUP_NAME. '/Special/index'));
			
		}else {
			$this->error('批量刪除文失敗');
		}
	}

	//還原
	public function restore() {
		
		$id = I('id',0 , 'intval');
		$batchFlag = I('get.batchFlag', 0, 'intval');
		//批量刪除
		if ($batchFlag) {
			$this->restoreBatch();
			return;
		}

		if (false !== M('special')->where(array('id' => $id))->setField('status', 0)) {
			
			$this->success('還原成功', U(GROUP_NAME. '/Special/trach'));
			
		}else {
			$this->error('還原失敗');
		}
	}

	//批量還原
	public function restoreBatch() {
		
		$idArr = I('key',0 , 'intval');
		if (!is_array($idArr)) {
			$this->error('請選擇要還原的項');
		}

		if (false !== M('special')->where(array('id' => array('in', $idArr)))->setField('status', 0)) {
			
			$this->success('還原成功', U(GROUP_NAME. '/Special/trach'));
			
		}else {
			$this->error('還原失敗');
		}
	}

	//徹底刪除
	public function clear() {

		$id = I('id',0 , 'intval');
		$batchFlag = I('get.batchFlag', 0, 'intval');
		//批量刪除
		if ($batchFlag) {
			$this->clearBatch();
			return;
		}

		if (M('special')->delete($id)) {
			// delete picture index
			
			M('attachmentindex')->where(array('arcid' => $id, 'modelid' => 0, 'desc' => 'special'))->delete();
			
			$this->success('徹底刪除成功', U(GROUP_NAME. '/Special/trach'));
		}else {
			$this->error('徹底刪除失敗');
		}
	}


	//批量徹底刪除
	public function clearBatch() {

		$idArr = I('key',0 , 'intval');		
		if (!is_array($idArr)) {
			$this->error('請選擇要徹底刪除的項');
		}
		$where = array('id' => array('in', $idArr));
		if (M('special')->where($where)->delete()) {
			// delete picture index
			M('attachmentindex')->where(array('arcid' => array('in', $idArr), 'modelid' => 0, 'desc' => 'special'))->delete();
			$this->success('徹底刪除成功', U(GROUP_NAME. '/Special/trach'));
		}else {
			$this->error('徹底刪除失敗');
		}
	}

	
}



?>